/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.result;

import javax.servlet.http.Cookie;
import org.hamcrest.Matcher;
import org.springframework.test.util.AssertionErrors;
import org.springframework.test.util.MatcherAssertionErrors;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.ResultMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CookieResultMatchers {
    protected CookieResultMatchers() {
    }

    public ResultMatcher value(final String name, final Matcher<? super String> matcher) {
        return new ResultMatcher(){

            public void match(MvcResult result) {
                Cookie cookie = result.getResponse().getCookie(name);
                AssertionErrors.assertTrue("Response cookie not found: " + name, cookie != null);
                MatcherAssertionErrors.assertThat("Response cookie", cookie.getValue(), matcher);
            }
        };
    }

    public ResultMatcher value(final String name, final String expectedValue) {
        return new ResultMatcher(){

            public void match(MvcResult result) {
                Cookie cookie = result.getResponse().getCookie(name);
                AssertionErrors.assertTrue("Response cookie not found: " + name, cookie != null);
                AssertionErrors.assertEquals("Response cookie", expectedValue, cookie.getValue());
            }
        };
    }

    public ResultMatcher exists(final String name) {
        return new ResultMatcher(){

            public void match(MvcResult result) {
                Cookie cookie = result.getResponse().getCookie(name);
                AssertionErrors.assertTrue("No cookie with name: " + name, cookie != null);
            }
        };
    }

    public ResultMatcher doesNotExist(final String name) {
        return new ResultMatcher(){

            public void match(MvcResult result) {
                Cookie cookie = result.getResponse().getCookie(name);
                AssertionErrors.assertTrue("Unexpected cookie with name " + name, cookie == null);
            }
        };
    }

    public ResultMatcher maxAge(final String name, final Matcher<? super Integer> matcher) {
        return new ResultMatcher(){

            public void match(MvcResult result) {
                Cookie cookie = result.getResponse().getCookie(name);
                AssertionErrors.assertTrue("No cookie with name: " + name, cookie != null);
                MatcherAssertionErrors.assertThat("Response cookie maxAge", cookie.getMaxAge(), matcher);
            }
        };
    }

    public ResultMatcher maxAge(final String name, final int maxAge) {
        return new ResultMatcher(){

            public void match(MvcResult result) {
                Cookie cookie = result.getResponse().getCookie(name);
                AssertionErrors.assertTrue("No cookie with name: " + name, cookie != null);
                AssertionErrors.assertEquals("Response cookie maxAge", maxAge, cookie.getMaxAge());
            }
        };
    }

    public ResultMatcher path(final String name, final Matcher<? super String> matcher) {
        return new ResultMatcher(){

            public void match(MvcResult result) throws Exception {
                Cookie cookie = result.getResponse().getCookie(name);
                MatcherAssertionErrors.assertThat("Response cookie path", cookie.getPath(), matcher);
            }
        };
    }

    public ResultMatcher path(final String name, final String path) {
        return new ResultMatcher(){

            public void match(MvcResult result) throws Exception {
                Cookie cookie = result.getResponse().getCookie(name);
                AssertionErrors.assertEquals("Response cookie path", path, cookie.getPath());
            }
        };
    }

    public ResultMatcher domain(final String name, final Matcher<? super String> matcher) {
        return new ResultMatcher(){

            public void match(MvcResult result) throws Exception {
                Cookie cookie = result.getResponse().getCookie(name);
                MatcherAssertionErrors.assertThat("Response cookie domain", cookie.getDomain(), matcher);
            }
        };
    }

    public ResultMatcher domain(final String name, final String domain) {
        return new ResultMatcher(){

            public void match(MvcResult result) throws Exception {
                Cookie cookie = result.getResponse().getCookie(name);
                AssertionErrors.assertEquals("Response cookie domain", domain, cookie.getDomain());
            }
        };
    }

    public ResultMatcher comment(final String name, final Matcher<? super String> matcher) {
        return new ResultMatcher(){

            public void match(MvcResult result) throws Exception {
                Cookie cookie = result.getResponse().getCookie(name);
                MatcherAssertionErrors.assertThat("Response cookie comment", cookie.getComment(), matcher);
            }
        };
    }

    public ResultMatcher comment(final String name, final String comment) {
        return new ResultMatcher(){

            public void match(MvcResult result) throws Exception {
                Cookie cookie = result.getResponse().getCookie(name);
                AssertionErrors.assertEquals("Response cookie comment", comment, cookie.getComment());
            }
        };
    }

    public ResultMatcher version(final String name, final Matcher<? super Integer> matcher) {
        return new ResultMatcher(){

            public void match(MvcResult result) throws Exception {
                Cookie cookie = result.getResponse().getCookie(name);
                MatcherAssertionErrors.assertThat("Response cookie version", cookie.getVersion(), matcher);
            }
        };
    }

    public ResultMatcher version(final String name, final int version) {
        return new ResultMatcher(){

            public void match(MvcResult result) throws Exception {
                Cookie cookie = result.getResponse().getCookie(name);
                AssertionErrors.assertEquals("Response cookie version", version, cookie.getVersion());
            }
        };
    }

    public ResultMatcher secure(final String name, final boolean secure) {
        return new ResultMatcher(){

            public void match(MvcResult result) throws Exception {
                Cookie cookie = result.getResponse().getCookie(name);
                AssertionErrors.assertEquals("Response cookie secure", secure, cookie.getSecure());
            }
        };
    }
}

