/*
  guests.js
  Copyright 2015 Ubiquiti Networks, Inc. All rights reserved.
 */

/*
  payments.js
  Copyright 2015 Ubiquiti Networks, Inc. All rights reserved.
 */

/*
  vouchers.js
  Copyright 2015 Ubiquiti Networks, Inc. All rights reserved.
 */

/*
  FormView.js
  Copyright 2015 Ubiquiti Networks, Inc. All rights reserved.
 */

/*
  operators.js
  Copyright 2015 Ubiquiti Networks, Inc. All rights reserved.
 */

/*
  Copyright 2015 Ubiquiti Networks, Inc. All rights reserved.
 */

define("unifi/model/Guest",["unifi/model/Model","backbone","ubnt/backgrid"],function(e,t,n){"use strict";return e.extend({name:function(){return this.get("name")||this.get("hostname")||this.get("mac")},authorization:function(){var e,t,i,o;switch(this.get("authorized_by")){case"none":return"None";case"password":return"Password";case"api":return"API";case"voucher":return t=this.get("voucher_code"),e="Voucher",t&&(e+="["+t+"]"),e;case"credit":return i=this.get("package"),o=this.get("amount"),e=this.get("payment_cardtype")||"Credit Card",i&&o&&(e+="("+i+","+n.Formatters.Currency.fromRaw(this)+")"),e;case"paypal":return"PayPal";default:return"None"}},extend:function(e){return this.sync("extend",this,e)},sync:function(e,n,i){switch(e){case"delete":i.contentType="application/json; charset=utf-8",i.type="POST",i.url="/api/s/"+SITE.name+"/cmd/hotspot",i.data=JSON.stringify({_id:n.id,cmd:"terminate"});break;case"extend":i.contentType="application/json; charset=utf-8",i.type="POST",i.url="/api/s/"+SITE.name+"/cmd/hotspot",i.data=JSON.stringify({_id:n.id,cmd:"extend"})}return t.sync.call(this,e,n,i)},toSearch:function(){return{name:this.attributes.name,ap:this.attributes.ap_mac,"package":this.attributes["package"],amount:this.attributes.amount,authorization:this.authorization(),mac:this.attributes.mac,hostname:this.attributes.hostname}}})}),define("unifi/collection/Guests",["unifi/collection/Collection","backbone","unifi/model/Guest"],function(e,t,n){"use strict";return e.extend({model:n,bySite:!0,url:function(){return"/api/s/"+SITE.name+"/stat/guest"},sync:function(e,n,i){switch(e){case"read":i.type="POST",i.data=JSON.stringify(i.data)}return t.sync.call(this,e,n,i)}})}),define("text!includes/hotspot/guestsIndexTemplate.html",[],function(){return'<div class="section section-main">\n    <h1><%- msg.G_HotspotGuests %></h1>\n\n    <form class="data-filters clearfix">\n        <span class="ubnt-icon-search"></span>\n        <input type="text" name="search" class="search left" />\n\n        <div class="left">\n            <select name="time-filter" data-label="<%- msg.G_FilterShow %>" >\n                <option value="24"><%- msg.G_Last %> 24 <%- msg.G_Hours %></option>\n                <option value="72">3 <%- msg.G_Days %></option>\n                <option value="168">7 <%- msg.G_Days %></option>\n                <option value="336">2 <%- msg.G_Weeks %></option>\n                <option value="720">30 <%- msg.G_Days %></option>\n                <option value="2880">120 <%- msg.G_Days %></option>\n            </select>\n        </div>\n\n        <div class="right">\n            <select name="items-per-page" data-label="<%- msg.G_FilterItemsPerPage %>">\n                <option value="10">10</option>\n                <option value="50" selected="selected">50</option>\n                <option value="100">100</option>\n                <option value="200">200</option>\n            </select>\n        </div>\n    </form>\n\n    <div class="data-table untitled">\n        <div class="loading"><span><%- msg.N_Loading %></span></div>\n    </div>\n</div>\n'}),define("unifi/view/guests/IndexView",["unifi/view/app/ListContentView","libs/backgrid","ubnt/backgrid","msg/Msg","jquery","libs/moment","unifi/collection/Guests","text!includes/hotspot/guestsIndexTemplate.html"],function(e,t,n,i,o,a,s,r){"use strict";return e.extend({id:"guestsIndex",_templateId:r,_collectionType:{name:"Guests",Class:s},_autoRender:!0,_pageable:!0,_limitTimeframe:"24",render:function(){var t=this.rendered;return e.prototype.render.call(this),t||this.$el.find("select[name=time-filter]").on("change",o.proxy(function(e){this._limitTimeframe=o(e.target).find("option:selected").val(),this.load(!0)},this)),this},load:function(t){t=t||!this.collection,(!this.collection||t)&&e.prototype.load.call(this,t,{reset:!0,data:{within:this._limitTimeframe}})},searchable:function(){var t=o.proxy(function(e){e.addSearchString("status",this.columnStatus(e))},this),n=o.proxy(function(){this.collection.each(t),this.trigger("search:indexed")},this);this.listenTo(this.collection,"change",t),this.listenTo(this.collection,"add",t),this.listenTo(this.collection,"reset",n),n(),e.prototype.searchable.call(this)},columnStatus:function(e){return e.get("expired")?i.G_HotspotExpired:i.G_HotspotValidUntil+" "+a(""+e.get("end"),"X").format("YYYY/MM/DD HH:mm:ss")},columns:function(){return[{name:"name",label:i.G_HotspotNameMACAddress,editable:!1,cell:n.Cells.ComplexCell.extend({formatter:{fromRaw:function(e){return(e.get("hostname")||e.get("name")||"")+" ["+e.get("mac")+"]"},toRaw:function(e){return e}}})},{name:"package",label:i.G_Package,editable:!1,sortable:!1,headerCell:n.Headers.noSortHeader,cell:"string"},{name:"amount",label:i.G_Amount,editable:!1,cell:n.Cells.ComplexCell.extend({formatter:n.Formatters.Currency})},{name:"package",label:i.G_HotspotAuthorizedBy,editable:!1,cell:n.Cells.ModelCell.extend({callback:"authorization"})},{name:"tx_bytes",label:i.G_Download,editable:!1,cell:t.StringCell.extend({formatter:n.Formatters.Bytes})},{name:"rx_bytes",label:i.G_Upload,editable:!1,cell:t.StringCell.extend({formatter:n.Formatters.Bytes})},{name:"end",label:i.G_Status,editable:!1,cell:n.Cells.ComplexCell.extend({formatter:{fromRaw:this.columnStatus,toRaw:function(e){return e}}})},{name:"_id",label:i.G_Actions,editable:!1,sortable:!1,headerCell:n.Headers.noSortHeader,cell:n.Cells.ActionsCell.extend({actions:{disconnect:{icon:"",callback:this.rowDisconnect},extend:{icon:"ubnt-icon-rotate",callback:this.rowExtend}}})}]},rowDisconnect:function(e){var t=this;e.destroy({wait:!0,error:function(e,n,o){t.app.views.app.flash("error","Error",i.apiError(n))}})},rowExtend:function(e){var t=this;e.extend({success:function(e,n,i){"ok"===e.meta.rc?t.collection.fetch({data:o.param({within:t._limitTimeframe})}):t.app.views.app.flash("error")},error:function(e){t.app.views.app.flash("error","Error",i.apiError(e))}})},remove:function(){this.$el.find("select[name=time-filter]").off("change"),this.stopListening(this.collection),this.rendered=!1,e.prototype.remove.apply(this,arguments)}})}),define("unifi/router/GuestsRouter",["unifi/router/Router","unifi/view/guests/IndexView"],function(e,t){"use strict";return e.extend({_fullyQualifiedName:"UNIFI.Routers.Guests",_associatedViews:{Index:t},routes:{guests:"index","guests?d=:d":"index"}})}),define("unifi/model/Payment",["unifi/model/Model","backbone"],function(e,t){"use strict";return e.extend({refund:function(e){return this.sync("refund",this,e)},sync:function(e,n,i){switch(e){case"refund":i.contentType="application/json; charset=utf-8",i.type="POST",i.url="/api/s/"+SITE.name+"/cmd/hotspot",i.data=JSON.stringify({_id:n.id,cmd:"refund"})}return t.sync.call(this,e,n,i)},toSearch:function(){return{lastname:this.attributes.last_name,firstname:this.attributes.first_name,"package":this.attributes["package"],amount:this.attributes.amount,info:this.attributes.info}}})}),define("unifi/collection/Payments",["unifi/collection/Collection","backbone","unifi/model/Payment"],function(e,t,n){"use strict";return e.extend({model:n,bySite:!0,url:function(){return"/api/s/"+SITE.name+"/stat/payment"},sync:function(e,n,i){switch(e){case"read":i.type="POST",i.data=JSON.stringify(i.data)}return t.sync.call(this,e,n,i)}})}),define("text!includes/hotspot/paymentsIndexTemplate.html",[],function(){return'<div class="section section-main">\n    <h1><%- msg.G_HotspotPaymentsTransactions %></h1>\n\n    <form class="data-filters clearfix">\n        <span class="ubnt-icon-search"></span>\n        <input type="text" name="search" class="search left" />\n\n        <div class="left">\n            <select name="time-filter" data-label="<%- msg.G_FilterShow %>" >\n                <option value="24"><%- msg.G_Last %> 24 <%- msg.G_Hours %></option>\n                <option value="72">3 <%- msg.G_Days %></option>\n                <option value="168">7 <%- msg.G_Days %></option>\n                <option value="336">2 <%- msg.G_Weeks %></option>\n                <option value="720">30 <%- msg.G_Days %></option>\n                <option value="2880">120 <%- msg.G_Days %></option>\n            </select>\n        </div>\n\n        <div class="right">\n            <select name="items-per-page" data-label="<%- msg.G_FilterItemsPerPage %>">\n                <option value="10">10</option>\n                <option value="50" selected="selected">50</option>\n                <option value="100">100</option>\n                <option value="200">200</option>\n            </select>\n        </div>\n    </form>\n\n    <div class="data-table untitled">\n        <div class="loading"><span><%- msg.N_Loading %></span></div>\n    </div>\n</div>\n'}),define("unifi/view/payments/IndexView",["unifi/view/app/ListContentView","libs/backgrid","ubnt/backgrid","underscore","msg/Msg","jquery","unifi/collection/Payments","text!includes/hotspot/paymentsIndexTemplate.html"],function(e,t,n,i,o,a,s,r){"use strict";return e.extend({id:"paymentsIndex",_templateId:r,_collectionType:{name:"Payments",Class:s},_autoRender:!0,_pageable:!0,_limitTimeframe:"24",render:function(){var t=this.rendered;return e.prototype.render.call(this),t||this.$el.find("select[name=time-filter]").on("change",a.proxy(function(e){this._limitTimeframe=a(e.target).find("option:selected").val(),this.load(!0)},this)),this},load:function(t){t=t||!this.collection,(!this.collection||t)&&e.prototype.load.call(this,t,{reset:!0,data:{within:this._limitTimeframe}})},searchable:function(){var t=a.proxy(function(e){e.addSearchString("status",this.columnStatus(e))},this),n=a.proxy(function(){this.collection.each(t),this.trigger("search:indexed")},this);this.listenTo(this.collection,"change",t),this.listenTo(this.collection,"add",t),this.listenTo(this.collection,"reset",n),n(),e.prototype.searchable.call(this)},columnStatus:function(e){return"paid"==e.get("status")?"Paid":"Voided/Refunded"},columns:function(){return[{name:"datetime",label:o.G_Time,editable:!1,cell:t.StringCell.extend({formatter:i.extend({},n.Formatters.Moment,{fromFormat:""})})},{name:"last_name",label:o.G_HotspotLastName,editable:!1,cell:"string"},{name:"first_name",label:o.G_HotspotFirstName,editable:!1,cell:"string"},{name:"package",label:o.G_Package,editable:!1,cell:"string"},{name:"amount",label:o.G_Amount,editable:!1,cell:n.Cells.ComplexCell.extend({formatter:n.Formatters.Currency})},{name:"info",label:o.G_HotspotExtraInfo,editable:!1,cell:"string"},{name:"status",label:o.G_Status,editable:!1,cell:n.Cells.ComplexCell.extend({formatter:{fromRaw:this.columnStatus,toRaw:function(e){return e}}})},{name:"_id",label:o.G_Actions,editable:!1,sortable:!1,headerCell:n.Headers.noSortHeader,cell:n.Cells.ActionsCell.extend({actions:{refund:{icon:"ubnt-icon-undo",callback:this.rowRefund,render:function(e){return"paid"==e.get("status")}}}})}]},rowRefund:function(e){var t=this;e.refund({success:function(n,i,o){"ok"===n.meta.rc?e.fetch():t.options.app.views.app.flash("error")},error:function(e){t.options.app.views.app.flash("error","Error",o.apiError(e))}})},remove:function(){this.$el.find("select[name=time-filter]").off("change"),this.stopListening(this.collection),this.rendered=!1,e.prototype.remove.apply(this,arguments)}})}),define("unifi/router/PaymentsRouter",["unifi/router/Router","unifi/view/payments/IndexView"],function(e,t){"use strict";return e.extend({_fullyQualifiedName:"UNIFI.Routers.Payments",_associatedViews:{Index:t},routes:{payments:"index","payments?d=:d":"index"}})}),define("text!includes/hotspot/vouchersFormTemplate.html",[],function(){return'<form class="create complex-form">\n    <h2 class="headline"><%- msg.G_HotspotCreateVouchers %></h2>\n\n    <fieldset class="basic">\n        <div class="fields">\n            <div>\n                <label for="voucherCreate" class="label"><%- msg.G_HotspotCreate %></label>\n                <input id="voucherCreate" type="text" name="n" value="10" size="4" />\n                <span class="inline">\n                    <select name="quota">\n                        <option value="1"><%- msg.G_HotspotOnetime %></option>\n                        <option value="0"><%- msg.G_HotspotMultiuse %></option>\n                    </select>\n                </span>\n            </div>\n            <div>\n                <label for="voucherExpire" class="label"><%- msg.G_HotspotVouchersFor %></label>\n                <span>\n                    <select id="voucherExpire" name="expire">\n                        <option value="480">8 <%- msg.G_Hours %></option>\n                        <option value="1440" selected="selected">24 <%- msg.G_Hours %></option>\n                        <option value="2880">2 <%- msg.G_Days %></option>\n                        <option value="4320">3 <%- msg.G_Days %></option>\n                        <option value="5760">4 <%- msg.G_Days %></option>\n                        <option value="10080">7 <%- msg.G_Days %></option>\n                        <option value="custom"><%- msg.G_HotspotUserDefined %></option>\n                    </select>\n                </span>\n\n                <div class="custom-expire">\n                    <input type="text" name="expire_number" value="1" size="4" />\n\n                    <span>\n                        <select name="expire_unit">\n                            <option value="1"><%- msg.G_Minute %></option>\n                            <option value="60"><%- msg.G_Hour %></option>\n                            <option value="1440" selected="selected"><%- msg.G_Day %></option>\n                        </select>\n                    </span>\n                </div>\n            </div>\n            <div>\n                <label for="downRateEnabled"><%- msg.G_SettingsBandwidthLimitDL %></label>\n                <input type="checkbox" id="downRateEnabled" name="downrate-enabled" value="1" />\n                <span><%- msg.G_SettingsLimitedTo %></span>\n                <input type="text" id="down" name="down" size="5" value="" />\n                <span><%- msg.G_SettingsKbps %></span>\n            </div>\n            <div>\n                <label for="upRateEnabled"><%- msg.G_SettingsBandwidthLimitUL %></label>\n                <input type="checkbox" id="upRateEnabled" name="uprate-enabled" value="1" />\n                <span><%- msg.G_SettingsLimitedTo %></span>\n                <input type="text" id="up" name="up" size="5" value="" />\n                <span><%- msg.G_SettingsKbps %></span>\n            </div>\n            <div>\n                <label for="quotaEnabled"><%- msg.G_HotspotVouchersQuota %></label>\n                <input type="checkbox" id="quotaEnabled" name="quota-enabled" value="1" />\n                <span><%- msg.G_SettingsLimitedTo %></span>\n                <input type="text" id="bytes" name="bytes" size="5" value="" />\n                <span><%- msg.G_SettingsMegaBytes %></span>\n            </div>\n            <div>\n                <label for="voucherNotes"><%- msg.G_HotspotNotes %></label>\n                <input id="voucherNotes" type="text" name="note" value="" placeholder="<%- msg.G_HotspotNotes %>" />\n            </div>\n        </div>\n    </fieldset>\n\n    <fieldset class="actions">\n        <button type="button" class="button tall auto white cancel"><span class="ui-button-icon ubnt-icon-close"></span>Cancel</button>\n        <button type="submit" class="button button-create tall auto green save"><span class="ubnt-icon-check ui-button-icon button-check-icon"></span>Create Vouchers</button>\n    </fieldset>\n</form>\n'}),define("unifi/view/vouchers/FormView",["unifi/view/app/FormView","msg/Msg","underscore","jquery","text!includes/hotspot/vouchersFormTemplate.html","unifi/view/app/ValidatorMixin"],function(e,t,n,i,o,a){"use strict";return e.extend({_templateId:n.template(o,{msg:t}),_fadeIn:!1,_permanent:!0,_collectionCreate:"batch",_prevalidate:{n:{input:"text",complex:!0},expire_number:{input:"text",complex:!0},up:{input:"text",complex:!0},down:{input:"text",complex:!0},bytes:{input:"text",complex:!0}},render:function(){var t=this,o=this.rendered;if(e.prototype.render.call(this),!o){var a=this.$el.find(".custom-expire"),s=a.find("input[name=expire_number]");this.$el.find("select[name=expire]").on("change",function(){"custom"==i(this).find("option:selected").val()?(s.trigger("validate"),a.show()):(s.removeClass("error").val("1").closest("div").find(".error-msg").remove(),a.hide())}).trigger("change");var r=[{checkboxEl:"input[name=downrate-enabled]",validateEl:"input[name=down]"},{checkboxEl:"input[name=uprate-enabled]",validateEl:"input[name=up]"},{checkboxEl:"input[name=quota-enabled]",validateEl:"input[name=bytes]"}];n.each(r,function(e){t.$el.find(e.checkboxEl).on("change",function(n){var o=i(this),a=t.$el.find(e.validateEl);o.is(":checked")?(o.parent().find("input").not(o).prop("disabled",!1),a.trigger("validate")):(a.removeClass("error").val("").closest("div").find(".error-msg").remove(),o.parent().find("input").not(o).prop("disabled",!0))})}),this.$el.find("input[name=downrate-enabled], input[name=uprate-enabled], input[name=quota-enabled]").on("change",function(){var e=i(this);e.is(":checked")?e.parent().find("input").not(e).prop("disabled",!1):e.parent().find("input").not(e).prop("disabled",!0)}).trigger("change"),this.app.isReadOnly||this.prevalidator()}},gather:function(){var e={n:this.$el.find("input[name=n]").val()||void 0,quota:this.$el.find("select[name=quota] option:selected").val()||void 0,expire:this.$el.find("select[name=expire] option:selected").val()||void 0,expire_number:this.$el.find("input[name=expire_number]").val()||void 0,expire_unit:this.$el.find("select[name=expire_unit] option:selected").val()||void 0,note:this.$el.find("input[name=note]").val()||void 0};return this.$el.find("input[name=downrate-enabled]").is(":checked")&&(e.down=this.$el.find("input[name=down]").val()||void 0),this.$el.find("input[name=uprate-enabled]").is(":checked")&&(e.up=this.$el.find("input[name=up]").val()||void 0),this.$el.find("input[name=quota-enabled]").is(":checked")&&(e.bytes=this.$el.find("input[name=bytes]").val()||void 0),e},save:function(e){e&&e.preventDefault(),this.$submit.trigger("saving");var n=this.model.validate(this.gather());if(n)return void this.$submit.trigger("error",!0);var o=this.$el.find(".error-msg").length>0;o||this.clear();var a=this,s=!o&&this._save(null,null,{validate:!0,success:i.proxy(function(e,t,n){this.trigger("save-success",e,t,n)},this),error:function(e,n,i){a.app.views.app.flash("error","Error",t.apiError(e,!0))}});(o||!s)&&this.$submit.trigger("error",!0)},success:function(){this.collection.reload(),this.remove()},remove:function(){this.$el.find("input[name=downrate-enabled], input[name=uprate-enabled], input[name=quota-enabled]").off(),this.$el.find("select[name=expire]").off("change"),this.rendered=!1,e.prototype.remove.apply(this,arguments)}})}),define("unifi/model/Voucher",["unifi/model/Model","backbone","underscore","ubnt/backgrid","msg/Msg"],function(e,t,n,i,o){"use strict";return e.extend({code:function(){return this.attributes.code.substring(0,5)+"-"+this.attributes.code.substring(5)},validate:function(e,t){var i={},a=t?t.partial:null;return a&&"n"!=a||(e.n?this.validator.range(e.n,1,1e4)||(i.n=o.localize(o.E_IncorrectNumberRange,o.G_HotspotCount,1,1e4)):i.n=o.localize(o.E_CannotBeEmpty,o.G_HotspotCount)),a&&"expire_number"!=a||(e.expire_number?this.validator.range(e.expire_number,1,1e6)||(i.expire_number=o.localize(o.E_IncorrectNumberRange,o.G_HotspotExpireValue,1,1e6)):i.expire_number=o.localize(o.E_CannotBeEmpty,o.G_HotspotExpireValue)),a&&"down"!=a||e.hasOwnProperty("down")&&(e.down?this.validator.range(e.down,2,102400)||(i.down=o.localize(o.E_IncorrectNumberRange,o.G_HotspotDownloadLimit,2,102400)):i.down=o.localize(o.E_CannotBeEmpty,o.G_HotspotDownloadLimit)),a&&"up"!=a||e.hasOwnProperty("up")&&(e.up?this.validator.range(e.up,2,102400)||(i.up=o.localize(o.E_IncorrectNumberRange,o.G_HotspotUploadLimit,2,102400)):i.up=o.localize(o.E_CannotBeEmpty,o.G_HotspotUploadLimit)),a&&"bytes"!=a||e.hasOwnProperty("bytes")&&(e.bytes?this.validator.range(e.bytes,1,1048576)||(i.bytes=o.localize(o.E_IncorrectNumberRange,o.G_HotspotByteQuota,1,1048576)):i.bytes=o.localize(o.E_CannotBeEmpty,o.G_HotspotByteQuota)),n.size(i)?i:void 0},sync:function(e,n,i){switch(e){case"delete":i.contentType="application/json; charset=utf-8",i.type="POST",i.url="/api/s/"+SITE.name+"/cmd/hotspot",i.data=JSON.stringify({_id:n.id,cmd:"delete-voucher"})}return t.sync.call(this,e,n,i)},byte_quota:function(){return parseInt(this.get("qos_usage_quota")||-1,10)},upload_limit:function(){return parseInt(this.get("qos_rate_max_up")||-1,10)},download_limit:function(){return parseInt(this.get("qos_rate_max_down")||-1,10)},toSearch:function(){return{code:this.code(),note:this.attributes.note}}})}),define("unifi/collection/Vouchers",["unifi/collection/Collection","underscore","backbone","unifi/model/Voucher"],function(e,t,n,i){"use strict";return e.extend({model:i,bySite:!0,url:function(){return"/api/s/"+SITE.name+"/stat/voucher"},batch:function(e,n){return this.sync("batch",this,t.extend(n||{},{data:e}))},sync:function(e,i,o){switch(e){case"batch":o.contentType="application/json; charset=utf-8",o.type="POST",o.url="/api/s/"+SITE.name+"/cmd/hotspot",o.data=JSON.stringify(t.extend(o.data,{cmd:"create-voucher"}))}return n.sync.call(this,e,i,o)}})}),define("text!includes/hotspot/vouchersIndexTemplate.html",[],function(){return'<div class="section section-main">\n    <h1><%- msg.G_HotspotVouchers %></h1>\n\n    <form class="data-filters clearfix">\n        <span class="ubnt-icon-search"></span>\n        <input type="text" name="search" class="search left" />\n\n        <div class="right">\n            <button class="button lighter skinny auto" id="printAll">\n                <span class="ubnt-icon-printer"></span> <%- msg.G_HotspotPrintAllUnusedVouchers %>\n            </button>\n            <select name="items-per-page" data-label="<%- msg.G_FilterItemsPerPage %>">\n                <option value="10">10</option>\n                <option value="50" selected="selected">50</option>\n                <option value="100">100</option>\n                <option value="200">200</option>\n            </select>\n        </div>\n    </form>\n\n    <div class="data-table untitled">\n        <div class="loading"><span><%- msg.N_Loading %></span></div>\n    </div>\n    <div class="buttons">\n        <button class="button tall auto white create-form">\n            <span class="ui-button-icon ubnt-icon-ticket"></span><%- msg.G_HotspotCreateVouchers %>\n        </button>\n    </div>\n\n    <div class="forms hidden"></div>\n</div>'}),define("unifi/view/vouchers/IndexView",["unifi/view/settings/ListContentView","unifi/view/vouchers/FormView","libs/backgrid","ubnt/backgrid","jquery","unifi/collection/Vouchers","msg/Msg","text!includes/hotspot/vouchersIndexTemplate.html"],function(e,t,n,i,o,a,s,r){"use strict";return e.extend({id:"vouchersIndex",_templateId:r,_collectionType:{name:"Vouchers",Class:a},_autoRender:!0,_pageable:!0,_formClass:t,render:function(){var t=this.rendered;return e.prototype.render.call(this),t||o("#printAll").on("click",this.printAll),this},renderForm:function(){this.$createBtn.hide()},removeForm:function(e){this.$createBtn.show()},searchable:function(){var t=o.proxy(function(e){e.addSearchString("create-time",i.Formatters.Moment.fromRaw(e.get("create_time"))),e.addSearchString("duration",i.Formatters.Minutes.fromRaw(e.get("duration"))),e.addSearchString("status",this.columnStatus(e))},this),n=o.proxy(function(){this.collection.each(t),this.trigger("search:indexed")},this);this.listenTo(this.collection,"change",t),this.listenTo(this.collection,"add",t),this.listenTo(this.collection,"reset",n),n(),e.prototype.searchable.call(this)},columnStatus:function(e){var t=(e.get("end_time")||0)-(new Date).getTime()/1e3;return e.get("used")>0?t>0?"Used"+(1!=e.get("quota")?" "+e.get("used")+" time(s)":"")+", expires in "+i.Formatters.Seconds.fromRaw(t.toFixed(0)):"Expired":"Valid"+(1!=e.get("quota")?" for multi-use":" for one-time use")},columns:function(){return[{name:"code",label:s.G_HotspotCode,editable:!1,cell:i.Cells.ModelCell.extend({callback:"code"})},{name:"create_time",label:s.G_HotspotCreateTime,editable:!1,cell:n.StringCell.extend({formatter:i.Formatters.Moment})},{name:"qos_rate_max_down",label:s.G_Down,editable:!1,sortValue:"download_limit",headerCell:i.Headers.customSortHeader,cell:n.StringCell.extend({formatter:i.Formatters.BitsPerSecondFromKbps})},{name:"qos_rate_max_up",label:s.G_Up,editable:!1,sortValue:"upload_limit",headerCell:i.Headers.customSortHeader,cell:n.StringCell.extend({formatter:i.Formatters.BitsPerSecondFromKbps})},{name:"qos_usage_quota",label:s.G_HotspotVouchersQuota,editable:!1,sortValue:"byte_quota",headerCell:i.Headers.customSortHeader,cell:i.Cells.ComplexCell.extend({formatter:{fromRaw:function(e){var t=e.get("qos_usage_quota")||-1;return 0>t?"":i.Formatters.Bytes.fromRaw(1024*t*1024)},toRaw:function(e){return e}}})},{name:"note",label:s.G_HotspotNotes,editable:!1,cell:"string"},{name:"duration",label:s.G_Duration,editable:!1,cell:n.StringCell.extend({formatter:i.Formatters.Minutes})},{name:"status",label:s.G_Status,editable:!1,sortable:!1,headerCell:i.Headers.noSortHeader,cell:i.Cells.ComplexCell.extend({formatter:{fromRaw:this.columnStatus,toRaw:function(e){return e}}})},{name:"_id",label:s.G_Actions,editable:!1,sortable:!1,headerCell:i.Headers.noSortHeader,cell:i.Cells.ActionsCell.extend({actions:{revoke:{icon:"ubnt-icon-close",callback:this.rowRevoke},print:{icon:"ubnt-icon-printer",buttonClasses:"auto",text:s.G_HotspotPrintBatch,callback:this.rowPrint}}})}]},rowRevoke:function(e){var t=this;e.destroy({wait:!0,error:function(e){t.options.app.views.app.flash("error","Error",s.apiError(e))}})},rowPrint:function(e){return window.open("/print/hotspot/vouchers/s/"+SITE.name+"?create_time="+e.get("create_time"),"print_voucher"),!1},printAll:function(){return window.open("/print/hotspot/vouchers/s/"+SITE.name,"print_voucher"),!1},remove:function(){this.stopListening(this.collection),o("#printAll").on("click",this.printAll),this.rendered=!1,e.prototype.remove.apply(this,arguments)}})}),define("unifi/router/VouchersRouter",["unifi/router/Router","unifi/view/vouchers/FormView","unifi/view/vouchers/IndexView"],function(e,t,n){"use strict";return e.extend({_fullyQualifiedName:"UNIFI.Routers.Vouchers",_associatedViews:{Form:t,Index:n},routes:{vouchers:"index","vouchers?d=:d":"index"}})}),define("text!includes/hotspot/operatorsFormTemplate.html",[],function(){return'<form class="create complex-form">\n    <h2 class="headline"><%- msg.G_HotspotCreateOperator %></h2>\n\n    <fieldset class="basic">\n        <div class="fields">\n            <div>\n                <label for="operatorAccountName"><%- msg.G_HotspotAccountName %></label>\n                <input id="operatorAccountName" type="text" name="name"/>\n            </div>\n            <div>\n                <label for="operatorPassword"><%- msg.G_PW %></label>\n                <input id="operatorPassword" type="password" name="x_password"/>\n            </div>\n            <div>\n                <label for="operatorNotes"><%- msg.G_HotspotNotes %></label>\n                <input id="operatorNotes" type="text" name="note" />\n            </div>\n        </div>\n    </fieldset>\n\n    <fieldset class="actions">\n        <button type="button" class="button tall auto white cancel">\n            <span class="ui-button-icon ubnt-icon-close"></span>\n            <%- msg.G_Cancel %>\n        </button>\n        <button type="submit" class="button button-create tall auto green save">\n            <span class="ubnt-icon-check ui-button-icon button-check-icon"></span>\n            <%- msg.G_HotspotCreateOperator %>\n        </button>\n    </fieldset>\n</form>\n'}),define("unifi/view/operators/FormView",["unifi/view/app/FormView","jquery","underscore","msg/Msg","text!includes/hotspot/operatorsFormTemplate.html"],function(e,t,n,i,o){"use strict";return e.extend({_templateId:n.template(o,{msg:i}),_fadeIn:!1,_permanent:!0,_prevalidate:{name:{input:"text",complex:!0},x_password:{input:"password",complex:!0}},initialize:function(t){e.prototype.initialize.call(this,t),this.list=t.list},render:function(){var t=this.rendered;e.prototype.render.call(this),t||this.app.isReadOnly||this.prevalidator()},gather:function(){return{name:this.$el.find("input[name=name]").val(),x_password:this.$el.find("input[name=x_password]").val(),note:this.$el.find("input[name=note]").val()}},success:function(t,n,i){e.prototype.success.call(this,t,n,i),this.remove()},error:function(t,n){e.prototype.error.call(this,t,n),this.options.app.views.app.flash("error","Error",i.apiError(n))}})}),define("unifi/model/Operator",["unifi/model/Model","underscore","backbone","msg/Msg"],function(e,t,n,i){"use strict";return e.extend({validate:function(e,n){var o={},a=n?n.partial:null;return a&&"name"!=a||(e.name?e.name.length>256&&(o.name=i.localize(i.E_IncorrectNumberRange,i.G_HotspotAccountName,1,256)):o.name=i.localize(i.E_CannotBeEmpty,i.G_HotspotAccountName)),a&&"x_password"!=a||(e.x_password?e.x_password.length>256&&(o.x_password=i.localize(i.E_IncorrectNumberRange,i.G_PW,1,256)):o.x_password=i.localize(i.E_CannotBeEmpty,i.G_PW)),t.size(o)?o:void 0},url:function(){return"/api/s/"+SITE.name+"/list/hotspotop"},sync:function(e,t,i){switch(e){case"create":i.contentType="application/json; charset=utf-8",i.url="/api/s/"+SITE.name+"/add/hotspotop",i.type="POST";break;case"update":i.contentType="application/json; charset=utf-8",i.url="/api/s/"+SITE.name+"/upd/hotspotop/"+this.id,i.type="POST",i.data=JSON.stringify(t.toJSON({exclude:["_id","site_id"]}));break;case"delete":i.contentType="application/json; charset=utf-8",i.url="/api/s/"+SITE.name+"/del/hotspotop/"+this.id,i.type="POST"}return n.sync.call(this,e,t,i)}})}),define("unifi/collection/Operators",["unifi/collection/Collection","backbone","unifi/model/Operator"],function(e,t,n){"use strict";return e.extend({model:n,bySite:!0,url:function(){return"/api/s/"+SITE.name+"/list/hotspotop"}})}),define("text!includes/hotspot/operatorsIndexTemplate.html",[],function(){return'<div class="section section-main">\n    <h1><%- msg.G_HotspotOperatorAccounts %></h1>\n\n    <form class="data-filters clearfix">\n        <span class="ubnt-icon-search"></span>\n        <input type="text" name="search" class="search left" />\n\n        <div class="right">\n            <select name="items-per-page" data-label="<%- msg.G_FilterItemsPerPage %>">\n                <option value="10">10</option>\n                <option value="50" selected="selected">50</option>\n                <option value="100">100</option>\n                <option value="200">200</option>\n            </select>\n        </div>\n    </form>\n\n    <div class="data-table untitled">\n        <div class="loading"><span><%- msg.N_Loading %></span></div>\n    </div>\n    <div class="buttons">\n        <button class="button tall auto white create-form">\n            <span class="ui-button-icon ubnt-icon-id"></span><%- msg.G_HotspotCreateNewOperator %>\n        </button>\n        <button class="button tall auto white open-login">\n            <span class="ui-button-icon ubnt-icon-id"></span><%- msg.G_HotspotOpenOperatorLogin %>\n        </button>\n    </div>\n\n    <div class="forms hidden"></div>\n</div>'}),define("unifi/view/operators/IndexView",["unifi/view/settings/ListContentView","unifi/view/operators/FormView","underscore","unifi/service/location/locationService","msg/Msg","libs/backgrid","ubnt/backgrid","unifi/collection/Operators","text!includes/hotspot/operatorsIndexTemplate.html","jquery"],function(e,t,n,i,o,a,s,r,l,c){"use strict";return e.extend({id:"operatorsIndex",_templateId:l,_collectionType:{name:"Operators",Class:r},_autoRender:!0,_pageable:!0,_formClass:t,render:function(t){e.prototype.render.call(this),!this.renderedd&&(this.renderedd=!0)&&(this.$openLoginBtn=this.$el.find(".open-login"),
this.$openLoginBtn.on("click",c.proxy(function(){i.openHotspotLoginPageForCurrentSite()},this)))},renderForm:function(){this.$createBtn.hide()},removeForm:function(){this.$createBtn.show()},columns:function(){return[{name:"name",label:o.G_Name,editable:!1,cell:"string"},{name:"x_password",label:o.G_PW,editable:!1,cell:"string"},{name:"note",label:o.G_HotspotNotes,editable:!1,cell:"string"},{name:"_id",label:o.G_Actions,editable:!1,sortable:!1,headerCell:s.Headers.noSortHeader,cell:s.Cells.ActionsCell.extend({actions:{"delete":{icon:"ubnt-icon-trash",callback:this.rowDelete}}})}]},rowDelete:function(e){e.destroy({wait:!0})},remove:function(){this.$openLoginBtn.off(),this.renderedd=!1,e.prototype.remove.apply(this,arguments)}})}),define("unifi/router/OperatorsRouter",["unifi/router/Router","unifi/view/operators/FormView","unifi/view/operators/IndexView"],function(e,t,n){"use strict";return e.extend({_fullyQualifiedName:"UNIFI.Routers.Operators",_associatedViews:{Index:n,Form:t},routes:{operators:"index","operators?d=:d":"index"}})}),define("unifi/view/app/OperatorView",["unifi/view/app/ChromeView","jquery"],function(e,t){"use strict";return e.extend({initialize:function(t){e.prototype.initialize.call(this,t)}})}),require(["jquery","app","unifi/router/GuestsRouter","unifi/router/PaymentsRouter","unifi/router/VouchersRouter","unifi/router/OperatorsRouter","unifi/view/app/OperatorView","unifi/collection/Sites"],function(e,t,n,i,o,a,s,r){"use strict";e(function(){var e={Guests:n,Payments:i,Vouchers:o,Operators:a},l={Sites:r};t.initialize(e,l,s)})}),define("hotspot",function(){});