/**
 * KineticJS JavaScript Framework v4.3.3
 * http://www.kineticjs.com/
 * Copyright 2013, Eric Rowell
 * Licensed under the MIT or GPL Version 2 licenses.
 * Date: Feb 12 2013
 *
 * Copyright (C) 2011 - 2013 by Eric Rowell
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

/** @license
 * RequireJS plugin for async dependency load like JSONP and Google Maps
 * Author: Miller Medeiros
 * Version: 0.1.1 (2011/11/17)
 * Released under the MIT license
 */

/*! Copyright (c) 2013 Brandon Aaron (http://brandon.aaron.sh)
 * Licensed under the MIT License (LICENSE.txt).
 *
 * Version: 3.1.6
 *
 * Requires: jQuery 1.2.2+
 */

/*
 * heatmap.js v2.0.0 | JavaScript Heatmap Library
 *
 * Copyright 2008-2014 Patrick Wied <heatmapjs@patrick-wied.at> - All rights reserved.
 * Dual licensed under MIT and Beerware license 
 *
 * :: 2014-10-31 21:16
 */

/*
* heatmap.js gmaps overlay
*
* Copyright (c) 2014, Patrick Wied (http://www.patrick-wied.at)
* Dual-licensed under the MIT (http://www.opensource.org/licenses/mit-license.php)
* and the Beerware (http://en.wikipedia.org/wiki/Beerware) license.
*/

/*!
 * jQuery Validation Plugin 1.12.0pre
 *
 * http://jqueryvalidation.org//
 *
 * Copyright 2013 Jörn Zaefferer
 * Released under the MIT license:
 *   http://www.opensource.org/licenses/mit-license.php
 */

/*
  map.js
  Copyright 2015 Ubiquiti Networks, Inc. All rights reserved.
 */

/*
  Copyright 2015 Ubiquiti Networks, Inc. All rights reserved.
 */

//
// Regular Expression for URL validation
//
// Author: Diego Perini
// Updated: 2010/12/05
// License: MIT
//
// Copyright (c) 2010-2013 Diego Perini (http://www.iport.it)
//
// Permission is hereby granted, free of charge, to any person
// obtaining a copy of this software and associated documentation
// files (the "Software"), to deal in the Software without
// restriction, including without limitation the rights to use,
// copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following
// conditions:
//
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
// OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
// HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
// OTHER DEALINGS IN THE SOFTWARE.
//
// the regular expression composed & commented
// could be easily tweaked for RFC compliance,
// it was expressly modified to fit & satisfy
// these test for an URL shortener:
//
//   http://mathiasbynens.be/demo/url-regex
//
// Notes on possible differences from a standard/generic validation:
//
// - utf-8 char class take in consideration the full Unicode range
// - TLDs have been made mandatory so single names like "localhost" fails
// - protocols have been restricted to ftp, http and https only as requested
//
// Changes:
//
// - IP address dotted notation validation, range: 1.0.0.0 - 223.255.255.255
//   first and last IP address of each class is considered invalid
//   (since they are broadcast/network addresses)
//
// - Added exclusion of private, reserved and/or local networks ranges
//
// - Made starting path slash optional (http://example.com?foo=bar)
//
// - Allow a dot (.) at the end of hostnames (http://example.com.)
//
// Compressed one-line versions:
//
// Javascript version
//
// /^(?:(?:https?|ftp):\/\/)(?:\S+(?::\S*)?@)?(?:(?!(?:10|127)(?:\.\d{1,3}){3})(?!(?:169\.254|192\.168)(?:\.\d{1,3}){2})(?!172\.(?:1[6-9]|2\d|3[0-1])(?:\.\d{1,3}){2})(?:[1-9]\d?|1\d\d|2[01]\d|22[0-3])(?:\.(?:1?\d{1,2}|2[0-4]\d|25[0-5])){2}(?:\.(?:[1-9]\d?|1\d\d|2[0-4]\d|25[0-4]))|(?:(?:[a-z\u00a1-\uffff0-9]-*)*[a-z\u00a1-\uffff0-9]+)(?:\.(?:[a-z\u00a1-\uffff0-9]-*)*[a-z\u00a1-\uffff0-9]+)*(?:\.(?:[a-z\u00a1-\uffff]{2,}))\.?)(?::\d{2,5})?(?:[/?#]\S*)?$/i
//
// PHP version
//
// _^(?:(?:https?|ftp)://)(?:\S+(?::\S*)?@)?(?:(?!(?:10|127)(?:\.\d{1,3}){3})(?!(?:169\.254|192\.168)(?:\.\d{1,3}){2})(?!172\.(?:1[6-9]|2\d|3[0-1])(?:\.\d{1,3}){2})(?:[1-9]\d?|1\d\d|2[01]\d|22[0-3])(?:\.(?:1?\d{1,2}|2[0-4]\d|25[0-5])){2}(?:\.(?:[1-9]\d?|1\d\d|2[0-4]\d|25[0-4]))|(?:(?:[a-z\x{00a1}-\x{ffff}0-9]-*)*[a-z\x{00a1}-\x{ffff}0-9]+)(?:\.(?:[a-z\x{00a1}-\x{ffff}0-9]-*)*[a-z\x{00a1}-\x{ffff}0-9]+)*(?:\.(?:[a-z\x{00a1}-\x{ffff}]{2,}))\.?)(?::\d{2,5})?(?:[/?#]\S*)?$_iuS
//

/*
  devices.js
  Copyright 2015 Ubiquiti Networks, Inc. All rights reserved.
 */

/*
  FormView.js
  Copyright 2015 Ubiquiti Networks, Inc. All rights reserved.
 */

/*
  gateways.js
  Copyright 2015 Ubiquiti Networks, Inc. All rights reserved.
 */

/*
  switches.js
  Copyright 2015 Ubiquiti Networks, Inc. All rights reserved.
 */

/*
  phones.js
  Copyright 2015 Ubiquiti Networks, Inc. All rights reserved.
 */

/*
  AddDeviceView.js
  Copyright 2015 Ubiquiti Networks, Inc. All rights reserved.
 */

/*
  devices/IndexView.js
  Copyright 2015 Ubiquiti Networks, Inc. All rights reserved.
 */

/*
 * Toastr
 * Copyright 2012-2015
 * Authors: John Papa, Hans Fjällemark, and Tim Ferrell.
 * All Rights Reserved.
 * Use, reproduction, distribution, and modification of this code is subject to the terms and
 * conditions of the MIT license, available at http://www.opensource.org/licenses/mit-license.php
 *
 * ARIA Support: Greta Krafsig
 *
 * Project: https://github.com/CodeSeven/toastr
 */

/*
  Copyright 2014 Ubiquiti Networks, Inc. All rights reserved.
 */

/*
  backgrid-select-all
  http://github.com/wyuenho/backgrid

  Copyright (c) 2013 Jimmy Yuen Ho Wong and contributors
  Licensed under the MIT @license.
*/

/*!
 * Lightbox v2.8.1
 * by Lokesh Dhakar
 *
 * More info:
 * http://lokeshdhakar.com/projects/lightbox2/
 *
 * Copyright 2007, 2015 Lokesh Dhakar
 * Released under the MIT license
 * https://github.com/lokesh/lightbox2/blob/master/LICENSE
 */

/*
  ubnt.layout.js
  Copyright 2015 Ubiquiti Networks, Inc. All rights reserved.
 
  To be used to add draggable handles to each layout panel and
  also to resize a panel manually. Each panel can be dragged
  from one or more directions (north, south, east or west) and
  can trigger the resize of other panels at the same time (eg. if
  one panel should expand while another collapses).
 
  Usage:
    //initialize the east column to have a handler on the west to change its width
    $('#columnEast').layout({
      'directions': {
        'west': {                                            //add a handle to the west side
          'draggable': true,                                 //allow the panel to be dragged to resize
          'property': 'width',                               //resize the panel's width attribute
          'also': [{
            'element': $('#columnMain > .content'),          //also resize this element
            'property': 'margin-right',                      //resize this element's margin-right
            'inverse': false                                 //don't resize inversely to the main panel
          }]
        }
      }
    });
 
    //resize the east column (using the west handler config) to be 30 pixels wider
    $('#columnEast').layout('resize', 'west', 30, true);
 
    //resize the west column (using the east handler config) to a dynamic value and animate the transition
    $('#columnWest').layout('resize', 'east', function() {
      var left = $('#columnEast').offset().left;
      return left ? left : $(window).width();
    }, false, { duration: 350 });
 */

/*
  ubnt.panel.js
  Copyright 2015 Ubiquiti Networks, Inc. All rights reserved.
 
  An extenstion of the ubnt.layout.js plugin that treats each
  layout element as a panel that can be toggled on or off using
  one or more buttons. A panel toggled to off is completely
  gone, not just minimized.
 
  Usage:
    //initialize the east column to have a handler on the west to change its width
    $('#columnEast').layout({
      'duration': 350,                                       //the duration for the panel show/hide animation
      'directions': {
        'west': {                                            //add a handle to the west side
          'draggable': true,                                 //allow the panel to be dragged to resize
          'property': 'width',                               //resize the panel's width attribute
          'also': [{
            'element': $('#columnMain > .content'),          //also resize this element
            'property': 'margin-right',                      //resize this element's margin-right
            'inverse': false                                 //don't resize inversely to the main panel
          }],
          buttons: [                                         //the button(s) to toggle the east column
            $('#toggleEast')
          ]
        }
      }
    });
 */

/*
  app.js
  Copyright 2015 Ubiquiti Networks, Inc. All rights reserved.
 */

define("text!includes/map/mapIndexTemplate.html",[],function(){return'<div id="Map" class="tab-content">\n    <div class="toolbar">\n        <div class="map-configuration-items">\n            <div class="buttonset left mainToggles">\n                <input type="checkbox" id="mapFilterDetails" name="filter" value="details" />\n                <label for="mapFilterDetails"><%- msg.G_MapDetails %></label>\n            </div>\n            <div class="right">\n                <select name="mapSelect" class="mapSelect"></select>\n            </div>\n        </div>\n        <div class="zoom-controls">\n            <div class="ir zoom-icon plus"><div class="plus-icon ubnt-icon-plus"></div></div>\n            <div class="zoom-slider"></div>\n            <div class="ir zoom-icon minus"><div class="minus-icon ubnt-icon-minus"></div></div>\n        </div>\n        <div class="ruler is-admin">\n            <div class="ruler-icon ubnt-icon-scale"></div>\n            <div class="sub-section">\n                <div class="sub-section-title"><%- msg.G_MapSetMapScale %></div>\n                <div class="ubnt-icon-close close handle"></div>\n                <div class="tip"><%- msg.G_MapDrawLine %></div>\n                <form action="#" class="frm-map-scale">\n                    <input name="distance" type="text" maxlength="4" placeholder="distance" class="input distance left disabled" disabled/>\n                    <div>\n                        <select name="units" class="input units right">\n                            <option value="m"><%- msg.G_MapMeters %></option>\n                            <option value="f"><%- msg.G_MapFeet %></option>\n                        </select>\n                    </div>\n                    <button type="submit" class="button submit right disabled" disabled>\n                        <span class="icon ubnt-icon-check"></span>\n                        <%- msg.G_MapSetScale %>\n                    </button>\n                </form>\n            </div>\n        </div>\n    </div>\n\n    <div class="ubnt-map-widget">\n        <div class="image-map-container map-container">\n            <div class="image-map-coverage-layer"></div>\n            <div class="image-drag-layer">\n                <div class="image-map-layer">\n                    <canvas class="map-canvas"></canvas>\n                </div>\n                <div class="sub-marker-layer"></div>\n                <div class="marker-layer"></div>\n            </div>\n        </div>\n        <div class="google-map-container map-container">\n            <div class="loading"></div>\n        </div>\n    </div>\n\n    <div class="scale">\n        <div class="scale-icon"></div>\n        <div class="scale-measurement"></div>\n    </div>\n\n    <div class="marker-drawer">\n        <button class="button header handle is-admin"><span class="unplaced-markers-count"></span> <%- msg.G_MapUnplacedDevices %></button>\n        <div class="unplaced-devices">\n            <h3 class="sub-section-title"><%- msg.G_MapUnplacedDevices %></h3>\n            <div class="ubnt-icon-close close handle"></div>\n            <ul class="marker-list draggable-list"></ul>\n        </div>\n    </div>\n</div>'}),define("text!includes/map/mapMarkerTemplate.html",[],function(){return'<div class="marker connected disconnected expand">\n    <div class="marker-button">\n        <div class="marker-icon device-icons access-point ir forceRetina"></div>\n    </div>\n\n    <div class="status-icon">\n        <div class="disconnected sprite-status-disconnected"></div>\n        <div class="isolated sprite-status-isolated"></div>\n        <div class="vwireless sprite-status-vwireless"></div>\n    </div>\n    <div class="title"></div>\n    <div class="details">\n        <div class="detail"><div class="ap-name"></div></div>\n        <div class="detail mac-text"><span></span> <div class="mac"></div></div>\n        <div class="detail users-text"><span></span> <div class="users"></div></div>\n        <div class="detail guests-text"><span></span> <div class="guests"></div></div>\n    </div>\n    <div class="halo"></div>\n    <div class="ir move"></div>\n    <div class="sub-buttons">\n        <div class="button-container lock">\n            <div class="button"><div class="icon ubnt-icon-unlock"></div></div>\n        </div>\n\n        <div class="button-container config">\n            <div class="button"><div class="icon ubnt-icon-gear"></div></div>\n        </div>\n\n        <div class="button-container remove">\n            <div class="button"><div class="icon ubnt-icon-close"></div></div>\n        </div>\n\n        <div class="button-container scan">\n            <div class="button"><div class="icon ubnt-icon-histogram"></div></div>\n        </div>\n    </div>\n</div>'}),define("text!includes/map/mapUnplacedMarkerTemplate.html",[],function(){return'<li class="device-list-item">\n    <a href="#">\n    	<span class="ui-icon device-icons access-point half"></span>\n    	<span class="item-label"></span>\n    </a>\n</li>'}),define("text!includes/map/mapUnplacedMarkerDraggableTemplate.html",[],function(){return'<div class="map-widget-marker helper marker expand">\n    <div class="marker-button">\n        <div class="marker-icon device-icons access-point ir ui-icon"></div>\n    </div>\n</div>'});var Kinetic={};!function(){Kinetic.version="4.3.3",Kinetic.Filters={},Kinetic.Plugins={},Kinetic.Global={stages:[],idCounter:0,ids:{},names:{},shapes:{},warn:function(e){window.console&&console.warn&&console.warn("Kinetic warning: "+e)},extend:function(e,t){for(var a in t.prototype)a in e.prototype||(e.prototype[a]=t.prototype[a])},_addId:function(e,t){void 0!==t&&(this.ids[t]=e)},_removeId:function(e){void 0!==e&&delete this.ids[e]},_addName:function(e,t){void 0!==t&&(void 0===this.names[t]&&(this.names[t]=[]),this.names[t].push(e))},_removeName:function(e,t){if(void 0!==e){var a=this.names[e];if(void 0!==a){for(var n=0;n<a.length;n++){var i=a[n];i._id===t&&a.splice(n,1)}0===a.length&&delete this.names[e]}}}}}(),function(e,t){"object"==typeof exports?module.exports=t():"function"==typeof define&&define.amd?define("libs/kinetic",t):e.returnExports=t()}(this,function(){return Kinetic}),function(){Kinetic.Type={_isElement:function(e){return!(!e||1!=e.nodeType)},_isFunction:function(e){return!!(e&&e.constructor&&e.call&&e.apply)},_isObject:function(e){return!!e&&e.constructor==Object},_isArray:function(e){return"[object Array]"==Object.prototype.toString.call(e)},_isNumber:function(e){return"[object Number]"==Object.prototype.toString.call(e)},_isString:function(e){return"[object String]"==Object.prototype.toString.call(e)},_hasMethods:function(e){var t=[];for(var a in e)this._isFunction(e[a])&&t.push(a);return t.length>0},_isInDocument:function(e){for(;e=e.parentNode;)if(e==document)return!0;return!1},_getXY:function(e){if(this._isNumber(e))return{x:e,y:e};if(this._isArray(e)){if(1===e.length){var t=e[0];if(this._isNumber(t))return{x:t,y:t};if(this._isArray(t))return{x:t[0],y:t[1]};if(this._isObject(t))return t}else if(e.length>=2)return{x:e[0],y:e[1]}}else if(this._isObject(e))return e;return null},_getSize:function(e){if(this._isNumber(e))return{width:e,height:e};if(this._isArray(e))if(1===e.length){var t=e[0];if(this._isNumber(t))return{width:t,height:t};if(this._isArray(t)){if(t.length>=4)return{width:t[2],height:t[3]};if(t.length>=2)return{width:t[0],height:t[1]}}else if(this._isObject(t))return t}else{if(e.length>=4)return{width:e[2],height:e[3]};if(e.length>=2)return{width:e[0],height:e[1]}}else if(this._isObject(e))return e;return null},_getPoints:function(e){if(void 0===e)return[];if(this._isArray(e[0])){for(var t=[],a=0;a<e.length;a++)t.push({x:e[a][0],y:e[a][1]});return t}if(this._isObject(e[0]))return e;for(var t=[],a=0;a<e.length;a+=2)t.push({x:e[a],y:e[a+1]});return t},_getImage:function(e,t){if(e)if(this._isElement(e))t(e);else if(this._isString(e)){var a=new Image;a.onload=function(){t(a)},a.src=e}else if(e.data){var n=document.createElement("canvas");n.width=e.width,n.height=e.height;var i=n.getContext("2d");i.putImageData(e,0,0);var o=n.toDataURL(),a=new Image;a.onload=function(){t(a)},a.src=o}else t(null);else t(null)},_rgbToHex:function(e,t,a){return((1<<24)+(e<<16)+(t<<8)+a).toString(16).slice(1)},_hexToRgb:function(e){var t=parseInt(e,16);return{r:t>>16&255,g:t>>8&255,b:255&t}},_getRandomColorKey:function(){var e=Math.round(255*Math.random()),t=Math.round(255*Math.random()),a=Math.round(255*Math.random());return this._rgbToHex(e,t,a)},_merge:function(e,t){var a=this._clone(t);for(var n in e)this._isObject(e[n])?a[n]=this._merge(e[n],a[n]):a[n]=e[n];return a},_clone:function(e){var t={};for(var a in e)this._isObject(e[a])?t[a]=this._clone(e[a]):t[a]=e[a];return t},_degToRad:function(e){return e*Math.PI/180},_radToDeg:function(e){return 180*e/Math.PI}}}(),function(){var e=document.createElement("canvas"),t=e.getContext("2d"),a=window.devicePixelRatio||1,n=t.webkitBackingStorePixelRatio||t.mozBackingStorePixelRatio||t.msBackingStorePixelRatio||t.oBackingStorePixelRatio||t.backingStorePixelRatio||1,i=a/n;Kinetic.Canvas=function(e,t,a){this.pixelRatio=a||i,this.width=e,this.height=t,this.element=document.createElement("canvas"),this.context=this.element.getContext("2d"),this.setSize(e||0,t||0)},Kinetic.Canvas.prototype={clear:function(){var e=this.getContext(),t=this.getElement();e.clearRect(0,0,t.width,t.height)},getElement:function(){return this.element},getContext:function(){return this.context},setWidth:function(e){this.width=e,this.element.width=e*this.pixelRatio,this.element.style.width=e+"px"},setHeight:function(e){this.height=e,this.element.height=e*this.pixelRatio,this.element.style.height=e+"px"},getWidth:function(){return this.width},getHeight:function(){return this.height},setSize:function(e,t){this.setWidth(e),this.setHeight(t)},toDataURL:function(e,t){try{return this.element.toDataURL(e,t)}catch(a){try{return this.element.toDataURL()}catch(a){return Kinetic.Global.warn("Unable to get data URL. "+a.message),""}}},fill:function(e){e.getFillEnabled()&&this._fill(e)},stroke:function(e){e.getStrokeEnabled()&&this._stroke(e)},fillStroke:function(e){var t=e.getFillEnabled();t&&this._fill(e),e.getStrokeEnabled()&&this._stroke(e,e.hasShadow()&&e.hasFill()&&t)},applyShadow:function(e,t){var a=this.context;a.save(),this._applyShadow(e),t(),a.restore(),t()},_applyLineCap:function(e){var t=e.getLineCap();t&&(this.context.lineCap=t)},_applyOpacity:function(e){var t=e.getAbsoluteOpacity();1!==t&&(this.context.globalAlpha=t)},_applyLineJoin:function(e){var t=e.getLineJoin();t&&(this.context.lineJoin=t)},_applyAncestorTransforms:function(e){var t=this.context;e._eachAncestorReverse(function(e){var a=e.getTransform(),n=a.getMatrix();t.transform(n[0],n[1],n[2],n[3],n[4],n[5])},!0)}},Kinetic.SceneCanvas=function(e,t,a){Kinetic.Canvas.call(this,e,t,a)},Kinetic.SceneCanvas.prototype={setWidth:function(e){var t=this.pixelRatio;Kinetic.Canvas.prototype.setWidth.call(this,e),this.context.scale(t,t)},setHeight:function(e){var t=this.pixelRatio;Kinetic.Canvas.prototype.setHeight.call(this,e),this.context.scale(t,t)},_fillColor:function(e){var t=this.context,a=e.getFill();t.fillStyle=a,e._fillFunc(t)},_fillPattern:function(e){var t=this.context,a=e.getFillPatternImage(),n=e.getFillPatternX(),i=e.getFillPatternY(),o=e.getFillPatternScale(),r=e.getFillPatternRotation(),s=e.getFillPatternOffset(),c=e.getFillPatternRepeat();(n||i)&&t.translate(n||0,i||0),r&&t.rotate(r),o&&t.scale(o.x,o.y),s&&t.translate(-1*s.x,-1*s.y),t.fillStyle=t.createPattern(a,c||"repeat"),t.fill()},_fillLinearGradient:function(e){for(var t=this.context,a=e.getFillLinearGradientStartPoint(),n=e.getFillLinearGradientEndPoint(),i=e.getFillLinearGradientColorStops(),o=t.createLinearGradient(a.x,a.y,n.x,n.y),r=0;r<i.length;r+=2)o.addColorStop(i[r],i[r+1]);t.fillStyle=o,t.fill()},_fillRadialGradient:function(e){for(var t=this.context,a=e.getFillRadialGradientStartPoint(),n=e.getFillRadialGradientEndPoint(),i=e.getFillRadialGradientStartRadius(),o=e.getFillRadialGradientEndRadius(),r=e.getFillRadialGradientColorStops(),s=t.createRadialGradient(a.x,a.y,i,n.x,n.y,o),c=0;c<r.length;c+=2)s.addColorStop(r[c],r[c+1]);t.fillStyle=s,t.fill()},_fill:function(e,t){var a=this.context,n=e.getFill(),i=e.getFillPatternImage(),o=e.getFillLinearGradientStartPoint(),r=e.getFillRadialGradientStartPoint(),s=e.getFillPriority();a.save(),!t&&e.hasShadow()&&this._applyShadow(e),n&&"color"===s?this._fillColor(e):i&&"pattern"===s?this._fillPattern(e):o&&"linear-gradient"===s?this._fillLinearGradient(e):r&&"radial-gradient"===s?this._fillRadialGradient(e):n?this._fillColor(e):i?this._fillPattern(e):o?this._fillLinearGradient(e):r&&this._fillRadialGradient(e),a.restore(),!t&&e.hasShadow()&&this._fill(e,!0)},_stroke:function(e,t){var a=this.context,n=e.getStroke(),i=e.getStrokeWidth(),o=e.getDashArray();(n||i)&&(a.save(),this._applyLineCap(e),o&&e.getDashArrayEnabled()&&(a.setLineDash?a.setLineDash(o):"mozDash"in a?a.mozDash=o:"webkitLineDash"in a&&(a.webkitLineDash=o)),!t&&e.hasShadow()&&this._applyShadow(e),a.lineWidth=i||2,a.strokeStyle=n||"black",e._strokeFunc(a),a.restore(),!t&&e.hasShadow()&&this._stroke(e,!0))},_applyShadow:function(e){var t=this.context;if(e.hasShadow()&&e.getShadowEnabled()){var a=e.getAbsoluteOpacity(),n=e.getShadowColor()||"black",i=e.getShadowBlur()||5,o=e.getShadowOffset()||{x:0,y:0};e.getShadowOpacity()&&(t.globalAlpha=e.getShadowOpacity()*a),t.shadowColor=n,t.shadowBlur=i,t.shadowOffsetX=o.x,t.shadowOffsetY=o.y}}},Kinetic.Global.extend(Kinetic.SceneCanvas,Kinetic.Canvas),Kinetic.HitCanvas=function(e,t,a){Kinetic.Canvas.call(this,e,t,a)},Kinetic.HitCanvas.prototype={_fill:function(e){var t=this.context;t.save(),t.fillStyle="#"+e.colorKey,e._fillFuncHit(t),t.restore()},_stroke:function(e){var t=this.context,a=e.getStroke(),n=e.getStrokeWidth();(a||n)&&(this._applyLineCap(e),t.save(),t.lineWidth=n||2,t.strokeStyle="#"+e.colorKey,e._strokeFuncHit(t),t.restore())}},Kinetic.Global.extend(Kinetic.HitCanvas,Kinetic.Canvas)}(),function(){Kinetic.Tween=function(e,t,a,n,i,o){this._listeners=[],this.addListener(this),this.obj=e,this.propFunc=t,this.begin=n,this._pos=n,this.setDuration(o),this.isPlaying=!1,this._change=0,this.prevTime=0,this.prevPos=0,this.looping=!1,this._time=0,this._position=0,this._startTime=0,this._finish=0,this.name="",this.func=a,this.setFinish(i)},Kinetic.Tween.prototype={setTime:function(e){this.prevTime=this._time,e>this.getDuration()?this.looping?(this.rewind(e-this._duration),this.update(),this.broadcastMessage("onLooped",{target:this,type:"onLooped"})):(this._time=this._duration,this.update(),this.stop(),this.broadcastMessage("onFinished",{target:this,type:"onFinished"})):0>e?(this.rewind(),this.update()):(this._time=e,this.update())},getTime:function(){return this._time},setDuration:function(e){this._duration=null===e||0>=e?1e5:e},getDuration:function(){return this._duration},setPosition:function(e){this.prevPos=this._pos,this.propFunc(e),this._pos=e,this.broadcastMessage("onChanged",{target:this,type:"onChanged"})},getPosition:function(e){return void 0===e&&(e=this._time),this.func(e,this.begin,this._change,this._duration)},setFinish:function(e){this._change=e-this.begin},getFinish:function(){return this.begin+this._change},start:function(){this.rewind(),this.startEnterFrame(),this.broadcastMessage("onStarted",{target:this,type:"onStarted"})},rewind:function(e){this.stop(),this._time=void 0===e?0:e,this.fixTime(),this.update()},fforward:function(){this._time=this._duration,this.fixTime(),this.update()},update:function(){this.setPosition(this.getPosition(this._time))},startEnterFrame:function(){this.stopEnterFrame(),this.isPlaying=!0,this.onEnterFrame()},onEnterFrame:function(){this.isPlaying&&this.nextFrame()},nextFrame:function(){this.setTime((this.getTimer()-this._startTime)/1e3)},stop:function(){this.stopEnterFrame(),this.broadcastMessage("onStopped",{target:this,type:"onStopped"})},stopEnterFrame:function(){this.isPlaying=!1},continueTo:function(e,t){this.begin=this._pos,this.setFinish(e),void 0!==this._duration&&this.setDuration(t),this.start()},resume:function(){this.fixTime(),this.startEnterFrame(),this.broadcastMessage("onResumed",{target:this,type:"onResumed"})},yoyo:function(){this.continueTo(this.begin,this._time)},addListener:function(e){return this.removeListener(e),this._listeners.push(e)},removeListener:function(e){for(var t=this._listeners,a=t.length;a--;)if(t[a]==e)return t.splice(a,1),!0;return!1},broadcastMessage:function(){for(var e=[],t=0;t<arguments.length;t++)e.push(arguments[t]);for(var a=e.shift(),n=this._listeners,i=n.length,t=0;i>t;t++)n[t][a]&&n[t][a].apply(n[t],e)},fixTime:function(){this._startTime=this.getTimer()-1e3*this._time},getTimer:function(){return(new Date).getTime()-this._time}},Kinetic.Tweens={"back-ease-in":function(e,t,a,n,i,o){var r=1.70158;return a*(e/=n)*e*((r+1)*e-r)+t},"back-ease-out":function(e,t,a,n,i,o){var r=1.70158;return a*((e=e/n-1)*e*((r+1)*e+r)+1)+t},"back-ease-in-out":function(e,t,a,n,i,o){var r=1.70158;return(e/=n/2)<1?a/2*(e*e*(((r*=1.525)+1)*e-r))+t:a/2*((e-=2)*e*(((r*=1.525)+1)*e+r)+2)+t},"elastic-ease-in":function(e,t,a,n,i,o){var r=0;return 0===e?t:1==(e/=n)?t+a:(o||(o=.3*n),!i||i<Math.abs(a)?(i=a,r=o/4):r=o/(2*Math.PI)*Math.asin(a/i),-(i*Math.pow(2,10*(e-=1))*Math.sin((e*n-r)*(2*Math.PI)/o))+t)},"elastic-ease-out":function(e,t,a,n,i,o){var r=0;return 0===e?t:1==(e/=n)?t+a:(o||(o=.3*n),!i||i<Math.abs(a)?(i=a,r=o/4):r=o/(2*Math.PI)*Math.asin(a/i),i*Math.pow(2,-10*e)*Math.sin((e*n-r)*(2*Math.PI)/o)+a+t)},"elastic-ease-in-out":function(e,t,a,n,i,o){var r=0;return 0===e?t:2==(e/=n/2)?t+a:(o||(o=n*(.3*1.5)),!i||i<Math.abs(a)?(i=a,r=o/4):r=o/(2*Math.PI)*Math.asin(a/i),1>e?-.5*(i*Math.pow(2,10*(e-=1))*Math.sin((e*n-r)*(2*Math.PI)/o))+t:i*Math.pow(2,-10*(e-=1))*Math.sin((e*n-r)*(2*Math.PI)/o)*.5+a+t)},"bounce-ease-out":function(e,t,a,n){return(e/=n)<1/2.75?a*(7.5625*e*e)+t:2/2.75>e?a*(7.5625*(e-=1.5/2.75)*e+.75)+t:2.5/2.75>e?a*(7.5625*(e-=2.25/2.75)*e+.9375)+t:a*(7.5625*(e-=2.625/2.75)*e+.984375)+t},"bounce-ease-in":function(e,t,a,n){return a-Kinetic.Tweens["bounce-ease-out"](n-e,0,a,n)+t},"bounce-ease-in-out":function(e,t,a,n){return n/2>e?.5*Kinetic.Tweens["bounce-ease-in"](2*e,0,a,n)+t:.5*Kinetic.Tweens["bounce-ease-out"](2*e-n,0,a,n)+.5*a+t},"ease-in":function(e,t,a,n){return a*(e/=n)*e+t},"ease-out":function(e,t,a,n){return-a*(e/=n)*(e-2)+t},"ease-in-out":function(e,t,a,n){return(e/=n/2)<1?a/2*e*e+t:-a/2*(--e*(e-2)-1)+t},"strong-ease-in":function(e,t,a,n){return a*(e/=n)*e*e*e*e+t},"strong-ease-out":function(e,t,a,n){return a*((e=e/n-1)*e*e*e*e+1)+t},"strong-ease-in-out":function(e,t,a,n){return(e/=n/2)<1?a/2*e*e*e*e*e+t:a/2*((e-=2)*e*e*e*e+2)+t},linear:function(e,t,a,n){return a*e/n+t}}}(),function(){Kinetic.Transform=function(){this.m=[1,0,0,1,0,0]},Kinetic.Transform.prototype={translate:function(e,t){this.m[4]+=this.m[0]*e+this.m[2]*t,this.m[5]+=this.m[1]*e+this.m[3]*t},scale:function(e,t){this.m[0]*=e,this.m[1]*=e,this.m[2]*=t,this.m[3]*=t},rotate:function(e){var t=Math.cos(e),a=Math.sin(e),n=this.m[0]*t+this.m[2]*a,i=this.m[1]*t+this.m[3]*a,o=this.m[0]*-a+this.m[2]*t,r=this.m[1]*-a+this.m[3]*t;this.m[0]=n,this.m[1]=i,this.m[2]=o,this.m[3]=r},getTranslation:function(){return{x:this.m[4],y:this.m[5]}},multiply:function(e){var t=this.m[0]*e.m[0]+this.m[2]*e.m[1],a=this.m[1]*e.m[0]+this.m[3]*e.m[1],n=this.m[0]*e.m[2]+this.m[2]*e.m[3],i=this.m[1]*e.m[2]+this.m[3]*e.m[3],o=this.m[0]*e.m[4]+this.m[2]*e.m[5]+this.m[4],r=this.m[1]*e.m[4]+this.m[3]*e.m[5]+this.m[5];this.m[0]=t,this.m[1]=a,this.m[2]=n,this.m[3]=i,this.m[4]=o,this.m[5]=r},invert:function(){var e=1/(this.m[0]*this.m[3]-this.m[1]*this.m[2]),t=this.m[3]*e,a=-this.m[1]*e,n=-this.m[2]*e,i=this.m[0]*e,o=e*(this.m[2]*this.m[5]-this.m[3]*this.m[4]),r=e*(this.m[1]*this.m[4]-this.m[0]*this.m[5]);this.m[0]=t,this.m[1]=a,this.m[2]=n,this.m[3]=i,this.m[4]=o,this.m[5]=r},getMatrix:function(){return this.m}}}(),function(){Kinetic.Collection=function(){var e=[].slice.call(arguments),t=e.length,a=0;for(this.length=t;t>a;a++)this[a]=e[a];return this},Kinetic.Collection.prototype=new Array,Kinetic.Collection.prototype.apply=function(e){args=[].slice.call(arguments),args.shift();for(var t=0;t<this.length;t++)Kinetic.Type._isFunction(this[t][e])&&this[t][e].apply(this[t],args)},Kinetic.Collection.prototype.each=function(e){for(var t=0;t<this.length;t++)e.call(this[t],t,this[t])}}(),function(){Kinetic.Filters.Grayscale=function(e,t){for(var a=e.data,n=0;n<a.length;n+=4){var i=.34*a[n]+.5*a[n+1]+.16*a[n+2];a[n]=i,a[n+1]=i,a[n+2]=i}}}(),function(){Kinetic.Filters.Brighten=function(e,t){for(var a=t.val||0,n=e.data,i=0;i<n.length;i+=4)n[i]+=a,n[i+1]+=a,n[i+2]+=a}}(),function(){Kinetic.Filters.Invert=function(e,t){for(var a=e.data,n=0;n<a.length;n+=4)a[n]=255-a[n],a[n+1]=255-a[n+1],a[n+2]=255-a[n+2]}}(),function(){Kinetic.Node=function(e){this._nodeInit(e)},Kinetic.Node.prototype={_nodeInit:function(e){this._id=Kinetic.Global.idCounter++,this.defaultNodeAttrs={visible:!0,listening:!0,name:void 0,opacity:1,x:0,y:0,scale:{x:1,y:1},rotation:0,offset:{x:0,y:0},draggable:!1,dragOnTop:!0},this.setDefaultAttrs(this.defaultNodeAttrs),this.eventListeners={},this.setAttrs(e)},on:function(e,t){for(var a=e.split(" "),n=a.length,i=0;n>i;i++){var o=a[i],r=o,s=r.split("."),c=s[0],d=s.length>1?s[1]:"";this.eventListeners[c]||(this.eventListeners[c]=[]),this.eventListeners[c].push({name:d,handler:t})}},off:function(e){for(var t=e.split(" "),a=t.length,n=0;a>n;n++){var i=t[n],o=i,r=o.split("."),s=r[0];if(r.length>1)if(s)this.eventListeners[s]&&this._off(s,r[1]);else for(var i in this.eventListeners)this._off(i,r[1]);else delete this.eventListeners[s]}},remove:function(){var e=this.getParent();e&&e.children&&(e.children.splice(this.index,1),e._setChildrenIndices()),delete this.parent},destroy:function(){for(var e=(this.getParent(),this.getStage(),Kinetic.DD),t=Kinetic.Global;this.children&&this.children.length>0;)this.children[0].destroy();t._removeId(this.getId()),t._removeName(this.getName(),this._id),e&&e.node&&e.node._id===this._id&&node._endDrag(),this.trans&&this.trans.stop(),this.remove()},getAttrs:function(){return this.attrs},setDefaultAttrs:function(e){if(void 0===this.attrs&&(this.attrs={}),e)for(var t in e)void 0===this.attrs[t]&&(this.attrs[t]=e[t])},setAttrs:function(e){if(e)for(var t in e){var a="set"+t.charAt(0).toUpperCase()+t.slice(1);Kinetic.Type._isFunction(this[a])?this[a](e[t]):this.setAttr(t,e[t])}},getVisible:function(){var e=this.attrs.visible,t=this.getParent();return e&&t&&!t.getVisible()?!1:e},getListening:function(){var e=this.attrs.listening,t=this.getParent();return e&&t&&!t.getListening()?!1:e},show:function(){this.setVisible(!0)},hide:function(){this.setVisible(!1)},getZIndex:function(){return this.index},getAbsoluteZIndex:function(){function e(i){for(var o=[],r=i.length,s=0;r>s;s++){var c=i[s];n++,"Shape"!==c.nodeType&&(o=o.concat(c.getChildren())),c._id===a._id&&(s=r)}o.length>0&&o[0].getLevel()<=t&&e(o)}var t=this.getLevel(),a=(this.getStage(),this),n=0;return"Stage"!==a.nodeType&&e(a.getStage().getChildren()),n},getLevel:function(){for(var e=0,t=this.parent;t;)e++,t=t.parent;return e},setPosition:function(){var e=Kinetic.Type._getXY([].slice.call(arguments));this.setAttr("x",e.x),this.setAttr("y",e.y)},getPosition:function(){var e=this.attrs;return{x:e.x,y:e.y}},getAbsolutePosition:function(){var e=this.getAbsoluteTransform(),t=this.getOffset();return e.translate(t.x,t.y),e.getTranslation()},setAbsolutePosition:function(){var e=Kinetic.Type._getXY([].slice.call(arguments)),t=this._clearTransform();this.attrs.x=t.x,this.attrs.y=t.y,delete t.x,delete t.y;var a=this.getAbsoluteTransform();a.invert(),a.translate(e.x,e.y),e={x:this.attrs.x+a.getTranslation().x,y:this.attrs.y+a.getTranslation().y},this.setPosition(e.x,e.y),this._setTransform(t)},move:function(){var e=Kinetic.Type._getXY([].slice.call(arguments)),t=this.getX(),a=this.getY();void 0!==e.x&&(t+=e.x),void 0!==e.y&&(a+=e.y),this.setPosition(t,a)},_eachAncestorReverse:function(e,t){var a=[],n=this.getParent();for(t&&a.unshift(this);n;)a.unshift(n),n=n.parent;for(var i=a.length,o=0;i>o;o++)e(a[o])},rotate:function(e){this.setRotation(this.getRotation()+e)},rotateDeg:function(e){this.setRotation(this.getRotation()+Kinetic.Type._degToRad(e))},moveToTop:function(){var e=this.index;return this.parent.children.splice(e,1),this.parent.children.push(this),this.parent._setChildrenIndices(),!0},moveUp:function(){var e=this.index,t=this.parent.getChildren().length;return t-1>e?(this.parent.children.splice(e,1),this.parent.children.splice(e+1,0,this),this.parent._setChildrenIndices(),!0):void 0},moveDown:function(){var e=this.index;return e>0?(this.parent.children.splice(e,1),this.parent.children.splice(e-1,0,this),this.parent._setChildrenIndices(),!0):void 0},moveToBottom:function(){var e=this.index;return e>0?(this.parent.children.splice(e,1),this.parent.children.unshift(this),this.parent._setChildrenIndices(),!0):void 0},setZIndex:function(e){var t=this.index;this.parent.children.splice(t,1),this.parent.children.splice(e,0,this),this.parent._setChildrenIndices()},getAbsoluteOpacity:function(){var e=this.getOpacity();return this.getParent()&&(e*=this.getParent().getAbsoluteOpacity()),e},moveTo:function(e){Kinetic.Node.prototype.remove.call(this),e.add(this)},toObject:function(){var e=Kinetic.Type,t={},a=this.attrs;t.attrs={};for(var n in a){var i=a[n];e._isFunction(i)||e._isElement(i)||e._isObject(i)&&e._hasMethods(i)||(t.attrs[n]=i)}return t.nodeType=this.nodeType,t.shapeType=this.shapeType,t},toJSON:function(){return JSON.stringify(this.toObject())},getParent:function(){return this.parent},getLayer:function(){return this.getParent().getLayer()},getStage:function(){return this.getParent()?this.getParent().getStage():void 0},simulate:function(e,t){this._handleEvent(e,t||{})},fire:function(e,t){this._executeHandlers(e,t||{})},getAbsoluteTransform:function(){var e=new Kinetic.Transform;return this._eachAncestorReverse(function(t){var a=t.getTransform();e.multiply(a)},!0),e},getTransform:function(){var e=new Kinetic.Transform,t=this.attrs,a=t.x,n=t.y,i=t.rotation,o=t.scale,r=o.x,s=o.y,c=t.offset,d=c.x,l=c.y;return(0!==a||0!==n)&&e.translate(a,n),0!==i&&e.rotate(i),(1!==r||1!==s)&&e.scale(r,s),(0!==d||0!==l)&&e.translate(-1*d,-1*l),e},clone:function(e){var t=this.shapeType||this.nodeType,a=new Kinetic[t](this.attrs);for(var n in this.eventListeners)for(var i=this.eventListeners[n],o=i.length,r=0;o>r;r++){var s=i[r];s.name.indexOf("kinetic")<0&&(a.eventListeners[n]||(a.eventListeners[n]=[]),a.eventListeners[n].push(s))}return a.setAttrs(e),a},toDataURL:function(e){e=e||{};var t,a,n=e.mimeType||null,i=e.quality||null,o=e.x||0,r=e.y||0;return e.width&&e.height?t=new Kinetic.SceneCanvas(e.width,e.height,1):(t=this.getStage().bufferCanvas,t.clear()),a=t.getContext(),a.save(),(o||r)&&a.translate(-1*o,-1*r),this.drawScene(t),a.restore(),t.toDataURL(n,i)},toImage:function(e){Kinetic.Type._getImage(this.toDataURL(e),function(t){e.callback(t)})},setSize:function(){var e=Kinetic.Type._getSize(Array.prototype.slice.call(arguments));this.setWidth(e.width),this.setHeight(e.height)},getSize:function(){return{width:this.getWidth(),height:this.getHeight()}},getWidth:function(){return this.attrs.width||0},getHeight:function(){return this.attrs.height||0},_get:function(e){return this.nodeType===e?[this]:[]},_off:function(e,t){for(var a=0;a<this.eventListeners[e].length;a++)if(this.eventListeners[e][a].name===t){if(this.eventListeners[e].splice(a,1),0===this.eventListeners[e].length){delete this.eventListeners[e];break}a--}},_clearTransform:function(){var e=this.attrs,t=e.scale,a=e.offset,n={x:e.x,y:e.y,rotation:e.rotation,scale:{x:t.x,y:t.y},offset:{x:a.x,y:a.y}};return this.attrs.x=0,this.attrs.y=0,this.attrs.rotation=0,this.attrs.scale={x:1,y:1},this.attrs.offset={x:0,y:0},n},_setTransform:function(e){for(var t in e)this.attrs[t]=e[t]},_fireBeforeChangeEvent:function(e,t,a){this._handleEvent("before"+e.toUpperCase()+"Change",{oldVal:t,newVal:a})},_fireChangeEvent:function(e,t,a){this._handleEvent(e+"Change",{oldVal:t,newVal:a})},setId:function(e){var t=this.getId(),a=(this.getStage(),Kinetic.Global);a._removeId(t),a._addId(this,e),this.setAttr("id",e)},setName:function(e){var t=this.getName(),a=(this.getStage(),Kinetic.Global);a._removeName(t,this._id),a._addName(this,e),this.setAttr("name",e)},setAttr:function(e,t){if(void 0!==t){var a=this.attrs[e];this._fireBeforeChangeEvent(e,a,t),this.attrs[e]=t,this._fireChangeEvent(e,a,t)}},_handleEvent:function(e,t,a){t&&"Shape"===this.nodeType&&(t.shape=this);var n=(this.getStage(),this.eventListeners),i=!0;"mouseenter"===e&&a&&this._id===a._id?i=!1:"mouseleave"===e&&a&&this._id===a._id&&(i=!1),i&&(n[e]&&this.fire(e,t),t&&!t.cancelBubble&&this.parent&&(a&&a.parent?this._handleEvent.call(this.parent,e,t,a.parent):this._handleEvent.call(this.parent,e,t)))},_executeHandlers:function(e,t){for(var a=this.eventListeners[e],n=a.length,i=0;n>i;i++)a[i].handler.apply(this,[t])}},Kinetic.Node.addSetters=function(e,t){for(var a=t.length,n=0;a>n;n++){var i=t[n];this._addSetter(e,i)}},Kinetic.Node.addPointSetters=function(e,t){for(var a=t.length,n=0;a>n;n++){var i=t[n];this._addPointSetter(e,i)}},Kinetic.Node.addRotationSetters=function(e,t){for(var a=t.length,n=0;a>n;n++){var i=t[n];this._addRotationSetter(e,i)}},Kinetic.Node.addGetters=function(e,t){for(var a=t.length,n=0;a>n;n++){var i=t[n];this._addGetter(e,i)}},Kinetic.Node.addRotationGetters=function(e,t){for(var a=t.length,n=0;a>n;n++){var i=t[n];this._addRotationGetter(e,i)}},Kinetic.Node.addGettersSetters=function(e,t){this.addSetters(e,t),this.addGetters(e,t)},Kinetic.Node.addPointGettersSetters=function(e,t){this.addPointSetters(e,t),this.addGetters(e,t)},Kinetic.Node.addRotationGettersSetters=function(e,t){this.addRotationSetters(e,t),this.addRotationGetters(e,t)},Kinetic.Node._addSetter=function(e,t){var a="set"+t.charAt(0).toUpperCase()+t.slice(1);e.prototype[a]=function(e){this.setAttr(t,e)}},Kinetic.Node._addPointSetter=function(e,t){var a="set"+t.charAt(0).toUpperCase()+t.slice(1);e.prototype[a]=function(){var e=Kinetic.Type._getXY([].slice.call(arguments));e&&void 0===e.x&&(e.x=this.attrs[t].x),e&&void 0===e.y&&(e.y=this.attrs[t].y),this.setAttr(t,e)}},Kinetic.Node._addRotationSetter=function(e,t){var a="set"+t.charAt(0).toUpperCase()+t.slice(1);e.prototype[a]=function(e){this.setAttr(t,e)},e.prototype[a+"Deg"]=function(e){this.setAttr(t,Kinetic.Type._degToRad(e))}},Kinetic.Node._addGetter=function(e,t){var a="get"+t.charAt(0).toUpperCase()+t.slice(1);e.prototype[a]=function(e){return this.attrs[t]}},Kinetic.Node._addRotationGetter=function(e,t){var a="get"+t.charAt(0).toUpperCase()+t.slice(1);e.prototype[a]=function(){return this.attrs[t]},e.prototype[a+"Deg"]=function(){return Kinetic.Type._radToDeg(this.attrs[t])}},Kinetic.Node.create=function(e,t){return this._createNode(JSON.parse(e),t)},Kinetic.Node._createNode=function(e,t){var a;a="Shape"===e.nodeType?void 0===e.shapeType?"Shape":e.shapeType:e.nodeType,t&&(e.attrs.container=t);var n=new Kinetic[a](e.attrs);if(e.children)for(var i=e.children.length,o=0;i>o;o++)n.add(this._createNode(e.children[o]));return n},Kinetic.Node.addGettersSetters(Kinetic.Node,["x","y","opacity"]),Kinetic.Node.addGetters(Kinetic.Node,["name","id"]),Kinetic.Node.addRotationGettersSetters(Kinetic.Node,["rotation"]),Kinetic.Node.addPointGettersSetters(Kinetic.Node,["scale","offset"]),Kinetic.Node.addSetters(Kinetic.Node,["width","height","listening","visible"]),Kinetic.Node.prototype.isListening=Kinetic.Node.prototype.getListening,Kinetic.Node.prototype.isVisible=Kinetic.Node.prototype.getVisible;for(var e=["on","off"],t=0;2>t;t++)!function(t){var a=e[t];Kinetic.Collection.prototype[a]=function(){var e=[].slice.call(arguments);e.unshift(a),this.apply.apply(this,e)}}(t)}(),function(){Kinetic.Animation=function(e,t){this.func=e,this.node=t,
this.id=Kinetic.Animation.animIdCounter++,this.frame={time:0,timeDiff:0,lastTime:(new Date).getTime()}},Kinetic.Animation.prototype={isRunning:function(){for(var e=Kinetic.Animation,t=e.animations,a=0;a<t.length;a++)if(t[a].id===this.id)return!0;return!1},start:function(){this.stop(),this.frame.timeDiff=0,this.frame.lastTime=(new Date).getTime(),Kinetic.Animation._addAnimation(this)},stop:function(){Kinetic.Animation._removeAnimation(this)},_updateFrameObject:function(e){this.frame.timeDiff=e-this.frame.lastTime,this.frame.lastTime=e,this.frame.time+=this.frame.timeDiff,this.frame.frameRate=1e3/this.frame.timeDiff}},Kinetic.Animation.animations=[],Kinetic.Animation.animIdCounter=0,Kinetic.Animation.animRunning=!1,Kinetic.Animation.fixedRequestAnimFrame=function(e){window.setTimeout(e,1e3/60)},Kinetic.Animation._addAnimation=function(e){this.animations.push(e),this._handleAnimation()},Kinetic.Animation._removeAnimation=function(e){for(var t=e.id,a=this.animations,n=a.length,i=0;n>i;i++)if(a[i].id===t){this.animations.splice(i,1);break}},Kinetic.Animation._runFrames=function(){for(var e={},t=this.animations,a=0;a<t.length;a++){var n=t[a],i=n.node,o=n.func;n._updateFrameObject((new Date).getTime()),i&&void 0!==i._id&&(e[i._id]=i),o&&o(n.frame)}for(var r in e)e[r].draw()},Kinetic.Animation._animationLoop=function(){var e=this;this.animations.length>0?(this._runFrames(),Kinetic.Animation.requestAnimFrame(function(){e._animationLoop()})):this.animRunning=!1},Kinetic.Animation._handleAnimation=function(){var e=this;this.animRunning||(this.animRunning=!0,e._animationLoop())},RAF=function(){return window.requestAnimationFrame||window.webkitRequestAnimationFrame||window.mozRequestAnimationFrame||window.oRequestAnimationFrame||window.msRequestAnimationFrame||Kinetic.Animation.fixedRequestAnimFrame}(),Kinetic.Animation.requestAnimFrame=function(e){var t=Kinetic.DD&&Kinetic.DD.moving?this.fixedRequestAnimFrame:RAF;t(e)};var e=Kinetic.Node.prototype.moveTo;Kinetic.Node.prototype.moveTo=function(t){e.call(this,t)}}(),function(){Kinetic.DD={anim:new Kinetic.Animation,moving:!1,offset:{x:0,y:0}},Kinetic.getNodeDragging=function(){return Kinetic.DD.node},Kinetic.DD._setupDragLayerAndGetContainer=function(e){var t,a,n=e.getStage();e.nodeType;return e._eachAncestorReverse(function(e){"Layer"===e.nodeType?(n.dragLayer.setAttrs(e.getAttrs()),t=n.dragLayer,n.add(n.dragLayer)):"Group"===e.nodeType&&(a=new Kinetic.Group(e.getAttrs()),t.add(a),t=a)}),t},Kinetic.DD._initDragLayer=function(e){e.dragLayer=new Kinetic.Layer,e.dragLayer.getCanvas().getElement().className="kinetic-drag-and-drop-layer"},Kinetic.DD._drag=function(e){var t=Kinetic.DD,a=t.node;if(a){var n=a.getStage().getUserPosition(),i=a.attrs.dragBoundFunc,o={x:n.x-t.offset.x,y:n.y-t.offset.y};void 0!==i&&(o=i.call(a,o,e)),a.setAbsolutePosition(o),t.moving||(t.moving=!0,a.setListening(!1),a._handleEvent("dragstart",e)),a._handleEvent("dragmove",e)}},Kinetic.DD._endDrag=function(e){var t=Kinetic.DD,a=t.node;if(a){var n=a.nodeType;a.getStage();a.setListening(!0),"Stage"===n?a.draw():(("Group"===n||"Shape"===n)&&a.getDragOnTop()&&t.prevParent&&(a.moveTo(t.prevParent),a.getStage().dragLayer.remove(),t.prevParent=null),a.getLayer().draw()),delete t.node,t.anim.stop(),t.moving&&(t.moving=!1,a._handleEvent("dragend",e))}},Kinetic.Node.prototype._startDrag=function(e){var t=Kinetic.DD,a=this,n=this.getStage(),i=n.getUserPosition();if(i){var o,r=(this.getTransform().getTranslation(),this.getAbsolutePosition()),s=this.nodeType;t.node=this,t.offset.x=i.x-r.x,t.offset.y=i.y-r.y,"Stage"===s||"Layer"===s?(t.anim.node=this,t.anim.start()):this.getDragOnTop()?(o=t._setupDragLayerAndGetContainer(this),t.anim.node=n.dragLayer,t.prevParent=this.getParent(),setTimeout(function(){t.node&&(a.moveTo(o),t.prevParent.getLayer().draw(),n.dragLayer.draw(),t.anim.start())},0)):(t.anim.node=this.getLayer(),t.anim.start())}},Kinetic.Node.prototype.setDraggable=function(e){this.setAttr("draggable",e),this._dragChange()},Kinetic.Node.prototype.getDraggable=function(){return this.attrs.draggable},Kinetic.Node.prototype.isDragging=function(){var e=Kinetic.DD;return e.node&&e.node._id===this._id&&e.moving},Kinetic.Node.prototype._listenDrag=function(){this._dragCleanup();var e=this;this.on("mousedown.kinetic touchstart.kinetic",function(t){Kinetic.getNodeDragging()||e._startDrag(t)})},Kinetic.Node.prototype._dragChange=function(){if(this.attrs.draggable)this._listenDrag();else{this._dragCleanup();var e=this.getStage(),t=Kinetic.DD;e&&t.node&&t.node._id===this._id&&t._endDrag()}},Kinetic.Node.prototype._dragCleanup=function(){this.off("mousedown.kinetic"),this.off("touchstart.kinetic")},Kinetic.Node.prototype.isDraggable=Kinetic.Node.prototype.getDraggable,Kinetic.Node.addGettersSetters(Kinetic.Node,["dragBoundFunc","dragOnTop"]);var e=document.getElementsByTagName("html")[0];e.addEventListener("mouseup",Kinetic.DD._endDrag,!0),e.addEventListener("touchend",Kinetic.DD._endDrag,!0)}(),function(){Kinetic.Transition=function(e,t){function a(e,t,i,o){for(var r in e)"duration"!==r&&"easing"!==r&&"callback"!==r&&(Kinetic.Type._isObject(e[r])?(i[r]={},a(e[r],t[r],i[r],o)):n._add(n._getTween(t,r,e[r],i,o)))}var n=this,i={};this.node=e,this.config=t,this.tweens=[],a(t,e.attrs,i,i),this.tweens[0].onStarted=function(){},this.tweens[0].onStopped=function(){e.transAnim.stop()},this.tweens[0].onResumed=function(){e.transAnim.start()},this.tweens[0].onLooped=function(){},this.tweens[0].onChanged=function(){},this.tweens[0].onFinished=function(){var a={};for(var n in t)"duration"!==n&&"easing"!==n&&"callback"!==n&&(a[n]=t[n]);e.transAnim.stop(),e.setAttrs(a),t.callback&&t.callback()}},Kinetic.Transition.prototype={start:function(){for(var e=0;e<this.tweens.length;e++)this.tweens[e].start()},stop:function(){for(var e=0;e<this.tweens.length;e++)this.tweens[e].stop()},resume:function(){for(var e=0;e<this.tweens.length;e++)this.tweens[e].resume()},_onEnterFrame:function(){for(var e=0;e<this.tweens.length;e++)this.tweens[e].onEnterFrame()},_add:function(e){this.tweens.push(e)},_getTween:function(e,t,a,n,i){var o=this.config,r=this.node,s=o.easing;void 0===s&&(s="linear");var c=new Kinetic.Tween(r,function(e){n[t]=e,r.setAttrs(i)},Kinetic.Tweens[s],e[t],a,o.duration);return c}},Kinetic.Node.prototype.transitionTo=function(e){var t=new Kinetic.Transition(this,e);return this.transAnim||(this.transAnim=new Kinetic.Animation),this.transAnim.func=function(){t._onEnterFrame()},this.transAnim.node="Stage"===this.nodeType?this:this.getLayer(),t.start(),this.transAnim.start(),this.trans=t,t}}(),function(){Kinetic.Container=function(e){this._containerInit(e)},Kinetic.Container.prototype={_containerInit:function(e){this.children=[],Kinetic.Node.call(this,e)},getChildren:function(){return this.children},removeChildren:function(){for(;this.children.length>0;)this.children[0].remove()},add:function(e){var t=(Kinetic.Global,this.children);return e.index=t.length,e.parent=this,t.push(e),this},get:function(e){var t=new Kinetic.Collection;if("#"===e.charAt(0)){var a=this._getNodeById(e.slice(1));a&&t.push(a)}else if("."===e.charAt(0)){var n=this._getNodesByName(e.slice(1));Kinetic.Collection.apply(t,n)}else{for(var i=[],o=this.getChildren(),r=o.length,s=0;r>s;s++)i=i.concat(o[s]._get(e));Kinetic.Collection.apply(t,i)}return t},_getNodeById:function(e){var t=(this.getStage(),Kinetic.Global),a=t.ids[e];return void 0!==a&&this.isAncestorOf(a)?a:null},_getNodesByName:function(e){var t=Kinetic.Global,a=t.names[e]||[];return this._getDescendants(a)},_get:function(e){for(var t=Kinetic.Node.prototype._get.call(this,e),a=this.getChildren(),n=a.length,i=0;n>i;i++)t=t.concat(a[i]._get(e));return t},toObject:function(){var e=Kinetic.Node.prototype.toObject.call(this);e.children=[];for(var t=this.getChildren(),a=t.length,n=0;a>n;n++){var i=t[n];e.children.push(i.toObject())}return e},_getDescendants:function(e){for(var t=[],a=e.length,n=0;a>n;n++){var i=e[n];this.isAncestorOf(i)&&t.push(i)}return t},isAncestorOf:function(e){for(var t=e.getParent();t;){if(t._id===this._id)return!0;t=t.getParent()}return!1},clone:function(e){var t=Kinetic.Node.prototype.clone.call(this,e);for(var a in this.children)t.add(this.children[a].clone());return t},getIntersections:function(){for(var e=Kinetic.Type._getXY(Array.prototype.slice.call(arguments)),t=[],a=this.get("Shape"),n=a.length,i=0;n>i;i++){var o=a[i];o.isVisible()&&o.intersects(e)&&t.push(o)}return t},_setChildrenIndices:function(){for(var e=this.children,t=e.length,a=0;t>a;a++)e[a].index=a},draw:function(){this.drawScene(),this.drawHit()},drawScene:function(e){if(this.isVisible())for(var t=this.children,a=t.length,n=0;a>n;n++)t[n].drawScene(e)},drawHit:function(){if(this.isVisible()&&this.isListening())for(var e=this.children,t=e.length,a=0;t>a;a++)e[a].drawHit()}},Kinetic.Global.extend(Kinetic.Container,Kinetic.Node)}(),function(){function e(e){e.fill()}function t(e){e.stroke()}function a(e){e.fill()}function n(e){e.stroke()}Kinetic.Shape=function(e){this._initShape(e)},Kinetic.Shape.prototype={_initShape:function(i){this.setDefaultAttrs({fillEnabled:!0,strokeEnabled:!0,shadowEnabled:!0,dashArrayEnabled:!0,fillPriority:"color"}),this.nodeType="Shape",this._fillFunc=e,this._strokeFunc=t,this._fillFuncHit=a,this._strokeFuncHit=n;for(var o,r=Kinetic.Global.shapes;;)if(o=Kinetic.Type._getRandomColorKey(),o&&!(o in r))break;this.colorKey=o,r[o]=this,Kinetic.Node.call(this,i)},getContext:function(){return this.getLayer().getContext()},getCanvas:function(){return this.getLayer().getCanvas()},hasShadow:function(){return!!(this.getShadowColor()||this.getShadowBlur()||this.getShadowOffset())},hasFill:function(){return!!(this.getFill()||this.getFillPatternImage()||this.getFillLinearGradientStartPoint()||this.getFillRadialGradientStartPoint())},_get:function(e){return this.nodeType===e||this.shapeType===e?[this]:[]},intersects:function(){var e=Kinetic.Type._getXY(Array.prototype.slice.call(arguments)),t=this.getStage(),a=t.hitCanvas;a.clear(),this.drawScene(a);var n=a.context.getImageData(Math.round(e.x),Math.round(e.y),1,1).data;return n[3]>0},enableFill:function(){this.setAttr("fillEnabled",!0)},disableFill:function(){this.setAttr("fillEnabled",!1)},enableStroke:function(){this.setAttr("strokeEnabled",!0)},disableStroke:function(){this.setAttr("strokeEnabled",!1)},enableShadow:function(){this.setAttr("shadowEnabled",!0)},disableShadow:function(){this.setAttr("shadowEnabled",!1)},enableDashArray:function(){this.setAttr("dashArrayEnabled",!0)},disableDashArray:function(){this.setAttr("dashArrayEnabled",!1)},remove:function(){Kinetic.Node.prototype.remove.call(this),delete Kinetic.Global.shapes[this.colorKey]},drawScene:function(e){var t=this.attrs,a=t.drawFunc,e=e||this.getLayer().getCanvas(),n=e.getContext();a&&this.isVisible()&&(n.save(),e._applyOpacity(this),e._applyLineJoin(this),e._applyAncestorTransforms(this),a.call(this,e),n.restore())},drawHit:function(){var e=this.attrs,t=e.drawHitFunc||e.drawFunc,a=this.getLayer().hitCanvas,n=a.getContext();t&&this.isVisible()&&this.isListening()&&(n.save(),a._applyLineJoin(this),a._applyAncestorTransforms(this),t.call(this,a),n.restore())},_setDrawFuncs:function(){!this.attrs.drawFunc&&this.drawFunc&&this.setDrawFunc(this.drawFunc),!this.attrs.drawHitFunc&&this.drawHitFunc&&this.setDrawHitFunc(this.drawHitFunc)}},Kinetic.Global.extend(Kinetic.Shape,Kinetic.Node),Kinetic.Node.addGettersSetters(Kinetic.Shape,["stroke","lineJoin","lineCap","strokeWidth","drawFunc","drawHitFunc","dashArray","shadowColor","shadowBlur","shadowOpacity","fillPatternImage","fill","fillPatternX","fillPatternY","fillLinearGradientColorStops","fillRadialGradientStartRadius","fillRadialGradientEndRadius","fillRadialGradientColorStops","fillPatternRepeat","fillEnabled","strokeEnabled","shadowEnabled","dashArrayEnabled","fillPriority"]),Kinetic.Node.addPointGettersSetters(Kinetic.Shape,["fillPatternOffset","fillPatternScale","fillLinearGradientStartPoint","fillLinearGradientEndPoint","fillRadialGradientStartPoint","fillRadialGradientEndPoint","shadowOffset"]),Kinetic.Node.addRotationGettersSetters(Kinetic.Shape,["fillPatternRotation"])}(),function(){Kinetic.Stage=function(e){this._initStage(e)},Kinetic.Stage.prototype={_initStage:function(e){var t=Kinetic.DD;this.setDefaultAttrs({width:400,height:200}),Kinetic.Container.call(this,e),this._setStageDefaultProperties(),this._id=Kinetic.Global.idCounter++,this._buildDOM(),this._bindContentEvents(),Kinetic.Global.stages.push(this),t&&t._initDragLayer(this)},setContainer:function(e){"string"==typeof e&&(e=document.getElementById(e)),this.setAttr("container",e)},setHeight:function(e){Kinetic.Node.prototype.setHeight.call(this,e),this._resizeDOM()},setWidth:function(e){Kinetic.Node.prototype.setWidth.call(this,e),this._resizeDOM()},clear:function(){for(var e=this.children,t=0;t<e.length;t++)e[t].clear()},remove:function(){var e=this.content;Kinetic.Node.prototype.remove.call(this),e&&Kinetic.Type._isInDocument(e)&&this.attrs.container.removeChild(e)},reset:function(){this.removeChildren(),this._setStageDefaultProperties(),this.setAttrs(this.defaultNodeAttrs)},getMousePosition:function(){return this.mousePos},getTouchPosition:function(){return this.touchPos},getUserPosition:function(){return this.getTouchPosition()||this.getMousePosition()},getStage:function(){return this},getContent:function(){return this.content},toDataURL:function(e){function t(i){var o=c[i],d=o.toDataURL(),l=new Image;l.onload=function(){s.drawImage(l,0,0),i<c.length-1?t(i+1):e.callback(r.toDataURL(a,n))},l.src=d}e=e||{};var a=e.mimeType||null,n=e.quality||null,i=e.x||0,o=e.y||0,r=new Kinetic.SceneCanvas(e.width||this.getWidth(),e.height||this.getHeight()),s=r.getContext(),c=this.children;(i||o)&&s.translate(-1*i,-1*o),t(0)},toImage:function(e){var t=e.callback;e.callback=function(e){Kinetic.Type._getImage(e,function(e){t(e)})},this.toDataURL(e)},getIntersection:function(e){for(var t,a=this.getChildren(),n=a.length-1;n>=0;n--){var i=a[n];if(i.isVisible()&&i.isListening()){var o=i.hitCanvas.context.getImageData(Math.round(e.x),Math.round(e.y),1,1).data;if(255===o[3]){var r=Kinetic.Type._rgbToHex(o[0],o[1],o[2]);return t=Kinetic.Global.shapes[r],{shape:t,pixel:o}}if(o[0]>0||o[1]>0||o[2]>0||o[3]>0)return{pixel:o}}}return null},_resizeDOM:function(){if(this.content){var e=this.attrs.width,t=this.attrs.height;this.content.style.width=e+"px",this.content.style.height=t+"px",this.bufferCanvas.setSize(e,t,1),this.hitCanvas.setSize(e,t);for(var a=this.children,n=0;n<a.length;n++){var i=a[n];i.getCanvas().setSize(e,t),i.hitCanvas.setSize(e,t),i.draw()}}},add:function(e){return Kinetic.Container.prototype.add.call(this,e),e.canvas.setSize(this.attrs.width,this.attrs.height),e.hitCanvas.setSize(this.attrs.width,this.attrs.height),e.draw(),this.content.appendChild(e.canvas.element),this},getDragLayer:function(){return this.dragLayer},_setUserPosition:function(e){e||(e=window.event),this._setMousePosition(e),this._setTouchPosition(e)},_bindContentEvents:function(){for(var e=(Kinetic.Global,this),t=["mousedown","mousemove","mouseup","mouseout","touchstart","touchmove","touchend"],a=0;a<t.length;a++){var n=t[a];!function(){var t=n;e.content.addEventListener(t,function(a){e["_"+t](a)},!1)}()}},_mouseout:function(e){this._setUserPosition(e);var t=Kinetic.DD,a=this.targetShape;!a||t&&t.moving||(a._handleEvent("mouseout",e),a._handleEvent("mouseleave",e),this.targetShape=null),this.mousePos=void 0},_mousemove:function(e){this._setUserPosition(e);var t=Kinetic.DD,a=this.getIntersection(this.getUserPosition());if(a){var n=a.shape;n&&(t&&t.moving||255!==a.pixel[3]||this.targetShape&&this.targetShape._id===n._id?n._handleEvent("mousemove",e):(this.targetShape&&(this.targetShape._handleEvent("mouseout",e,n),this.targetShape._handleEvent("mouseleave",e,n)),n._handleEvent("mouseover",e,this.targetShape),n._handleEvent("mouseenter",e,this.targetShape),this.targetShape=n))}else!this.targetShape||t&&t.moving||(this.targetShape._handleEvent("mouseout",e),this.targetShape._handleEvent("mouseleave",e),this.targetShape=null);t&&t._drag(e)},_mousedown:function(e){var t,a=Kinetic.DD;if(this._setUserPosition(e),t=this.getIntersection(this.getUserPosition()),t&&t.shape){var n=t.shape;this.clickStart=!0,n._handleEvent("mousedown",e)}a&&this.attrs.draggable&&!a.node&&this._startDrag(e)},_mouseup:function(e){this._setUserPosition(e);var t=this,a=Kinetic.DD,n=this.getIntersection(this.getUserPosition());if(n&&n.shape){var i=n.shape;i._handleEvent("mouseup",e),this.clickStart&&(a&&a.moving&&a.node||(i._handleEvent("click",e),this.inDoubleClickWindow&&i._handleEvent("dblclick",e),this.inDoubleClickWindow=!0,setTimeout(function(){t.inDoubleClickWindow=!1},this.dblClickWindow)))}this.clickStart=!1},_touchstart:function(e){var t,a=Kinetic.DD;if(this._setUserPosition(e),e.preventDefault(),t=this.getIntersection(this.getUserPosition()),t&&t.shape){var n=t.shape;this.tapStart=!0,n._handleEvent("touchstart",e)}a&&this.attrs.draggable&&!a.node&&this._startDrag(e)},_touchend:function(e){this._setUserPosition(e);var t=this,a=Kinetic.DD,n=this.getIntersection(this.getUserPosition());if(n&&n.shape){var i=n.shape;i._handleEvent("touchend",e),this.tapStart&&(a&&a.moving&&a.node||(i._handleEvent("tap",e),this.inDoubleClickWindow&&i._handleEvent("dbltap",e),this.inDoubleClickWindow=!0,setTimeout(function(){t.inDoubleClickWindow=!1},this.dblClickWindow)))}this.tapStart=!1},_touchmove:function(e){this._setUserPosition(e);var t=Kinetic.DD;e.preventDefault();var a=this.getIntersection(this.getUserPosition());if(a&&a.shape){var n=a.shape;n._handleEvent("touchmove",e)}t&&t._drag(e)},_setMousePosition:function(e){var t=e.clientX-this._getContentPosition().left,a=e.clientY-this._getContentPosition().top;this.mousePos={x:t,y:a}},_setTouchPosition:function(e){if(void 0!==e.touches&&1===e.touches.length){var t=e.touches[0],a=t.clientX-this._getContentPosition().left,n=t.clientY-this._getContentPosition().top;this.touchPos={x:a,y:n}}},_getContentPosition:function(){var e=this.content.getBoundingClientRect();return{top:e.top,left:e.left}},_buildDOM:function(){this.content=document.createElement("div"),this.content.style.position="relative",this.content.style.display="inline-block",this.content.className="kineticjs-content",this.attrs.container.appendChild(this.content),this.bufferCanvas=new Kinetic.SceneCanvas,this.hitCanvas=new Kinetic.HitCanvas,this._resizeDOM()},_onContent:function(e,t){for(var a=e.split(" "),n=0;n<a.length;n++){var i=a[n];this.content.addEventListener(i,t,!1)}},_setStageDefaultProperties:function(){this.nodeType="Stage",this.dblClickWindow=400,this.targetShape=null,this.mousePos=void 0,this.clickStart=!1,this.touchPos=void 0,this.tapStart=!1}},Kinetic.Global.extend(Kinetic.Stage,Kinetic.Container),Kinetic.Node.addGetters(Kinetic.Stage,["container"])}(),function(){Kinetic.Layer=function(e){this._initLayer(e)},Kinetic.Layer.prototype={_initLayer:function(e){this.setDefaultAttrs({clearBeforeDraw:!0}),this.nodeType="Layer",this.beforeDrawFunc=void 0,this.afterDrawFunc=void 0,this.canvas=new Kinetic.SceneCanvas,this.canvas.getElement().style.position="absolute",this.hitCanvas=new Kinetic.HitCanvas,Kinetic.Container.call(this,e)},draw:function(){this.getContext();void 0!==this.beforeDrawFunc&&this.beforeDrawFunc.call(this),Kinetic.Container.prototype.draw.call(this),void 0!==this.afterDrawFunc&&this.afterDrawFunc.call(this)},drawHit:function(){this.hitCanvas.clear(),Kinetic.Container.prototype.drawHit.call(this)},drawScene:function(e){e=e||this.getCanvas(),this.attrs.clearBeforeDraw&&e.clear(),Kinetic.Container.prototype.drawScene.call(this,e)},toDataURL:function(e){e=e||{};var t=e.mimeType||null,a=e.quality||null;e.x||0,e.y||0;return e.width||e.height||e.x||e.y?Kinetic.Node.prototype.toDataURL.call(this,e):this.getCanvas().toDataURL(t,a)},beforeDraw:function(e){this.beforeDrawFunc=e},afterDraw:function(e){this.afterDrawFunc=e},getCanvas:function(){return this.canvas},getContext:function(){return this.canvas.context},clear:function(){this.getCanvas().clear()},setVisible:function(e){Kinetic.Node.prototype.setVisible.call(this,e),e?(this.canvas.element.style.display="block",this.hitCanvas.element.style.display="block"):(this.canvas.element.style.display="none",this.hitCanvas.element.style.display="none")},setZIndex:function(e){Kinetic.Node.prototype.setZIndex.call(this,e);var t=this.getStage();t&&(t.content.removeChild(this.canvas.element),e<t.getChildren().length-1?t.content.insertBefore(this.canvas.element,t.getChildren()[e+1].canvas.element):t.content.appendChild(this.canvas.element))},moveToTop:function(){Kinetic.Node.prototype.moveToTop.call(this);var e=this.getStage();e&&(e.content.removeChild(this.canvas.element),e.content.appendChild(this.canvas.element))},moveUp:function(){if(Kinetic.Node.prototype.moveUp.call(this)){var e=this.getStage();e&&(e.content.removeChild(this.canvas.element),this.index<e.getChildren().length-1?e.content.insertBefore(this.canvas.element,e.getChildren()[this.index+1].canvas.element):e.content.appendChild(this.canvas.element))}},moveDown:function(){if(Kinetic.Node.prototype.moveDown.call(this)){var e=this.getStage();if(e){var t=e.getChildren();e.content.removeChild(this.canvas.element),e.content.insertBefore(this.canvas.element,t[this.index+1].canvas.element)}}},moveToBottom:function(){if(Kinetic.Node.prototype.moveToBottom.call(this)){var e=this.getStage();if(e){var t=e.getChildren();e.content.removeChild(this.canvas.element),e.content.insertBefore(this.canvas.element,t[1].canvas.element)}}},getLayer:function(){return this},remove:function(){var e=this.getStage(),t=this.canvas,a=t.element;Kinetic.Node.prototype.remove.call(this),e&&t&&Kinetic.Type._isInDocument(a)&&e.content.removeChild(a)}},Kinetic.Global.extend(Kinetic.Layer,Kinetic.Container),Kinetic.Node.addGettersSetters(Kinetic.Layer,["clearBeforeDraw"])}(),function(){Kinetic.Group=function(e){this._initGroup(e)},Kinetic.Group.prototype={_initGroup:function(e){this.nodeType="Group",Kinetic.Container.call(this,e)}},Kinetic.Global.extend(Kinetic.Group,Kinetic.Container)}(),function(){Kinetic.Rect=function(e){this._initRect(e)},Kinetic.Rect.prototype={_initRect:function(e){this.setDefaultAttrs({width:0,height:0,cornerRadius:0}),Kinetic.Shape.call(this,e),this.shapeType="Rect",this._setDrawFuncs()},drawFunc:function(e){var t=e.getContext();t.beginPath();var a=this.getCornerRadius(),n=this.getWidth(),i=this.getHeight();0===a?t.rect(0,0,n,i):(t.moveTo(a,0),t.lineTo(n-a,0),t.arc(n-a,a,a,3*Math.PI/2,0,!1),t.lineTo(n,i-a),t.arc(n-a,i-a,a,0,Math.PI/2,!1),t.lineTo(a,i),t.arc(a,i-a,a,Math.PI/2,Math.PI,!1),t.lineTo(0,a),t.arc(a,a,a,Math.PI,3*Math.PI/2,!1)),t.closePath(),e.fillStroke(this)}},Kinetic.Global.extend(Kinetic.Rect,Kinetic.Shape),Kinetic.Node.addGettersSetters(Kinetic.Rect,["cornerRadius"])}(),function(){Kinetic.Circle=function(e){this._initCircle(e)},Kinetic.Circle.prototype={_initCircle:function(e){this.setDefaultAttrs({radius:0}),Kinetic.Shape.call(this,e),this.shapeType="Circle",this._setDrawFuncs()},drawFunc:function(e){var t=e.getContext();t.beginPath(),t.arc(0,0,this.getRadius(),0,2*Math.PI,!0),t.closePath(),e.fillStroke(this)},getWidth:function(){return 2*this.getRadius()},getHeight:function(){return 2*this.getRadius()},setWidth:function(e){Kinetic.Node.prototype.setWidth.call(this,e),this.setRadius(e/2)},setHeight:function(e){Kinetic.Node.prototype.setHeight.call(this,e),this.setRadius(e/2)}},Kinetic.Global.extend(Kinetic.Circle,Kinetic.Shape),Kinetic.Node.addGettersSetters(Kinetic.Circle,["radius"])}(),function(){Kinetic.Wedge=function(e){this._initWedge(e)},Kinetic.Wedge.prototype={_initWedge:function(e){this.setDefaultAttrs({radius:0,angle:0,clockwise:!1}),Kinetic.Shape.call(this,e),this.shapeType="Wedge",this._setDrawFuncs()},drawFunc:function(e){var t=e.getContext();t.beginPath(),t.arc(0,0,this.getRadius(),0,this.getAngle(),this.getClockwise()),t.lineTo(0,0),t.closePath(),e.fillStroke(this)},setAngleDeg:function(e){this.setAngle(Kinetic.Type._degToRad(e))},getAngleDeg:function(){return Kinetic.Type._radToDeg(this.getAngle())}},Kinetic.Global.extend(Kinetic.Wedge,Kinetic.Shape),Kinetic.Node.addGettersSetters(Kinetic.Wedge,["radius","angle","clockwise"])}(),function(){Kinetic.Ellipse=function(e){this._initEllipse(e)},Kinetic.Ellipse.prototype={_initEllipse:function(e){this.setDefaultAttrs({radius:{x:0,y:0}}),Kinetic.Shape.call(this,e),this.shapeType="Ellipse",this._setDrawFuncs()},drawFunc:function(e){var t=e.getContext(),a=this.getRadius();t.beginPath(),t.save(),a.x!==a.y&&t.scale(1,a.y/a.x),t.arc(0,0,a.x,0,2*Math.PI,!0),t.restore(),t.closePath(),e.fillStroke(this)},getWidth:function(){return 2*this.getRadius().x},getHeight:function(){return 2*this.getRadius().y},setWidth:function(e){Kinetic.Node.prototype.setWidth.call(this,e),this.setRadius({x:e/2})},setHeight:function(e){Kinetic.Node.prototype.setHeight.call(this,e),this.setRadius({y:e/2})}},Kinetic.Global.extend(Kinetic.Ellipse,Kinetic.Shape),Kinetic.Node.addPointGettersSetters(Kinetic.Ellipse,["radius"])}(),function(){Kinetic.Image=function(e){this._initImage(e)},Kinetic.Image.prototype={_initImage:function(e){Kinetic.Shape.call(this,e),this.shapeType="Image",this._setDrawFuncs();var t=this;this.on("imageChange",function(e){t._syncSize()}),this._syncSize()},drawFunc:function(e){var t,a=this.getWidth(),n=this.getHeight(),i=this,o=e.getContext();if(o.beginPath(),o.rect(0,0,a,n),o.closePath(),e.fillStroke(this),this.attrs.image){if(this.attrs.crop&&this.attrs.crop.width&&this.attrs.crop.height){var r=this.attrs.crop.x||0,s=this.attrs.crop.y||0,c=this.attrs.crop.width,d=this.attrs.crop.height;t=[this.attrs.image,r,s,c,d,0,0,a,n]}else t=[this.attrs.image,0,0,a,n];this.hasShadow()?e.applyShadow(this,function(){i._drawImage(o,t)}):this._drawImage(o,t)}},drawHitFunc:function(e){var t=this.getWidth(),a=this.getHeight(),n=this.imageHitRegion,i=e.getContext();n?(i.drawImage(n,0,0,t,a),i.beginPath(),i.rect(0,0,t,a),i.closePath(),e.stroke(this)):(i.beginPath(),i.rect(0,0,t,a),i.closePath(),e.fillStroke(this))},applyFilter:function(e,t,a){var n=new Kinetic.Canvas(this.attrs.image.width,this.attrs.image.height),i=n.getContext();i.drawImage(this.attrs.image,0,0);try{var o=i.getImageData(0,0,n.getWidth(),n.getHeight());e(o,t);var r=this;Kinetic.Type._getImage(o,function(e){r.setImage(e),a&&a()})}catch(s){Kinetic.Global.warn("Unable to apply filter. "+s.message)}},setCrop:function(){var e=[].slice.call(arguments),t=Kinetic.Type._getXY(e),a=Kinetic.Type._getSize(e),n=Kinetic.Type._merge(t,a);this.setAttr("crop",Kinetic.Type._merge(n,this.getCrop()))},createImageHitRegion:function(e){var t=new Kinetic.Canvas(this.attrs.width,this.attrs.height),a=t.getContext();a.drawImage(this.attrs.image,0,0);try{for(var n=a.getImageData(0,0,t.getWidth(),t.getHeight()),i=n.data,o=Kinetic.Type._hexToRgb(this.colorKey),r=0,s=i.length;s>r;r+=4)i[r]=o.r,i[r+1]=o.g,i[r+2]=o.b;var c=this;Kinetic.Type._getImage(n,function(t){c.imageHitRegion=t,e&&e()})}catch(d){Kinetic.Global.warn("Unable to create image hit region. "+d.message)}},clearImageHitRegion:function(){delete this.imageHitRegion},_syncSize:function(){this.attrs.image&&(this.attrs.width||this.setWidth(this.attrs.image.width),this.attrs.height||this.setHeight(this.attrs.image.height))},_drawImage:function(e,t){5===t.length?e.drawImage(t[0],t[1],t[2],t[3],t[4]):9===t.length&&e.drawImage(t[0],t[1],t[2],t[3],t[4],t[5],t[6],t[7],t[8])}},Kinetic.Global.extend(Kinetic.Image,Kinetic.Shape),Kinetic.Node.addGettersSetters(Kinetic.Image,["image"]),Kinetic.Node.addGetters(Kinetic.Image,["crop"])}(),function(){Kinetic.Polygon=function(e){this._initPolygon(e)},Kinetic.Polygon.prototype={_initPolygon:function(e){this.setDefaultAttrs({points:[]}),Kinetic.Shape.call(this,e),this.shapeType="Polygon",this._setDrawFuncs()},drawFunc:function(e){var t=e.getContext(),a=this.getPoints(),n=a.length;t.beginPath(),t.moveTo(a[0].x,a[0].y);for(var i=1;n>i;i++)t.lineTo(a[i].x,a[i].y);t.closePath(),e.fillStroke(this)},setPoints:function(e){this.setAttr("points",Kinetic.Type._getPoints(e))}},Kinetic.Global.extend(Kinetic.Polygon,Kinetic.Shape),Kinetic.Node.addGetters(Kinetic.Polygon,["points"])}(),function(){function e(e){e.fillText(this.partialText,0,0)}function t(e){e.strokeText(this.partialText,0,0)}var a="auto",i="Calibri",o="canvas",r="center",s="Change.kinetic",c="2d",d="\n",l="",m="left",g="\n",u="text",h="Text",p="top",y="middle",_="normal",f="px ",v=" ",b="right",w=["fontFamily","fontSize","fontStyle","padding","align","lineHeight","text","width","height"],S=w.length;Kinetic.Text=function(e){this._initText(e)},Kinetic.Text.prototype={_initText:function(n){var r=this;this.setDefaultAttrs({fontFamily:i,text:l,fontSize:12,align:m,verticalAlign:p,fontStyle:_,padding:0,width:a,height:a,lineHeight:1}),this.dummyCanvas=document.createElement(o),Kinetic.Shape.call(this,n),this._fillFunc=e,this._strokeFunc=t,this.shapeType=h,this._setDrawFuncs();for(var c=0;S>c;c++)this.on(w[c]+s,r._setTextData);this._setTextData()},drawFunc:function(e){var t=e.getContext(),a=this.getPadding(),n=this.getFontStyle(),i=this.getFontSize(),o=this.getFontFamily(),s=this.getTextHeight(),c=this.getLineHeight()*s,d=this.textArr,l=d.length,g=this.getWidth();t.font=n+v+i+f+o,t.textBaseline=y,t.textAlign=m,t.save(),t.translate(a,0),t.translate(0,a+s/2);for(var u=0;l>u;u++){var h=d[u],p=h.text,_=h.width;t.save(),this.getAlign()===b?t.translate(g-_-2*a,0):this.getAlign()===r&&t.translate((g-_-2*a)/2,0),this.partialText=p,e.fillStroke(this),t.restore(),t.translate(0,c)}t.restore()},drawHitFunc:function(e){var t=e.getContext(),a=this.getWidth(),n=this.getHeight();t.beginPath(),t.rect(0,0,a,n),t.closePath(),e.fillStroke(this)},setText:function(e){var t=Kinetic.Type._isString(e)?e:e.toString();this.setAttr(u,t)},getWidth:function(){return this.attrs.width===a?this.getTextWidth()+2*this.getPadding():this.attrs.width},getHeight:function(){return this.attrs.height===a?this.getTextHeight()*this.textArr.length*this.attrs.lineHeight+2*this.attrs.padding:this.attrs.height},getTextWidth:function(){return this.textWidth},getTextHeight:function(){return this.textHeight},_getTextSize:function(e){var t,a=this.dummyCanvas,n=a.getContext(c),i=this.getFontSize();return n.save(),n.font=this.getFontStyle()+v+i+f+this.getFontFamily(),t=n.measureText(e),n.restore(),{width:t.width,height:parseInt(i,10)}},_expandTextData:function(e){var t=e.length;for(n=0,text=l,newArr=[],n=0;n<t;n++)text=e[n],newArr.push({text:text,width:this._getTextSize(text).width});return newArr},_setTextData:function(){var e=this.getText().split(l),t=[],n=0;for(addLine=!0,lineHeightPx=0,padding=this.getPadding(),this.textWidth=0,this.textHeight=this._getTextSize(this.getText()).height,lineHeightPx=this.getLineHeight()*this.textHeight;e.length>0&&addLine&&(this.attrs.height===a||lineHeightPx*(n+1)<this.attrs.height-2*padding);){var i=0,o=void 0;for(addLine=!1;i<e.length;){if(e.indexOf(g)===i){e.splice(i,1),o=e.splice(0,i).join(l);break}var r=e.slice(0,i);if(this.attrs.width!==a&&this._getTextSize(r.join(l)).width>this.attrs.width-2*padding){if(0==i)break;var s=r.lastIndexOf(v),c=r.lastIndexOf(d),m=Math.max(s,c);if(m>=0){o=e.splice(0,1+m).join(l);break}o=e.splice(0,i).join(l);break}i++,i===e.length&&(o=e.splice(0,i).join(l))}this.textWidth=Math.max(this.textWidth,this._getTextSize(o).width),void 0!==o&&(t.push(o),addLine=!0),n++}this.textArr=this._expandTextData(t)}},Kinetic.Global.extend(Kinetic.Text,Kinetic.Shape),Kinetic.Node.addGettersSetters(Kinetic.Text,["fontFamily","fontSize","fontStyle","padding","align","lineHeight"]),Kinetic.Node.addGetters(Kinetic.Text,[u])}(),function(){Kinetic.Line=function(e){this._initLine(e)},Kinetic.Line.prototype={_initLine:function(e){this.setDefaultAttrs({points:[],lineCap:"butt"}),Kinetic.Shape.call(this,e),this.shapeType="Line",this._setDrawFuncs()},drawFunc:function(e){var t=this.getPoints(),a=t.length,n=e.getContext();n.beginPath(),n.moveTo(t[0].x,t[0].y);
for(var i=1;a>i;i++){var o=t[i];n.lineTo(o.x,o.y)}e.stroke(this)},setPoints:function(e){this.setAttr("points",Kinetic.Type._getPoints(e))}},Kinetic.Global.extend(Kinetic.Line,Kinetic.Shape),Kinetic.Node.addGetters(Kinetic.Line,["points"])}(),function(){Kinetic.Spline=function(e){this._initSpline(e)},Kinetic.Spline._getControlPoints=function(e,t,a,n){var i=e.x,o=e.y,r=t.x,s=t.y,c=a.x,d=a.y,l=Math.sqrt(Math.pow(r-i,2)+Math.pow(s-o,2)),m=Math.sqrt(Math.pow(c-r,2)+Math.pow(d-s,2)),g=n*l/(l+m),u=n*m/(l+m),h=r-g*(c-i),p=s-g*(d-o),y=r+u*(c-i),_=s+u*(d-o);return[{x:h,y:p},{x:y,y:_}]},Kinetic.Spline.prototype={_initSpline:function(e){this.setDefaultAttrs({tension:1}),Kinetic.Line.call(this,e),this.shapeType="Spline"},drawFunc:function(e){var t=this.getPoints(),a=t.length,n=e.getContext(),i=this.getTension();if(n.beginPath(),n.moveTo(t[0].x,t[0].y),0!==i&&a>2){var o=this.allPoints,r=o.length;n.quadraticCurveTo(o[0].x,o[0].y,o[1].x,o[1].y);for(var s=2;r-1>s;)n.bezierCurveTo(o[s].x,o[s++].y,o[s].x,o[s++].y,o[s].x,o[s++].y);n.quadraticCurveTo(o[r-1].x,o[r-1].y,t[a-1].x,t[a-1].y)}else for(var s=1;a>s;s++){var c=t[s];n.lineTo(c.x,c.y)}e.stroke(this)},setPoints:function(e){Kinetic.Line.prototype.setPoints.call(this,e),this._setAllPoints()},setTension:function(e){this.setAttr("tension",e),this._setAllPoints()},_setAllPoints:function(){for(var e=this.getPoints(),t=e.length,a=this.getTension(),n=[],i=1;t-1>i;i++){var o=Kinetic.Spline._getControlPoints(e[i-1],e[i],e[i+1],a);n.push(o[0]),n.push(e[i]),n.push(o[1])}this.allPoints=n}},Kinetic.Global.extend(Kinetic.Spline,Kinetic.Line),Kinetic.Node.addGetters(Kinetic.Spline,["tension"])}(),function(){Kinetic.Blob=function(e){this._initBlob(e)},Kinetic.Blob.prototype={_initBlob:function(e){Kinetic.Spline.call(this,e),this.shapeType="Blob"},drawFunc:function(e){var t=this.getPoints(),a=t.length,n=e.getContext(),i=this.getTension();if(n.beginPath(),n.moveTo(t[0].x,t[0].y),0!==i&&a>2)for(var o=this.allPoints,r=o.length,s=0;r-1>s;)n.bezierCurveTo(o[s].x,o[s++].y,o[s].x,o[s++].y,o[s].x,o[s++].y);else for(var s=1;a>s;s++){var c=t[s];n.lineTo(c.x,c.y)}n.closePath(),e.fillStroke(this)},_setAllPoints:function(){var e=this.getPoints(),t=e.length,a=this.getTension(),n=Kinetic.Spline._getControlPoints(e[t-1],e[0],e[1],a),i=Kinetic.Spline._getControlPoints(e[t-2],e[t-1],e[0],a);Kinetic.Spline.prototype._setAllPoints.call(this),this.allPoints.unshift(n[1]),this.allPoints.push(i[0]),this.allPoints.push(e[t-1]),this.allPoints.push(i[1]),this.allPoints.push(n[0]),this.allPoints.push(e[0])}},Kinetic.Global.extend(Kinetic.Blob,Kinetic.Spline)}(),function(){Kinetic.Sprite=function(e){this._initSprite(e)},Kinetic.Sprite.prototype={_initSprite:function(e){this.setDefaultAttrs({index:0,frameRate:17}),Kinetic.Shape.call(this,e),this.shapeType="Sprite",this._setDrawFuncs(),this.anim=new Kinetic.Animation;var t=this;this.on("animationChange",function(){t.setIndex(0)})},drawFunc:function(e){var t=this.attrs.animation,a=this.attrs.index,n=this.attrs.animations[t][a],i=e.getContext(),o=this.attrs.image;o&&i.drawImage(o,n.x,n.y,n.width,n.height,0,0,n.width,n.height)},drawHitFunc:function(e){var t=this.attrs.animation,a=this.attrs.index,n=this.attrs.animations[t][a],i=e.getContext();i.beginPath(),i.rect(0,0,n.width,n.height),i.closePath(),e.fill(this)},start:function(){var e=this,t=this.getLayer();this.anim.node=t,this.interval=setInterval(function(){var t=e.attrs.index;e._updateIndex(),e.afterFrameFunc&&t===e.afterFrameIndex&&(e.afterFrameFunc(),delete e.afterFrameFunc,delete e.afterFrameIndex)},1e3/this.attrs.frameRate),this.anim.start()},stop:function(){this.anim.stop(),clearInterval(this.interval)},afterFrame:function(e,t){this.afterFrameIndex=e,this.afterFrameFunc=t},_updateIndex:function(){var e=this.attrs.index,t=this.attrs.animation;e<this.attrs.animations[t].length-1?this.attrs.index++:this.attrs.index=0}},Kinetic.Global.extend(Kinetic.Sprite,Kinetic.Shape),Kinetic.Node.addGettersSetters(Kinetic.Sprite,["animation","animations","index"])}(),function(){Kinetic.Star=function(e){this._initStar(e)},Kinetic.Star.prototype={_initStar:function(e){this.setDefaultAttrs({numPoints:0,innerRadius:0,outerRadius:0}),Kinetic.Shape.call(this,e),this.shapeType="Star",this._setDrawFuncs()},drawFunc:function(e){var t=e.getContext(),a=this.attrs.innerRadius,n=this.attrs.outerRadius,i=this.attrs.numPoints;t.beginPath(),t.moveTo(0,0-this.attrs.outerRadius);for(var o=1;2*i>o;o++){var r=o%2===0?n:a,s=r*Math.sin(o*Math.PI/i),c=-1*r*Math.cos(o*Math.PI/i);t.lineTo(s,c)}t.closePath(),e.fillStroke(this)}},Kinetic.Global.extend(Kinetic.Star,Kinetic.Shape),Kinetic.Node.addGettersSetters(Kinetic.Star,["numPoints","innerRadius","outerRadius"])}(),function(){Kinetic.RegularPolygon=function(e){this._initRegularPolygon(e)},Kinetic.RegularPolygon.prototype={_initRegularPolygon:function(e){this.setDefaultAttrs({radius:0,sides:0}),Kinetic.Shape.call(this,e),this.shapeType="RegularPolygon",this._setDrawFuncs()},drawFunc:function(e){var t=e.getContext(),a=this.attrs.sides,n=this.attrs.radius;t.beginPath(),t.moveTo(0,0-n);for(var i=1;a>i;i++){var o=n*Math.sin(2*i*Math.PI/a),r=-1*n*Math.cos(2*i*Math.PI/a);t.lineTo(o,r)}t.closePath(),e.fillStroke(this)}},Kinetic.Global.extend(Kinetic.RegularPolygon,Kinetic.Shape),Kinetic.Node.addGettersSetters(Kinetic.RegularPolygon,["radius","sides"])}(),function(){Kinetic.Path=function(e){this._initPath(e)},Kinetic.Path.prototype={_initPath:function(e){this.dataArray=[];var t=this;Kinetic.Shape.call(this,e),this.shapeType="Path",this._setDrawFuncs(),this.dataArray=Kinetic.Path.parsePathData(this.attrs.data),this.on("dataChange",function(){t.dataArray=Kinetic.Path.parsePathData(t.attrs.data)})},drawFunc:function(e){var t=this.dataArray,a=e.getContext();a.beginPath();for(var n=0;n<t.length;n++){var i=t[n].command,o=t[n].points;switch(i){case"L":a.lineTo(o[0],o[1]);break;case"M":a.moveTo(o[0],o[1]);break;case"C":a.bezierCurveTo(o[0],o[1],o[2],o[3],o[4],o[5]);break;case"Q":a.quadraticCurveTo(o[0],o[1],o[2],o[3]);break;case"A":var r=o[0],s=o[1],c=o[2],d=o[3],l=o[4],m=o[5],g=o[6],u=o[7],h=c>d?c:d,p=c>d?1:c/d,y=c>d?d/c:1;a.translate(r,s),a.rotate(g),a.scale(p,y),a.arc(0,0,h,l,l+m,1-u),a.scale(1/p,1/y),a.rotate(-g),a.translate(-r,-s);break;case"z":a.closePath()}}e.fillStroke(this)}},Kinetic.Global.extend(Kinetic.Path,Kinetic.Shape),Kinetic.Path.getLineLength=function(e,t,a,n){return Math.sqrt((a-e)*(a-e)+(n-t)*(n-t))},Kinetic.Path.getPointOnLine=function(e,t,a,n,i,o,r){void 0===o&&(o=t),void 0===r&&(r=a);var s=(i-a)/(n-t+1e-8),c=Math.sqrt(e*e/(1+s*s));t>n&&(c*=-1);var d,l=s*c;if((r-a)/(o-t+1e-8)===s)d={x:o+c,y:r+l};else{var m,g,u=this.getLineLength(t,a,n,i);if(1e-8>u)return;var h=(o-t)*(n-t)+(r-a)*(i-a);h/=u*u,m=t+h*(n-t),g=a+h*(i-a);var p=this.getLineLength(o,r,m,g),y=Math.sqrt(e*e-p*p);c=Math.sqrt(y*y/(1+s*s)),t>n&&(c*=-1),l=s*c,d={x:m+c,y:g+l}}return d},Kinetic.Path.getPointOnCubicBezier=function(e,t,a,n,i,o,r,s,c){function d(e){return e*e*e}function l(e){return 3*e*e*(1-e)}function m(e){return 3*e*(1-e)*(1-e)}function g(e){return(1-e)*(1-e)*(1-e)}var u=s*d(e)+o*l(e)+n*m(e)+t*g(e),h=c*d(e)+r*l(e)+i*m(e)+a*g(e);return{x:u,y:h}},Kinetic.Path.getPointOnQuadraticBezier=function(e,t,a,n,i,o,r){function s(e){return e*e}function c(e){return 2*e*(1-e)}function d(e){return(1-e)*(1-e)}var l=o*s(e)+n*c(e)+t*d(e),m=r*s(e)+i*c(e)+a*d(e);return{x:l,y:m}},Kinetic.Path.getPointOnEllipticalArc=function(e,t,a,n,i,o){var r=Math.cos(o),s=Math.sin(o),c={x:a*Math.cos(i),y:n*Math.sin(i)};return{x:e+(c.x*r-c.y*s),y:t+(c.x*s+c.y*r)}},Kinetic.Path.parsePathData=function(e){if(!e)return[];var t=e,a=["m","M","l","L","v","V","h","H","z","Z","c","C","q","Q","t","T","s","S","a","A"];t=t.replace(new RegExp(" ","g"),",");for(var n=0;n<a.length;n++)t=t.replace(new RegExp(a[n],"g"),"|"+a[n]);for(var i=t.split("|"),o=[],r=0,s=0,n=1;n<i.length;n++){var c=i[n],d=c.charAt(0);c=c.slice(1),c=c.replace(new RegExp(",-","g"),"-"),c=c.replace(new RegExp("-","g"),",-"),c=c.replace(new RegExp("e,-","g"),"e-");var l=c.split(",");l.length>0&&""===l[0]&&l.shift();for(var m=0;m<l.length;m++)l[m]=parseFloat(l[m]);for(;l.length>0&&!isNaN(l[0]);){var g=null,u=[],h=r,p=s;switch(d){case"l":r+=l.shift(),s+=l.shift(),g="L",u.push(r,s);break;case"L":r=l.shift(),s=l.shift(),u.push(r,s);break;case"m":r+=l.shift(),s+=l.shift(),g="M",u.push(r,s),d="l";break;case"M":r=l.shift(),s=l.shift(),g="M",u.push(r,s),d="L";break;case"h":r+=l.shift(),g="L",u.push(r,s);break;case"H":r=l.shift(),g="L",u.push(r,s);break;case"v":s+=l.shift(),g="L",u.push(r,s);break;case"V":s=l.shift(),g="L",u.push(r,s);break;case"C":u.push(l.shift(),l.shift(),l.shift(),l.shift()),r=l.shift(),s=l.shift(),u.push(r,s);break;case"c":u.push(r+l.shift(),s+l.shift(),r+l.shift(),s+l.shift()),r+=l.shift(),s+=l.shift(),g="C",u.push(r,s);break;case"S":var y=r,_=s,f=o[o.length-1];"C"===f.command&&(y=r+(r-f.points[2]),_=s+(s-f.points[3])),u.push(y,_,l.shift(),l.shift()),r=l.shift(),s=l.shift(),g="C",u.push(r,s);break;case"s":var y=r,_=s,f=o[o.length-1];"C"===f.command&&(y=r+(r-f.points[2]),_=s+(s-f.points[3])),u.push(y,_,r+l.shift(),s+l.shift()),r+=l.shift(),s+=l.shift(),g="C",u.push(r,s);break;case"Q":u.push(l.shift(),l.shift()),r=l.shift(),s=l.shift(),u.push(r,s);break;case"q":u.push(r+l.shift(),s+l.shift()),r+=l.shift(),s+=l.shift(),g="Q",u.push(r,s);break;case"T":var y=r,_=s,f=o[o.length-1];"Q"===f.command&&(y=r+(r-f.points[0]),_=s+(s-f.points[1])),r=l.shift(),s=l.shift(),g="Q",u.push(y,_,r,s);break;case"t":var y=r,_=s,f=o[o.length-1];"Q"===f.command&&(y=r+(r-f.points[0]),_=s+(s-f.points[1])),r+=l.shift(),s+=l.shift(),g="Q",u.push(y,_,r,s);break;case"A":var v=l.shift(),b=l.shift(),w=l.shift(),S=l.shift(),C=l.shift(),x=r,k=s;r=l.shift(),s=l.shift(),g="A",u=this.convertEndpointToCenterParameterization(x,k,r,s,S,C,v,b,w);break;case"a":var v=l.shift(),b=l.shift(),w=l.shift(),S=l.shift(),C=l.shift(),x=r,k=s;r+=l.shift(),s+=l.shift(),g="A",u=this.convertEndpointToCenterParameterization(x,k,r,s,S,C,v,b,w)}o.push({command:g||d,points:u,start:{x:h,y:p},pathLength:this.calcLength(h,p,g||d,u)})}("z"===d||"Z"===d)&&o.push({command:"z",points:[],start:void 0,pathLength:0})}return o},Kinetic.Path.calcLength=function(e,a,n,i){var o,r,s,c=Kinetic.Path;switch(n){case"L":return c.getLineLength(e,a,i[0],i[1]);case"C":for(o=0,r=c.getPointOnCubicBezier(0,e,a,i[0],i[1],i[2],i[3],i[4],i[5]),t=.01;t<=1;t+=.01)s=c.getPointOnCubicBezier(t,e,a,i[0],i[1],i[2],i[3],i[4],i[5]),o+=c.getLineLength(r.x,r.y,s.x,s.y),r=s;return o;case"Q":for(o=0,r=c.getPointOnQuadraticBezier(0,e,a,i[0],i[1],i[2],i[3]),t=.01;t<=1;t+=.01)s=c.getPointOnQuadraticBezier(t,e,a,i[0],i[1],i[2],i[3]),o+=c.getLineLength(r.x,r.y,s.x,s.y),r=s;return o;case"A":o=0;var d=i[4],l=i[5],m=i[4]+l,g=Math.PI/180;if(Math.abs(d-m)<g&&(g=Math.abs(d-m)),r=c.getPointOnEllipticalArc(i[0],i[1],i[2],i[3],d,0),0>l)for(t=d-g;t>m;t-=g)s=c.getPointOnEllipticalArc(i[0],i[1],i[2],i[3],t,0),o+=c.getLineLength(r.x,r.y,s.x,s.y),r=s;else for(t=d+g;t<m;t+=g)s=c.getPointOnEllipticalArc(i[0],i[1],i[2],i[3],t,0),o+=c.getLineLength(r.x,r.y,s.x,s.y),r=s;return s=c.getPointOnEllipticalArc(i[0],i[1],i[2],i[3],m,0),o+=c.getLineLength(r.x,r.y,s.x,s.y)}return 0},Kinetic.Path.convertEndpointToCenterParameterization=function(e,t,a,n,i,o,r,s,c){var d=c*(Math.PI/180),l=Math.cos(d)*(e-a)/2+Math.sin(d)*(t-n)/2,m=-1*Math.sin(d)*(e-a)/2+Math.cos(d)*(t-n)/2,g=l*l/(r*r)+m*m/(s*s);g>1&&(r*=Math.sqrt(g),s*=Math.sqrt(g));var u=Math.sqrt((r*r*(s*s)-r*r*(m*m)-s*s*(l*l))/(r*r*(m*m)+s*s*(l*l)));i==o&&(u*=-1),isNaN(u)&&(u=0);var h=u*r*m/s,p=u*-s*l/r,y=(e+a)/2+Math.cos(d)*h-Math.sin(d)*p,_=(t+n)/2+Math.sin(d)*h+Math.cos(d)*p,f=function(e){return Math.sqrt(e[0]*e[0]+e[1]*e[1])},v=function(e,t){return(e[0]*t[0]+e[1]*t[1])/(f(e)*f(t))},b=function(e,t){return(e[0]*t[1]<e[1]*t[0]?-1:1)*Math.acos(v(e,t))},w=b([1,0],[(l-h)/r,(m-p)/s]),S=[(l-h)/r,(m-p)/s],C=[(-1*l-h)/r,(-1*m-p)/s],x=b(S,C);return v(S,C)<=-1&&(x=Math.PI),v(S,C)>=1&&(x=0),0===o&&x>0&&(x-=2*Math.PI),1==o&&0>x&&(x+=2*Math.PI),[y,_,r,s,w,x,d,o]},Kinetic.Node.addGettersSetters(Kinetic.Path,["data"])}(),function(){function e(e){e.fillText(this.partialText,0,0)}function t(e){e.strokeText(this.partialText,0,0)}Kinetic.TextPath=function(e){this._initTextPath(e)},Kinetic.TextPath.prototype={_initTextPath:function(a){this.setDefaultAttrs({fontFamily:"Calibri",fontSize:12,fontStyle:"normal",text:""}),this.dummyCanvas=document.createElement("canvas"),this.dataArray=[];var n=this;Kinetic.Shape.call(this,a),this._fillFunc=e,this._strokeFunc=t,this.shapeType="TextPath",this._setDrawFuncs(),this.dataArray=Kinetic.Path.parsePathData(this.attrs.data),this.on("dataChange",function(){n.dataArray=Kinetic.Path.parsePathData(this.attrs.data)});for(var i=["text","textStroke","textStrokeWidth"],o=0;o<i.length;o++){var r=i[o];this.on(r+"Change",n._setTextData)}n._setTextData()},drawFunc:function(e){var t=(this.charArr,e.getContext());t.font=this.attrs.fontStyle+" "+this.attrs.fontSize+"pt "+this.attrs.fontFamily,t.textBaseline="middle",t.textAlign="left",t.save();for(var a=this.glyphInfo,n=0;n<a.length;n++){t.save();var i=a[n].p0;a[n].p1,parseFloat(this.attrs.fontSize);t.translate(i.x,i.y),t.rotate(a[n].rotation),this.partialText=a[n].text,e.fillStroke(this),t.restore()}t.restore()},getTextWidth:function(){return this.textWidth},getTextHeight:function(){return this.textHeight},setText:function(e){Kinetic.Text.prototype.setText.call(this,e)},_getTextSize:function(e){var t=this.dummyCanvas,a=t.getContext("2d");a.save(),a.font=this.attrs.fontStyle+" "+this.attrs.fontSize+"pt "+this.attrs.fontFamily;var n=a.measureText(e);return a.restore(),{width:n.width,height:parseInt(this.attrs.fontSize,10)}},_setTextData:function(){var e=this,t=this._getTextSize(this.attrs.text);this.textWidth=t.width,this.textHeight=t.height,this.glyphInfo=[];for(var a,n,i,o=this.attrs.text.split(""),r=-1,s=0,c=function(){s=0;for(var t=e.dataArray,n=r+1;n<t.length;n++){if(t[n].pathLength>0)return r=n,t[n];"M"==t[n].command&&(a={x:t[n].points[0],y:t[n].points[1]})}return{}},d=function(t,o){var r=e._getTextSize(t).width,d=0,l=0;for(n=void 0;Math.abs(r-d)/r>.01&&25>l;){l++;for(var m=d;void 0===i;)i=c(),i&&m+i.pathLength<r&&(m+=i.pathLength,i=void 0);if(i==={}||void 0===a)return;var g=!1;switch(i.command){case"L":Kinetic.Path.getLineLength(a.x,a.y,i.points[0],i.points[1])>r?n=Kinetic.Path.getPointOnLine(r,a.x,a.y,i.points[0],i.points[1],a.x,a.y):i=void 0;break;case"A":var u=i.points[4],h=i.points[5],p=i.points[4]+h;0===s?s=u+1e-8:r>d?s+=Math.PI/180*h/Math.abs(h):s-=Math.PI/360*h/Math.abs(h),Math.abs(s)>Math.abs(p)&&(s=p,g=!0),n=Kinetic.Path.getPointOnEllipticalArc(i.points[0],i.points[1],i.points[2],i.points[3],s,i.points[6]);break;case"C":0===s?s=r>i.pathLength?1e-8:r/i.pathLength:r>d?s+=(r-d)/i.pathLength:s-=(d-r)/i.pathLength,s>1&&(s=1,g=!0),n=Kinetic.Path.getPointOnCubicBezier(s,i.start.x,i.start.y,i.points[0],i.points[1],i.points[2],i.points[3],i.points[4],i.points[5]);break;case"Q":0===s?s=r/i.pathLength:r>d?s+=(r-d)/i.pathLength:s-=(d-r)/i.pathLength,s>1&&(s=1,g=!0),n=Kinetic.Path.getPointOnQuadraticBezier(s,i.start.x,i.start.y,i.points[0],i.points[1],i.points[2],i.points[3])}void 0!==n&&(d=Kinetic.Path.getLineLength(a.x,a.y,n.x,n.y)),g&&(g=!1,i=void 0)}},l=0;l<o.length&&(d(o[l]),void 0!==a&&void 0!==n);l++){var m=Kinetic.Path.getLineLength(a.x,a.y,n.x,n.y),g=0,u=Kinetic.Path.getPointOnLine(g+m/2,a.x,a.y,n.x,n.y),h=Math.atan2(n.y-a.y,n.x-a.x);this.glyphInfo.push({transposeX:u.x,transposeY:u.y,text:o[l],rotation:h,p0:a,p1:n}),a=n}}},Kinetic.Global.extend(Kinetic.TextPath,Kinetic.Shape),Kinetic.Node.addGettersSetters(Kinetic.TextPath,["fontFamily","fontSize","fontStyle"]),Kinetic.Node.addGetters(Kinetic.TextPath,["text"])}(),define("ubnt/view/map/RulerView",["backbone","underscore","libs/kinetic","jquery"],function(e,t,a,n){"use strict";return e.View.extend({_fullyQualifiedName:"UBNT.views.map.Ruler",events:{click:"onRulerClick","click .close":"onCloseClick","click .submit":"onFormSubmit"},initialize:function(){t.bindAll(this),this.distance=0,this.measuredDistance=0,this.scale=0,this.render()},render:function(){!this.rendered&&(this.rendered=!0)&&(this.$distance=this.$(".distance"),this.$units=this.$(".units"),this.$submit=this.$(".submit"))},setupStage:function(){var e=n("#Map");this.layer=new a.Layer,this.stage=new a.Stage({container:"Map",width:e.width(),height:e.height()}),this.background=new a.Rect({x:0,y:0,width:this.stage.getWidth(),height:this.stage.getHeight(),fill:"#1292c5",opacity:.1}),this.line=new a.Line({points:[0,0,0,0],stroke:"red"}),this.moving=!1,this.layer.add(this.background),this.layer.add(this.line),this.stage.add(this.layer)},destroyStage:function(){this.line.destroy(),this.background.destroy(),this.layer.destroy(),this.stage.destroy()},bindStageEvents:function(){this.stage.on("mousedown",this.onStageMouseDown),this.stage.on("mousemove",this.onStageMouseMove),this.stage.on("mouseup",this.onStageMouseUp)},unbindStageEvents:function(){this.stage.off("mousedown",this.onStageMouseDown),this.stage.off("mousemove",this.onStageMouseMove),this.stage.off("mouseup",this.onStageMouseUp)},onStageMouseDown:function(){if(this.moving)this.moving=!1,this.layer.draw();else{var e=this.stage.getMousePosition();this.line.getPoints()[0].x=e.x,this.line.getPoints()[0].y=e.y,this.line.getPoints()[1].x=e.x,this.line.getPoints()[1].y=e.y,this.moving=!0,this.layer.drawScene()}},onStageMouseMove:function(){if(this.moving){var e=this.stage.getMousePosition();e.x,e.y;this.line.getPoints()[1].x=e.x,this.line.getPoints()[1].y=e.y,this.moving=!0,this.layer.drawScene()}},onStageMouseUp:function(){var e=this.line.getPoints();this.measuredDistance=this.getDistance(e[0],e[1]),this.moving=!1,this.measuredDistance>0&&(this.$distance.prop("disabled",!1).removeClass("disabled").focus(),this.$submit.prop("disabled",!1).removeClass("disabled"))},onRulerClick:function(e){this.$el.hasClass("is-open")||(this.$el.addClass("is-open"),this.setupStage(),this.bindStageEvents()),e.preventDefault()},onCloseClick:function(e){return this.$el.removeClass("is-open"),this.unbindStageEvents(),this.destroyStage(),e.preventDefault(),e.stopPropagation(),!1},onFormSubmit:function(e){var t=parseFloat(this.$distance.val(),10),a=t/this.measuredDistance,n=this.$units.val();t&&(this.onCloseClick(e),this.$el.trigger("scaled",[a,n]),this.$distance.val(""))},getDistance:function(e,t){return Math.sqrt(Math.pow(t.x-e.x,2)+Math.pow(t.y-e.y,2))},remove:function(){this.unbindStageEvents(),this.rendered=!1,e.View.prototype.remove.apply(this,arguments)}})}),define("ubnt/EventDispatcher",{bind:function(e,t,a){"use strict";var n=this._callbacks||(this._callbacks={}),i=n[e]||(n[e]=[]);return i.push([t,a]),this},unbind:function(e,t){"use strict";var a;if(e){if(a=this._callbacks)if(t){var n=a[e];if(!n)return this;for(var i=0,o=n.length;o>i;i++)if(n[i]&&t===n[i][0]){n[i]=null;break}}else a[e]=[]}else this._callbacks={};return this},trigger:function(e){"use strict";var t,a,n,i,o,r=2;if(!(a=this._callbacks))return this;for(;r--;)if(n=r?e:"all",t=a[n])for(var s=0,c=t.length;c>s;s++)(i=t[s])?(o=r?Array.prototype.slice.call(arguments,1):arguments,i[0].apply(i[1]||this,o)):(t.splice(s,1),s--,c--);return this}}),define("ubnt/TimerEvent",{TIMER_COMPLETE:"timer complete",TIMER:"timer"}),define("ubnt/Timer",["underscore","ubnt/EventDispatcher","ubnt/TimerEvent"],function(e,t,a){"use strict";var n=function(t,a){e.bindAll(this),this._delay=t,this._repeatCount=a||0,this._interval=void 0,this._currentCount=0,this._isRunning=!1};return e.extend(n.prototype,t,{setRunning:function(){throw new Error("running is read-only")},setCurrentCount:function(){throw new Error("currentCount is read-only")},setDelay:function(e){this._delay=e},setRepeatCount:function(e){this._repeatCount=e||0},reset:function(){this.stop(),this._currentCount=0},start:function(){this._interval||this._repeatCount&&this._currentCount>=this._repeatCount||(this._interval=setTimeout(this.tick,this._delay))},stop:function(){this._interval&&clearTimeout(this._interval),this._interval=void 0},tick:function(){return this._currentCount+=1,this._repeatCount&&this._currentCount>=this._repeatCount?(this.reset(),void this.trigger(a.TIMER_COMPLETE,{target:this})):(this._interval=setTimeout(this.tick,this._delay),void this.trigger(a.TIMER))}}),n}),define("ubnt/view/map/MarkerView",["backbone","underscore","ubnt/Timer","ubnt/TimerEvent","jquery"],function(e,t,a,n,i){"use strict";return e.View.extend({_fullyQualifiedName:"UBNT.views.map.Marker",initialize:function(e){t.bindAll(this),this.isHoldToDrag=!1,this.isMoving=!1,this.el=this.template({}),this.$el=i(this.el),this.$el.draggable({}).data("view",this),this.$marker=this.$(".marker-button"),this.$el.removeClass("expand"),this.$el.addClass("ap-model-"+this.model.get("model")),this.initHandlers(),this.render()},initHandlers:function(){this.isHoldToDrag&&(this.holdTimer=new a(500,1),this.holdTimer.bind(n.TIMER_COMPLETE,this.enableMove)),this.$el.on("drag",this.dragHandler),this.$el.on("dragstop",this.dragStopHandler),this.bindHandlers()},bindHandlers:function(){this.$marker.on("mousedown",this.markerMouseDownHandler),this.isHoldToDrag&&this.$marker.on("mouseout",this.holdTimer.reset)},dragHandler:function(){return this.isMoving?(this.setExpanded(!1),this.trigger("markerchange"),!0):!1},dragStopHandler:function(e,t){this.trigger("dragstop",e,t)},render:function(){},show:function(){this.$el.show()},hide:function(){this.$el.hide()},pulse:function(){this.$el.addClass("show-halo")},enableMove:function(){this.isMoving=!0,this.isHoldToDrag&&(this.$el.addClass("show-move"),this.$el.removeClass("expand")),this.trigger("dragstart",this)},disableMove:function(){this.$el.removeClass("show-move"),this.isMoving=!1,this.trigger("dragstop",this)},setPosition:function(e,t){this.x=e,this.y=t,this.$el.css({left:this.x,top:this.y})},setExpanded:function(e){e?this.isExpanded||(this.$el.addClass("expand"),this.trigger("markerselect",this)):this.isExpanded&&(this.$el.removeClass("expand"),this.trigger("markerdeselect",this))},markerMouseDownHandler:function(e){this.isHoldToDrag&&this.holdTimer.start(),this.$el.toggleClass("expand"),this.isExpanded()?this.trigger("markerselect",this):this.trigger("markerdeselect",this),this.trigger("markerchange",this),this.isHoldToDrag||this.enableMove(),i("body").bind("mouseup",this.markerMouseUpHandler)},isExpanded:function(){return this.$el.hasClass("expand")},markerMouseUpHandler:function(e){this.isHoldToDrag&&this.holdTimer.reset(),this.disableMove(),i("body").unbind("mouseup",this.markerMouseUpHandler)},handleRemoveClick:function(){this.save({map_id:"",x:"",y:""})},remove:function(){this.$el.off("drag",this.dragHandler),this.$el.off("dragstop",this.dragStopHandler),this.$marker.off("mousedown",this.markerMouseDownHandler),i("body").unbind("mouseup",this.markerMouseUpHandler),e.View.prototype.remove.apply(this,arguments)}})}),define("unifi/view/map/MarkerView",["ubnt/view/map/MarkerView","underscore","jquery","msg/Msg"],function(e,t,a,n){"use strict";return e.extend({initialize:function(a){t.bindAll(this),this.template=this.options.template,this.map=this.options.map,e.prototype.initialize.apply(this,[a]),this.updateState(),this.updateUplink()},initHandlers:function(){e.prototype.initHandlers.apply(this,[]),this.$lockButton=this.$(".lock"),this.$configButton=this.$(".config"),this.$scanButton=this.$(".scan"),this.$removeButton=this.$(".remove"),this.$lockButtonIcon=this.$lockButton.find(".icon"),this.$lockButton.on("click",this.lockClickHandler),this.$configButton.on("click",this.configClickHandler),this.$removeButton.on("click",this.handleRemoveClick),this.model.isGen2Ap()&&(this.$scanButton.on("click",this.scanClickHandler),this.$el.addClass("gen-2")),this.listenTo(this.model,"change:name",this.updateName),this.listenTo(this.model,"change:mac",this.updateMac),this.listenTo(this.model,"change:user-num_sta",this.updateUsers),this.listenTo(this.model,"change:user-num_sta",this.updateUsers),this.listenTo(this.model,"change:na-user-num_sta",this.updateUsers),this.listenTo(this.model,"change:na-guest-num_sta",this.updateGuests),this.listenTo(this.model,"change:ng-guest-num_sta",this.updateGuests),this.listenTo(this.model,"change:ng-guest-num_sta",this.updateGuests),this.listenTo(this.model,"change:state",this.updateState),this.listenTo(this.model,"change:uplink",this.updateUplink),this.listenTo(this.model,"change:locked",this.updateLocked),this.updateLocked()},updateLocked:function(){this.model.get("locked")?(this.$el.toggleClass("locked",!0),this.$el.draggable("disable"),this.$lockButtonIcon.removeClass("ubnt-icon-unlock").addClass("ubnt-icon-lock")):(this.$el.toggleClass("locked",!1),this.$el.draggable("enable"),this.$lockButtonIcon.removeClass("ubnt-icon-lock").addClass("ubnt-icon-unlock"))},enableMove:function(){this.model.get("locked")||e.prototype.enableMove.apply(this,arguments)},lockClickHandler:function(e){var t=!this.model.get("locked");this.$el.toggleClass("locked",t),this.$el.draggable(t?"disable":"enable"),t?this.$lockButtonIcon.removeClass("ubnt-icon-unlock").addClass("ubnt-icon-lock"):this.$lockButtonIcon.removeClass("ubnt-icon-lock").addClass("ubnt-icon-unlock"),this.app.isReadOnly?this.model.set({locked:t}):this.model.save({locked:t})},configClickHandler:function(e){var a=this;if(this.app.routers.devices.views.index.properties[this.model.get("mac")]){var n=function(){a.app.routers.devices.views.index.properties[a.model.get("mac")].setSection("config")};t.delay(n,0)}else this.app.routers.devices.views.index.property(this.model,{section:"config"})},scanClickHandler:function(e){var a=this;if(this.app.routers.devices.views.index.properties[this.model.get("mac")]){var n=function(){a.app.routers.devices.views.index.properties[a.model.get("mac")].setSection("rfMap")};t.delay(n,0)}else this.app.routers.devices.views.index.property(this.model,{section:"rfMap"})},handleRemoveClick:function(t){this.model.get("locked")||e.prototype.handleRemoveClick.apply(this,arguments)},render:function(){e.prototype.render.apply(this,[]);var t=this;!this.rendered&&(this.rendered=!0)&&(this.$details=this.$(".details"),a(".ruler").on("scaled",this.updateRulerScale),this.$coverageToggle2g=a("#mapFilterCoverage2G"),this.$coverageToggle2g.on("change",function(){t.is2gCoverageEnabled=t.$coverageToggle2g.is(":checked"),t.updateUsers(),t.updateGuests()}),this.$coverageToggle5g=a("#mapFilterCoverage5G"),this.$coverageToggle5g.on("change",function(){t.is2gCoverageEnabled=!t.$coverageToggle5g.is(":checked"),t.updateUsers(),t.updateGuests()}),this.is2gCoverageEnabled=this.$coverageToggle2g.is(":checked")),this.updateName(),this.updateMac(),this.updateUsers(),this.updateGuests(),this.$(".marker-icon").addClass(this.model.apIcon()),this.$el.addClass(this.model.get("type"))},updateName:function(){this.$(".title").text(this.model.name());var e="";switch(this.model.get("type")){case this.model.typeMap.ap:e="AP";break;case this.model.typeMap.gateway:e="Gateway";break;case this.model.typeMap["switch"]:e="Switch";break;case this.model.typeMap.phone:e="Phone"}this.$details.find(".ap-name").text(this.model.get("name")||"Unnamed "+e)},updateMac:function(){this.$details.find(".mac").text(this.model.get("mac"))},updateUsers:function(){if(this.model.get("type")===this.model.typeMap.phone)this.$details.find(".users").parent().hide();else{var e=this.model.get("user-num_sta"),t=this.is2gCoverageEnabled?this.model.get("ng-user-num_sta"):this.model.get("na-user-num_sta");this.model.get("type")===this.model.typeMap.ap?this.$details.find(".users").text((t||0)+" / "+(e||0)):this.$details.find(".users").text(e||0)}},updateGuests:function(){if(this.model.get("type")===this.model.typeMap.phone)this.$details.find(".guests").parent().hide();else{var e=this.model.get("guest-num_sta"),t=this.is2gCoverageEnabled?this.model.get("ng-guest-num_sta"):this.model.get("na-guest-num_sta");this.model.get("type")===this.model.typeMap.ap?this.$details.find(".guests").text((t||0)+" / "+(e||0)):this.$details.find(".guests").text(e||0)}},updateState:function(){this.model.isConnected()?this.$el.addClass("ap-connected").removeClass("ap-disconnected"):this.$el.addClass("ap-disconnected").removeClass("ap-connected"),11===parseInt(this.model.get("state"),10)?this.$el.addClass("ap-isolated"):this.$el.removeClass("ap-isolated")},updateUplink:function(){var e=this.model.uplink();e&&"ath0"==e.name?this.$el.addClass("ap-vwireless"):this.$el.removeClass("ap-vwireless")},updateRulerScale:function(e,t,a){this.map.model.set({upp:t,unit:a}),this.map.$el.click()},save:function(e){this.app.isReadOnly?this.model.set({map_id:void 0!==e.map_id?e.map_id:this.model.get("map_id"),x:void 0!==e.x?e.x:this.model.get("x"),y:void 0!==e.y?e.y:this.model.get("y"),locked:void 0!==e.locked?e.locked:this.model.get("locked")}):(this.model.unset("x",{silent:!0}),this.model.unset("y",{silent:!0}),this.model.unset("map_id",{silent:!0}),this.model.unset("locked",{silent:!0}),this.model.save({map_id:void 0!==e.map_id?e.map_id:this.model.get("map_id"),x:void 0!==e.x?e.x:this.model.get("x"),y:void 0!==e.y?e.y:this.model.get("y"),locked:void 0!==e.locked?e.locked:this.model.get("locked")}))},pulse:function(){this.$el.stop().effect("pulsate",{times:2},2500)},remove:function(){this.$lockButton.off("click",this.lockClickHandler),this.$configButton.off("click",this.configClickHandler),this.$scanButton.on("scan",this.scanClickHandler),this.$removeButton.off("click",this.handleRemoveClick),this.stopListening(this.model,"change:name",this.updateName),this.stopListening(this.model,"change:mac",this.updateMac),this.stopListening(this.model,"change:user-num_sta",this.updateUsers),this.stopListening(this.model,"change:guest-num_sta",this.updateGuests),this.stopListening(this.model,"change:state",this.updateState),this.stopListening(this.model,"change:uplink",this.updateUplink),a(".ruler").off("scaled",this.updateRulerScale),this.rfMap&&(this.rfMap.remove(),this.rfMap=null),this.rendered=!1,e.prototype.remove.apply(this,arguments)}})}),define("ubnt/view/map/UnplacedMarkerView",["backbone","underscore","jquery"],function(e,t,a){"use strict";return e.View.extend({initialize:function(){var e=this;t.bindAll(this),this.el=this.template({}),this.$el=a(this.el),this.draggableTemplate=this.options.draggableTemplate||this.draggableTemplate,this.$draggableHelper=a(this.draggableTemplate({})),this.$draggableHelper.addClass("ap-model-"+this.model.get("model")),this.$el.addClass("unplaced-marker ap-model-"+this.model.get("model")).draggable({appendTo:"#Map",helper:function(){return e.$draggableHelper.get(0)},cursorAt:{right:0,bottom:0}}),this.$draggableHelper.data("view",this),this.model.bind("change",this.updateMarker),this.model.bind("remove",this.removeMarker),this.updateMarker(this.model)},updateMarker:function(e){e.isConnected()?(this.$el.addClass("ap-connected").removeClass("ap-disconnected"),this.$draggableHelper.addClass("ap-connected").removeClass("ap-disconnected")):(this.$el.addClass("ap-disconnected").removeClass("ap-connected"),this.$draggableHelper.addClass("ap-disconnected").removeClass("ap-connected"))},remove:function(){this.model.unbind("change",this.updateMarker),this.model.unbind("remove",this.removeMarker),e.View.prototype.remove.apply(this,arguments)}})}),define("ubnt/view/map/MarkerDrawerView",["backbone","underscore","ubnt/view/map/UnplacedMarkerView","jquery"],function(e,t,a,n){"use strict";return e.View.extend({_fullyQualifiedName:"UBNT.views.map.MarkerDrawer",initialize:function(){t.bindAll(this),this.$markerList=this.$(".marker-list"),this.markerViews={},this.markerView=this.options.markerView||a,this.unplacedMarkerTemplate=this.options.unplacedMarkerTemplate,this.unplacedMarkerDraggableTemplate=this.options.unplacedMarkerDraggableTemplate,this.collections={},this.collections.markers=this.options.markers,this.collections.maps=this.options.maps,this.listenTo(this.collections.markers,"add",this.addMarker),this.listenTo(this.collections.markers,"change",this.updateMarker),this.listenTo(this.collections.markers,"reset",this.resetMarkers),
this.listenTo(this.collections.markers,"remove",this.removeMarker),this.$unplacedMarkerCountElt=this.$(".unplaced-markers-count")},render:function(){return this.isRendered||(this.isRendered=!0,this.resetMarkers()),this.$el},isMarkerMappable:function(e){return e.id&&e.get("adopted")},addMultipleMarkers:function(e){var t,a,n,i,o=this,r=e.length,s=document.createDocumentFragment();for(i=0;r>i;i++)t=e[i],a=t.get("map_id"),a||o.collections.maps.get(a)||!o.isMarkerMappable(t)||(n=new o.markerView({model:t,template:o.unplacedMarkerTemplate,draggableTemplate:o.unplacedMarkerDraggableTemplate}),n.render(),s.appendChild(n.$el[0]),o.markerViews[t.id]=n);o.$markerList.append(s),o.updateUnplacedMarkerCount()},addMarker:function(e){if((!e.get("map_id")||!this.collections.maps.get(e.get("map_id"))||this.isMarkerMappable(e))&&e.id){var t=new this.markerView({model:e,template:this.unplacedMarkerTemplate,draggableTemplate:this.unplacedMarkerDraggableTemplate});t.render(),this.$markerList.append(t.$el),this.markerViews[e.id]=t,this.updateUnplacedMarkerCount()}},updateMarker:function(e){e.changedAttributes();this.isMarkerMappable(e)&&(e.get("map_id")||this.collections.maps.get(e.get("map_id"))?this.removeMarker(e):(null===this.markerViews[e.id]||void 0===this.markerViews[e.id])&&this.addMarker(e))},resetMarkers:function(){n.each(this.markerViews,function(e,t){t.remove()}),this.markerViews={},this.addMultipleMarkers(this.collections.markers.models),this.updateUnplacedMarkerCount()},removeMarker:function(e){this.markerViews[e.id]&&(this.markerViews[e.id].remove(),delete this.markerViews[e.id],this.updateUnplacedMarkerCount())},hasUnplacedMarkers:function(){return n.isEmptyObject(this.markerViews)?!1:!0},updateUnplacedMarkerCount:function(){var e=t.size(this.markerViews);this.$unplacedMarkerCountElt.text(e),e?this.show():this.hide()},show:function(){this.$el.show()},hide:function(){this.$el.hide()},remove:function(){this.stopListening(this.collections.markers,"add",this.addMarker),this.stopListening(this.collections.markers,"change",this.updateMarker),this.stopListening(this.collections.markers,"reset",this.resetMarkers),this.stopListening(this.collections.markers,"remove",this.removeMarker),this.isRendered=!1,e.View.prototype.remove.apply(this,arguments)}})}),define("unifi/view/map/UnplacedMarkerView",["ubnt/view/map/UnplacedMarkerView","underscore"],function(e,t){"use strict";return e.extend({initialize:function(t){this.template=this.options.template,this.listenTo(this.model,"change:name",this.updateName),e.prototype.initialize.apply(this,[t]),this.$itemLabel=this.$(".item-label"),this.$UIicon=this.$(".ui-icon"),this.$draggableHelperUIicon=this.$draggableHelper.find(".ui-icon")},render:function(){this.updateName(),this.$UIicon.addClass(this.model.apIcon()),this.$draggableHelperUIicon.addClass(this.model.apIcon()).text(this.model.name()),this.listenTo(this.model,"change:state",this.updateState),this.updateState()},updateName:function(){this.$itemLabel.html(t.escape(this.model.name()))},updateState:function(){this.model.isConnected()?this.$el.addClass("ap-connected"):this.$el.addClass("ap-disconnected"),11===parseInt(this.model.get("state"),10)?this.$el.addClass("ap-isolated"):this.$el.removeClass("ap-isolated")},remove:function(){this.stopListening(this.model,"change:name",this.updateName),this.stopListening(this.model,"change:state",this.updateState),e.prototype.remove.apply(this,arguments)}})}),define("ubnt/view/map/MapBase",["backbone","underscore","jquery","msg/Msg"],function(e,t,a,n){"use strict";return e.View.extend({_fullyQualifiedName:"UBNT.views.map.MapBase",initialize:function(){t.bindAll(this),this.collections={},this.collections.markers=this.options.markers,this.MarkerView=this.options.markerView,this.markerTemplate=this.options.markerTemplate,this.markerViews={},this.layers={},this.layerItems={},this.layerZ=1},bindHandlers:function(){this.collections.markers.on("add",this.addMarker),this.collections.markers.on("change",this.updateMarker),this.collections.markers.on("reset",this.resetMarkers),this.collections.markers.on("remove",this.removeMarker),t.each(this.layers,function(e){e.bindHandlers()},this)},unbindHandlers:function(){this.collections.markers.off("add",this.addMarker),this.collections.markers.off("change",this.updateMarker),this.collections.markers.off("reset",this.resetMarkers),this.collections.markers.off("remove",this.removeMarker),t.each(this.layers,function(e){e.unbindHandlers()},this)},getMap:function(){return this.model},show:function(){this.$el.show()},hide:function(){this.$el.hide()},resize:function(){},mapChangeHandler:function(){},toggleLabels:function(){a.each(this.markers,function(e,t){t.toggleLabel()})},toggleDetails:function(){a.each(this.markers,function(e,t){t.toggleDetail()})},bringLayerItemToTop:function(e){var t=this.layerItems[e.cid];t&&(t.$el.css("zIndex",this.layerZ),this.layerZ++)},addMarker:function(e,t){var a=e.get("map_id"),i=e.id;if(this.model&&t&&a==this.model.id&&(null===this.markerViews[i]||void 0===this.markerViews[i])){var o=new this.MarkerView({model:e,map:this,template:this.markerTemplate});o.bind("markerselect",this.markerSelectHandler),o.bind("markerdeselect",this.markerDeselectHandler),this.markerViews[i]=o;var r=o.$(".detail.mac-text"),s=o.$(".detail.channel-text"),c=o.$(".detail.users-text"),d=o.$(".detail.guests-text");r.find("span").text(n.G_MapMAC),s.find("span").text(n.G_MapChannel),c.find("span").text(n.G_MapUsers),d.find("span").text(n.G_MapGuests)}},updateMarker:function(){throw"updateMarker: You must override this function."},resetMarkers:function(){t.each(this.markerViews,function(e){this.removeMarker(e.model)},this),this.markerViews={},this.collections.markers.each(function(e){this.addMarker(e)},this)},removeMarker:function(e){var t=this.markerViews[e.id];t&&(this.markerViews[e.id].remove(),delete this.markerViews[e.id],this.trigger("mapremovemarker",t))},getMarkers:function(){return this.markerViews},addLayerItem:function(){throw"addLayerItem: You must override this function."},removeLayerItem:function(){throw"removeLayerItem: You must override this function."},dropHandler:function(){throw"dropHandler: You must override this function."},enableMapDrag:function(){throw"enableMapDrag: You must override this function."},disableMapDrag:function(){throw"disableMapDrag: You must override this function."},computeDistanceBetween:function(){throw"computeDistanceBetween: You must override this function."},computeOffset:function(){throw"computeOffset: You must override this function."},translateToPixelCoordinates:function(){throw"translateToPixelCoordinates: You must override this function."},translateToMapCoordinates:function(){throw"translateToMapCoordinates: You must override this function."},markerSelectHandler:function(e){t.each(this.markerViews,function(t){t!==e&&t.setExpanded(!1)},this)},markerDeselectHandler:function(){},remove:function(){this.unbindHandlers(),t.each(this.markerViews,function(e){e.unbind("markerselect",this.markerSelectHandler),e.unbind("markerdeselect",this.markerDeselectHandler)},this),e.View.prototype.remove.apply(this,arguments)}},{MAP_PANE:"mapPane",OVERLAY_LAYER:"overlayLayer",OVERLAY_SHADOW:"overlayShadow",OVERLAY_IMAGE:"overlayImage",FLOAT_SHADOW:"floatShadow",OVERLAY_MOUSE_TARGET:"overlayMouseTarget",FLOAT_PANE:"floatPane"})}),define("ubnt/view/map/GoogleMapOverlayWrapperView",[],function(){"use strict";return{Overlay:function(e,t){return this.view=e,this},initialize:function(){this.Overlay.prototype=new google.maps.OverlayView,this.Overlay.prototype.onAdd=function(){var e=this.getPanes();e[this.view.getPane()].appendChild(this.view.$el.get(0))},this.Overlay.prototype.onRemove=function(){this.view.$el.hide()},this.Overlay.prototype.draw=function(){this.view.trigger("layeritemadded"),this.view.$el.show()},this.Overlay.prototype.hide=function(){this.view.$el.hide()},this.Overlay.prototype.show=function(){this.draw(),this.view.$el.show()},this.Overlay.prototype.toggle=function(){this.view.$el.toggle()}}}}),!function(){function e(e,t){return t>e?-1:e>t?1:e>=t?0:NaN}function t(e){return null===e?NaN:+e}function a(e){return!isNaN(e)}function n(e){return{left:function(t,a,n,i){for(arguments.length<3&&(n=0),arguments.length<4&&(i=t.length);i>n;){var o=n+i>>>1;e(t[o],a)<0?n=o+1:i=o}return n},right:function(t,a,n,i){for(arguments.length<3&&(n=0),arguments.length<4&&(i=t.length);i>n;){var o=n+i>>>1;e(t[o],a)>0?i=o:n=o+1}return n}}}function i(e){return e.length}function o(e){for(var t=1;e*t%1;)t*=10;return t}function r(e,t){for(var a in t)Object.defineProperty(e.prototype,a,{value:t[a],enumerable:!1})}function s(){this._=Object.create(null)}function c(e){return(e+="")===lr||e[0]===mr?mr+e:e}function d(e){return(e+="")[0]===mr?e.slice(1):e}function l(e){return c(e)in this._}function m(e){return(e=c(e))in this._&&delete this._[e]}function g(){var e=[];for(var t in this._)e.push(d(t));return e}function u(){var e=0;for(var t in this._)++e;return e}function h(){for(var e in this._)return!1;return!0}function p(){this._=Object.create(null)}function y(e,t,a){return function(){var n=a.apply(t,arguments);return n===t?e:n}}function _(e,t){if(t in e)return t;t=t.charAt(0).toUpperCase()+t.slice(1);for(var a=0,n=gr.length;n>a;++a){var i=gr[a]+t;if(i in e)return i}}function f(){}function v(){}function b(e){function t(){for(var t,n=a,i=-1,o=n.length;++i<o;)(t=n[i].on)&&t.apply(this,arguments);return e}var a=[],n=new s;return t.on=function(t,i){var o,r=n.get(t);return arguments.length<2?r&&r.on:(r&&(r.on=null,a=a.slice(0,o=a.indexOf(r)).concat(a.slice(o+1)),n.remove(t)),i&&a.push(n.set(t,{on:i})),e)},t}function w(){Xo.event.preventDefault()}function S(){for(var e,t=Xo.event;e=t.sourceEvent;)t=e;return t}function C(e){for(var t=new v,a=0,n=arguments.length;++a<n;)t[arguments[a]]=b(t);return t.of=function(a,n){return function(i){try{var o=i.sourceEvent=Xo.event;i.target=e,Xo.event=i,t[i.type].apply(a,n)}finally{Xo.event=o}}},t}function x(e){return hr(e,vr),e}function k(e){return"function"==typeof e?e:function(){return pr(e,this)}}function M(e){return"function"==typeof e?e:function(){return yr(e,this)}}function P(e,t){function a(){this.removeAttribute(e)}function n(){this.removeAttributeNS(e.space,e.local)}function i(){this.setAttribute(e,t)}function o(){this.setAttributeNS(e.space,e.local,t)}function r(){var a=t.apply(this,arguments);null==a?this.removeAttribute(e):this.setAttribute(e,a)}function s(){var a=t.apply(this,arguments);null==a?this.removeAttributeNS(e.space,e.local):this.setAttributeNS(e.space,e.local,a)}return e=Xo.ns.qualify(e),null==t?e.local?n:a:"function"==typeof t?e.local?s:r:e.local?o:i}function T(e){return e.trim().replace(/\s+/g," ")}function A(e){return new RegExp("(?:^|\\s+)"+Xo.requote(e)+"(?:\\s+|$)","g")}function D(e){return(e+"").trim().split(/^|\s+/)}function G(e,t){function a(){for(var a=-1;++a<i;)e[a](this,t)}function n(){for(var a=-1,n=t.apply(this,arguments);++a<i;)e[a](this,n)}e=D(e).map(F);var i=e.length;return"function"==typeof t?n:a}function F(e){var t=A(e);return function(a,n){if(i=a.classList)return n?i.add(e):i.remove(e);var i=a.getAttribute("class")||"";n?(t.lastIndex=0,t.test(i)||a.setAttribute("class",T(i+" "+e))):a.setAttribute("class",T(i.replace(t," ")))}}function $(e,t,a){function n(){this.style.removeProperty(e)}function i(){this.style.setProperty(e,t,a)}function o(){var n=t.apply(this,arguments);null==n?this.style.removeProperty(e):this.style.setProperty(e,n,a)}return null==t?n:"function"==typeof t?o:i}function N(e,t){function a(){delete this[e]}function n(){this[e]=t}function i(){var a=t.apply(this,arguments);null==a?delete this[e]:this[e]=a}return null==t?a:"function"==typeof t?i:n}function L(e){return"function"==typeof e?e:(e=Xo.ns.qualify(e)).local?function(){return this.ownerDocument.createElementNS(e.space,e.local)}:function(){return this.ownerDocument.createElementNS(this.namespaceURI,e)}}function E(e){return{__data__:e}}function R(e){return function(){return fr(this,e)}}function I(t){return arguments.length||(t=e),function(e,a){return e&&a?t(e.__data__,a.__data__):!e-!a}}function H(e,t){for(var a=0,n=e.length;n>a;a++)for(var i,o=e[a],r=0,s=o.length;s>r;r++)(i=o[r])&&t(i,r,a);return e}function B(e){return hr(e,wr),e}function O(e){var t,a;return function(n,i,o){var r,s=e[o].update,c=s.length;for(o!=a&&(a=o,t=0),i>=t&&(t=i+1);!(r=s[t])&&++t<c;);return r}}function U(){var e=this.__transition__;e&&++e.active}function V(e,t,a){function n(){var t=this[r];t&&(this.removeEventListener(e,t,t.$),delete this[r])}function i(){var i=c(t,Zo(arguments));n.call(this),this.addEventListener(e,this[r]=i,i.$=a),i._=t}function o(){var t,a=new RegExp("^__on([^.]+)"+Xo.requote(e)+"$");for(var n in this)if(t=n.match(a)){var i=this[n];this.removeEventListener(t[1],i,i.$),delete this[n]}}var r="__on"+e,s=e.indexOf("."),c=W;s>0&&(e=e.slice(0,s));var d=Cr.get(e);return d&&(e=d,c=z),s?t?i:n:t?f:o}function W(e,t){return function(a){var n=Xo.event;Xo.event=a,t[0]=this.__data__;try{e.apply(this,t)}finally{Xo.event=n}}}function z(e,t){var a=W(e,t);return function(e){var t=this,n=e.relatedTarget;n&&(n===t||8&n.compareDocumentPosition(t))||a.call(t,e)}}function K(){var e=".dragsuppress-"+ ++kr,t="click"+e,a=Xo.select(er).on("touchmove"+e,w).on("dragstart"+e,w).on("selectstart"+e,w);if(xr){var n=Qo.style,i=n[xr];n[xr]="none"}return function(o){function r(){a.on(t,null)}a.on(e,null),xr&&(n[xr]=i),o&&(a.on(t,function(){w(),r()},!0),setTimeout(r,0))}}function j(e,t){t.changedTouches&&(t=t.changedTouches[0]);var a=e.ownerSVGElement||e;if(a.createSVGPoint){var n=a.createSVGPoint();if(0>Mr&&(er.scrollX||er.scrollY)){a=Xo.select("body").append("svg").style({position:"absolute",top:0,left:0,margin:0,padding:0,border:"none"},"important");var i=a[0][0].getScreenCTM();Mr=!(i.f||i.e),a.remove()}return Mr?(n.x=t.pageX,n.y=t.pageY):(n.x=t.clientX,n.y=t.clientY),n=n.matrixTransform(e.getScreenCTM().inverse()),[n.x,n.y]}var o=e.getBoundingClientRect();return[t.clientX-o.left-e.clientLeft,t.clientY-o.top-e.clientTop]}function q(){return Xo.event.changedTouches[0].identifier}function X(){return Xo.event.target}function Y(){return er}function Z(e){return e>0?1:0>e?-1:0}function J(e,t,a){return(t[0]-e[0])*(a[1]-e[1])-(t[1]-e[1])*(a[0]-e[0])}function Q(e){return e>1?0:-1>e?Pr:Math.acos(e)}function ee(e){return e>1?Ar:-1>e?-Ar:Math.asin(e)}function te(e){return((e=Math.exp(e))-1/e)/2}function ae(e){return((e=Math.exp(e))+1/e)/2}function ne(e){return((e=Math.exp(2*e))-1)/(e+1)}function ie(e){return(e=Math.sin(e/2))*e}function oe(){}function re(e,t,a){return this instanceof re?(this.h=+e,this.s=+t,void(this.l=+a)):arguments.length<2?e instanceof re?new re(e.h,e.s,e.l):be(""+e,we,re):new re(e,t,a)}function se(e,t,a){function n(e){return e>360?e-=360:0>e&&(e+=360),60>e?o+(r-o)*e/60:180>e?r:240>e?o+(r-o)*(240-e)/60:o}function i(e){return Math.round(255*n(e))}var o,r;return e=isNaN(e)?0:(e%=360)<0?e+360:e,t=isNaN(t)?0:0>t?0:t>1?1:t,a=0>a?0:a>1?1:a,r=.5>=a?a*(1+t):a+t-a*t,o=2*a-r,new ye(i(e+120),i(e),i(e-120))}function ce(e,t,a){return this instanceof ce?(this.h=+e,this.c=+t,void(this.l=+a)):arguments.length<2?e instanceof ce?new ce(e.h,e.c,e.l):e instanceof le?ge(e.l,e.a,e.b):ge((e=Se((e=Xo.rgb(e)).r,e.g,e.b)).l,e.a,e.b):new ce(e,t,a)}function de(e,t,a){return isNaN(e)&&(e=0),isNaN(t)&&(t=0),new le(a,Math.cos(e*=Fr)*t,Math.sin(e)*t)}function le(e,t,a){return this instanceof le?(this.l=+e,this.a=+t,void(this.b=+a)):arguments.length<2?e instanceof le?new le(e.l,e.a,e.b):e instanceof ce?de(e.h,e.c,e.l):Se((e=ye(e)).r,e.g,e.b):new le(e,t,a)}function me(e,t,a){var n=(e+16)/116,i=n+t/500,o=n-a/200;return i=ue(i)*Vr,n=ue(n)*Wr,o=ue(o)*zr,new ye(pe(3.2404542*i-1.5371385*n-.4985314*o),pe(-.969266*i+1.8760108*n+.041556*o),pe(.0556434*i-.2040259*n+1.0572252*o))}function ge(e,t,a){return e>0?new ce(Math.atan2(a,t)*$r,Math.sqrt(t*t+a*a),e):new ce(NaN,NaN,e)}function ue(e){return e>.206893034?e*e*e:(e-4/29)/7.787037}function he(e){return e>.008856?Math.pow(e,1/3):7.787037*e+4/29}function pe(e){return Math.round(255*(.00304>=e?12.92*e:1.055*Math.pow(e,1/2.4)-.055))}function ye(e,t,a){return this instanceof ye?(this.r=~~e,this.g=~~t,void(this.b=~~a)):arguments.length<2?e instanceof ye?new ye(e.r,e.g,e.b):be(""+e,ye,se):new ye(e,t,a)}function _e(e){return new ye(e>>16,e>>8&255,255&e)}function fe(e){return _e(e)+""}function ve(e){return 16>e?"0"+Math.max(0,e).toString(16):Math.min(255,e).toString(16)}function be(e,t,a){var n,i,o,r=0,s=0,c=0;if(n=/([a-z]+)\((.*)\)/i.exec(e))switch(i=n[2].split(","),n[1]){case"hsl":return a(parseFloat(i[0]),parseFloat(i[1])/100,parseFloat(i[2])/100);case"rgb":return t(xe(i[0]),xe(i[1]),xe(i[2]))}return(o=qr.get(e))?t(o.r,o.g,o.b):(null==e||"#"!==e.charAt(0)||isNaN(o=parseInt(e.slice(1),16))||(4===e.length?(r=(3840&o)>>4,r=r>>4|r,s=240&o,s=s>>4|s,c=15&o,c=c<<4|c):7===e.length&&(r=(16711680&o)>>16,s=(65280&o)>>8,c=255&o)),t(r,s,c))}function we(e,t,a){var n,i,o=Math.min(e/=255,t/=255,a/=255),r=Math.max(e,t,a),s=r-o,c=(r+o)/2;return s?(i=.5>c?s/(r+o):s/(2-r-o),n=e==r?(t-a)/s+(a>t?6:0):t==r?(a-e)/s+2:(e-t)/s+4,n*=60):(n=NaN,i=c>0&&1>c?0:n),new re(n,i,c)}function Se(e,t,a){e=Ce(e),t=Ce(t),a=Ce(a);var n=he((.4124564*e+.3575761*t+.1804375*a)/Vr),i=he((.2126729*e+.7151522*t+.072175*a)/Wr),o=he((.0193339*e+.119192*t+.9503041*a)/zr);return le(116*i-16,500*(n-i),200*(i-o))}function Ce(e){return(e/=255)<=.04045?e/12.92:Math.pow((e+.055)/1.055,2.4)}function xe(e){var t=parseFloat(e);return"%"===e.charAt(e.length-1)?Math.round(2.55*t):t}function ke(e){return"function"==typeof e?e:function(){return e}}function Me(e){return e}function Pe(e){return function(t,a,n){return 2===arguments.length&&"function"==typeof a&&(n=a,a=null),Te(t,a,e,n)}}function Te(e,t,a,n){function i(){var e,t=c.status;if(!t&&De(c)||t>=200&&300>t||304===t){try{e=a.call(o,c)}catch(n){return void r.error.call(o,n)}r.load.call(o,e)}else r.error.call(o,c)}var o={},r=Xo.dispatch("beforesend","progress","load","error"),s={},c=new XMLHttpRequest,d=null;return!er.XDomainRequest||"withCredentials"in c||!/^(http(s)?:)?\/\//.test(e)||(c=new XDomainRequest),"onload"in c?c.onload=c.onerror=i:c.onreadystatechange=function(){c.readyState>3&&i()},c.onprogress=function(e){var t=Xo.event;Xo.event=e;try{r.progress.call(o,c)}finally{Xo.event=t}},o.header=function(e,t){return e=(e+"").toLowerCase(),arguments.length<2?s[e]:(null==t?delete s[e]:s[e]=t+"",o)},o.mimeType=function(e){return arguments.length?(t=null==e?null:e+"",o):t},o.responseType=function(e){return arguments.length?(d=e,o):d},o.response=function(e){return a=e,o},["get","post"].forEach(function(e){o[e]=function(){return o.send.apply(o,[e].concat(Zo(arguments)))}}),o.send=function(a,n,i){if(2===arguments.length&&"function"==typeof n&&(i=n,n=null),c.open(a,e,!0),null==t||"accept"in s||(s.accept=t+",*/*"),c.setRequestHeader)for(var l in s)c.setRequestHeader(l,s[l]);return null!=t&&c.overrideMimeType&&c.overrideMimeType(t),null!=d&&(c.responseType=d),null!=i&&o.on("error",i).on("load",function(e){i(null,e)}),r.beforesend.call(o,c),c.send(null==n?null:n),o},o.abort=function(){return c.abort(),o},Xo.rebind(o,r,"on"),null==n?o:o.get(Ae(n))}function Ae(e){return 1===e.length?function(t,a){e(null==t?a:null)}:e}function De(e){var t=e.responseType;return t&&"text"!==t?e.response:e.responseText}function Ge(){var e=Fe(),t=$e()-e;t>24?(isFinite(t)&&(clearTimeout(Jr),Jr=setTimeout(Ge,t)),Zr=0):(Zr=1,es(Ge))}function Fe(){var e=Date.now();for(Qr=Xr;Qr;)e>=Qr.t&&(Qr.f=Qr.c(e-Qr.t)),Qr=Qr.n;return e}function $e(){for(var e,t=Xr,a=1/0;t;)t.f?t=e?e.n=t.n:Xr=t.n:(t.t<a&&(a=t.t),t=(e=t).n);return Yr=e,a}function Ne(e,t){return t-(e?Math.ceil(Math.log(e)/Math.LN10):1)}function Le(e,t){var a=Math.pow(10,3*dr(8-t));return{scale:t>8?function(e){return e/a}:function(e){return e*a},symbol:e}}function Ee(e){var t=e.decimal,a=e.thousands,n=e.grouping,i=e.currency,o=n&&a?function(e,t){for(var i=e.length,o=[],r=0,s=n[0],c=0;i>0&&s>0&&(c+s+1>t&&(s=Math.max(1,t-c)),o.push(e.substring(i-=s,i+s)),!((c+=s+1)>t));)s=n[r=(r+1)%n.length];return o.reverse().join(a)}:Me;return function(e){var a=as.exec(e),n=a[1]||" ",r=a[2]||">",s=a[3]||"-",c=a[4]||"",d=a[5],l=+a[6],m=a[7],g=a[8],u=a[9],h=1,p="",y="",_=!1,f=!0;switch(g&&(g=+g.substring(1)),(d||"0"===n&&"="===r)&&(d=n="0",r="="),u){case"n":m=!0,u="g";break;case"%":h=100,y="%",u="f";break;case"p":h=100,y="%",u="r";break;case"b":case"o":case"x":case"X":"#"===c&&(p="0"+u.toLowerCase());case"c":f=!1;case"d":_=!0,g=0;break;case"s":h=-1,u="r"}"$"===c&&(p=i[0],y=i[1]),"r"!=u||g||(u="g"),null!=g&&("g"==u?g=Math.max(1,Math.min(21,g)):("e"==u||"f"==u)&&(g=Math.max(0,Math.min(20,g)))),u=ns.get(u)||Re;var v=d&&m;return function(e){var a=y;if(_&&e%1)return"";var i=0>e||0===e&&0>1/e?(e=-e,"-"):"-"===s?"":s;if(0>h){var c=Xo.formatPrefix(e,g);e=c.scale(e),a=c.symbol+y}else e*=h;e=u(e,g);var b,w,S=e.lastIndexOf(".");if(0>S){var C=f?e.lastIndexOf("e"):-1;0>C?(b=e,w=""):(b=e.substring(0,C),w=e.substring(C))}else b=e.substring(0,S),w=t+e.substring(S+1);!d&&m&&(b=o(b,1/0));var x=p.length+b.length+w.length+(v?0:i.length),k=l>x?new Array(x=l-x+1).join(n):"";return v&&(b=o(k+b,k.length?l-w.length:1/0)),i+=p,e=b+w,("<"===r?i+e+k:">"===r?k+i+e:"^"===r?k.substring(0,x>>=1)+i+e+k.substring(x):i+(v?e:k+e))+a}}}function Re(e){return e+""}function Ie(){this._=new Date(arguments.length>1?Date.UTC.apply(this,arguments):arguments[0])}function He(e,t,a){function n(t){var a=e(t),n=o(a,1);return n-t>t-a?a:n}function i(a){return t(a=e(new os(a-1)),1),a}function o(e,a){return t(e=new os(+e),a),e}function r(e,n,o){var r=i(e),s=[];if(o>1)for(;n>r;)a(r)%o||s.push(new Date(+r)),t(r,1);else for(;n>r;)s.push(new Date(+r)),t(r,1);return s}function s(e,t,a){try{os=Ie;var n=new Ie;return n._=e,r(n,t,a)}finally{os=Date}}e.floor=e,e.round=n,e.ceil=i,e.offset=o,e.range=r;var c=e.utc=Be(e);return c.floor=c,c.round=Be(n),c.ceil=Be(i),c.offset=Be(o),c.range=s,e}function Be(e){return function(t,a){try{os=Ie;var n=new Ie;return n._=t,e(n,a)._}finally{os=Date}}}function Oe(e){function t(e){function t(t){for(var a,i,o,r=[],s=-1,c=0;++s<n;)37===e.charCodeAt(s)&&(r.push(e.slice(c,s)),null!=(i=ss[a=e.charAt(++s)])&&(a=e.charAt(++s)),(o=T[a])&&(a=o(t,null==i?"e"===a?" ":"0":i)),r.push(a),c=s+1);return r.push(e.slice(c,s)),r.join("")}var n=e.length;return t.parse=function(t){var n={y:1900,m:0,d:1,H:0,M:0,S:0,L:0,Z:null},i=a(n,e,t,0);if(i!=t.length)return null;"p"in n&&(n.H=n.H%12+12*n.p);var o=null!=n.Z&&os!==Ie,r=new(o?Ie:os);return"j"in n?r.setFullYear(n.y,0,n.j):"w"in n&&("W"in n||"U"in n)?(r.setFullYear(n.y,0,1),r.setFullYear(n.y,0,"W"in n?(n.w+6)%7+7*n.W-(r.getDay()+5)%7:n.w+7*n.U-(r.getDay()+6)%7)):r.setFullYear(n.y,n.m,n.d),r.setHours(n.H+(n.Z/100|0),n.M+n.Z%100,n.S,n.L),o?r._:r},t.toString=function(){return e},t}function a(e,t,a,n){for(var i,o,r,s=0,c=t.length,d=a.length;c>s;){if(n>=d)return-1;if(i=t.charCodeAt(s++),37===i){if(r=t.charAt(s++),o=A[r in ss?t.charAt(s++):r],!o||(n=o(e,a,n))<0)return-1}else if(i!=a.charCodeAt(n++))return-1}return n}function n(e,t,a){S.lastIndex=0;var n=S.exec(t.slice(a));return n?(e.w=C.get(n[0].toLowerCase()),a+n[0].length):-1}function i(e,t,a){b.lastIndex=0;var n=b.exec(t.slice(a));return n?(e.w=w.get(n[0].toLowerCase()),a+n[0].length):-1}function o(e,t,a){M.lastIndex=0;var n=M.exec(t.slice(a));return n?(e.m=P.get(n[0].toLowerCase()),a+n[0].length):-1}function r(e,t,a){x.lastIndex=0;var n=x.exec(t.slice(a));return n?(e.m=k.get(n[0].toLowerCase()),a+n[0].length):-1}function s(e,t,n){return a(e,T.c.toString(),t,n)}function c(e,t,n){return a(e,T.x.toString(),t,n)}function d(e,t,n){return a(e,T.X.toString(),t,n)}function l(e,t,a){var n=v.get(t.slice(a,a+=2).toLowerCase());return null==n?-1:(e.p=n,a)}var m=e.dateTime,g=e.date,u=e.time,h=e.periods,p=e.days,y=e.shortDays,_=e.months,f=e.shortMonths;t.utc=function(e){function a(e){try{os=Ie;var t=new os;return t._=e,n(t)}finally{os=Date}}var n=t(e);return a.parse=function(e){try{os=Ie;var t=n.parse(e);return t&&t._}finally{os=Date}},a.toString=n.toString,a},t.multi=t.utc.multi=st;var v=Xo.map(),b=Ve(p),w=We(p),S=Ve(y),C=We(y),x=Ve(_),k=We(_),M=Ve(f),P=We(f);h.forEach(function(e,t){v.set(e.toLowerCase(),t)});var T={a:function(e){return y[e.getDay()]},A:function(e){return p[e.getDay()]},b:function(e){return f[e.getMonth()]},B:function(e){return _[e.getMonth()]},c:t(m),d:function(e,t){return Ue(e.getDate(),t,2)},e:function(e,t){return Ue(e.getDate(),t,2)},H:function(e,t){return Ue(e.getHours(),t,2)},I:function(e,t){return Ue(e.getHours()%12||12,t,2)},j:function(e,t){return Ue(1+is.dayOfYear(e),t,3)},L:function(e,t){return Ue(e.getMilliseconds(),t,3)},m:function(e,t){return Ue(e.getMonth()+1,t,2)},M:function(e,t){return Ue(e.getMinutes(),t,2)},p:function(e){return h[+(e.getHours()>=12)]},S:function(e,t){return Ue(e.getSeconds(),t,2)},U:function(e,t){return Ue(is.sundayOfYear(e),t,2)},w:function(e){return e.getDay()},W:function(e,t){return Ue(is.mondayOfYear(e),t,2)},x:t(g),X:t(u),y:function(e,t){return Ue(e.getFullYear()%100,t,2)},Y:function(e,t){return Ue(e.getFullYear()%1e4,t,4)},Z:ot,"%":function(){return"%"}},A={a:n,A:i,b:o,B:r,c:s,d:Qe,e:Qe,H:tt,I:tt,j:et,L:it,m:Je,M:at,p:l,S:nt,U:Ke,w:ze,W:je,x:c,X:d,y:Xe,Y:qe,Z:Ye,"%":rt};return t}function Ue(e,t,a){var n=0>e?"-":"",i=(n?-e:e)+"",o=i.length;return n+(a>o?new Array(a-o+1).join(t)+i:i)}function Ve(e){return new RegExp("^(?:"+e.map(Xo.requote).join("|")+")","i")}function We(e){for(var t=new s,a=-1,n=e.length;++a<n;)t.set(e[a].toLowerCase(),a);return t}function ze(e,t,a){cs.lastIndex=0;var n=cs.exec(t.slice(a,a+1));return n?(e.w=+n[0],a+n[0].length):-1}function Ke(e,t,a){cs.lastIndex=0;var n=cs.exec(t.slice(a));return n?(e.U=+n[0],a+n[0].length):-1}function je(e,t,a){cs.lastIndex=0;var n=cs.exec(t.slice(a));return n?(e.W=+n[0],a+n[0].length):-1}function qe(e,t,a){cs.lastIndex=0;var n=cs.exec(t.slice(a,a+4));return n?(e.y=+n[0],a+n[0].length):-1}function Xe(e,t,a){cs.lastIndex=0;var n=cs.exec(t.slice(a,a+2));return n?(e.y=Ze(+n[0]),a+n[0].length):-1}function Ye(e,t,a){return/^[+-]\d{4}$/.test(t=t.slice(a,a+5))?(e.Z=-t,a+5):-1}function Ze(e){return e+(e>68?1900:2e3)}function Je(e,t,a){cs.lastIndex=0;var n=cs.exec(t.slice(a,a+2));return n?(e.m=n[0]-1,a+n[0].length):-1}function Qe(e,t,a){cs.lastIndex=0;var n=cs.exec(t.slice(a,a+2));return n?(e.d=+n[0],a+n[0].length):-1}function et(e,t,a){cs.lastIndex=0;var n=cs.exec(t.slice(a,a+3));return n?(e.j=+n[0],a+n[0].length):-1}function tt(e,t,a){cs.lastIndex=0;var n=cs.exec(t.slice(a,a+2));return n?(e.H=+n[0],a+n[0].length):-1}function at(e,t,a){cs.lastIndex=0;var n=cs.exec(t.slice(a,a+2));return n?(e.M=+n[0],a+n[0].length):-1}function nt(e,t,a){cs.lastIndex=0;var n=cs.exec(t.slice(a,a+2));return n?(e.S=+n[0],a+n[0].length):-1}function it(e,t,a){cs.lastIndex=0;var n=cs.exec(t.slice(a,a+3));return n?(e.L=+n[0],a+n[0].length):-1}function ot(e){var t=e.getTimezoneOffset(),a=t>0?"-":"+",n=dr(t)/60|0,i=dr(t)%60;return a+Ue(n,"0",2)+Ue(i,"0",2)}function rt(e,t,a){ds.lastIndex=0;var n=ds.exec(t.slice(a,a+1));return n?a+n[0].length:-1}function st(e){for(var t=e.length,a=-1;++a<t;)e[a][0]=this(e[a][0]);return function(t){for(var a=0,n=e[a];!n[1](t);)n=e[++a];return n[0](t)}}function ct(){}function dt(e,t,a){var n=a.s=e+t,i=n-e,o=n-i;a.t=e-o+(t-i)}function lt(e,t){e&&us.hasOwnProperty(e.type)&&us[e.type](e,t)}function mt(e,t,a){var n,i=-1,o=e.length-a;for(t.lineStart();++i<o;)n=e[i],t.point(n[0],n[1],n[2]);t.lineEnd()}function gt(e,t){var a=-1,n=e.length;for(t.polygonStart();++a<n;)mt(e[a],t,1);t.polygonEnd()}function ut(){function e(e,t){e*=Fr,t=t*Fr/2+Pr/4;var a=e-n,r=a>=0?1:-1,s=r*a,c=Math.cos(t),d=Math.sin(t),l=o*d,m=i*c+l*Math.cos(s),g=l*r*Math.sin(s);ps.add(Math.atan2(g,m)),n=e,i=c,o=d}var t,a,n,i,o;ys.point=function(r,s){ys.point=e,n=(t=r)*Fr,i=Math.cos(s=(a=s)*Fr/2+Pr/4),o=Math.sin(s)},ys.lineEnd=function(){e(t,a)}}function ht(e){var t=e[0],a=e[1],n=Math.cos(a);return[n*Math.cos(t),n*Math.sin(t),Math.sin(a)]}function pt(e,t){return e[0]*t[0]+e[1]*t[1]+e[2]*t[2]}function yt(e,t){return[e[1]*t[2]-e[2]*t[1],e[2]*t[0]-e[0]*t[2],e[0]*t[1]-e[1]*t[0]]}function _t(e,t){e[0]+=t[0],e[1]+=t[1],e[2]+=t[2]}function ft(e,t){return[e[0]*t,e[1]*t,e[2]*t]}function vt(e){var t=Math.sqrt(e[0]*e[0]+e[1]*e[1]+e[2]*e[2]);e[0]/=t,e[1]/=t,e[2]/=t}function bt(e){return[Math.atan2(e[1],e[0]),ee(e[2])]}function wt(e,t){return dr(e[0]-t[0])<Dr&&dr(e[1]-t[1])<Dr}function St(e,t){e*=Fr;var a=Math.cos(t*=Fr);Ct(a*Math.cos(e),a*Math.sin(e),Math.sin(t))}function Ct(e,t,a){++_s,vs+=(e-vs)/_s,bs+=(t-bs)/_s,ws+=(a-ws)/_s}function xt(){function e(e,i){e*=Fr;var o=Math.cos(i*=Fr),r=o*Math.cos(e),s=o*Math.sin(e),c=Math.sin(i),d=Math.atan2(Math.sqrt((d=a*c-n*s)*d+(d=n*r-t*c)*d+(d=t*s-a*r)*d),t*r+a*s+n*c);fs+=d,Ss+=d*(t+(t=r)),Cs+=d*(a+(a=s)),xs+=d*(n+(n=c)),Ct(t,a,n)}var t,a,n;Ts.point=function(i,o){i*=Fr;var r=Math.cos(o*=Fr);t=r*Math.cos(i),a=r*Math.sin(i),n=Math.sin(o),Ts.point=e,Ct(t,a,n)}}function kt(){Ts.point=St}function Mt(){function e(e,t){e*=Fr;var a=Math.cos(t*=Fr),r=a*Math.cos(e),s=a*Math.sin(e),c=Math.sin(t),d=i*c-o*s,l=o*r-n*c,m=n*s-i*r,g=Math.sqrt(d*d+l*l+m*m),u=n*r+i*s+o*c,h=g&&-Q(u)/g,p=Math.atan2(g,u);ks+=h*d,Ms+=h*l,Ps+=h*m,fs+=p,Ss+=p*(n+(n=r)),Cs+=p*(i+(i=s)),xs+=p*(o+(o=c)),Ct(n,i,o)}var t,a,n,i,o;Ts.point=function(r,s){t=r,a=s,Ts.point=e,r*=Fr;var c=Math.cos(s*=Fr);n=c*Math.cos(r),i=c*Math.sin(r),o=Math.sin(s),Ct(n,i,o)},Ts.lineEnd=function(){e(t,a),Ts.lineEnd=kt,Ts.point=St}}function Pt(){return!0}function Tt(e,t,a,n,i){var o=[],r=[];if(e.forEach(function(e){if(!((t=e.length-1)<=0)){var t,a=e[0],n=e[t];if(wt(a,n)){i.lineStart();for(var s=0;t>s;++s)i.point((a=e[s])[0],a[1]);return void i.lineEnd()}var c=new Dt(a,e,null,!0),d=new Dt(a,null,c,!1);c.o=d,o.push(c),r.push(d),c=new Dt(n,e,null,!1),d=new Dt(n,null,c,!0),c.o=d,o.push(c),r.push(d)}}),r.sort(t),At(o),At(r),o.length){for(var s=0,c=a,d=r.length;d>s;++s)r[s].e=c=!c;for(var l,m,g=o[0];;){for(var u=g,h=!0;u.v;)if((u=u.n)===g)return;l=u.z,i.lineStart();do{if(u.v=u.o.v=!0,u.e){if(h)for(var s=0,d=l.length;d>s;++s)i.point((m=l[s])[0],m[1]);else n(u.x,u.n.x,1,i);u=u.n}else{if(h){l=u.p.z;for(var s=l.length-1;s>=0;--s)i.point((m=l[s])[0],m[1])}else n(u.x,u.p.x,-1,i);u=u.p}u=u.o,l=u.z,h=!h}while(!u.v);i.lineEnd()}}}function At(e){if(t=e.length){for(var t,a,n=0,i=e[0];++n<t;)i.n=a=e[n],a.p=i,i=a;i.n=a=e[0],a.p=i}}function Dt(e,t,a,n){this.x=e,this.z=t,this.o=a,this.e=n,this.v=!1,this.n=this.p=null}function Gt(e,t,a,n){return function(i,o){function r(t,a){var n=i(t,a);e(t=n[0],a=n[1])&&o.point(t,a)}function s(e,t){var a=i(e,t);y.point(a[0],a[1])}function c(){f.point=s,y.lineStart()}function d(){f.point=r,y.lineEnd()}function l(e,t){p.push([e,t]);var a=i(e,t);b.point(a[0],a[1])}function m(){b.lineStart(),p=[]}function g(){l(p[0][0],p[0][1]),b.lineEnd();var e,t=b.clean(),a=v.buffer(),n=a.length;if(p.pop(),h.push(p),p=null,n)if(1&t){e=a[0];var i,n=e.length-1,r=-1;if(n>0){for(w||(o.polygonStart(),w=!0),o.lineStart();++r<n;)o.point((i=e[r])[0],i[1]);o.lineEnd()}}else n>1&&2&t&&a.push(a.pop().concat(a.shift())),u.push(a.filter(Ft))}var u,h,p,y=t(o),_=i.invert(n[0],n[1]),f={point:r,lineStart:c,lineEnd:d,polygonStart:function(){f.point=l,f.lineStart=m,f.lineEnd=g,u=[],h=[]},polygonEnd:function(){f.point=r,f.lineStart=c,f.lineEnd=d,u=Xo.merge(u);var e=It(_,h);u.length?(w||(o.polygonStart(),w=!0),Tt(u,Nt,e,a,o)):e&&(w||(o.polygonStart(),w=!0),o.lineStart(),a(null,null,1,o),o.lineEnd()),w&&(o.polygonEnd(),w=!1),u=h=null},sphere:function(){o.polygonStart(),o.lineStart(),a(null,null,1,o),o.lineEnd(),o.polygonEnd()}},v=$t(),b=t(v),w=!1;return f}}function Ft(e){return e.length>1}function $t(){var e,t=[];return{lineStart:function(){t.push(e=[])},point:function(t,a){e.push([t,a])},lineEnd:f,buffer:function(){var a=t;return t=[],e=null,a},rejoin:function(){t.length>1&&t.push(t.pop().concat(t.shift()))}}}function Nt(e,t){return((e=e.x)[0]<0?e[1]-Ar-Dr:Ar-e[1])-((t=t.x)[0]<0?t[1]-Ar-Dr:Ar-t[1])}function Lt(e){var t,a=NaN,n=NaN,i=NaN;return{lineStart:function(){e.lineStart(),t=1},point:function(o,r){var s=o>0?Pr:-Pr,c=dr(o-a);
dr(c-Pr)<Dr?(e.point(a,n=(n+r)/2>0?Ar:-Ar),e.point(i,n),e.lineEnd(),e.lineStart(),e.point(s,n),e.point(o,n),t=0):i!==s&&c>=Pr&&(dr(a-i)<Dr&&(a-=i*Dr),dr(o-s)<Dr&&(o-=s*Dr),n=Et(a,n,o,r),e.point(i,n),e.lineEnd(),e.lineStart(),e.point(s,n),t=0),e.point(a=o,n=r),i=s},lineEnd:function(){e.lineEnd(),a=n=NaN},clean:function(){return 2-t}}}function Et(e,t,a,n){var i,o,r=Math.sin(e-a);return dr(r)>Dr?Math.atan((Math.sin(t)*(o=Math.cos(n))*Math.sin(a)-Math.sin(n)*(i=Math.cos(t))*Math.sin(e))/(i*o*r)):(t+n)/2}function Rt(e,t,a,n){var i;if(null==e)i=a*Ar,n.point(-Pr,i),n.point(0,i),n.point(Pr,i),n.point(Pr,0),n.point(Pr,-i),n.point(0,-i),n.point(-Pr,-i),n.point(-Pr,0),n.point(-Pr,i);else if(dr(e[0]-t[0])>Dr){var o=e[0]<t[0]?Pr:-Pr;i=a*o/2,n.point(-o,i),n.point(0,i),n.point(o,i)}else n.point(t[0],t[1])}function It(e,t){var a=e[0],n=e[1],i=[Math.sin(a),-Math.cos(a),0],o=0,r=0;ps.reset();for(var s=0,c=t.length;c>s;++s){var d=t[s],l=d.length;if(l)for(var m=d[0],g=m[0],u=m[1]/2+Pr/4,h=Math.sin(u),p=Math.cos(u),y=1;;){y===l&&(y=0),e=d[y];var _=e[0],f=e[1]/2+Pr/4,v=Math.sin(f),b=Math.cos(f),w=_-g,S=w>=0?1:-1,C=S*w,x=C>Pr,k=h*v;if(ps.add(Math.atan2(k*S*Math.sin(C),p*b+k*Math.cos(C))),o+=x?w+S*Tr:w,x^g>=a^_>=a){var M=yt(ht(m),ht(e));vt(M);var P=yt(i,M);vt(P);var T=(x^w>=0?-1:1)*ee(P[2]);(n>T||n===T&&(M[0]||M[1]))&&(r+=x^w>=0?1:-1)}if(!y++)break;g=_,h=v,p=b,m=e}}return(-Dr>o||Dr>o&&0>ps)^1&r}function Ht(e){function t(e,t){return Math.cos(e)*Math.cos(t)>o}function a(e){var a,o,c,d,l;return{lineStart:function(){d=c=!1,l=1},point:function(m,g){var u,h=[m,g],p=t(m,g),y=r?p?0:i(m,g):p?i(m+(0>m?Pr:-Pr),g):0;if(!a&&(d=c=p)&&e.lineStart(),p!==c&&(u=n(a,h),(wt(a,u)||wt(h,u))&&(h[0]+=Dr,h[1]+=Dr,p=t(h[0],h[1]))),p!==c)l=0,p?(e.lineStart(),u=n(h,a),e.point(u[0],u[1])):(u=n(a,h),e.point(u[0],u[1]),e.lineEnd()),a=u;else if(s&&a&&r^p){var _;y&o||!(_=n(h,a,!0))||(l=0,r?(e.lineStart(),e.point(_[0][0],_[0][1]),e.point(_[1][0],_[1][1]),e.lineEnd()):(e.point(_[1][0],_[1][1]),e.lineEnd(),e.lineStart(),e.point(_[0][0],_[0][1])))}!p||a&&wt(a,h)||e.point(h[0],h[1]),a=h,c=p,o=y},lineEnd:function(){c&&e.lineEnd(),a=null},clean:function(){return l|(d&&c)<<1}}}function n(e,t,a){var n=ht(e),i=ht(t),r=[1,0,0],s=yt(n,i),c=pt(s,s),d=s[0],l=c-d*d;if(!l)return!a&&e;var m=o*c/l,g=-o*d/l,u=yt(r,s),h=ft(r,m),p=ft(s,g);_t(h,p);var y=u,_=pt(h,y),f=pt(y,y),v=_*_-f*(pt(h,h)-1);if(!(0>v)){var b=Math.sqrt(v),w=ft(y,(-_-b)/f);if(_t(w,h),w=bt(w),!a)return w;var S,C=e[0],x=t[0],k=e[1],M=t[1];C>x&&(S=C,C=x,x=S);var P=x-C,T=dr(P-Pr)<Dr,A=T||Dr>P;if(!T&&k>M&&(S=k,k=M,M=S),A?T?k+M>0^w[1]<(dr(w[0]-C)<Dr?k:M):k<=w[1]&&w[1]<=M:P>Pr^(C<=w[0]&&w[0]<=x)){var D=ft(y,(-_+b)/f);return _t(D,h),[w,bt(D)]}}}function i(t,a){var n=r?e:Pr-e,i=0;return-n>t?i|=1:t>n&&(i|=2),-n>a?i|=4:a>n&&(i|=8),i}var o=Math.cos(e),r=o>0,s=dr(o)>Dr,c=ua(e,6*Fr);return Gt(t,a,c,r?[0,-e]:[-Pr,e-Pr])}function Bt(e,t,a,n){return function(i){var o,r=i.a,s=i.b,c=r.x,d=r.y,l=s.x,m=s.y,g=0,u=1,h=l-c,p=m-d;if(o=e-c,h||!(o>0)){if(o/=h,0>h){if(g>o)return;u>o&&(u=o)}else if(h>0){if(o>u)return;o>g&&(g=o)}if(o=a-c,h||!(0>o)){if(o/=h,0>h){if(o>u)return;o>g&&(g=o)}else if(h>0){if(g>o)return;u>o&&(u=o)}if(o=t-d,p||!(o>0)){if(o/=p,0>p){if(g>o)return;u>o&&(u=o)}else if(p>0){if(o>u)return;o>g&&(g=o)}if(o=n-d,p||!(0>o)){if(o/=p,0>p){if(o>u)return;o>g&&(g=o)}else if(p>0){if(g>o)return;u>o&&(u=o)}return g>0&&(i.a={x:c+g*h,y:d+g*p}),1>u&&(i.b={x:c+u*h,y:d+u*p}),i}}}}}}function Ot(e,t,a,n){function i(n,i){return dr(n[0]-e)<Dr?i>0?0:3:dr(n[0]-a)<Dr?i>0?2:1:dr(n[1]-t)<Dr?i>0?1:0:i>0?3:2}function o(e,t){return r(e.x,t.x)}function r(e,t){var a=i(e,1),n=i(t,1);return a!==n?a-n:0===a?t[1]-e[1]:1===a?e[0]-t[0]:2===a?e[1]-t[1]:t[0]-e[0]}return function(s){function c(e){for(var t=0,a=y.length,n=e[1],i=0;a>i;++i)for(var o,r=1,s=y[i],c=s.length,d=s[0];c>r;++r)o=s[r],d[1]<=n?o[1]>n&&J(d,o,e)>0&&++t:o[1]<=n&&J(d,o,e)<0&&--t,d=o;return 0!==t}function d(o,s,c,d){var l=0,m=0;if(null==o||(l=i(o,c))!==(m=i(s,c))||r(o,s)<0^c>0){do d.point(0===l||3===l?e:a,l>1?n:t);while((l=(l+c+4)%4)!==m)}else d.point(s[0],s[1])}function l(i,o){return i>=e&&a>=i&&o>=t&&n>=o}function m(e,t){l(e,t)&&s.point(e,t)}function g(){A.point=h,y&&y.push(_=[]),x=!0,C=!1,w=S=NaN}function u(){p&&(h(f,v),b&&C&&P.rejoin(),p.push(P.buffer())),A.point=m,C&&s.lineEnd()}function h(e,t){e=Math.max(-Ds,Math.min(Ds,e)),t=Math.max(-Ds,Math.min(Ds,t));var a=l(e,t);if(y&&_.push([e,t]),x)f=e,v=t,b=a,x=!1,a&&(s.lineStart(),s.point(e,t));else if(a&&C)s.point(e,t);else{var n={a:{x:w,y:S},b:{x:e,y:t}};T(n)?(C||(s.lineStart(),s.point(n.a.x,n.a.y)),s.point(n.b.x,n.b.y),a||s.lineEnd(),k=!1):a&&(s.lineStart(),s.point(e,t),k=!1)}w=e,S=t,C=a}var p,y,_,f,v,b,w,S,C,x,k,M=s,P=$t(),T=Bt(e,t,a,n),A={point:m,lineStart:g,lineEnd:u,polygonStart:function(){s=P,p=[],y=[],k=!0},polygonEnd:function(){s=M,p=Xo.merge(p);var t=c([e,n]),a=k&&t,i=p.length;(a||i)&&(s.polygonStart(),a&&(s.lineStart(),d(null,null,1,s),s.lineEnd()),i&&Tt(p,o,t,d,s),s.polygonEnd()),p=y=_=null}};return A}}function Ut(e,t){function a(a,n){return a=e(a,n),t(a[0],a[1])}return e.invert&&t.invert&&(a.invert=function(a,n){return a=t.invert(a,n),a&&e.invert(a[0],a[1])}),a}function Vt(e){var t=0,a=Pr/3,n=oa(e),i=n(t,a);return i.parallels=function(e){return arguments.length?n(t=e[0]*Pr/180,a=e[1]*Pr/180):[t/Pr*180,a/Pr*180]},i}function Wt(e,t){function a(e,t){var a=Math.sqrt(o-2*i*Math.sin(t))/i;return[a*Math.sin(e*=i),r-a*Math.cos(e)]}var n=Math.sin(e),i=(n+Math.sin(t))/2,o=1+n*(2*i-n),r=Math.sqrt(o)/i;return a.invert=function(e,t){var a=r-t;return[Math.atan2(e,a)/i,ee((o-(e*e+a*a)*i*i)/(2*i))]},a}function zt(){function e(e,t){Fs+=i*e-n*t,n=e,i=t}var t,a,n,i;Rs.point=function(o,r){Rs.point=e,t=n=o,a=i=r},Rs.lineEnd=function(){e(t,a)}}function Kt(e,t){$s>e&&($s=e),e>Ls&&(Ls=e),Ns>t&&(Ns=t),t>Es&&(Es=t)}function jt(){function e(e,t){r.push("M",e,",",t,o)}function t(e,t){r.push("M",e,",",t),s.point=a}function a(e,t){r.push("L",e,",",t)}function n(){s.point=e}function i(){r.push("Z")}var o=qt(4.5),r=[],s={point:e,lineStart:function(){s.point=t},lineEnd:n,polygonStart:function(){s.lineEnd=i},polygonEnd:function(){s.lineEnd=n,s.point=e},pointRadius:function(e){return o=qt(e),s},result:function(){if(r.length){var e=r.join("");return r=[],e}}};return s}function qt(e){return"m0,"+e+"a"+e+","+e+" 0 1,1 0,"+-2*e+"a"+e+","+e+" 0 1,1 0,"+2*e+"z"}function Xt(e,t){vs+=e,bs+=t,++ws}function Yt(){function e(e,n){var i=e-t,o=n-a,r=Math.sqrt(i*i+o*o);Ss+=r*(t+e)/2,Cs+=r*(a+n)/2,xs+=r,Xt(t=e,a=n)}var t,a;Hs.point=function(n,i){Hs.point=e,Xt(t=n,a=i)}}function Zt(){Hs.point=Xt}function Jt(){function e(e,t){var a=e-n,o=t-i,r=Math.sqrt(a*a+o*o);Ss+=r*(n+e)/2,Cs+=r*(i+t)/2,xs+=r,r=i*e-n*t,ks+=r*(n+e),Ms+=r*(i+t),Ps+=3*r,Xt(n=e,i=t)}var t,a,n,i;Hs.point=function(o,r){Hs.point=e,Xt(t=n=o,a=i=r)},Hs.lineEnd=function(){e(t,a)}}function Qt(e){function t(t,a){e.moveTo(t,a),e.arc(t,a,r,0,Tr)}function a(t,a){e.moveTo(t,a),s.point=n}function n(t,a){e.lineTo(t,a)}function i(){s.point=t}function o(){e.closePath()}var r=4.5,s={point:t,lineStart:function(){s.point=a},lineEnd:i,polygonStart:function(){s.lineEnd=o},polygonEnd:function(){s.lineEnd=i,s.point=t},pointRadius:function(e){return r=e,s},result:f};return s}function ea(e){function t(e){return(s?n:a)(e)}function a(t){return na(t,function(a,n){a=e(a,n),t.point(a[0],a[1])})}function n(t){function a(a,n){a=e(a,n),t.point(a[0],a[1])}function n(){v=NaN,x.point=o,t.lineStart()}function o(a,n){var o=ht([a,n]),r=e(a,n);i(v,b,f,w,S,C,v=r[0],b=r[1],f=a,w=o[0],S=o[1],C=o[2],s,t),t.point(v,b)}function r(){x.point=a,t.lineEnd()}function c(){n(),x.point=d,x.lineEnd=l}function d(e,t){o(m=e,g=t),u=v,h=b,p=w,y=S,_=C,x.point=o}function l(){i(v,b,f,w,S,C,u,h,m,p,y,_,s,t),x.lineEnd=r,r()}var m,g,u,h,p,y,_,f,v,b,w,S,C,x={point:a,lineStart:n,lineEnd:r,polygonStart:function(){t.polygonStart(),x.lineStart=c},polygonEnd:function(){t.polygonEnd(),x.lineStart=n}};return x}function i(t,a,n,s,c,d,l,m,g,u,h,p,y,_){var f=l-t,v=m-a,b=f*f+v*v;if(b>4*o&&y--){var w=s+u,S=c+h,C=d+p,x=Math.sqrt(w*w+S*S+C*C),k=Math.asin(C/=x),M=dr(dr(C)-1)<Dr||dr(n-g)<Dr?(n+g)/2:Math.atan2(S,w),P=e(M,k),T=P[0],A=P[1],D=T-t,G=A-a,F=v*D-f*G;(F*F/b>o||dr((f*D+v*G)/b-.5)>.3||r>s*u+c*h+d*p)&&(i(t,a,n,s,c,d,T,A,M,w/=x,S/=x,C,y,_),_.point(T,A),i(T,A,M,w,S,C,l,m,g,u,h,p,y,_))}}var o=.5,r=Math.cos(30*Fr),s=16;return t.precision=function(e){return arguments.length?(s=(o=e*e)>0&&16,t):Math.sqrt(o)},t}function ta(e){var t=ea(function(t,a){return e([t*$r,a*$r])});return function(e){return ra(t(e))}}function aa(e){this.stream=e}function na(e,t){return{point:t,sphere:function(){e.sphere()},lineStart:function(){e.lineStart()},lineEnd:function(){e.lineEnd()},polygonStart:function(){e.polygonStart()},polygonEnd:function(){e.polygonEnd()}}}function ia(e){return oa(function(){return e})()}function oa(e){function t(e){return e=s(e[0]*Fr,e[1]*Fr),[e[0]*g+c,d-e[1]*g]}function a(e){return e=s.invert((e[0]-c)/g,(d-e[1])/g),e&&[e[0]*$r,e[1]*$r]}function n(){s=Ut(r=da(_,f,v),o);var e=o(p,y);return c=u-e[0]*g,d=h+e[1]*g,i()}function i(){return l&&(l.valid=!1,l=null),t}var o,r,s,c,d,l,m=ea(function(e,t){return e=o(e,t),[e[0]*g+c,d-e[1]*g]}),g=150,u=480,h=250,p=0,y=0,_=0,f=0,v=0,b=As,w=Me,S=null,C=null;return t.stream=function(e){return l&&(l.valid=!1),l=ra(b(r,m(w(e)))),l.valid=!0,l},t.clipAngle=function(e){return arguments.length?(b=null==e?(S=e,As):Ht((S=+e)*Fr),i()):S},t.clipExtent=function(e){return arguments.length?(C=e,w=e?Ot(e[0][0],e[0][1],e[1][0],e[1][1]):Me,i()):C},t.scale=function(e){return arguments.length?(g=+e,n()):g},t.translate=function(e){return arguments.length?(u=+e[0],h=+e[1],n()):[u,h]},t.center=function(e){return arguments.length?(p=e[0]%360*Fr,y=e[1]%360*Fr,n()):[p*$r,y*$r]},t.rotate=function(e){return arguments.length?(_=e[0]%360*Fr,f=e[1]%360*Fr,v=e.length>2?e[2]%360*Fr:0,n()):[_*$r,f*$r,v*$r]},Xo.rebind(t,m,"precision"),function(){return o=e.apply(this,arguments),t.invert=o.invert&&a,n()}}function ra(e){return na(e,function(t,a){e.point(t*Fr,a*Fr)})}function sa(e,t){return[e,t]}function ca(e,t){return[e>Pr?e-Tr:-Pr>e?e+Tr:e,t]}function da(e,t,a){return e?t||a?Ut(ma(e),ga(t,a)):ma(e):t||a?ga(t,a):ca}function la(e){return function(t,a){return t+=e,[t>Pr?t-Tr:-Pr>t?t+Tr:t,a]}}function ma(e){var t=la(e);return t.invert=la(-e),t}function ga(e,t){function a(e,t){var a=Math.cos(t),s=Math.cos(e)*a,c=Math.sin(e)*a,d=Math.sin(t),l=d*n+s*i;return[Math.atan2(c*o-l*r,s*n-d*i),ee(l*o+c*r)]}var n=Math.cos(e),i=Math.sin(e),o=Math.cos(t),r=Math.sin(t);return a.invert=function(e,t){var a=Math.cos(t),s=Math.cos(e)*a,c=Math.sin(e)*a,d=Math.sin(t),l=d*o-c*r;return[Math.atan2(c*o+d*r,s*n+l*i),ee(l*n-s*i)]},a}function ua(e,t){var a=Math.cos(e),n=Math.sin(e);return function(i,o,r,s){var c=r*t;null!=i?(i=ha(a,i),o=ha(a,o),(r>0?o>i:i>o)&&(i+=r*Tr)):(i=e+r*Tr,o=e-.5*c);for(var d,l=i;r>0?l>o:o>l;l-=c)s.point((d=bt([a,-n*Math.cos(l),-n*Math.sin(l)]))[0],d[1])}}function ha(e,t){var a=ht(t);a[0]-=e,vt(a);var n=Q(-a[1]);return((-a[2]<0?-n:n)+2*Math.PI-Dr)%(2*Math.PI)}function pa(e,t,a){var n=Xo.range(e,t-Dr,a).concat(t);return function(e){return n.map(function(t){return[e,t]})}}function ya(e,t,a){var n=Xo.range(e,t-Dr,a).concat(t);return function(e){return n.map(function(t){return[t,e]})}}function _a(e){return e.source}function fa(e){return e.target}function va(e,t,a,n){var i=Math.cos(t),o=Math.sin(t),r=Math.cos(n),s=Math.sin(n),c=i*Math.cos(e),d=i*Math.sin(e),l=r*Math.cos(a),m=r*Math.sin(a),g=2*Math.asin(Math.sqrt(ie(n-t)+i*r*ie(a-e))),u=1/Math.sin(g),h=g?function(e){var t=Math.sin(e*=g)*u,a=Math.sin(g-e)*u,n=a*c+t*l,i=a*d+t*m,r=a*o+t*s;return[Math.atan2(i,n)*$r,Math.atan2(r,Math.sqrt(n*n+i*i))*$r]}:function(){return[e*$r,t*$r]};return h.distance=g,h}function ba(){function e(e,i){var o=Math.sin(i*=Fr),r=Math.cos(i),s=dr((e*=Fr)-t),c=Math.cos(s);Bs+=Math.atan2(Math.sqrt((s=r*Math.sin(s))*s+(s=n*o-a*r*c)*s),a*o+n*r*c),t=e,a=o,n=r}var t,a,n;Os.point=function(i,o){t=i*Fr,a=Math.sin(o*=Fr),n=Math.cos(o),Os.point=e},Os.lineEnd=function(){Os.point=Os.lineEnd=f}}function wa(e,t){function a(t,a){var n=Math.cos(t),i=Math.cos(a),o=e(n*i);return[o*i*Math.sin(t),o*Math.sin(a)]}return a.invert=function(e,a){var n=Math.sqrt(e*e+a*a),i=t(n),o=Math.sin(i),r=Math.cos(i);return[Math.atan2(e*o,n*r),Math.asin(n&&a*o/n)]},a}function Sa(e,t){function a(e,t){r>0?-Ar+Dr>t&&(t=-Ar+Dr):t>Ar-Dr&&(t=Ar-Dr);var a=r/Math.pow(i(t),o);return[a*Math.sin(o*e),r-a*Math.cos(o*e)]}var n=Math.cos(e),i=function(e){return Math.tan(Pr/4+e/2)},o=e===t?Math.sin(e):Math.log(n/Math.cos(t))/Math.log(i(t)/i(e)),r=n*Math.pow(i(e),o)/o;return o?(a.invert=function(e,t){var a=r-t,n=Z(o)*Math.sqrt(e*e+a*a);return[Math.atan2(e,a)/o,2*Math.atan(Math.pow(r/n,1/o))-Ar]},a):xa}function Ca(e,t){function a(e,t){var a=o-t;return[a*Math.sin(i*e),o-a*Math.cos(i*e)]}var n=Math.cos(e),i=e===t?Math.sin(e):(n-Math.cos(t))/(t-e),o=n/i+e;return dr(i)<Dr?sa:(a.invert=function(e,t){var a=o-t;return[Math.atan2(e,a)/i,o-Z(i)*Math.sqrt(e*e+a*a)]},a)}function xa(e,t){return[e,Math.log(Math.tan(Pr/4+t/2))]}function ka(e){var t,a=ia(e),n=a.scale,i=a.translate,o=a.clipExtent;return a.scale=function(){var e=n.apply(a,arguments);return e===a?t?a.clipExtent(null):a:e},a.translate=function(){var e=i.apply(a,arguments);return e===a?t?a.clipExtent(null):a:e},a.clipExtent=function(e){var r=o.apply(a,arguments);if(r===a){if(t=null==e){var s=Pr*n(),c=i();o([[c[0]-s,c[1]-s],[c[0]+s,c[1]+s]])}}else t&&(r=null);return r},a.clipExtent(null)}function Ma(e,t){return[Math.log(Math.tan(Pr/4+t/2)),-e]}function Pa(e){return e[0]}function Ta(e){return e[1]}function Aa(e){for(var t=e.length,a=[0,1],n=2,i=2;t>i;i++){for(;n>1&&J(e[a[n-2]],e[a[n-1]],e[i])<=0;)--n;a[n++]=i}return a.slice(0,n)}function Da(e,t){return e[0]-t[0]||e[1]-t[1]}function Ga(e,t,a){return(a[0]-t[0])*(e[1]-t[1])<(a[1]-t[1])*(e[0]-t[0])}function Fa(e,t,a,n){var i=e[0],o=a[0],r=t[0]-i,s=n[0]-o,c=e[1],d=a[1],l=t[1]-c,m=n[1]-d,g=(s*(c-d)-m*(i-o))/(m*r-s*l);return[i+g*r,c+g*l]}function $a(e){var t=e[0],a=e[e.length-1];return!(t[0]-a[0]||t[1]-a[1])}function Na(){tn(this),this.edge=this.site=this.circle=null}function La(e){var t=Qs.pop()||new Na;return t.site=e,t}function Ea(e){Ka(e),Ys.remove(e),Qs.push(e),tn(e)}function Ra(e){var t=e.circle,a=t.x,n=t.cy,i={x:a,y:n},o=e.P,r=e.N,s=[e];Ea(e);for(var c=o;c.circle&&dr(a-c.circle.x)<Dr&&dr(n-c.circle.cy)<Dr;)o=c.P,s.unshift(c),Ea(c),c=o;s.unshift(c),Ka(c);for(var d=r;d.circle&&dr(a-d.circle.x)<Dr&&dr(n-d.circle.cy)<Dr;)r=d.N,s.push(d),Ea(d),d=r;s.push(d),Ka(d);var l,m=s.length;for(l=1;m>l;++l)d=s[l],c=s[l-1],Ja(d.edge,c.site,d.site,i);c=s[0],d=s[m-1],d.edge=Ya(c.site,d.site,null,i),za(c),za(d)}function Ia(e){for(var t,a,n,i,o=e.x,r=e.y,s=Ys._;s;)if(n=Ha(s,r)-o,n>Dr)s=s.L;else{if(i=o-Ba(s,r),!(i>Dr)){n>-Dr?(t=s.P,a=s):i>-Dr?(t=s,a=s.N):t=a=s;break}if(!s.R){t=s;break}s=s.R}var c=La(e);if(Ys.insert(t,c),t||a){if(t===a)return Ka(t),a=La(t.site),Ys.insert(c,a),c.edge=a.edge=Ya(t.site,c.site),za(t),void za(a);if(!a)return void(c.edge=Ya(t.site,c.site));Ka(t),Ka(a);var d=t.site,l=d.x,m=d.y,g=e.x-l,u=e.y-m,h=a.site,p=h.x-l,y=h.y-m,_=2*(g*y-u*p),f=g*g+u*u,v=p*p+y*y,b={x:(y*f-u*v)/_+l,y:(g*v-p*f)/_+m};Ja(a.edge,d,h,b),c.edge=Ya(d,e,null,b),a.edge=Ya(e,h,null,b),za(t),za(a)}}function Ha(e,t){var a=e.site,n=a.x,i=a.y,o=i-t;if(!o)return n;var r=e.P;if(!r)return-(1/0);a=r.site;var s=a.x,c=a.y,d=c-t;if(!d)return s;var l=s-n,m=1/o-1/d,g=l/d;return m?(-g+Math.sqrt(g*g-2*m*(l*l/(-2*d)-c+d/2+i-o/2)))/m+n:(n+s)/2}function Ba(e,t){var a=e.N;if(a)return Ha(a,t);var n=e.site;return n.y===t?n.x:1/0}function Oa(e){this.site=e,this.edges=[]}function Ua(e){for(var t,a,n,i,o,r,s,c,d,l,m=e[0][0],g=e[1][0],u=e[0][1],h=e[1][1],p=Xs,y=p.length;y--;)if(o=p[y],o&&o.prepare())for(s=o.edges,c=s.length,r=0;c>r;)l=s[r].end(),n=l.x,i=l.y,d=s[++r%c].start(),t=d.x,a=d.y,(dr(n-t)>Dr||dr(i-a)>Dr)&&(s.splice(r,0,new Qa(Za(o.site,l,dr(n-m)<Dr&&h-i>Dr?{x:m,y:dr(t-m)<Dr?a:h}:dr(i-h)<Dr&&g-n>Dr?{x:dr(a-h)<Dr?t:g,y:h}:dr(n-g)<Dr&&i-u>Dr?{x:g,y:dr(t-g)<Dr?a:u}:dr(i-u)<Dr&&n-m>Dr?{x:dr(a-u)<Dr?t:m,y:u}:null),o.site,null)),++c)}function Va(e,t){return t.angle-e.angle}function Wa(){tn(this),this.x=this.y=this.arc=this.site=this.cy=null}function za(e){var t=e.P,a=e.N;if(t&&a){var n=t.site,i=e.site,o=a.site;if(n!==o){var r=i.x,s=i.y,c=n.x-r,d=n.y-s,l=o.x-r,m=o.y-s,g=2*(c*m-d*l);if(!(g>=-Gr)){var u=c*c+d*d,h=l*l+m*m,p=(m*u-d*h)/g,y=(c*h-l*u)/g,m=y+s,_=ec.pop()||new Wa;_.arc=e,_.site=i,_.x=p+r,_.y=m+Math.sqrt(p*p+y*y),_.cy=m,e.circle=_;for(var f=null,v=Js._;v;)if(_.y<v.y||_.y===v.y&&_.x<=v.x){if(!v.L){f=v.P;break}v=v.L}else{if(!v.R){f=v;break}v=v.R}Js.insert(f,_),f||(Zs=_)}}}}function Ka(e){var t=e.circle;t&&(t.P||(Zs=t.N),Js.remove(t),ec.push(t),tn(t),e.circle=null)}function ja(e){for(var t,a=qs,n=Bt(e[0][0],e[0][1],e[1][0],e[1][1]),i=a.length;i--;)t=a[i],(!qa(t,e)||!n(t)||dr(t.a.x-t.b.x)<Dr&&dr(t.a.y-t.b.y)<Dr)&&(t.a=t.b=null,a.splice(i,1))}function qa(e,t){var a=e.b;if(a)return!0;var n,i,o=e.a,r=t[0][0],s=t[1][0],c=t[0][1],d=t[1][1],l=e.l,m=e.r,g=l.x,u=l.y,h=m.x,p=m.y,y=(g+h)/2,_=(u+p)/2;if(p===u){if(r>y||y>=s)return;if(g>h){if(o){if(o.y>=d)return}else o={x:y,y:c};a={x:y,y:d}}else{if(o){if(o.y<c)return}else o={x:y,y:d};a={x:y,y:c}}}else if(n=(g-h)/(p-u),i=_-n*y,-1>n||n>1)if(g>h){if(o){if(o.y>=d)return}else o={x:(c-i)/n,y:c};a={x:(d-i)/n,y:d}}else{if(o){if(o.y<c)return}else o={x:(d-i)/n,y:d};a={x:(c-i)/n,y:c}}else if(p>u){if(o){if(o.x>=s)return}else o={x:r,y:n*r+i};a={x:s,y:n*s+i}}else{if(o){if(o.x<r)return}else o={x:s,y:n*s+i};a={x:r,y:n*r+i}}return e.a=o,e.b=a,!0}function Xa(e,t){this.l=e,this.r=t,this.a=this.b=null}function Ya(e,t,a,n){var i=new Xa(e,t);return qs.push(i),a&&Ja(i,e,t,a),n&&Ja(i,t,e,n),Xs[e.i].edges.push(new Qa(i,e,t)),Xs[t.i].edges.push(new Qa(i,t,e)),i}function Za(e,t,a){var n=new Xa(e,null);return n.a=t,n.b=a,qs.push(n),n}function Ja(e,t,a,n){e.a||e.b?e.l===a?e.b=n:e.a=n:(e.a=n,e.l=t,e.r=a)}function Qa(e,t,a){var n=e.a,i=e.b;this.edge=e,this.site=t,this.angle=a?Math.atan2(a.y-t.y,a.x-t.x):e.l===t?Math.atan2(i.x-n.x,n.y-i.y):Math.atan2(n.x-i.x,i.y-n.y)}function en(){this._=null}function tn(e){e.U=e.C=e.L=e.R=e.P=e.N=null}function an(e,t){var a=t,n=t.R,i=a.U;i?i.L===a?i.L=n:i.R=n:e._=n,n.U=i,a.U=n,a.R=n.L,a.R&&(a.R.U=a),n.L=a}function nn(e,t){var a=t,n=t.L,i=a.U;i?i.L===a?i.L=n:i.R=n:e._=n,n.U=i,a.U=n,a.L=n.R,a.L&&(a.L.U=a),n.R=a}function on(e){for(;e.L;)e=e.L;return e}function rn(e,t){var a,n,i,o=e.sort(sn).pop();for(qs=[],Xs=new Array(e.length),Ys=new en,Js=new en;;)if(i=Zs,o&&(!i||o.y<i.y||o.y===i.y&&o.x<i.x))(o.x!==a||o.y!==n)&&(Xs[o.i]=new Oa(o),Ia(o),a=o.x,n=o.y),o=e.pop();else{if(!i)break;Ra(i.arc)}t&&(ja(t),Ua(t));var r={cells:Xs,edges:qs};return Ys=Js=qs=Xs=null,r}function sn(e,t){return t.y-e.y||t.x-e.x}function cn(e,t,a){return(e.x-a.x)*(t.y-e.y)-(e.x-t.x)*(a.y-e.y)}function dn(e){return e.x}function ln(e){return e.y}function mn(){return{leaf:!0,nodes:[],point:null,x:null,y:null}}function gn(e,t,a,n,i,o){if(!e(t,a,n,i,o)){var r=.5*(a+i),s=.5*(n+o),c=t.nodes;c[0]&&gn(e,c[0],a,n,r,s),c[1]&&gn(e,c[1],r,n,i,s),c[2]&&gn(e,c[2],a,s,r,o),c[3]&&gn(e,c[3],r,s,i,o)}}function un(e,t){e=Xo.rgb(e),t=Xo.rgb(t);var a=e.r,n=e.g,i=e.b,o=t.r-a,r=t.g-n,s=t.b-i;return function(e){return"#"+ve(Math.round(a+o*e))+ve(Math.round(n+r*e))+ve(Math.round(i+s*e))}}function hn(e,t){var a,n={},i={};for(a in e)a in t?n[a]=_n(e[a],t[a]):i[a]=e[a];for(a in t)a in e||(i[a]=t[a]);return function(e){for(a in n)i[a]=n[a](e);return i}}function pn(e,t){return e=+e,t=+t,function(a){return e*(1-a)+t*a}}function yn(e,t){var a,n,i,o=ac.lastIndex=nc.lastIndex=0,r=-1,s=[],c=[];for(e+="",t+="";(a=ac.exec(e))&&(n=nc.exec(t));)(i=n.index)>o&&(i=t.slice(o,i),s[r]?s[r]+=i:s[++r]=i),(a=a[0])===(n=n[0])?s[r]?s[r]+=n:s[++r]=n:(s[++r]=null,c.push({i:r,x:pn(a,n)})),o=nc.lastIndex;return o<t.length&&(i=t.slice(o),s[r]?s[r]+=i:s[++r]=i),s.length<2?c[0]?(t=c[0].x,function(e){return t(e)+""}):function(){return t}:(t=c.length,function(e){for(var a,n=0;t>n;++n)s[(a=c[n]).i]=a.x(e);return s.join("")})}function _n(e,t){for(var a,n=Xo.interpolators.length;--n>=0&&!(a=Xo.interpolators[n](e,t)););return a}function fn(e,t){var a,n=[],i=[],o=e.length,r=t.length,s=Math.min(e.length,t.length);for(a=0;s>a;++a)n.push(_n(e[a],t[a]));for(;o>a;++a)i[a]=e[a];for(;r>a;++a)i[a]=t[a];return function(e){for(a=0;s>a;++a)i[a]=n[a](e);return i}}function vn(e){return function(t){return 0>=t?0:t>=1?1:e(t)}}function bn(e){return function(t){return 1-e(1-t)}}function wn(e){return function(t){return.5*(.5>t?e(2*t):2-e(2-2*t))}}function Sn(e){return e*e}function Cn(e){return e*e*e}function xn(e){if(0>=e)return 0;if(e>=1)return 1;var t=e*e,a=t*e;return 4*(.5>e?a:3*(e-t)+a-.75)}function kn(e){return function(t){return Math.pow(t,e)}}function Mn(e){return 1-Math.cos(e*Ar)}function Pn(e){return Math.pow(2,10*(e-1))}function Tn(e){return 1-Math.sqrt(1-e*e)}function An(e,t){var a;return arguments.length<2&&(t=.45),arguments.length?a=t/Tr*Math.asin(1/e):(e=1,a=t/4),function(n){return 1+e*Math.pow(2,-10*n)*Math.sin((n-a)*Tr/t)}}function Dn(e){return e||(e=1.70158),function(t){return t*t*((e+1)*t-e)}}function Gn(e){return 1/2.75>e?7.5625*e*e:2/2.75>e?7.5625*(e-=1.5/2.75)*e+.75:2.5/2.75>e?7.5625*(e-=2.25/2.75)*e+.9375:7.5625*(e-=2.625/2.75)*e+.984375}function Fn(e,t){e=Xo.hcl(e),t=Xo.hcl(t);var a=e.h,n=e.c,i=e.l,o=t.h-a,r=t.c-n,s=t.l-i;return isNaN(r)&&(r=0,n=isNaN(n)?t.c:n),isNaN(o)?(o=0,a=isNaN(a)?t.h:a):o>180?o-=360:-180>o&&(o+=360),function(e){return de(a+o*e,n+r*e,i+s*e)+""}}function $n(e,t){e=Xo.hsl(e),t=Xo.hsl(t);var a=e.h,n=e.s,i=e.l,o=t.h-a,r=t.s-n,s=t.l-i;return isNaN(r)&&(r=0,n=isNaN(n)?t.s:n),isNaN(o)?(o=0,a=isNaN(a)?t.h:a):o>180?o-=360:-180>o&&(o+=360),function(e){return se(a+o*e,n+r*e,i+s*e)+""}}function Nn(e,t){e=Xo.lab(e),t=Xo.lab(t);var a=e.l,n=e.a,i=e.b,o=t.l-a,r=t.a-n,s=t.b-i;return function(e){return me(a+o*e,n+r*e,i+s*e)+""}}function Ln(e,t){return t-=e,function(a){return Math.round(e+t*a)}}function En(e){var t=[e.a,e.b],a=[e.c,e.d],n=In(t),i=Rn(t,a),o=In(Hn(a,t,-i))||0;t[0]*a[1]<a[0]*t[1]&&(t[0]*=-1,t[1]*=-1,n*=-1,i*=-1),this.rotate=(n?Math.atan2(t[1],t[0]):Math.atan2(-a[0],a[1]))*$r,this.translate=[e.e,e.f],this.scale=[n,o],this.skew=o?Math.atan2(i,o)*$r:0}function Rn(e,t){return e[0]*t[0]+e[1]*t[1]}function In(e){var t=Math.sqrt(Rn(e,e));return t&&(e[0]/=t,e[1]/=t),t}function Hn(e,t,a){return e[0]+=a*t[0],e[1]+=a*t[1],e}function Bn(e,t){var a,n=[],i=[],o=Xo.transform(e),r=Xo.transform(t),s=o.translate,c=r.translate,d=o.rotate,l=r.rotate,m=o.skew,g=r.skew,u=o.scale,h=r.scale;return s[0]!=c[0]||s[1]!=c[1]?(n.push("translate(",null,",",null,")"),i.push({i:1,x:pn(s[0],c[0])},{i:3,x:pn(s[1],c[1])})):c[0]||c[1]?n.push("translate("+c+")"):n.push(""),d!=l?(d-l>180?l+=360:l-d>180&&(d+=360),i.push({i:n.push(n.pop()+"rotate(",null,")")-2,x:pn(d,l)})):l&&n.push(n.pop()+"rotate("+l+")"),m!=g?i.push({i:n.push(n.pop()+"skewX(",null,")")-2,x:pn(m,g)}):g&&n.push(n.pop()+"skewX("+g+")"),u[0]!=h[0]||u[1]!=h[1]?(a=n.push(n.pop()+"scale(",null,",",null,")"),i.push({i:a-4,x:pn(u[0],h[0])},{i:a-2,x:pn(u[1],h[1])})):(1!=h[0]||1!=h[1])&&n.push(n.pop()+"scale("+h+")"),a=i.length,function(e){for(var t,o=-1;++o<a;)n[(t=i[o]).i]=t.x(e);return n.join("")}}function On(e,t){return t=(t-=e=+e)||1/t,function(a){return(a-e)/t}}function Un(e,t){return t=(t-=e=+e)||1/t,function(a){return Math.max(0,Math.min(1,(a-e)/t))}}function Vn(e){for(var t=e.source,a=e.target,n=zn(t,a),i=[t];t!==n;)t=t.parent,i.push(t);for(var o=i.length;a!==n;)i.splice(o,0,a),a=a.parent;return i}function Wn(e){for(var t=[],a=e.parent;null!=a;)t.push(e),e=a,a=a.parent;return t.push(e),t}function zn(e,t){if(e===t)return e;for(var a=Wn(e),n=Wn(t),i=a.pop(),o=n.pop(),r=null;i===o;)r=i,i=a.pop(),o=n.pop();return r}function Kn(e){e.fixed|=2}function jn(e){e.fixed&=-7}function qn(e){e.fixed|=4,e.px=e.x,e.py=e.y}function Xn(e){e.fixed&=-5}function Yn(e,t,a){var n=0,i=0;if(e.charge=0,!e.leaf)for(var o,r=e.nodes,s=r.length,c=-1;++c<s;)o=r[c],null!=o&&(Yn(o,t,a),e.charge+=o.charge,n+=o.charge*o.cx,i+=o.charge*o.cy);if(e.point){e.leaf||(e.point.x+=Math.random()-.5,e.point.y+=Math.random()-.5);var d=t*a[e.point.index];e.charge+=e.pointCharge=d,n+=d*e.point.x,i+=d*e.point.y}e.cx=n/e.charge,e.cy=i/e.charge}function Zn(e,t){return Xo.rebind(e,t,"sort","children","value"),e.nodes=e,e.links=ni,e}function Jn(e,t){for(var a=[e];null!=(e=a.pop());)if(t(e),(i=e.children)&&(n=i.length))for(var n,i;--n>=0;)a.push(i[n])}function Qn(e,t){for(var a=[e],n=[];null!=(e=a.pop());)if(n.push(e),(o=e.children)&&(i=o.length))for(var i,o,r=-1;++r<i;)a.push(o[r]);for(;null!=(e=n.pop());)t(e)}function ei(e){return e.children}function ti(e){return e.value}function ai(e,t){return t.value-e.value}function ni(e){return Xo.merge(e.map(function(e){return(e.children||[]).map(function(t){return{source:e,target:t}})}))}function ii(e){return e.x}function oi(e){return e.y}function ri(e,t,a){e.y0=t,e.y=a}function si(e){return Xo.range(e.length)}function ci(e){for(var t=-1,a=e[0].length,n=[];++t<a;)n[t]=0;return n}function di(e){for(var t,a=1,n=0,i=e[0][1],o=e.length;o>a;++a)(t=e[a][1])>i&&(n=a,i=t);return n}function li(e){return e.reduce(mi,0)}function mi(e,t){return e+t[1]}function gi(e,t){return ui(e,Math.ceil(Math.log(t.length)/Math.LN2+1))}function ui(e,t){for(var a=-1,n=+e[0],i=(e[1]-n)/t,o=[];++a<=t;)o[a]=i*a+n;return o}function hi(e){return[Xo.min(e),Xo.max(e)]}function pi(e,t){return e.value-t.value}function yi(e,t){var a=e._pack_next;e._pack_next=t,t._pack_prev=e,t._pack_next=a,a._pack_prev=t}function _i(e,t){e._pack_next=t,t._pack_prev=e}function fi(e,t){var a=t.x-e.x,n=t.y-e.y,i=e.r+t.r;return.999*i*i>a*a+n*n}function vi(e){function t(e){l=Math.min(e.x-e.r,l),m=Math.max(e.x+e.r,m),g=Math.min(e.y-e.r,g),u=Math.max(e.y+e.r,u)}if((a=e.children)&&(d=a.length)){var a,n,i,o,r,s,c,d,l=1/0,m=-(1/0),g=1/0,u=-(1/0);if(a.forEach(bi),n=a[0],n.x=-n.r,n.y=0,t(n),d>1&&(i=a[1],i.x=i.r,i.y=0,t(i),d>2))for(o=a[2],Ci(n,i,o),t(o),yi(n,o),n._pack_prev=o,yi(o,i),i=n._pack_next,r=3;d>r;r++){Ci(n,i,o=a[r]);var h=0,p=1,y=1;for(s=i._pack_next;s!==i;s=s._pack_next,p++)if(fi(s,o)){h=1;break}if(1==h)for(c=n._pack_prev;c!==s._pack_prev&&!fi(c,o);c=c._pack_prev,y++);h?(y>p||p==y&&i.r<n.r?_i(n,i=s):_i(n=c,i),r--):(yi(n,o),i=o,t(o))}var _=(l+m)/2,f=(g+u)/2,v=0;for(r=0;d>r;r++)o=a[r],o.x-=_,o.y-=f,v=Math.max(v,o.r+Math.sqrt(o.x*o.x+o.y*o.y));e.r=v,a.forEach(wi)}}function bi(e){e._pack_next=e._pack_prev=e}function wi(e){delete e._pack_next,delete e._pack_prev}function Si(e,t,a,n){var i=e.children;if(e.x=t+=n*e.x,e.y=a+=n*e.y,e.r*=n,i)for(var o=-1,r=i.length;++o<r;)Si(i[o],t,a,n)}function Ci(e,t,a){var n=e.r+a.r,i=t.x-e.x,o=t.y-e.y;if(n&&(i||o)){var r=t.r+a.r,s=i*i+o*o;r*=r,n*=n;var c=.5+(n-r)/(2*s),d=Math.sqrt(Math.max(0,2*r*(n+s)-(n-=s)*n-r*r))/(2*s);a.x=e.x+c*i+d*o,a.y=e.y+c*o-d*i}else a.x=e.x+n,a.y=e.y}function xi(e,t){return e.parent==t.parent?1:2}function ki(e){var t=e.children;return t.length?t[0]:e.t}function Mi(e){var t,a=e.children;return(t=a.length)?a[t-1]:e.t}function Pi(e,t,a){var n=a/(t.i-e.i);t.c-=n,t.s+=a,e.c+=n,t.z+=a,t.m+=a}function Ti(e){for(var t,a=0,n=0,i=e.children,o=i.length;--o>=0;)t=i[o],t.z+=a,t.m+=a,a+=t.s+(n+=t.c)}function Ai(e,t,a){return e.a.parent===t.parent?e.a:a}function Di(e){return 1+Xo.max(e,function(e){return e.y})}function Gi(e){return e.reduce(function(e,t){return e+t.x},0)/e.length}function Fi(e){var t=e.children;return t&&t.length?Fi(t[0]):e}function $i(e){var t,a=e.children;return a&&(t=a.length)?$i(a[t-1]):e}function Ni(e){return{x:e.x,y:e.y,dx:e.dx,dy:e.dy}}function Li(e,t){var a=e.x+t[3],n=e.y+t[0],i=e.dx-t[1]-t[3],o=e.dy-t[0]-t[2];return 0>i&&(a+=i/2,i=0),0>o&&(n+=o/2,o=0),{x:a,y:n,dx:i,dy:o}}function Ei(e){var t=e[0],a=e[e.length-1];return a>t?[t,a]:[a,t]}function Ri(e){return e.rangeExtent?e.rangeExtent():Ei(e.range())}function Ii(e,t,a,n){var i=a(e[0],e[1]),o=n(t[0],t[1]);return function(e){return o(i(e))}}function Hi(e,t){var a,n=0,i=e.length-1,o=e[n],r=e[i];return o>r&&(a=n,n=i,i=a,a=o,o=r,r=a),e[n]=t.floor(o),e[i]=t.ceil(r),e}function Bi(e){return e?{floor:function(t){return Math.floor(t/e)*e},ceil:function(t){return Math.ceil(t/e)*e}}:hc}function Oi(e,t,a,n){var i=[],o=[],r=0,s=Math.min(e.length,t.length)-1;for(e[s]<e[0]&&(e=e.slice().reverse(),t=t.slice().reverse());++r<=s;)i.push(a(e[r-1],e[r])),o.push(n(t[r-1],t[r]));return function(t){var a=Xo.bisect(e,t,1,s)-1;return o[a](i[a](t))}}function Ui(e,t,a,n){function i(){var i=Math.min(e.length,t.length)>2?Oi:Ii,c=n?Un:On;return r=i(e,t,c,a),s=i(t,e,c,_n),o}function o(e){return r(e)}var r,s;return o.invert=function(e){return s(e)},o.domain=function(t){return arguments.length?(e=t.map(Number),i()):e},o.range=function(e){return arguments.length?(t=e,i()):t},o.rangeRound=function(e){return o.range(e).interpolate(Ln)},o.clamp=function(e){return arguments.length?(n=e,i()):n},o.interpolate=function(e){return arguments.length?(a=e,i()):a},o.ticks=function(t){return Ki(e,t)},o.tickFormat=function(t,a){return ji(e,t,a)},o.nice=function(t){return Wi(e,t),i()},o.copy=function(){return Ui(e,t,a,n)},i()}function Vi(e,t){return Xo.rebind(e,t,"range","rangeRound","interpolate","clamp")}function Wi(e,t){return Hi(e,Bi(zi(e,t)[2]))}function zi(e,t){null==t&&(t=10);var a=Ei(e),n=a[1]-a[0],i=Math.pow(10,Math.floor(Math.log(n/t)/Math.LN10)),o=t/n*i;return.15>=o?i*=10:.35>=o?i*=5:.75>=o&&(i*=2),a[0]=Math.ceil(a[0]/i)*i,a[1]=Math.floor(a[1]/i)*i+.5*i,a[2]=i,a}function Ki(e,t){return Xo.range.apply(Xo,zi(e,t))}function ji(e,t,a){var n=zi(e,t);if(a){var i=as.exec(a);if(i.shift(),"s"===i[8]){var o=Xo.formatPrefix(Math.max(dr(n[0]),dr(n[1])));return i[7]||(i[7]="."+qi(o.scale(n[2]))),i[8]="f",a=Xo.format(i.join("")),function(e){return a(o.scale(e))+o.symbol}}i[7]||(i[7]="."+Xi(i[8],n)),a=i.join("")}else a=",."+qi(n[2])+"f";return Xo.format(a)}function qi(e){return-Math.floor(Math.log(e)/Math.LN10+.01)}function Xi(e,t){var a=qi(t[2]);return e in pc?Math.abs(a-qi(Math.max(dr(t[0]),dr(t[1]))))+ +("e"!==e):a-2*("%"===e)}function Yi(e,t,a,n){function i(e){return(a?Math.log(0>e?0:e):-Math.log(e>0?0:-e))/Math.log(t)}function o(e){return a?Math.pow(t,e):-Math.pow(t,-e)}function r(t){return e(i(t))}return r.invert=function(t){return o(e.invert(t))},r.domain=function(t){return arguments.length?(a=t[0]>=0,e.domain((n=t.map(Number)).map(i)),r):n},r.base=function(a){return arguments.length?(t=+a,e.domain(n.map(i)),r):t},r.nice=function(){var t=Hi(n.map(i),a?Math:_c);return e.domain(t),n=t.map(o),r},r.ticks=function(){var e=Ei(n),r=[],s=e[0],c=e[1],d=Math.floor(i(s)),l=Math.ceil(i(c)),m=t%1?2:t;if(isFinite(l-d)){if(a){for(;l>d;d++)for(var g=1;m>g;g++)r.push(o(d)*g);r.push(o(d))}else for(r.push(o(d));d++<l;)for(var g=m-1;g>0;g--)r.push(o(d)*g);for(d=0;r[d]<s;d++);for(l=r.length;r[l-1]>c;l--);r=r.slice(d,l)}return r},r.tickFormat=function(e,t){if(!arguments.length)return yc;arguments.length<2?t=yc:"function"!=typeof t&&(t=Xo.format(t));var n,s=Math.max(.1,e/r.ticks().length),c=a?(n=1e-12,Math.ceil):(n=-1e-12,Math.floor);return function(e){return e/o(c(i(e)+n))<=s?t(e):""}},r.copy=function(){return Yi(e.copy(),t,a,n)},Vi(r,e)}function Zi(e,t,a){function n(t){return e(i(t))}var i=Ji(t),o=Ji(1/t);return n.invert=function(t){return o(e.invert(t))},n.domain=function(t){return arguments.length?(e.domain((a=t.map(Number)).map(i)),n):a},n.ticks=function(e){return Ki(a,e)},n.tickFormat=function(e,t){return ji(a,e,t)},n.nice=function(e){return n.domain(Wi(a,e))},n.exponent=function(r){return arguments.length?(i=Ji(t=r),o=Ji(1/t),e.domain(a.map(i)),n):t},n.copy=function(){return Zi(e.copy(),t,a)},Vi(n,e)}function Ji(e){return function(t){return 0>t?-Math.pow(-t,e):Math.pow(t,e)}}function Qi(e,t){function a(a){return o[((i.get(a)||("range"===t.t?i.set(a,e.push(a)):NaN))-1)%o.length]}function n(t,a){return Xo.range(e.length).map(function(e){return t+a*e})}var i,o,r;return a.domain=function(n){if(!arguments.length)return e;e=[],i=new s;for(var o,r=-1,c=n.length;++r<c;)i.has(o=n[r])||i.set(o,e.push(o));return a[t.t].apply(a,t.a)},a.range=function(e){return arguments.length?(o=e,r=0,t={t:"range",a:arguments},a):o},a.rangePoints=function(i,s){arguments.length<2&&(s=0);var c=i[0],d=i[1],l=(d-c)/(Math.max(1,e.length-1)+s);
return o=n(e.length<2?(c+d)/2:c+l*s/2,l),r=0,t={t:"rangePoints",a:arguments},a},a.rangeBands=function(i,s,c){arguments.length<2&&(s=0),arguments.length<3&&(c=s);var d=i[1]<i[0],l=i[d-0],m=i[1-d],g=(m-l)/(e.length-s+2*c);return o=n(l+g*c,g),d&&o.reverse(),r=g*(1-s),t={t:"rangeBands",a:arguments},a},a.rangeRoundBands=function(i,s,c){arguments.length<2&&(s=0),arguments.length<3&&(c=s);var d=i[1]<i[0],l=i[d-0],m=i[1-d],g=Math.floor((m-l)/(e.length-s+2*c)),u=m-l-(e.length-s)*g;return o=n(l+Math.round(u/2),g),d&&o.reverse(),r=Math.round(g*(1-s)),t={t:"rangeRoundBands",a:arguments},a},a.rangeBand=function(){return r},a.rangeExtent=function(){return Ei(t.a[0])},a.copy=function(){return Qi(e,t)},a.domain(e)}function eo(n,i){function o(){var e=0,t=i.length;for(s=[];++e<t;)s[e-1]=Xo.quantile(n,e/t);return r}function r(e){return isNaN(e=+e)?void 0:i[Xo.bisect(s,e)]}var s;return r.domain=function(i){return arguments.length?(n=i.map(t).filter(a).sort(e),o()):n},r.range=function(e){return arguments.length?(i=e,o()):i},r.quantiles=function(){return s},r.invertExtent=function(e){return e=i.indexOf(e),0>e?[NaN,NaN]:[e>0?s[e-1]:n[0],e<s.length?s[e]:n[n.length-1]]},r.copy=function(){return eo(n,i)},o()}function to(e,t,a){function n(t){return a[Math.max(0,Math.min(r,Math.floor(o*(t-e))))]}function i(){return o=a.length/(t-e),r=a.length-1,n}var o,r;return n.domain=function(a){return arguments.length?(e=+a[0],t=+a[a.length-1],i()):[e,t]},n.range=function(e){return arguments.length?(a=e,i()):a},n.invertExtent=function(t){return t=a.indexOf(t),t=0>t?NaN:t/o+e,[t,t+1/o]},n.copy=function(){return to(e,t,a)},i()}function ao(e,t){function a(a){return a>=a?t[Xo.bisect(e,a)]:void 0}return a.domain=function(t){return arguments.length?(e=t,a):e},a.range=function(e){return arguments.length?(t=e,a):t},a.invertExtent=function(a){return a=t.indexOf(a),[e[a-1],e[a]]},a.copy=function(){return ao(e,t)},a}function no(e){function t(e){return+e}return t.invert=t,t.domain=t.range=function(a){return arguments.length?(e=a.map(t),t):e},t.ticks=function(t){return Ki(e,t)},t.tickFormat=function(t,a){return ji(e,t,a)},t.copy=function(){return no(e)},t}function io(e){return e.innerRadius}function oo(e){return e.outerRadius}function ro(e){return e.startAngle}function so(e){return e.endAngle}function co(e){function t(t){function r(){d.push("M",o(e(l),s))}for(var c,d=[],l=[],m=-1,g=t.length,u=ke(a),h=ke(n);++m<g;)i.call(this,c=t[m],m)?l.push([+u.call(this,c,m),+h.call(this,c,m)]):l.length&&(r(),l=[]);return l.length&&r(),d.length?d.join(""):null}var a=Pa,n=Ta,i=Pt,o=lo,r=o.key,s=.7;return t.x=function(e){return arguments.length?(a=e,t):a},t.y=function(e){return arguments.length?(n=e,t):n},t.defined=function(e){return arguments.length?(i=e,t):i},t.interpolate=function(e){return arguments.length?(r="function"==typeof e?o=e:(o=xc.get(e)||lo).key,t):r},t.tension=function(e){return arguments.length?(s=e,t):s},t}function lo(e){return e.join("L")}function mo(e){return lo(e)+"Z"}function go(e){for(var t=0,a=e.length,n=e[0],i=[n[0],",",n[1]];++t<a;)i.push("H",(n[0]+(n=e[t])[0])/2,"V",n[1]);return a>1&&i.push("H",n[0]),i.join("")}function uo(e){for(var t=0,a=e.length,n=e[0],i=[n[0],",",n[1]];++t<a;)i.push("V",(n=e[t])[1],"H",n[0]);return i.join("")}function ho(e){for(var t=0,a=e.length,n=e[0],i=[n[0],",",n[1]];++t<a;)i.push("H",(n=e[t])[0],"V",n[1]);return i.join("")}function po(e,t){return e.length<4?lo(e):e[1]+fo(e.slice(1,e.length-1),vo(e,t))}function yo(e,t){return e.length<3?lo(e):e[0]+fo((e.push(e[0]),e),vo([e[e.length-2]].concat(e,[e[1]]),t))}function _o(e,t){return e.length<3?lo(e):e[0]+fo(e,vo(e,t))}function fo(e,t){if(t.length<1||e.length!=t.length&&e.length!=t.length+2)return lo(e);var a=e.length!=t.length,n="",i=e[0],o=e[1],r=t[0],s=r,c=1;if(a&&(n+="Q"+(o[0]-2*r[0]/3)+","+(o[1]-2*r[1]/3)+","+o[0]+","+o[1],i=e[1],c=2),t.length>1){s=t[1],o=e[c],c++,n+="C"+(i[0]+r[0])+","+(i[1]+r[1])+","+(o[0]-s[0])+","+(o[1]-s[1])+","+o[0]+","+o[1];for(var d=2;d<t.length;d++,c++)o=e[c],s=t[d],n+="S"+(o[0]-s[0])+","+(o[1]-s[1])+","+o[0]+","+o[1]}if(a){var l=e[c];n+="Q"+(o[0]+2*s[0]/3)+","+(o[1]+2*s[1]/3)+","+l[0]+","+l[1]}return n}function vo(e,t){for(var a,n=[],i=(1-t)/2,o=e[0],r=e[1],s=1,c=e.length;++s<c;)a=o,o=r,r=e[s],n.push([i*(r[0]-a[0]),i*(r[1]-a[1])]);return n}function bo(e){if(e.length<3)return lo(e);var t=1,a=e.length,n=e[0],i=n[0],o=n[1],r=[i,i,i,(n=e[1])[0]],s=[o,o,o,n[1]],c=[i,",",o,"L",xo(Pc,r),",",xo(Pc,s)];for(e.push(e[a-1]);++t<=a;)n=e[t],r.shift(),r.push(n[0]),s.shift(),s.push(n[1]),ko(c,r,s);return e.pop(),c.push("L",n),c.join("")}function wo(e){if(e.length<4)return lo(e);for(var t,a=[],n=-1,i=e.length,o=[0],r=[0];++n<3;)t=e[n],o.push(t[0]),r.push(t[1]);for(a.push(xo(Pc,o)+","+xo(Pc,r)),--n;++n<i;)t=e[n],o.shift(),o.push(t[0]),r.shift(),r.push(t[1]),ko(a,o,r);return a.join("")}function So(e){for(var t,a,n=-1,i=e.length,o=i+4,r=[],s=[];++n<4;)a=e[n%i],r.push(a[0]),s.push(a[1]);for(t=[xo(Pc,r),",",xo(Pc,s)],--n;++n<o;)a=e[n%i],r.shift(),r.push(a[0]),s.shift(),s.push(a[1]),ko(t,r,s);return t.join("")}function Co(e,t){var a=e.length-1;if(a)for(var n,i,o=e[0][0],r=e[0][1],s=e[a][0]-o,c=e[a][1]-r,d=-1;++d<=a;)n=e[d],i=d/a,n[0]=t*n[0]+(1-t)*(o+i*s),n[1]=t*n[1]+(1-t)*(r+i*c);return bo(e)}function xo(e,t){return e[0]*t[0]+e[1]*t[1]+e[2]*t[2]+e[3]*t[3]}function ko(e,t,a){e.push("C",xo(kc,t),",",xo(kc,a),",",xo(Mc,t),",",xo(Mc,a),",",xo(Pc,t),",",xo(Pc,a))}function Mo(e,t){return(t[1]-e[1])/(t[0]-e[0])}function Po(e){for(var t=0,a=e.length-1,n=[],i=e[0],o=e[1],r=n[0]=Mo(i,o);++t<a;)n[t]=(r+(r=Mo(i=o,o=e[t+1])))/2;return n[t]=r,n}function To(e){for(var t,a,n,i,o=[],r=Po(e),s=-1,c=e.length-1;++s<c;)t=Mo(e[s],e[s+1]),dr(t)<Dr?r[s]=r[s+1]=0:(a=r[s]/t,n=r[s+1]/t,i=a*a+n*n,i>9&&(i=3*t/Math.sqrt(i),r[s]=i*a,r[s+1]=i*n));for(s=-1;++s<=c;)i=(e[Math.min(c,s+1)][0]-e[Math.max(0,s-1)][0])/(6*(1+r[s]*r[s])),o.push([i||0,r[s]*i||0]);return o}function Ao(e){return e.length<3?lo(e):e[0]+fo(e,To(e))}function Do(e){for(var t,a,n,i=-1,o=e.length;++i<o;)t=e[i],a=t[0],n=t[1]+Sc,t[0]=a*Math.cos(n),t[1]=a*Math.sin(n);return e}function Go(e){function t(t){function c(){p.push("M",s(e(_),m),l,d(e(y.reverse()),m),"Z")}for(var g,u,h,p=[],y=[],_=[],f=-1,v=t.length,b=ke(a),w=ke(i),S=a===n?function(){return u}:ke(n),C=i===o?function(){return h}:ke(o);++f<v;)r.call(this,g=t[f],f)?(y.push([u=+b.call(this,g,f),h=+w.call(this,g,f)]),_.push([+S.call(this,g,f),+C.call(this,g,f)])):y.length&&(c(),y=[],_=[]);return y.length&&c(),p.length?p.join(""):null}var a=Pa,n=Pa,i=0,o=Ta,r=Pt,s=lo,c=s.key,d=s,l="L",m=.7;return t.x=function(e){return arguments.length?(a=n=e,t):n},t.x0=function(e){return arguments.length?(a=e,t):a},t.x1=function(e){return arguments.length?(n=e,t):n},t.y=function(e){return arguments.length?(i=o=e,t):o},t.y0=function(e){return arguments.length?(i=e,t):i},t.y1=function(e){return arguments.length?(o=e,t):o},t.defined=function(e){return arguments.length?(r=e,t):r},t.interpolate=function(e){return arguments.length?(c="function"==typeof e?s=e:(s=xc.get(e)||lo).key,d=s.reverse||s,l=s.closed?"M":"L",t):c},t.tension=function(e){return arguments.length?(m=e,t):m},t}function Fo(e){return e.radius}function $o(e){return[e.x,e.y]}function No(e){return function(){var t=e.apply(this,arguments),a=t[0],n=t[1]+Sc;return[a*Math.cos(n),a*Math.sin(n)]}}function Lo(){return 64}function Eo(){return"circle"}function Ro(e){var t=Math.sqrt(e/Pr);return"M0,"+t+"A"+t+","+t+" 0 1,1 0,"+-t+"A"+t+","+t+" 0 1,1 0,"+t+"Z"}function Io(e,t){return hr(e,$c),e.id=t,e}function Ho(e,t,a,n){var i=e.id;return H(e,"function"==typeof a?function(e,o,r){e.__transition__[i].tween.set(t,n(a.call(e,e.__data__,o,r)))}:(a=n(a),function(e){e.__transition__[i].tween.set(t,a)}))}function Bo(e){return null==e&&(e=""),function(){this.textContent=e}}function Oo(e,t,a,n){var i=e.__transition__||(e.__transition__={active:0,count:0}),o=i[a];if(!o){var r=n.time;o=i[a]={tween:new s,time:r,ease:n.ease,delay:n.delay,duration:n.duration},++i.count,Xo.timer(function(n){function s(n){return i.active>a?d():(i.active=a,o.event&&o.event.start.call(e,l,t),o.tween.forEach(function(a,n){(n=n.call(e,l,t))&&p.push(n)}),void Xo.timer(function(){return h.c=c(n||1)?Pt:c,1},0,r))}function c(n){if(i.active!==a)return d();for(var r=n/u,s=m(r),c=p.length;c>0;)p[--c].call(e,s);return r>=1?(o.event&&o.event.end.call(e,l,t),d()):void 0}function d(){return--i.count?delete i[a]:delete e.__transition__,1}var l=e.__data__,m=o.ease,g=o.delay,u=o.duration,h=Qr,p=[];return h.t=g+r,n>=g?s(n-g):void(h.c=s)},0,r)}}function Uo(e,t,a){e.attr("transform",function(e){var n=t(e);return"translate("+(isFinite(n)?n:a(e))+",0)"})}function Vo(e,t,a){e.attr("transform",function(e){var n=t(e);return"translate(0,"+(isFinite(n)?n:a(e))+")"})}function Wo(e){return e.toISOString()}function zo(e,t,a){function n(t){return e(t)}function i(e,a){var n=e[1]-e[0],i=n/a,o=Xo.bisect(Uc,i);return o==Uc.length?[t.year,zi(e.map(function(e){return e/31536e6}),a)[2]]:o?t[i/Uc[o-1]<Uc[o]/i?o-1:o]:[zc,zi(e,a)[2]]}return n.invert=function(t){return Ko(e.invert(t))},n.domain=function(t){return arguments.length?(e.domain(t),n):e.domain().map(Ko)},n.nice=function(e,t){function a(a){return!isNaN(a)&&!e.range(a,Ko(+a+1),t).length}var o=n.domain(),r=Ei(o),s=null==e?i(r,10):"number"==typeof e&&i(r,e);return s&&(e=s[0],t=s[1]),n.domain(Hi(o,t>1?{floor:function(t){for(;a(t=e.floor(t));)t=Ko(t-1);return t},ceil:function(t){for(;a(t=e.ceil(t));)t=Ko(+t+1);return t}}:e))},n.ticks=function(e,t){var a=Ei(n.domain()),o=null==e?i(a,10):"number"==typeof e?i(a,e):!e.range&&[{range:e},t];return o&&(e=o[0],t=o[1]),e.range(a[0],Ko(+a[1]+1),1>t?1:t)},n.tickFormat=function(){return a},n.copy=function(){return zo(e.copy(),t,a)},Vi(n,e)}function Ko(e){return new Date(e)}function jo(e){return JSON.parse(e.responseText)}function qo(e){var t=Jo.createRange();return t.selectNode(Jo.body),t.createContextualFragment(e.responseText)}var Xo={version:"3.4.13"};Date.now||(Date.now=function(){return+new Date});var Yo=[].slice,Zo=function(e){return Yo.call(e)},Jo=document,Qo=Jo.documentElement,er=window;try{Zo(Qo.childNodes)[0].nodeType}catch(tr){Zo=function(e){for(var t=e.length,a=new Array(t);t--;)a[t]=e[t];return a}}try{Jo.createElement("div").style.setProperty("opacity",0,"")}catch(ar){var nr=er.Element.prototype,ir=nr.setAttribute,or=nr.setAttributeNS,rr=er.CSSStyleDeclaration.prototype,sr=rr.setProperty;nr.setAttribute=function(e,t){ir.call(this,e,t+"")},nr.setAttributeNS=function(e,t,a){or.call(this,e,t,a+"")},rr.setProperty=function(e,t,a){sr.call(this,e,t+"",a)}}Xo.ascending=e,Xo.descending=function(e,t){return e>t?-1:t>e?1:t>=e?0:NaN},Xo.min=function(e,t){var a,n,i=-1,o=e.length;if(1===arguments.length){for(;++i<o&&!(null!=(a=e[i])&&a>=a);)a=void 0;for(;++i<o;)null!=(n=e[i])&&a>n&&(a=n)}else{for(;++i<o&&!(null!=(a=t.call(e,e[i],i))&&a>=a);)a=void 0;for(;++i<o;)null!=(n=t.call(e,e[i],i))&&a>n&&(a=n)}return a},Xo.max=function(e,t){var a,n,i=-1,o=e.length;if(1===arguments.length){for(;++i<o&&!(null!=(a=e[i])&&a>=a);)a=void 0;for(;++i<o;)null!=(n=e[i])&&n>a&&(a=n)}else{for(;++i<o&&!(null!=(a=t.call(e,e[i],i))&&a>=a);)a=void 0;for(;++i<o;)null!=(n=t.call(e,e[i],i))&&n>a&&(a=n)}return a},Xo.extent=function(e,t){var a,n,i,o=-1,r=e.length;if(1===arguments.length){for(;++o<r&&!(null!=(a=i=e[o])&&a>=a);)a=i=void 0;for(;++o<r;)null!=(n=e[o])&&(a>n&&(a=n),n>i&&(i=n))}else{for(;++o<r&&!(null!=(a=i=t.call(e,e[o],o))&&a>=a);)a=void 0;for(;++o<r;)null!=(n=t.call(e,e[o],o))&&(a>n&&(a=n),n>i&&(i=n))}return[a,i]},Xo.sum=function(e,t){var n,i=0,o=e.length,r=-1;if(1===arguments.length)for(;++r<o;)a(n=+e[r])&&(i+=n);else for(;++r<o;)a(n=+t.call(e,e[r],r))&&(i+=n);return i},Xo.mean=function(e,n){var i,o=0,r=e.length,s=-1,c=r;if(1===arguments.length)for(;++s<r;)a(i=t(e[s]))?o+=i:--c;else for(;++s<r;)a(i=t(n.call(e,e[s],s)))?o+=i:--c;return c?o/c:void 0},Xo.quantile=function(e,t){var a=(e.length-1)*t+1,n=Math.floor(a),i=+e[n-1],o=a-n;return o?i+o*(e[n]-i):i},Xo.median=function(n,i){var o,r=[],s=n.length,c=-1;if(1===arguments.length)for(;++c<s;)a(o=t(n[c]))&&r.push(o);else for(;++c<s;)a(o=t(i.call(n,n[c],c)))&&r.push(o);return r.length?Xo.quantile(r.sort(e),.5):void 0};var cr=n(e);Xo.bisectLeft=cr.left,Xo.bisect=Xo.bisectRight=cr.right,Xo.bisector=function(t){return n(1===t.length?function(a,n){return e(t(a),n)}:t)},Xo.shuffle=function(e){for(var t,a,n=e.length;n;)a=Math.random()*n--|0,t=e[n],e[n]=e[a],e[a]=t;return e},Xo.permute=function(e,t){for(var a=t.length,n=new Array(a);a--;)n[a]=e[t[a]];return n},Xo.pairs=function(e){for(var t,a=0,n=e.length-1,i=e[0],o=new Array(0>n?0:n);n>a;)o[a]=[t=i,i=e[++a]];return o},Xo.zip=function(){if(!(n=arguments.length))return[];for(var e=-1,t=Xo.min(arguments,i),a=new Array(t);++e<t;)for(var n,o=-1,r=a[e]=new Array(n);++o<n;)r[o]=arguments[o][e];return a},Xo.transpose=function(e){return Xo.zip.apply(Xo,e)},Xo.keys=function(e){var t=[];for(var a in e)t.push(a);return t},Xo.values=function(e){var t=[];for(var a in e)t.push(e[a]);return t},Xo.entries=function(e){var t=[];for(var a in e)t.push({key:a,value:e[a]});return t},Xo.merge=function(e){for(var t,a,n,i=e.length,o=-1,r=0;++o<i;)r+=e[o].length;for(a=new Array(r);--i>=0;)for(n=e[i],t=n.length;--t>=0;)a[--r]=n[t];return a};var dr=Math.abs;Xo.range=function(e,t,a){if(arguments.length<3&&(a=1,arguments.length<2&&(t=e,e=0)),(t-e)/a===1/0)throw new Error("infinite range");var n,i=[],r=o(dr(a)),s=-1;if(e*=r,t*=r,a*=r,0>a)for(;(n=e+a*++s)>t;)i.push(n/r);else for(;(n=e+a*++s)<t;)i.push(n/r);return i},Xo.map=function(e){var t=new s;if(e instanceof s)e.forEach(function(e,a){t.set(e,a)});else for(var a in e)t.set(a,e[a]);return t};var lr="__proto__",mr="\x00";r(s,{has:l,get:function(e){return this._[c(e)]},set:function(e,t){return this._[c(e)]=t},remove:m,keys:g,values:function(){var e=[];for(var t in this._)e.push(this._[t]);return e},entries:function(){var e=[];for(var t in this._)e.push({key:d(t),value:this._[t]});return e},size:u,empty:h,forEach:function(e){for(var t in this._)e.call(this,d(t),this._[t])}}),Xo.nest=function(){function e(t,r,c){if(c>=o.length)return n?n.call(i,r):a?r.sort(a):r;for(var d,l,m,g,u=-1,h=r.length,p=o[c++],y=new s;++u<h;)(g=y.get(d=p(l=r[u])))?g.push(l):y.set(d,[l]);return t?(l=t(),m=function(a,n){l.set(a,e(t,n,c))}):(l={},m=function(a,n){l[a]=e(t,n,c)}),y.forEach(m),l}function t(e,a){if(a>=o.length)return e;var n=[],i=r[a++];return e.forEach(function(e,i){n.push({key:e,values:t(i,a)})}),i?n.sort(function(e,t){return i(e.key,t.key)}):n}var a,n,i={},o=[],r=[];return i.map=function(t,a){return e(a,t,0)},i.entries=function(a){return t(e(Xo.map,a,0),0)},i.key=function(e){return o.push(e),i},i.sortKeys=function(e){return r[o.length-1]=e,i},i.sortValues=function(e){return a=e,i},i.rollup=function(e){return n=e,i},i},Xo.set=function(e){var t=new p;if(e)for(var a=0,n=e.length;n>a;++a)t.add(e[a]);return t},r(p,{has:l,add:function(e){return this._[c(e+="")]=!0,e},remove:m,values:g,size:u,empty:h,forEach:function(e){for(var t in this._)e.call(this,d(t))}}),Xo.behavior={},Xo.rebind=function(e,t){for(var a,n=1,i=arguments.length;++n<i;)e[a=arguments[n]]=y(e,t,t[a]);return e};var gr=["webkit","ms","moz","Moz","o","O"];Xo.dispatch=function(){for(var e=new v,t=-1,a=arguments.length;++t<a;)e[arguments[t]]=b(e);return e},v.prototype.on=function(e,t){var a=e.indexOf("."),n="";if(a>=0&&(n=e.slice(a+1),e=e.slice(0,a)),e)return arguments.length<2?this[e].on(n):this[e].on(n,t);if(2===arguments.length){if(null==t)for(e in this)this.hasOwnProperty(e)&&this[e].on(n,null);return this}},Xo.event=null,Xo.requote=function(e){return e.replace(ur,"\\$&")};var ur=/[\\\^\$\*\+\?\|\[\]\(\)\.\{\}]/g,hr={}.__proto__?function(e,t){e.__proto__=t}:function(e,t){for(var a in t)e[a]=t[a]},pr=function(e,t){return t.querySelector(e)},yr=function(e,t){return t.querySelectorAll(e)},_r=Qo.matches||Qo[_(Qo,"matchesSelector")],fr=function(e,t){return _r.call(e,t)};"function"==typeof Sizzle&&(pr=function(e,t){return Sizzle(e,t)[0]||null},yr=Sizzle,fr=Sizzle.matchesSelector),Xo.selection=function(){return Sr};var vr=Xo.selection.prototype=[];vr.select=function(e){var t,a,n,i,o=[];e=k(e);for(var r=-1,s=this.length;++r<s;){o.push(t=[]),t.parentNode=(n=this[r]).parentNode;for(var c=-1,d=n.length;++c<d;)(i=n[c])?(t.push(a=e.call(i,i.__data__,c,r)),a&&"__data__"in i&&(a.__data__=i.__data__)):t.push(null)}return x(o)},vr.selectAll=function(e){var t,a,n=[];e=M(e);for(var i=-1,o=this.length;++i<o;)for(var r=this[i],s=-1,c=r.length;++s<c;)(a=r[s])&&(n.push(t=Zo(e.call(a,a.__data__,s,i))),t.parentNode=a);return x(n)};var br={svg:"http://www.w3.org/2000/svg",xhtml:"http://www.w3.org/1999/xhtml",xlink:"http://www.w3.org/1999/xlink",xml:"http://www.w3.org/XML/1998/namespace",xmlns:"http://www.w3.org/2000/xmlns/"};Xo.ns={prefix:br,qualify:function(e){var t=e.indexOf(":"),a=e;return t>=0&&(a=e.slice(0,t),e=e.slice(t+1)),br.hasOwnProperty(a)?{space:br[a],local:e}:e}},vr.attr=function(e,t){if(arguments.length<2){if("string"==typeof e){var a=this.node();return e=Xo.ns.qualify(e),e.local?a.getAttributeNS(e.space,e.local):a.getAttribute(e)}for(t in e)this.each(P(t,e[t]));return this}return this.each(P(e,t))},vr.classed=function(e,t){if(arguments.length<2){if("string"==typeof e){var a=this.node(),n=(e=D(e)).length,i=-1;if(t=a.classList){for(;++i<n;)if(!t.contains(e[i]))return!1}else for(t=a.getAttribute("class");++i<n;)if(!A(e[i]).test(t))return!1;return!0}for(t in e)this.each(G(t,e[t]));return this}return this.each(G(e,t))},vr.style=function(e,t,a){var n=arguments.length;if(3>n){if("string"!=typeof e){2>n&&(t="");for(a in e)this.each($(a,e[a],t));return this}if(2>n)return er.getComputedStyle(this.node(),null).getPropertyValue(e);a=""}return this.each($(e,t,a))},vr.property=function(e,t){if(arguments.length<2){if("string"==typeof e)return this.node()[e];for(t in e)this.each(N(t,e[t]));return this}return this.each(N(e,t))},vr.text=function(e){return arguments.length?this.each("function"==typeof e?function(){var t=e.apply(this,arguments);this.textContent=null==t?"":t}:null==e?function(){this.textContent=""}:function(){this.textContent=e}):this.node().textContent},vr.html=function(e){return arguments.length?this.each("function"==typeof e?function(){var t=e.apply(this,arguments);this.innerHTML=null==t?"":t}:null==e?function(){this.innerHTML=""}:function(){this.innerHTML=e}):this.node().innerHTML},vr.append=function(e){return e=L(e),this.select(function(){return this.appendChild(e.apply(this,arguments))})},vr.insert=function(e,t){return e=L(e),t=k(t),this.select(function(){return this.insertBefore(e.apply(this,arguments),t.apply(this,arguments)||null)})},vr.remove=function(){return this.each(function(){var e=this.parentNode;e&&e.removeChild(this)})},vr.data=function(e,t){function a(e,a){var n,i,o,r=e.length,m=a.length,g=Math.min(r,m),u=new Array(m),h=new Array(m),p=new Array(r);if(t){var y,_=new s,f=new Array(r);for(n=-1;++n<r;)_.has(y=t.call(i=e[n],i.__data__,n))?p[n]=i:_.set(y,i),f[n]=y;for(n=-1;++n<m;)(i=_.get(y=t.call(a,o=a[n],n)))?i!==!0&&(u[n]=i,i.__data__=o):h[n]=E(o),_.set(y,!0);for(n=-1;++n<r;)_.get(f[n])!==!0&&(p[n]=e[n])}else{for(n=-1;++n<g;)i=e[n],o=a[n],i?(i.__data__=o,u[n]=i):h[n]=E(o);for(;m>n;++n)h[n]=E(a[n]);for(;r>n;++n)p[n]=e[n]}h.update=u,h.parentNode=u.parentNode=p.parentNode=e.parentNode,c.push(h),d.push(u),l.push(p)}var n,i,o=-1,r=this.length;if(!arguments.length){for(e=new Array(r=(n=this[0]).length);++o<r;)(i=n[o])&&(e[o]=i.__data__);return e}var c=B([]),d=x([]),l=x([]);if("function"==typeof e)for(;++o<r;)a(n=this[o],e.call(n,n.parentNode.__data__,o));else for(;++o<r;)a(n=this[o],e);return d.enter=function(){return c},d.exit=function(){return l},d},vr.datum=function(e){return arguments.length?this.property("__data__",e):this.property("__data__")},vr.filter=function(e){var t,a,n,i=[];"function"!=typeof e&&(e=R(e));for(var o=0,r=this.length;r>o;o++){i.push(t=[]),t.parentNode=(a=this[o]).parentNode;for(var s=0,c=a.length;c>s;s++)(n=a[s])&&e.call(n,n.__data__,s,o)&&t.push(n)}return x(i)},vr.order=function(){for(var e=-1,t=this.length;++e<t;)for(var a,n=this[e],i=n.length-1,o=n[i];--i>=0;)(a=n[i])&&(o&&o!==a.nextSibling&&o.parentNode.insertBefore(a,o),o=a);return this},vr.sort=function(e){e=I.apply(this,arguments);for(var t=-1,a=this.length;++t<a;)this[t].sort(e);return this.order()},vr.each=function(e){return H(this,function(t,a,n){e.call(t,t.__data__,a,n)})},vr.call=function(e){var t=Zo(arguments);return e.apply(t[0]=this,t),this},vr.empty=function(){return!this.node()},vr.node=function(){for(var e=0,t=this.length;t>e;e++)for(var a=this[e],n=0,i=a.length;i>n;n++){var o=a[n];if(o)return o}return null},vr.size=function(){var e=0;return H(this,function(){++e}),e};var wr=[];Xo.selection.enter=B,Xo.selection.enter.prototype=wr,wr.append=vr.append,wr.empty=vr.empty,wr.node=vr.node,wr.call=vr.call,wr.size=vr.size,wr.select=function(e){for(var t,a,n,i,o,r=[],s=-1,c=this.length;++s<c;){n=(i=this[s]).update,r.push(t=[]),t.parentNode=i.parentNode;for(var d=-1,l=i.length;++d<l;)(o=i[d])?(t.push(n[d]=a=e.call(i.parentNode,o.__data__,d,s)),a.__data__=o.__data__):t.push(null)}return x(r)},wr.insert=function(e,t){return arguments.length<2&&(t=O(this)),vr.insert.call(this,e,t)},vr.transition=function(){for(var e,t,a=Ac||++Nc,n=[],i=Dc||{time:Date.now(),ease:xn,delay:0,duration:250},o=-1,r=this.length;++o<r;){n.push(e=[]);for(var s=this[o],c=-1,d=s.length;++c<d;)(t=s[c])&&Oo(t,c,a,i),e.push(t)}return Io(n,a)},vr.interrupt=function(){return this.each(U)},Xo.select=function(e){var t=["string"==typeof e?pr(e,Jo):e];return t.parentNode=Qo,x([t])},Xo.selectAll=function(e){var t=Zo("string"==typeof e?yr(e,Jo):e);return t.parentNode=Qo,x([t])};var Sr=Xo.select(Qo);vr.on=function(e,t,a){var n=arguments.length;if(3>n){if("string"!=typeof e){2>n&&(t=!1);for(a in e)this.each(V(a,e[a],t));return this}if(2>n)return(n=this.node()["__on"+e])&&n._;a=!1}return this.each(V(e,t,a))};var Cr=Xo.map({mouseenter:"mouseover",mouseleave:"mouseout"});Cr.forEach(function(e){"on"+e in Jo&&Cr.remove(e)});var xr="onselectstart"in Jo?null:_(Qo.style,"userSelect"),kr=0;Xo.mouse=function(e){return j(e,S())};var Mr=/WebKit/.test(er.navigator.userAgent)?-1:0;Xo.touch=function(e,t,a){if(arguments.length<3&&(a=t,t=S().changedTouches),t)for(var n,i=0,o=t.length;o>i;++i)if((n=t[i]).identifier===a)return j(e,n)},Xo.behavior.drag=function(){function e(){this.on("mousedown.drag",i).on("touchstart.drag",o)}function t(e,t,i,o,r){return function(){function s(){var e,a,n=t(g,p);n&&(e=n[0]-v[0],a=n[1]-v[1],h|=e|a,v=n,u({type:"drag",x:n[0]+d[0],y:n[1]+d[1],dx:e,dy:a}))}function c(){t(g,p)&&(_.on(o+y,null).on(r+y,null),f(h&&Xo.event.target===m),u({type:"dragend"}))}var d,l=this,m=Xo.event.target,g=l.parentNode,u=a.of(l,arguments),h=0,p=e(),y=".drag"+(null==p?"":"-"+p),_=Xo.select(i()).on(o+y,s).on(r+y,c),f=K(),v=t(g,p);n?(d=n.apply(l,arguments),d=[d.x-v[0],d.y-v[1]]):d=[0,0],u({type:"dragstart"})}}var a=C(e,"drag","dragstart","dragend"),n=null,i=t(f,Xo.mouse,Y,"mousemove","mouseup"),o=t(q,Xo.touch,X,"touchmove","touchend");return e.origin=function(t){return arguments.length?(n=t,e):n},Xo.rebind(e,a,"on")},Xo.touches=function(e,t){return arguments.length<2&&(t=S().touches),t?Zo(t).map(function(t){var a=j(e,t);return a.identifier=t.identifier,a}):[]};var Pr=Math.PI,Tr=2*Pr,Ar=Pr/2,Dr=1e-6,Gr=Dr*Dr,Fr=Pr/180,$r=180/Pr,Nr=Math.SQRT2,Lr=2,Er=4;Xo.interpolateZoom=function(e,t){function a(e){var t=e*f;if(_){var a=ae(p),r=o/(Lr*g)*(a*ne(Nr*t+p)-te(p));return[n+r*d,i+r*l,o*a/ae(Nr*t+p)]}return[n+e*d,i+e*l,o*Math.exp(Nr*t)]}var n=e[0],i=e[1],o=e[2],r=t[0],s=t[1],c=t[2],d=r-n,l=s-i,m=d*d+l*l,g=Math.sqrt(m),u=(c*c-o*o+Er*m)/(2*o*Lr*g),h=(c*c-o*o-Er*m)/(2*c*Lr*g),p=Math.log(Math.sqrt(u*u+1)-u),y=Math.log(Math.sqrt(h*h+1)-h),_=y-p,f=(_||Math.log(c/o))/Nr;return a.duration=1e3*f,a},Xo.behavior.zoom=function(){function e(e){e.on(P,d).on(Hr+".zoom",m).on("dblclick.zoom",g).on(D,l)}function t(e){return[(e[0]-x.x)/x.k,(e[1]-x.y)/x.k]}function a(e){return[e[0]*x.k+x.x,e[1]*x.k+x.y]}function n(e){x.k=Math.max(M[0],Math.min(M[1],e))}function i(e,t){t=a(t),x.x+=e[0]-t[0],x.y+=e[1]-t[1]}function o(){v&&v.domain(f.range().map(function(e){return(e-x.x)/x.k}).map(f.invert)),S&&S.domain(b.range().map(function(e){return(e-x.y)/x.k}).map(b.invert))}function r(e){e({type:"zoomstart"})}function s(e){o(),e({type:"zoom",scale:x.k,translate:[x.x,x.y]})}function c(e){e({type:"zoomend"})}function d(){function e(){l=1,i(Xo.mouse(n),g),s(d)}function a(){m.on(T,null).on(A,null),u(l&&Xo.event.target===o),c(d)}var n=this,o=Xo.event.target,d=G.of(n,arguments),l=0,m=Xo.select(er).on(T,e).on(A,a),g=t(Xo.mouse(n)),u=K();U.call(n),r(d)}function l(){function e(){var e=Xo.touches(u);return g=x.k,e.forEach(function(e){e.identifier in p&&(p[e.identifier]=t(e))}),e}function a(){var t=Xo.event.target;Xo.select(t).on(v,o).on(b,m),S.push(t);for(var a=Xo.event.changedTouches,r=0,c=a.length;c>r;++r)p[a[r].identifier]=null;var d=e(),l=Date.now();if(1===d.length){if(500>l-_){var g=d[0],u=p[g.identifier];n(2*x.k),i(g,u),w(),s(h)}_=l}else if(d.length>1){var g=d[0],f=d[1],C=g[0]-f[0],k=g[1]-f[1];y=C*C+k*k}}function o(){for(var e,t,a,o,r=Xo.touches(u),c=0,d=r.length;d>c;++c,o=null)if(a=r[c],o=p[a.identifier]){if(t)break;e=a,t=o}if(o){var l=(l=a[0]-e[0])*l+(l=a[1]-e[1])*l,m=y&&Math.sqrt(l/y);e=[(e[0]+a[0])/2,(e[1]+a[1])/2],t=[(t[0]+o[0])/2,(t[1]+o[1])/2],n(m*g)}_=null,i(e,t),s(h)}function m(){if(Xo.event.touches.length){for(var t=Xo.event.changedTouches,a=0,n=t.length;n>a;++a)delete p[t[a].identifier];for(var i in p)return void e()}Xo.selectAll(S).on(f,null),C.on(P,d).on(D,l),k(),c(h)}var g,u=this,h=G.of(u,arguments),p={},y=0,f=".zoom-"+Xo.event.changedTouches[0].identifier,v="touchmove"+f,b="touchend"+f,S=[],C=Xo.select(u),k=K();U.call(u),a(),r(h),C.on(P,null).on(D,a)}function m(){var e=G.of(this,arguments);y?clearTimeout(y):(u=t(h=p||Xo.mouse(this)),U.call(this),r(e)),y=setTimeout(function(){y=null,c(e)},50),w(),n(Math.pow(2,.002*Rr())*x.k),i(h,u),s(e)}function g(){var e=G.of(this,arguments),a=Xo.mouse(this),o=t(a),d=Math.log(x.k)/Math.LN2;r(e),n(Math.pow(2,Xo.event.shiftKey?Math.ceil(d)-1:Math.floor(d)+1)),i(a,o),s(e),c(e)}var u,h,p,y,_,f,v,b,S,x={x:0,y:0,k:1},k=[960,500],M=Ir,P="mousedown.zoom",T="mousemove.zoom",A="mouseup.zoom",D="touchstart.zoom",G=C(e,"zoomstart","zoom","zoomend");return e.event=function(e){e.each(function(){var e=G.of(this,arguments),t=x;Ac?Xo.select(this).transition().each("start.zoom",function(){x=this.__chart__||{x:0,y:0,k:1},r(e)}).tween("zoom:zoom",function(){var a=k[0],n=k[1],i=a/2,o=n/2,r=Xo.interpolateZoom([(i-x.x)/x.k,(o-x.y)/x.k,a/x.k],[(i-t.x)/t.k,(o-t.y)/t.k,a/t.k]);return function(t){var n=r(t),c=a/n[2];this.__chart__=x={x:i-n[0]*c,y:o-n[1]*c,k:c},s(e)}}).each("end.zoom",function(){c(e)}):(this.__chart__=x,r(e),s(e),c(e))})},e.translate=function(t){return arguments.length?(x={x:+t[0],y:+t[1],k:x.k},o(),e):[x.x,x.y]},e.scale=function(t){return arguments.length?(x={x:x.x,y:x.y,k:+t},o(),e):x.k},e.scaleExtent=function(t){return arguments.length?(M=null==t?Ir:[+t[0],+t[1]],e):M},e.center=function(t){return arguments.length?(p=t&&[+t[0],+t[1]],e):p},e.size=function(t){return arguments.length?(k=t&&[+t[0],+t[1]],e):k},e.x=function(t){return arguments.length?(v=t,f=t.copy(),x={x:0,y:0,k:1},e):v},e.y=function(t){return arguments.length?(S=t,b=t.copy(),x={x:0,y:0,k:1},e):S},Xo.rebind(e,G,"on")};var Rr,Ir=[0,1/0],Hr="onwheel"in Jo?(Rr=function(){return-Xo.event.deltaY*(Xo.event.deltaMode?120:1)},"wheel"):"onmousewheel"in Jo?(Rr=function(){return Xo.event.wheelDelta},"mousewheel"):(Rr=function(){return-Xo.event.detail},"MozMousePixelScroll");Xo.color=oe,oe.prototype.toString=function(){return this.rgb()+""},Xo.hsl=re;var Br=re.prototype=new oe;Br.brighter=function(e){return e=Math.pow(.7,arguments.length?e:1),new re(this.h,this.s,this.l/e)},Br.darker=function(e){return e=Math.pow(.7,arguments.length?e:1),new re(this.h,this.s,e*this.l)},Br.rgb=function(){return se(this.h,this.s,this.l)},Xo.hcl=ce;var Or=ce.prototype=new oe;Or.brighter=function(e){return new ce(this.h,this.c,Math.min(100,this.l+Ur*(arguments.length?e:1)))},Or.darker=function(e){return new ce(this.h,this.c,Math.max(0,this.l-Ur*(arguments.length?e:1)))},Or.rgb=function(){return de(this.h,this.c,this.l).rgb()},Xo.lab=le;var Ur=18,Vr=.95047,Wr=1,zr=1.08883,Kr=le.prototype=new oe;Kr.brighter=function(e){return new le(Math.min(100,this.l+Ur*(arguments.length?e:1)),this.a,this.b)},Kr.darker=function(e){return new le(Math.max(0,this.l-Ur*(arguments.length?e:1)),this.a,this.b)},Kr.rgb=function(){return me(this.l,this.a,this.b)},Xo.rgb=ye;var jr=ye.prototype=new oe;jr.brighter=function(e){e=Math.pow(.7,arguments.length?e:1);var t=this.r,a=this.g,n=this.b,i=30;return t||a||n?(t&&i>t&&(t=i),a&&i>a&&(a=i),n&&i>n&&(n=i),new ye(Math.min(255,t/e),Math.min(255,a/e),Math.min(255,n/e))):new ye(i,i,i)},jr.darker=function(e){return e=Math.pow(.7,arguments.length?e:1),new ye(e*this.r,e*this.g,e*this.b)},jr.hsl=function(){return we(this.r,this.g,this.b)},jr.toString=function(){return"#"+ve(this.r)+ve(this.g)+ve(this.b)};var qr=Xo.map({aliceblue:15792383,antiquewhite:16444375,aqua:65535,aquamarine:8388564,azure:15794175,beige:16119260,bisque:16770244,black:0,blanchedalmond:16772045,blue:255,blueviolet:9055202,brown:10824234,burlywood:14596231,cadetblue:6266528,chartreuse:8388352,chocolate:13789470,coral:16744272,cornflowerblue:6591981,cornsilk:16775388,crimson:14423100,cyan:65535,darkblue:139,darkcyan:35723,darkgoldenrod:12092939,darkgray:11119017,darkgreen:25600,darkgrey:11119017,darkkhaki:12433259,darkmagenta:9109643,darkolivegreen:5597999,darkorange:16747520,darkorchid:10040012,darkred:9109504,darksalmon:15308410,darkseagreen:9419919,darkslateblue:4734347,darkslategray:3100495,darkslategrey:3100495,darkturquoise:52945,darkviolet:9699539,deeppink:16716947,deepskyblue:49151,dimgray:6908265,dimgrey:6908265,dodgerblue:2003199,firebrick:11674146,floralwhite:16775920,forestgreen:2263842,fuchsia:16711935,gainsboro:14474460,ghostwhite:16316671,gold:16766720,goldenrod:14329120,gray:8421504,green:32768,greenyellow:11403055,grey:8421504,honeydew:15794160,hotpink:16738740,indianred:13458524,indigo:4915330,ivory:16777200,khaki:15787660,lavender:15132410,lavenderblush:16773365,lawngreen:8190976,lemonchiffon:16775885,lightblue:11393254,lightcoral:15761536,lightcyan:14745599,lightgoldenrodyellow:16448210,lightgray:13882323,lightgreen:9498256,lightgrey:13882323,lightpink:16758465,lightsalmon:16752762,lightseagreen:2142890,lightskyblue:8900346,lightslategray:7833753,lightslategrey:7833753,lightsteelblue:11584734,lightyellow:16777184,lime:65280,limegreen:3329330,linen:16445670,magenta:16711935,maroon:8388608,mediumaquamarine:6737322,mediumblue:205,mediumorchid:12211667,mediumpurple:9662683,mediumseagreen:3978097,mediumslateblue:8087790,mediumspringgreen:64154,mediumturquoise:4772300,mediumvioletred:13047173,midnightblue:1644912,mintcream:16121850,mistyrose:16770273,moccasin:16770229,navajowhite:16768685,navy:128,oldlace:16643558,olive:8421376,olivedrab:7048739,orange:16753920,orangered:16729344,orchid:14315734,palegoldenrod:15657130,palegreen:10025880,paleturquoise:11529966,palevioletred:14381203,papayawhip:16773077,peachpuff:16767673,peru:13468991,pink:16761035,plum:14524637,powderblue:11591910,purple:8388736,red:16711680,rosybrown:12357519,royalblue:4286945,saddlebrown:9127187,salmon:16416882,sandybrown:16032864,seagreen:3050327,seashell:16774638,sienna:10506797,silver:12632256,skyblue:8900331,slateblue:6970061,slategray:7372944,slategrey:7372944,snow:16775930,springgreen:65407,steelblue:4620980,tan:13808780,teal:32896,thistle:14204888,tomato:16737095,turquoise:4251856,violet:15631086,wheat:16113331,white:16777215,whitesmoke:16119285,yellow:16776960,yellowgreen:10145074});qr.forEach(function(e,t){qr.set(e,_e(t))}),Xo.functor=ke,Xo.xhr=Pe(Me),Xo.dsv=function(e,t){function a(e,a,o){arguments.length<3&&(o=a,a=null);var r=Te(e,t,null==a?n:i(a),o);return r.row=function(e){return arguments.length?r.response(null==(a=e)?n:i(e)):a},r}function n(e){return a.parse(e.responseText);
}function i(e){return function(t){return a.parse(t.responseText,e)}}function o(t){return t.map(r).join(e)}function r(e){return s.test(e)?'"'+e.replace(/\"/g,'""')+'"':e}var s=new RegExp('["'+e+"\n]"),c=e.charCodeAt(0);return a.parse=function(e,t){var n;return a.parseRows(e,function(e,a){if(n)return n(e,a-1);var i=new Function("d","return {"+e.map(function(e,t){return JSON.stringify(e)+": d["+t+"]"}).join(",")+"}");n=t?function(e,a){return t(i(e),a)}:i})},a.parseRows=function(e,t){function a(){if(l>=d)return r;if(i)return i=!1,o;var t=l;if(34===e.charCodeAt(t)){for(var a=t;a++<d;)if(34===e.charCodeAt(a)){if(34!==e.charCodeAt(a+1))break;++a}l=a+2;var n=e.charCodeAt(a+1);return 13===n?(i=!0,10===e.charCodeAt(a+2)&&++l):10===n&&(i=!0),e.slice(t+1,a).replace(/""/g,'"')}for(;d>l;){var n=e.charCodeAt(l++),s=1;if(10===n)i=!0;else if(13===n)i=!0,10===e.charCodeAt(l)&&(++l,++s);else if(n!==c)continue;return e.slice(t,l-s)}return e.slice(t)}for(var n,i,o={},r={},s=[],d=e.length,l=0,m=0;(n=a())!==r;){for(var g=[];n!==o&&n!==r;)g.push(n),n=a();t&&null==(g=t(g,m++))||s.push(g)}return s},a.format=function(t){if(Array.isArray(t[0]))return a.formatRows(t);var n=new p,i=[];return t.forEach(function(e){for(var t in e)n.has(t)||i.push(n.add(t))}),[i.map(r).join(e)].concat(t.map(function(t){return i.map(function(e){return r(t[e])}).join(e)})).join("\n")},a.formatRows=function(e){return e.map(o).join("\n")},a},Xo.csv=Xo.dsv(",","text/csv"),Xo.tsv=Xo.dsv("	","text/tab-separated-values");var Xr,Yr,Zr,Jr,Qr,es=er[_(er,"requestAnimationFrame")]||function(e){setTimeout(e,17)};Xo.timer=function(e,t,a){var n=arguments.length;2>n&&(t=0),3>n&&(a=Date.now());var i=a+t,o={c:e,t:i,f:!1,n:null};Yr?Yr.n=o:Xr=o,Yr=o,Zr||(Jr=clearTimeout(Jr),Zr=1,es(Ge))},Xo.timer.flush=function(){Fe(),$e()},Xo.round=function(e,t){return t?Math.round(e*(t=Math.pow(10,t)))/t:Math.round(e)};var ts=["y","z","a","f","p","n","µ","m","","k","M","G","T","P","E","Z","Y"].map(Le);Xo.formatPrefix=function(e,t){var a=0;return e&&(0>e&&(e*=-1),t&&(e=Xo.round(e,Ne(e,t))),a=1+Math.floor(1e-12+Math.log(e)/Math.LN10),a=Math.max(-24,Math.min(24,3*Math.floor((a-1)/3)))),ts[8+a/3]};var as=/(?:([^{])?([<>=^]))?([+\- ])?([$#])?(0)?(\d+)?(,)?(\.-?\d+)?([a-z%])?/i,ns=Xo.map({b:function(e){return e.toString(2)},c:function(e){return String.fromCharCode(e)},o:function(e){return e.toString(8)},x:function(e){return e.toString(16)},X:function(e){return e.toString(16).toUpperCase()},g:function(e,t){return e.toPrecision(t)},e:function(e,t){return e.toExponential(t)},f:function(e,t){return e.toFixed(t)},r:function(e,t){return(e=Xo.round(e,Ne(e,t))).toFixed(Math.max(0,Math.min(20,Ne(e*(1+1e-15),t))))}}),is=Xo.time={},os=Date;Ie.prototype={getDate:function(){return this._.getUTCDate()},getDay:function(){return this._.getUTCDay()},getFullYear:function(){return this._.getUTCFullYear()},getHours:function(){return this._.getUTCHours()},getMilliseconds:function(){return this._.getUTCMilliseconds()},getMinutes:function(){return this._.getUTCMinutes()},getMonth:function(){return this._.getUTCMonth()},getSeconds:function(){return this._.getUTCSeconds()},getTime:function(){return this._.getTime()},getTimezoneOffset:function(){return 0},valueOf:function(){return this._.valueOf()},setDate:function(){rs.setUTCDate.apply(this._,arguments)},setDay:function(){rs.setUTCDay.apply(this._,arguments)},setFullYear:function(){rs.setUTCFullYear.apply(this._,arguments)},setHours:function(){rs.setUTCHours.apply(this._,arguments)},setMilliseconds:function(){rs.setUTCMilliseconds.apply(this._,arguments)},setMinutes:function(){rs.setUTCMinutes.apply(this._,arguments)},setMonth:function(){rs.setUTCMonth.apply(this._,arguments)},setSeconds:function(){rs.setUTCSeconds.apply(this._,arguments)},setTime:function(){rs.setTime.apply(this._,arguments)}};var rs=Date.prototype;is.year=He(function(e){return e=is.day(e),e.setMonth(0,1),e},function(e,t){e.setFullYear(e.getFullYear()+t)},function(e){return e.getFullYear()}),is.years=is.year.range,is.years.utc=is.year.utc.range,is.day=He(function(e){var t=new os(2e3,0);return t.setFullYear(e.getFullYear(),e.getMonth(),e.getDate()),t},function(e,t){e.setDate(e.getDate()+t)},function(e){return e.getDate()-1}),is.days=is.day.range,is.days.utc=is.day.utc.range,is.dayOfYear=function(e){var t=is.year(e);return Math.floor((e-t-6e4*(e.getTimezoneOffset()-t.getTimezoneOffset()))/864e5)},["sunday","monday","tuesday","wednesday","thursday","friday","saturday"].forEach(function(e,t){t=7-t;var a=is[e]=He(function(e){return(e=is.day(e)).setDate(e.getDate()-(e.getDay()+t)%7),e},function(e,t){e.setDate(e.getDate()+7*Math.floor(t))},function(e){var a=is.year(e).getDay();return Math.floor((is.dayOfYear(e)+(a+t)%7)/7)-(a!==t)});is[e+"s"]=a.range,is[e+"s"].utc=a.utc.range,is[e+"OfYear"]=function(e){var a=is.year(e).getDay();return Math.floor((is.dayOfYear(e)+(a+t)%7)/7)}}),is.week=is.sunday,is.weeks=is.sunday.range,is.weeks.utc=is.sunday.utc.range,is.weekOfYear=is.sundayOfYear;var ss={"-":"",_:" ",0:"0"},cs=/^\s*\d+/,ds=/^%/;Xo.locale=function(e){return{numberFormat:Ee(e),timeFormat:Oe(e)}};var ls=Xo.locale({decimal:".",thousands:",",grouping:[3],currency:["$",""],dateTime:"%a %b %e %X %Y",date:"%m/%d/%Y",time:"%H:%M:%S",periods:["AM","PM"],days:["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"],shortDays:["Sun","Mon","Tue","Wed","Thu","Fri","Sat"],months:["January","February","March","April","May","June","July","August","September","October","November","December"],shortMonths:["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"]});Xo.format=ls.numberFormat,Xo.geo={},ct.prototype={s:0,t:0,add:function(e){dt(e,this.t,ms),dt(ms.s,this.s,this),this.s?this.t+=ms.t:this.s=ms.t},reset:function(){this.s=this.t=0},valueOf:function(){return this.s}};var ms=new ct;Xo.geo.stream=function(e,t){e&&gs.hasOwnProperty(e.type)?gs[e.type](e,t):lt(e,t)};var gs={Feature:function(e,t){lt(e.geometry,t)},FeatureCollection:function(e,t){for(var a=e.features,n=-1,i=a.length;++n<i;)lt(a[n].geometry,t)}},us={Sphere:function(e,t){t.sphere()},Point:function(e,t){e=e.coordinates,t.point(e[0],e[1],e[2])},MultiPoint:function(e,t){for(var a=e.coordinates,n=-1,i=a.length;++n<i;)e=a[n],t.point(e[0],e[1],e[2])},LineString:function(e,t){mt(e.coordinates,t,0)},MultiLineString:function(e,t){for(var a=e.coordinates,n=-1,i=a.length;++n<i;)mt(a[n],t,0)},Polygon:function(e,t){gt(e.coordinates,t)},MultiPolygon:function(e,t){for(var a=e.coordinates,n=-1,i=a.length;++n<i;)gt(a[n],t)},GeometryCollection:function(e,t){for(var a=e.geometries,n=-1,i=a.length;++n<i;)lt(a[n],t)}};Xo.geo.area=function(e){return hs=0,Xo.geo.stream(e,ys),hs};var hs,ps=new ct,ys={sphere:function(){hs+=4*Pr},point:f,lineStart:f,lineEnd:f,polygonStart:function(){ps.reset(),ys.lineStart=ut},polygonEnd:function(){var e=2*ps;hs+=0>e?4*Pr+e:e,ys.lineStart=ys.lineEnd=ys.point=f}};Xo.geo.bounds=function(){function e(e,t){v.push(b=[l=e,g=e]),m>t&&(m=t),t>u&&(u=t)}function t(t,a){var n=ht([t*Fr,a*Fr]);if(_){var i=yt(_,n),o=[i[1],-i[0],0],r=yt(o,i);vt(r),r=bt(r);var c=t-h,d=c>0?1:-1,p=r[0]*$r*d,y=dr(c)>180;if(y^(p>d*h&&d*t>p)){var f=r[1]*$r;f>u&&(u=f)}else if(p=(p+360)%360-180,y^(p>d*h&&d*t>p)){var f=-r[1]*$r;m>f&&(m=f)}else m>a&&(m=a),a>u&&(u=a);y?h>t?s(l,t)>s(l,g)&&(g=t):s(t,g)>s(l,g)&&(l=t):g>=l?(l>t&&(l=t),t>g&&(g=t)):t>h?s(l,t)>s(l,g)&&(g=t):s(t,g)>s(l,g)&&(l=t)}else e(t,a);_=n,h=t}function a(){w.point=t}function n(){b[0]=l,b[1]=g,w.point=e,_=null}function i(e,a){if(_){var n=e-h;f+=dr(n)>180?n+(n>0?360:-360):n}else p=e,y=a;ys.point(e,a),t(e,a)}function o(){ys.lineStart()}function r(){i(p,y),ys.lineEnd(),dr(f)>Dr&&(l=-(g=180)),b[0]=l,b[1]=g,_=null}function s(e,t){return(t-=e)<0?t+360:t}function c(e,t){return e[0]-t[0]}function d(e,t){return t[0]<=t[1]?t[0]<=e&&e<=t[1]:e<t[0]||t[1]<e}var l,m,g,u,h,p,y,_,f,v,b,w={point:e,lineStart:a,lineEnd:n,polygonStart:function(){w.point=i,w.lineStart=o,w.lineEnd=r,f=0,ys.polygonStart()},polygonEnd:function(){ys.polygonEnd(),w.point=e,w.lineStart=a,w.lineEnd=n,0>ps?(l=-(g=180),m=-(u=90)):f>Dr?u=90:-Dr>f&&(m=-90),b[0]=l,b[1]=g}};return function(e){u=g=-(l=m=1/0),v=[],Xo.geo.stream(e,w);var t=v.length;if(t){v.sort(c);for(var a,n=1,i=v[0],o=[i];t>n;++n)a=v[n],d(a[0],i)||d(a[1],i)?(s(i[0],a[1])>s(i[0],i[1])&&(i[1]=a[1]),s(a[0],i[1])>s(i[0],i[1])&&(i[0]=a[0])):o.push(i=a);for(var r,a,h=-(1/0),t=o.length-1,n=0,i=o[t];t>=n;i=a,++n)a=o[n],(r=s(i[1],a[0]))>h&&(h=r,l=a[0],g=i[1])}return v=b=null,l===1/0||m===1/0?[[NaN,NaN],[NaN,NaN]]:[[l,m],[g,u]]}}(),Xo.geo.centroid=function(e){_s=fs=vs=bs=ws=Ss=Cs=xs=ks=Ms=Ps=0,Xo.geo.stream(e,Ts);var t=ks,a=Ms,n=Ps,i=t*t+a*a+n*n;return Gr>i&&(t=Ss,a=Cs,n=xs,Dr>fs&&(t=vs,a=bs,n=ws),i=t*t+a*a+n*n,Gr>i)?[NaN,NaN]:[Math.atan2(a,t)*$r,ee(n/Math.sqrt(i))*$r]};var _s,fs,vs,bs,ws,Ss,Cs,xs,ks,Ms,Ps,Ts={sphere:f,point:St,lineStart:xt,lineEnd:kt,polygonStart:function(){Ts.lineStart=Mt},polygonEnd:function(){Ts.lineStart=xt}},As=Gt(Pt,Lt,Rt,[-Pr,-Pr/2]),Ds=1e9;Xo.geo.clipExtent=function(){var e,t,a,n,i,o,r={stream:function(e){return i&&(i.valid=!1),i=o(e),i.valid=!0,i},extent:function(s){return arguments.length?(o=Ot(e=+s[0][0],t=+s[0][1],a=+s[1][0],n=+s[1][1]),i&&(i.valid=!1,i=null),r):[[e,t],[a,n]]}};return r.extent([[0,0],[960,500]])},(Xo.geo.conicEqualArea=function(){return Vt(Wt)}).raw=Wt,Xo.geo.albers=function(){return Xo.geo.conicEqualArea().rotate([96,0]).center([-.6,38.7]).parallels([29.5,45.5]).scale(1070)},Xo.geo.albersUsa=function(){function e(e){var o=e[0],r=e[1];return t=null,a(o,r),t||(n(o,r),t)||i(o,r),t}var t,a,n,i,o=Xo.geo.albers(),r=Xo.geo.conicEqualArea().rotate([154,0]).center([-2,58.5]).parallels([55,65]),s=Xo.geo.conicEqualArea().rotate([157,0]).center([-3,19.9]).parallels([8,18]),c={point:function(e,a){t=[e,a]}};return e.invert=function(e){var t=o.scale(),a=o.translate(),n=(e[0]-a[0])/t,i=(e[1]-a[1])/t;return(i>=.12&&.234>i&&n>=-.425&&-.214>n?r:i>=.166&&.234>i&&n>=-.214&&-.115>n?s:o).invert(e)},e.stream=function(e){var t=o.stream(e),a=r.stream(e),n=s.stream(e);return{point:function(e,i){t.point(e,i),a.point(e,i),n.point(e,i)},sphere:function(){t.sphere(),a.sphere(),n.sphere()},lineStart:function(){t.lineStart(),a.lineStart(),n.lineStart()},lineEnd:function(){t.lineEnd(),a.lineEnd(),n.lineEnd()},polygonStart:function(){t.polygonStart(),a.polygonStart(),n.polygonStart()},polygonEnd:function(){t.polygonEnd(),a.polygonEnd(),n.polygonEnd()}}},e.precision=function(t){return arguments.length?(o.precision(t),r.precision(t),s.precision(t),e):o.precision()},e.scale=function(t){return arguments.length?(o.scale(t),r.scale(.35*t),s.scale(t),e.translate(o.translate())):o.scale()},e.translate=function(t){if(!arguments.length)return o.translate();var d=o.scale(),l=+t[0],m=+t[1];return a=o.translate(t).clipExtent([[l-.455*d,m-.238*d],[l+.455*d,m+.238*d]]).stream(c).point,n=r.translate([l-.307*d,m+.201*d]).clipExtent([[l-.425*d+Dr,m+.12*d+Dr],[l-.214*d-Dr,m+.234*d-Dr]]).stream(c).point,i=s.translate([l-.205*d,m+.212*d]).clipExtent([[l-.214*d+Dr,m+.166*d+Dr],[l-.115*d-Dr,m+.234*d-Dr]]).stream(c).point,e},e.scale(1070)};var Gs,Fs,$s,Ns,Ls,Es,Rs={point:f,lineStart:f,lineEnd:f,polygonStart:function(){Fs=0,Rs.lineStart=zt},polygonEnd:function(){Rs.lineStart=Rs.lineEnd=Rs.point=f,Gs+=dr(Fs/2)}},Is={point:Kt,lineStart:f,lineEnd:f,polygonStart:f,polygonEnd:f},Hs={point:Xt,lineStart:Yt,lineEnd:Zt,polygonStart:function(){Hs.lineStart=Jt},polygonEnd:function(){Hs.point=Xt,Hs.lineStart=Yt,Hs.lineEnd=Zt}};Xo.geo.path=function(){function e(e){return e&&("function"==typeof s&&o.pointRadius(+s.apply(this,arguments)),r&&r.valid||(r=i(o)),Xo.geo.stream(e,r)),o.result()}function t(){return r=null,e}var a,n,i,o,r,s=4.5;return e.area=function(e){return Gs=0,Xo.geo.stream(e,i(Rs)),Gs},e.centroid=function(e){return vs=bs=ws=Ss=Cs=xs=ks=Ms=Ps=0,Xo.geo.stream(e,i(Hs)),Ps?[ks/Ps,Ms/Ps]:xs?[Ss/xs,Cs/xs]:ws?[vs/ws,bs/ws]:[NaN,NaN]},e.bounds=function(e){return Ls=Es=-($s=Ns=1/0),Xo.geo.stream(e,i(Is)),[[$s,Ns],[Ls,Es]]},e.projection=function(e){return arguments.length?(i=(a=e)?e.stream||ta(e):Me,t()):a},e.context=function(e){return arguments.length?(o=null==(n=e)?new jt:new Qt(e),"function"!=typeof s&&o.pointRadius(s),t()):n},e.pointRadius=function(t){return arguments.length?(s="function"==typeof t?t:(o.pointRadius(+t),+t),e):s},e.projection(Xo.geo.albersUsa()).context(null)},Xo.geo.transform=function(e){return{stream:function(t){var a=new aa(t);for(var n in e)a[n]=e[n];return a}}},aa.prototype={point:function(e,t){this.stream.point(e,t)},sphere:function(){this.stream.sphere()},lineStart:function(){this.stream.lineStart()},lineEnd:function(){this.stream.lineEnd()},polygonStart:function(){this.stream.polygonStart()},polygonEnd:function(){this.stream.polygonEnd()}},Xo.geo.projection=ia,Xo.geo.projectionMutator=oa,(Xo.geo.equirectangular=function(){return ia(sa)}).raw=sa.invert=sa,Xo.geo.rotation=function(e){function t(t){return t=e(t[0]*Fr,t[1]*Fr),t[0]*=$r,t[1]*=$r,t}return e=da(e[0]%360*Fr,e[1]*Fr,e.length>2?e[2]*Fr:0),t.invert=function(t){return t=e.invert(t[0]*Fr,t[1]*Fr),t[0]*=$r,t[1]*=$r,t},t},ca.invert=sa,Xo.geo.circle=function(){function e(){var e="function"==typeof n?n.apply(this,arguments):n,t=da(-e[0]*Fr,-e[1]*Fr,0).invert,i=[];return a(null,null,1,{point:function(e,a){i.push(e=t(e,a)),e[0]*=$r,e[1]*=$r}}),{type:"Polygon",coordinates:[i]}}var t,a,n=[0,0],i=6;return e.origin=function(t){return arguments.length?(n=t,e):n},e.angle=function(n){return arguments.length?(a=ua((t=+n)*Fr,i*Fr),e):t},e.precision=function(n){return arguments.length?(a=ua(t*Fr,(i=+n)*Fr),e):i},e.angle(90)},Xo.geo.distance=function(e,t){var a,n=(t[0]-e[0])*Fr,i=e[1]*Fr,o=t[1]*Fr,r=Math.sin(n),s=Math.cos(n),c=Math.sin(i),d=Math.cos(i),l=Math.sin(o),m=Math.cos(o);return Math.atan2(Math.sqrt((a=m*r)*a+(a=d*l-c*m*s)*a),c*l+d*m*s)},Xo.geo.graticule=function(){function e(){return{type:"MultiLineString",coordinates:t()}}function t(){return Xo.range(Math.ceil(o/y)*y,i,y).map(g).concat(Xo.range(Math.ceil(d/_)*_,c,_).map(u)).concat(Xo.range(Math.ceil(n/h)*h,a,h).filter(function(e){return dr(e%y)>Dr}).map(l)).concat(Xo.range(Math.ceil(s/p)*p,r,p).filter(function(e){return dr(e%_)>Dr}).map(m))}var a,n,i,o,r,s,c,d,l,m,g,u,h=10,p=h,y=90,_=360,f=2.5;return e.lines=function(){return t().map(function(e){return{type:"LineString",coordinates:e}})},e.outline=function(){return{type:"Polygon",coordinates:[g(o).concat(u(c).slice(1),g(i).reverse().slice(1),u(d).reverse().slice(1))]}},e.extent=function(t){return arguments.length?e.majorExtent(t).minorExtent(t):e.minorExtent()},e.majorExtent=function(t){return arguments.length?(o=+t[0][0],i=+t[1][0],d=+t[0][1],c=+t[1][1],o>i&&(t=o,o=i,i=t),d>c&&(t=d,d=c,c=t),e.precision(f)):[[o,d],[i,c]]},e.minorExtent=function(t){return arguments.length?(n=+t[0][0],a=+t[1][0],s=+t[0][1],r=+t[1][1],n>a&&(t=n,n=a,a=t),s>r&&(t=s,s=r,r=t),e.precision(f)):[[n,s],[a,r]]},e.step=function(t){return arguments.length?e.majorStep(t).minorStep(t):e.minorStep()},e.majorStep=function(t){return arguments.length?(y=+t[0],_=+t[1],e):[y,_]},e.minorStep=function(t){return arguments.length?(h=+t[0],p=+t[1],e):[h,p]},e.precision=function(t){return arguments.length?(f=+t,l=pa(s,r,90),m=ya(n,a,f),g=pa(d,c,90),u=ya(o,i,f),e):f},e.majorExtent([[-180,-90+Dr],[180,90-Dr]]).minorExtent([[-180,-80-Dr],[180,80+Dr]])},Xo.geo.greatArc=function(){function e(){return{type:"LineString",coordinates:[t||n.apply(this,arguments),a||i.apply(this,arguments)]}}var t,a,n=_a,i=fa;return e.distance=function(){return Xo.geo.distance(t||n.apply(this,arguments),a||i.apply(this,arguments))},e.source=function(a){return arguments.length?(n=a,t="function"==typeof a?null:a,e):n},e.target=function(t){return arguments.length?(i=t,a="function"==typeof t?null:t,e):i},e.precision=function(){return arguments.length?e:0},e},Xo.geo.interpolate=function(e,t){return va(e[0]*Fr,e[1]*Fr,t[0]*Fr,t[1]*Fr)},Xo.geo.length=function(e){return Bs=0,Xo.geo.stream(e,Os),Bs};var Bs,Os={sphere:f,point:f,lineStart:ba,lineEnd:f,polygonStart:f,polygonEnd:f},Us=wa(function(e){return Math.sqrt(2/(1+e))},function(e){return 2*Math.asin(e/2)});(Xo.geo.azimuthalEqualArea=function(){return ia(Us)}).raw=Us;var Vs=wa(function(e){var t=Math.acos(e);return t&&t/Math.sin(t)},Me);(Xo.geo.azimuthalEquidistant=function(){return ia(Vs)}).raw=Vs,(Xo.geo.conicConformal=function(){return Vt(Sa)}).raw=Sa,(Xo.geo.conicEquidistant=function(){return Vt(Ca)}).raw=Ca;var Ws=wa(function(e){return 1/e},Math.atan);(Xo.geo.gnomonic=function(){return ia(Ws)}).raw=Ws,xa.invert=function(e,t){return[e,2*Math.atan(Math.exp(t))-Ar]},(Xo.geo.mercator=function(){return ka(xa)}).raw=xa;var zs=wa(function(){return 1},Math.asin);(Xo.geo.orthographic=function(){return ia(zs)}).raw=zs;var Ks=wa(function(e){return 1/(1+e)},function(e){return 2*Math.atan(e)});(Xo.geo.stereographic=function(){return ia(Ks)}).raw=Ks,Ma.invert=function(e,t){return[-t,2*Math.atan(Math.exp(e))-Ar]},(Xo.geo.transverseMercator=function(){var e=ka(Ma),t=e.center,a=e.rotate;return e.center=function(e){return e?t([-e[1],e[0]]):(e=t(),[e[1],-e[0]])},e.rotate=function(e){return e?a([e[0],e[1],e.length>2?e[2]+90:90]):(e=a(),[e[0],e[1],e[2]-90])},a([0,0,90])}).raw=Ma,Xo.geom={},Xo.geom.hull=function(e){function t(e){if(e.length<3)return[];var t,i=ke(a),o=ke(n),r=e.length,s=[],c=[];for(t=0;r>t;t++)s.push([+i.call(this,e[t],t),+o.call(this,e[t],t),t]);for(s.sort(Da),t=0;r>t;t++)c.push([s[t][0],-s[t][1]]);var d=Aa(s),l=Aa(c),m=l[0]===d[0],g=l[l.length-1]===d[d.length-1],u=[];for(t=d.length-1;t>=0;--t)u.push(e[s[d[t]][2]]);for(t=+m;t<l.length-g;++t)u.push(e[s[l[t]][2]]);return u}var a=Pa,n=Ta;return arguments.length?t(e):(t.x=function(e){return arguments.length?(a=e,t):a},t.y=function(e){return arguments.length?(n=e,t):n},t)},Xo.geom.polygon=function(e){return hr(e,js),e};var js=Xo.geom.polygon.prototype=[];js.area=function(){for(var e,t=-1,a=this.length,n=this[a-1],i=0;++t<a;)e=n,n=this[t],i+=e[1]*n[0]-e[0]*n[1];return.5*i},js.centroid=function(e){var t,a,n=-1,i=this.length,o=0,r=0,s=this[i-1];for(arguments.length||(e=-1/(6*this.area()));++n<i;)t=s,s=this[n],a=t[0]*s[1]-s[0]*t[1],o+=(t[0]+s[0])*a,r+=(t[1]+s[1])*a;return[o*e,r*e]},js.clip=function(e){for(var t,a,n,i,o,r,s=$a(e),c=-1,d=this.length-$a(this),l=this[d-1];++c<d;){for(t=e.slice(),e.length=0,i=this[c],o=t[(n=t.length-s)-1],a=-1;++a<n;)r=t[a],Ga(r,l,i)?(Ga(o,l,i)||e.push(Fa(o,r,l,i)),e.push(r)):Ga(o,l,i)&&e.push(Fa(o,r,l,i)),o=r;s&&e.push(e[0]),l=i}return e};var qs,Xs,Ys,Zs,Js,Qs=[],ec=[];Oa.prototype.prepare=function(){for(var e,t=this.edges,a=t.length;a--;)e=t[a].edge,e.b&&e.a||t.splice(a,1);return t.sort(Va),t.length},Qa.prototype={start:function(){return this.edge.l===this.site?this.edge.a:this.edge.b},end:function(){return this.edge.l===this.site?this.edge.b:this.edge.a}},en.prototype={insert:function(e,t){var a,n,i;if(e){if(t.P=e,t.N=e.N,e.N&&(e.N.P=t),e.N=t,e.R){for(e=e.R;e.L;)e=e.L;e.L=t}else e.R=t;a=e}else this._?(e=on(this._),t.P=null,t.N=e,e.P=e.L=t,a=e):(t.P=t.N=null,this._=t,a=null);for(t.L=t.R=null,t.U=a,t.C=!0,e=t;a&&a.C;)n=a.U,a===n.L?(i=n.R,i&&i.C?(a.C=i.C=!1,n.C=!0,e=n):(e===a.R&&(an(this,a),e=a,a=e.U),a.C=!1,n.C=!0,nn(this,n))):(i=n.L,i&&i.C?(a.C=i.C=!1,n.C=!0,e=n):(e===a.L&&(nn(this,a),e=a,a=e.U),a.C=!1,n.C=!0,an(this,n))),a=e.U;this._.C=!1},remove:function(e){e.N&&(e.N.P=e.P),e.P&&(e.P.N=e.N),e.N=e.P=null;var t,a,n,i=e.U,o=e.L,r=e.R;if(a=o?r?on(r):o:r,i?i.L===e?i.L=a:i.R=a:this._=a,o&&r?(n=a.C,a.C=e.C,a.L=o,o.U=a,a!==r?(i=a.U,a.U=e.U,e=a.R,i.L=e,a.R=r,r.U=a):(a.U=i,i=a,e=a.R)):(n=e.C,e=a),e&&(e.U=i),!n){if(e&&e.C)return void(e.C=!1);do{if(e===this._)break;if(e===i.L){if(t=i.R,t.C&&(t.C=!1,i.C=!0,an(this,i),t=i.R),t.L&&t.L.C||t.R&&t.R.C){t.R&&t.R.C||(t.L.C=!1,t.C=!0,nn(this,t),t=i.R),t.C=i.C,i.C=t.R.C=!1,an(this,i),e=this._;break}}else if(t=i.L,t.C&&(t.C=!1,i.C=!0,nn(this,i),t=i.L),t.L&&t.L.C||t.R&&t.R.C){t.L&&t.L.C||(t.R.C=!1,t.C=!0,an(this,t),t=i.L),t.C=i.C,i.C=t.L.C=!1,nn(this,i),e=this._;break}t.C=!0,e=i,i=i.U}while(!e.C);e&&(e.C=!1)}}},Xo.geom.voronoi=function(e){function t(e){var t=new Array(e.length),n=s[0][0],i=s[0][1],o=s[1][0],r=s[1][1];return rn(a(e),s).cells.forEach(function(a,s){var c=a.edges,d=a.site,l=t[s]=c.length?c.map(function(e){var t=e.start();return[t.x,t.y]}):d.x>=n&&d.x<=o&&d.y>=i&&d.y<=r?[[n,r],[o,r],[o,i],[n,i]]:[];l.point=e[s]}),t}function a(e){return e.map(function(e,t){return{x:Math.round(o(e,t)/Dr)*Dr,y:Math.round(r(e,t)/Dr)*Dr,i:t}})}var n=Pa,i=Ta,o=n,r=i,s=tc;return e?t(e):(t.links=function(e){return rn(a(e)).edges.filter(function(e){return e.l&&e.r}).map(function(t){return{source:e[t.l.i],target:e[t.r.i]}})},t.triangles=function(e){var t=[];return rn(a(e)).cells.forEach(function(a,n){for(var i,o,r=a.site,s=a.edges.sort(Va),c=-1,d=s.length,l=s[d-1].edge,m=l.l===r?l.r:l.l;++c<d;)i=l,o=m,l=s[c].edge,m=l.l===r?l.r:l.l,n<o.i&&n<m.i&&cn(r,o,m)<0&&t.push([e[n],e[o.i],e[m.i]])}),t},t.x=function(e){return arguments.length?(o=ke(n=e),t):n},t.y=function(e){return arguments.length?(r=ke(i=e),t):i},t.clipExtent=function(e){return arguments.length?(s=null==e?tc:e,t):s===tc?null:s},t.size=function(e){return arguments.length?t.clipExtent(e&&[[0,0],e]):s===tc?null:s&&s[1]},t)};var tc=[[-1e6,-1e6],[1e6,1e6]];Xo.geom.delaunay=function(e){return Xo.geom.voronoi().triangles(e)},Xo.geom.quadtree=function(e,t,a,n,i){function o(e){function o(e,t,a,n,i,o,r,s){if(!isNaN(a)&&!isNaN(n))if(e.leaf){var c=e.x,l=e.y;if(null!=c)if(dr(c-a)+dr(l-n)<.01)d(e,t,a,n,i,o,r,s);else{var m=e.point;e.x=e.y=e.point=null,d(e,m,c,l,i,o,r,s),d(e,t,a,n,i,o,r,s)}else e.x=a,e.y=n,e.point=t}else d(e,t,a,n,i,o,r,s)}function d(e,t,a,n,i,r,s,c){var d=.5*(i+s),l=.5*(r+c),m=a>=d,g=n>=l,u=(g<<1)+m;e.leaf=!1,e=e.nodes[u]||(e.nodes[u]=mn()),m?i=d:s=d,g?r=l:c=l,o(e,t,a,n,i,r,s,c)}var l,m,g,u,h,p,y,_,f,v=ke(s),b=ke(c);if(null!=t)p=t,y=a,_=n,f=i;else if(_=f=-(p=y=1/0),m=[],g=[],h=e.length,r)for(u=0;h>u;++u)l=e[u],l.x<p&&(p=l.x),l.y<y&&(y=l.y),l.x>_&&(_=l.x),l.y>f&&(f=l.y),m.push(l.x),g.push(l.y);else for(u=0;h>u;++u){var w=+v(l=e[u],u),S=+b(l,u);p>w&&(p=w),y>S&&(y=S),w>_&&(_=w),S>f&&(f=S),m.push(w),g.push(S)}var C=_-p,x=f-y;C>x?f=y+C:_=p+x;var k=mn();if(k.add=function(e){o(k,e,+v(e,++u),+b(e,u),p,y,_,f)},k.visit=function(e){gn(e,k,p,y,_,f)},u=-1,null==t){for(;++u<h;)o(k,e[u],m[u],g[u],p,y,_,f);--u}else e.forEach(k.add);return m=g=e=l=null,k}var r,s=Pa,c=Ta;return(r=arguments.length)?(s=dn,c=ln,3===r&&(i=a,n=t,a=t=0),o(e)):(o.x=function(e){return arguments.length?(s=e,o):s},o.y=function(e){return arguments.length?(c=e,o):c},o.extent=function(e){return arguments.length?(null==e?t=a=n=i=null:(t=+e[0][0],a=+e[0][1],n=+e[1][0],i=+e[1][1]),o):null==t?null:[[t,a],[n,i]]},o.size=function(e){return arguments.length?(null==e?t=a=n=i=null:(t=a=0,n=+e[0],i=+e[1]),o):null==t?null:[n-t,i-a]},o)},Xo.interpolateRgb=un,Xo.interpolateObject=hn,Xo.interpolateNumber=pn,Xo.interpolateString=yn;var ac=/[-+]?(?:\d+\.?\d*|\.?\d+)(?:[eE][-+]?\d+)?/g,nc=new RegExp(ac.source,"g");Xo.interpolate=_n,Xo.interpolators=[function(e,t){var a=typeof t;return("string"===a?qr.has(t)||/^(#|rgb\(|hsl\()/.test(t)?un:yn:t instanceof oe?un:Array.isArray(t)?fn:"object"===a&&isNaN(t)?hn:pn)(e,t)}],Xo.interpolateArray=fn;var ic=function(){return Me},oc=Xo.map({linear:ic,poly:kn,quad:function(){return Sn},cubic:function(){return Cn},sin:function(){return Mn},exp:function(){return Pn},circle:function(){return Tn},elastic:An,back:Dn,bounce:function(){return Gn}}),rc=Xo.map({"in":Me,out:bn,"in-out":wn,"out-in":function(e){return wn(bn(e))}});Xo.ease=function(e){var t=e.indexOf("-"),a=t>=0?e.slice(0,t):e,n=t>=0?e.slice(t+1):"in";return a=oc.get(a)||ic,n=rc.get(n)||Me,vn(n(a.apply(null,Yo.call(arguments,1))))},Xo.interpolateHcl=Fn,Xo.interpolateHsl=$n,Xo.interpolateLab=Nn,Xo.interpolateRound=Ln,Xo.transform=function(e){var t=Jo.createElementNS(Xo.ns.prefix.svg,"g");return(Xo.transform=function(e){if(null!=e){t.setAttribute("transform",e);var a=t.transform.baseVal.consolidate()}return new En(a?a.matrix:sc)})(e)},En.prototype.toString=function(){return"translate("+this.translate+")rotate("+this.rotate+")skewX("+this.skew+")scale("+this.scale+")"};var sc={a:1,b:0,c:0,d:1,e:0,f:0};Xo.interpolateTransform=Bn,Xo.layout={},Xo.layout.bundle=function(){return function(e){for(var t=[],a=-1,n=e.length;++a<n;)t.push(Vn(e[a]));return t}},Xo.layout.chord=function(){function e(){var e,d,m,g,u,h={},p=[],y=Xo.range(o),_=[];for(a=[],n=[],e=0,g=-1;++g<o;){for(d=0,u=-1;++u<o;)d+=i[g][u];p.push(d),_.push(Xo.range(o)),e+=d}for(r&&y.sort(function(e,t){return r(p[e],p[t])}),s&&_.forEach(function(e,t){e.sort(function(e,a){return s(i[t][e],i[t][a])})}),e=(Tr-l*o)/e,d=0,g=-1;++g<o;){for(m=d,u=-1;++u<o;){var f=y[g],v=_[f][u],b=i[f][v],w=d,S=d+=b*e;h[f+"-"+v]={index:f,subindex:v,startAngle:w,endAngle:S,value:b}}n[f]={index:f,startAngle:m,endAngle:d,value:(d-m)/e},d+=l}for(g=-1;++g<o;)for(u=g-1;++u<o;){var C=h[g+"-"+u],x=h[u+"-"+g];(C.value||x.value)&&a.push(C.value<x.value?{source:x,target:C}:{source:C,target:x})}c&&t()}function t(){a.sort(function(e,t){return c((e.source.value+e.target.value)/2,(t.source.value+t.target.value)/2)})}var a,n,i,o,r,s,c,d={},l=0;return d.matrix=function(e){return arguments.length?(o=(i=e)&&i.length,a=n=null,d):i},d.padding=function(e){return arguments.length?(l=e,a=n=null,d):l},d.sortGroups=function(e){return arguments.length?(r=e,a=n=null,d):r},d.sortSubgroups=function(e){return arguments.length?(s=e,a=null,d):s},d.sortChords=function(e){return arguments.length?(c=e,a&&t(),d):c},d.chords=function(){return a||e(),a},d.groups=function(){return n||e(),n},d},Xo.layout.force=function(){function e(e){return function(t,a,n,i){if(t.point!==e){var o=t.cx-e.x,r=t.cy-e.y,s=i-a,c=o*o+r*r;if(c>s*s/y){if(h>c){var d=t.charge/c;e.px-=o*d,e.py-=r*d}return!0}if(t.point&&c&&h>c){var d=t.pointCharge/c;e.px-=o*d,e.py-=r*d}}return!t.charge}}function t(e){e.px=Xo.event.x,e.py=Xo.event.y,s.resume()}var a,n,i,o,r,s={},c=Xo.dispatch("start","tick","end"),d=[1,1],l=.9,m=cc,g=dc,u=-30,h=lc,p=.1,y=.64,_=[],f=[];return s.tick=function(){if((n*=.99)<.005)return c.end({type:"end",alpha:n=0}),!0;var t,a,s,m,g,h,y,v,b,w=_.length,S=f.length;for(a=0;S>a;++a)s=f[a],m=s.source,g=s.target,v=g.x-m.x,b=g.y-m.y,(h=v*v+b*b)&&(h=n*o[a]*((h=Math.sqrt(h))-i[a])/h,v*=h,b*=h,g.x-=v*(y=m.weight/(g.weight+m.weight)),g.y-=b*y,m.x+=v*(y=1-y),m.y+=b*y);if((y=n*p)&&(v=d[0]/2,b=d[1]/2,a=-1,y))for(;++a<w;)s=_[a],s.x+=(v-s.x)*y,s.y+=(b-s.y)*y;if(u)for(Yn(t=Xo.geom.quadtree(_),n,r),a=-1;++a<w;)(s=_[a]).fixed||t.visit(e(s));for(a=-1;++a<w;)s=_[a],s.fixed?(s.x=s.px,s.y=s.py):(s.x-=(s.px-(s.px=s.x))*l,s.y-=(s.py-(s.py=s.y))*l);c.tick({type:"tick",alpha:n})},s.nodes=function(e){return arguments.length?(_=e,s):_},s.links=function(e){return arguments.length?(f=e,s):f},s.size=function(e){return arguments.length?(d=e,s):d},s.linkDistance=function(e){return arguments.length?(m="function"==typeof e?e:+e,s):m},s.distance=s.linkDistance,s.linkStrength=function(e){return arguments.length?(g="function"==typeof e?e:+e,s):g},s.friction=function(e){return arguments.length?(l=+e,s):l},s.charge=function(e){return arguments.length?(u="function"==typeof e?e:+e,s):u},s.chargeDistance=function(e){return arguments.length?(h=e*e,s):Math.sqrt(h)},s.gravity=function(e){return arguments.length?(p=+e,s):p},s.theta=function(e){return arguments.length?(y=e*e,s):Math.sqrt(y)},s.alpha=function(e){return arguments.length?(e=+e,n?n=e>0?e:0:e>0&&(c.start({type:"start",alpha:n=e}),Xo.timer(s.tick)),s):n},s.start=function(){function e(e,n){if(!a){for(a=new Array(c),s=0;c>s;++s)a[s]=[];for(s=0;d>s;++s){var i=f[s];a[i.source.index].push(i.target),a[i.target.index].push(i.source)}}for(var o,r=a[t],s=-1,d=r.length;++s<d;)if(!isNaN(o=r[s][e]))return o;return Math.random()*n}var t,a,n,c=_.length,l=f.length,h=d[0],p=d[1];for(t=0;c>t;++t)(n=_[t]).index=t,n.weight=0;for(t=0;l>t;++t)n=f[t],"number"==typeof n.source&&(n.source=_[n.source]),"number"==typeof n.target&&(n.target=_[n.target]),++n.source.weight,++n.target.weight;for(t=0;c>t;++t)n=_[t],isNaN(n.x)&&(n.x=e("x",h)),isNaN(n.y)&&(n.y=e("y",p)),isNaN(n.px)&&(n.px=n.x),isNaN(n.py)&&(n.py=n.y);if(i=[],"function"==typeof m)for(t=0;l>t;++t)i[t]=+m.call(this,f[t],t);else for(t=0;l>t;++t)i[t]=m;if(o=[],"function"==typeof g)for(t=0;l>t;++t)o[t]=+g.call(this,f[t],t);else for(t=0;l>t;++t)o[t]=g;if(r=[],"function"==typeof u)for(t=0;c>t;++t)r[t]=+u.call(this,_[t],t);else for(t=0;c>t;++t)r[t]=u;return s.resume()},s.resume=function(){return s.alpha(.1)},s.stop=function(){return s.alpha(0)},s.drag=function(){return a||(a=Xo.behavior.drag().origin(Me).on("dragstart.force",Kn).on("drag.force",t).on("dragend.force",jn)),arguments.length?void this.on("mouseover.force",qn).on("mouseout.force",Xn).call(a):a},Xo.rebind(s,c,"on")};var cc=20,dc=1,lc=1/0;Xo.layout.hierarchy=function(){function e(i){var o,r=[i],s=[];for(i.depth=0;null!=(o=r.pop());)if(s.push(o),(d=a.call(e,o,o.depth))&&(c=d.length)){for(var c,d,l;--c>=0;)r.push(l=d[c]),l.parent=o,l.depth=o.depth+1;n&&(o.value=0),o.children=d}else n&&(o.value=+n.call(e,o,o.depth)||0),delete o.children;return Qn(i,function(e){var a,i;t&&(a=e.children)&&a.sort(t),n&&(i=e.parent)&&(i.value+=e.value)}),s}var t=ai,a=ei,n=ti;return e.sort=function(a){return arguments.length?(t=a,e):t},e.children=function(t){return arguments.length?(a=t,e):a},e.value=function(t){return arguments.length?(n=t,e):n},e.revalue=function(t){return n&&(Jn(t,function(e){e.children&&(e.value=0)}),Qn(t,function(t){var a;t.children||(t.value=+n.call(e,t,t.depth)||0),(a=t.parent)&&(a.value+=t.value)})),t},e},Xo.layout.partition=function(){function e(t,a,n,i){var o=t.children;if(t.x=a,t.y=t.depth*i,t.dx=n,t.dy=i,o&&(r=o.length)){var r,s,c,d=-1;for(n=t.value?n/t.value:0;++d<r;)e(s=o[d],a,c=s.value*n,i),a+=c}}function t(e){var a=e.children,n=0;if(a&&(i=a.length))for(var i,o=-1;++o<i;)n=Math.max(n,t(a[o]));return 1+n}function a(a,o){var r=n.call(this,a,o);return e(r[0],0,i[0],i[1]/t(r[0])),r}var n=Xo.layout.hierarchy(),i=[1,1];return a.size=function(e){return arguments.length?(i=e,a):i},Zn(a,n)},Xo.layout.pie=function(){function e(o){var r=o.map(function(a,n){return+t.call(e,a,n)}),s=+("function"==typeof n?n.apply(this,arguments):n),c=(("function"==typeof i?i.apply(this,arguments):i)-s)/Xo.sum(r),d=Xo.range(o.length);null!=a&&d.sort(a===mc?function(e,t){return r[t]-r[e]}:function(e,t){return a(o[e],o[t])});var l=[];return d.forEach(function(e){var t;l[e]={data:o[e],value:t=r[e],startAngle:s,endAngle:s+=t*c}}),l}var t=Number,a=mc,n=0,i=Tr;return e.value=function(a){return arguments.length?(t=a,e):t},e.sort=function(t){return arguments.length?(a=t,e):a},e.startAngle=function(t){return arguments.length?(n=t,e):n},e.endAngle=function(t){return arguments.length?(i=t,e):i},e};var mc={};Xo.layout.stack=function(){function e(s,c){if(!(g=s.length))return s;var d=s.map(function(a,n){return t.call(e,a,n)}),l=d.map(function(t){return t.map(function(t,a){return[o.call(e,t,a),r.call(e,t,a)]})}),m=a.call(e,l,c);d=Xo.permute(d,m),l=Xo.permute(l,m);var g,u,h,p,y=n.call(e,l,c),_=d[0].length;for(h=0;_>h;++h)for(i.call(e,d[0][h],p=y[h],l[0][h][1]),u=1;g>u;++u)i.call(e,d[u][h],p+=l[u-1][h][1],l[u][h][1]);return s}var t=Me,a=si,n=ci,i=ri,o=ii,r=oi;return e.values=function(a){return arguments.length?(t=a,e):t},e.order=function(t){return arguments.length?(a="function"==typeof t?t:gc.get(t)||si,e):a},e.offset=function(t){return arguments.length?(n="function"==typeof t?t:uc.get(t)||ci,e):n},e.x=function(t){return arguments.length?(o=t,e):o},e.y=function(t){return arguments.length?(r=t,e):r},e.out=function(t){return arguments.length?(i=t,e):i},e};var gc=Xo.map({"inside-out":function(e){var t,a,n=e.length,i=e.map(di),o=e.map(li),r=Xo.range(n).sort(function(e,t){return i[e]-i[t]}),s=0,c=0,d=[],l=[];for(t=0;n>t;++t)a=r[t],c>s?(s+=o[a],d.push(a)):(c+=o[a],l.push(a));return l.reverse().concat(d)},reverse:function(e){return Xo.range(e.length).reverse()},"default":si}),uc=Xo.map({silhouette:function(e){var t,a,n,i=e.length,o=e[0].length,r=[],s=0,c=[];for(a=0;o>a;++a){for(t=0,n=0;i>t;t++)n+=e[t][a][1];n>s&&(s=n),r.push(n)}for(a=0;o>a;++a)c[a]=(s-r[a])/2;return c;
},wiggle:function(e){var t,a,n,i,o,r,s,c,d,l=e.length,m=e[0],g=m.length,u=[];for(u[0]=c=d=0,a=1;g>a;++a){for(t=0,i=0;l>t;++t)i+=e[t][a][1];for(t=0,o=0,s=m[a][0]-m[a-1][0];l>t;++t){for(n=0,r=(e[t][a][1]-e[t][a-1][1])/(2*s);t>n;++n)r+=(e[n][a][1]-e[n][a-1][1])/s;o+=r*e[t][a][1]}u[a]=c-=i?o/i*s:0,d>c&&(d=c)}for(a=0;g>a;++a)u[a]-=d;return u},expand:function(e){var t,a,n,i=e.length,o=e[0].length,r=1/i,s=[];for(a=0;o>a;++a){for(t=0,n=0;i>t;t++)n+=e[t][a][1];if(n)for(t=0;i>t;t++)e[t][a][1]/=n;else for(t=0;i>t;t++)e[t][a][1]=r}for(a=0;o>a;++a)s[a]=0;return s},zero:ci});Xo.layout.histogram=function(){function e(e,o){for(var r,s,c=[],d=e.map(a,this),l=n.call(this,d,o),m=i.call(this,l,d,o),o=-1,g=d.length,u=m.length-1,h=t?1:1/g;++o<u;)r=c[o]=[],r.dx=m[o+1]-(r.x=m[o]),r.y=0;if(u>0)for(o=-1;++o<g;)s=d[o],s>=l[0]&&s<=l[1]&&(r=c[Xo.bisect(m,s,1,u)-1],r.y+=h,r.push(e[o]));return c}var t=!0,a=Number,n=hi,i=gi;return e.value=function(t){return arguments.length?(a=t,e):a},e.range=function(t){return arguments.length?(n=ke(t),e):n},e.bins=function(t){return arguments.length?(i="number"==typeof t?function(e){return ui(e,t)}:ke(t),e):i},e.frequency=function(a){return arguments.length?(t=!!a,e):t},e},Xo.layout.pack=function(){function e(e,o){var r=a.call(this,e,o),s=r[0],c=i[0],d=i[1],l=null==t?Math.sqrt:"function"==typeof t?t:function(){return t};if(s.x=s.y=0,Qn(s,function(e){e.r=+l(e.value)}),Qn(s,vi),n){var m=n*(t?1:Math.max(2*s.r/c,2*s.r/d))/2;Qn(s,function(e){e.r+=m}),Qn(s,vi),Qn(s,function(e){e.r-=m})}return Si(s,c/2,d/2,t?1:1/Math.max(2*s.r/c,2*s.r/d)),r}var t,a=Xo.layout.hierarchy().sort(pi),n=0,i=[1,1];return e.size=function(t){return arguments.length?(i=t,e):i},e.radius=function(a){return arguments.length?(t=null==a||"function"==typeof a?a:+a,e):t},e.padding=function(t){return arguments.length?(n=+t,e):n},Zn(e,a)},Xo.layout.tree=function(){function e(e,i){var l=r.call(this,e,i),m=l[0],g=t(m);if(Qn(g,a),g.parent.m=-g.z,Jn(g,n),d)Jn(m,o);else{var u=m,h=m,p=m;Jn(m,function(e){e.x<u.x&&(u=e),e.x>h.x&&(h=e),e.depth>p.depth&&(p=e)});var y=s(u,h)/2-u.x,_=c[0]/(h.x+s(h,u)/2+y),f=c[1]/(p.depth||1);Jn(m,function(e){e.x=(e.x+y)*_,e.y=e.depth*f})}return l}function t(e){for(var t,a={A:null,children:[e]},n=[a];null!=(t=n.pop());)for(var i,o=t.children,r=0,s=o.length;s>r;++r)n.push((o[r]=i={_:o[r],parent:t,children:(i=o[r].children)&&i.slice()||[],A:null,a:null,z:0,m:0,c:0,s:0,t:null,i:r}).a=i);return a.children[0]}function a(e){var t=e.children,a=e.parent.children,n=e.i?a[e.i-1]:null;if(t.length){Ti(e);var o=(t[0].z+t[t.length-1].z)/2;n?(e.z=n.z+s(e._,n._),e.m=e.z-o):e.z=o}else n&&(e.z=n.z+s(e._,n._));e.parent.A=i(e,n,e.parent.A||a[0])}function n(e){e._.x=e.z+e.parent.m,e.m+=e.parent.m}function i(e,t,a){if(t){for(var n,i=e,o=e,r=t,c=i.parent.children[0],d=i.m,l=o.m,m=r.m,g=c.m;r=Mi(r),i=ki(i),r&&i;)c=ki(c),o=Mi(o),o.a=e,n=r.z+m-i.z-d+s(r._,i._),n>0&&(Pi(Ai(r,e,a),e,n),d+=n,l+=n),m+=r.m,d+=i.m,g+=c.m,l+=o.m;r&&!Mi(o)&&(o.t=r,o.m+=m-l),i&&!ki(c)&&(c.t=i,c.m+=d-g,a=e)}return a}function o(e){e.x*=c[0],e.y=e.depth*c[1]}var r=Xo.layout.hierarchy().sort(null).value(null),s=xi,c=[1,1],d=null;return e.separation=function(t){return arguments.length?(s=t,e):s},e.size=function(t){return arguments.length?(d=null==(c=t)?o:null,e):d?null:c},e.nodeSize=function(t){return arguments.length?(d=null==(c=t)?null:o,e):d?c:null},Zn(e,r)},Xo.layout.cluster=function(){function e(e,o){var r,s=t.call(this,e,o),c=s[0],d=0;Qn(c,function(e){var t=e.children;t&&t.length?(e.x=Gi(t),e.y=Di(t)):(e.x=r?d+=a(e,r):0,e.y=0,r=e)});var l=Fi(c),m=$i(c),g=l.x-a(l,m)/2,u=m.x+a(m,l)/2;return Qn(c,i?function(e){e.x=(e.x-c.x)*n[0],e.y=(c.y-e.y)*n[1]}:function(e){e.x=(e.x-g)/(u-g)*n[0],e.y=(1-(c.y?e.y/c.y:1))*n[1]}),s}var t=Xo.layout.hierarchy().sort(null).value(null),a=xi,n=[1,1],i=!1;return e.separation=function(t){return arguments.length?(a=t,e):a},e.size=function(t){return arguments.length?(i=null==(n=t),e):i?null:n},e.nodeSize=function(t){return arguments.length?(i=null!=(n=t),e):i?n:null},Zn(e,t)},Xo.layout.treemap=function(){function e(e,t){for(var a,n,i=-1,o=e.length;++i<o;)n=(a=e[i]).value*(0>t?0:t),a.area=isNaN(n)||0>=n?0:n}function t(a){var o=a.children;if(o&&o.length){var r,s,c,d=m(a),l=[],g=o.slice(),h=1/0,p="slice"===u?d.dx:"dice"===u?d.dy:"slice-dice"===u?1&a.depth?d.dy:d.dx:Math.min(d.dx,d.dy);for(e(g,d.dx*d.dy/a.value),l.area=0;(c=g.length)>0;)l.push(r=g[c-1]),l.area+=r.area,"squarify"!==u||(s=n(l,p))<=h?(g.pop(),h=s):(l.area-=l.pop().area,i(l,p,d,!1),p=Math.min(d.dx,d.dy),l.length=l.area=0,h=1/0);l.length&&(i(l,p,d,!0),l.length=l.area=0),o.forEach(t)}}function a(t){var n=t.children;if(n&&n.length){var o,r=m(t),s=n.slice(),c=[];for(e(s,r.dx*r.dy/t.value),c.area=0;o=s.pop();)c.push(o),c.area+=o.area,null!=o.z&&(i(c,o.z?r.dx:r.dy,r,!s.length),c.length=c.area=0);n.forEach(a)}}function n(e,t){for(var a,n=e.area,i=0,o=1/0,r=-1,s=e.length;++r<s;)(a=e[r].area)&&(o>a&&(o=a),a>i&&(i=a));return n*=n,t*=t,n?Math.max(t*i*h/n,n/(t*o*h)):1/0}function i(e,t,a,n){var i,o=-1,r=e.length,s=a.x,d=a.y,l=t?c(e.area/t):0;if(t==a.dx){for((n||l>a.dy)&&(l=a.dy);++o<r;)i=e[o],i.x=s,i.y=d,i.dy=l,s+=i.dx=Math.min(a.x+a.dx-s,l?c(i.area/l):0);i.z=!0,i.dx+=a.x+a.dx-s,a.y+=l,a.dy-=l}else{for((n||l>a.dx)&&(l=a.dx);++o<r;)i=e[o],i.x=s,i.y=d,i.dx=l,d+=i.dy=Math.min(a.y+a.dy-d,l?c(i.area/l):0);i.z=!1,i.dy+=a.y+a.dy-d,a.x+=l,a.dx-=l}}function o(n){var i=r||s(n),o=i[0];return o.x=0,o.y=0,o.dx=d[0],o.dy=d[1],r&&s.revalue(o),e([o],o.dx*o.dy/o.value),(r?a:t)(o),g&&(r=i),i}var r,s=Xo.layout.hierarchy(),c=Math.round,d=[1,1],l=null,m=Ni,g=!1,u="squarify",h=.5*(1+Math.sqrt(5));return o.size=function(e){return arguments.length?(d=e,o):d},o.padding=function(e){function t(t){var a=e.call(o,t,t.depth);return null==a?Ni(t):Li(t,"number"==typeof a?[a,a,a,a]:a)}function a(t){return Li(t,e)}if(!arguments.length)return l;var n;return m=null==(l=e)?Ni:"function"==(n=typeof e)?t:"number"===n?(e=[e,e,e,e],a):a,o},o.round=function(e){return arguments.length?(c=e?Math.round:Number,o):c!=Number},o.sticky=function(e){return arguments.length?(g=e,r=null,o):g},o.ratio=function(e){return arguments.length?(h=e,o):h},o.mode=function(e){return arguments.length?(u=e+"",o):u},Zn(o,s)},Xo.random={normal:function(e,t){var a=arguments.length;return 2>a&&(t=1),1>a&&(e=0),function(){var a,n,i;do a=2*Math.random()-1,n=2*Math.random()-1,i=a*a+n*n;while(!i||i>1);return e+t*a*Math.sqrt(-2*Math.log(i)/i)}},logNormal:function(){var e=Xo.random.normal.apply(Xo,arguments);return function(){return Math.exp(e())}},bates:function(e){var t=Xo.random.irwinHall(e);return function(){return t()/e}},irwinHall:function(e){return function(){for(var t=0,a=0;e>a;a++)t+=Math.random();return t}}},Xo.scale={};var hc={floor:Me,ceil:Me};Xo.scale.linear=function(){return Ui([0,1],[0,1],_n,!1)};var pc={s:1,g:1,p:1,r:1,e:1};Xo.scale.log=function(){return Yi(Xo.scale.linear().domain([0,1]),10,!0,[1,10])};var yc=Xo.format(".0e"),_c={floor:function(e){return-Math.ceil(-e)},ceil:function(e){return-Math.floor(-e)}};Xo.scale.pow=function(){return Zi(Xo.scale.linear(),1,[0,1])},Xo.scale.sqrt=function(){return Xo.scale.pow().exponent(.5)},Xo.scale.ordinal=function(){return Qi([],{t:"range",a:[[]]})},Xo.scale.category10=function(){return Xo.scale.ordinal().range(fc)},Xo.scale.category20=function(){return Xo.scale.ordinal().range(vc)},Xo.scale.category20b=function(){return Xo.scale.ordinal().range(bc)},Xo.scale.category20c=function(){return Xo.scale.ordinal().range(wc)};var fc=[2062260,16744206,2924588,14034728,9725885,9197131,14907330,8355711,12369186,1556175].map(fe),vc=[2062260,11454440,16744206,16759672,2924588,10018698,14034728,16750742,9725885,12955861,9197131,12885140,14907330,16234194,8355711,13092807,12369186,14408589,1556175,10410725].map(fe),bc=[3750777,5395619,7040719,10264286,6519097,9216594,11915115,13556636,9202993,12426809,15186514,15190932,8666169,11356490,14049643,15177372,8077683,10834324,13528509,14589654].map(fe),wc=[3244733,7057110,10406625,13032431,15095053,16616764,16625259,16634018,3253076,7652470,10607003,13101504,7695281,10394312,12369372,14342891,6513507,9868950,12434877,14277081].map(fe);Xo.scale.quantile=function(){return eo([],[])},Xo.scale.quantize=function(){return to(0,1,[0,1])},Xo.scale.threshold=function(){return ao([.5],[0,1])},Xo.scale.identity=function(){return no([0,1])},Xo.svg={},Xo.svg.arc=function(){function e(){var e=t.apply(this,arguments),o=a.apply(this,arguments),r=n.apply(this,arguments)+Sc,s=i.apply(this,arguments)+Sc,c=(r>s&&(c=r,r=s,s=c),s-r),d=Pr>c?"0":"1",l=Math.cos(r),m=Math.sin(r),g=Math.cos(s),u=Math.sin(s);return c>=Cc?e?"M0,"+o+"A"+o+","+o+" 0 1,1 0,"+-o+"A"+o+","+o+" 0 1,1 0,"+o+"M0,"+e+"A"+e+","+e+" 0 1,0 0,"+-e+"A"+e+","+e+" 0 1,0 0,"+e+"Z":"M0,"+o+"A"+o+","+o+" 0 1,1 0,"+-o+"A"+o+","+o+" 0 1,1 0,"+o+"Z":e?"M"+o*l+","+o*m+"A"+o+","+o+" 0 "+d+",1 "+o*g+","+o*u+"L"+e*g+","+e*u+"A"+e+","+e+" 0 "+d+",0 "+e*l+","+e*m+"Z":"M"+o*l+","+o*m+"A"+o+","+o+" 0 "+d+",1 "+o*g+","+o*u+"L0,0Z"}var t=io,a=oo,n=ro,i=so;return e.innerRadius=function(a){return arguments.length?(t=ke(a),e):t},e.outerRadius=function(t){return arguments.length?(a=ke(t),e):a},e.startAngle=function(t){return arguments.length?(n=ke(t),e):n},e.endAngle=function(t){return arguments.length?(i=ke(t),e):i},e.centroid=function(){var e=(t.apply(this,arguments)+a.apply(this,arguments))/2,o=(n.apply(this,arguments)+i.apply(this,arguments))/2+Sc;return[Math.cos(o)*e,Math.sin(o)*e]},e};var Sc=-Ar,Cc=Tr-Dr;Xo.svg.line=function(){return co(Me)};var xc=Xo.map({linear:lo,"linear-closed":mo,step:go,"step-before":uo,"step-after":ho,basis:bo,"basis-open":wo,"basis-closed":So,bundle:Co,cardinal:_o,"cardinal-open":po,"cardinal-closed":yo,monotone:Ao});xc.forEach(function(e,t){t.key=e,t.closed=/-closed$/.test(e)});var kc=[0,2/3,1/3,0],Mc=[0,1/3,2/3,0],Pc=[0,1/6,2/3,1/6];Xo.svg.line.radial=function(){var e=co(Do);return e.radius=e.x,delete e.x,e.angle=e.y,delete e.y,e},uo.reverse=ho,ho.reverse=uo,Xo.svg.area=function(){return Go(Me)},Xo.svg.area.radial=function(){var e=Go(Do);return e.radius=e.x,delete e.x,e.innerRadius=e.x0,delete e.x0,e.outerRadius=e.x1,delete e.x1,e.angle=e.y,delete e.y,e.startAngle=e.y0,delete e.y0,e.endAngle=e.y1,delete e.y1,e},Xo.svg.chord=function(){function e(e,s){var c=t(this,o,e,s),d=t(this,r,e,s);return"M"+c.p0+n(c.r,c.p1,c.a1-c.a0)+(a(c,d)?i(c.r,c.p1,c.r,c.p0):i(c.r,c.p1,d.r,d.p0)+n(d.r,d.p1,d.a1-d.a0)+i(d.r,d.p1,c.r,c.p0))+"Z"}function t(e,t,a,n){var i=t.call(e,a,n),o=s.call(e,i,n),r=c.call(e,i,n)+Sc,l=d.call(e,i,n)+Sc;return{r:o,a0:r,a1:l,p0:[o*Math.cos(r),o*Math.sin(r)],p1:[o*Math.cos(l),o*Math.sin(l)]}}function a(e,t){return e.a0==t.a0&&e.a1==t.a1}function n(e,t,a){return"A"+e+","+e+" 0 "+ +(a>Pr)+",1 "+t}function i(e,t,a,n){return"Q 0,0 "+n}var o=_a,r=fa,s=Fo,c=ro,d=so;return e.radius=function(t){return arguments.length?(s=ke(t),e):s},e.source=function(t){return arguments.length?(o=ke(t),e):o},e.target=function(t){return arguments.length?(r=ke(t),e):r},e.startAngle=function(t){return arguments.length?(c=ke(t),e):c},e.endAngle=function(t){return arguments.length?(d=ke(t),e):d},e},Xo.svg.diagonal=function(){function e(e,i){var o=t.call(this,e,i),r=a.call(this,e,i),s=(o.y+r.y)/2,c=[o,{x:o.x,y:s},{x:r.x,y:s},r];return c=c.map(n),"M"+c[0]+"C"+c[1]+" "+c[2]+" "+c[3]}var t=_a,a=fa,n=$o;return e.source=function(a){return arguments.length?(t=ke(a),e):t},e.target=function(t){return arguments.length?(a=ke(t),e):a},e.projection=function(t){return arguments.length?(n=t,e):n},e},Xo.svg.diagonal.radial=function(){var e=Xo.svg.diagonal(),t=$o,a=e.projection;return e.projection=function(e){return arguments.length?a(No(t=e)):t},e},Xo.svg.symbol=function(){function e(e,n){return(Tc.get(t.call(this,e,n))||Ro)(a.call(this,e,n))}var t=Eo,a=Lo;return e.type=function(a){return arguments.length?(t=ke(a),e):t},e.size=function(t){return arguments.length?(a=ke(t),e):a},e};var Tc=Xo.map({circle:Ro,cross:function(e){var t=Math.sqrt(e/5)/2;return"M"+-3*t+","+-t+"H"+-t+"V"+-3*t+"H"+t+"V"+-t+"H"+3*t+"V"+t+"H"+t+"V"+3*t+"H"+-t+"V"+t+"H"+-3*t+"Z"},diamond:function(e){var t=Math.sqrt(e/(2*Fc)),a=t*Fc;return"M0,"+-t+"L"+a+",0 0,"+t+" "+-a+",0Z"},square:function(e){var t=Math.sqrt(e)/2;return"M"+-t+","+-t+"L"+t+","+-t+" "+t+","+t+" "+-t+","+t+"Z"},"triangle-down":function(e){var t=Math.sqrt(e/Gc),a=t*Gc/2;return"M0,"+a+"L"+t+","+-a+" "+-t+","+-a+"Z"},"triangle-up":function(e){var t=Math.sqrt(e/Gc),a=t*Gc/2;return"M0,"+-a+"L"+t+","+a+" "+-t+","+a+"Z"}});Xo.svg.symbolTypes=Tc.keys();var Ac,Dc,Gc=Math.sqrt(3),Fc=Math.tan(30*Fr),$c=[],Nc=0;$c.call=vr.call,$c.empty=vr.empty,$c.node=vr.node,$c.size=vr.size,Xo.transition=function(e){return arguments.length?Ac?e.transition():e:Sr.transition()},Xo.transition.prototype=$c,$c.select=function(e){var t,a,n,i=this.id,o=[];e=k(e);for(var r=-1,s=this.length;++r<s;){o.push(t=[]);for(var c=this[r],d=-1,l=c.length;++d<l;)(n=c[d])&&(a=e.call(n,n.__data__,d,r))?("__data__"in n&&(a.__data__=n.__data__),Oo(a,d,i,n.__transition__[i]),t.push(a)):t.push(null)}return Io(o,i)},$c.selectAll=function(e){var t,a,n,i,o,r=this.id,s=[];e=M(e);for(var c=-1,d=this.length;++c<d;)for(var l=this[c],m=-1,g=l.length;++m<g;)if(n=l[m]){o=n.__transition__[r],a=e.call(n,n.__data__,m,c),s.push(t=[]);for(var u=-1,h=a.length;++u<h;)(i=a[u])&&Oo(i,u,r,o),t.push(i)}return Io(s,r)},$c.filter=function(e){var t,a,n,i=[];"function"!=typeof e&&(e=R(e));for(var o=0,r=this.length;r>o;o++){i.push(t=[]);for(var a=this[o],s=0,c=a.length;c>s;s++)(n=a[s])&&e.call(n,n.__data__,s,o)&&t.push(n)}return Io(i,this.id)},$c.tween=function(e,t){var a=this.id;return arguments.length<2?this.node().__transition__[a].tween.get(e):H(this,null==t?function(t){t.__transition__[a].tween.remove(e)}:function(n){n.__transition__[a].tween.set(e,t)})},$c.attr=function(e,t){function a(){this.removeAttribute(s)}function n(){this.removeAttributeNS(s.space,s.local)}function i(e){return null==e?a:(e+="",function(){var t,a=this.getAttribute(s);return a!==e&&(t=r(a,e),function(e){this.setAttribute(s,t(e))})})}function o(e){return null==e?n:(e+="",function(){var t,a=this.getAttributeNS(s.space,s.local);return a!==e&&(t=r(a,e),function(e){this.setAttributeNS(s.space,s.local,t(e))})})}if(arguments.length<2){for(t in e)this.attr(t,e[t]);return this}var r="transform"==e?Bn:_n,s=Xo.ns.qualify(e);return Ho(this,"attr."+e,t,s.local?o:i)},$c.attrTween=function(e,t){function a(e,a){var n=t.call(this,e,a,this.getAttribute(i));return n&&function(e){this.setAttribute(i,n(e))}}function n(e,a){var n=t.call(this,e,a,this.getAttributeNS(i.space,i.local));return n&&function(e){this.setAttributeNS(i.space,i.local,n(e))}}var i=Xo.ns.qualify(e);return this.tween("attr."+e,i.local?n:a)},$c.style=function(e,t,a){function n(){this.style.removeProperty(e)}function i(t){return null==t?n:(t+="",function(){var n,i=er.getComputedStyle(this,null).getPropertyValue(e);return i!==t&&(n=_n(i,t),function(t){this.style.setProperty(e,n(t),a)})})}var o=arguments.length;if(3>o){if("string"!=typeof e){2>o&&(t="");for(a in e)this.style(a,e[a],t);return this}a=""}return Ho(this,"style."+e,t,i)},$c.styleTween=function(e,t,a){function n(n,i){var o=t.call(this,n,i,er.getComputedStyle(this,null).getPropertyValue(e));return o&&function(t){this.style.setProperty(e,o(t),a)}}return arguments.length<3&&(a=""),this.tween("style."+e,n)},$c.text=function(e){return Ho(this,"text",e,Bo)},$c.remove=function(){return this.each("end.transition",function(){var e;this.__transition__.count<2&&(e=this.parentNode)&&e.removeChild(this)})},$c.ease=function(e){var t=this.id;return arguments.length<1?this.node().__transition__[t].ease:("function"!=typeof e&&(e=Xo.ease.apply(Xo,arguments)),H(this,function(a){a.__transition__[t].ease=e}))},$c.delay=function(e){var t=this.id;return arguments.length<1?this.node().__transition__[t].delay:H(this,"function"==typeof e?function(a,n,i){a.__transition__[t].delay=+e.call(a,a.__data__,n,i)}:(e=+e,function(a){a.__transition__[t].delay=e}))},$c.duration=function(e){var t=this.id;return arguments.length<1?this.node().__transition__[t].duration:H(this,"function"==typeof e?function(a,n,i){a.__transition__[t].duration=Math.max(1,e.call(a,a.__data__,n,i))}:(e=Math.max(1,e),function(a){a.__transition__[t].duration=e}))},$c.each=function(e,t){var a=this.id;if(arguments.length<2){var n=Dc,i=Ac;Ac=a,H(this,function(t,n,i){Dc=t.__transition__[a],e.call(t,t.__data__,n,i)}),Dc=n,Ac=i}else H(this,function(n){var i=n.__transition__[a];(i.event||(i.event=Xo.dispatch("start","end"))).on(e,t)});return this},$c.transition=function(){for(var e,t,a,n,i=this.id,o=++Nc,r=[],s=0,c=this.length;c>s;s++){r.push(e=[]);for(var t=this[s],d=0,l=t.length;l>d;d++)(a=t[d])&&(n=Object.create(a.__transition__[i]),n.delay+=n.duration,Oo(a,d,o,n)),e.push(a)}return Io(r,o)},Xo.svg.axis=function(){function e(e){e.each(function(){var e,d=Xo.select(this),l=this.__chart__||a,m=this.__chart__=a.copy(),g=null==c?m.ticks?m.ticks.apply(m,s):m.domain():c,u=null==t?m.tickFormat?m.tickFormat.apply(m,s):Me:t,h=d.selectAll(".tick").data(g,m),p=h.enter().insert("g",".domain").attr("class","tick").style("opacity",Dr),y=Xo.transition(h.exit()).style("opacity",Dr).remove(),_=Xo.transition(h.order()).style("opacity",1),f=Math.max(i,0)+r,v=Ri(m),b=d.selectAll(".domain").data([0]),w=(b.enter().append("path").attr("class","domain"),Xo.transition(b));p.append("line"),p.append("text");var S,C,x,k,M=p.select("line"),P=_.select("line"),T=h.select("text").text(u),A=p.select("text"),D=_.select("text"),G="top"===n||"left"===n?-1:1;if("bottom"===n||"top"===n?(e=Uo,S="x",x="y",C="x2",k="y2",T.attr("dy",0>G?"0em":".71em").style("text-anchor","middle"),w.attr("d","M"+v[0]+","+G*o+"V0H"+v[1]+"V"+G*o)):(e=Vo,S="y",x="x",C="y2",k="x2",T.attr("dy",".32em").style("text-anchor",0>G?"end":"start"),w.attr("d","M"+G*o+","+v[0]+"H0V"+v[1]+"H"+G*o)),M.attr(k,G*i),A.attr(x,G*f),P.attr(C,0).attr(k,G*i),D.attr(S,0).attr(x,G*f),m.rangeBand){var F=m,$=F.rangeBand()/2;l=m=function(e){return F(e)+$}}else l.rangeBand?l=m:y.call(e,m,l);p.call(e,l,m),_.call(e,m,m)})}var t,a=Xo.scale.linear(),n=Lc,i=6,o=6,r=3,s=[10],c=null;return e.scale=function(t){return arguments.length?(a=t,e):a},e.orient=function(t){return arguments.length?(n=t in Ec?t+"":Lc,e):n},e.ticks=function(){return arguments.length?(s=arguments,e):s},e.tickValues=function(t){return arguments.length?(c=t,e):c},e.tickFormat=function(a){return arguments.length?(t=a,e):t},e.tickSize=function(t){var a=arguments.length;return a?(i=+t,o=+arguments[a-1],e):i},e.innerTickSize=function(t){return arguments.length?(i=+t,e):i},e.outerTickSize=function(t){return arguments.length?(o=+t,e):o},e.tickPadding=function(t){return arguments.length?(r=+t,e):r},e.tickSubdivide=function(){return arguments.length&&e},e};var Lc="bottom",Ec={top:1,right:1,bottom:1,left:1};Xo.svg.brush=function(){function e(o){o.each(function(){var o=Xo.select(this).style("pointer-events","all").style("-webkit-tap-highlight-color","rgba(0,0,0,0)").on("mousedown.brush",i).on("touchstart.brush",i),r=o.selectAll(".background").data([0]);r.enter().append("rect").attr("class","background").style("visibility","hidden").style("cursor","crosshair"),o.selectAll(".extent").data([0]).enter().append("rect").attr("class","extent").style("cursor","move");var s=o.selectAll(".resize").data(h,Me);s.exit().remove(),s.enter().append("g").attr("class",function(e){return"resize "+e}).style("cursor",function(e){return Rc[e]}).append("rect").attr("x",function(e){return/[ew]$/.test(e)?-3:null}).attr("y",function(e){return/^[ns]/.test(e)?-3:null}).attr("width",6).attr("height",6).style("visibility","hidden"),s.style("display",e.empty()?"none":null);var l,m=Xo.transition(o),g=Xo.transition(r);c&&(l=Ri(c),g.attr("x",l[0]).attr("width",l[1]-l[0]),a(m)),d&&(l=Ri(d),g.attr("y",l[0]).attr("height",l[1]-l[0]),n(m)),t(m)})}function t(e){e.selectAll(".resize").attr("transform",function(e){return"translate("+l[+/e$/.test(e)]+","+m[+/^s/.test(e)]+")"})}function a(e){e.select(".extent").attr("x",l[0]),e.selectAll(".extent,.n>rect,.s>rect").attr("width",l[1]-l[0])}function n(e){e.select(".extent").attr("y",m[0]),e.selectAll(".extent,.e>rect,.w>rect").attr("height",m[1]-m[0])}function i(){function i(){32==Xo.event.keyCode&&(T||(f=null,D[0]-=l[1],D[1]-=m[1],T=2),w())}function h(){32==Xo.event.keyCode&&2==T&&(D[0]+=l[1],D[1]+=m[1],T=0,w())}function p(){var e=Xo.mouse(b),i=!1;v&&(e[0]+=v[0],e[1]+=v[1]),T||(Xo.event.altKey?(f||(f=[(l[0]+l[1])/2,(m[0]+m[1])/2]),D[0]=l[+(e[0]<f[0])],D[1]=m[+(e[1]<f[1])]):f=null),M&&y(e,c,0)&&(a(x),i=!0),P&&y(e,d,1)&&(n(x),i=!0),i&&(t(x),C({type:"brush",mode:T?"move":"resize"}))}function y(e,t,a){var n,i,s=Ri(t),c=s[0],d=s[1],h=D[a],p=a?m:l,y=p[1]-p[0];return T&&(c-=h,d-=y+h),n=(a?u:g)?Math.max(c,Math.min(d,e[a])):e[a],T?i=(n+=h)+y:(f&&(h=Math.max(c,Math.min(d,2*f[a]-n))),n>h?(i=n,n=h):i=h),p[0]!=n||p[1]!=i?(a?r=null:o=null,p[0]=n,p[1]=i,!0):void 0}function _(){p(),x.style("pointer-events","all").selectAll(".resize").style("display",e.empty()?"none":null),Xo.select("body").style("cursor",null),G.on("mousemove.brush",null).on("mouseup.brush",null).on("touchmove.brush",null).on("touchend.brush",null).on("keydown.brush",null).on("keyup.brush",null),A(),C({type:"brushend"})}var f,v,b=this,S=Xo.select(Xo.event.target),C=s.of(b,arguments),x=Xo.select(b),k=S.datum(),M=!/^(n|s)$/.test(k)&&c,P=!/^(e|w)$/.test(k)&&d,T=S.classed("extent"),A=K(),D=Xo.mouse(b),G=Xo.select(er).on("keydown.brush",i).on("keyup.brush",h);if(Xo.event.changedTouches?G.on("touchmove.brush",p).on("touchend.brush",_):G.on("mousemove.brush",p).on("mouseup.brush",_),x.interrupt().selectAll("*").interrupt(),T)D[0]=l[0]-D[0],D[1]=m[0]-D[1];else if(k){var F=+/w$/.test(k),$=+/^n/.test(k);v=[l[1-F]-D[0],m[1-$]-D[1]],D[0]=l[F],D[1]=m[$]}else Xo.event.altKey&&(f=D.slice());x.style("pointer-events","none").selectAll(".resize").style("display",null),Xo.select("body").style("cursor",S.style("cursor")),C({type:"brushstart"}),p()}var o,r,s=C(e,"brushstart","brush","brushend"),c=null,d=null,l=[0,0],m=[0,0],g=!0,u=!0,h=Ic[0];return e.event=function(e){e.each(function(){var e=s.of(this,arguments),t={x:l,y:m,i:o,j:r},a=this.__chart__||t;this.__chart__=t,Ac?Xo.select(this).transition().each("start.brush",function(){o=a.i,r=a.j,l=a.x,m=a.y,e({type:"brushstart"})}).tween("brush:brush",function(){var a=fn(l,t.x),n=fn(m,t.y);return o=r=null,function(i){l=t.x=a(i),m=t.y=n(i),e({type:"brush",mode:"resize"})}}).each("end.brush",function(){o=t.i,r=t.j,e({type:"brush",mode:"resize"}),e({type:"brushend"})}):(e({type:"brushstart"}),e({type:"brush",mode:"resize"}),e({type:"brushend"}))})},e.x=function(t){return arguments.length?(c=t,h=Ic[!c<<1|!d],e):c},e.y=function(t){return arguments.length?(d=t,h=Ic[!c<<1|!d],e):d},e.clamp=function(t){return arguments.length?(c&&d?(g=!!t[0],u=!!t[1]):c?g=!!t:d&&(u=!!t),e):c&&d?[g,u]:c?g:d?u:null},e.extent=function(t){var a,n,i,s,g;return arguments.length?(c&&(a=t[0],n=t[1],d&&(a=a[0],n=n[0]),o=[a,n],c.invert&&(a=c(a),n=c(n)),a>n&&(g=a,a=n,n=g),(a!=l[0]||n!=l[1])&&(l=[a,n])),d&&(i=t[0],s=t[1],c&&(i=i[1],s=s[1]),r=[i,s],d.invert&&(i=d(i),s=d(s)),i>s&&(g=i,i=s,s=g),(i!=m[0]||s!=m[1])&&(m=[i,s])),e):(c&&(o?(a=o[0],n=o[1]):(a=l[0],n=l[1],c.invert&&(a=c.invert(a),n=c.invert(n)),a>n&&(g=a,a=n,n=g))),d&&(r?(i=r[0],s=r[1]):(i=m[0],s=m[1],d.invert&&(i=d.invert(i),s=d.invert(s)),i>s&&(g=i,i=s,s=g))),c&&d?[[a,i],[n,s]]:c?[a,n]:d&&[i,s])},e.clear=function(){return e.empty()||(l=[0,0],m=[0,0],o=r=null),e},e.empty=function(){return!!c&&l[0]==l[1]||!!d&&m[0]==m[1]},Xo.rebind(e,s,"on")};var Rc={n:"ns-resize",e:"ew-resize",s:"ns-resize",w:"ew-resize",nw:"nwse-resize",ne:"nesw-resize",se:"nwse-resize",sw:"nesw-resize"},Ic=[["n","e","s","w","nw","ne","se","sw"],["e","w"],["n","s"],[]],Hc=is.format=ls.timeFormat,Bc=Hc.utc,Oc=Bc("%Y-%m-%dT%H:%M:%S.%LZ");Hc.iso=Date.prototype.toISOString&&+new Date("2000-01-01T00:00:00.000Z")?Wo:Oc,Wo.parse=function(e){var t=new Date(e);return isNaN(t)?null:t},Wo.toString=Oc.toString,is.second=He(function(e){return new os(1e3*Math.floor(e/1e3))},function(e,t){e.setTime(e.getTime()+1e3*Math.floor(t))},function(e){return e.getSeconds()}),is.seconds=is.second.range,is.seconds.utc=is.second.utc.range,is.minute=He(function(e){return new os(6e4*Math.floor(e/6e4))},function(e,t){e.setTime(e.getTime()+6e4*Math.floor(t))},function(e){return e.getMinutes()}),is.minutes=is.minute.range,is.minutes.utc=is.minute.utc.range,is.hour=He(function(e){var t=e.getTimezoneOffset()/60;return new os(36e5*(Math.floor(e/36e5-t)+t))},function(e,t){e.setTime(e.getTime()+36e5*Math.floor(t))},function(e){return e.getHours()}),is.hours=is.hour.range,is.hours.utc=is.hour.utc.range,is.month=He(function(e){return e=is.day(e),e.setDate(1),e},function(e,t){e.setMonth(e.getMonth()+t)},function(e){return e.getMonth()}),is.months=is.month.range,is.months.utc=is.month.utc.range;var Uc=[1e3,5e3,15e3,3e4,6e4,3e5,9e5,18e5,36e5,108e5,216e5,432e5,864e5,1728e5,6048e5,2592e6,7776e6,31536e6],Vc=[[is.second,1],[is.second,5],[is.second,15],[is.second,30],[is.minute,1],[is.minute,5],[is.minute,15],[is.minute,30],[is.hour,1],[is.hour,3],[is.hour,6],[is.hour,12],[is.day,1],[is.day,2],[is.week,1],[is.month,1],[is.month,3],[is.year,1]],Wc=Hc.multi([[".%L",function(e){return e.getMilliseconds()}],[":%S",function(e){return e.getSeconds()}],["%I:%M",function(e){return e.getMinutes()}],["%I %p",function(e){return e.getHours()}],["%a %d",function(e){return e.getDay()&&1!=e.getDate()}],["%b %d",function(e){return 1!=e.getDate()}],["%B",function(e){return e.getMonth()}],["%Y",Pt]]),zc={range:function(e,t,a){return Xo.range(Math.ceil(e/a)*a,+t,a).map(Ko)},floor:Me,ceil:Me};Vc.year=is.year,is.scale=function(){return zo(Xo.scale.linear(),Vc,Wc)};var Kc=Vc.map(function(e){return[e[0].utc,e[1]]}),jc=Bc.multi([[".%L",function(e){return e.getUTCMilliseconds()}],[":%S",function(e){return e.getUTCSeconds()}],["%I:%M",function(e){return e.getUTCMinutes()}],["%I %p",function(e){return e.getUTCHours()}],["%a %d",function(e){return e.getUTCDay()&&1!=e.getUTCDate()}],["%b %d",function(e){return 1!=e.getUTCDate()}],["%B",function(e){return e.getUTCMonth()}],["%Y",Pt]]);Kc.year=is.year.utc,is.scale.utc=function(){return zo(Xo.scale.linear(),Kc,jc)},Xo.text=Pe(function(e){return e.responseText}),Xo.json=function(e,t){return Te(e,"application/json",jo,t)},Xo.html=function(e,t){return Te(e,"text/html",qo,t)},Xo.xml=Pe(function(e){return e.responseXML}),"function"==typeof define&&define.amd?define("libs/d3",Xo):"object"==typeof module&&module.exports&&(module.exports=Xo),this.d3=Xo}(),define("unifi/view/map/MarkerRfMapView",["backbone","underscore","jquery","libs/d3","msg/Msg"],function(e,t,a,n,i){"use strict";return e.View.extend({rfMapBorderData:{normalCircle:{cx:75,cy:75,r:65,fill:"none",stroke:"rgba(50,110,140,1)","stroke-width":2},warningPath:{data1:{fill:"none",stroke:"#FBE800","stroke-width":2,"stroke-miterlimit":10,d:"M592,306.9c0,1.6-4.6,3-4.7,4.5c-0.1,1.5,4.4,3.5,4.2,5c-0.2,1.5-4.9,2.5-5.2,4c-0.2,1.5,4,3.9,3.6,5.4c-0.3,1.5-5.1,1.9-5.6,3.4c-0.4,1.5,3.5,4.3,3,5.8c-0.5,1.5-5.3,1.3-5.9,2.8c-0.6,1.4,3,4.7,2.4,6.1c-0.7,1.4-5.4,0.7-6.2,2.1c-0.7,1.4,2.5,5,1.7,6.3c-0.8,1.3-5.5,0.2-6.3,1.4c-0.9,1.3,1.9,5.2,1,6.4c-0.9,1.2-5.5-0.4-6.5,0.7c-1,1.2,1.4,5.4,0.3,6.5c-1.1,1.1-5.4-1-6.5,0c-1.1,1.1,0.8,5.5-0.4,6.5c-1.2,1-5.2-1.6-6.5-0.7c-1.2,0.9,0.2,5.5-1.1,6.4c-1.3,0.9-5-2.2-6.4-1.4c-1.3,0.8-0.4,5.5-1.8,6.3c-1.4,0.7-4.8-2.7-6.2-2c-1.4,0.6-1,5.5-2.4,6c-1.4,0.6-4.5-3.2-5.9-2.7c-1.5,0.5-1.6,5.3-3.1,5.7c-1.5,0.4-4.1-3.7-5.6-3.3c-1.5,0.3-2.2,5.1-3.7,5.4c-1.5,0.2-3.7-4.1-5.2-3.9c-1.5,0.2-2.7,4.8-4.2,4.9c-1.5,0.1-3.2-4.4-4.7-4.4c-1.6,0-3.2,4.5-4.7,4.4c-1.5-0.1-2.7-4.8-4.2-4.9c-1.5-0.2-3.7,4.2-5.2,3.9c-1.5-0.2-2.2-5-3.7-5.4c-1.5-0.3-4.1,3.7-5.6,3.3c-1.5-0.4-1.6-5.2-3.1-5.7c-1.5-0.5-4.5,3.3-5.9,2.7c-1.4-0.6-1-5.4-2.4-6c-1.4-0.7-4.8,2.8-6.2,2c-1.4-0.7-0.5-5.5-1.8-6.3c-1.3-0.8-5.1,2.2-6.4,1.4c-1.3-0.9,0.1-5.5-1.1-6.4c-1.2-0.9-5.3,1.7-6.5,0.7c-1.2-1,0.7-5.4-0.4-6.5c-1.1-1.1-5.4,1.1-6.5,0c-1.1-1.1,1.3-5.3,0.3-6.5c-1-1.2-5.5,0.5-6.5-0.7c-0.9-1.2,1.9-5.1,1-6.4c-0.9-1.3-5.5-0.1-6.3-1.4c-0.8-1.3,2.4-4.9,1.7-6.3c-0.7-1.4-5.5-0.7-6.2-2.1c-0.6-1.4,2.9-4.6,2.4-6.1c-0.6-1.4-5.4-1.3-5.9-2.8c-0.5-1.5,3.4-4.3,3-5.8c-0.4-1.5-5.2-1.9-5.6-3.4c-0.3-1.5,3.9-3.9,3.6-5.4c-0.2-1.5-5-2.4-5.2-4c-0.2-1.5,4.3-3.4,4.2-5c-0.1-1.5-4.7-3-4.7-4.5s4.6-3,4.7-4.5c0.1-1.5-4.4-3.5-4.2-5c0.2-1.5,4.9-2.5,5.2-4c0.2-1.5-4-3.9-3.6-5.4c0.3-1.5,5.1-1.9,5.6-3.4c0.4-1.5-3.5-4.3-3-5.8c0.5-1.5,5.3-1.3,5.9-2.8c0.6-1.4-3-4.7-2.4-6.1c0.6-1.4,5.4-0.7,6.2-2.1c0.7-1.4-2.5-5-1.7-6.3c0.8-1.3,5.5-0.2,6.3-1.4c0.9-1.3-1.9-5.2-1-6.4c0.9-1.2,5.5,0.4,6.5-0.7c1-1.2-1.4-5.4-0.3-6.5c1.1-1.1,5.4,1,6.5,0c1.1-1.1-0.8-5.5,0.4-6.5c1.2-1,5.2,1.6,6.5,0.7c1.2-0.9-0.2-5.5,1.1-6.4c1.3-0.9,5,2.2,6.4,1.4c1.3-0.8,0.4-5.5,1.8-6.3c1.4-0.7,4.8,2.7,6.2,2c1.4-0.6,1-5.5,2.4-6c1.4-0.6,4.5,3.2,5.9,2.7c1.5-0.5,1.6-5.3,3.1-5.7c1.5-0.4,4.1,3.7,5.6,3.3c1.5-0.3,2.2-5.1,3.7-5.4c1.5-0.2,3.7,4.1,5.2,3.9c1.5-0.2,2.7-4.8,4.2-4.9c1.5-0.1,3.2,4.4,4.7,4.4s3.2-4.5,4.7-4.4c1.5,0.1,2.7,4.8,4.2,4.9c1.5,0.2,3.7-4.2,5.2-3.9c1.5,0.2,2.2,5,3.7,5.4c1.5,0.3,4.1-3.7,5.6-3.3c1.5,0.4,1.6,5.2,3.1,5.7c1.5,0.5,4.5-3.3,5.9-2.7c1.4,0.6,1,5.4,2.4,6c1.4,0.7,4.8-2.8,6.2-2c1.4,0.7,0.5,5.5,1.8,6.3c1.3,0.8,5.1-2.2,6.4-1.4c1.3,0.9-0.1,5.5,1.1,6.4c1.2,0.9,5.3-1.7,6.5-0.7c1.2,1-0.7,5.4,0.4,6.5c1.1,1.1,5.4-1.1,6.5,0c1.1,1.1-1.3,5.3-0.3,6.5c1,1.2,5.5-0.5,6.5,0.7c0.9,1.2-1.9,5.1-1,6.4c0.9,1.3,5.5,0.1,6.3,1.4c0.8,1.3-2.4,4.9-1.7,6.3c0.7,1.4,5.5,0.7,6.2,2.1c0.6,1.4-2.9,4.6-2.4,6.1c0.6,1.4,5.4,1.3,5.9,2.8c0.5,1.5-3.4,4.3-3,5.8c0.4,1.5,5.2,1.9,5.6,3.4c0.3,1.5-3.9,3.9-3.6,5.4c0.2,1.5,5,2.4,5.2,4c0.2,1.5-4.3,3.4-4.2,5C587.4,304,592,305.4,592,306.9z",transform:"translate(-304,-156) scale(0.75)"},data2:{fill:"none",stroke:"#FBE800","stroke-width":2,"stroke-miterlimit":10,d:"M592,306.9c0,1.6-4.6,3-4.7,4.5c-0.1,1.5,4.4,3.5,4.2,5c-0.2,1.5-4.9,2.5-5.2,4c-0.2,1.5,4,3.9,3.6,5.4c-0.3,1.5-5.1,1.9-5.6,3.4c-0.4,1.5,3.5,4.3,3,5.8c-0.5,1.5-5.3,1.3-5.9,2.8c-0.6,1.4,3,4.7,2.4,6.1c-0.7,1.4-5.4,0.7-6.2,2.1c-0.7,1.4,2.5,5,1.7,6.3c-0.8,1.3-5.5,0.2-6.3,1.4c-0.9,1.3,1.9,5.2,1,6.4c-0.9,1.2-5.5-0.4-6.5,0.7c-1,1.2,1.4,5.4,0.3,6.5c-1.1,1.1-5.4-1-6.5,0c-1.1,1.1,0.8,5.5-0.4,6.5c-1.2,1-5.2-1.6-6.5-0.7c-1.2,0.9,0.2,5.5-1.1,6.4c-1.3,0.9-5-2.2-6.4-1.4c-1.3,0.8-0.4,5.5-1.8,6.3c-1.4,0.7-4.8-2.7-6.2-2c-1.4,0.6-1,5.5-2.4,6c-1.4,0.6-4.5-3.2-5.9-2.7c-1.5,0.5-1.6,5.3-3.1,5.7c-1.5,0.4-4.1-3.7-5.6-3.3c-1.5,0.3-2.2,5.1-3.7,5.4c-1.5,0.2-3.7-4.1-5.2-3.9c-1.5,0.2-2.7,4.8-4.2,4.9c-1.5,0.1-3.2-4.4-4.7-4.4c-1.6,0-3.2,4.5-4.7,4.4c-1.5-0.1-2.7-4.8-4.2-4.9c-1.5-0.2-3.7,4.2-5.2,3.9c-1.5-0.2-2.2-5-3.7-5.4c-1.5-0.3-4.1,3.7-5.6,3.3c-1.5-0.4-1.6-5.2-3.1-5.7c-1.5-0.5-4.5,3.3-5.9,2.7c-1.4-0.6-1-5.4-2.4-6c-1.4-0.7-4.8,2.8-6.2,2c-1.4-0.7-0.5-5.5-1.8-6.3c-1.3-0.8-5.1,2.2-6.4,1.4c-1.3-0.9,0.1-5.5-1.1-6.4c-1.2-0.9-5.3,1.7-6.5,0.7c-1.2-1,0.7-5.4-0.4-6.5c-1.1-1.1-5.4,1.1-6.5,0c-1.1-1.1,1.3-5.3,0.3-6.5c-1-1.2-5.5,0.5-6.5-0.7c-0.9-1.2,1.9-5.1,1-6.4c-0.9-1.3-5.5-0.1-6.3-1.4c-0.8-1.3,2.4-4.9,1.7-6.3c-0.7-1.4-5.5-0.7-6.2-2.1c-0.6-1.4,2.9-4.6,2.4-6.1c-0.6-1.4-5.4-1.3-5.9-2.8c-0.5-1.5,3.4-4.3,3-5.8c-0.4-1.5-5.2-1.9-5.6-3.4c-0.3-1.5,3.9-3.9,3.6-5.4c-0.2-1.5-5-2.4-5.2-4c-0.2-1.5,4.3-3.4,4.2-5c-0.1-1.5-4.7-3-4.7-4.5s4.6-3,4.7-4.5c0.1-1.5-4.4-3.5-4.2-5c0.2-1.5,4.9-2.5,5.2-4c0.2-1.5-4-3.9-3.6-5.4c0.3-1.5,5.1-1.9,5.6-3.4c0.4-1.5-3.5-4.3-3-5.8c0.5-1.5,5.3-1.3,5.9-2.8c0.6-1.4-3-4.7-2.4-6.1c0.6-1.4,5.4-0.7,6.2-2.1c0.7-1.4-2.5-5-1.7-6.3c0.8-1.3,5.5-0.2,6.3-1.4c0.9-1.3-1.9-5.2-1-6.4c0.9-1.2,5.5,0.4,6.5-0.7c1-1.2-1.4-5.4-0.3-6.5c1.1-1.1,5.4,1,6.5,0c1.1-1.1-0.8-5.5,0.4-6.5c1.2-1,5.2,1.6,6.5,0.7c1.2-0.9-0.2-5.5,1.1-6.4c1.3-0.9,5,2.2,6.4,1.4c1.3-0.8,0.4-5.5,1.8-6.3c1.4-0.7,4.8,2.7,6.2,2c1.4-0.6,1-5.5,2.4-6c1.4-0.6,4.5,3.2,5.9,2.7c1.5-0.5,1.6-5.3,3.1-5.7c1.5-0.4,4.1,3.7,5.6,3.3c1.5-0.3,2.2-5.1,3.7-5.4c1.5-0.2,3.7,4.1,5.2,3.9c1.5-0.2,2.7-4.8,4.2-4.9c1.5-0.1,3.2,4.4,4.7,4.4s3.2-4.5,4.7-4.4c1.5,0.1,2.7,4.8,4.2,4.9c1.5,0.2,3.7-4.2,5.2-3.9c1.5,0.2,2.2,5,3.7,5.4c1.5,0.3,4.1-3.7,5.6-3.3c1.5,0.4,1.6,5.2,3.1,5.7c1.5,0.5,4.5-3.3,5.9-2.7c1.4,0.6,1,5.4,2.4,6c1.4,0.7,4.8-2.8,6.2-2c1.4,0.7,0.5,5.5,1.8,6.3c1.3,0.8,5.1-2.2,6.4-1.4c1.3,0.9-0.1,5.5,1.1,6.4c1.2,0.9,5.3-1.7,6.5-0.7c1.2,1-0.7,5.4,0.4,6.5c1.1,1.1,5.4-1.1,6.5,0c1.1,1.1-1.3,5.3-0.3,6.5c1,1.2,5.5-0.5,6.5,0.7c0.9,1.2-1.9,5.1-1,6.4c0.9,1.3,5.5,0.1,6.3,1.4c0.8,1.3-2.4,4.9-1.7,6.3c0.7,1.4,5.5,0.7,6.2,2.1c0.6,1.4-2.9,4.6-2.4,6.1c0.6,1.4,5.4,1.3,5.9,2.8c0.5,1.5-3.4,4.3-3,5.8c0.4,1.5,5.2,1.9,5.6,3.4Ic0.3,1.5-3.9,3.9-3.6,5.4c0.2,1.5,5,2.4,5.2,4c0.2,1.5-4.3,3.4-4.2,5C587.4,304,592,305.4,592,306.9z",
transform:"translate(-304,-156) scale(0.75)"}},dangerPolygon:{data1:{fill:"none",stroke:"#ED2224","stroke-width":2,"stroke-miterlimit":10,points:"591.4,308.6 595.2,311.8 589.4,314.6 592.1,317.9 589.3,320.7 594.2,324.6 595.2,328.2 593.3,331.1 587.7,332.8 586.8,335.8 587.1,339.1 582.6,340.7 581.7,343.5 581.8,346.9 577.7,348.2 582.5,354.4 577.8,355.3 580.5,360.9 575.9,361.5 576.5,366.1 572.8,367.2 570,368.9 565.1,368.5 563,370.7 560.4,372.4 557.9,374.1 557.8,378.9 554.4,379.5 552.7,382.5 549.4,383.1 548.2,387.3 545,388.1 541.3,387.8 539.5,391.4 536.5,392.7 533.7,394.4 529,389.6 526.4,391.8 524.3,396.6 520,390.8 517.8,396.6 514.4,394.9 511.8,401.2 508.4,398.7 505.2,400.1 502.1,393.9 498.8,397.3 495.8,395.1 493.4,390.6 490.1,392.1 487,392.1 484.2,390.8 480.5,392.4 476.5,394.5 474,392.2 470.4,392.4 466.7,392.8 463.9,391 460.8,389.8 458.9,386.6 455.8,385.4 453.5,382.9 454.8,375.8 450.3,376.6 445.1,377.9 442.2,376.2 442.6,371.1 441.1,368.2 441.8,363.5 439.4,361.5 432.7,362.8 435.9,356.7 428.4,357.9 428.4,354.1 427.3,351.1 426.4,348 428.8,343.4 428.9,340.1 420.2,340.2 418.2,337.5 416,334.7 422.8,329.6 420.3,327 419.1,324.1 413.6,321.7 412.8,318.5 416.9,314.9 419.3,311.6 420.4,308.6 419.2,305.5 420,302.5 422.8,299.7 417.2,295.9 423.2,293.8 422.1,290.5 422.7,287.5 417.3,282.8 425.6,282.1 422.9,277.9 423.7,274.8 421.3,270.3 428.2,270 429.6,267.3 433.7,266.1 430.3,260.4 435.8,260.4 432.8,254.4 440.7,256.6 439.5,251.7 439.9,247.8 441.9,245.3 446.8,245.9 447.3,241.8 447.7,237.3 453.1,239.1 452.2,232.4 458.3,235.7 458.7,230.3 464.1,233.3 465.4,229.1 470,231.6 472,228.4 475.6,229.3 477.2,224.5 481.5,228 483.3,223 486.1,221 489.7,223 492.2,218.2 495.7,220.9 498.7,218.5 501.9,218.4 505.2,223.9 508.5,216.2 511.6,218.2 514.2,224.3 518.2,217.8 521.4,218.3 523.7,223.6 527.3,222 531.1,220.2 532.9,225.2 535.9,226.2 538.3,228.6 540.8,230.5 545.6,227.9 546,233.7 547.3,237.6 554.5,231.9 558,232.5 555.9,240.8 562.1,237.9 562.3,242.6 566.9,242.2 570.6,243.1 571.6,246.7 571.8,250.9 574.4,252.7 572.7,258 580.6,256.2 579.4,260.9 577.3,265.8 577.9,268.8 586.5,267.8 584.3,272.4 584.5,275.7 586.6,278.2 588.4,280.8 592.1,283 587.2,287.6 587.4,290.7 593.7,292.6 593.3,295.9 588.1,299.6 593.1,302.3 590,305.5",transform:"translate(-304,-157) scale(0.75)"},data2:{fill:"none",stroke:"#ED2224","stroke-width":1.2,"stroke-miterlimit":10,points:"458.4,379.7 453.1,381.9 452.4,377.5 447.8,378.2 449.8,371.1 442.7,374.2 441.8,370.6 444.1,364.2 435,368.1 433.9,364.7 436.9,358.5 433,357.6 427.2,357.5 426,354.4 426.7,350.3 425,347.6 423.1,345 423.4,341.4 423,338.2 422.6,335.1 422.2,332 419.6,329.4 420.4,326.1 420.1,323 418.3,320.1 416.9,317.1 412.7,314.2 419,310.7 422,307.7 416.5,304.5 422.4,301.8 423.1,298.9 421.7,295.7 416.9,291.7 415.2,288 418.4,285.4 418.9,282.3 423.8,280.5 425,277.7 421,272.7 429.9,273.3 430.4,270.2 425.4,263.9 434.7,265.8 431.4,260.1 432.2,256.8 432.3,252.8 437.5,252.8 440.9,251.7 440.7,247.3 444.6,246.7 448,245.8 446.3,239.2 448.5,236.8 451.3,235.1 456.4,236.7 457.5,232.7 460,230.5 464.3,231.8 466.3,228.9 469.3,227.9 470.9,223.3 476.2,228.3 479.7,229.2 482.3,227.7 484.9,225.4 488,225.6 489.7,217.3 493.7,222.5 496.7,221.1 500.1,225 502.9,218.2 506.1,216.4 509,225.7 512.5,219.6 514.8,226.6 518.6,221.3 522.1,219.9 525.4,219.8 528.7,220.1 530.3,226.2 532.2,230.2 537.4,224.8 541,224.5 543.4,227 543.6,233.8 547.5,233 548,238.1 550.8,239.2 557.8,234.4 561,235.5 560.5,241.4 563.1,243.2 567.8,242.7 568.4,246.7 571,248.6 570,253.6 577.7,251.4 572.7,259.1 577.5,259.5 578.7,262.4 581.9,264.1 586.4,265.3 582,271.1 580.9,274.9 585.8,276.1 584.7,279.9 583.7,283.4 592.1,284 590.6,287.7 588.4,291.4 591.9,293.9 587,297.7 593.3,300 597.7,302.9 594.3,306.3 595.7,309.5 590.7,312.5 588.3,315.4 591.4,318.8 594.8,322.4 592.3,325.2 588.2,327.6 588.7,330.8 589.5,334.3 591.2,338.2 585,339.3 587.4,343.7 587.4,347.2 584.8,349.5 577.3,348.9 576.1,351.7 581,358.5 572.5,356.4 576.4,363.1 572.4,363.9 568.5,364.6 571.8,372 567.6,372.4 563.8,372.9 563.8,377.7 560.2,378.4 554.1,375.5 555.7,383.1 553.6,385.7 549.8,385.7 545.9,385.1 545.4,391.2 540.2,387.5 537.1,388.2 536.4,395.1 531.4,390.4 528.5,391.3 526,394.1 523.8,398.7 520.4,398.4 516.4,393.4 513.7,397.1 510.7,399.5 507.4,397.3 504.2,396.1 501.2,393.5 497.7,399.5 494.9,395.4 491.9,394 489,393.2 485.6,393.9 482.3,394.3 479.6,392.4 475.7,394.1 473,392.1 470.1,390.7 470,383.4 463.7,389.2 464.4,381.4 462.1,379.4",transform:"translate(-304,-157) scale(0.75)"}}},initialize:function(t){e.View.prototype.initialize.apply(this,arguments),this.markerView=t.markerView,this.model=this.markerView.model,this.render()},render:function(){var e=this;!this.rendered&&(this.rendered=!0)&&(this.width=150,this.height=150,this.$el=a("<div></div>"),this.$el.addClass("rfmap"),this.$el.css({position:"absolute",width:this.width+"px",height:this.height+"px","z-index":2}),this.svgContainer=n.select(this.$el.get(0)).append("svg").attr("width",this.width).attr("height",this.height),this.$labels=a('<div class="labels"></div'),this.$el.append(this.$labels),this.$upperLabels=a('<div class="upperLabels"></div'),this.$labels.append(this.$upperLabels),this.$lowerLabels=a('<div class="lowerLabels"></div'),this.$labels.append(this.$lowerLabels),this.$mapToggles=a(".buttonset.mainToggles input"),this.$mapToggles.on("click",this.toggleRfMap.bind(this)),this.$coverageToggle2g=a("#mapFilterCoverage2G"),this.$coverageToggle2g.on("change",function(){e.is2gCoverageEnabled=e.$coverageToggle2g.is(":checked"),e.toggleRfMap(),e.renderComponents()}),this.$coverageToggle5g=a("#mapFilterCoverage5G"),this.$coverageToggle5g.on("change",function(){e.is2gCoverageEnabled=!e.$coverageToggle5g.is(":checked"),e.toggleRfMap(),e.renderComponents()}),this.is2gCoverageEnabled=this.$coverageToggle2g.is(":checked"),this.markerView.$el.before(this.$el),this.markerView.$el.on("drag",function(t,a){e.setPosition(a.position.left,a.position.top)}),this.listenTo(this.model,"change:state",this.renderComponents),this.listenTo(this.model,"change:ng-channel change:na-channel",this.renderChannelLabel),this.listenTo(this.model,"change:ng-tx_power change:na-tx_power change:ng-gain change:na-gain change:ng-eirp change:na-eirp",this.renderTxPowerLabel)),this.toggleRfMap(),this.renderComponents()},renderComponents:function(){this.renderBackgroundCircle(),this.renderChannelLabel(),this.renderBandLabel(),this.renderAntennaLabel(),this.renderTxPowerLabel(),this.renderBackgroundCircleOutline()},toggleRfMap:function(){a("#Map").hasClass("details")&&this.isRfMapSupported()?(this.$el.show(),this.markerView.$el.addClass("withRfMap")):(this.$el.hide(),this.markerView.$el.removeClass("withRfMap"))},isRfMapSupported:function(){return this.model.isConnected()&&(this.is2gCoverageEnabled?this.model.hasRadio("ng"):this.model.hasRadio("na"))?!0:!1},renderBackgroundCircle:function(){this.backgroundCircle&&this.backgroundCircle.remove(),this.backgroundCircle=this.svgContainer.append("g"),this.backgroundCircle.append("circle").attr("cx",75).attr("cy",75).attr("r",60).attr("fill","rgba(80,80,80,0.7)").attr("stroke","rgba(80,80,80,0.85)").attr("stroke-width",1)},renderBackgroundCircleOutlineShape:function(e,a,n){var i=e.append(a);return t.each(n,function(e,t){i.attr(t,e)}),i},renderBackgroundCircleOutline:function(){this.backgroundCircleOutline&&this.backgroundCircleOutline.remove(),this.backgroundCircleOutline=this.svgContainer.append("g"),this.renderBackgroundCircleOutlineShape(this.backgroundCircleOutline,"circle",this.rfMapBorderData.normalCircle)},renderThroughputChart:function(){var e,t=0;this.throughputChart&&this.throughputChart.remove(),this.throughputChart=this.svgContainer.append("g");for(var a=0;8>a;a++)e=a>=8*t?.5:1,this.throughputChart.append("rect").attr("x",47).attr("y",88-4*a).attr("width",5).attr("height",2.75).attr("fill","rgba(255,255,255,"+e+")")},renderThroughputChartLabel:function(){var e="0",t="mbps";this.throughputChartLabel&&this.throughputChartLabel.remove(),this.throughputChartLabel=a("<div></div").addClass("throughputChartLabel"),this.throughputChartLabel.append(a("<div></div>").text(e).addClass("mediumText")),this.throughputChartLabel.append(a("<div></div>").text(t).addClass("smallText")),this.$labels.append(this.throughputChartLabel)},renderUtilizationChart:function(){var e=0;this.utilizationChart&&this.utilizationChart.remove(),this.utilizationChart=this.svgContainer.append("g"),this.utilizationChart.append("rect").attr("x",98).attr("y",60).attr("width",5).attr("height",30*(1-e)).attr("fill","rgba(255,255,255,0.5)"),this.utilizationChart.append("rect").attr("x",98).attr("y",60+32*(1-e)).attr("width",5).attr("height",30*e).attr("fill","rgba(255,255,255,1)")},renderUtilizationChartLabel:function(){var e="0",t="%";this.utilizationChartLabel&&this.utilizationChartLabel.remove(),this.utilizationChartLabel=a("<div></div").addClass("utilizationChartLabel"),this.utilizationChartLabel.append(a("<span></span>").text(e).addClass("mediumText")),this.utilizationChartLabel.append(a("<span></span>").text(t).addClass("smallText")),this.$labels.append(this.utilizationChartLabel)},renderChannelLabel:function(){var e="ch",t=this.is2gCoverageEnabled?this.model.channel("ng"):this.model.channel("na");this.channelLabel&&this.channelLabel.remove(),this.channelLabel=a("<div></div").addClass("channelLabel"),this.channelLabel.append(a("<span></span>").text(e).addClass("smallText")),this.channelLabel.append(a("<span></span>").text(t).addClass("mediumText")),this.$upperLabels.append(this.channelLabel)},renderAntennaLabel:function(){var e=this.is2gCoverageEnabled?this.model.getNss("ng"):this.model.getNss("na"),t=e,n=e;e&&(this.antennaLabel&&this.antennaLabel.remove(),this.antennaLabel=a("<div></div").addClass("antennaLabel"),this.antennaLabel.append(a("<span></span>").text(t).addClass("mediumText")),this.antennaLabel.append(a("<span></span>").text("x").addClass("smallText")),this.antennaLabel.append(a("<span></span>").text(n).addClass("mediumText")),this.$lowerLabels.append(this.antennaLabel))},renderBandLabel:function(){var e="11",t=this.is2gCoverageEnabled?"n/b/g":this.model.is11ac()?"n/a/ac":"n/a";this.bandLabel&&this.bandLabel.remove(),t&&(this.bandLabel=a("<div></div").addClass("bandLabel"),this.bandLabel.append(a("<span></span>").text(e).addClass("smallText")),this.bandLabel.append(a("<span></span>").text(t).addClass("mediumText")),this.$lowerLabels.append(this.bandLabel))},renderTxPowerLabel:function(){var e=this.is2gCoverageEnabled?this.model.transmitPower("ng"):this.model.transmitPower("na"),t="dbm";this.txPowerLabel&&this.txPowerLabel.remove(),e&&(this.txPowerLabel=a("<div></div").addClass("txPowerLabel"),this.txPowerLabel.append(a("<span></span>").text(e).addClass("mediumText")),this.txPowerLabel.append(a("<span></span>").text(t).addClass("smallText")),this.$upperLabels.append(this.txPowerLabel))},setPosition:function(e,t){this.$el.css({left:e-75,top:t-75})},remove:function(){e.View.prototype.remove.apply(this,arguments)}})}),define("ubnt/view/map/GoogleMapMarkerWrapperView",["unifi/view/map/MarkerRfMapView"],function(e){"use strict";return{Overlay:function(e,t){return this.markerView=e,this},initialize:function(){this.Overlay.prototype=new google.maps.OverlayView,this.Overlay.prototype.onAdd=function(){var e=this.getPanes();e.floatPane.appendChild(this.markerView.$el.get(0))},this.Overlay.prototype.onRemove=function(){this.markerView.$el.hide()},this.Overlay.prototype.draw=function(){var t=this.getProjection(),a=t.fromLatLngToDivPixel(new google.maps.LatLng(this.markerView.model.get("x"),this.markerView.model.get("y")));this.markerView.$el.css("position","absolute"),this.markerView.$el.css("top",a.y+"px"),this.markerView.$el.css("left",a.x+"px"),this.markerView.$el.show(),!this.markerView.rfMap&&this.markerView.$el.parent().size()&&this.markerView.model.get("type")==this.markerView.model.typeMap.ap&&(this.markerView.rfMap=new e({markerView:this.markerView})),this.markerView.rfMap&&this.markerView.rfMap.setPosition(a.x,a.y)},this.Overlay.prototype.hide=function(){this.container.hide()},this.Overlay.prototype.show=function(){this.draw(),this.container.show()},this.Overlay.prototype.toggle=function(){this.container.toggle()}}}}),define("async",[],function(){function e(e){var t,a;t=document.createElement("script"),t.type="text/javascript",t.async=!0,t.src=e,a=document.getElementsByTagName("script")[0],a.parentNode.insertBefore(t,a)}function t(e,t){var a=/!(.+)/,i=e.replace(a,""),o=a.test(e)?e.replace(/.+!/,""):n;return i+=i.indexOf("?")<0?"?":"&",i+o+"="+t}function a(){return i+=1,"__async_req_"+i+"__"}var n="callback",i=0;return{load:function(n,i,o,r){if(r.isBuild)o(null);else{var s=a();window[s]=o,e(t(n,s))}}}}),define("gmaps",["jquery"],function(e){"use strict";if(window.google&&window.google.maps)return window.google;var t=e.Deferred();return require(["async!//maps.google.com/maps/api/js?libraries=geometry&sensor=false!callback"],function(){t.resolve(window.google)},function(e){window.googleMapsNotLoaded(),t.reject()}),t.promise()}),define("ubnt/view/map/GoogleMapView",["underscore","ubnt/view/map/MapBase","ubnt/view/map/GoogleMapOverlayWrapperView","ubnt/view/map/GoogleMapMarkerWrapperView","ubnt/Timer","ubnt/TimerEvent","jquery","msg/Msg","gmaps"],function(e,t,a,n,i,o,r,s,c){"use strict";return t.extend({_fullyQualifiedName:"UBNT.views.map.GoogleMap",initialize:function(a){e.bindAll(this),this.app=a.app,this.loaded=!1,c.maps?r("body").hasClass("googlemaps-notLoaded")||(this.loaded=!0):c.done(r.proxy(function(e){c=e,this.onLoad()},this)).fail(function(){r("body").addClass("googlemaps-notLoaded")}),this.mapBaseType="google",t.prototype.initialize.apply(this,[a]),this.markerViewOverlays={},this.layerItemOverlays={},this.layerQueue=[]},onLoad:function(){this.loaded=!0,n.initialize(),a.initialize(),this.trigger("googlemaps-loaded")},setMap:function(e){this.model&&(this.model.off("change:zoom",this.mapZoomHandler),this.model.off("change:lat",this.mapOffsetHandler),this.model.off("change:lng",this.mapOffsetHandler),this.model.off("change:mapTypeId",this.mapTypeHandler)),this.model=e,this.model.on("change:zoom",this.mapZoomHandler),this.model.on("change:lat",this.mapOffsetHandler),this.model.on("change:lng",this.mapOffsetHandler),this.model.on("change:mapTypeId",this.mapTypeHandler),this.zoomLevel=this.model.get("zoom"),r("body").hasClass("googlemaps-notLoaded")?window.googleMapsNotLoaded():this.renderMap()},mapChangeHandler:function(){this.renderMap()},getMap:function(){return this.model},render:function(){return this.model&&this.setOffset(this.model.get("lat")||0,this.model.get("lng")||0,!0),this.$el},renderMap:function(){if(!this.loaded)return this.renderOnLoad=!0;this.calculateScale();var t=this,a={zoom:this.model?this.model.get("zoom"):1,center:new c.maps.LatLng(this.model.get("lat"),this.model.get("lng")),mapTypeId:c.maps.MapTypeId[this.model.get("mapTypeId").toUpperCase()],tilt:0,disableDoubleClickZoom:!0,zoomControl:!1,streetViewControl:!1,panControl:!1,scaleControl:!0};this.googleMap?this.googleMap.setOptions(a):(this.googleMap=new c.maps.Map(this.$el.get(0),a),c.maps.event.addListener(this.googleMap,"zoom_changed",function(){var e=t.googleMap.getZoom();e>20&&(e=20),1>e&&(e=1),t.setZoom(e)}),c.maps.event.addListener(this.googleMap,"center_changed",function(){t.setOffset(t.googleMap.center.lat(),t.googleMap.center.lng())}),c.maps.event.addListener(this.googleMap,"maptypeid_changed",function(){t.setMapType(t.googleMap.getMapTypeId())}),this.googleMapOverlay=new c.maps.OverlayView,this.googleMapOverlay.onAdd=function(){},this.googleMapOverlay.draw=function(){},this.googleMapOverlay.onRemove=function(){},this.googleMapOverlay.setMap(this.googleMap),e.each(this.layerQueue,function(e){this.layers[e.cid]=e,e.bindHandlers()},this),this.layerQueue=[],this.loaded=!0),this.previousMapZoom=a.zoom,this.googleMapOverlay&&this.resetMarkers()},addLayer:function(t,a){var n=e.extend(a,{mapBase:this}),i=new t(n);null===this.googleMap||void 0===this.googleMap?this.layerQueue.push(i):this.layers[i.cid]=t},addLayerItem:function(e){if(this.googleMap){var t=new a.Overlay(e,this.googleMap);t.setMap(this.googleMap),this.layerItems[e.cid]=e,this.layerItemOverlays[e.cid]=t,e.$el.css("zIndex",this.layerZ),this.layerZ++,e.trigger("layeritemadded")}},removeLayerItem:function(e){var t=this.layerItemOverlays[e.cid];t&&t.setMap(null)},positionMarker:function(e){this.googleMap&&this.markerViewOverlays[e.model.id]&&(e.model.attributes.map_id==this.model.id?this.markerViewOverlays[e.model.id].setMap(this.googleMap):this.markerViewOverlays[e.model.id].setMap(null))},updateMarkerPositions:function(){e.each(this.markerViews,this.positionMarker)},addMarker:function(e){t.prototype.addMarker.apply(this,[e,this.model]);var a=this.markerViews[e.id];if(a){(null===this.markerViewOverlays[e.id]||void 0===this.markerViewOverlays[e.id])&&(this.markerViewOverlays[e.id]=new n.Overlay(a,this.googleMap));var i=this.markerViewOverlays[e.id];this.model&&this.model.id==e.attributes.map_id&&i.setMap(this.googleMap),a.unbind("dragstart",this.markerDragStartHandler).bind("dragstart",this.markerDragStartHandler),a.unbind("dragstop",this.markerDragStopHandler).bind("dragstop",this.markerDragStopHandler)}},updateMarker:function(e){void 0!==e.get("map_id")&&(this.model&&e.get("map_id")==this.model.id?this.addMarker(e):this.removeMarker(e))},removeMarker:function(e){this.markerViewOverlays[e.id];this.markerViewOverlays[e.id]&&(this.markerViewOverlays[e.id].setMap(null),delete this.markerViewOverlays[e.id]),t.prototype.removeMarker.apply(this,[e])},resize:function(){this.loaded&&this.googleMap&&c.maps.event.trigger(this.googleMap,"resize")},markerDragStartHandler:function(){this.isMarkerDragging=!0,this.disableMapDrag()},markerDragStopHandler:function(e,t){if(this.isMarkerDragging=!1,this.enableMapDrag(),t&&t.position){var a=this.googleMapOverlay.getProjection().fromDivPixelToLatLng(new c.maps.Point(t.position.left,t.position.top)),n=t.helper.data("view"),i=n.model;this.app.isReadOnly?i.set({x:Number(a.lat().toFixed(5)),y:Number(a.lng().toFixed(5))}):i.save({x:Number(a.lat().toFixed(5)),y:Number(a.lng().toFixed(5))})}},dropHandler:function(e,t){var a=this.googleMapOverlay.getProjection().fromContainerPixelToLatLng(new c.maps.Point(t.position.left,t.position.top-42)),n=t.helper.data("view"),i=n.model;this.app.isReadOnly?i.set({x:Number(a.lat().toFixed(5)),y:Number(a.lng().toFixed(5)),map_id:this.model.id}):i.save({x:Number(a.lat().toFixed(5)),y:Number(a.lng().toFixed(5)),map_id:this.model.id})},enableMapDrag:function(){this.googleMap&&this.googleMap.setOptions({draggable:!0})},disableMapDrag:function(){this.googleMap&&this.googleMap.setOptions({draggable:!1})},calculateScale:function(){this.scale=1/Math.pow(2,20-this.zoomLevel)/5},mapTypeHandler:function(e){this.setMapType(e.get("mapTypeId"),!0)},setMapType:function(e,t){this.model.set({mapTypeId:e}),t||this.app.isReadOnly||this.saveMapType(e)},saveMapType:e.debounce(function(e){this.model.unset("mapTypeId",{silent:!0}),this.model.save({mapTypeId:e},{silent:!0})},250),mapOffsetHandler:function(e){this.setOffset(e.get("lat")||0,e.get("lng")||0,!0)},setOffset:function(e,t,a){this.model.set({lat:e,lng:t}),a||this.app.isReadOnly||this.saveOffset(e,t)},saveOffset:e.debounce(function(e,t){this.model.unset("lat",{silent:!0}),this.model.unset("lng",{silent:!0}),this.model.save({lat:e,lng:t},{silent:!0})},250),mapZoomHandler:function(e){this.setZoom(e.get("zoom")||this.zoomLevel,!0),this.renderMap(),this.updateMarkerPositions()},setZoom:function(e,t){this.zoomLevel!=e&&(this.zoomLevel=e,this.model.set({zoom:e}),t||this.app.isReadOnly||this.saveZoom(e))},saveZoom:e.debounce(function(e){this.model.unset("zoom",{silent:!0}),this.model.save({zoom:e},{silent:!0})},250),computeDistanceBetween:function(e,t,a,n){var i=this.googleMapOverlay.getProjection().fromDivPixelToLatLng(new c.maps.Point(e,t)),o=this.googleMapOverlay.getProjection().fromDivPixelToLatLng(new c.maps.Point(a,n));return c.maps.geometry.spherical.computeDistanceBetween(i,o)},computeOffset:function(e,t,a,n){var i=this.googleMapOverlay.getProjection().fromDivPixelToLatLng(new c.maps.Point(e,t)),o=c.maps.geometry.spherical.computeOffset(i,a,(n+Math.PI)*(180/Math.PI)),r=this.googleMapOverlay.getProjection().fromLatLngToDivPixel(o);return{x:Math.round(r.x),y:Math.round(r.y)}},translateToPixelCoordinates:function(e,t){var a=this.googleMapOverlay.getProjection().fromLatLngToDivPixel(new c.maps.LatLng(e,t));return a},translateToMapCoordinates:function(e,t){var a=this.googleMapOverlay.getProjection().fromDivPixelToLatLng(new c.maps.Point(e,t));return{x:a.lat(),y:a.lng()}},remove:function(){this.model.off("change",this.mapChangeHandler),e.each(this.markerViews,function(e){e.unbind("dragstart",this.markerDragStartHandler),e.unbind("dragstop",this.markerDragStopHandler)},this),this.googleMap&&(c.maps.event.removeListener(this.googleMap,"zoom_changed"),c.maps.event.removeListener(this.googleMap,"center_changed"),c.maps.event.removeListener(this.googleMap,"bounds_changed"),c.maps.event.removeListener(this.googleMap,"maptypeid_changed")),this.model&&(this.model.off("change:zoom",this.mapZoomHandler),this.model.off("change:lat",this.mapOffsetHandler),this.model.off("change:lng",this.mapOffsetHandler),this.model.off("change:mapTypeId",this.mapTypeHandler)),t.prototype.remove.apply(this,arguments)}})}),function(e){"function"==typeof define&&define.amd?define("libs/jquery.mousewheel",["jquery"],e):"object"==typeof exports?module.exports=e:e(jQuery)}(function(e){function t(t){var o=t||window.event,r=s.call(arguments,1),c=0,d=0,l=0,m=0;return t=e.event.fix(o),t.type="mousewheel","detail"in o&&(l=-1*o.detail),"wheelDelta"in o&&(l=o.wheelDelta),"wheelDeltaY"in o&&(l=o.wheelDeltaY),"wheelDeltaX"in o&&(d=-1*o.wheelDeltaX),"axis"in o&&o.axis===o.HORIZONTAL_AXIS&&(d=-1*l,l=0),c=0===l?d:l,"deltaY"in o&&(l=-1*o.deltaY,c=l),"deltaX"in o&&(d=o.deltaX,0===l&&(c=-1*d)),0!==l||0!==d?(m=Math.max(Math.abs(l),Math.abs(d)),(!i||i>m)&&(i=m),c=Math[c>=1?"floor":"ceil"](c/i),d=Math[d>=1?"floor":"ceil"](d/i),l=Math[l>=1?"floor":"ceil"](l/i),t.deltaX=d,t.deltaY=l,t.deltaFactor=i,r.unshift(t,c,d,l),n&&clearTimeout(n),n=setTimeout(a,200),(e.event.dispatch||e.event.handle).apply(this,r)):void 0}function a(){i=null}var n,i,o=["wheel","mousewheel","DOMMouseScroll","MozMousePixelScroll"],r="onwheel"in document||document.documentMode>=9?["wheel"]:["mousewheel","DomMouseScroll","MozMousePixelScroll"],s=Array.prototype.slice;if(e.event.fixHooks)for(var c=o.length;c;)e.event.fixHooks[o[--c]]=e.event.mouseHooks;e.event.special.mousewheel={version:"3.1.6",setup:function(){if(this.addEventListener)for(var e=r.length;e;)this.addEventListener(r[--e],t,!1);else this.onmousewheel=t},teardown:function(){if(this.removeEventListener)for(var e=r.length;e;)this.removeEventListener(r[--e],t,!1);else this.onmousewheel=null}},e.fn.extend({mousewheel:function(e){return e?this.bind("mousewheel",e):this.trigger("mousewheel")},unmousewheel:function(e){return this.unbind("mousewheel",e)}})}),define("ubnt/view/map/ImageMapView",["ubnt/view/map/MapBase","underscore","jquery","unifi/webrtc/WebRtcHelpers","config/ManageConfig","unifi/view/map/MarkerRfMapView","libs/jquery.mousewheel"],function(e,t,a,n,i,o){"use strict";return e.extend({_fullyQualifiedName:"UBNT.views.map.ImageMap",initialize:function(a){t.bindAll(this),this.mapBaseType="image",this.app=a.app,e.prototype.initialize.apply(this,[a]),this.zoom=1,this.scale=1,this.$dragLayer=this.$(".image-drag-layer"),this.$subMarkerLayer=this.$(".sub-marker-layer"),this.$markerLayer=this.$(".marker-layer"),this.mapImages=[],this.initHandlers()},initHandlers:function(){this.$el.bind("mousedown",this.mouseDownHandler),this.$el.bind("mousewheel",this.mouseWheelHandler)},setMap:function(e){if(this.model&&(this.model.off("change:zoom",this.mapZoomHandler),this.model.off("change:offset_left",this.mapOffsetHandler),this.model.off("change:offset_right",this.mapOffsetHandler),this.model.off("change:url",this.loadMap)),this.model=e,this.$img=this.mapImages[this.model.id],this.$(".image-map-layer").empty(),void 0===this.$img)this.loadMap();else{var t=this.$el.width(),a=this.$el.height();this.imgWidth=this.$img[0].width,this.imgHeight=this.$img[0].height,this.scale=1,this.imgWidth/this.imgHeight>t/a?(this.$img.height(t/this.imgWidth*this.imgHeight),this.$img.width(t)):(this.$img.width(a/this.imgHeight*this.imgWidth),this.$img.height(a)),this.$dragLayer.css("top",(a-this.imgHeight)/2+"px"),this.$dragLayer.css("left",(t-this.imgWidth)/2+"px"),this.$(".image-map-layer").append(this.$img),this.resetMarkers(),this.model.on("change:zoom",this.mapZoomHandler),this.model.on("change:offset_left",this.mapOffsetHandler),this.model.on("change:offset_right",this.mapOffsetHandler),this.model.on("change:url",this.loadMap),this.mapZoomHandler(this.model),this.mapOffsetHandler(this.model)}},mapZoomHandler:function(e){this.setZoom(e.get("zoom"),!0)},mapOffsetHandler:function(e){this.setOffset(e.get("offset_top")||0,e.get("offset_left")||0,!0)},loadMap:function(e,t,o){var r=this;this.$img=a(new Image),this.$img.load(function(){r.mapImages=[],r.mapImages[r.model.id]=a(this),r.$img.unbind("load"),r.setMap(r.model)}),i.USE_WEBRTC?a.ajax({type:"GET",dataType:"arraybuffer",processData:!1,xhrFields:{withCredentials:!0},url:r.model.get("url"),success:function(e){r.$img.attr("src","data:image;base64,"+btoa(n.Uint8ArrayToBinaryString(e)))},error:function(){console.log("error!")}}):this.$img.attr("src",this.model.get("url"))},render:function(){return this.updateMarkerPositions(),this.model&&this.setOffset(this.model.get("offset_top")||0,this.model.get("offset_left")||0,!0),this.$el},preventEventPropagationFunc:function(e){e.stopPropagation()},addMarker:function(t){e.prototype.addMarker.apply(this,[t,this.model]);var a=this.markerViews[t.id];a&&(a.$el.unbind("mousedown",this.preventEventPropagationFunc).bind("mousedown",this.preventEventPropagationFunc),a.unbind("dragstart",this.markerDragStartHandler).bind("dragstart",this.markerDragStartHandler),a.unbind("dragstop",this.markerDragStopHandler).bind("dragstop",this.markerDragStopHandler),this.positionMarker(a),this.$markerLayer.append(a.$el))},updateMarker:function(e){void 0!==e.get("map_id")&&(this.model&&e.get("map_id")==this.model.id?this.addMarker(e):this.removeMarker(e))},positionMarker:function(e){if(this.model&&e.model.attributes.map_id==this.model.id){var t=e.model.get("x")*this.zoom,a=e.model.get("y")*this.zoom;e.setPosition(t,a),e.show(),!e.rfMap&&e.$el.parent().size()&&e.model.get("type")==e.model.typeMap.ap&&(e.rfMap=new o({markerView:e})),e.rfMap&&e.rfMap.setPosition(t,a)}else e.hide()},updateMarkerPositions:function(){t.each(this.markerViews,this.positionMarker)},addLayer:function(e,a){var n=t.extend(a,{mapBase:this}),i=new e(n);this.layers[i.cid]=i},addLayerItem:function(e){this.$subMarkerLayer.append(e.$el),e.trigger("layeritemadded")},removeLayerItem:function(e){e.$el.remove()},markerDragStartHandler:function(e){this.isMarkerDragging=!0},markerDragStopHandler:function(e,t){if(this.isMarkerDragging=!1,t&&t.helper){var a=t.helper.data("view"),n=a.model;this.app.isReadOnly?n.set({x:t.position.left/this.zoom,y:t.position.top/this.zoom}):n.save({x:t.position.left/this.zoom,y:t.position.top/this.zoom})}},mouseDownHandler:function(e){return 2==e.button?(e.preventDefault(),e.stopPropagation(),!1):(this.startPageX=e.pageX,this.startPageY=e.pageY,a("body").bind("mouseup",this.mouseUpHandler),this.$el.bind("mousemove",this.mouseMoveHandler),!1)},mouseWheelHandler:function(e,t,a,n){},mouseUpHandler:function(){a("body").unbind("mouseup",this.mouseUpHandler),this.$el.unbind("mousemove",this.mouseMoveHandler)},mouseMoveHandler:function(e){if(!this.isMarkerDragging){this.deltaX=e.pageX-this.startPageX,this.deltaY=e.pageY-this.startPageY,this.startPageX=e.pageX,this.startPageY=e.pageY;var t=this.$dragLayer.offset(),a=t.top+this.deltaY,n=t.left+this.deltaX;this.setOffset(a,n)}},clickHandler:function(e){var t=a(e.target);t.hasClass("phone-icon")&&(t.parent().css("z-index",this.currentZIndex),this.currentZIndex++)},dropHandler:function(e,t){var a=t.helper.data("view"),n=a.model,i=this.$dragLayer.position(),o=(t.position.left-i.left)/this.zoom,r=(t.position.top-i.top-42)/this.zoom;this.app.isReadOnly?n.set({x:o,y:r,map_id:this.model.id}):n.save({x:o,y:r,map_id:this.model.id})},setOffset:function(e,t,a){this.$dragLayer.offset({top:e,left:t}),this.model.set({offset_top:e,offset_left:t}),a||this.app.isReadOnly||this.saveOffset(e,t)},saveOffset:t.debounce(function(e,t){this.model.unset("offset_top",{silent:!0}),this.model.unset("offset_left",{silent:!0}),this.model.save({offset_top:e,offset_left:t},{silent:!0})},250),setZoom:function(e){this.$dragLayer.position(),this.$el.width(),this.$el.height();this.zoom=e/10,this.$img.width(this.scale*this.imgWidth*this.zoom),this.$img.height(this.scale*this.imgHeight*this.zoom),this.updateMarkerPositions()},setFocus:function(e,t,a){var n=this.translateToPixelCoordinates(e,t),i=this.$el.width(),o=this.$el.height(),r=i/2-n.x,s=o/2-n.y;a||(this.$dragLayer.css("top",s+"px"),this.$dragLayer.css("left",r+"px"))},enableMapDrag:function(){this.$el.on("mousedown",this.mouseDownHandler)},disableMapDrag:function(){this.$el.off("mousedown",this.mouseDownHandler)},translateToPixelCoordinates:function(e,t){return{x:e*this.scale*this.zoom,y:t*this.scale*this.zoom}},translateToMapCoordinates:function(e,t){return{x:e/this.scale/this.zoom,y:t/this.scale/this.zoom}},computeOffset:function(e,t,a,n){return{x:e+Math.sin(n)*(a*this.scale*this.zoom),y:t-Math.cos(n)*(a*this.scale*this.zoom)}},computeDistanceBetween:function(e,t,a,n){var i=this.translateToMapCoordinates(e,t),o=this.translateToMapCoordinates(a,n);return Math.sqrt((o.x-i.x)*(o.x-i.x)+(o.y-i.y)*(o.y-i.y))},remove:function(){this.$el.unbind("mousedown",this.mouseDownHandler),this.$el.unbind("mousewheel",this.mouseWheelHandler),t.each(this.markerViews,function(e){e.$el.unbind("mousedown"),e.unbind("dragstart",this.markerDragStartHandler),e.unbind("dragstop",this.markerDragStopHandler)},this),a("body").unbind("mouseup",this.mouseUpHandler),this.$el.unbind("mousemove",this.mouseMoveHandler),this.$el.off("mousedown",this.mouseDownHandler),this.model&&(this.model.off("change:zoom",this.mapZoomHandler),this.model.off("change:offset_left",this.mapOffsetHandler),this.model.off("change:offset_right",this.mapOffsetHandler),this.model.off("change:url",this.loadMap)),e.prototype.remove.apply(this,arguments)}})}),define("ubnt/view/uicomponents/DroppableItemView",["backbone","jquery"],function(e,t){"use strict";return e.View.extend({_fullyQualifiedName:"UBNT.views.uicomponents.DroppableItem",initialize:function(){this.scope=this.options.scope||"global",this.accept=this.options.accept,this.drop=this.options.drop,this._greedy=this.options.greedy||!0;var e=this;this.$el.droppable({tolerance:"pointer",accept:this.accept,greedy:this._greedy,activeClass:"droppable",drop:function(a,n){t(this).removeClass("ui-state-highlight"),e.trigger("drop",a,n)},over:function(a,n){t(this).addClass("ui-state-highlight"),e.trigger("over",a,n)},out:function(a,n){t(this).removeClass("ui-state-highlight"),e.trigger("out",a,n)}})},destroy:function(){this.$el.droppable("destroy")},setScope:function(e){this.$el.droppable("option","scope",e)},setAccept:function(e){this.$el.droppable("option","accept",e)}})}),define("ubnt/view/map/MapWidgetView",["backbone","jquery","underscore","ubnt/view/map/MarkerView","ubnt/view/map/GoogleMapView","ubnt/view/map/ImageMapView","ubnt/view/uicomponents/DroppableItemView","libs/jquery.mousewheel"],function(e,t,a,n,i,o,r){"use strict";return e.View.extend({_fullyQualifiedName:"UBNT.views.map.MapWidget",initialize:function(){a.bindAll(this),this.markerView=this.options.markerView||n,this.markerTemplate=this.options.markerTemplate,this.layers={},this.maps=this.options.maps,this.markers=this.options.markers,this.app=this.options.app,this.zoomLevel=1,this.$googleMapContainer=this.$(".google-map-container"),this.googleMap=new i({
app:this.app,el:this.$googleMapContainer,collection:this.maps,markers:this.markers,markerView:this.markerView,markerTemplate:this.markerTemplate}),this.$imageMapContainer=this.$(".image-map-container"),this.imageMap=new o({app:this.app,el:this.$imageMapContainer,collection:this.maps,markers:this.markers,markerView:this.markerView,markerTemplate:this.markerTemplate}),this.initHandlers(),this.initDroppable()},initHandlers:function(){this.$el.bind("mousewheel",this.mouseWheelHandler)},bindHandlers:function(){this.googleMap.bindHandlers(),this.imageMap.bindHandlers()},unbindHandlers:function(){this.googleMap.unbindHandlers(),this.imageMap.unbindHandlers()},render:function(){this.$googleMap=this.googleMap.render(),this.$imageMap=this.imageMap.render(),this.isRendered||(this.isRendered=!0)},locateDevice:function(e){if(this.isRendered){if(this.markers.get(e)&&this.model.id==e.get("map_id")){var t;if(t="googleMap"===this.model.get("type")?this.googleMap.markerViews[e.id]:this.imageMap.markerViews[e.id]){if("imageMap"===this.model.get("type")){var n=t.$el.position(),i=this.imageMap.translateToMapCoordinates(n.left,n.top);this.imageMap.setFocus(i.x,i.y)}t.pulse()}else a.delay(this.locateDevice,50,e)}}else a.delay(this.locateDevice,50,e)},addLayer:function(e,t){this.googleMap.addLayer(e,t),this.imageMap.addLayer(e,t)},setMap:function(e){e&&(this.model&&this.model.off("change:type",this.setMap),this.model=e,this.model.on("change:type",this.setMap),"googleMap"===e.get("type")?(this.googleMap.show(),this.googleMap.setMap(e),this.imageMap.hide(),t("#Map").addClass("isGoogleMap")):(this.imageMap.show(),this.imageMap.setMap(e),this.googleMap.hide(),t("#Map").removeClass("isGoogleMap")),this.zoomLevel=e.get("zoom"))},initDroppable:function(){this.droppable=new r({el:this.el,accept:".unplaced-marker"}),this.droppable.bind("drop",this.dropHandler)},dropHandler:function(e,t){"googleMap"==this.model.attributes.type?this.googleMap.dropHandler(e,t):this.imageMap.dropHandler(e,t)},mouseWheelHandler:function(e,t,a,n){n=n||e.originalEvent.wheelDeltaY;var i=this.zoomLevel;if(n>0){if(!(this.zoomLevel<20))return;i+=1}else{if(!(this.zoomLevel>1))return;i-=1}this.setZoom(i)},setZoom:function(e,t){this.zoomLevel!=e&&(this.zoomLevel=e,this.model.set({zoom:e}),t||this.app.isReadOnly||this.saveZoom(e))},saveZoom:a.debounce(function(e){this.model.unset("zoom",{silent:!0}),this.model.save({zoom:e},{silent:!0})},250),resize:function(){this.imageMap&&this.imageMap.resize(),this.googleMap&&this.googleMap.resize()},remove:function(){this.unbindHandlers(),this.model.off("change:type",this.setMap),this.$el.unbind("mousewheel",this.mouseWheelHandler),this.droppable.unbind("drop",this.dropHandler),this.model.off("change:type",this.setMap),this.isRendered=!1,e.View.prototype.remove.apply(this,arguments)}})}),define("ubnt/view/map/MapView",["backbone","underscore","jquery","ubnt/view/map/MapWidgetView","msg/Msg","libs/jquery.cookie"],function(e,t,a,n,i){"use strict";return e.View.extend({_fullyQualifiedName:"UBNT.views.map.Map",initialize:function(){this.markers=this.options.markers,this.maps=this.options.maps,this.markerView=this.options.markerView,this.markerTemplate=this.options.markerTemplate,this.app=this.options.app,this.mapWidget=new n({app:this.app,el:this.$(".ubnt-map-widget"),maps:this.maps,markers:this.markers,markerView:this.markerView,markerTemplate:this.markerTemplate})},setMap:function(e){this.model=e,this.mapWidget.setMap(e)},tabShowHandler:function(e,t){a("#Map:visible").length?(this.visible=!0,this.mapWidget.resize()):this.visible===!0&&(this.visible=!1)},render:function(){!this.rendered&&(this.rendered=!0)&&this.mapWidget.bindHandlers(),this.mapWidget.render(),this.tabShowHandler()},locateDevice:function(e){this.rendered?this.markers.get(e)&&this.mapWidget.locateDevice(e):t.delay(this.locateDevice,50,e)},remove:function(){this.rendered=!1,e.View.prototype.remove.apply(this,arguments)}})}),define("unifi/view/map/TopologyView",["backbone","underscore","jquery","libs/kinetic"],function(e,t,a,n){"use strict";return e.View.extend({LINK_COLOR:[{value:45,color:"#57c23e"},{value:30,color:"#f78100"},{value:20,color:"#ff0000"}],DISCONNECTED_COLOR:"#CCCCCC",initialize:function(e){t.bindAll(this),this.indexView=e.indexView,this.markers=this.indexView.app.collection("Devices"),this.linkLines=[],this.isMoving=!1,this.isVisible=!1},setMap:function(e){this.model&&(this.model.off("change:zoom",this.mapChangeHandler),this.model.off("change:offset_left",this.mapChangeHandler),this.model.off("change:offset_top",this.mapChangeHandler),this.model.off("change:lng",this.mapChangeHandler),this.model.off("change:lat",this.mapChangeHandler),this.model.off("change:upp",this.mapChangeHandler),this.model.off("change:unit",this.mapChangeHandler)),this.model=e,this.isVisible&&this.rebuildUplinks(),this.model.on("change:zoom",this.mapChangeHandler),this.model.on("change:offset_left",this.mapChangeHandler),this.model.on("change:offset_top",this.mapChangeHandler),this.model.on("change:lng",this.mapChangeHandler),this.model.on("change:lat",this.mapChangeHandler),this.model.on("change:upp",this.mapChangeHandler),this.model.on("change:unit",this.mapChangeHandler),this.mapChangeHandler()},bindListeners:function(){this.markers.on("add",this.mapChangeHandler),this.markers.on("remove",this.mapChangeHandler),this.markers.on("change:map_id",this.mapChangeHandler),this.markers.on("change:x",this.mapChangeHandler),this.markers.on("change:y",this.mapChangeHandler)},unbindListeners:function(){this.markers.off("add",this.mapChangeHandler),this.markers.off("remove",this.mapChangeHandler),this.markers.off("change:map_id",this.mapChangeHandler),this.markers.off("change:x",this.mapChangeHandler),this.markers.off("change:y",this.mapChangeHandler)},mapChangeHandler:function(){this.isVisible&&this.rebuildUplinks()},show:function(){this.isVisible||(this.isVisible=!0,this.bindListeners(),this.setupStage(),this.rebuildUplinks(),this.markers.on("change",this.rebuildUplinks))},hide:function(){this.isVisible&&(this.isVisible=!1,this.unbindListeners(),this.markers.off("change",this.rebuildUplinks),this.destroyStage())},setupStage:function(){var e=a(".marker-layer");this.layer=new n.Layer,this.stage=new n.Stage({container:e[0],width:e.width(),height:e.parent().height()}),this.stage.add(this.layer)},destroyStage:function(){this.layer&&(this.layer.destroy(),this.stage.destroy())},getMarkerPosition:function(e){var t=this.markers.get(e),a=this.model.get("zoom");if("googleMap"===this.model.get("type")){var n=this.indexView.getActiveMap().googleMapOverlay.getProjection(),i=n.fromLatLngToDivPixel(new google.maps.LatLng(t.get("x"),t.get("y")));return{left:i.x,top:i.y}}return{left:t.get("x")*a/10,top:t.get("y")*a/10}},rebuildUplinks:function(){if("googleMap"!==this.model.get("type")){var e,a,n;this.model&&(e=this.markers.filter(function(e){return e.get("map_id")===this.model.get("_id")},this),t.each(this.linkLines,function(e){e.line.destroy()}),this.linkLines=[],this.layer.removeChildren(),t.each(e,function(e){a=e.uplinks(),t.each(a,function(t){t.configured&&(n=this.markers.findWhere({mac:t.mac}),n&&n.get("map_id")===this.model.get("_id")&&this.setTopologyLink(e,n,t))},this)},this))}},setTopologyLink:function(e,a,n){var i,o,r,s=.8,c=this.getMarkerPosition(e.id),d=this.getMarkerPosition(a.id);n.configured?(n.up?(i=!0,o=this.LINK_COLOR[0].color,t.each(this.LINK_COLOR,function(e){n.rssi<e.value&&(o=e.color)},this)):(i=!0,o=this.DISCONNECTED_COLOR),s=1):s=.25,r=this._createLine(c.left,c.top,d.left,d.top,o,s),this.linkLines.push({line:r,islandDevice:e,uplinkDevice:a}),this.layer.add(r),this.layer.drawScene()},_createLine:function(e,t,a,i,o,r){var s=new n.Line({points:this._getArrowPoints(e,t,a,i),stroke:o,opacity:r,dashArray:[10,10]});return s},_getArrowPoints:function(e,t,a,n){return[e,t,a,n]},remove:function(){this.unbindListeners(),this.model.off("change:zoom",this.mapChangeHandler),this.model.off("change:offset_left",this.mapChangeHandler),this.model.off("change:offset_top",this.mapChangeHandler),this.model.off("change:lng",this.mapChangeHandler),this.model.off("change:lat",this.mapChangeHandler),this.model.off("change:upp",this.mapChangeHandler),this.model.off("change:unit",this.mapChangeHandler),this.markers.off("change",this.rebuildUplinks),e.View.prototype.remove.apply(this,arguments)}})}),function(e,t,a){"undefined"!=typeof module&&module.exports?module.exports=a():"function"==typeof define&&define.amd?define("heatmap",a):t[e]=a()}("h337",this,function(){var e={defaultRadius:40,defaultRenderer:"canvas2d",defaultGradient:{.25:"rgb(0,0,255)",.55:"rgb(0,255,0)",.85:"yellow",1:"rgb(255,0,0)"},defaultMaxOpacity:1,defaultMinOpacity:0,defaultBlur:.85,defaultXField:"x",defaultYField:"y",defaultValueField:"value",plugins:{}},t=function(){var t=function(e){this._coordinator={},this._data=[],this._radi=[],this._min=0,this._max=1,this._xField=e.xField||e.defaultXField,this._yField=e.yField||e.defaultYField,this._valueField=e.valueField||e.defaultValueField,e.radius&&(this._cfgRadius=e.radius)},a=e.defaultRadius;return t.prototype={_organiseData:function(e,t){var n=e[this._xField],i=e[this._yField],o=this._radi,r=this._data,s=this._max,c=this._min,d=e[this._valueField]||1,l=e.radius||this._cfgRadius||a;return r[n]||(r[n]=[],o[n]=[]),r[n][i]?r[n][i]+=d:(r[n][i]=d,o[n][i]=l),r[n][i]>s?(t?this.setDataMax(r[n][i]):this._max=r[n][i],!1):{x:n,y:i,value:d,radius:l,min:c,max:s}},_unOrganizeData:function(){var e=[],t=this._data,a=this._radi;for(var n in t)for(var i in t[n])e.push({x:n,y:i,radius:a[n][i],value:t[n][i]});return{min:this._min,max:this._max,data:e}},_onExtremaChange:function(){this._coordinator.emit("extremachange",{min:this._min,max:this._max})},addData:function(){if(arguments[0].length>0)for(var e=arguments[0],t=e.length;t--;)this.addData.call(this,e[t]);else{var a=this._organiseData(arguments[0],!0);a&&this._coordinator.emit("renderpartial",{min:this._min,max:this._max,data:[a]})}return this},setData:function(e){var t=e.data,a=t.length;this._data=[],this._radi=[];for(var n=0;a>n;n++)this._organiseData(t[n],!1);return this._max=e.max,this._min=e.min||0,this._onExtremaChange(),this._coordinator.emit("renderall",this._getInternalData()),this},removeData:function(){},setDataMax:function(e){return this._max=e,this._onExtremaChange(),this._coordinator.emit("renderall",this._getInternalData()),this},setDataMin:function(e){return this._min=e,this._onExtremaChange(),this._coordinator.emit("renderall",this._getInternalData()),this},setCoordinator:function(e){this._coordinator=e},_getInternalData:function(){return{max:this._max,min:this._min,data:this._data,radi:this._radi}},getData:function(){return this._unOrganizeData()}},t}(),a=function(){function e(e){var a=e.container,n=this.shadowCanvas=document.createElement("canvas"),i=this.canvas=e.canvas||document.createElement("canvas"),o=(this._renderBoundaries=[1e4,1e4,0,0],getComputedStyle(e.container)||{});i.className="heatmap-canvas",this._width=i.width=n.width=+o.width.replace(/px/,""),this._height=i.height=n.height=+o.height.replace(/px/,""),this.shadowCtx=n.getContext("2d"),this.ctx=i.getContext("2d"),i.style.cssText=n.style.cssText="position:absolute;left:0;top:0;",a.style.position="relative",a.appendChild(i),this._palette=t(e),this._templates={},this._setStyles(e)}var t=function(e){var t=e.gradient||e.defaultGradient,a=document.createElement("canvas"),n=a.getContext("2d");a.width=256,a.height=1;var i=n.createLinearGradient(0,0,256,1);for(var o in t)i.addColorStop(o,t[o]);return n.fillStyle=i,n.fillRect(0,0,256,1),n.getImageData(0,0,256,1).data},a=function(e,t){var a=document.createElement("canvas"),n=a.getContext("2d"),i=e,o=e;if(a.width=a.height=2*e,1==t)n.beginPath(),n.arc(i,o,e,0,2*Math.PI,!1),n.fillStyle="rgba(0,0,0,1)",n.fill();else{var r=n.createRadialGradient(i,o,e*t,i,o,e);r.addColorStop(0,"rgba(0,0,0,1)"),r.addColorStop(1,"rgba(0,0,0,0)"),n.fillStyle=r,n.fillRect(0,0,2*e,2*e)}return a},n=function(e){for(var t=[],a=e.min,n=e.max,i=e.radi,e=e.data,o=Object.keys(e),r=o.length;r--;)for(var s=o[r],c=Object.keys(e[s]),d=c.length;d--;){var l=c[d],m=e[s][l],g=i[s][l];t.push({x:s,y:l,value:m,radius:g})}return{min:a,max:n,data:t}};return e.prototype={renderPartial:function(e){this._drawAlpha(e),this._colorize()},renderAll:function(e){this._clear(),this._drawAlpha(n(e)),this._colorize()},_updateGradient:function(e){this._palette=t(e)},updateConfig:function(e){e.gradient&&this._updateGradient(e),this._setStyles(e)},setDimensions:function(e,t){this._width=e,this._height=t,this.canvas.width=this.shadowCanvas.width=e,this.canvas.height=this.shadowCanvas.height=t},_clear:function(){this.shadowCtx.clearRect(0,0,this._width,this._height),this.ctx.clearRect(0,0,this._width,this._height)},_setStyles:function(e){this._blur=0==e.blur?0:e.blur||e.defaultBlur,e.backgroundColor&&(this.canvas.style.backgroundColor=e.backgroundColor),this._opacity=255*(e.opacity||0),this._maxOpacity=255*(e.maxOpacity||e.defaultMaxOpacity),this._minOpacity=255*(e.minOpacity||e.defaultMinOpacity),this._useGradientOpacity=!!e.useGradientOpacity},_drawAlpha:function(e){for(var t=this._min=e.min,n=this._max=e.max,e=e.data||[],i=e.length,o=1-this._blur;i--;){var r,s=e[i],c=s.x,d=s.y,l=s.radius,m=Math.min(s.value,n),g=c-l,u=d-l,h=this.shadowCtx;this._templates[l]?r=this._templates[l]:this._templates[l]=r=a(l,o),h.globalAlpha=(m-t)/(n-t),h.drawImage(r,g,u),g<this._renderBoundaries[0]&&(this._renderBoundaries[0]=g),u<this._renderBoundaries[1]&&(this._renderBoundaries[1]=u),g+2*l>this._renderBoundaries[2]&&(this._renderBoundaries[2]=g+2*l),u+2*l>this._renderBoundaries[3]&&(this._renderBoundaries[3]=u+2*l)}},_colorize:function(){var e=this._renderBoundaries[0],t=this._renderBoundaries[1],a=this._renderBoundaries[2]-e,n=this._renderBoundaries[3]-t,i=this._width,o=this._height,r=this._opacity,s=this._maxOpacity,c=this._minOpacity,d=this._useGradientOpacity;0>e&&(e=0),0>t&&(t=0),e+a>i&&(a=i-e),t+n>o&&(n=o-t);for(var l=this.shadowCtx.getImageData(e,t,a,n),m=l.data,g=m.length,u=this._palette,h=3;g>h;h+=4){var p=m[h],y=4*p;if(y){var _;_=r>0?r:s>p?c>p?c:p:s,m[h-3]=u[y],m[h-2]=u[y+1],m[h-1]=u[y+2],m[h]=d?u[y+3]:_}}l.data=m,this.ctx.putImageData(l,e,t),this._renderBoundaries=[1e3,1e3,0,0]},getValueAt:function(e){var t,a=this.shadowCtx,n=a.getImageData(e.x,e.y,1,1),i=n.data[3],o=this._max,r=this._min;return t=Math.abs(o-r)*(i/255)>>0},getDataURL:function(){return this.canvas.toDataURL()}},e}(),n=function(){var t=!1;return"canvas2d"===e.defaultRenderer&&(t=a),t}(),i={merge:function(){for(var e={},t=arguments.length,a=0;t>a;a++){var n=arguments[a];for(var i in n)e[i]=n[i]}return e}},o=function(){function a(){var a=this._config=i.merge(e,arguments[0]||{});if(this._coordinator=new o,a.plugin){var s=a.plugin;if(!e.plugins[s])throw new Error("Plugin '"+s+"' not found. Maybe it was not registered.");var c=e.plugins[s];this._renderer=new c.renderer(a),this._store=new c.store(a)}else this._renderer=new n(a),this._store=new t(a);r(this)}var o=function(){function e(){this.cStore={}}return e.prototype={on:function(e,t,a){var n=this.cStore;n[e]||(n[e]=[]),n[e].push(function(e){return t.call(a,e)})},emit:function(e,t){var a=this.cStore;if(a[e])for(var n=a[e].length,i=0;n>i;i++){var o=a[e][i];o(t)}}},e}(),r=function(e){var t=e._renderer,a=e._coordinator,n=e._store;a.on("renderpartial",t.renderPartial,t),a.on("renderall",t.renderAll,t),a.on("extremachange",function(t){e._config.onExtremaChange&&e._config.onExtremaChange({min:t.min,max:t.max,gradient:e._config.gradient||e._config.defaultGradient})}),n.setCoordinator(a)};return a.prototype={addData:function(){return this._store.addData.apply(this._store,arguments),this},removeData:function(){return this._store.removeData&&this._store.removeData.apply(this._store,arguments),this},setData:function(){return this._store.setData.apply(this._store,arguments),this},setDataMax:function(){return this._store.setDataMax.apply(this._store,arguments),this},setDataMin:function(){return this._store.setDataMin.apply(this._store,arguments),this},configure:function(e){return this._config=i.merge(this._config,e),this._renderer.updateConfig(this._config),this._coordinator.emit("renderall",this._store._getInternalData()),this},repaint:function(){return this._coordinator.emit("renderall",this._store._getInternalData()),this},getData:function(){return this._store.getData()},getDataURL:function(){return this._renderer.getDataURL()},getValueAt:function(e){return this._store.getValueAt?this._store.getValueAt(e):this._renderer.getValueAt?this._renderer.getValueAt(e):null}},a}(),r={create:function(e){return new o(e)},register:function(t,a){e.plugins[t]=a}};return r}),function(e,t,a){"undefined"!=typeof module&&module.exports?module.exports=a(require("jquery"),require("heatmap"),require("gmaps")):"function"==typeof define&&define.amd?define("heatmap-gmaps",["jquery","heatmap","gmaps"],a):t[e]=a($,h337,google)}("HeatmapOverlay",this,function(e,t,a){if(window.HeatmapOverlay)return window.HeatmapOverlay;var n=e.Deferred(),i=function(e){var a=function(e,t){this.setMap(e),this.initialize(t||{})};return a.prototype=new e.maps.OverlayView,a.CSS_TRANSFORM=function(){for(var e=document.createElement("div"),t=["transform","WebkitTransform","MozTransform","OTransform","msTransform"],a=0;a<t.length;a++){var n=t[a];if(void 0!==e.style[n])return n}return t[0]}(),a.prototype.initialize=function(e){this.cfg=e;var t=this.map=this.getMap(),a=this.container=document.createElement("div"),n=t.getDiv(),i=this.width=n.clientWidth,o=this.height=n.clientHeight;a.style.cssText="width:"+i+"px;height:"+o+"px;",this.data=[],this.max=1,this.min=0,e.container=a},a.prototype.onAdd=function(){this.getPanes().overlayLayer.appendChild(this.container),this.changeHandler=e.maps.event.addListener(this.map,"bounds_changed",this.draw),this.heatmap||(this.heatmap=t.create(this.cfg)),this.draw()},a.prototype.onRemove=function(){this.map&&(this.map=null,this.container.parentElement.removeChild(this.container),this.container=null,this.changeHandler&&(e.maps.event.removeListener(this.changeHandler),this.changeHandler=null))},a.prototype.draw=function(){if(this.map){var t=this.map.getBounds(),n=new e.maps.LatLng(t.getNorthEast().lat(),t.getSouthWest().lng()),i=this.getProjection(),o=i.fromLatLngToDivPixel(n);this.container.style[a.CSS_TRANSFORM]="translate("+Math.round(o.x)+"px,"+Math.round(o.y)+"px)",this.update()}},a.prototype.resize=function(){if(this.map){var e=this.map.getDiv(),t=e.clientWidth,a=e.clientHeight;(t!=this.width||a!=this.height)&&(this.width=t,this.height=a,this.heatmap._renderer.setDimensions(t,a),this.update())}},a.prototype.update=function(){var t,a,n,i,o=this.map.getProjection();if(o&&(n=this.map.getBounds(),i=new e.maps.LatLng(n.getNorthEast().lat(),n.getSouthWest().lng()),t=this.map.getZoom(),a=Math.pow(2,t),this.resize(),0!=this.data.length)){for(var r={max:this.max,min:this.min},s=[],c=this.data.length,d=this.getProjection(),l=d.fromLatLngToDivPixel(i),m=this.cfg.scaleRadius?a:1,g=0,u=0,h=this.cfg.valueField||"value";c--;){var p=this.data[c],y=p[h],_=p.latlng;if(n.contains(_)){g=Math.max(y,g),u=Math.min(y,u);var f=d.fromLatLngToDivPixel(_),v={x:Math.round(f.x-l.x),y:Math.round(f.y-l.y)};v[h]=y;var b;b=p.radius?p.radius*m:(this.cfg.radius||2)*m,v.radius=b,s.push(v)}}this.cfg.useLocalExtrema&&(r.max=g,r.min=u),r.data=s,this.heatmap.setData(r)}},a.prototype.setData=function(t){this.max=t.max,this.min=t.min;for(var a=this.cfg.latField||"lat",n=this.cfg.lngField||"lng",i=this.cfg.valueField||"value",t=t.data,o=t.length,r=[];o--;){var s=t[o],c=new e.maps.LatLng(s[a],s[n]),d={latlng:c};d[i]=s[i],s.radius&&(d.radius=s.radius),r.push(d)}this.data=r,this.update()},a.prototype.addData=function(t){if(t.length>0)for(var a=t.length;a--;)this.addData(t[a]);else{var n=this.cfg.latField||"lat",i=this.cfg.lngField||"lng",o=this.cfg.valueField||"value",r=t,s=new e.maps.LatLng(r[n],r[i]),c={latlng:s};c[o]=r[o],r.radius&&(c.radius=r.radius),this.max=Math.max(this.max,c[o]),this.min=Math.min(this.min,c[o]),this.data.push(c),this.update()}},a};return a.maps?i(a):(a.done(e.proxy(function(e){a=e;var t=i(a);t.isResolved=!0,n.resolve(t)},this)).fail(function(){n.reject()}),n.promise())}),define("unifi/view/map/CoverageView",["backbone","underscore","jquery","heatmap","heatmap-gmaps"],function(e,t,a,n,i){"use strict";return e.View.extend({el:".image-map-coverage-layer",initialize:function(e){t.bindAll(this);this.indexView=e.indexView,this.markers=this.indexView.app.collection("Devices"),this.isVisible=!1,this.dataSetMax=10,this.dataSetMin=0,this.markerHeatmapCount=9,this.coverageFilter="2G",this.heatmapOptions={radius:200,maxOpacity:.7,useLocalExtrema:!0,latField:"lat",lngField:"lng",gradient:{0:"rgba(000,000,255,0)",.2:"rgba(000,000,255,1)",.4:"rgba(000,255,255,1)",.6:"rgba(000,255,000,1)",.8:"rgba(255,255,000,1)",1:"rgba(255,000,000,1)"}},this.$heatmapElt=this.$el,this.heatmapElt=this.$heatmapElt[0],a(window).on("resize",this.resize)},setCoverageFilter:function(e){this.coverageFilter=e,this.mapChangeHandler()},setMap:function(e){this.model&&(this.model.off("change:zoom",this.mapChangeHandler),this.model.off("change:offset_left",this.mapChangeHandler),this.model.off("change:offset_top",this.mapChangeHandler),this.model.off("change:lng",this.mapChangeHandler),this.model.off("change:lat",this.mapChangeHandler),this.model.off("change:upp",this.mapChangeHandler),this.model.off("change:unit",this.mapChangeHandler)),this.model=e,this.model.on("change:zoom",this.mapChangeHandler),this.model.on("change:offset_left",this.mapChangeHandler),this.model.on("change:offset_top",this.mapChangeHandler),this.model.on("change:lng",this.mapChangeHandler),this.model.on("change:lat",this.mapChangeHandler),this.model.on("change:upp",this.mapChangeHandler),this.model.on("change:unit",this.mapChangeHandler),this.mapChangeHandler()},mapChangeHandler:function(){this.isVisible&&this.updateCoverage()},show:function(){this.isVisible||(this.bindListeners(),this.isVisible=!0,this.updateCoverage())},hide:function(){this.isVisible&&(this.unbindListeners(),this.$el.empty(),this.isVisible=!1,this.googleHeatmap&&(this.googleHeatmap.onRemove(),this.googleHeatmap=null))},bindListeners:function(){this.markers.on("add",this.mapChangeHandler),this.markers.on("remove",this.mapChangeHandler),this.markers.on("change:map_id",this.mapChangeHandler),this.markers.on("change:x",this.mapChangeHandler),this.markers.on("change:y",this.mapChangeHandler),this.markers.on("change:ng-tx_power",this.mapChangeHandler),this.markers.on("change:ng-gain",this.mapChangeHandler),this.markers.on("change:ng-eirp",this.mapChangeHandler),this.markers.on("change:na-tx_power",this.mapChangeHandler),this.markers.on("change:na-gain",this.mapChangeHandler),this.markers.on("change:na-eirp",this.mapChangeHandler)},unbindListeners:function(){this.markers.off("add",this.mapChangeHandler),this.markers.off("remove",this.mapChangeHandler),this.markers.off("change:map_id",this.mapChangeHandler),this.markers.off("change:x",this.mapChangeHandler),this.markers.off("change:y",this.mapChangeHandler),this.markers.off("change:ng-tx_power",this.mapChangeHandler),this.markers.off("change:ng-gain",this.mapChangeHandler),this.markers.off("change:ng-eirp",this.mapChangeHandler),this.markers.off("change:na-tx_power",this.mapChangeHandler),this.markers.off("change:na-gain",this.mapChangeHandler),this.markers.off("change:na-eirp",this.mapChangeHandler)},resize:function(){var e=a(".image-map-container");if(e.length){var t=a(".ubnt-map-widget").outerWidth(),n=a(".ubnt-map-widget").outerHeight();this.$heatmapElt.css({width:t,height:n});var i=this.$heatmapElt.find("canvas");if(i.length){var o=i[0].getContext("2d");o.canvas.style.width=t+"px",o.canvas.style.height=n+"px",o.canvas.width=t,o.canvas.height=n}this.updateCoverage(!0)}},updateCoverage:t.debounce(function(t){if("map"===e.history.fragment.split("?")[0]&&this.model&&this.isVisible){if(!t)return void this.resize();"googleMap"===this.model.get("type")?this.updateGoogleMapCoverage():this.updateImageMapCoverage()}},100),updateGoogleMapCoverage:function(){var e=this;if(e.HeatmapOverlay)e._updateGoogleMapCoverage();else{if(e.HeatmapOverlayLoading)return;e.HeatmapOverlayLoading=!0,i.isResolved?(e.HeatmapOverlay=i,e._updateGoogleMapCoverage()):i.done(a.proxy(function(t){e.HeatmapOverlay=t,e._updateGoogleMapCoverage()},this))}},_updateGoogleMapCoverage:function(){var e=this.indexView.map.mapWidget.googleMap,a=e.googleMap;if(window.google.maps.hasOwnProperty("OverlayView")&&e.loaded&&google.maps){this.googleHeatmap&&(this.googleHeatmap.onRemove(),this.googleHeatmap=null),this.googleHeatmap=new this.HeatmapOverlay(a,this.heatmapOptions);var n=function(){return this.googleHeatmap.heatmap?(this.googleData=[],t.each(e.markerViews,function(e){var t=this.calculateCoverage(e.model);t>=0&&this.googleData.push({lat:e.model.get("x"),lng:e.model.get("y"),value:this.markerHeatmapCount,radius:t})},this),void(this.googleData.length?this.googleHeatmap.setData({max:this.dataSetMax,min:this.dataSetMin,data:this.googleData}):this.googleHeatmap.heatmap.setData({data:[]}))):void t.delay(t.bind(n,this),50)};t.delay(t.bind(n,this),50)}},updateImageMapCoverage:function(){var e,i,o,r=this,s=a(".image-map-container"),c=s.find(".marker"),d=a(".image-drag-layer").position(),l=[];this.$el.empty(),this.heatmap=n.create(t.extend(this.heatmapOptions,{container:this.heatmapElt})),window.heatmap=this.heatmap;var m=function(){c.each(function(t){e=a(this),i=e.position(),o=e.find(".mac").text();var n=r.calculateCoverage(r.markers.findWhere({mac:o}));n>=0&&l.push({x:i.left+d.left,y:i.top+d.top,value:r.markerHeatmapCount,radius:n})}),this.heatmap.setData({max:this.dataSetMax,min:this.dataSetMin,data:l})};t.delay(t.bind(m,this),50)},calculateCoverage:function(e){var t,a,n,i=100,o=1,r="2G"==this.coverageFilter?e.transmitPower("ng"):e.transmitPower("na"),s="2G"==this.coverageFilter?e.transmitFrequency("ng"):e.transmitFrequency("na"),c=this.model.get("unit")||"m",d=this.model.get("upp")||10,l=this.model.get("zoom")||1,m=this.indexView.getActiveMap().scale||1;return d>0?(o=1,d/="m"===c?1:3.2808399,o=10/d*l*m):o=15*l*m,1==e.get("state")&&r>=0?(t=o,a=r,n=Math.pow(10,a/20)/(s/3e5),t*=Math.sqrt(n/200),1>t&&(t=1),t=Math.floor(t),i=t):void 0},remove:function(){a(window).off("resize",this.resize),this.model&&(this.model.off("change:zoom",this.mapChangeHandler),this.model.off("change:offset_left",this.mapChangeHandler),this.model.off("change:offset_top",this.mapChangeHandler),this.model.off("change:lng",this.mapChangeHandler),this.model.off("change:lat",this.mapChangeHandler),this.model.off("change:upp",this.mapChangeHandler),this.model.off("change:unit",this.mapChangeHandler)),this.unbindListeners(),this.googleHeatmap&&(this.googleHeatmap.onRemove(),this.googleHeatmap=null),e.View.prototype.remove.apply(this,arguments)}})}),define("unifi/model/Map",["unifi/model/Model","backbone"],function(e,t){"use strict";return e.extend({defaults:{upp:.5,unit:"m",offset_top:130,offset_left:200,zoom:10},sync:function(e,a,n){switch(n=n||{},e){case"update":n.contentType="application/json; charset=utf-8","googleMap"===this.get("type")?(n.url="/api/s/"+SITE.name+"/rest/map/"+a.id,n.type="PUT",n.data=JSON.stringify(a.attributes)):(n.url="/api/s/"+SITE.name+"/rest/map/"+a.id,n.type="PUT",n.data=JSON.stringify(a.changed));break;case"delete":n.url="/api/s/"+SITE.name+"/rest/map/"+a.id}return t.sync.call(this,e,a,n)}})}),define("unifi/collection/Maps",["unifi/collection/Collection","unifi/model/Map","underscore"],function(e,t,a){"use strict";return e.extend({model:t,bySite:!0,url:function(e,t){return e?t?"/api/s/"+SITE.name+"/rest/map/":"/upload/map/s/"+SITE.name:"/api/s/"+SITE.name+"/list/map"},createGoogleMapModel:function(e,t){return t=t||{data:null},t.url=this.url(!0,!0),t.data=JSON.stringify(e),this.create(e,t)},comparator:function(e){return e.get("name")}})}),define("text!includes/map/addEditMapDialogTemplate.html",[],function(){return'<div class="dialog-content add-map-dialog-content">\n    <div class="content-area">\n        <form name="addEditMapForm" class="side-by-side ui-form clearfix">\n            <fieldset class="fieldset">\n                <div class="row">\n                    <input name="name" type="text" placeholder="Enter new map name" class="input map-name" tabindex="1" />\n                    <div class="buttonset map-type-select">\n                        <input type="radio" id="mapTypeImage" name="type" value="imageMap" class="image-map-radio" />\n                        <label for="mapTypeImage"> </label>\n                        <input type="radio" id="mapTypeGoogleMaps" name="type" value="googleMap" class="google-map-radio" />\n                        <label for="mapTypeGoogleMaps"></label>\n                    </div>\n                    <input name="Filedata" type="file" style="position: absolute; left: -9999px;" accept="image/x-png, image/png, image/jpg, image/jpe, image/jpeg, image/pjpeg, image/gif" />\n                </div>\n            </fieldset>\n        </form>\n        <div class="map-container">\n            <img class="image-map" />\n            <div class="google-map-container"></div>\n            <div class="select-a-different-map">\n                <span class="not-map-text"></span>\n                <a href="#"></a>\n            </div>\n            <div class="set-location">\n                <form name="setLocation" class="ui-form clearfix">\n                    <fieldset>\n                        <p>\n                            <input name="location" type="text" placeholder="Enter location" class="set-location-input input" tabindex="2" />\n                            <button name="searchButton" type="submit" value="Locate" class="button set-location-button" tabindex="3">\n                                <span class="ubnt-icon-location ui-button-icon"></span>\n                                <span class="copy"></span>\n                            </button>\n                        </p>\n                    </fieldset>\n                </form>\n            </div>\n        </div>\n    </div>\n</div>'}),function(e){e.extend(e.fn,{validate:function(t){if(!this.length)return void(t&&t.debug&&window.console&&console.warn("Nothing selected, can't validate, returning nothing."));var a=e.data(this[0],"validator");return a?a:(this.attr("novalidate","novalidate"),a=new e.validator(t,this[0]),e.data(this[0],"validator",a),a.settings.onsubmit&&(this.validateDelegate(":submit","click",function(t){a.settings.submitHandler&&(a.submitButton=t.target),e(t.target).hasClass("cancel")&&(a.cancelSubmit=!0),void 0!==e(t.target).attr("formnovalidate")&&(a.cancelSubmit=!0)}),this.submit(function(t){function n(){var n;return a.settings.submitHandler?(a.submitButton&&(n=e("<input type='hidden'/>").attr("name",a.submitButton.name).val(e(a.submitButton).val()).appendTo(a.currentForm)),a.settings.submitHandler.call(a,a.currentForm,t),a.submitButton&&n.remove(),!1):!0}return a.settings.debug&&t.preventDefault(),a.cancelSubmit?(a.cancelSubmit=!1,n()):a.form()?a.pendingRequest?(a.formSubmitted=!0,!1):n():(a.focusInvalid(),!1)})),a)},valid:function(){if(e(this[0]).is("form"))return this.validate().form();var t=!0,a=e(this[0].form).validate();return this.each(function(){t=t&&a.element(this)}),t},removeAttrs:function(t){var a={},n=this;return e.each(t.split(/\s/),function(e,t){a[t]=n.attr(t),n.removeAttr(t)}),a},rules:function(t,a){var n=this[0];if(t){var i=e.data(n.form,"validator").settings,o=i.rules,r=e.validator.staticRules(n);switch(t){case"add":e.extend(r,e.validator.normalizeRule(a)),delete r.messages,o[n.name]=r,a.messages&&(i.messages[n.name]=e.extend(i.messages[n.name],a.messages));break;case"remove":if(!a)return delete o[n.name],r;var s={};return e.each(a.split(/\s/),function(e,t){s[t]=r[t],delete r[t]}),s}}var c=e.validator.normalizeRules(e.extend({},e.validator.classRules(n),e.validator.attributeRules(n),e.validator.dataRules(n),e.validator.staticRules(n)),n);
if(c.required){var d=c.required;delete c.required,c=e.extend({required:d},c)}return c}}),e.extend(e.expr[":"],{blank:function(t){return!e.trim(""+e(t).val())},filled:function(t){return!!e.trim(""+e(t).val())},unchecked:function(t){return!e(t).prop("checked")}}),e.validator=function(t,a){this.settings=e.extend(!0,{},e.validator.defaults,t),this.currentForm=a,this.init()},e.validator.format=function(t,a){return 1===arguments.length?function(){var a=e.makeArray(arguments);return a.unshift(t),e.validator.format.apply(this,a)}:(arguments.length>2&&a.constructor!==Array&&(a=e.makeArray(arguments).slice(1)),a.constructor!==Array&&(a=[a]),e.each(a,function(e,a){t=t.replace(new RegExp("\\{"+e+"\\}","g"),function(){return a})}),t)},e.extend(e.validator,{defaults:{messages:{},groups:{},rules:{},errorClass:"error",validClass:"valid",errorElement:"label",focusInvalid:!0,errorContainer:e([]),errorLabelContainer:e([]),onsubmit:!0,ignore:":hidden",ignoreTitle:!1,onfocusin:function(e,t){this.lastActive=e,this.settings.focusCleanup&&!this.blockFocusCleanup&&(this.settings.unhighlight&&this.settings.unhighlight.call(this,e,this.settings.errorClass,this.settings.validClass),this.addWrapper(this.errorsFor(e)).hide())},onfocusout:function(e,t){this.checkable(e)||!(e.name in this.submitted)&&this.optional(e)||this.element(e)},onkeyup:function(e,t){(9!==t.which||""!==this.elementValue(e))&&(e.name in this.submitted||e===this.lastElement)&&this.element(e)},onclick:function(e,t){e.name in this.submitted?this.element(e):e.parentNode.name in this.submitted&&this.element(e.parentNode)},highlight:function(t,a,n){"radio"===t.type?this.findByName(t.name).addClass(a).removeClass(n):e(t).addClass(a).removeClass(n)},unhighlight:function(t,a,n){"radio"===t.type?this.findByName(t.name).removeClass(a).addClass(n):e(t).removeClass(a).addClass(n)}},setDefaults:function(t){e.extend(e.validator.defaults,t)},messages:{required:"This field is required.",remote:"Please fix this field.",email:"Please enter a valid email address.",url:"Please enter a valid URL.",date:"Please enter a valid date.",dateISO:"Please enter a valid date (ISO).",number:"Please enter a valid number.",digits:"Please enter only digits.",creditcard:"Please enter a valid credit card number.",equalTo:"Please enter the same value again.",maxlength:e.validator.format("Please enter no more than {0} characters."),minlength:e.validator.format("Please enter at least {0} characters."),rangelength:e.validator.format("Please enter a value between {0} and {1} characters long."),range:e.validator.format("Please enter a value between {0} and {1}."),max:e.validator.format("Please enter a value less than or equal to {0}."),min:e.validator.format("Please enter a value greater than or equal to {0}.")},autoCreateRanges:!1,prototype:{init:function(){function t(t){var a=e.data(this[0].form,"validator"),n="on"+t.type.replace(/^validate/,"");a.settings[n]&&a.settings[n].call(a,this[0],t)}this.labelContainer=e(this.settings.errorLabelContainer),this.errorContext=this.labelContainer.length&&this.labelContainer||e(this.currentForm),this.containers=e(this.settings.errorContainer).add(this.settings.errorLabelContainer),this.submitted={},this.valueCache={},this.pendingRequest=0,this.pending={},this.invalid={},this.reset();var a=this.groups={};e.each(this.settings.groups,function(t,n){"string"==typeof n&&(n=n.split(/\s/)),e.each(n,function(e,n){a[n]=t})});var n=this.settings.rules;e.each(n,function(t,a){n[t]=e.validator.normalizeRule(a)}),e(this.currentForm).validateDelegate(":text, [type='password'], [type='file'], select, textarea, [type='number'], [type='search'] ,[type='tel'], [type='url'], [type='email'], [type='datetime'], [type='date'], [type='month'], [type='week'], [type='time'], [type='datetime-local'], [type='range'], [type='color'] ","focusin focusout keyup",t).validateDelegate("[type='radio'], [type='checkbox'], select, option","click",t),this.settings.invalidHandler&&e(this.currentForm).bind("invalid-form.validate",this.settings.invalidHandler)},form:function(){return this.checkForm(),e.extend(this.submitted,this.errorMap),this.invalid=e.extend({},this.errorMap),this.valid()||e(this.currentForm).triggerHandler("invalid-form",[this]),this.showErrors(),this.valid()},checkForm:function(){this.prepareForm();for(var e=0,t=this.currentElements=this.elements();t[e];e++)this.check(t[e]);return this.valid()},element:function(t){t=this.validationTargetFor(this.clean(t)),this.lastElement=t,this.prepareElement(t),this.currentElements=e(t);var a=this.check(t)!==!1;return a?delete this.invalid[t.name]:this.invalid[t.name]=!0,this.numberOfInvalids()||(this.toHide=this.toHide.add(this.containers)),this.showErrors(),a},showErrors:function(t){if(t){e.extend(this.errorMap,t),this.errorList=[];for(var a in t)this.errorList.push({message:t[a],element:this.findByName(a)[0]});this.successList=e.grep(this.successList,function(e){return!(e.name in t)})}this.settings.showErrors?this.settings.showErrors.call(this,this.errorMap,this.errorList):this.defaultShowErrors()},resetForm:function(){e.fn.resetForm&&e(this.currentForm).resetForm(),this.submitted={},this.lastElement=null,this.prepareForm(),this.hideErrors(),this.elements().removeClass(this.settings.errorClass).removeData("previousValue")},numberOfInvalids:function(){return this.objectLength(this.invalid)},objectLength:function(e){var t=0;for(var a in e)t++;return t},hideErrors:function(){this.addWrapper(this.toHide).hide()},valid:function(){return 0===this.size()},size:function(){return this.errorList.length},focusInvalid:function(){if(this.settings.focusInvalid)try{e(this.findLastActive()||this.errorList.length&&this.errorList[0].element||[]).filter(":visible").focus().trigger("focusin")}catch(t){}},findLastActive:function(){var t=this.lastActive;return t&&1===e.grep(this.errorList,function(e){return e.element.name===t.name}).length&&t},elements:function(){var t=this,a={};return e(this.currentForm).find("input, select, textarea").not(":submit, :reset, :image, [disabled]").not(this.settings.ignore).filter(function(){return!this.name&&t.settings.debug&&window.console&&console.error("%o has no name assigned",this),this.name in a||!t.objectLength(e(this).rules())?!1:(a[this.name]=!0,!0)})},clean:function(t){return e(t)[0]},errors:function(){var t=this.settings.errorClass.replace(" ",".");return e(this.settings.errorElement+"."+t,this.errorContext)},reset:function(){this.successList=[],this.errorList=[],this.errorMap={},this.toShow=e([]),this.toHide=e([]),this.currentElements=e([])},prepareForm:function(){this.reset(),this.toHide=this.errors().add(this.containers)},prepareElement:function(e){this.reset(),this.toHide=this.errorsFor(e)},elementValue:function(t){var a=e(t).attr("type"),n=e(t).val();return"radio"===a||"checkbox"===a?e("input[name='"+e(t).attr("name")+"']:checked").val():"string"==typeof n?n.replace(/\r/g,""):n},check:function(t){t=this.validationTargetFor(this.clean(t));var a,n=e(t).rules(),i=!1,o=this.elementValue(t);for(var r in n){var s={method:r,parameters:n[r]};try{if(a=e.validator.methods[r].call(this,o,t,s.parameters),"dependency-mismatch"===a){i=!0;continue}if(i=!1,"pending"===a)return void(this.toHide=this.toHide.not(this.errorsFor(t)));if(!a)return this.formatAndAdd(t,s),!1}catch(c){throw this.settings.debug&&window.console&&console.log("Exception occurred when checking element "+t.id+", check the '"+s.method+"' method.",c),c}}return i?void 0:(this.objectLength(n)&&this.successList.push(t),!0)},customDataMessage:function(t,a){return e(t).data("msg-"+a.toLowerCase())||t.attributes&&e(t).attr("data-msg-"+a.toLowerCase())},customMessage:function(e,t){var a=this.settings.messages[e];return a&&(a.constructor===String?a:a[t])},findDefined:function(){for(var e=0;e<arguments.length;e++)if(void 0!==arguments[e])return arguments[e]},defaultMessage:function(t,a){return this.findDefined(this.customMessage(t.name,a),this.customDataMessage(t,a),!this.settings.ignoreTitle&&t.title||void 0,e.validator.messages[a],"<strong>Warning: No message defined for "+t.name+"</strong>")},formatAndAdd:function(t,a){var n=this.defaultMessage(t,a.method),i=/\$?\{(\d+)\}/g;"function"==typeof n?n=n.call(this,a.parameters,t):i.test(n)&&(n=e.validator.format(n.replace(i,"{$1}"),a.parameters)),this.errorList.push({message:n,element:t}),this.errorMap[t.name]=n,this.submitted[t.name]=n},addWrapper:function(e){return this.settings.wrapper&&(e=e.add(e.parent(this.settings.wrapper))),e},defaultShowErrors:function(){var e,t;for(e=0;this.errorList[e];e++){var a=this.errorList[e];this.settings.highlight&&this.settings.highlight.call(this,a.element,this.settings.errorClass,this.settings.validClass),this.showLabel(a.element,a.message)}if(this.errorList.length&&(this.toShow=this.toShow.add(this.containers)),this.settings.success)for(e=0;this.successList[e];e++)this.showLabel(this.successList[e]);if(this.settings.unhighlight)for(e=0,t=this.validElements();t[e];e++)this.settings.unhighlight.call(this,t[e],this.settings.errorClass,this.settings.validClass);this.toHide=this.toHide.not(this.toShow),this.hideErrors(),this.addWrapper(this.toShow).show()},validElements:function(){return this.currentElements.not(this.invalidElements())},invalidElements:function(){return e(this.errorList).map(function(){return this.element})},showLabel:function(t,a){var n=this.errorsFor(t);n.length?(n.removeClass(this.settings.validClass).addClass(this.settings.errorClass),n.html(a)):(n=e("<"+this.settings.errorElement+">").attr("for",this.idOrName(t)).addClass(this.settings.errorClass).html(a||""),this.settings.wrapper&&(n=n.hide().show().wrap("<"+this.settings.wrapper+"/>").parent()),this.labelContainer.append(n).length||(this.settings.errorPlacement?this.settings.errorPlacement(n,e(t)):n.insertAfter(t))),!a&&this.settings.success&&(n.text(""),"string"==typeof this.settings.success?n.addClass(this.settings.success):this.settings.success(n,t)),this.toShow=this.toShow.add(n)},errorsFor:function(t){var a=this.idOrName(t);return this.errors().filter(function(){return e(this).attr("for")===a})},idOrName:function(e){return this.groups[e.name]||(this.checkable(e)?e.name:e.id||e.name)},validationTargetFor:function(e){return this.checkable(e)&&(e=this.findByName(e.name).not(this.settings.ignore)[0]),e},checkable:function(e){return/radio|checkbox/i.test(e.type)},findByName:function(t){return e(this.currentForm).find("[name='"+t+"']")},getLength:function(t,a){switch(a.nodeName.toLowerCase()){case"select":return e("option:selected",a).length;case"input":if(this.checkable(a))return this.findByName(a.name).filter(":checked").length}return t.length},depend:function(e,t){return this.dependTypes[typeof e]?this.dependTypes[typeof e](e,t):!0},dependTypes:{"boolean":function(e,t){return e},string:function(t,a){return!!e(t,a.form).length},"function":function(e,t){return e(t)}},optional:function(t){var a=this.elementValue(t);return!e.validator.methods.required.call(this,a,t)&&"dependency-mismatch"},startRequest:function(e){this.pending[e.name]||(this.pendingRequest++,this.pending[e.name]=!0)},stopRequest:function(t,a){this.pendingRequest--,this.pendingRequest<0&&(this.pendingRequest=0),delete this.pending[t.name],a&&0===this.pendingRequest&&this.formSubmitted&&this.form()?(e(this.currentForm).submit(),this.formSubmitted=!1):!a&&0===this.pendingRequest&&this.formSubmitted&&(e(this.currentForm).triggerHandler("invalid-form",[this]),this.formSubmitted=!1)},previousValue:function(t){return e.data(t,"previousValue")||e.data(t,"previousValue",{old:null,valid:!0,message:this.defaultMessage(t,"remote")})}},classRuleSettings:{required:{required:!0},email:{email:!0},url:{url:!0},date:{date:!0},dateISO:{dateISO:!0},number:{number:!0},digits:{digits:!0},creditcard:{creditcard:!0}},addClassRules:function(t,a){t.constructor===String?this.classRuleSettings[t]=a:e.extend(this.classRuleSettings,t)},classRules:function(t){var a={},n=e(t).attr("class");return n&&e.each(n.split(" "),function(){this in e.validator.classRuleSettings&&e.extend(a,e.validator.classRuleSettings[this])}),a},attributeRules:function(t){var a={},n=e(t),i=n[0].getAttribute("type");for(var o in e.validator.methods){var r;"required"===o?(r=n.get(0).getAttribute(o),""===r&&(r=!0),r=!!r):r=n.attr(o),/min|max/.test(o)&&(null===i||/number|range|text/.test(i))&&(r=Number(r)),r?a[o]=r:i===o&&"range"!==i&&(a[o]=!0)}return a.maxlength&&/-1|2147483647|524288/.test(a.maxlength)&&delete a.maxlength,a},dataRules:function(t){var a,n,i={},o=e(t);for(a in e.validator.methods)n=o.data("rule-"+a.toLowerCase()),void 0!==n&&(i[a]=n);return i},staticRules:function(t){var a={},n=e.data(t.form,"validator");return n.settings.rules&&(a=e.validator.normalizeRule(n.settings.rules[t.name])||{}),a},normalizeRules:function(t,a){return e.each(t,function(n,i){if(i===!1)return void delete t[n];if(i.param||i.depends){var o=!0;switch(typeof i.depends){case"string":o=!!e(i.depends,a.form).length;break;case"function":o=i.depends.call(a,a)}o?t[n]=void 0!==i.param?i.param:!0:delete t[n]}}),e.each(t,function(n,i){t[n]=e.isFunction(i)?i(a):i}),e.each(["minlength","maxlength"],function(){t[this]&&(t[this]=Number(t[this]))}),e.each(["rangelength","range"],function(){var a;t[this]&&(e.isArray(t[this])?t[this]=[Number(t[this][0]),Number(t[this][1])]:"string"==typeof t[this]&&(a=t[this].split(/[\s,]+/),t[this]=[Number(a[0]),Number(a[1])]))}),e.validator.autoCreateRanges&&(t.min&&t.max&&(t.range=[t.min,t.max],delete t.min,delete t.max),t.minlength&&t.maxlength&&(t.rangelength=[t.minlength,t.maxlength],delete t.minlength,delete t.maxlength)),t},normalizeRule:function(t){if("string"==typeof t){var a={};e.each(t.split(/\s/),function(){a[this]=!0}),t=a}return t},addMethod:function(t,a,n){e.validator.methods[t]=a,e.validator.messages[t]=void 0!==n?n:e.validator.messages[t],a.length<3&&e.validator.addClassRules(t,e.validator.normalizeRule(t))},methods:{required:function(t,a,n){if(!this.depend(n,a))return"dependency-mismatch";if("select"===a.nodeName.toLowerCase()){var i=e(a).val();return i&&i.length>0}return this.checkable(a)?this.getLength(t,a)>0:e.trim(t).length>0},email:function(e,t){return this.optional(t)||/^((([a-z]|\d|[!#\$%&'\*\+\-\/=\?\^_`{\|}~]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])+(\.([a-z]|\d|[!#\$%&'\*\+\-\/=\?\^_`{\|}~]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])+)*)|((\x22)((((\x20|\x09)*(\x0d\x0a))?(\x20|\x09)+)?(([\x01-\x08\x0b\x0c\x0e-\x1f\x7f]|\x21|[\x23-\x5b]|[\x5d-\x7e]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(\\([\x01-\x09\x0b\x0c\x0d-\x7f]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]))))*(((\x20|\x09)*(\x0d\x0a))?(\x20|\x09)+)?(\x22)))@((([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.)+(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))$/i.test(e)},url:function(e,t){return this.optional(t)||/^(https?|s?ftp):\/\/(((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:)*@)?(((\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5]))|((([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.)+(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.?)(:\d*)?)(\/((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)+(\/(([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)*)*)?)?(\?((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)|[\uE000-\uF8FF]|\/|\?)*)?(#((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)|\/|\?)*)?$/i.test(e)},date:function(e,t){return this.optional(t)||!/Invalid|NaN/.test(new Date(e).toString())},dateISO:function(e,t){return this.optional(t)||/^\d{4}[\/\-]\d{1,2}[\/\-]\d{1,2}$/.test(e)},number:function(e,t){return this.optional(t)||/^-?(?:\d+|\d{1,3}(?:,\d{3})+)?(?:\.\d+)?$/.test(e)},digits:function(e,t){return this.optional(t)||/^\d+$/.test(e)},creditcard:function(e,t){if(this.optional(t))return"dependency-mismatch";if(/[^0-9 \-]+/.test(e))return!1;var a=0,n=0,i=!1;e=e.replace(/\D/g,"");for(var o=e.length-1;o>=0;o--){var r=e.charAt(o);n=parseInt(r,10),i&&(n*=2)>9&&(n-=9),a+=n,i=!i}return a%10===0},minlength:function(t,a,n){var i=e.isArray(t)?t.length:this.getLength(e.trim(t),a);return this.optional(a)||i>=n},maxlength:function(t,a,n){var i=e.isArray(t)?t.length:this.getLength(e.trim(t),a);return this.optional(a)||n>=i},rangelength:function(t,a,n){var i=e.isArray(t)?t.length:this.getLength(e.trim(t),a);return this.optional(a)||i>=n[0]&&i<=n[1]},min:function(e,t,a){return this.optional(t)||e>=a},max:function(e,t,a){return this.optional(t)||a>=e},range:function(e,t,a){return this.optional(t)||e>=a[0]&&e<=a[1]},equalTo:function(t,a,n){var i=e(n);return this.settings.onfocusout&&i.unbind(".validate-equalTo").bind("blur.validate-equalTo",function(){e(a).valid()}),t===i.val()},remote:function(t,a,n){if(this.optional(a))return"dependency-mismatch";var i=this.previousValue(a);if(this.settings.messages[a.name]||(this.settings.messages[a.name]={}),i.originalMessage=this.settings.messages[a.name].remote,this.settings.messages[a.name].remote=i.message,n="string"==typeof n&&{url:n}||n,i.old===t)return i.valid;i.old=t;var o=this;this.startRequest(a);var r={};return r[a.name]=t,e.ajax(e.extend(!0,{url:n,mode:"abort",port:"validate"+a.name,dataType:"json",data:r,success:function(n){o.settings.messages[a.name].remote=i.originalMessage;var r=n===!0||"true"===n;if(r){var s=o.formSubmitted;o.prepareElement(a),o.formSubmitted=s,o.successList.push(a),delete o.invalid[a.name],o.showErrors()}else{var c={},d=n||o.defaultMessage(a,"remote");c[a.name]=i.message=e.isFunction(d)?d(t):d,o.invalid[a.name]=!0,o.showErrors(c)}i.valid=r,o.stopRequest(a,r)}},n)),"pending"}}}),e.format=e.validator.format}(jQuery),function(e){var t={};if(e.ajaxPrefilter)e.ajaxPrefilter(function(e,a,n){var i=e.port;"abort"===e.mode&&(t[i]&&t[i].abort(),t[i]=n)});else{var a=e.ajax;e.ajax=function(n){var i=("mode"in n?n:e.ajaxSettings).mode,o=("port"in n?n:e.ajaxSettings).port;return"abort"===i?(t[o]&&t[o].abort(),t[o]=a.apply(this,arguments),t[o]):a.apply(this,arguments)}}}(jQuery),function(e){e.extend(e.fn,{validateDelegate:function(t,a,n){return this.bind(a,function(a){var i=e(a.target);return i.is(t)?n.apply(i,arguments):void 0})}})}(jQuery),define("libs/jquery.validate",["jquery-ui"],function(){}),define("ubnt/view/map/AddEditMapDialogView",["underscore","ubnt/view/dialogs/DialogView","ubnt/view/dialogs/ErrorDialogView","msg/Msg","jquery","xregexp","ubnt/view/map/GoogleMapView","ubnt/view/map/GoogleMapOverlayWrapperView","ubnt/view/map/GoogleMapMarkerWrapperView","text!includes/map/addEditMapDialogTemplate.html","unifi/webrtc/WebRtcHelpers","config/ManageConfig","libs/jquery.validate"],function(e,t,a,n,i,o,r,s,c,d,l,m){"use strict";return t.extend({_fullyQualifiedName:"UBNT.views.map.AddEditMapDialog",initialize:function(a){e.bindAll(this);var i=this;this.template=e.template(d),this.mapIndexView=a.mapIndexView;var o={title:n.G_MapAddMapHeader,autoOpen:!0,width:640,resizable:!1,draggable:!1,modal:!0,dialogClass:"ubnt-map-add-map-dialog",CancelButton:{buttonClass:"ui-button-cancel button tall auto",handler:function(){i.mapIndexView.addMapPending=!1,i.destroy(),i.mapIndexView.configureMapsHandler()}},DoneButton:{buttonClass:"ui-button-positive button tall auto green",handler:this.addMapHandler},buttons:{},close:this.destroy};o.buttons[n.G_Cancel]=o.CancelButton,o.buttons[n.G_Done]=o.DoneButton,a.dialogOptions=e.extend(o,a.dialogOptions||{}),t.prototype.initialize.apply(this,[a])},initElements:function(){this.$mapTypeSelect=this.$('input[name="type"]'),this.$mapImageBrowser=this.$('input[name="Filedata"]'),this.$googleMapContainer=this.$(".google-map-container"),this.$form=this.$('form[name="addEditMapForm"]'),this.$setLocationForm=this.$('form[name="setLocation"]'),this.$mapLabel=this.$('input[name="name"]'),this.$imageMapContainer=this.$(".map-container"),this.$mapImage=this.$("img.image-map"),this.$selectMapLink=this.$(".select-a-different-map"),this.$setLocation=this.$(".set-location"),this.$setLocation.find('input[type="button"]'),this.$searchButton=this.$el.find('input[name="searchButton"]'),this.$addMapButtonText=this.$el.parent().find(".ui-dialog-buttonpane button:first-child span"),this.$uploadImageLabel=this.$('label[for="mapTypeImage"]'),this.$mapTypeLabel=this.$('label[for="mapTypeGoogleMaps"]'),this.$notMap=this.$(".select-a-different-map").find(".not-map-text"),this.$selectDiffMap=this.$(".select-a-different-map").find("a"),this.$buttonLocate=this.$('button[name="searchButton"]'),this.$el.find(".buttonset").buttonset()},initHandlers:function(){this.$selectMapLink.find("a").on("click",this.showMapImageBrowser),this.$mapImageBrowser.on("change",this.setImageMap),this.$mapTypeSelect.on("change",this.mapTypeChangeHandler),this.$mapImage.on("load",this.imageMapLoadHandler)},initValidation:function(){i.validator.addMethod("regex",function(e,t,a){return this.optional(t)||a.test(e)},""),i.validator.addMethod("custom_xregex",function(e,t){var a=new o("^[\\p{L}\\p{Z}\\p{P}\\p{S}\\p{N}]{0,}$");return this.optional(t)||a.test(e)},""),this.$form.validate({rules:{name:{required:!0,custom_xregex:!0}},submitHandler:this.saveMap}),this.$setLocationForm.validate({rules:{location:{required:!0}},submitHandler:this.setLocation})},setLocation:function(){var e=this;return this.geocoder.geocode({address:i('input[name="location"]').val()},function(t,i){if(i===google.maps.GeocoderStatus.OK)e.googleMap.setOptions({center:t[0].geometry.location});else switch(e.errorDialog||(e.errorDialog=new a),i){case"ZERO_RESULTS":e.errorDialog.open(n.E_GoogleNotFound);break;default:e.errorDialog.open(i)}}),!1},setImageMap:function(){var e=this.$mapImageBrowser.get(0).files[0],t=new FileReader,a=this;t.onload=function(e){a.$mapImage.attr("src",e.target.result)},t.readAsDataURL(e)},showMapImageBrowser:function(){return this.$mapImageBrowser.val(""),this.$mapImage.removeAttr("src"),this.$mapImage.hide(),this.$mapImageBrowser.click(),this.$setLocation.hide(),!1},showImageMap:function(){this.$mapImage.show(),this.$selectMapLink.show(),this.$setLocation.hide(),this.$googleMapContainer.hide()},showGoogleMap:function(){var e=i("body");if(this.$mapImage.hide(),this.$selectMapLink.hide(),this.$setLocation.show(),this.$googleMapContainer.show(),e.hasClass("googlemaps-notLoaded"))window.googleMapsNotLoaded();else if(r.loaded||i("body").bind("googleMapsLoaded.AddMapDialog",this.googleMapLoadedHandler),r.loading||r.loaded||(window.UBNTMapGoogleMapCallback=function(){r.loaded=!0,c.initialize(),s.initialize(),i("body").trigger("googleMapsLoaded")},r.loading=!0,window.google&&window.google.maps&&window.UBNTMapGoogleMapCallback()),r.loaded){var t=new google.maps.LatLng(37.411146,-121.943083),a={};a=this.model&&"googleMap"===this.model.get("type")?{zoom:this.model.get("zoom"),center:new google.maps.LatLng(this.model.get("lat"),this.model.get("lng")),mapTypeId:this.model.get("mapTypeId"),tilt:this.model.get("tilt")}:{zoom:14,center:t,mapTypeId:google.maps.MapTypeId.SATELLITE,tilt:0},null===this.googleMap||void 0===this.googleMap?(this.googleMap=new google.maps.Map(this.$googleMapContainer.get(0),a),this.geocoder=new google.maps.Geocoder):this.googleMap.setOptions(a)}},setModel:function(e){this.model=e,this.render()},removeMarkers:function(){var t=this,a=e.filter(this.mapIndexView.markers.models,function(e){return t.model&&e.get("map_id")==t.model.id});e.each(a,function(e){e.save({map_id:"",x:"",y:""})})},saveMap:function(){var e=this,t={name:this.$mapLabel.val(),type:this.$('input[type="radio"]:checked').val()};switch(t.type){case"imageMap":var o=this.$mapImageBrowser.get(0).files[0];if(o){this.mapIndexView.addMapPending=!0,this.removeMarkers();var r,s;m.USE_WEBRTC?(r="/upload/s/"+SITE.name+"/map/"+t.type+"/"+encodeURI(t.name)+(null===this.model?"":"/"+this.model.get("_id")),s=e.$mapImage.attr("src")):(r="/upload/s/"+SITE.name+"/map"+(null===this.model?"":"/"+this.model.get("_id")),s=new FormData(this.$form.get(0))),i.ajax({url:r,data:s,cache:!1,processData:!1,contentType:!1,dataType:"json",unifi_convertToBinary:!0,type:"POST",success:e.handleUploadComplete,error:e.handleUploadFailed})}else this.model&&this.$mapImage.attr("src")?this.model.save(t,{success:this.destroy}):(this.errorDialog||(this.errorDialog=new a),this.errorDialog.open(n.E_NoImageSpecified));break;case"googleMap":t.lat=this.googleMap.getCenter().lat(),t.lng=this.googleMap.getCenter().lng(),t.zoom=this.googleMap.getZoom(),t.tilt=this.googleMap.getTilt(),t.mapTypeId=this.googleMap.getMapTypeId(),this.model?(this.removeMarkers(),this.model.save(t,{wait:!0,success:e.destroy})):(this.mapIndexView.addMapPending=!0,this.collection.createGoogleMapModel(t,{wait:!0,success:e.destroy}))}},render:function(){if(t.prototype.render.apply(this,[]),this.isRenderedd||(this.isRenderedd=!0,this.initElements(),this.initHandlers(),this.initValidation(),this.$searchButton.button(),i(".ui-button-cancel").attr("tabindex",4).button({icons:{primary:"ubnt-icon-close"}}),i(".ui-button-positive").attr("tabindex",5).button({icons:{primary:"ubnt-icon-check"}}),this.$uploadImageLabel.find(".ui-button-text").text(n.G_MapUploadImage),this.$mapTypeLabel.find(".ui-button-text").text(n.G_MapGoogleMaps),this.$notMap.text(n.G_MapNotWhatYouLookingFor),this.$selectDiffMap.text(n.G_MapSelectDiffMap),this.$buttonLocate.find("span.copy").text(n.G_Locate)),this.$mapLabel.val(""),this.$mapImage.hide(),this.model){var e=this;this.$el.dialog("option",{title:n.G_MapEditMapHeader}),this.$mapLabel.val(this.model.get("name"));var a=this.model.get("type")||"imageMap";"imageMap"===a?(this.$("input.image-map-radio").click(),m.USE_WEBRTC?i.ajax({type:"GET",dataType:"arraybuffer",processData:!1,xhrFields:{withCredentials:!0},url:e.model.get("url"),success:function(t){e.$mapImage.attr("src","data:image;base64,"+btoa(l.Uint8ArrayToBinaryString(t)))},error:function(){console.log("error!")}}):this.$mapImage.attr("src",this.model.get("url"))):(this.$("input.google-map-radio").click(),this.showGoogleMap()),this.$mapTypeSelect.find(i('input[value="'+a+'"]'))}else this.$el.dialog("option",{title:n.G_MapAddMapHeader}),this.$addMapButtonText.text("Add Map"),this.$googleMapContainer.hide(),this.setDefaultMapType||(this.$("input.image-map-radio").click(),this.showMapImageBrowser(),this.setDefaultMapType=!0);this.$('input[name="key"]').val(i.cookie("unifises"))},imageMapLoadHandler:function(e){this.$mapImage.css("width","auto"),this.$mapImage.css("height","auto");var t=e.target.width,a=e.target.height,n=this.$imageMapContainer.width(),i=this.$imageMapContainer.height();t/a>n/i?(this.$mapImage.height(n/t*a),this.$mapImage.width(n),this.$mapImage.css("margin-top",(i-this.$mapImage.height())/2+"px"),this.$mapImage.css("margin-left","0px")):(this.$mapImage.width(i/a*t),this.$mapImage.height(i),this.$mapImage.css("margin-left",(n-this.$mapImage.width())/2+"px"),this.$mapImage.css("margin-top","0px")),this.$googleMapContainer.hide(),this.$setLocation.hide(),this.$selectMapLink.show(),this.$mapImage.show()},mapTypeChangeHandler:function(e){var t=i(e.target).val();switch(t){case"imageMap":this.showImageMap();break;case"googleMap":this.showGoogleMap()}},googleMapLoadedHandler:function(){i("body").unbind("googleMapsLoaded.AddMapDialog"),this.showGoogleMap()},addMapHandler:function(){this.$form.submit()},handleUploadProgress:function(e){},handleUploadComplete:function(e,a,n){var i=e.data[0],o=this.collection.get(i._id);o?o.set(i,{silent:!1}):this.collection.add(i),t.prototype.destroy.apply(this,arguments),this.$mapImageBrowser.val("")},handleUploadFailed:function(e,t,a){},handleUploadCanceled:function(e){},dialogOpenHandler:function(e,t){this.model&&"googleMap"===this.model.get("type")?(this.$("input.image-map-radio").removeAttr("checked"),this.$("input.image-map-radio").next("label").removeClass("ui-state-active"),this.$("input.google-map-radio").attr("checked","checked"),this.$("input.google-map-radio").next("label").addClass("ui-state-active")):(this.$("input.image-map-radio").attr("checked","checked"),this.$("input.image-map-radio").next("label").addClass("ui-state-active"),this.$("input.google-map-radio").removeAttr("checked"),this.$("input.google-map-radio").next("label").removeClass("ui-state-active"))},dialogCloseHandler:function(e,a){t.prototype.dialogCloseHandler.apply(this,arguments),this.setDefaultMapType=null},hide:function(){t.prototype.hide.apply(this,arguments)},destroy:function(){t.prototype.destroy.apply(this,arguments)},remove:function(){this.$selectMapLink.find("a").off("click",this.showMapImageBrowser),this.$mapImageBrowser.off("change",this.setImageMap),this.$mapTypeSelect.off("change",this.mapTypeChangeHandler),this.$mapImage.off("load",this.imageMapLoadHandler),i("body").unbind("googleMapsLoaded.AddMapDialog",this.googleMapLoadedHandler),this.isRenderedd=!1,t.prototype.remove.apply(this,arguments)}})}),define("text!includes/map/confirmRemoveDialogTemplate.html",[],function(){return'<div class="dialog-content configure-maps-dialog">\n    <div class="content-area">\n        <img class="image" src="/lib/1.0.2.1095/images/1x1.gif" alt="" />\n        <div class="confirmation">\n            \n            <div class="map-name"></div>\n        </div>\n    </div>\n</div>'}),define("ubnt/view/map/ConfirmRemoveMapDialogView",["underscore","ubnt/view/dialogs/DialogView","msg/Msg","jquery","text!includes/map/confirmRemoveDialogTemplate.html","unifi/webrtc/WebRtcHelpers","config/ManageConfig"],function(e,t,a,n,i,o,r){"use strict";return t.extend({_fullyQualifiedName:"UBNT.views.dialogs.ConfirmRemoveDialog",initialize:function(){e.bindAll(this),this.template=e.template(i);var n={title:a.G_PleaseConfirm,autoOpen:!0,width:430,height:265,resizable:!1,draggable:!1,modal:!0,dialogClass:"confirm-dialog confirm-remove-dialog",CancelButton:{buttonClass:"button tall auto ui-button-cancel",handler:this.cancelHandler},ConfirmButton:{buttonClass:"button tall auto red",handler:this.confirmHandler},buttons:{}};n.buttons[a.G_Cancel]=n.CancelButton,n.buttons[a.G_Confirm]=n.ConfirmButton,this.options.dialogOptions=e.extend(n,this.options.dialogOptions||{}),t.prototype.initialize.apply(this,[this.options])},render:function(){if(t.prototype.render.apply(this,[]),n(".ui-button-cancel").button({icons:{primary:"ubnt-icon-close"}}),this.$image=this.$el.find(".image"),this.$mapName=this.$el.find(".map-name"),this.map&&this.map.get("url")&&"imageMap"===this.map.get("type"))if(this.$el.removeClass("no-image"),r.USE_WEBRTC){var e=this;n.ajax({type:"GET",dataType:"arraybuffer",processData:!1,xhrFields:{withCredentials:!0},url:e.map.get("url"),success:function(t){e.$image.attr("src","data:image;base64,"+btoa(o.Uint8ArrayToBinaryString(t)))},error:function(){console.log("error!")}})}else this.$image.attr("src",this.map.get("url"));else this.$el.addClass("no-image"),this.$image.attr("src","/lib/1.0.2.1095/images/1x1.gif");this.$confirmation=this.$el.find(".confirmation"),this.$confirmation.find("div").before(a.G_RemoveMap),this.$mapName.text(this.mapName)},show:function(e){this.map=e,this.mapName=e.get("name"),this.open()},confirmHandler:function(){this.options.confirmHandler.call(this.context,this.map),this.destroy()},cancelHandler:function(){this.options.cancelHandler.call(this.context,this.map),
this.destroy()}})}),define("text!includes/map/configureMapsDialogTemplate.html",[],function(){return'<div class="dialog-content configure-maps-dialog">\n    <% if(items.length > 0) { %>\n        <table class="table maps">\n            <thead class="thead">\n                <tr class="table-row">\n                    <td class="table-cell table-cell-map-name"></td>\n                    <td class="table-cell table-cell-actions"></td>\n                </tr>\n            </thead>\n            <tbody class="tbody">\n                <% for(var key in items) { %>\n                <tr class="table-row map-<%- items[key]._id %>" data-id="<%- items[key]._id %>">\n                    <td class="table-cell table-cell-map-name"><%- items[key].name %></td>\n                    <td class="table-cell table-cell-actions">\n                        <button class="button edit skinny"><span class="ui-icon ubnt-icon-edit"></span></button>\n                        <button class="button remove skinny" \n                            <% if (items[key].attr_no_delete) { %>disabled="disabled"<% } %>><span class="ui-icon ubnt-icon-trash"></span></button>\n                    </td>\n                </tr>\n                <% } %>\n            </tbody>\n        </table>\n    <% } else { %>\n        <div class="no-maps"></div>\n    <% } %>\n</div>'}),define("ubnt/view/map/ConfigureMapsDialogView",["underscore","ubnt/view/dialogs/DialogView","msg/Msg","jquery","text!includes/map/configureMapsDialogTemplate.html"],function(e,t,a,n,i){"use strict";return t.extend({_fullyQualifiedName:"UBNT.views.map.ConfigureMapsDialog",initialize:function(n){e.bindAll(this),this.mapIndexView=n.mapIndexView,this.template=e.template(i);var o={title:a.G_ConfigureMaps,autoOpen:!0,width:430,resizable:!1,draggable:!1,modal:!0,dialogClass:"ubnt-map-configure-maps-dialog",AddMapButton:{buttonClass:"ui-button-positive button tall green add-a-map",handler:this.addMapHandler},DoneButton:{buttonClass:"ui-button-cancel button tall right",handler:this.destroy},buttons:{},close:this.destroy};o.buttons[a.G_MapAddMap]=o.AddMapButton,o.buttons[a.G_Done]=o.DoneButton,n.dialogOptions=e.extend(o,n.dialogOptions||{}),t.prototype.initialize.apply(this,[n]),this.collection.on("change",this.updateMapNames)},render:function(){var e={items:this.collection.toJSON(),length:this.collection.length};t.prototype.render.apply(this,[{template_json:e}]),this.$tableCellMapName=n("thead .table-cell-map-name"),this.$tableCellActions=n("thead .table-cell-actions"),this.$noMaps=n(".no-maps"),this.$edit=n(".edit span"),this.$remove=n(".remove span"),this.$tableCellMapName.text(a.G_Name),this.$tableCellActions.text(a.G_Actions),this.$noMaps.text(a.G_MapNoMaps),this.$edit.after(a.G_Edit),this.$remove.after(a.G_Delete),this.isRenderedd||(n(".ui-button-cancel").button({icons:{primary:"ubnt-icon-close"}}),n(".ui-button-positive").button({icons:{primary:"ubnt-icon-check"}}),this.$el.one("click",".edit",this.editMapHandler),this.$el.one("click",".remove",this.removeMapHandler)),this.isRendered=!1},updateMapNames:function(){var t=this;e.each(this.collection.models,function(e){t.$(".map-"+e.get("_id")).find(".table-cell-map-name").text(e.get("name"))})},setModel:function(e){this.model=e},editMapHandler:function(e){this.destroy(),this.mapIndexView.editMapClickHandler(e)},removeMapHandler:function(e){this.destroy();var t=n(e.target).parents(".table-row").data("id"),a=this.collection.findWhere({_id:t});this.mapIndexView.removeMapClickHandler(a)},addMapHandler:function(){this.destroy(),this.mapIndexView.addMapClickHandler()},remove:function(){this.collection.off("change",this.updateMapNames),this.isRendered=!1,t.prototype.remove.apply(this,arguments)}})}),define("unifi/view/map/IndexView",["backbone","underscore","jquery","msg/Msg","unifi/view/app/ContentView","text!includes/map/mapIndexTemplate.html","text!includes/map/mapMarkerTemplate.html","text!includes/map/mapUnplacedMarkerTemplate.html","text!includes/map/mapUnplacedMarkerDraggableTemplate.html","ubnt/view/map/RulerView","unifi/view/map/MarkerView","ubnt/view/map/MarkerDrawerView","unifi/view/map/UnplacedMarkerView","ubnt/view/map/MapView","unifi/view/map/TopologyView","unifi/view/map/CoverageView","unifi/collection/Maps","ubnt/view/uicomponents/SelectMenuView","ubnt/view/map/AddEditMapDialogView","ubnt/view/map/ConfirmRemoveMapDialogView","ubnt/view/map/ConfigureMapsDialogView","ubnt/view/dialogs/ErrorDialogView"],function(e,t,a,n,i,o,r,s,c,d,l,m,g,u,h,p,y,_,f,v,b,w){"use strict";return i.extend({template:t.template(o),id:"mapIndex",initialize:function(e){i.prototype.initialize.call(this,e),this._dependencies=a.Deferred(),this.drawerHidden=!0,a.when(this._dependencies).then(this.render,this.failed),this.dependencies()},render:function(){if("pending"!==this._dependencies.state()){var e=this;if(i.prototype.render.call(this),!this.rendered&&(this.rendered=!0)){if(this.maps=this.app.collection("Maps"),this.markers=this.options.app.collection("Devices"),this.$el.html(this.template({msg:n})),this.$el.find("select").each(function(){var e=a(this),t=e.parent();"mapSelect"!=e.attr("name")&&e.selectmenu({parent:t,appendTo:t,icons:{button:"ubnt-icon-arrow-down secondary-color"},position:{at:"left bottom"}})}),this.$mapSelect=this.$el.find('select[name="mapSelect"]'),this.$drawerHandle=this.$el.find(".marker-drawer").find(".handle"),this.mapSelector=new _({el:this.$mapSelect,collection:this.maps,width:200,create:function(t,i){i.menuWrap.append(a('<div class="ui-menu-item configure-maps is-admin"><span class="ubnt-icon-gear gear"></span>'+n.G_ConfigureMaps+"</div>").on("click",function(t){e.configureMapsHandler()}).on("mouseover",function(e){i.menu.find(".ui-state-focus").removeClass("ui-state-focus")}))}}),this.$slider=this.$el.find(".zoom-slider").slider({min:1,max:20,value:10,step:1,slide:this.slideHandler,orientation:"vertical",range:"min"}),this.$zoomOut=this.$el.find(".zoom-controls").find(".minus").click(this.zoomOut),this.$zoomIn=this.$el.find(".zoom-controls").find(".plus").click(this.zoomIn),this.markerDrawer=new m({el:this.$("div.marker-drawer"),markers:this.markers,maps:this.maps,markerView:g,unplacedMarkerTemplate:t.template(s),unplacedMarkerDraggableTemplate:t.template(c)}),this.$markerDrawer=this.markerDrawer.render(),this.maps.models[0]){var o=a.cookie?a.cookie("default-map"):null,y=this.maps.get(o)||this.maps.models[0];y&&(this.mapSelector.set(y.id),this.mapSelector.$el.trigger("change"),this.mapSelector.$el.selectmenu("close"))}this.$drawerHandle.on("click",this.toggleDrawer),this.$mapSelect.on("change",this.mapSelectHandler),this.map=new u({app:this.options.app,el:"#Map",maps:this.maps,markers:this.markers,markerView:l.extend({app:this.options.app}),markerTemplate:t.template(r)}),this.coverageView=new p({indexView:this}),this.topologyView=new h({indexView:this}),this.$(".buttonset").buttonset(),this.$(".buttonset.mainToggles input").on("click",this.mapViewClick),this.mapViewClick(),this.$(".buttonset.coverage input").on("click",this.mapCoverageViewClick),this.$(".buttonset.coverage").hide(),this.$ruler=new d({el:".ruler"}),this.$ruler.$el.on("scaled",this.setUpp),this.$scale=this.$(".scale"),this.$scaleMeasurement=this.$scale.find(".scale-measurement"),this.$scaleIcon=this.$scale.find(".scale-icon"),this.setMap(this.maps.findWhere({_id:this.$mapSelect.val()})),this.markers.bind("add",this.addDevice),this.markers.bind("change",this.updateDevice),this.markers.bind("remove",this.removeDevice),this.markers.bind("reset",this.resetDevices),this.maps.bind("add",this.addMap),this.maps.bind("change",this.updateMap),this.maps.bind("remove",this.removeMap),this.maps.bind("reset",this.resetMaps)}this.map.render(),this.coverageView.updateCoverage()}},addDevice:function(e,t){this.markerDrawer.hasUnplacedMarkers()&&this.showDrawer()},updateDevice:function(e,t){var a=e.changedAttributes();(void 0!==a.map_id||void 0!==a.provisioned)&&(this.markerDrawer.hasUnplacedMarkers()?this.showDrawer():this.hideDrawer())},removeDevice:function(e,t){this.markerDrawer.hasUnplacedMarkers()?this.showDrawer():this.hideDrawer()},resetDevices:function(){},configureMapsHandler:function(){var e=new b({mapIndexView:this,collection:this.maps});e.render()},toggleDrawer:function(){this.drawerHidden?this.showDrawer():this.hideDrawer()},showDrawer:function(e){this.markerDrawer.$el.addClass("is-open"),this.drawerHidden=!1},hideDrawer:function(e){this.markerDrawer.$el.removeClass("is-open"),this.drawerHidden=!0},mapSelectHandler:function(){var e=this.$mapSelect.val();a.cookie&&a.cookie("default-map",e);var t=this.maps.findWhere({_id:e});this.setMap(t)},setMap:function(e){this.model&&this.model.off("change:zoom",this.mapZoomHandler),this.model=e,this.model.on("change:zoom",this.mapZoomHandler),this.map.setMap(e),this.coverageView.setMap(e),this.topologyView.setMap(e),this.setZoom(this.model.get("zoom"),!0)},getActiveMap:function(){var e=this.model;return e?"googleMap"===e.get("type")?this.map.mapWidget.googleMap:this.map.mapWidget.imageMap:null},setScaleBar:function(){var e,t,a=this.getActiveMap(),n=1;a&&(t=this.model.get("upp")||.5,e=1*a.scale*(a.zoomLevel*t),n=e>1e4||Math.abs(e-1e4)<Math.abs(e-5e3)?1e4:e>5e3||Math.abs(e-5e3)<Math.abs(e-1e3)?5e3:e>1e3||Math.abs(e-1e3)<Math.abs(e-500)?1e3:e>500||Math.abs(e-500)<Math.abs(e-100)?500:e>100||Math.abs(e-100)<Math.abs(e-50)?100:Math.abs(e-50)<Math.abs(e-20)?50:Math.abs(e-20)<Math.abs(e-10)?20:Math.abs(e-10)<Math.abs(e-5)?10:Math.abs(e-5)<Math.abs(e-1)?5:1,this.$scaleMeasurement.text(n+" "+(this.model.get("unit")||"m")),this.$scaleIcon.width(n*a.scale*this.model.get("zoom")/t),this.$scale.show())},setUpp:function(e,t,a){var n,i=this.getActiveMap();return i&&(n=t*i.scale*this.model.get("zoom"),this.app.isReadOnly?i.model.set({upp:n,unit:a}):i.model.save({upp:n,unit:a}),this.setScaleBar()),!1},mapViewClick:function(){var e=this.$('input[name="filter"]:checked'),n=[];e.each(function(){n.push(a(this).val())}),this.mapView||(this.mapView=[]),this.map.$el.removeClass(this.mapView.join(" ")).addClass(n.join(" ")),this.mapView=n,t.contains(this.mapView,"details")?(a("#mapFilterDetails").next("label:first").addClass("ui-state-active"),this.map.$el.removeClass("labels")):this.map.$el.addClass("labels"),t.contains(this.mapView,"coverage")?(a("#mapFilterCoverage").next("label:first").addClass("ui-state-active"),this.coverageView.show()):this.coverageView.hide(),t.contains(this.mapView,"details")||t.contains(this.mapView,"coverage")?this.$(".buttonset.coverage").show():this.$(".buttonset.coverage").hide(),t.contains(this.mapView,"topology")?(a("#mapFilterTopology").next("label:first").addClass("ui-state-active"),this.topologyView.show()):this.topologyView.hide()},mapCoverageViewClick:function(){var e=this.$('input[name="coverageFilter"]:checked'),n=[];e.each(function(){n.push(a(this).val())}),this.mapViewCoverageType||(this.mapViewCoverageType=[]),this.map.$el.removeClass(this.mapViewCoverageType.join(" ")).addClass(n.join(" ")),this.mapViewCoverageType=n,t.contains(this.mapViewCoverageType,"2G")&&(a("#mapFilterCoverage2G").next("label:first").addClass("ui-state-active"),a("#mapFilterCoverage5G").prop("checked",!1).next("label:first").removeClass("ui-state-active"),this.coverageView.setCoverageFilter("2G")),t.contains(this.mapViewCoverageType,"5G")&&(a("#mapFilterCoverage5G").next("label:first").addClass("ui-state-active"),a("#mapFilterCoverage2G").prop("checked",!1).next("label:first").removeClass("ui-state-active"),this.coverageView.setCoverageFilter("5G"))},slideHandler:function(e,t){var a=t.value;this.setZoom(a,!1,!0)},zoomOut:function(){var e=this.$slider.slider("value"),t=this.$slider.slider("option","min"),a=e-1;return a>=t&&this.setZoom(a),!1},zoomIn:function(){var e=this.$slider.slider("value"),t=this.$slider.slider("option","max"),a=e+1;return t>=a&&this.setZoom(a),!1},mapZoomHandler:function(e){this.setZoom(e.get("zoom"),!0)},setZoom:function(e,t,a){a||this.$slider.slider("option","value",e),this.model.set({zoom:e}),this.setScaleBar(),t||this.app.isReadOnly||this.saveZoom(e)},saveZoom:t.debounce(function(e){this.model.unset("zoom",{silent:!0}),this.model.save({zoom:e},{silent:!0})},250),addMapClickHandler:function(){this.addEditMapDialog=new f({collection:this.maps,mapIndexView:this}),this.$addEditMapDialog=this.addEditMapDialog.render(),this.addEditMapDialog.setModel(null),this.addEditMapDialog.show()},editMapClickHandler:function(e){var t=this.maps.get(a(e.target).parents(".table-row:first").data("id"));t&&(this.addEditMapDialog=new f({collection:this.maps,model:t,mapIndexView:this}),this.$addEditMapDialog=this.addEditMapDialog.render(),this.addEditMapDialog.setModel(t),this.addEditMapDialog.show())},removeMapClickHandler:function(e){var t=new v({cancelHandler:this.cancelRemoveMapHandler,confirmHandler:this.confirmRemoveMapHandler});t.show(e)},cancelRemoveMapHandler:function(){this.configureMapsHandler(),this.removeMapPending=!1},confirmRemoveMapHandler:function(e){var t=this;e&&(this.maps.remove(e),e.destroy({success:function(){var e=t.maps.at(0);e&&(t.setMap(e),t.mapSelector.set(e.id))}})),this.configureMapsHandler()},addMap:function(e,t){this.addMapPending&&(this.addMapPending=!1,a(".ui-dialog").is(":visible")||this.configureMapsHandler(),this.setMap(e),this.mapSelector.set(e.id))},updateMap:function(e,t){},removeMap:function(e,t){if(this.model.id===e.id){var a=this.maps.at(0);a&&(this.setMap(a),this.mapSelector.set(a.id))}this.removeMapPending&&(this.removeMapPending=!1,this.configureMapsHandler())},resetMaps:function(){},dependencies:function(){var e={Maps:y},n=[],i={},o=this;t.each(e,function(e,t){n.push(i[t]=a.Deferred())},this),a.when.apply(a,n).then(function(){o._dependencies.resolve()},function(){o._dependencies.reject()}),t.each(e,function(e,t){this.app.collection(t,{fetch:{reload:!1,deferred:i[t]}},e)},this)},failed:function(){(new w).open(n.E_DataLoad)},locateDevice:function(e){this.rendered?(this.$mapSelect.val(e.get("map_id")),this.mapSelectHandler(),this.markers.get(e)&&this.map.locateDevice(e)):t.delay(this.locateDevice,50,e)},remove:function(){this.$ruler.$el.off("scaled",this.setUpp),this.$(".buttonset input").off("click",this.mapViewClick),this.$drawerHandle.off("click",this.toggleDrawer),this.$mapSelect.off("change",this.mapSelectHandler),this.markers.unbind("add",this.addDevice),this.markers.unbind("change",this.updateDevice),this.markers.unbind("remove",this.removeDevice),this.markers.unbind("reset",this.resetDevices),this.maps.unbind("add",this.addMap),this.maps.unbind("change",this.updateMap),this.maps.unbind("remove",this.removeMap),this.maps.unbind("reset",this.resetMaps),this.rendered=!1,i.prototype.remove.apply(this,arguments)}})}),define("unifi/router/MapRouter",["unifi/router/Router","unifi/view/map/IndexView","unifi/view/map/MarkerView","unifi/view/map/UnplacedMarkerView"],function(e,t,a,n){"use strict";return e.extend({_fullyQualifiedName:"UNIFI.Routers.Map",_associatedViews:{Index:t,Marker:a,UnplacedMarker:n},routes:{map:"index","map?d=:d":"index"}})}),define("unifi/view/app/PropertyView",["backbone","underscore","jquery","ubnt/backgrid","ubnt/view/dialogs/ErrorDialogView","msg/Msg"],function(e,t,a,n,i,o){"use strict";return e.View.extend({tagName:"div",className:"properties accordion",templateId:null,_autoRender:!1,_detached:!1,initialize:function(e){if(!this.templateId)throw"Missing templateId";t.bindAll(this),this.template=t.template(this.templateId),this.properties=e.properties,this.parent=e.parent,this.app=this.parent.app,this.id=e.property_id,this.$container=this.properties.$el,this.grids={},this.collections={},this.model.on("change:name",this.render,!0),this.model.on("remove",this.remove),a(window).bind("resize",this.position),this._autoRender&&this.render()},render:function(e){return!this.rendered&&(this.rendered=!0)?(this.$el.html(this.template(t.extend(this.args(),this.model))),this.$tabs=this.$(".tabs"),this.$statusSaved=this.$(".status-success"),this.$statusError=this.$(".status-error"),this.$overflow=this.$(".properties-container.overflow"),this.$el.find(".accordion").andSelf().accordion({header:"> .accordion-header",heightStyle:"content",collapsible:!0,animate:200,beforeActivate:function(e,t){return a(this).hasClass("ui-dragging-stopped")?!1:void 0},activate:a.proxy(function(e,t){this.position()},this)}),this.$el.find(".accordion .accordion-header").on("click",this.renderSelects),this.$el.find(".accordion-header .remove").on("click",a.proxy(function(e){e.stopPropagation(),e.preventDefault(),this.remove()},this)),this.$el.find(".accordion-header .detach").on("click",a.proxy(function(e){e.stopPropagation(),e.preventDefault(),this._detached?this.attach():this.detach()},this)),this.$tabs.tabs({activate:a.proxy(function(e,t){this.position(),this.$tabs.trigger("change")},this)}),this.$tabs.find("a").on("click",this.renderSelects),this.$container.prepend(this.$el.hide().fadeIn()),this.attach(!0)):(e||(this._detached?this.detach():this.attach()),this.$el.find(".accordion-header .title-text").text(this.model.get("name"))),this.$container.scrollTop(0),this.position(),this},renderSelects:function(){this.$("select:visible").each(function(){var e=a(this),t=e.parent(),n=e.data("selectRendered"),i=e.data("myposition")||"left top",o=e.data("atposition")||"left bottom";n||(e.selectmenu({parent:t,appendTo:t,icons:{button:"ubnt-icon-arrow-down secondary-color"},position:{my:i,at:o,collision:"flip"},change:function(t,a){var n=a.item.element.parents(".row:first"),i=n.next(".custom:first");"custom"===a.item.value?i.show():i.hide(),e.trigger("change")}}),e.data("selectRendered",!0).trigger("change",!0))})},args:function(){return{_id:this.id,msg:o}},remove:function(){this.model&&(this.parent.properties[this.model.get("mac")]=null,delete this.parent.properties[this.model.get("mac")]),this.rendered=!1,this.model.off("change:name",this.render,!0),this.model.off("remove",this.remove),a(window).unbind("resize",this.position),this.$el.find(".accordion-header .remove").off(),this.$el.find(".accordion .accordion-header").off(),this.$el.find(".accordion-header .detach").off(),this.$tabs.find("a").off(),t.each(this.grids,function(e){e.remove()}),this.grids={},this.removeTooltips(),this.$el.fadeOut(a.proxy(function(){e.View.prototype.remove.apply(this,arguments),this.$container.trigger("property:remove")},this))},attach:function(e){this.removeTooltips(),e||this.$container.prepend(this.$el.detach()),this.$el.accordion("option","active",0),this.$el.is(".ui-draggable")&&this.$el.draggable("destroy"),this.$el.is(".ui-resizable")&&(this.$el.resizable("destroy"),this.$el.css("width","")),this.$el.css({position:"static",top:0,left:0,"z-index":""}).find(".accordion-header .detach").attr("title",o.G_Detach).tooltip({show:!1,hide:!1,track:!0,close:a.proxy(function(e,t){this.$el.find(".accordion-header .detach").attr("title",this._detached?o.G_Attach:o.G_Detach)},this)}),this.overflow(!1),this._detached=!1,this.$container.trigger("property:render")},detach:function(e){var t=this.properties.$detached.find("> div.properties").size();this.removeTooltips(),e||this.properties.$detached.append(this.$el.detach()),this.$el.accordion("option","animate",!1).accordion("option","active",0).draggable({handle:".accordion-header",stack:".properties",containment:"window",opacity:.95,stop:function(e){a(e.target).addClass("ui-dragging-stopped").delay(300).queue(function(e){a(this).removeClass("ui-dragging-stopped"),e()})}}).resizable({handles:"e"}).css("width","").css("position","absolute").position({my:"center+"+10*t+" center+"+10*t,of:a.Window}).accordion("option","animate",200).trigger("click").find(".accordion-header .detach").attr("title",o.G_Attach).tooltip({show:!1,hide:!1,track:!0,close:a.proxy(function(e,t){this.$el.find(".accordion-header .detach").attr("title",this._detached?o.G_Attach:o.G_Detach)},this)}),this._detached=!0,this.position(),this.$container.trigger("property:remove")},removeTooltips:function(){a(".ui-tooltip-content").parents("div").remove()},overflow:function(e){if(this.$overflow.css("max-height",""),e){var t=a(window).height(),n=this.$el.outerHeight(!0)-this.$overflow.height();this.$overflow.css("max-height",Math.max(0,t-n)+"px")}},position:function(){if(this._detached){this.overflow(!1);var e=this.$el.offset().top;0>e&&this.$el.css("top",e=0);var t,n=e+this.$el.outerHeight(!0),i=n-a(window).height();i>0&&((t=(e-=i)<0)&&(e=0),this.$el.css("top",e),t&&this.overflow(!0))}},grid:function(e,a,i,o,r){if(a){var s=new n.Grid(r=t.extend({columns:e,collection:a,pageable:!0,footer:n.Paginators.Mini,noRows:o},r||{}));return i.html(s.render().$el),r.pageable&&s.paginate(1,5),s}o&&i.html(o)},failed:function(){(new i).open(o.E_DataLoad)},showSavedState:function(){this.$statusSaved.stop().fadeIn().delay(2e3).fadeOut()},showErrorState:function(){this.$statusError.stop().fadeIn().delay(2e3).fadeOut()}})}),define("regex-weburl",[],function(){var e=new RegExp("^(?:(?:https?|ftp)://)(?:\\S+(?::\\S*)?@)?(?:(?:[1-9]\\d?|1\\d\\d|2[01]\\d|22[0-3])(?:\\.(?:1?\\d{1,2}|2[0-4]\\d|25[0-5])){2}(?:\\.(?:[1-9]\\d?|1\\d\\d|2[0-4]\\d|25[0-4]))|(?:(?:[a-z\\u00a1-\\uffff0-9]-*)*[a-z\\u00a1-\\uffff0-9]+)(?:\\.(?:[a-z\\u00a1-\\uffff0-9]-*)*[a-z\\u00a1-\\uffff0-9]+)*(?:\\.(?:[a-z\\u00a1-\\uffff]{2,}))\\.?)(?::\\d{2,5})?(?:[/?#]\\S*)?$","i");return e}),define("text!includes/devices/CustomUpgradeDialogTemplate.html",[],function(){return'<div class="dialog-content custom-upgrade-dialog-content">\n    <div class="content-area">\n        <form name="customUpgradeForm" class="ui-form clearfix">\n            <fieldset class="fieldset">\n                <div class="row">\n                    <label><%- msg.G_UpgradeUrlPrompt %></label>\n                </div>\n                <br/>\n                <div class="row">\n                    <input name="upgrade-url" type="text" placeholder="<%- msg.G_UpgradeUrlPlaceholder %>" class="input upgrade-url" tabindex="1" />\n                </div>\n            </fieldset>\n        </form>\n    </div>\n</div>'}),define("ubnt/view/dialogs/CustomUpgradeDialogView",["underscore","ubnt/view/dialogs/DialogView","msg/Msg","jquery","xregexp","regex-weburl","text!includes/devices/CustomUpgradeDialogTemplate.html","libs/jquery.validate"],function(e,t,a,n,i,o,r){"use strict";return t.extend({_fullyQualifiedName:"UBNT.views.devices.CustomUpgradeDialog",initialize:function(n){e.bindAll(this);this.template=e.template(r);var i={title:a.G_PropertiesCustomUpgrade,autoOpen:!0,width:440,resizable:!1,draggable:!1,modal:!0,dialogClass:"ubnt-devices-custom-upgrade-dialog",CancelButton:{buttonClass:"ui-button-cancel button auto",handler:this.close},UpgradeButton:{buttonClass:"ui-button-positive button auto red",handler:this.doneHandler},buttons:{},close:this.destroy};i.buttons[a.G_Upgrade]=i.UpgradeButton,i.buttons[a.G_Cancel]=i.CancelButton,n.dialogOptions=e.extend(i,n.dialogOptions||{}),t.prototype.initialize.apply(this,[n])},initValidation:function(){var e=this;n.validator.addMethod("custom_xregex",function(e,t){var a=new i(o);return this.optional(t)||a.test(e)},a.G_UpgradeUrlError),this.$form.validate({rules:{"upgrade-url":{required:!0,custom_xregex:!0}},submitHandler:function(){e.options.upgradeHandler(e.$el.find('input[name="upgrade-url"]').val()),e.close()}})},render:function(){var e={msg:a};t.prototype.render.apply(this,[{template_json:e}]),this.isRenderedd||(this.isRenderedd=!0,this.$form=this.$('form[name="customUpgradeForm"]'),this.initValidation())},doneHandler:function(){this.$form.submit()},remove:function(){this.isRenderedd=!1,t.prototype.remove.apply(this,arguments)}})}),function(e){Backbone.Stickit={_handlers:[],addHandler:function(e){e=_.map(_.flatten([e]),function(e){return _.extend({updateModel:!0,updateView:!0,updateMethod:"text"},e)}),this._handlers=this._handlers.concat(e)}},_.extend(Backbone.View.prototype,{_modelBindings:null,unstickit:function(e){_.each(this._modelBindings,_.bind(function(t,a){return e&&t.model!==e?!1:(t.model.off(t.event,t.fn),void delete this._modelBindings[a])},this)),this._modelBindings=_.compact(this._modelBindings),this.$el.off(".stickit"+(e?"."+e.cid:""))},stickit:function(e,t){var n=this,g=e||this.model,u=".stickit."+g.cid,h=t||this.bindings||{};this._modelBindings||(this._modelBindings=[]),this.unstickit(g),_.each(_.keys(h),function(e){var t,p,y,f,v=h[e]||{},b=_.uniqueId();":el"!=e?t=n.$(e):(t=n.$el,e=""),t.length&&(_.isString(v)&&(v={observe:v}),f=c(t,v),y=f.observe,p=_.extend({bindKey:b},f.setOptions||{}),d(n,t,f,g,y),l(n,t,f,g,y),y&&(_.each(f.events||[],function(a){var o=a+u,s=function(e){var a=f.getVal.call(n,t,e,f);i(n,f.updateModel,a,f)&&r(g,y,a,p,n,f)};""===e?n.$el.on(o,s):n.$el.on(o,e,s)}),_.each(_.flatten([y]),function(e){o(g,n,"change:"+e,function(e,a,i){(null==i||i.bindKey!=b)&&m(n,t,f,s(e,y,f,n),e)})}),m(n,t,f,s(g,y,f,n),g,!0)),a(n,f.initialize,t,g,f))}),this.remove=_.wrap(this.remove,function(e){n.unstickit(),e&&e.call(n)})}});var t=function(e,t){var a=(t||"").split("."),n=_.reduce(a,function(e,t){return e[t]},e);return null==n?e:n},a=function(e,t){return t?(_.isString(t)?e[t]:t).apply(e,_.toArray(arguments).slice(2)):void 0},n=function(e){return e.find("option").not(function(){return!this.selected})},i=function(e,t){return _.isBoolean(t)?t:_.isFunction(t)||_.isString(t)?a.apply(this,_.toArray(arguments)):!1},o=function(e,t,a,n){e.on(a,n,t),t._modelBindings.push({model:e,event:a,fn:n})},r=function(e,t,n,i,o,r){r.onSet&&(n=a(o,r.onSet,n,r)),e.set(t,n,i)},s=function(e,t,n,i){var o,r=function(t){var a=n.escape?e.escape(t):e.get(t);return _.isUndefined(a)?"":a};return o=_.isArray(t)?_.map(t,r):r(t),n.onGet?a(i,n.onGet,o,n):o},c=function(e,t){var a=[{updateModel:!1,updateView:!0,updateMethod:"text",update:function(e,t,a,n){e[n.updateMethod](t)},getVal:function(e,t,a){return e[a.updateMethod]()}}];_.each(Backbone.Stickit._handlers,function(t){e.is(t.selector)&&a.push(t)}),a.push(t);var n=_.extend.apply(_,a);return delete n.selector,n},d=function(e,t,a,n,i){var r=["autofocus","autoplay","async","checked","controls","defer","disabled","hidden","loop","multiple","open","readonly","required","scoped","selected"];_.each(a.attributes||[],function(a){var c="",d=a.observe||(a.observe=i),l=function(){var i=_.indexOf(r,a.name,!0)>-1?"prop":"attr",o=s(n,d,a,e);"class"==a.name?(t.removeClass(c).addClass(o),c=o):t[i](a.name,o)};_.each(_.flatten([d]),function(t){o(n,e,"change:"+t,l)}),l()})},l=function(e,t,n,i,r){if(null!=n.visible){var c=function(){var o=n.visible,c=n.visibleFn,d=s(i,r,n,e),l=!!d;(_.isFunction(o)||_.isString(o))&&(l=a(e,o,d,n)),c?a(e,c,t,l,n):l?t.show():t.hide()};_.each(_.flatten([r]),function(t){o(i,e,"change:"+t,c)}),c()}},m=function(e,t,n,o,r,s){i(e,n.updateView,o,n)&&(n.update.call(e,t,o,r,n),s||a(e,n.afterUpdate,t,o,n))};Backbone.Stickit.addHandler([{selector:'[contenteditable="true"]',updateMethod:"html",events:["keyup","change","paste","cut"]},{selector:"input",events:["keyup","change","paste","cut"],update:function(e,t){e.val(t)},getVal:function(e){var t=e.val();return e.is('[type="number"]')?null==t?t:Number(t):t}},{selector:"textarea",events:["keyup","change","paste","cut"],update:function(e,t){e.val(t)},getVal:function(e){return e.val()}},{selector:'input[type="radio"]',events:["change"],update:function(e,t){e.filter('[value="'+t+'"]').prop("checked",!0)},getVal:function(e){return e.filter(":checked").val()}},{selector:'input[type="checkbox"]',events:["change"],update:function(t,a,n,i){t.length>1?(a||(a=[]),_.each(t,function(t){_.indexOf(a,e(t).val())>-1?e(t).prop("checked",!0):e(t).prop("checked",!1)})):_.isBoolean(a)?t.prop("checked",a):t.prop("checked",a==t.val())},getVal:function(t){var a;if(t.length>1)a=_.reduce(t,function(t,a){return e(a).prop("checked")&&t.push(e(a).val()),t},[]);else{a=t.prop("checked");var n=t.val();"on"!=n&&null!=n&&(a=a?t.val():null)}return a}},{selector:"select",events:["change"],update:function(n,i,o,r){var s,c=r.selectOptions,d=c&&c.collection||void 0,l=n.prop("multiple");if(!c){c={};var m=function(e){return e.find("option").map(function(){return{value:this.value,label:this.text}}).get()};n.find("optgroup").length?(d={opt_labels:[]},_.each(n.find("optgroup"),function(t){var a=e(t).attr("label");d.opt_labels.push(a),d[a]=m(e(t))})):d=m(n)}c.valuePath=c.valuePath||"value",c.labelPath=c.labelPath||"label";var g=function(a,n,i){c.defaultOption&&(a=_.clone(a),a.unshift("__default__")),_.each(a,function(a){var o=e("<option/>"),r=a,s=function(e,t){o.text(e),r=t,o.data("stickit_bind_val",r),_.isArray(r)||_.isObject(r)||o.val(r)};"__default__"===a?s(c.defaultOption.label,c.defaultOption.value):s(t(a,c.labelPath),t(a,c.valuePath)),!l&&null!=r&&null!=i&&r==i||_.isObject(i)&&_.isEqual(r,i)?o.prop("selected",!0):l&&_.isArray(i)&&_.each(i,function(e){_.isObject(e)&&(e=t(e,c.valuePath)),(e==r||_.isObject(e)&&_.isEqual(r,e))&&o.prop("selected",!0)}),n.append(o)})};n.html("");var u=function(e,a){var n=window;return 0===a.indexOf("this.")&&(n=e),a=a.replace(/^[a-z]*\.(.+)$/,"$1"),t(n,a)};s=_.isString(d)?u(this,d):_.isFunction(d)?a(this,d,n,r):d,s instanceof Backbone.Collection&&(s=s.toJSON()),_.isArray(s)?g(s,n,i):_.each(s.opt_labels,function(t){var a=e("<optgroup/>").attr("label",t);g(s[t],a,i),n.append(a)})},getVal:function(t){var a;return a=t.prop("multiple")?e(n(t).map(function(){return e(this).data("stickit_bind_val")})).get():n(t).data("stickit_bind_val")}}])}(window.jQuery||window.Zepto),define("stickit",["backbone"],function(){}),define("unifi/view/devices/PropertyView",["unifi/view/app/PropertyView","ubnt/backgrid","underscore","backbone","jquery","msg/Msg","ubnt/view/dialogs/ConfirmDialogView","ubnt/view/dialogs/CustomUpgradeDialogView","stickit"],function(e,t,a,n,i,o,r,s){"use strict";return e.extend({initialize:function(t){e.prototype.initialize.call(this,t),this.model.on("change",this.populate),i.when(this._rendered=i.Deferred(),this._dependencies=i.Deferred()).then(this.populate,this.failed),this.dependencies(),this.render()},bindings:function(){return{".button-locate":{observe:["state","map_id","default","upgradable","locating"],onGet:function(){1==this.model.get("state")?this.$btnLocate.show():this.$btnLocate.hide(),this.model.get("adopted")&&(this.$btnLocate.removeClass("on"),this.model.get("locating")?this.$btnLocate.addClass("locating"):this.$btnLocate.removeClass("locating")),1==this.model.get("state")?this.$btnRestart.show():this.$btnRestart.hide(),2!=this.model.get("state")&&12!=this.model.get("state")||!this.model.get("default")?this.$btnAdopt.hide():"scan"==this.model.get("discovered_via")&&this.model.get("vwireEnabled")===!1?this.$btnAdopt.hide():this.$btnAdopt.show(),5==this.model.get("state")&&this.$btnAdopt.hide(),1==this.model.get("state")&&this.model.get("upgradable")===!0?this.$btnUpdate.show():this.$btnUpdate.hide()}},".bind-status":{observe:"state",onGet:function(){this.$statusBar.removeClass("ok pending error").addClass(this.model.statusType()).text(this.model.status())}},".bind-version":"version",".bind-ip":"ip",".bind-uptime":{observe:"uptime",onGet:function(){this.$bindUptime.text(this.model.uptime())}},".bind-adopt-ip":{observe:["adopt_ip","ip"],onGet:function(){return this.model.adoptIp()}},".bind-adopt-port":{observe:["sshd_port"],onGet:function(){return this.model.adoptPort()}},".bind-adopt-url":{observe:["adopt_url","inform_url"],onGet:function(){return this.model.adoptUrl()}}}},dependencies:function(){this._dependencies.resolve()},render:function(t){var a=this.rendered;return e.prototype.render.call(this,t),a||(this.$statusBar=this.$(".device-status"),this.$bindUptime=this.$(".bind-uptime"),this.$aliasForm=this.$(".aliasForm"),this.$forget=this.$(".forget"),this.$customUpgrade=this.$("button.custom-upgrade"),this.$moveDropdown=this.$(".move-dropdown"),this.$copyConfigDropdown=this.$(".copyConfig-dropdown"),this.$btnUpdate=this.$(".button-update"),this.$btnAdopt=this.$(".button-adopt"),this.$btnLocate=this.$(".button-locate"),this.$btnRestart=this.$(".button-restart"),this.$aliasForm.on("submit",this.updateAlias),this.$forget.on("click",this.forget),
this.$moveDropdown.on("change",this.moveDropdownChange),this.$copyConfigDropdown.on("change",this.copyConfigDropdownChange),this.$btnAdopt.on("click",this.adopt),this.$btnUpdate.on("click",this.upgrade),this.$btnLocate.on("click",this.locate),this.$btnRestart.on("click",this.restart),this.$customUpgrade.on("click",this.customUpgradeDialog)),this},populate:function(){if(this._dependencies&&"resolved"==this._dependencies.state()){this.$el.find(".property-content .loading").remove(),this.$el.removeClass("ap-connected ap-disconnected ap-upgradable ap-adopted ap-pending ap-adoptfailed ap-adopting ap-unmanaged has-uplink-dev"),this.$el.addClass("device-properties"),this.$el.addClass("mac-"+this.model.get("mac").replace(/:/g,"")),this.$el.addClass("ap-model-"+this.model.get("model")),this.model.isConnected()?(this.$el.addClass("ap-connected"),this.model.get("upgradable")&&this.$el.addClass("ap-upgradable")):this.$el.addClass("ap-disconnected"),this.model.get("adopted")?(this.$el.addClass("ap-adopted"),10==parseInt(this.model.get("state"),10)&&this.$el.addClass("ap-adoptfailed")):(this.$el.addClass("ap-pending"),this.model.get("default")||this.$el.addClass("ap-unmanaged")),"Adopting"===this.model.status()&&(this.$el.addClass("ap-adopting"),this.$el.find(".basic-overview").show());var e=this.model.uplinkDeviceMac();""!==e&&this.$el.addClass("has-uplink-dev"),this.setupMoveDropdown(),this.setupCopyConfigDropdown()}},populateNetworkForm:function(e,t){e[0].reset(),"pppoe"==t.type?(this.$connectionType.val("pppoe").trigger("change"),e.find("input[name=username]").val(t.username),e.find("input[name=x_password]").val(t.x_password),e.find("input[name=dns1]").val(t.dns1),e.find("input[name=dns2]").val(t.dns2),e.find("input[name=dnssuffix]").val(t.dnssuffix)):"static"==t.type?(this.$connectionType.val("static").trigger("change"),e.find("input[name=ip]").val(t.ip),e.find("input[name=netmask]").val(t.netmask),e.find("input[name=gateway]").val(t.gateway),e.find("input[name=dns1]").val(t.dns1),e.find("input[name=dns2]").val(t.dns2),e.find("input[name=dnssuffix]").val(t.dnssuffix)):(this.$connectionType.val("dhcp").trigger("change"),e.find("input[name=dns1]").val(t.dns1),e.find("input[name=dns2]").val(t.dns2),e.find("input[name=dnssuffix]").val(t.dnssuffix))},setupMoveDropdown:function(){this.$moveDropdown.empty().append(i('<option value=""></option>').text(o.G_MoveTo)),this.app.collection("Sites").each(function(e){if(!e.get("attr_hidden")){var t=e.get("desc");e.get("_id")==SITE.id&&(t+=" (current)"),this.$moveDropdown.append(i('<option value="'+e.get("_id")+'"></option>').text(t))}},this)},setupCopyConfigDropdown:function(){this.$copyConfigDropdown.empty().append(i('<option value=""></option>').text(o.G_CopyFrom)),this.app.collection("Devices").each(function(e){var t=e.get("mac"),a=e.get("type"),n=e.get("model");if(a===this.model.typeMap["switch"]&&t!==this.model.get("mac")&&(this.model.copyConfigMap[this.model.get("model")]&&this.model.copyConfigMap[this.model.get("model")].indexOf(n)>-1||n===this.model.get("model"))){var o=e.get("name");this.$copyConfigDropdown.append(i('<option value="'+t+'"></option>').text(o?o+" ("+t+")":t))}},this)},moveDropdownChange:function(){var e=this.$moveDropdown.val(),t=this.$moveDropdown.find("option:selected").text(),a=this,n=o.localize(o.G_PropertiesMoveDeviceConfirmTxt,t,t);if(e&&e!=SITE.id){var s=new r;s.options.dialogOptions.title=o.G_PropertiesMoveDeviceConfirmTitle,s.show(n,i.proxy(function(){a.model.move({data:{site:e},success:function(e,t){i("#header .refresh-status").click()},error:i.proxy(function(e){a.app.views.app.flash("error","Error",o.apiError(e))},a)})},a)),s.closeDialog(function(){a.$moveDropdown.val("").trigger("change")},a)}},copyConfigDropdownChange:function(){var e=this,t=this.$copyConfigDropdown.val();if(t){var a=this.$copyConfigDropdown.find("option:selected").text(),n=o.localize(o.G_PropertiesCopyDeviceConfigConfirmTxt,a),s=new r;s.options.dialogOptions.title=o.G_PropertiesCopyDeviceConfigConfirmTitle,s.show(n,i.proxy(function(){e.model.copyConfig({selectedMac:t,success:function(e,t){i("#header .refresh-status").click()},error:i.proxy(function(t){e.app.views.app.flash("error","Error",o.apiError(t))},e)})})),s.closeDialog(function(){e.$copyConfigDropdown.val("").trigger("change")},e)}},updateAlias:function(){var e,t,a=this,n=this.$aliasForm.find('input[name="name"]'),o=n.val(),r=!1;return this.$aliasForm.find(".error").removeClass("error"),this.$aliasForm.find(".row-error").remove(),""===o?(r=!0,o=this.model.get("mac"),e={name:o}):e=this.$aliasForm.serializeObject(),t=this.model.save(e,{wait:!0,data:e,success:function(e,t){"ok"===t.meta.rc?(a.showSavedState(),n.val(r?"":o)):a.showErrorState()},error:function(){a.showErrorState()}}),!t&&this.model.validationError&&this.model.validationError.name&&(n.addClass("error"),this.$aliasForm.find(".row").after(i('<div class="row row-error"></div>').text(this.model.validationError.name))),!1},updateNetwork:function(e,t){var n={};switch(this.$connectionType.val()){case"pppoe":n[t]={type:"pppoe",username:e.find("input[name=username]").val(),x_password:e.find("input[name=x_password]").val(),dns1:e.find("input[name=dns1]").val(),dns2:e.find("input[name=dns2]").val(),dnssuffix:e.find("input[name=dnssuffix]").val()},n[t].dns1||delete n[t].dns1,n[t].dns2||delete n[t].dns2,n[t].dnssuffix||delete n[t].dnssuffix;break;case"static":n[t]={type:"static",ip:e.find("input[name=ip]").val(),netmask:e.find("input[name=netmask]").val(),gateway:e.find("input[name=gateway]").val(),dns1:e.find("input[name=dns1]").val(),dns2:e.find("input[name=dns2]").val(),dnssuffix:e.find("input[name=dnssuffix]").val()},n[t].gateway||delete n[t].gateway,n[t].dns1||delete n[t].dns1,n[t].dns2||delete n[t].dns2,n[t].dnssuffix||delete n[t].dnssuffix;break;case"dhcp":n[t]={type:"dhcp",dns1:e.find("input[name=dns1]").val(),dns2:e.find("input[name=dns2]").val(),dnssuffix:e.find("input[name=dnssuffix]").val()},n[t].dns1||delete n[t].dns1,n[t].dns2||delete n[t].dns2,n[t].dnssuffix||delete n[t].dnssuffix}e.find(".error").removeClass("error");var o=this.model.save(n,{success:i.proxy(function(e,t){"ok"===t.meta.rc?this.showSavedState():this.showErrorState()},this),error:i.proxy(function(){this.showErrorState()},this)});!o&&this.model.validationError&&this.model.validationError[t]&&a.each(this.model.validationError[t],function(t,a){switch(a){case"username":case"x_password":case"ip":case"netmask":case"gateway":case"dns1":case"dns2":case"dnssuffix":e.find('input[name="'+a+'"]').addClass("error")}},this)},forget:function(){var e=new r;return e.options.dialogOptions.title=o.G_PropertiesForgetDeviceConfirmTitle,e.show(o.G_PropertiesForgetDeviceConfirmTxt,i.proxy(function(){this.model.forget({success:i.proxy(function(){this.app.collection("Devices").remove(this.model),this.remove()},this),error:i.proxy(function(e){this.app.views.app.flash("error","Error",o.apiError(e))},this)})},this)),!1},adopt:function(){return this.parent.rowAdopt(this.model),!1},upgrade:function(){return this.parent.rowUpgrade(this.model),!1},locate:function(){return this.parent.rowLocate(this.model),!1},restart:function(){return this.parent.rowRestart(this.model),!1},customUpgradeDialog:function(){this.customUpgradeDialog=new s({upgradeHandler:this.customUpgradeConfirmDialog}),this.$customUpgradeDialog=this.customUpgradeDialog.render(),this.customUpgradeDialog.show()},customUpgradeConfirmDialog:function(e){var t=this,a=new r;a.options.dialogOptions.title=o.G_PropertiesConfirmCustomUpgrade,a.options.dialogOptions.width=440,a.show(o.G_PropertiesConfirmCustomUpgradeText,function(){t.model.customUpgrade({upgradePath:e})})},remove:function(){this.model.off("change",this.populate),this.$aliasForm.off(),this.$forget.off(),this.$moveDropdown.off(),this.$btnAdopt.off(),this.$btnUpdate.off(),this.$btnLocate.off(),this.$btnRestart.off(),this.rendered=!1,e.prototype.remove.call(this)}})}),define("unifi/model/RfItemModel",["backbone","underscore"],function(e,t){"use strict";return e.Model.extend({defaults:{utilization:0,interference:0,frequencies:[],channels:[]}})}),define("unifi/view/aps/RfItemView",["backbone","jquery","libs/d3"],function(e,t,a){"use strict";return e.View.extend({TRAPEZOID_X_OFFSET:8,render:function(){var e,t=this.model.get("width"),n=this.options.frequencies[0],i=n-10,o=i+t,r=0,s=0;switch(t){case 80:e=4,r=-90,s=-26;break;case 40:e=2,r=-93,s=-29;break;default:r=-96,s=-32,e=1}this.svgEl=a.select(this.el).append("svg"),this.svgEl.attr("data-channel",this.model.get("channel")).attr("data-start-frequency",i).attr("data-end-frequency",o).attr("data-utilization",this.model.get("utilization")).attr("data-interference",this.model.get("interference")).attr("data-interference-histogram",this.model.get("rssi_histogram")).attr("data-interference-types",this.model.get("interference_type")).attr("class","unifiRf__item unifiRf__item--"+e).attr("data-interference-histogram-start_dbm",r).attr("data-interference-histogram-end_dbm",s),this._renderBackgroundRectangle(),this._renderLevelRectangle(),this._renderValue()},_renderBackgroundRectangle:function(){var e=t(this.svgEl.node()).width(),a=t(this.svgEl.node()).height(),n=this.svgEl.append("rect").attr("width",e).attr("height",a).attr("class","unifiRf__itemBackground");if(this.options.radioChannelWidth==this.model.get("width")&&this.options.highlightChannel==this.model.get("channel")){var i=(this.model.get("utilization"),this.model.get("interference")),o=this._calculateHue(i),r="stroke: hsl("+o+", 75%, 50%) !important; stroke-width: 2px";n.attr("style",r)}},_renderLevelRectangle:function(){var e=this.model.get("utilization"),a=this.model.get("interference"),n=t(this.svgEl.node()).width(),i=t(this.svgEl.node()).height(),o=i*e/100,r=i-o,s=this._calculateHue(a),c="fill: hsl("+s+", 75%, 50%) !important";this.svgEl.append("rect").attr("width",n).attr("height",o).attr("style",c).attr("y",r).attr("class","unifiRf__itemLevel")},_renderValue:function(){this.svgEl.append("svg:text").attr("class","unifiRf__value").attr("x","50%").attr("y","50%").attr("dy","30px").text(this.model.get("channel"))},_calculateHue:function(e){var t=120,a=32,n=96,i=(n- -e)/(n-a)*100,o=i/100*t;return t-o}})}),define("unifi/view/aps/RfLegendView",["underscore","backbone","jquery","libs/d3"],function(e,t,a,n){"use strict";return t.View.extend({options:{precision:15,maxHueValue:120,itemHeight:5,padding:1,labels:[-96,-80,-64,-48,-32]},render:function(){this.svgEl=n.select(this.el).append("svg"),this._renderColorItems(),this._renderLabels()},_renderColorItems:function(){for(var e=this.options.padding,t=a(this.svgEl.node()).width(),n=a(this.svgEl.node()).height(),i=this.options.precision,o=(t-e)/i+e/i,r=n-this.options.itemHeight,s=0;i>s;s++){var c=o*s+(s>0?e*s:0),d=this._calculateHue(s),l="hsl("+d+", 75%, 50%)";this.svgEl.append("rect").attr("x",c).attr("y",r).attr("width",o).attr("height",n).attr("fill",l)}},_renderLabels:function(){for(var e=this.options.labels,t=a(this.svgEl.node()).width(),n=this.svgEl.append("g"),i=0;i<e.length;i++){var o=t/(e.length-1)*i;n.append("svg:text").attr("class","unifiRf__legendLabel").attr("x",o).attr("y","0").attr("dy","8px").text(e[i])}},_calculateHue:function(e){var t=e/(this.options.precision-1)*this.options.maxHueValue;return this.options.maxHueValue-t}})}),define("unifi/view/aps/RfInterferenceLevelView",["underscore","backbone","jquery","libs/d3"],function(e,t,a,n){"use strict";return t.View.extend({options:{minValue:0,maxValue:10,minOpacity:0,maxOpacity:100},render:function(){this.svgEl=n.select(this.el).append("svg"),this._renderHistogram()},_renderHistogram:function(){var e=a(this.svgEl.node()).width(),t=a(this.svgEl.node()).height(),n=this.model.get("interference"),i=this.options.maxValue,o=this.options.minValue,r=Math.round(e/n.length);this.svgEl.append("rect").attr("class","background").attr("x",0).attr("y",0).attr("width",32*r).attr("height",t);for(var s=0;s<n.length;s++){var c=r*s,d=this._calculateOpacity(n[s],i,o)/100;this.svgEl.append("rect").attr("x",c).attr("y",0).attr("width",r).attr("height",t).attr("fill-opacity",d)}},_calculateOpacity:function(e,t,a){t>this.options.maxValue&&(t=this.options.maxValue),a<this.options.minValue&&(a=this.options.minValue);var n=t-a,i=this.options.maxOpacity-this.options.minOpacity;return(e-a)*i/n+this.options.minOpacity}})}),define("text!includes/aps/rfEnvironmentTemplate.html",[],function(){return'<div class="unifiRf__items">\n    <div class="unifiRf__scrollable">\n        <% bandwidthGroups.forEach(function(group) { %>\n        <div class="unifiRf__row unifiRf__row<%- group.width %>">\n            <div class="unifiRf__bandwidthLegend"><%- group.width %> MHz</div>\n        </div>\n        <% }); %>\n    </div>\n</div>\n'}),define("text!includes/aps/rfTooltipTemplate.html",[],function(){return'<div class="unifiRf__tooltip">\n    <h2>Channel <%- channel %></h2>\n    <h3><%- startFrequency %> - <%- endFrequency %></h3>\n\n    <dl>\n        <dt class="unifiRf__tooltipKey unifiRf__tooltipKey--inline"><%- msg.G_PropertiesRFUtilization %>:</dt>\n        <dd class="unifiRf__tooltipValue unifiRf__tooltipValue--inline unifiRf__tooltipValue--highlighted"><%- utilization %>%</dd>\n        <br/>\n\n        <dt class="unifiRf__tooltipKey unifiRf__tooltipKey--inline"><%- msg.G_PropertiesRFInterference %>:</dt>\n        <dd class="unifiRf__tooltipValue unifiRf__tooltipValue--inline unifiRf__tooltipValue--highlighted"><%- interference %><%- msg.G_PropertiesDBM %></dd>\n\n        <dd class="unifiRf__tooltipValue">\n            <div class="unifiRf__interferenceLevel"></div>\n            <div class="unifiRf__interferenceLevelLegend">\n                <div class="unifiRf__interferenceLevelLegend--left"><%- startDbm %></div>\n                <div class="unifiRf__interferenceLevelLegend--right"><%- endDbm %></div>\n            </div>\n        </dd>\n\n        <dt class="unifiRf__tooltipKey"><%- msg.G_PropertiesRFInterferenceTypes %>:</dt>\n        <dd class="unifiRf__tooltipValue interference">\n            <% interferenceTypes.forEach(function(interferenceType) { %>\n            <div class="interference-type">\n	            <span class="interference-icon interference-<%- interferenceType %> half"></span>\n	            <span class="interference-title"><%- interferenceType %></span>\n	        </div>\n            <% }); %>\n        </dd>\n    </dl>\n</div>\n'}),define("unifi/view/aps/RfEnvironmentView",["underscore","backbone","jquery","unifi/model/RfItemModel","unifi/view/aps/RfItemView","unifi/view/aps/RfLegendView","unifi/view/aps/RfInterferenceLevelView","text!includes/aps/rfEnvironmentTemplate.html","text!includes/aps/rfTooltipTemplate.html","msg/Msg"],function(e,t,a,n,i,o,r,s,c,d){"use strict";return t.View.extend({initialize:function(e){t.View.prototype.initialize.call(this,e),this.bandwidthGroups=this._getProcessedBandwidthGroups(),this.radioChannel=e.radioChannel,this.radioChannelWidth=e.radioChannelWidth,this.radioHt=e.radioHt},_getProcessedBandwidthGroups:function(){var t=this.model.get("bandwidthGroups"),a=e.chain(t).groupBy("width").map(function(e,t){return{width:t,data:e}}).value();return a.reverse()},render:function(){this._renderLayout(),this._renderItems(),this._setupTooltips()},_renderLayout:function(){this.$el.html(e.template(s,{bandwidthGroups:this.bandwidthGroups}))},_renderItems:function(){e.each(this.bandwidthGroups,e.bind(function(t){var a=this._highlightChannel(t.data,this.radioChannel);e.each(t.data,e.bind(function(e){var o=this.$(".unifiRf__row"+t.width),r=new i({el:o,model:new n(e),radioChannel:this.radioChannel,radioChannelWidth:this.radioChannelWidth,frequencies:e.frequencies,highlightChannel:a});r.render()},this))},this))},_highlightChannel:function(e,t){for(var a=0;a<e.length-1;a++)if(e[a].channel<=t&&e[a+1].channel>t)return e[a].channel;return e[e.length-1].channel},_setupTooltips:function(){this.$(".unifiRf__item").attr("title","").tooltip({show:!1,hide:!1,content:function(){var t=a(this),n={msg:d,channel:t.attr("data-channel"),startFrequency:t.attr("data-start-frequency"),endFrequency:t.attr("data-end-frequency"),utilization:t.attr("data-utilization"),interference:t.attr("data-interference"),interferenceTypes:t.attr("data-interference-types").split(","),startDbm:t.attr("data-interference-histogram-start_dbm"),endDbm:t.attr("data-interference-histogram-end_dbm")};return e.template(c,n)},position:{at:"center+20 top-2",my:"right bottom"},open:function(e,n){a(".ui-tooltip:not(:last-child)").remove();var i=a(this),o=new r({el:a(n.tooltip[0]).find(".unifiRf__interferenceLevel"),model:new t.Model({interference:i.attr("data-interference-histogram").split(",")})});o.render()}})}})}),define("text!includes/aps/apPropertiesTemplate.html",[],function(){return'<div class="accordion-header">\n    <div class="accordion-title">\n        <span class="device-icons access-point half"></span>\n        <span class="title-text"><%- name() %></span>\n        <div class="ubnt-icon-arrow-down sidebar-icons minmax minimize"></div>\n    </div>\n    <div class="right">\n        <div class="ubnt-icon-new-window sidebar-icons detach" title="Detach"></div>\n        <div class="ubnt-icon-close sidebar-icons remove" title="Close"></div>\n    </div>\n</div>\n<div class="property-content">\n    <div class="loading"><span><%- msg.N_Loading %></span></div>\n\n    <div class="device-status-wrapper">\n        <div class="device-status bind-status"></div>\n    </div>\n    <div class="status-alert status-success"><span class="ubnt-icon-check checkmark"></span><%- msg.G_Saved %></div>\n    <div class="status-alert status-error"><span class="ubnt-icon-warning alert"></span><%- msg.E_Error %></div>\n    <div class="tabs">\n        <ul>\n            <li class="tab-nav-list-item">\n                <a class="tab-button" href="#deviceDetails<%- _id %>"><%- msg.G_PropertiesDetails %></a>\n            </li>\n            <li class="tab-nav-list-item station-details">\n                <a class="tab-button" href="#deviceUsers<%- _id %>"><%- msg.G_Users %></a>\n            </li>\n            <li class="tab-nav-list-item station-details">\n                <a class="tab-button" href="#deviceGuests<%- _id %>"><%- msg.G_Guests %></a>\n            </li>\n            <li class="tab-nav-list-item ap-configs">\n                <a class="tab-button" href="#deviceConfig<%- _id %>"><%- msg.G_PropertiesConfiguration %></a>\n            </li>\n        </ul>\n        <div class="properties-container overflow">\n            <div id="deviceDetails<%- _id %>" class="tab-content">\n                <div class="accordion">\n                    <div class="accordion-header">\n                        <div class="accordion-title"><%- msg.G_DevicesOverview %></div>\n                    </div>\n                    <div class="basic-overview">\n                        <table>\n                            <tr class="table-row">\n                                <td class="column-name"><%- msg.G_PropertiesMACAddress %></td>\n                                <td class="column-value"><%- get(\'mac\') %></td>\n                            </tr>\n                            <tr class="table-row">\n                                <td class="column-name"><%- msg.G_DevicesModel %></td>\n                                <td class="column-value"><%- apModel() %></td>\n                            </tr>\n                            <tr class="table-row">\n                                <td class="column-name"><%- msg.G_Version %></td>\n                                <td class="column-value bind-version"></td>\n                            </tr>\n                        </table>\n                        <hr />\n                        <table>\n                            <tr class="table-row ip-address">\n                                <td class="column-name"><%- msg.G_IPAddress %></td>\n                                <td class="column-value bind-ip"></td>\n                            </tr>\n                            <tr class="table-row uptime">\n                                <td class="column-name"><%- msg.G_Uptime %></td>\n                                <td class="column-value bind-uptime"></td>\n                            </tr>\n                            <tr class="table-row last-uplink">\n                                <td class="column-name"><%- msg.G_LastUplink %></td>\n                                <td class="column-value">\n                                    <a class="bind-lastuplink button-uplink-device" href="#"></a>\n                                </td>\n                            </tr>\n                            <tr class="table-row last-seen">\n                                <td class="column-name"><%- msg.G_LastSeen %></td>\n                                <td class="column-value bind-lastseen"></td>\n                            </tr>\n                        </table>\n                        <hr class="station-details" />\n                        <table class="station-details">\n                            <tr class="table-row">\n                                <td class="column-name"># <%- msg.G_Users %></td>\n                                <td class="column-value bind-num-users"></td>\n                            </tr>\n                            <tr class="table-row">\n                                <td class="column-name"># <%- msg.G_Guests %></td>\n                                <td class="column-value bind-num-guests"></td>\n                            </tr>\n                        </table>\n                    </div>\n                    <div class="accordion-header ap-uplink-details">\n                        <div class="accordion-title"><%- msg.G_PropertiesUplink %> <span class="uplink-type"></span></div>\n                    </div>\n                    <div class="ap-uplink-details">\n                        <table class="wireless">\n                            <tr class="table-row">\n                                <td class="column-name"><%- msg.G_PropertiesUplinkAP %></td>\n                                <td class="column-value">\n                                    <a class="bind-uplink-device button-uplink-device" href="#"></a>\n                                </td>\n                            </tr>\n                            <tr class="table-row">\n                                <td class="column-name"><%- msg.G_PropertiesSignal %></td>\n                                <td class="column-value bind-uplink-rssi"></td>\n                            </tr>\n                            <tr class="table-row">\n                                <td class="column-name"><%- msg.G_PropertiesTXRate %></td>\n                                <td class="column-value bind-uplink-tx-rate"></td>\n                            </tr>\n                            <tr class="table-row">\n                                <td class="column-name"><%- msg.G_PropertiesRXRate %></td>\n                                <td class="column-value bind-uplink-rx-rate"></td>\n                            </tr>\n                        </table>\n                        <table class="wire">\n                            <tr class="table-row">\n                                <td class="column-name"><%- msg.G_Speed %></td>\n                                <td class="column-value bind-uplink-speed"></td>\n                            </tr>\n                            <tr class="table-row">\n                                <td class="column-name"><%- msg.G_PropertiesDuplex %></td>\n                                <td class="column-value bind-uplink-duplex"></td>\n                            </tr>\n                            <tr class="table-row uplink-device">\n                                <td class="column-name"><%- msg.G_PropertiesUplink %></td>\n                                <td class="column-value">\n                                    <a class="bind-uplink-device button-uplink-device" href="#"></a>\n                                </td>\n                            </tr>\n                        </table>\n                        <hr />\n                        <table>\n                            <tr class="table-row">\n                                <td class="column-name"><%- msg.G_PropertiesDownPktsBytes %></td>\n                                <td class="column-value bind-uplink-down-packets"></td>\n                            </tr>\n                            <tr class="table-row">\n                                <td class="column-name"><%- msg.G_PropertiesUpPktsBytes %></td>\n                                <td class="column-value bind-uplink-up-packets"></td>\n                            </tr>\n                            <tr class="table-row">\n                                <td class="column-name"><%- msg.G_Activity %></td>\n                                <td class="column-value bind-uplink-activity"></td>\n                            </tr>\n                        </table>\n                    </div>\n                    <div class="accordion-header ap-adv-adopt">\n                        <div class="accordion-title"><%- msg.G_PropertiesAdvancedOpts %></div>\n                    </div>\n                    <div class="ap-adv-adopt">\n                        <form action="" class="advAdoptForm ap-adv-adopt">\n                            <div class="row">\n                                <label class="label inline"><%- msg.G_IP %></label>\n                                <input class="input inline medium bind-adopt-ip" type="text" value="" name="ip" />\n                                <span class="colon">:</span>\n                                <input class="input inline small" type="text" value="22" name="port" />\n                            </div>\n                            <div class="row">\n                                <label class="label inline"><%- msg.G_UN %></label>\n                                <input class="input inline" type="text" value="" name="username" />\n                            </div>\n                            <div class="row">\n                                <label class="label inline"><%- msg.G_PW %></label>\n                                <input class="input inline" type="password" value="" name="password" />\n                            </div>\n                            <div class="row">\n                                <label class="label inline"><%- msg.G_PropertiesInformURL %></label>\n                                <input class="input inline bind-adopt-url" type="text" value="" name="url" />\n                            </div>\n                            <button class="button is-admin" type="submit"><%- msg.G_Adopt %></button>\n                        </form>\n                    </div>\n                    <div class="accordion-header ap-downlink-details">\n                        <div class="accordion-title"><%- msg.G_PropertiesDownlinks %></div>\n                    </div>\n                    <div class="ap-downlink-details ap-downlink-content">\n                        <div class="data-table data-table-downlinks bind-downlinks"></div>\n                    </div>\n                    <div class="accordion-header radio-ng ap-ng-details">\n                        <div class="accordion-title"><%- msg.G_PropertiesRadio11NBG %></div>\n                    </div>\n                    <div class="radio-ng ap-ng-details">\n                        <table>\n                            <tr class="table-row">\n                                <td class="column-name"><%- msg.G_Channel %></td>\n                                <td class="column-value bind-ng-channel"></td>\n                            </tr>\n                            <tr class="table-row">\n                                <td class="column-name"><%- msg.G_PropertiesTransmitPower %></td>\n                                <td class="column-value"><span class="bind-ng-transmit-power"></span></td>\n                            </tr>\n                            <tr class="table-row">\n                                <td class="column-name"><%- msg.G_PropertiesTXPktsBytes %></td>\n                                <td class="column-value bind-ng-tx-packets"></td>\n                            </tr>\n                            <tr class="table-row">\n                                <td class="column-name"><%- msg.G_PropertiesRXPktsBytes %></td>\n                                <td class="column-value bind-ng-rx-packets"></td>\n                            </tr>\n                            <tr class="table-row">\n                                <td class="column-name"><%- msg.G_PropertiesTXRetryDropped %></td>\n                                <td class="column-value bind-ng-tx-retry"></td>\n                            </tr>\n                            <tr class="table-row">\n                                <td class="column-name"><%- msg.G_PropertiesRXRetryDropped %></td>\n                                <td class="column-value bind-ng-rx-retry"></td>\n                            </tr>\n                        </table>\n                        <hr />\n                        <table>\n                            <tr class="table-row">\n                                <td class="column-name"># <%- msg.G_Users %></td>\n                                <td class="column-value bind-ng-users"></td>\n                            </tr>\n                            <tr class="table-row">\n                                <td class="column-name"># <%- msg.G_Guests %></td>\n                                <td class="column-value bind-ng-guests"></td>\n                            </tr>\n                        </table>\n                    </div>\n                    <div class="accordion-header radio-na ap-na-details">\n                        <div class="accordion-title"><%- msg.G_PropertiesRadio11NA %></div>\n                    </div>\n                    <div class="radio-na ap-na-details">\n                        <table>\n                            <tr class="table-row">\n                                <td class="column-name"><%- msg.G_Channel %></td>\n                                <td class="column-value bind-na-channel"></td>\n                            </tr>\n                            <tr class="table-row">\n                                <td class="column-name"><%- msg.G_PropertiesTransmitPower %></td>\n                                <td class="column-value"><span class="bind-na-transmit-power"></span></td>\n                            </tr>\n                            <tr class="table-row">\n                                <td class="column-name"><%- msg.G_PropertiesTXPktsBytes %></td>\n                                <td class="column-value bind-na-tx-packets"></td>\n                            </tr>\n                            <tr class="table-row">\n                                <td class="column-name"><%- msg.G_PropertiesRXPktsBytes %></td>\n                                <td class="column-value bind-na-rx-packets"></td>\n                            </tr>\n                            <tr class="table-row">\n                                <td class="column-name"><%- msg.G_PropertiesTXRetryDropped %></td>\n                                <td class="column-value bind-na-tx-retry"></td>\n                            </tr>\n                            <tr class="table-row">\n                                <td class="column-name"><%- msg.G_PropertiesRXRetryDropped %></td>\n                                <td class="column-value bind-na-rx-retry"></td>\n                            </tr>\n                        </table>\n                        <hr />\n                        <table>\n                            <tr class="table-row">\n                                <td class="column-name"># <%- msg.G_Users %></td>\n                                <td class="column-value bind-na-users"></td>\n                            </tr>\n                            <tr class="table-row">\n                                <td class="column-name"># <%- msg.G_Guests %></td>\n                                <td class="column-value bind-na-guests"></td>\n                            </tr>\n                        </table>\n                    </div>\n\n                    <div class="accordion-header ap-rf-environment">\n                        <div class="accordion-title"><%- msg.G_PropertiesRFEnvironment %></div>\n                    </div>\n                    <div class="radio-na ap-rf-environment unifiRf">\n                        <form class="data-filters ap-rf-environment-frequency-filters clearfix">\n                            <div class="buttonset frequency-filters ui-buttonset">\n                                <input type="radio" id="frequencyFilter2G_<%- _id %>" name="ap-rf-frequency-filter" value="2G" checked="checked" /><label for="frequencyFilter2G_<%- _id %>"><%- msg.G_2G %></label>\n                                <input type="radio" id="frequencyFilter5G_<%- _id %>" name="ap-rf-frequency-filter" value="5G" /><label for="frequencyFilter5G_<%- _id %>"><%- msg.G_5G %></label>\n                            </div>\n                        </form>\n                        <div class="bind-rf-legend unifiRf__legend"></div>\n\n                        <div class="bind-rf-environment bind-rf-environment-2G"></div>\n                        <div class="bind-rf-environment bind-rf-environment-5G"></div>\n\n                        <br />\n\n                        <div class="bind-rf-environment-last-updated bind-rf-environment-last-updated-2G unifiRf__lastUpdated unifiRf__lastUpdated--inline"></div>\n                        <div class="bind-rf-environment-last-updated bind-rf-environment-last-updated-5G unifiRf__lastUpdated unifiRf__lastUpdated--inline"></div>\n                        <button class="button button-rfScan right lighter skinny unifiRf__scan is-admin">\n                            <span class="ui-button-icon-primary ubnt-icon-refresh sidebar-icons"></span>\n                            <span class="text"><%- msg.G_PropertiesRFScan %></span>\n                        </button>\n                    </div>\n\n                </div>\n            </div>\n            <div id="deviceUsers<%- _id %>" class="tab-content minigrid">\n                <div class="data-table data-table-users"><%- msg.G_PropertiesNoUsersConnected %></div>\n            </div>\n            <div id="deviceGuests<%- _id %>" class="tab-content minigrid">\n                <div class="data-table data-table-guests"><%- msg.G_PropertiesNoGuestsConnected %></div>\n            </div>\n            <div id="deviceConfig<%- _id %>" class="tab-content ap-configs">\n                <div class="accordion">\n                    <div class="accordion-header ap-configs">\n                        <div class="accordion-title"><%- msg.G_Config %></div>\n                    </div>\n                    <div class="ap-configs">\n                        <form action="" class="aliasForm">\n                            <div class="row">\n                                <label for="aliasName<%- _id %>" class="label"><%- msg.G_PropertiesAlias %></label>\n                                <input name="name" id="aliasName<%- _id %>" type="text" class="input" value="<%- get(\'name\') %>" pattern=".{1,128}" title="<%- msg.E_AliasName %>" />\n                            </div>\n                            <button class="button is-admin" type="submit"><%- msg.G_Apply %></button>\n                        </form>\n                    </div>\n\n                    <div class="accordion-header">\n                        <div class="accordion-title"><%- msg.G_PropertiesRadios %></div>\n                    </div>\n                    <div>\n                        <form action="" class="radiosForm">\n                            <fieldset class="fieldset radio-ng ap-ng-configs">\n                                <legend class="legend"><%- msg.G_PropertiesRadio2G11NBG %></legend>\n                                <div class="row">\n                                    <input type="hidden" class="hidden" name="ng.radio" value="ng" />\n                                    <label for="channel-radio-nbg<%- _id %>" class="label label-selectmenu"><%- msg.G_Channel %></label>\n                                    <div class="selectmenu-group">\n                                        <div>\n                                            <select name="ng.channel" id="channel-radio-nbg<%- _id %>" class="radio-channel inline"></select>\n                                        </div>\n                                        <div>\n                                            <select name="ng.ht" class="inline radio-ht" data-radio="ng">\n                                                <option value="20"><%- msg.G_PropertiesHT20 %></option>\n                                                <option value="40"><%- msg.G_PropertiesHT40 %></option>\n                                            </select>\n                                        </div>\n                                    </div>\n                                </div>\n                                <div class="row">\n                                    <label for="txPower-radio-nbg<%- _id %>" class="label label-selectmenu"><%- msg.G_PropertiesTXPower %></label>\n                                    <select name="ng.tx_power_mode" id="txPower-radio-nbg<%- _id %>" class="inline">\n                                        <option value="auto"><%- msg.G_Auto %></option>\n                                        <option value="high"><%- msg.G_High %></option>\n                                        <option value="medium"><%- msg.G_Medium %></option>\n                                        <option value="low"><%- msg.G_Low %></option>\n                                        <option value="custom"><%- msg.G_Custom %></option>\n                                    </select>\n                                </div>\n                                <div class="custom">\n                                    <div class="row">\n                                        <input class="input no-label" type="text" name="ng.tx_power" size="2" value="<%- get(\'ng.tx_power\') || \'0\' %>" />\n                                        <label class="label unit"><%- msg.G_PropertiesDBM %></label>\n                                    </div>\n                                </div>\n                                <div class="row antenna-gain">\n                                    <label class="label custom-label" for="antenna-gain<%- _id %>"><%- msg.G_PropertiesAntennaGain %></label>\n                                    <input class="custom input" id="antenna-gain<%- _id %>" type="number" max="99" min="-99" step="1" name="ng.antenna_gain" value="<%- get(\'ng.antenna_gain\') || \'6\' %>" />\n                                    <label class="label unit"><%- msg.G_PropertiesDBI %></label>\n                                </div>\n                                <div class="row">\n                                    <label for="minRssiEnabled-radio-ng<%- _id %>" class="label label-selectmenu"><%- msg.G_SettingsMinRSSI %></label>\n                                    <input class="input rssiCheckbox" type="checkbox" name="ng.min_rssi_enabled" id="minRssiEnabled-radio-ng<%- _id %>" />\n                                    <input class="input rssiInput" type="number" name="ng.min_rssi" id="minRssi-radio-ng<%- _id %>" size="2" title="<%- msg.G_SettingsRecntClntsRSSI %>" min="-94" max="-1"/>\n                                    <span class="rssiSpan"> <%- msg.G_PropertiesDBM %></span>\n                                </div>\n                            </fieldset>\n                            <fieldset class="fieldset radio-na ap-na-configs">\n                                <legend class="legend"><%- msg.G_PropertiesRadio5G11NA %></legend>\n                                <div class="row">\n                                    <input type="hidden" class="hidden" name="na.radio" value="na" />\n                                    <label for="channel-radio-na<%- _id %>" class="label label-selectmenu"><%- msg.G_Channel %></label>\n                                    <div class="selectmenu-group">\n                                        <div>\n                                            <select name="na.channel" id="channel-radio-na<%- _id %>" class="radio-channel inline"></select>\n                                        </div>\n                                        <div>\n                                            <select name="na.ht" class="radio-ht inline" data-radio="na">\n                                                <option value="20"><%- msg.G_PropertiesHT20 %></option>\n                                                <option value="40"><%- msg.G_PropertiesHT40 %></option>\n                                                <option value="80"><%- msg.G_PropertiesHT80 %></option>\n                                            </select>\n                                        </div>\n                                    </div>\n                                </div>\n                                <div class="row">\n                                    <label for="txPower-radio-na<%- _id %>" class="label label-selectmenu"><%- msg.G_PropertiesTXPower %></label>\n                                    <select name="na.tx_power_mode" id="txPower-radio-na<%- _id %>" class="inline">\n                                        <option value="auto"><%- msg.G_Auto %></option>\n                                        <option value="high"><%- msg.G_High %></option>\n                                        <option value="medium"><%- msg.G_Medium %></option>\n                                        <option value="low"><%- msg.G_Low %></option>\n                                        <option value="custom"><%- msg.G_Custom %></option>\n                                    </select>\n                                </div>\n                                <div class="custom">\n                                    <div class="row">\n                                        <input class="input no-label" type="text" name="na.tx_power" size="2" value="<%- get(\'na.tx_power\') || \'0\' %>" />\n                                        <label class="label unit"><%- msg.G_PropertiesDBM %></label>\n                                    </div>\n                                </div>\n                                <div class="row antenna-gain">\n                                    <label class="label custom-label" for="antenna-gain-na<%- _id %>"><%- msg.G_PropertiesAntennaGain %></label>\n                                    <input class="custom input" id="antenna-gain-na<%- _id %>" type="number" max="99" min="-99" step="1" name="na.antenna_gain" value="<%- get(\'na.antenna_gain\') || \'6\' %>" />\n                                    <label class="label unit"><%- msg.G_PropertiesDBI %></label>\n                                </div>\n                                <div class="row">\n                                    <label for="minRssiEnabled-radio-na<%- _id %>" class="label label-selectmenu"><%- msg.G_SettingsMinRSSI %></label>\n                                    <input class="input rssiCheckbox" type="checkbox" name="na.min_rssi_enabled" id="minRssiEnabled-radio-na<%- _id %>" />\n                                    <input class="input rssiInput" type="number" name="na.min_rssi" id="minRssi-radio-na<%- _id %>" size="2" title="<%- msg.G_SettingsRecntClntsRSSI %>" min="-94" max="-1"/>\n                                    <span class="rssiSpan"> <%- msg.G_PropertiesDBM %></span>\n                                </div>\n                            </fieldset>\n                            <button class="button is-admin" type="submit"><%- msg.G_Apply %></button>\n                        </form>\n                    </div>\n\n                    <div class="accordion-header">\n                        <div class="accordion-title"><%- msg.G_PropertiesWLANS %></div>\n                    </div>\n                    <div>\n                        <fieldset class="fieldset ap-ng-configs radio-ng fieldset-wlan">\n                            <div class="settings-list">\n                                <legend class="legend"><%- msg.G_PropertiesWLANS2G11NBG %></legend>\n                                <div class="row">\n                                    <label for="wlan-group-ng<%- _id %>" class="label label-selectmenu wide"><%- msg.G_PropertiesWLANGroup %></label>\n                                    <div class="is-admin bind-wlan-group-ng">\n                                        <select name="wlan-group-ng" id="wlan-group-ng<%- _id %>" data-radio="ng" class="inline select-wlan wlan-group-ng"></select>\n                                    </div>\n                                    <div class="table-wlans table-wlans-ng data-table data-table-wlans-ng"></div>\n                            </div>\n                        </fieldset>\n                        <fieldset class="fieldset ap-na-configs radio-na fieldset-wlan">\n                            <div class="settings-list">\n                                <legend class="legend"><%- msg.G_PropertiesWLANS5G11NA %></legend>\n                                <div class="row">\n                                    <label for="wlan-group-na<%- _id %>" class="label label-selectmenu wide"><%- msg.G_PropertiesWLANGroup %></label>\n                                    <div class="is-admin bind-wlan-group-na">\n                                        <select name="wlan-group-na" id="wlan-group-na<%- _id %>" data-radio="na" class="inline select-wlan wlan-group-na"></select>\n                                    </div>\n                                    <div class="table-wlans table-wlans-na data-table data-table-wlans-na"></div>\n                                    <div class=\'WLANSDisabled\'><%- msg.G_5GWLANSDisabled %></div>\n                                </div>\n                            </div>\n                        </fieldset>\n                        <fieldset class="fieldset override-form">\n                            <form>\n                                <legend class="legend"><%- msg.G_Override %></legend>\n                                <div class="row">\n                                    <label class="label" for="override-enabled<%- _id %>"><%- msg.G_Enabled %></label>\n                                    <input class="input checkbox" type="checkbox" name="wlanEnabled" id="override-enabled<%- _id %>" />\n                                    <span><%- msg.G_PropertiesEnblOnAP %></span>\n                                </div>\n                                <div class="row">\n                                    <label class="label" for="override-vlan<%- _id %>"><%- msg.G_PropertiesVLAN %></label>\n                                    <input class="input checkbox" type="checkbox" name="vlanEnabled" id="override-vlan<%- _id %>" />\n                                    <span><%- msg.G_PropertiesUseVLANId %></span>\n                                    <input class="input small" type="text" name="vlan" maxlength="4" size="3" />\n                                </div>\n                                <div class="row ssid-row">\n                                    <label class="label inline" for="override-ssid<%- _id %>"><%- msg.G_PropertiesSSID %></label>\n                                    <input class="input inline" type="text" name="name" id="override-ssid<%- _id %>" />\n                                </div>\n                                <div class="row wpapsk">\n                                    <label class="label inline" for="override-psk<%- _id %>"><%- msg.G_PropertiesPSK %></label>\n                                    <input class="input inline" type="text" name="passphrase" id="override-psk<%- _id %>" />\n                                </div>\n                                <button class="button is-admin" type="submit"><%- msg.G_Apply %></button>\n                                <button class="button is-admin" name="restore" value="Restore" type="button"><%- msg.G_PropertiesRestore %></button>\n                                <button class="button" name="cancel" value="Cancel" type="button"><%- msg.G_Cancel %></button>\n                            </form>\n                        </fieldset>\n                    </div>\n\n                    <div class="accordion-header">\n                        <div class="accordion-title"><%- msg.G_Network %></div>\n                    </div>\n                    <div>\n                        <form action="" class="networkForm bind-network">\n                            <div class="clearfix">\n                                <div class="side-by-side">\n                                    <div class="row">\n                                        <label for="configure-ip<%- _id %>" class="label inline"><%- msg.G_PropertiesConfigIP %></label>\n                                        <select name="type" class="configure-ip" id="configure-ip<%- _id %>">\n                                            <option value="dhcp"><%- msg.G_PropertiesUsingDHCP %></option>\n                                            <option value="static"><%- msg.G_PropertiesStaticIP %></option>\n                                        </select>\n                                    </div>\n                                </div>\n                            </div>\n\n                            <div class="clearfix">\n                                <div class="side-by-side">\n                                    <div class="row connection-toggled connection-static">\n                                        <label class="label inline"><%- msg.G_IPAddress %></label>\n                                        <input type="text" class="input inline" name="ip" size="17" value="" />\n                                    </div>\n                                    <div class="row connection-toggled connection-static">\n                                        <label class="label inline"><%- msg.G_PropertiesSubnetMask %></label>\n                                        <input type="text" class="input inline" name="netmask" size="17" value="" />\n                                    </div>\n                                    <div class="row connection-toggled connection-static">\n                                        <label class="label inline"><%- msg.G_PropertiesGateway %></label>\n                                        <input type="text" class="input inline" name="gateway" size="17" value="" />\n                                    </div>\n                                </div>\n\n                                <div class="side-by-side">\n                                    <div class="row connection-toggled connection-static">\n                                        <label class="label inline"><%- msg.G_PropertiesPreferredDNS %></label>\n                                        <input type="text" class="input inline" name="dns1" size="17" value="" />\n                                    </div>\n                                    <div class="row connection-toggled connection-static">\n                                        <label class="label inline"><%- msg.G_PropertiesAlternateDNS %></label>\n                                        <input type="text" class="input inline" name="dns2" size="17" value="" />\n                                    </div>\n                                    <div class="row connection-toggled connection-static">\n                                        <label class="label inline"><%- msg.G_PropertiesDNSSuffix %></label>\n                                        <input type="text" class="input inline" name="dnssuffix" size="17" value="" />\n                                    </div>\n                                </div>\n                            </div>\n                            <button class="button is-admin"><%- msg.G_Apply %></button>\n                        </form>\n                    </div>\n                    <div class="accordion-header ap-dualband-configs">\n                        <div class="accordion-title"><%- msg.G_PropertiesBandSteering %></div>\n                    </div>\n                    <div class="ap-dualband-configs">\n                        <form>\n                            <div class="clearfix">\n                                <div class="buttonset band-steering">\n                                  <input type="radio" id="bandSteeringTo5G_<%- _id %>" name="bandSteeringSelection" value="prefer_5g" />\n                                  <label for="bandSteeringTo5G_<%- _id %>"><%- msg.G_PropertiesPrefer5G %></label>\n                                  <input type="radio" id="bandSteeringEqual_<%- _id %>" name="bandSteeringSelection" value="equal" />\n                                  <label for="bandSteeringEqual_<%- _id %>"><%- msg.G_PropertiesBalanced %></label>\n                                  <input type="radio" id="bandSteeringOff_<%- _id %>" name="bandSteeringSelection" value="off" />\n                                  <label for="bandSteeringOff_<%- _id %>"><%- msg.G_SettingsOff %></label>\n                              </div>\n                            </div>\n                        </form>\n                    </div>\n                    <!-- <div class="accordion-header">\n                        <div class="accordion-title"><%- msg.G_PropertiesAirtimeFairness %></div>\n                    </div>\n                    <div>\n                        <form>\n                            <div class="clearfix">\n                                <div class="buttonset airtime-fairness">\n                                    <input type="radio" id="airtimeFairnessOff_<%- _id %>" name="bandSteeringSelection" value="false" />\n                                    <label for="airtimeFairnessOff_<%- _id %>"><%- msg.G_SettingsOff %></label>\n                                    <input type="radio" id="airtimeFairnessOn_<%- _id %>" name="bandSteeringSelection" value="true" />\n                                    <label for="airtimeFairnessOn_<%- _id %>"><%- msg.G_SettingsOn %></label>\n                                </div>\n                            </div>\n                        </form>\n                    </div> -->\n                    <!-- <div class="accordion-header">\n                        <div class="accordion-title"><%- msg.G_PropertiesAggregationFragmentation %></div>\n                    </div>\n                    <div>\n                        <fieldset class="fieldset">\n                            <form>\n                                <div class="clearfix">\n                                    <div class="buttonset aggregation-fragmentation">\n                                        <input type="radio" id="aggregationFragmentationOff_<%- _id %>" name="bandSteeringSelection" value="off" />\n                                        <label for="aggregationFragmentationOff_<%- _id %>"><%- msg.G_SettingsOff %></label>\n                                        <input type="radio" id="aggregationFragmentationOn_<%- _id %>" name="bandSteeringSelection" value="on" />\n                                        <label for="aggregationFragmentationOn_<%- _id %>"><%- msg.G_SettingsOn %></label>\n                                        <input type="radio" id="aggregationFragmentationAuto_<%- _id %>" name="bandSteeringSelection" value="auto" />\n                                        <label for="aggregationFragmentationAuto_<%- _id %>"><%- msg.G_PropertiesAuto %></label>\n                                    </div>\n                                    <br/>\n                                    <legend class="legend">Adjust Setting</legend>\n                                    <div class=\'slider-wrapper\'>\n                                        <div class=\'aggregation-fragmentation-slider slider\'></div>\n                                        <label>Lower Latency</label>\n                                        <label>Higher Throughput</label>\n                                    </div>\n                                </div>\n                            </form>\n                        </fieldset>\n                    </div> -->\n                    <div class="accordion-header ap-uplinks-select">\n                        <div class="accordion-title"><%- msg.G_PropertiesWirelessUplinks %></div>\n                    </div>\n                    <div class="ap-uplinks-select ap-uplinks-content">\n                        <div class="data-table-uplinks-none"><%- msg.G_PropertiesNoWirelssUplnks %></div>\n                        <div class="data-table data-table-uplinks"></div>\n                    </div>\n\n                    <div class="accordion-header is-admin">\n                        <div class="accordion-title"><%- msg.G_PropertiesCustomUpgrade %></div>\n                    </div>\n                    <div class="is-admin">\n                        <div class="row">\n                            <%- msg.G_PropertiesCustomFirmwareTxt %>\n                        </div>\n                        <button class="button custom-upgrade left">\n                            <span class="ui-button-icon-primary ubnt-icon-download"></span>\n                            <span class="nav-text"><%- msg.G_PropertiesCustomUpgrade %></span>\n                        </button>\n                    </div>\n\n                    <div class="accordion-header is-admin">\n                        <div class="accordion-title"><%- msg.G_PropertiesForgetAP %></div>\n                    </div>\n                    <div class="is-admin">\n                        <div class="row">\n                            <%- msg.G_PropertiesForgetAPTxt %>\n                        </div>\n                        <button class="button forget left">\n                            <span class="ui-button-icon-primary ubnt-icon-forget-this-network"></span>\n                            <span class="nav-text"><%- msg.G_PropertiesForget %></span>\n                        </button>\n                        <div class="left">\n                            <select name="move" class="move-dropdown" data-myposition="left bottom" data-atposition="left top"></select>\n                        </div>\n                        <!--<button class="button shell">Shell</button>-->\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class="dialog-controls is-admin clearfix">\n            <button class="button button-locate left">\n                <span class="ui-button-icon-primary ubnt-icon-location sidebar-icons locate"></span>\n                <span class="nav-text"><%- msg.G_Locate %></span>\n            </button>\n            <button class="button button-restart left">\n                <span class="ui-button-icon-primary ubnt-icon-rotate sidebar-icons restart"></span>\n                <span class="nav-text"><%- msg.G_Restart %></span>\n            </button>\n            <button class="button button-update left">\n                <span class="ui-button-icon-primary ubnt-icon-download sidebar-icons update"></span>\n                <span class="nav-text"><%- msg.G_Upgrade %></span>\n            </button>\n            <button class="button button-adopt left">\n                <span class="ui-button-icon-primary ubnt-icon-plus sidebar-icons adopt"></span>\n                <span class="nav-text"><%- msg.G_Adopt %></span>\n            </button>\n        </div>\n    </div>\n</div>\n';
}),define("unifi/view/aps/PropertyView",["unifi/view/devices/PropertyView","unifi/view/aps/RfEnvironmentView","unifi/view/aps/RfLegendView","ubnt/backgrid","underscore","backbone","jquery","msg/Msg","unifi/model/Device","unifi/collection/SystemInfos","unifi/collection/WlanGroups","unifi/collection/Wlans","unifi/collection/Sites","text!includes/aps/apPropertiesTemplate.html","ubnt/view/dialogs/AlertDialogView","ubnt/view/dialogs/ConfirmDialogView","libs/moment","stickit"],function(e,t,a,n,i,o,r,s,c,d,l,m,g,u,h,p,y){"use strict";return e.extend({templateId:u,events:{"change input[name=ap-rf-frequency-filter]":"_onRfEnvironmentFrequencyChange"},initialize:function(t){this.configuredRadios=!1,e.prototype.initialize.call(this,t),this.listenTo(this.app.collection("Wlans"),"add remove destroy change",this.setupWlanPanel),this.listenTo(this.model,"change:radio_na change:radio_ng",r.proxy("updateRadiosForm",this))},bindings:function(){var t={".bind-lastseen":{observe:"last_seen",onGet:function(){this.$bindLastseen.text(this.model.lastSeen())}},".bind-lastuplink":{observe:["last_uplink","uplink"],onGet:function(){this.$bindLastUplink.text(this.model.uplinkDeviceText())}},".bind-num-users":{observe:"user-num_sta",onGet:function(e){this.$bindNumUsers.text(e||0)}},".bind-num-guests":{observe:"guest-num_sta",onGet:function(e){this.$bindNumGuests.text(e||0)}},".bind-uplink-device":{observe:"uplink",onGet:function(){this.$bindUplinkDevice.text(this.model.uplinkDeviceText()),this.$bindUplinkRssi.text(this.model.uplinkRssi()),this.$bindUplinkTxRate.text(this.model.uplinkTxRate()),this.$bindUplinkRxRate.text(this.model.uplinkRxRate()),this.$bindUplinkSpeed.text(this.model.uplinkSpeed()),this.$bindUplinkDuplex.text(this.model.uplinkDuplex()),this.$bindUplinkDownPackets.text(this.model.uplinkDownPackets()),this.$bindUplinkUpPackets.text(this.model.uplinkUpPackets()),this.$bindUplinkActivity.text(this.model.uplinkActivity()),this.$statusBar.removeClass("ok pending error").addClass(this.model.statusType()).text(this.model.status())}},".bind-ng-channel":{observe:["ng-state","ng-extchannel","ng-channel","na-state","na-extchannel","na-channel"],onGet:function(){this.$bindNgChannel.text(this.model.channel("ng")),this.$bindNaChannel.text(this.model.channel("na"))}},".bind-ng-transmit-power":{observe:["ng-tx_power","ng-gain","ng-eirp","na-tx_power","na-gain","na-eirp"],onGet:function(){var e=this.model.transmitPower("ng"),t=this.model.transmitPower("na"),a=" "+s.G_PropertiesDBM+" ("+s.G_PropertiesEIRP+")";this.$bindNgTransmitPower.text(i.isUndefined(e)?"":e+a),this.$bindNaTransmitPower.text(i.isUndefined(t)?"":t+a)}},".bind-ng-tx-packets":{observe:"stat",onGet:function(){this.$bindNgTxPackets.text(this.model.packetsPerBytes("ng","tx")),this.$bindNgRxPackets.text(this.model.packetsPerBytes("ng","rx")),this.$bindNgTxRetry.text(this.model.errorPercentage("ng","tx")),this.$bindNgRxRetry.text(this.model.errorPercentage("ng","rx")),this.$bindNaTxPackets.text(this.model.packetsPerBytes("na","tx")),this.$bindNaRxPackets.text(this.model.packetsPerBytes("na","rx")),this.$bindNaTxRetry.text(this.model.errorPercentage("na","tx")),this.$bindNaRxRetry.text(this.model.errorPercentage("na","rx"))}},".bind-na-users":{observe:["na-user-num_sta"],onGet:function(){this.$bindNaUsers.text(this.model.get("na-user-num_sta")||0)}},".bind-ng-users":{observe:["ng-user-num_sta"],onGet:function(){this.$bindNgUsers.text(this.model.get("ng-user-num_sta")||0)}},".bind-na-guests":{observe:["na-guest-num_sta"],onGet:function(){this.$bindNaGuests.text(this.model.get("na-guest-num_sta")||0)}},".bind-ng-guests":{observe:["ng-guest-num_sta"],onGet:function(){this.$bindNgGuests.text(this.model.get("ng-guest-num_sta")||0)}},".bind-wlan-group-ng":{observe:"wlangroup_id_ng",updateView:!1,onGet:function(e){this.$bindWlanGroupNg.find("select").val(e).trigger("change",!0),this.setupWlanTable("ng")}},".bind-wlan-group-na":{observe:"wlangroup_id_na",updateView:!1,onGet:function(e){this.$bindWlanGroupNa.find("select").val(e).trigger("change",!0),this.setupWlanTable("na")}},".bind-network":{observe:"config_network",onGet:function(e){this.populateNetworkForm(this.$networkForm,e)}}},a={};return this.model.isGen2Ap()&&i.extend(a,{".bind-rf-environment-2G":{observe:"spectrum_table_ng",onGet:function(e){this.populateRfEnvironment(this.$bindRfEnvironment2G,e,"ng")}},".bind-rf-environment-5G":{observe:"spectrum_table_na",onGet:function(e){this.populateRfEnvironment(this.$bindRfEnvironment5G,e,"na")}}}),i.extend({},e.prototype.bindings.call(this),t,a)},updateScanDisplay:function(){var e=this.model.get("spectrum_scanning"),t=this.model.get("spectrum_table_time_na"),a=this.model.get("spectrum_table_time_ng");e?(this.$bindRfEnvironmentLastUpdated2G.text(s.G_PropertiesRFScanScanning),this.$bindRfEnvironmentLastUpdated5G.text(s.G_PropertiesRFScanScanning)):(this.$bindRfEnvironmentLastUpdated5G.text(s.localize(s.G_PropertiesRFLastUpdated,this.model.lastScan(t))),this.$bindRfEnvironmentLastUpdated2G.text(s.localize(s.G_PropertiesRFLastUpdated,this.model.lastScan(a)))),this.toggleRfScanButton(e)},dependencies:function(){var e={SystemInfos:d,WlanGroups:l,Wlans:m,Sites:g},t=[],a={},n=this;i.each(e,function(e,n){t.push(a[n]=r.Deferred())},this),r.when.apply(r,t).then(function(){n._dependencies.resolve()},function(){n._dependencies.reject()}),i.each(e,function(e,t){this.app.collection(t,{fetch:{reload:!1,deferred:a[t]}},e)},this)},render:function(t){var a=this.rendered;return e.prototype.render.call(this,t),a||(this.$advAdoptForm=this.$(".advAdoptForm"),this.$radiosForm=this.$(".radiosForm"),this.$networkForm=this.$(".networkForm"),this.$shell=this.$(".shell"),this.$connectionType=this.$(".configure-ip"),this.$bandSteering=this.$(".band-steering"),this.$btnLocate=this.$(".button-locate"),this.$btnRestart=this.$(".button-restart"),this.$btnUpdate=this.$(".button-update"),this.$btnAdopt=this.$(".button-adopt"),this.$overrideFieldset=this.$(".override-form"),this.$overrideForm=this.$overrideFieldset.find("form"),this.$fieldsetWlans=this.$(".fieldset-wlan"),this.$uplinkDevice=this.$(".button-uplink-device"),this.$bindUptime=this.$(".bind-uptime"),this.$bindLastseen=this.$(".bind-lastseen"),this.$bindLastUplink=this.$(".bind-lastuplink"),this.$bindNumUsers=this.$(".bind-num-users"),this.$bindNumGuests=this.$(".bind-num-guests"),this.$bindUplinkDevice=this.$(".bind-uplink-device"),this.$bindUplinkRssi=this.$(".bind-uplink-rssi"),this.$bindUplinkTxRate=this.$(".bind-uplink-tx-rate"),this.$bindUplinkRxRate=this.$(".bind-uplink-rx-rate"),this.$bindUplinkSpeed=this.$(".bind-uplink-speed"),this.$bindUplinkDuplex=this.$(".bind-uplink-duplex"),this.$bindUplinkDownPackets=this.$(".bind-uplink-down-packets"),this.$bindUplinkUpPackets=this.$(".bind-uplink-up-packets"),this.$bindUplinkActivity=this.$(".bind-uplink-activity"),this.$bindAdoptIp=this.$(".bind-adopt-ip"),this.$bindAdoptUrl=this.$(".bind-adopt-url"),this.$bindDownlinks=this.$(".bind-downlinks"),this.$bindNgChannel=this.$(".bind-ng-channel"),this.$bindNgTransmitPower=this.$(".bind-ng-transmit-power"),this.$bindNgTxPackets=this.$(".bind-ng-tx-packets"),this.$bindNgRxPackets=this.$(".bind-ng-rx-packets"),this.$bindNgTxRetry=this.$(".bind-ng-tx-retry"),this.$bindNgRxRetry=this.$(".bind-ng-rx-retry"),this.$bindNgUsers=this.$(".bind-ng-users"),this.$bindNgGuests=this.$(".bind-ng-guests"),this.$bindNaChannel=this.$(".bind-na-channel"),this.$bindNaTransmitPower=this.$(".bind-na-transmit-power"),this.$bindNaTxPackets=this.$(".bind-na-tx-packets"),this.$bindNaRxPackets=this.$(".bind-na-rx-packets"),this.$bindNaTxRetry=this.$(".bind-na-tx-retry"),this.$bindNaRxRetry=this.$(".bind-na-rx-retry"),this.$bindNaUsers=this.$(".bind-na-users"),this.$bindNaGuests=this.$(".bind-na-guests"),this.$bindWlanGroupNg=this.$(".bind-wlan-group-ng"),this.$bindWlanGroupNa=this.$(".bind-wlan-group-na"),this.$rfScanButton=this.$(".button-rfScan"),this.$bindRfEnvironment=this.$(".bind-rf-environment"),this.$bindRfEnvironment2G=this.$(".bind-rf-environment-2G"),this.$bindRfEnvironment5G=this.$(".bind-rf-environment-5G"),this.$bindRfEnvironmentLastUpdated=this.$(".bind-rf-environment-last-updated"),this.$bindRfEnvironmentLastUpdated2G=this.$(".bind-rf-environment-last-updated-2G"),this.$bindRfEnvironmentLastUpdated5G=this.$(".bind-rf-environment-last-updated-5G"),this.$bindRfLegend=this.$(".bind-rf-legend"),this.noUserRows=this.$(".data-table-users").html(),this.noGuestRows=this.$(".data-table-guests").html(),this.noDownlinkRows=this.$(".data-table-downlinks").html(),this.noUplinkRows=this.$(".data-table-uplinks").html(),this.noWlanRows_ng=this.$(".data-table-wlans-ng").html(),this.noWlanRows_na=this.$(".data-table-wlans-na").html(),this.wLanOverrideModel=null,this.wLanOverrideRadio=null,this.$(".buttonset").buttonset(),this.$advAdoptForm.on("submit",this.onAdvAdoptFormSubmit),this.$networkForm.on("submit",r.proxy(function(e){e.preventDefault(),this.updateNetwork(this.$networkForm,"config_network")},this)),this.$radiosForm.on("submit",this.updateRadios),this.$bandSteering.on("change","input",this.saveBandSteering),this.$shell.on("click",this.shell),this.$(".button-block").on("click",this.blockUser),this.$(".button-reconnect").on("click",this.reconnectUser),this.$uplinkDevice.on("click",this.displayUplinkDevice),this.$connectionType.on("change",r.proxy(function(e){var t=r(e.target).val();this.$networkForm.find(".connection-toggled").hide().filter(".connection-"+t).show()},this)).trigger("change"),this.$overrideForm.on("submit",this.onOverrideFormSubmit),this.$overrideForm.find('button[name="restore"]').on("click",this.onOverrideFormRestore),this.$overrideForm.find('button[name="cancel"]').on("click",this.onOverrideFormCancel),this.$("select.wlan-group-ng").on("change",this.updateWlan),this.$("select.wlan-group-na").on("change",this.updateWlan),this.$('input[name="ng.min_rssi_enabled"]').on("change",this.updateMinRSSIForm),this.$('input[name="na.min_rssi_enabled"]').on("change",this.updateMinRSSIForm),this.$("select.radio-ht").on("change",this.updateChannelSelect),"resolved"===this._rendered.state()&&"resolved"==this._dependencies.state()?(this.configuredRadios=!1,this.populate()):"pending"===this._rendered.state()&&this._rendered.resolve(),this.model.isGen2Ap()?(this._showRfTab(this.$bindRfEnvironment2G,this.$bindRfEnvironmentLastUpdated2G),this.renderRfLegend(),this.$rfScanButton.on("click",this.onRfScanClick),this.updateScanDisplay(this.model.get("spectrum_scanning"))):this.$(".ap-rf-environment").hide(),this.stickit(this.model,this.bindings())),this.options.options&&this.options.options.section&&this.setSection(this.options.options.section),this},setSection:function(e){if(e){var t,a;switch(e){case"rfMap":t=0,a=6;break;case"config":t=3,a=0}this.$tabs.tabs("option","active",t),this.$el.find(".properties-container > div:nth-child("+(t+1)+") > .accordion").accordion("option","active",a),this.options.options.section=null}},toggleRfScanButton:function(e){e===!0?this.$rfScanButton.addClass("disabled").attr("disabled","disabled"):this.$rfScanButton.removeClass("disabled").removeAttr("disabled")},populate:function(){if(e.prototype.populate.call(this),this._dependencies&&"resolved"==this._dependencies.state()){var t=this.model.isConnected(),a=this.model.uplink(),n=a?"wireless"===a.type:!1,o=!1;this.$el.removeClass("ap-uplink-wire ap-uplink-wireless ap-has-downlinks ap-needs-uplinks ap-ng-radio ap-na-radio ap-dualband-radio"),this.model.get("adopted")&&(this.model.get("locating")?this.$btnLocate.addClass("locating"):this.$btnLocate.removeClass("locating")),this.setupAP(),i.each(this.model.uplinks(),function(e,t){t.configured&&(o=!0)}),this.model.get("vwireEnabled")&&(n||o||!t)&&(this.$el.addClass("ap-needs-uplinks"),t||this.setupUplinksTable()),this.model.isGen2Ap()&&this.updateScanDisplay(),this.position()}},setupAP:function(){var e=this.model.hasRadio("ng"),t=this.model.hasRadio("na"),a=i.size(this.model.downlinks())>0,n=this.model.uplink()||{},o=(this.model.downlinks(),this.model.is11ac());"eth0"==n.name||"eth1"==n.name?(this.$el.addClass("ap-uplink-wire"),this.$(".uplink-type").text("("+s.G_Wire+")")):"ath0"==n.name&&(this.$el.addClass("ap-uplink-wireless"),this.$(".uplink-type").text("("+s.G_Wireless+")")),this.setupUplinksTable(),this.setupDownlinksTable(),this.systemInfo=this.app.collection("SystemInfos").at(0),this.currentCCode=this.systemInfo.get("cur_ccode"),this.currentCountryKey=this.currentCCode.key,this.currentCCode.ht40_ng||this.$('select[name="ng.ht"] option[value=40]').remove(),this.currentCCode.ht40_na||this.$('select[name="na.ht"] option[value=40]').remove(),this.currentCCode.channels_na_80&&0!==this.currentCCode.channels_na_80.length&&this.model.is11ac()||this.$('select[name="na.ht"] option[value=80]').remove(),a&&this.$el.addClass("ap-has-downlinks"),e&&this.$el.addClass("ap-ng-radio"),t&&(this.$el.addClass("ap-na-radio"),o&&(this.$("fieldset.ap-na-configs legend").text(s.G_PropertiesRadio5G11AC),this.$("fieldset.ap-na-configs.fieldset-wlan legend").text(s.G_PropertiesWLANS5G11AC),this.$("div.radio-na").find("div.accordion-title").text(s.G_PropertiesRadio11AC))),t&&e&&this.$el.addClass("ap-dualband-radio"),this.configuredRadios||this.updateRadiosForm(),this.updateBandSteering(),this.userTable(),this.guestTable(),this.$("select.radio-ht").each(function(){r(this).trigger("change")}),this.setupWlanPanel()},onRfScanClick:function(e){var t=r(e.target);if(!t.hasClass("disabled")){var a=new p;return a.options.dialogOptions.title=s.G_PropertiesRFScanConfirmTitle,a.show(s.G_PropertiesRFScanConfirmTxt,r.proxy(function(){this.toggleRfScanButton(!0),this.$bindRfEnvironmentLastUpdated2G.text(s.G_PropertiesRFScanScanning),this.$bindRfEnvironmentLastUpdated5G.text(s.G_PropertiesRFScanScanning),this.model.spectrumScan()},this)),!1}},onAdvAdoptFormSubmit:function(e){e.preventDefault();var t=this,a=this.model,n=r(e.target).find("button");this.$advAdoptForm.find(".error").removeClass("error"),n.attr("disabled","disabled");var o=a.advanceAdopt({data:{ip:this.$advAdoptForm.find('input[name="ip"]').val(),port:this.$advAdoptForm.find('input[name="port"]').val(),username:this.$advAdoptForm.find('input[name="username"]').val(),password:this.$advAdoptForm.find('input[name="password"]').val(),url:this.$advAdoptForm.find('input[name="url"]').val()},success:function(e){"ok"===e.meta.rc?a.fetch({success:function(e,a,n){"ok"===a.meta.rc&&t.parent.property(e)},complete:function(){n.removeAttr("disabled")}}):(t.showErrorState(),n.removeAttr("disabled"))},error:function(){t.showErrorState(),n.removeAttr("disabled")}});!o&&this.model.validationError&&i.each(this.model.validationError,function(e,t){switch(t){case"username":case"password":this.$advAdoptForm.find('input[name="'+t+'"]').addClass("error"),n.removeAttr("disabled")}},this)},displayUplinkDevice:function(){var e=this.app.routers.devices.views.index,t=e.collection.getDeviceFromMac(this.model.uplinkDeviceMac()),a=t&&e.property(t),n=this.model.uplinkRemotePort();return n&&(a.$el.find(".switchPorts-anchor").click(),i.delay(function(){a.$el.find(".port-"+n).click()},100)),!1},userAndGuestColumns:function(){var e=this;return[{name:"hostname",label:s.G_Name,editable:!1,sortable:!1,headerCell:n.Headers.noSortHeader,cell:n.Cells.ModelCell.extend({callback:"name"}),callback:function(t){var a=e.app.routers.clients.views.index,n=a.collection.getClientFromMac(t.get("mac"));a.property(n)}},{name:"essid",label:s.G_Wlan,editable:!1,sortable:!1,headerCell:n.Headers.noSortHeader,cell:"string"},{name:"signal",label:s.G_DevicesSignal,editable:!1,cell:n.Cells.ModelCell.extend({callback:"signalWithDbm"})},{name:"tx_rate",label:s.G_DevicesTX,editable:!1,cell:n.Cells.ModelCell.extend({callback:"txRateInM"})}]},userTable:function(){if(!this.rendered)return!1;var e=this.app.collection("Clients"),t=e.where({ap_mac:this.model.get("mac"),is_guest:!1});this.grids.users?this.grids.users.collection.set(t):this.grids.users=this.grid(this.userAndGuestColumns(),new o.Collection(t),this.$(".data-table-users"),this.noUserRows)},guestTable:function(){if(!this.rendered)return!1;var e=this.app.collection("Clients"),t=e.where({ap_mac:this.model.get("mac"),is_guest:!0});this.grids.guests?this.grids.guests.collection.set(t):this.grids.guests=this.grid(this.userAndGuestColumns(),new o.Collection(t),this.$(".data-table-guests"),this.noGuestRows)},updateRadioTable:function(e){var t,a=this;i.each(e,function(e){if(t=a.model.getRadio(e.radio),void 0!==t)for(var n in e)e.hasOwnProperty(n)&&(t[n]=e[n])})},updateRadiosForm:function(){var e,t,a=this;i.each(this.model.get("radio_table"),function(n){t=n.radio,e=a.$("fieldset.radio-"+t),e.find('select[name="'+t+'.ht"]').val(n.ht||("ng"==t?20:40)).change(),e.find('select[name="'+t+'.tx_power_mode"]').val(n.tx_power_mode||"auto").change(),e.find('input[name="'+t+'.tx_power"]').val(n.tx_power||"0"),e.find('input[name="'+t+'.antenna_gain"]').val(n.antenna_gain||"6"),e.find('input[name="'+t+'.min_rssi_enabled"]').prop("checked",n.min_rssi_enabled||!1),e.find('input[name="'+t+'.min_rssi"]').val(n.min_rssi||"-94"),n.builtin_antenna!==!1&&e.find("div.antenna-gain").remove(),"custom"===n.tx_power_mode?e.find("div.custom").show():e.find("div.custom").hide(),this.configuredRadios=!0},this),this.configuredRadios&&(this.updateMinRSSIForm(),this.renderSelects())},updateRadios:function(){var e=this,t=this.$radiosForm.serializeObject(),a={},n={},o=[],r=0,c=0,d="",l=!0,m={};return i.each(t,function(e,t){0===t.indexOf("ng.")?a[t.replace("ng.","")]=e:0===t.indexOf("na.")&&(n[t.replace("na.","")]=e)}),a&&this.model.hasRadio("ng")&&(this.$radiosForm.find('input[name="ng.min_rssi_enabled"]').prop("checked")?a.min_rssi_enabled=!0:(a.min_rssi_enabled=!1,delete a.min_rssi),o.push(a)),n&&this.model.hasRadio("na")&&(this.$radiosForm.find('input[name="na.min_rssi_enabled"]').prop("checked")?n.min_rssi_enabled=!0:(n.min_rssi_enabled=!1,delete n.min_rssi),o.push(n)),i.each(o,function(t){return d=t.radio,"custom"===t.tx_power_mode&&(r=e.model.get("radio_"+d).max_txpower||"0",c=e.model.get("radio_"+d).min_txpower||"0",t.tx_power>r||t.tx_power<c)?((new h).open(s.localize(s.E_IncorrectNumberRange,("ng"===d?s.G_2G:s.G_5G)+" "+s.G_PropertiesTransmitPower,c,r)),void(l=!1)):void 0}),l?(this.model.update({data:{radio_table:o},success:function(t){"ok"===t.meta.rc?(m=i.find(t.data,function(t){return t.mac===e.model.get("mac")}),void 0!==m&&e.updateRadioTable(m.radio_table),e.updateRadiosForm(),e.showSavedState()):e.showErrorState()},error:function(){e.showErrorState()}}),!1):!1},updateMinRSSIForm:function(){var e,t,a=this,n=this.app.collection("WlanGroups");i.each(this.model.get("radio_table"),function(i){var o=a.model.get("wlangroup_id_"+i.radio),r=n.findWhere({_id:o});t=i.radio,e=a.$("fieldset.radio-"+t),r&&r.get("roam_enabled")?(e.find('input[name="'+t+'.min_rssi_enabled"]').prop("disabled",!0),e.find('input[name="'+t+'.min_rssi"]').prop("disabled",!0)):(e.find('input[name="'+t+'.min_rssi_enabled"]').prop("disabled",!1),e.find('input[name="'+t+'.min_rssi_enabled"]').prop("checked")===!0?e.find('input[name="'+t+'.min_rssi"]').prop("disabled",!1):e.find('input[name="'+t+'.min_rssi"]').prop("disabled",!0))})},updateBandSteering:function(){var e=this.model.get("bandsteering_mode")||"off",t=this.model.isGen2Ap();if(t||(this.$bandSteering.find('input[value="equal"]').prop("disabled",!0),this.$bandSteering.find('input[value="equal"] + label').hide()),this.model.hasBandsteering()||this.$bandSteering.find("input").prop("disabled",!0),this.$bandSteering.find("input").prop("checked",!1),this.$bandSteering.find('input[value="'+e+'"]').prop("checked",!0),this.app.isReadOnly){var a=this;this.$bandSteering.find("input").each(function(){var t=r(this).val();t!==e&&a.$bandSteering.find('input[value="'+t+'"]').prop("disabled",!0)})}this.$bandSteering.buttonset("refresh")},saveBandSteering:function(){var e=this,t=this.$bandSteering.find("input:checked").val();return this.model.save({bandsteering_mode:t},{wait:!0,data:{bandsteering_mode:t},success:function(t,a){if("ok"===a.meta.rc){i.find(a.data,function(t){return t.mac===e.model.get("mac")});e.updateBandSteering(),e.showSavedState()}else e.showErrorState()},error:function(){e.showErrorState()}}),!1},saveAirtimeFairness:function(){},shell:function(){return window.open("/shell?mac="+this.model.get("mac")+"&name="+this.model.name(),"_blank","toolbar=no,menubar=0,status=0,copyhistory=0,scrollbars=yes,resizable=1,location=0,Width=800,Height=600"),!1},blockUser:function(e){var t=r(e.target),a=t.data("mac"),n=this.app.collection("Clients"),i=n.getClientFromMac(a);i.block()},reconnectUser:function(){var e=r(event.target),t=e.data("mac"),a=this.app.collection("Clients"),n=a.getClientFromMac(t);n.reconnect()},updateChannelSelect:function(e){var t,a=r(e.target),n=a.val()||20,o=a.data("radio"),c=this.$('select[name="'+o+'.channel"]'),d=c.val()||(this.model.get("radio_"+o)||{}).channel,l=this.model.hasDfs();if(c.empty().append(r('<option value="auto" />').text(s.G_Auto)),i.each(this.currentCCode["channels_"+o+(20==n?"":"_"+n)],r.proxy(function(e){var t=r("<option />").attr("value",e).text(e);if("na"==o){var a=-1!==r.inArray(e,this.currentCCode.channels_na_dfs);if(a){if(!l)return;t.text(function(e,t){return t+" (dfs)"})}t.attr("band",i.escape(52>e?1:149>e?2:3))}c.append(t)},this)),"na"==o&&("US"==this.currentCountryKey||"CA"==this.currentCountryKey))switch(this.model.get("model")){case"U5O":c.find("[band=1]").remove(),c.find("[band=2]").remove();break;case"U7P":c.find("[band=2]").remove()}t=c.find("option[value="+d+"]"),t.length||(t=c.find("option[value=auto]")),t.attr("selected",!0).trigger("change")},updateWlan:function(e,t){var a,n=r(e.target),i=n.data("radio"),o=n.val(),s=this.app.collection("WlanGroups"),c=s.findWhere({_id:o}),d=this.app.collection("Wlans");d.findWhere({wlangroup_id:o});if(n.data("wlangroup",c),a=this.$radiosForm.find(".radio-"+i),c&&c.get("roam_enabled")){a.find('select[name="'+i+'.channel"]').val("ng"==i?c.get("roam_channel_ng"):c.get("roam_channel_na")).disable(),a.find('select[name="'+i+'.ht"]').disable(),"resolved"===this._rendered.state()&&"resolved"==this._dependencies.state()&&a.find('select[name="'+i+'.ht"]').val("20").change();try{a.find('select[name="'+i+'.channel"]').selectmenu("disable"),a.find('select[name="'+i+'.ht"]').selectmenu("disable")}catch(l){}}else{a.find('select[name="'+i+'.channel"]').enable(),a.find('select[name="'+i+'.ht"]').enable();try{a.find('select[name="'+i+'.channel"]').selectmenu("enable"),a.find('select[name="'+i+'.ht"]').selectmenu("enable")}catch(l){}}this.updateMinRSSIForm(),t||this.model.get("_id")&&this.model.get("wlangroup_id_"+i)!=o&&this.model.updateWlanGroup(i,{wait:!0,wlangroup_id:o,success:r.proxy(function(){this.showSavedState(),this.setupWlanTable(i)},this),error:r.proxy(function(){this.showErrorState()},this)})},setupWlanPanel:function(){var e=this,t=["ng","na"],a=this.app.collection("WlanGroups");i.each(t,function(t,n){var o=e.$("select.wlan-group-"+t);o.empty(),i.each(a.models,function(a,n){var s=r('<option value="'+i.escape(a.get("_id"))+'"></option>');if(a.get("roam_enabled")){if(t!=a.get("roam_radio"))return null;s.addClass("roam"),s.text(a.get("name")+" (Zero-Handoff)")}else s.text(a.get("name"));s.hasClass("roam")&&(e.$el.hasClass("ap-uplink-wireless")||e.model.noZh())?s=null:o.append(s)});try{o.selectmenu("refresh")}catch(s){}var c=e.model.get("wlangroup_id_"+t);c&&(o.val(c).trigger("change",!0),e.setupWlanTable(t,c))})},fillWlanForm:function(e){if(this.$overrideForm.find(".error").removeClass("error"),this.$overrideForm.find(".row-error").remove(),this.wLanOverrideModel){var t=this.wLanOverrideModel.get("_id"),a=this.wLanOverrideRadio,n=this.model.getOverride(t,a),i=this.wLanOverrideModel.toJSON();(!n||e)&&(n=this.wLanOverrideModel.toJSON()),this.$overrideForm.find('input[name="name"]').val(n.hasOwnProperty("name")?n.name:i.name),this.$overrideForm.find('input[name="wlanEnabled"]').prop("checked",n.hasOwnProperty("enabled")?n.enabled===!0:i.enabled===!0),this.$overrideForm.find('input[name="vlanEnabled"]').prop("checked",n.hasOwnProperty("vlan_enabled")?n.vlan_enabled===!0:i.vlan_enabled===!0),this.$overrideForm.find('input[name="vlan"]').val(n.hasOwnProperty("vlan")?n.vlan>1?n.vlan:"":i.vlan>1?i.vlan:""),this.$overrideForm.find(".wpapsk").attr("display",n.hasOwnProperty("security")?"wpapsk"==n.security?"block":"none":"wpapsk"==i.security?"block":"none"),this.$overrideForm.find('input[name="passphrase"]').val(n.hasOwnProperty("x_passphrase")?n.x_passphrase:i.x_passphrase),"wpapsk"==this.wLanOverrideModel.get("security")?this.$overrideForm.find("div.row.wpapsk").show():this.$overrideForm.find("div.row.wpapsk").hide()}var o=this.$overrideForm.find('input[name="vlanEnabled"]'),r=this.$overrideForm.find('input[name="vlan"]');o.prop("checked")===!0?r.prop("disabled",!1):r.prop("disabled",!0),o.click(function(){o.is(":checked")?r.prop("disabled",!1):r.prop("disabled",!0)})},onOverrideFormSubmit:function(e){e&&e.preventDefault(),this.submitOverride(!1)},submitOverride:function(e){if(this.$overrideForm.find(".error").removeClass("error"),this.$overrideForm.find(".row-error").remove(),this.wLanOverrideModel){var t=this,a=this.model.get("wlan_overrides")||[],n=this.wLanOverrideModel.get("_id"),o=this.wLanOverrideRadio,s=this.model.getOverride(n,o)||this.wLanOverrideModel.toJSON(),c=!0;if(a=r.grep(a,function(e){return e!=s}),!e){var d=["enabled","name","radio","vlan","vlan_enabled","wlan_id","x_passphrase"];s=i.pick(s,d),s.wlan_id=n,s.radio=o,s.name=this.$overrideForm.find('input[name="name"]').val(),s.enabled=this.$overrideForm.find('input[name="wlanEnabled"]').is(":checked");var l=s.vlan_enabled=this.$overrideForm.find('input[name="vlanEnabled"]').is(":checked");s.vlan=this.$overrideForm.find('input[name="vlan"]').val(),s.x_passphrase=this.$overrideForm.find('input[name="passphrase"]').val();var m=this.wLanOverrideModel;s.name!=m.get("name")?c=!1:delete s.name,s.enabled!=m.get("enabled")?c=!1:delete s.enabled,s.vlan_enabled!=m.get("vlan_enabled")?c=!1:delete s.vlan_enabled,""===s.vlan?l?c=!1:delete s.vlan:s.vlan!=m.get("vlan")?c=!1:delete s.vlan,s.x_passphrase!=m.get("x_passphrase")?c=!1:delete s.x_passphrase,c||a.push(s)}var g=this.model.save({wlan_overrides:a,wlanconf:this.app.collection("Wlans").findWhere({_id:n})},{wait:!0,data:{wlan_overrides:a},success:function(e,a){"ok"===a.meta.rc?(t.setupWlanTable(o),t.$el.removeClass("ap-show-override"),t.showSavedState()):t.showErrorState()},error:function(){t.showErrorState()}});!g&&this.model.validationError&&this.model.validationError.wlan_overrides&&i.each(this.model.validationError.wlan_overrides,function(e,t){i.each(e,function(e,t){var a;switch(t){case"name":case"vlan":a=this.$overrideForm.find('input[name="'+t+'"]').addClass("error");break;case"x_passphrase":a=this.$overrideForm.find('input[name="passphrase"]').addClass("error")}a.parents(".row").after(r('<div class="row row-error"></div>').text(e))},this)},this)}},onOverrideFormRestore:function(e,t){return this.fillWlanForm(!0),!t&&this.submitOverride(!0),!1},onOverrideFormCancel:function(e){return this.onOverrideFormRestore(null,!0),this.$el.removeClass("ap-show-override"),!1},setupWlanTable:function(e,t){if(!this.rendered)return!1;var a=this,o=a.$("select.wlan-group-"+e),r=t||o.val(),c=this.app.collection("Wlans").filter(function(e){return e.get("wlangroup_id")==r}),d=this.$(".data-table-wlans-"+e);if(d.next(".WLANSDisabled").hide(),this.grids["wlan_"+e])this.grids["wlan_"+e].collection.reset(),this.grids["wlan_"+e].collection.set(c);else{var l=[{name:"name",label:s.G_Name,editable:!1,sortable:!1,headerCell:n.Headers.noSortHeader,cell:n.Cells.ComplexCell.extend({className:"string-cell",formatter:{fromRaw:function(e){var t=(e.get("enabled")||!1,e.get("name"));return t},toRaw:function(e){return e}}})},{name:"essid",label:s.G_Overrides,editable:!1,sortable:!1,headerCell:n.Headers.noSortHeader,cell:n.Cells.ComplexCell.extend({className:"string-cell",formatter:{fromRaw:function(t){var n=[],i=a.model.getOverride(t.get("_id"),e);if(!i)return"";if(i.hasOwnProperty("enabled")&&i.enabled!=t.get("enabled")){if(i.enabled===!0)return s.G_Enabled;if(i.enabled===!1)return s.G_Disabled}i.hasOwnProperty("name")&&i.name!=t.get("name")&&n.push("SSID:"+i.name),i.hasOwnProperty("vlan_enabled")&&(t.get("vlan_enabled")&&!i.vlan_enabled?n.push("VLAN:"+s.G_Disabled):!t.get("vlan_enabled")&&i.vlan_enabled&&n.push("VLAN:"+s.G_Enabled));var o=t.get("vlan_enabled")===!0&&i.vlan_enabled!==!1||t.get("vlan_enabled")===!1&&i.vlan_enabled===!0;return i.hasOwnProperty("vlan")&&o&&t.get("vlan")!=i.vlan&&n.push("VLAN:"+i.vlan),i.hasOwnProperty("x_passphrase")&&"wpapsk"==t.get("security")&&i.x_passphrase!=t.get("x_passphrase")&&n.push("PSK"),n.join(", ")},toRaw:function(e){return e}}})},{name:"_id",label:s.G_Actions,editable:!1,sortable:!1,headerCell:n.Headers.noSortHeader,cell:n.Cells.ActionsCell.extend({actions:{override:{render:function(e){var t=a.app.collection("WlanGroups"),n=t.findWhere({_id:e.get("wlangroup_id")});return n&&n.get("roam_enabled")?!1:!0},callback:function(t){a.wLanOverrideModel=t,a.wLanOverrideRadio=e,a.$el.addClass("ap-show-override"),a.fillWlanForm()}}}})}];this.grids["wlan_"+e]=this.grid(l,new m(c),d,this["noWlanRows_"+e])}i.size(c)?d.show():d.hide();try{o.selectmenu("refresh")}catch(g){}},setupUplinksTable:function(){if(!this.rendered)return!1;var e=this,t=this.app.routers.devices.views.index,a=this.model.uplinks(),d=this.$(".data-table-uplinks"),l=this.$(".data-table-uplinks-none");if(i.size(a)?(d.show(),l.hide()):(d.hide(),l.show()),this.grids.uplinks)this.grids.uplinks.collection.set(a);else{var m=[{name:"mac",label:s.G_AP,editable:!1,sortable:!1,headerCell:n.Headers.noSortHeader,cell:n.Cells.ComplexCell.extend({formatter:{fromRaw:function(e){var a=t.collection.getDeviceFromMac(e.get("mac"));return a||(a=e),a.name()},toRaw:function(e){return e}}}),callback:function(e){var a=t.collection.getDeviceFromMac(e.get("mac"));a&&t.property(a)},title:"mac"},{name:"channel",label:s.G_ChannelAbbrev,editable:!1,sortable:!1,headerCell:n.Headers.noSortHeader,cell:"string"},{name:"rssi",label:s.G_DevicesSignal,editable:!1,sortable:!1,headerCell:n.Headers.noSortHeader,cell:n.Cells.ModelCell.extend({callback:"calcRssi"})},{name:"configured",label:s.G_Actions,editable:!1,sortable:!1,headerCell:n.Headers.noSortHeader,cell:n.Cells.ActionsCell.extend({actions:{select:{buttonClasses:"narrow",render:function(e){return!e.get("configured")},callback:function(t,a){var n=r(a.currentTarget);n.prop("disabled",!0),e.model.setVwireUplink({data:{uplink:t.get("mac"),mac:e.model.get("mac")},success:function(){(new h).open(s.G_DevicesTopologyChanged)},complete:function(){n.prop("disabled",!1)}})}},remove:{buttonClasses:"narrow",render:function(e){return e.get("configured")},callback:function(t,a){var n=r(a.currentTarget);n.prop("disabled",!0),e.model.unsetVwireUplink({data:{uplink:t.get("mac"),mac:e.model.get("mac")},success:function(){(new h).open(s.G_DevicesTopologyChanged)},complete:function(){n.prop("disabled",!1)}})}}}})}];this.grids.uplinks=this.grid(m,new o.Collection(a,{model:c}),this.$(".data-table-uplinks"),this.noUplinkRows)}},setupDownlinksTable:function(){if(!this.rendered)return!1;var e=this,t=this.app.routers.devices.views.index;if(this.grids.downlinks)this.grids.downlinks.collection.set(this.model.downlinks());else{var a=[{name:"ap_mac",label:s.G_AP,editable:!1,sortable:!1,headerCell:n.Headers.noSortHeader,cell:n.Cells.ComplexCell.extend({formatter:{fromRaw:function(e){var a=t.collection.getDeviceFromMac(e.get("ap_mac"));return a||(a=e),a.name()},toRaw:function(e){return e}}}),callback:function(e){var a=e.get("ap_mac"),n=t.collection.getDeviceFromMac(a);t.property(n)},title:"ap_mac"},{name:"rssi",label:s.G_DevicesSignal,editable:!1,sortable:!1,headerCell:n.Headers.noSortHeader,cell:n.Cells.ModelCell.extend({callback:"calcRssi"})},{name:"_id",label:s.G_Actions,editable:!1,sortable:!1,headerCell:n.Headers.noSortHeader,
cell:n.Cells.ActionsCell.extend({actions:{remove:{buttonClasses:"narrow",callback:function(t,a){var n=r(a.currentTarget);n.prop("disabled",!0),e.model.unsetVwireUplink({data:{mac:t.get("ap_mac"),uplink:e.model.get("mac")},success:function(){(new h).open(s.G_DevicesTopologyChanged)},complete:function(){n.prop("disabled",!1)}})}}}})}];this.grids.downlinks=this.grid(a,new o.Collection(this.model.downlinks(),{model:c}),this.$(".data-table-downlinks"),this.noDownlinkRows)}},renderRfLegend:function(){var e=new a({el:this.$bindRfLegend});e.render()},populateRfEnvironment:function(e,a,n){var r=this,s=i.map(a,function(e){return i.extend({},e,{frequencies:[r.model.getFrequency(n,e.channel)]})}),c="ng"==n?this.model.get("ng-channel"):this.model.get("na-channel"),d=i.findWhere(this.model.get("radio_table"),{radio:n}),l=d?d.ht?d.ht:"ng"==n?"20":"40":null,m=new t({el:e,model:new o.Model({bandwidthGroups:s}),radioChannel:c,radioChannelWidth:l});m.render()},_onRfEnvironmentFrequencyChange:function(e){switch(r(e.target).val()){case"2G":this._showRfTab(this.$bindRfEnvironment2G,this.$bindRfEnvironmentLastUpdated2G);break;case"5G":this._showRfTab(this.$bindRfEnvironment5G,this.$bindRfEnvironmentLastUpdated5G)}},_hideAllRfTabs:function(){this.$bindRfEnvironment.hide(),this.$bindRfEnvironmentLastUpdated.hide()},_showRfTab:function(e,t){this._hideAllRfTabs(),e.show(),t.show()},remove:function(){this.onOverrideFormCancel(),this.stopListening(this.app.collection("Wlans"),"add remove destroy change",this.setupWlanPanel),this.stopListening(this.model,"change:radio_na change:radio_ng"),this.$advAdoptForm.off("submit"),this.$networkForm.off("submit"),this.$radiosForm.off("submit"),this.$shell.off("click"),this.$customUpgrade.off("click",this.customUpgrade),this.$(".button-block").off("click"),this.$(".button-reconnect").off("click"),this.$uplinkDevice.off("click"),this.$connectionType.off("change"),this.$overrideForm.off("submit"),this.$overrideForm.find('button[name="restore"]').off("click"),this.$overrideForm.find('button[name="cancel"]').off("click"),this.$("select.wlan-group-ng").off("change"),this.$("select.wlan-group-na").off("change"),this.$('input[name="ng.min_rssi_enabled"]').off("change"),this.$('input[name="na.min_rssi_enabled"]').off("change"),this.$("select.radio-ht").off("change"),this.unstickit(this.model),this.rendered=!1,e.prototype.remove.apply(this,arguments)}})}),define("text!includes/gateway/gatewayPortForwardFormTemplate.html",[],function(){return'<form>\n    <fieldset class="fieldset">\n        <div class="row">\n            <label class="label inline"><%- msg.G_Name %></label>\n            <input type="text" class="input inline" name="name" value="" />\n        </div>\n        <div class="row source">\n            <label class="label inline"><%- msg.G_PortForwardSource %></label>\n            \n            <div class="radio-group left">\n                <label><input type="radio" name="src_type" value="any" /> <%- msg.G_PropertiesPortFwdSrcAnywhere %></label>\n                <label><input type="radio" name="src_type" value="limited" /> <%- msg.G_PropertiesPortFwdSrcLimited %></label>\n            </div>\n            \n            <input type="text" class="input inline" name="src" value="" />\n        </div>\n        <div class="row">\n            <label class="label inline"><%- msg.G_Port %></label>\n            <input type="text" class="input inline" name="dst_port" value="" />\n            <label class="tip inline">(1000,1002-1004,...)\n        </div>\n        <div class="row">\n            <label class="label inline"><%- msg.G_PortForwardDestIp %></label>\n            <input type="text" class="input inline" name="fwd" value="" />\n        </div>\n        <div class="row">\n            <label class="label inline"><%- msg.G_PortForwardDestPort %></label>\n            <input type="text" class="input inline" name="fwd_port" value="" />\n        </div>\n    </fieldset>\n    \n    <fieldset class="fieldset">\n        <legend class="legend"><%- msg.G_SettingsAdvancedOpts %></legend>\n        \n        <div class="row">\n            <label class="label inline"><%- msg.G_PropertiesProtocol %></label>\n            \n            <div class="radio-group">\n                <label><input type="radio" name="proto" value="tcp_udp" /> <%- msg.G_Both %></label>\n                <label><input type="radio" name="proto" value="tcp" /> <%- msg.G_PropertiesTcp %></label>\n                <label><input type="radio" name="proto" value="udp" /> <%- msg.G_PropertiesUdp %></label>\n            </div>\n        </div>\n    </fieldset>\n    \n    <button class="button is-admin" type="submit"><%- msg.G_Apply %></button>\n    <button class="button" name="cancel" value="Cancel" type="button"><%- msg.G_Cancel %></button>\n</form>'}),define("unifi/view/gateway/PortForwardFormView",["unifi/view/app/FormView","jquery","underscore","msg/Msg","text!includes/gateway/gatewayPortForwardFormTemplate.html"],function(e,t,a,n,i){"use strict";return e.extend({_templateId:a.template(i,{msg:n}),_prevalidate:{name:{input:"text"},src:{input:"text"},dst_port:{input:"text"},fwd:{input:"text"},fwd_port:{input:"text"}},events:{"click button[name=cancel]":"remove"},render:function(){var t=this,a=this.rendered;e.prototype.render.call(this);var n=this.$container.parents(".portfwd-config");if(n.addClass("show-form"),!a){this.on("remove",function(){n.removeClass("show-form")}),this.$fwdPort=this.$("input[name=fwd_port]"),this.$dstPort=this.$("input[name=dst_port]"),this.$src_type=this.$("input[name=src_type]"),this.$src_type_limited=this.$("input[name=src_type][value=limited]"),this.$src=this.$("input[name=src]"),this.$dstPort.on("change",function(e){var a=t.$dstPort.val().indexOf("-")>=0||t.$dstPort.val().indexOf(",")>=0;t.$fwdPort.val(t.$dstPort.val()),t.$fwdPort.enable(),a&&a&&t.$fwdPort.disable()}),this.$fwdPort.on("change",function(e){var a=t.$fwdPort.val().indexOf("-")>=0||t.$fwdPort.val().indexOf(",")>=0;t.$fwdPort.enable(),a&&(t.$dstPort.val(t.$fwdPort.val()),a&&t.$fwdPort.disable())});var i=this.$dstPort.val().indexOf("-")>=0||this.$dstPort.val().indexOf(",")>=0;this.$fwdPort.val(this.$dstPort.val()),this.$fwdPort.enable(),i&&i&&this.$fwdPort.disable(),this.$src_type.on("change",function(e){t.$src_type_limited.is(":checked")?t.$src.enable():(t.$src.disable(),t.$src.val(""),t.valid(["src"]))}),this.$src_type_limited.is(":checked")?this.$src.enable():this.$src.disable(),this.app.isReadOnly||this.prevalidator()}},populate:function(){var e=this.model.get("src"),t=!e||"any"==e;this.model&&(this.$el.find("input[name=name]").val(this.model.get("name")),this.$el.find("input[name=src_type][value="+(t?"any":"limited")+"]").prop("checked",!0),this.$el.find("input[name=src]").val(t?"":e),this.$el.find("input[name=dst_port]").val(this.model.get("dst_port")),this.$el.find("input[name=fwd]").val(this.model.get("fwd")),this.$el.find("input[name=fwd_port]").val(this.model.get("fwd_port")),this.$el.find("input[name=proto][value="+(this.model.get("proto")||"tcp_udp")+"]").prop("checked",!0))},gather:function(){var e=this.$el.find("input[name=src]").val(),t="any"==this.$el.find("input[name=src_type]:checked").val();return{name:this.$el.find("input[name=name]").val(),src:t?"any":e,dst_port:this.$el.find("input[name=dst_port]").val(),fwd:this.$el.find("input[name=fwd]").val(),fwd_port:this.$el.find("input[name=fwd_port]").val(),proto:this.$el.find("input[name=proto]:checked").val()}},success:function(){this.remove()},error:function(e,t){this.options.app.views.app.flash("error","Error",n.apiError(t))},remove:function(){this.$("input[name=dst_port]").off(),e.prototype.remove.apply(this,arguments)}})}),define("text!includes/gateway/gatewayDynamicDNSFormTemplate.html",[],function(){return'<form>\n    <fieldset class="fieldset">\n        <div class="row">\n            <label class="label inline"><%- msg.G_PropertiesDDNSService %></label>\n            <select name="service" class="input inline">\n                <option value="afraid" selected="selected"><%- msg.G_PropertiesDDNSServiceAfraid %></option>\n                <option value="dnspark"><%- msg.G_PropertiesDDNSServiceDnspark %></option>\n                <option value="dslreports"><%- msg.G_PropertiesDDNSServiceDslreports %></option>\n                <option value="dyndns"><%- msg.G_PropertiesDDNSServiceDyndns %></option>\n                <option value="easydns"><%- msg.G_PropertiesDDNSServiceEasydns %></option>\n                <option value="namecheap"><%- msg.G_PropertiesDDNSServiceNamecheap %></option>\n                <option value="sitelutions"><%- msg.G_PropertiesDDNSServiceSitelutions %></option>\n                <option value="zoneedit"><%- msg.G_PropertiesDDNSServiceZoneedit %></option>\n            </select>\n        </div>\n        <div class="row">\n            <label class="label inline"><%- msg.G_PropertiesDDNSHostname %></label>\n            <input type="text" class="input inline" name="host_name" value="" />\n        </div>\n        <div class="row">\n            <label class="label inline"><%- msg.G_PropertiesDDNSUsername %></label>\n            <input type="text" class="input inline" name="login" value="" />\n        </div>\n        <div class="row">\n            <label class="label inline"><%- msg.G_PropertiesDDNSPassword %></label>\n            <input type="password" class="input inline" name="x_password" value="" />\n        </div>\n        <div class="row">\n            <label class="label inline"><%- msg.G_PropertiesDDNSServer %></label>\n            <input type="text" class="input inline" name="server" value="" />\n        </div>\n    </fieldset>\n\n    <button class="button is-admin" type="submit"><%- msg.G_Apply %></button>\n    <button class="button" name="cancel" value="Cancel" type="button"><%- msg.G_Cancel %></button>\n</form>\n'}),define("unifi/view/gateway/DynamicDNSFormView",["unifi/view/app/FormView","jquery","underscore","msg/Msg","text!includes/gateway/gatewayDynamicDNSFormTemplate.html"],function(e,t,a,n,i){"use strict";return e.extend({_templateId:a.template(i,{msg:n}),_prevalidate:{login:{input:"text"},x_password:{input:"password"},host_name:{input:"text"},server:{input:"text"}},events:{"click button[name=cancel]":"remove"},render:function(){var t=this.rendered;e.prototype.render.call(this);var a=this.$container.parents(".dynamicdns-config");a.addClass("show-form"),this.$el.find("input[name=x_password-text]").addClass("input inline"),t||(this.on("remove",function(){a.removeClass("show-form")}),this.app.isReadOnly||this.prevalidator())},populate:function(){this.model&&(this.$el.find("select[name=service]").val(this.model.get("service")||"afraid").trigger("change"),this.$el.find("input[name=host_name]").val(this.model.get("host_name")),this.$el.find("input[name=login]").val(this.model.get("login")),this.$el.find("input[name=x_password]").val(this.model.get("x_password")),this.$el.find("input[name=server]").val(this.model.get("server")))},gather:function(){var e={service:this.$el.find("select[name=service] option:selected").val(),host_name:this.$el.find("input[name=host_name]").val(),login:this.$el.find("input[name=login]").val(),x_password:this.$el.find("input[name=x_password]").val(),server:this.$el.find("input[name=server]").val()};return e},success:function(){this.remove()},error:function(e,t){this.options.app.views.app.flash("error","Error",n.apiError(t))},remove:function(){e.prototype.remove.apply(this,arguments)}})}),define("text!includes/gateway/DpiPropertyTemplate.html",[],function(){return'<div class="category header">\n    <span><%- msg.G_PropertiesTotalUsage %></span>\n     - \n    <span class="totalBytes"></span> \n    (\n        <span class="ubnt-icon-arrow-down"></span> \n        <span class="rxBytes"></span>  \n        <span class="ubnt-icon-arrow-up"></span> \n        <span class="txBytes"></span>\n    )\n</div>\n<div class="category graph">\n    <div class="chart"></div>\n    <div class="chartDetail">\n        <span class="name"></span> - \n        <span class="totalBytes"></span> \n        (\n            <span class="ubnt-icon-arrow-down"></span> \n            <span class="rxBytes"></span>  \n            <span class="ubnt-icon-arrow-up"></span> \n            <span class="txBytes"></span>\n        )\n    </div>\n</div>\n<div class="category detail"></div>\n\n<div class="application header">\n    <div class="back"><%- msg.G_PropertiesTotalUsage %> ></div>\n    <div class="title">"<span class="name"></span>" <%- msg.G_PropertiesUsageByClient %></div>\n</div>\n<div class="application chart data-table">\n</div>\n'}),define("unifi/util/DpiRuleMap",[],function(){"use strict";return{applications:{1:{category_id:0,name:"MSN"},10:{category_id:0,name:"Gadu-Gadu"},100:{category_id:0,name:"Verychat(M)"},101:{category_id:0,name:"Voxer(M)"},102:{category_id:0,name:"TextMe(M)"},103:{category_id:0,name:"Bump(M)"},104:{category_id:0,name:"CoolMessenger"},105:{category_id:0,name:"NateOn"},106:{category_id:0,name:"WeChat(M)"},107:{category_id:0,name:"Snapchat(M)"},108:{category_id:0,name:"Wangxin"},11:{category_id:0,name:"Yixin"},1114113:{category_id:17,name:"WatchGuard WSM Management"},1114114:{category_id:17,name:"WatchGuard Web Management UI"},1114115:{category_id:17,name:"WatchGuard Authentication Access"},1114117:{category_id:17,name:"WatchGuard external Webblocker database fetch"},1114118:{category_id:17,name:"Livelink"},1114119:{category_id:17,name:"Altiris"},1114120:{category_id:17,name:"AMS"},1114121:{category_id:17,name:"Apache Synapse"},1114122:{category_id:17,name:"WatchGuard CLI "},1114124:{category_id:17,name:"Webex"},1114125:{category_id:17,name:"Webex-WebOffice"},1114128:{category_id:17,name:"Avamar"},1114129:{category_id:17,name:"Avaya"},1114130:{category_id:17,name:"BackupExec"},1114131:{category_id:17,name:"Bitcoin Core"},1114133:{category_id:17,name:"Microsoft OS license"},1114134:{category_id:17,name:"Microsoft Office 2013 license"},1114138:{category_id:17,name:"BZFlag"},1114140:{category_id:17,name:"CAJO"},1114141:{category_id:17,name:"Cisco HSRP"},1114142:{category_id:17,name:"SkyDesk"},1114150:{category_id:17,name:"openQRM"},1114151:{category_id:17,name:"Citrix"},1114152:{category_id:17,name:"CodeMeter"},1114155:{category_id:17,name:"Corba"},1114158:{category_id:17,name:"Cups"},1114160:{category_id:17,name:"Cvsup"},1114161:{category_id:17,name:"DameWare"},1114167:{category_id:17,name:"Db2"},1114169:{category_id:17,name:"Dclink"},1114170:{category_id:17,name:"Urchin Web Analytics"},1114176:{category_id:17,name:"EForward-document transport system"},1114177:{category_id:17,name:"EMWIN"},1114180:{category_id:17,name:"ESRI"},1114182:{category_id:17,name:"Big Brother"},1114187:{category_id:17,name:"Freeciv"},1114188:{category_id:17,name:"Microsoft Lync"},1114191:{category_id:17,name:"Websense"},1114195:{category_id:17,name:"Whisker"},1114198:{category_id:17,name:"Hewlett-Packard"},1114201:{category_id:17,name:"HP-JetDirect"},1114203:{category_id:17,name:"VMWare"},1114205:{category_id:17,name:"IBM HTTP"},1114206:{category_id:17,name:"IBM SmartCloud"},1114212:{category_id:17,name:"IMS"},1114213:{category_id:17,name:"Infomix"},1114222:{category_id:17,name:"Limelight"},1114229:{category_id:17,name:"Lawson-m3"},1114238:{category_id:17,name:"Meeting-maker"},1114239:{category_id:17,name:"Zendesk"},1114246:{category_id:17,name:"Microsoft DTC"},1114248:{category_id:17,name:"Microsoft Netlogon"},1114250:{category_id:17,name:"Microsoft Remote Web Workplace"},1114252:{category_id:17,name:"Sharepoint-wiki"},1114253:{category_id:17,name:"Microsoft SSDP"},1114255:{category_id:17,name:"GatherPlace"},1114269:{category_id:17,name:"Xgrid"},1114272:{category_id:17,name:"Backweb"},1114273:{category_id:17,name:"Bugzilla"},1114274:{category_id:17,name:"NCube"},1114275:{category_id:17,name:"WinboxRouterOS"},1114277:{category_id:17,name:"WSO2"},1114279:{category_id:17,name:"NetFlow"},1114289:{category_id:17,name:"concur"},1114290:{category_id:17,name:"NetSupport"},1114308:{category_id:17,name:"DirectAdmin"},1114309:{category_id:17,name:"EasyBits"},1114310:{category_id:17,name:"Eiq-sec-analyzer"},1114311:{category_id:17,name:"Netbotz"},1114318:{category_id:17,name:"Perforce"},1114320:{category_id:17,name:"TiVoConnect"},1114321:{category_id:17,name:"Polycom"},1114322:{category_id:17,name:"WebSphere"},1114330:{category_id:17,name:"Radacct RADIUS"},1114331:{category_id:17,name:"Psiphon"},1114334:{category_id:17,name:"Securemeeting"},1114335:{category_id:17,name:"SW Soft Plesk"},1114337:{category_id:17,name:"SANE"},1114339:{category_id:17,name:"WebHost"},1114340:{category_id:17,name:"CPanel"},1114342:{category_id:17,name:"Sibelius"},1114343:{category_id:17,name:"Siebel-crm"},1114347:{category_id:17,name:"SMS"},1114350:{category_id:17,name:"Spirent"},1114351:{category_id:17,name:"SPSS"},1114352:{category_id:17,name:"Subversion"},1114355:{category_id:17,name:"Tripwire"},1114359:{category_id:17,name:"WatchGuard Webblocker database transfer"},1114361:{category_id:17,name:"WatchGuard Security Event Processor logging"},1114363:{category_id:17,name:"Genesys Meeting Center"},1114365:{category_id:17,name:"Nagios"},1179649:{category_id:18,name:"TCP Port Service Multiplexer"},1179650:{category_id:18,name:"Management Utility"},1179651:{category_id:18,name:"Compression Process"},1179653:{category_id:18,name:"Echo"},1179654:{category_id:18,name:"Discard"},1179655:{category_id:18,name:"Active"},1179660:{category_id:18,name:"Character Generator"},1179665:{category_id:18,name:"any private mail system"},1179667:{category_id:18,name:"AltaVista Firewall97"},1179668:{category_id:18,name:"NSW User System FE"},1179669:{category_id:18,name:"MSG ICP"},1179670:{category_id:18,name:"MSG Authentication"},1179671:{category_id:18,name:"Display Support Protocol"},1179672:{category_id:18,name:"any private printer server"},1179673:{category_id:18,name:"Time"},1179674:{category_id:18,name:"Route Access Protocol"},1179675:{category_id:18,name:"Resource Location Protocol"},1179676:{category_id:18,name:"graphics"},1179677:{category_id:18,name:"Host Name Server"},1179678:{category_id:18,name:"NIC Name"},1179679:{category_id:18,name:"MPM FLAGS Protocol"},1179680:{category_id:18,name:"Message Processing Module [recv]"},1179681:{category_id:18,name:"MPM [default send]"},1179682:{category_id:18,name:"NI FTP"},1179683:{category_id:18,name:"Digital Audit Daemon"},1179684:{category_id:18,name:"Login Host Protocol (TACACS)"},1179685:{category_id:18,name:"Remote Mail Checking Protocol"},1179686:{category_id:18,name:"IMP Logical Address Maintenance"},1179687:{category_id:18,name:"XNS Time Protocol"},1179688:{category_id:18,name:"Domain Name Server"},1179689:{category_id:18,name:"XNS Clearinghouse"},1179690:{category_id:18,name:"ISI Graphics Language"},1179691:{category_id:18,name:"XNS Authentication"},1179692:{category_id:18,name:"Mail Transfer Protocol (MTP)"},1179693:{category_id:18,name:"XNS Mail"},1179694:{category_id:18,name:"any private file service"},1179695:{category_id:18,name:"NI MAIL"},1179696:{category_id:18,name:"ACA Services"},1179697:{category_id:18,name:"VIA Systems - FTP whois++"},1179698:{category_id:18,name:"Communications Integrator (CI)"},1179699:{category_id:18,name:"TACACS-Database Service"},1179700:{category_id:18,name:"Oracle SQL-NET"},1179701:{category_id:18,name:"Bootstrap Protocol Server"},1179702:{category_id:18,name:"Bootstrap Protocol Client"},1179704:{category_id:18,name:"Gopher"},1179705:{category_id:18,name:"Remote Job Service"},1179706:{category_id:18,name:"any private dial out service"},1179707:{category_id:18,name:"Distributed External Object Store"},1179708:{category_id:18,name:"any private RJE service netrjs"},1179709:{category_id:18,name:"Vet TCP"},1179710:{category_id:18,name:"Finger"},1179711:{category_id:18,name:"World Wide Web HTTP"},1179712:{category_id:18,name:"Torpark"},1179713:{category_id:18,name:"XFER Utility"},1179714:{category_id:18,name:"MIT ML Device"},1179715:{category_id:18,name:"Common Trace Facility"},1179716:{category_id:18,name:"Micro Focus Cobol"},1179717:{category_id:18,name:"any private terminal link ttylink"},1179718:{category_id:18,name:"Kerberos"},1179719:{category_id:18,name:"SU MIT Telnet Gateway"},1179720:{category_id:18,name:"DNSIX Securit Attribute Token Map"},1179721:{category_id:18,name:"MIT Dover Spooler"},1179722:{category_id:18,name:"Network Printing Protocol"},1179723:{category_id:18,name:"Device Control Protocol"},1179724:{category_id:18,name:"Tivoli Object Dispatcher"},1179725:{category_id:18,name:"BSD supdupd(8)"},1179726:{category_id:18,name:"DIXIE Protocol Specification"},1179727:{category_id:18,name:"Swift Remote Virtural File Protocol"},1179728:{category_id:18,name:"linuxconf"},1179729:{category_id:18,name:"Metagram Relay"},1179731:{category_id:18,name:"NIC Host Name Server"},1179732:{category_id:18,name:"ISO-TSAP Class 0"},1179733:{category_id:18,name:"Genesis Point-to-Point Trans Net"},1179734:{category_id:18,name:"ACR-NEMA Digital Imag. &amp; Comm. 300"},1179735:{category_id:18,name:"Mailbox Name Nameserver"},1179737:{category_id:18,name:"Eudora compatible PW changer"},1179739:{category_id:18,name:"SNA Gateway Access Server"},1179740:{category_id:18,name:"PostOffice V.2"},1179742:{category_id:18,name:"Portmapper RPC Bind"},1179743:{category_id:18,name:"McIDAS Data Transmission Protocol"},1179744:{category_id:18,name:"Ident Tap Authentication Service"},1179745:{category_id:18,name:"Audio News Multicast"},1179746:{category_id:18,name:"Simple File Transfer Protocol"},1179747:{category_id:18,name:"ANSA REX Notify"},1179748:{category_id:18,name:"UUCP Path Service"},1179749:{category_id:18,name:"SQL Services"},1179752:{category_id:18,name:"Encore Expedited Remote Pro.Call"},1179753:{category_id:18,name:"Smakynet"},1179754:{category_id:18,name:"NTP"},1179755:{category_id:18,name:"ANSA REX Trader"},1179756:{category_id:18,name:"Locus PC-Interface Net Map Ser"},1179757:{category_id:18,name:"Unisys Unitary Login"},1179758:{category_id:18,name:"Locus PC-Interface Conn Server"},1179759:{category_id:18,name:"GSS X License Verification"},1179760:{category_id:18,name:"Password Generator Protocol"},1179761:{category_id:18,name:"Cisco FNATIVE"},1179762:{category_id:18,name:"Cisco TNATIVE"},1179763:{category_id:18,name:"Cisco SYSMAINT"},1179764:{category_id:18,name:"Statistics Service"},1179765:{category_id:18,name:"INGRES-NET Service"},1179766:{category_id:18,name:"NCS local location broker"},1179767:{category_id:18,name:"PROFILE Naming System"},1179768:{category_id:18,name:"NetBIOS Name Service"},1179769:{category_id:18,name:"NetBIOS Datagram Service"},1179770:{category_id:18,name:"NetBIOS Session Service"},1179771:{category_id:18,name:"EMFIS Data Service"},1179772:{category_id:18,name:"EMFIS Control Service"},1179773:{category_id:18,name:"Britton-Lee IDM"},1179774:{category_id:18,name:"Internet Message Access Protocol"},1179775:{category_id:18,name:"Universal Management Architecture"},1179776:{category_id:18,name:"UAAC Protocol"},1179777:{category_id:18,name:"iso-ip0"},1179778:{category_id:18,name:"iso-ip"},1179779:{category_id:18,name:"Jargon"},1179780:{category_id:18,name:"AED 512 Emulation Service"},1179781:{category_id:18,name:"SQL-net"},1179782:{category_id:18,name:"HEMS"},1179783:{category_id:18,name:"Background File Transfer Program (BFTP)"},1179784:{category_id:18,name:"SGMP"},1179785:{category_id:18,name:"NetSC-prod"},1179786:{category_id:18,name:"NetSC-dev"},1179787:{category_id:18,name:"SQL Service"},1179788:{category_id:18,name:"KNET VM Command Message Protocol"},1179789:{category_id:18,name:"PCMail Server"},1179790:{category_id:18,name:"NSS-Routing"},1179791:{category_id:18,name:"SGMP-traps"},1179793:{category_id:18,name:"SNMPTRAP"},1179794:{category_id:18,name:"CMIP TCP Manager"},1179795:{category_id:18,name:"CMIP TCP Agent"},1179796:{category_id:18,name:"Xerox"},1179797:{category_id:18,name:"Sirius Systems"},1179798:{category_id:18,name:"namp"},1179799:{category_id:18,name:"rsvd"},1179800:{category_id:18,name:"send"},1179801:{category_id:18,name:"Network PostScript"},1179802:{category_id:18,name:"Network Innovations Multiplex"},1179803:{category_id:18,name:"Network Innovations CL 1"},1179804:{category_id:18,name:"xyplex-mux"},1179805:{category_id:18,name:"mailq"},1179806:{category_id:18,name:"vmnet"},1179807:{category_id:18,name:"genrad-mux"},1179808:{category_id:18,name:"X Display Manager Control Protocol"},1179809:{category_id:18,name:"NextStep Window Server"},1179810:{category_id:18,name:"Border Gateway Protocol"},1179811:{category_id:18,name:"Intergraph"},1179812:{category_id:18,name:"unify"},1179813:{category_id:18,name:"Unisys Audit SITP"},1179814:{category_id:18,name:"ocbinder"},1179815:{category_id:18,name:"ocserver"},1179816:{category_id:18,name:"remote-kis"},1179817:{category_id:18,name:"KIS Protocol"},1179818:{category_id:18,name:"Application Communication Interface"},1179819:{category_id:18,name:"Plus Fives MUMPS"},1179820:{category_id:18,name:"Queued File Transport"},1179821:{category_id:18,name:"Gateway Access Control Protocol"},1179822:{category_id:18,name:"Prospero Directory Service"},1179823:{category_id:18,name:"OSU Network Monitoring System"},1179824:{category_id:18,name:"Spider Remote Monitoring Protocol"},1179825:{category_id:18,name:"Internet Relay Chat"},1179826:{category_id:18,name:"DNSIX Network Level Module Audit"},1179827:{category_id:18,name:"DNSIX Session Mgt Module Audit Redir"},1179828:{category_id:18,name:"Directory Location Service"},1179829:{category_id:18,name:"Directory Location Service Monitor"},1179830:{category_id:18,name:"SMUX"},1179831:{category_id:18,name:"IBM System Resource Controller"},1179832:{category_id:18,name:"AppleTalk Routing Maintenance"},1179833:{category_id:18,name:"AppleTalk Name Binding"},1179834:{category_id:18,name:"AppleTalk Unused"},1179835:{category_id:18,name:"AppleTalk Echo"},1179836:{category_id:18,name:"AppleTalk Zone Information"},1179838:{category_id:18,name:"Trivial Authenticated Mail Protocol"},1179839:{category_id:18,name:"ANSI Z39.50"},1179840:{category_id:18,name:"Texas Instruments"},1179841:{category_id:18,name:"ATEXSSTR"},1179842:{category_id:18,name:"IPX"},1179843:{category_id:18,name:"vmpwscs"},1179844:{category_id:18,name:"Insignia Solutions"},1179845:{category_id:18,name:"Computer Associates Intl License Server"},1179846:{category_id:18,name:"dBASE Unix"},1179847:{category_id:18,name:"Netix Message Posting Protocol"},1179848:{category_id:18,name:"Unisys ARPs"},1179849:{category_id:18,name:"Interactive Mail Access Protocol v3"},1179850:{category_id:18,name:"Berkeley rlogind with SPX auth"},1179851:{category_id:18,name:"Berkeley rshd with SPX auth"},1179852:{category_id:18,name:"Certificate Distribution Center"},1179853:{category_id:18,name:"masqdialer"},1179854:{category_id:18,name:"direct"},1179855:{category_id:18,name:"Survey Measurement"},1179856:{category_id:18,name:"inbusiness"},1179857:{category_id:18,name:"link"},1179858:{category_id:18,name:"Display Systems Protocol"},1179860:{category_id:18,name:"bhfhs"},1179862:{category_id:18,name:"RAP (Route Access Protocol)"},1179863:{category_id:18,name:"Checkpoint Firewall-1"},1179864:{category_id:18,name:"Efficient Short Remote Operations"},1179865:{category_id:18,name:"openport"},1179866:{category_id:18,name:"Checkpoint Firewall-1 Management"},1179867:{category_id:18,name:"arcisdms"},1179868:{category_id:18,name:"hdap"},1179869:{category_id:18,name:"Border Gateway Multicast Protocol (BGMP)"},1179870:{category_id:18,name:"X-Bone CTL"},1179871:{category_id:18,name:"SCSI on ST"},1179872:{category_id:18,name:"Tobit David Service Layer"},1179873:{category_id:18,name:"Tobit David Replica"},1179874:{category_id:18,name:"http-mgmt"},1179875:{category_id:18,name:"personal-link"},1179876:{category_id:18,name:"Cable Port A X"},1179877:{category_id:18,name:"rescap"},1179878:{category_id:18,name:"corerjd"},1179879:{category_id:18,name:"FXP-1"},1179880:{category_id:18,name:"K-BLOCK"},1179881:{category_id:18,name:"Novastor Backup"},1179882:{category_id:18,name:"entrusttime"},1179883:{category_id:18,name:"bhmds"},1179884:{category_id:18,name:"AppleShare IP WebAdmin"},1179885:{category_id:18,name:"VSLMP"},1179886:{category_id:18,name:"magenta-logic"},1179887:{category_id:18,name:"opalis-robot"},1179888:{category_id:18,name:"DPSI"},1179889:{category_id:18,name:"decAuth"},1179890:{category_id:18,name:"zannet"},1179891:{category_id:18,name:"PKIX TimeStamp"},1179892:{category_id:18,name:"PTP Event"},1179893:{category_id:18,name:"PTP General"},1179894:{category_id:18,name:"Programmable Interconnect Point (PIP)"},1179895:{category_id:18,name:"RTSPS"},1179896:{category_id:18,name:"Texar Security Port"},1179897:{category_id:18,name:"Prospero Data Access Protocol"},1179898:{category_id:18,name:"Perf Analysis Workbench"},1179899:{category_id:18,name:"Zebra server"},1179900:{category_id:18,name:"Fatmen Server"},1179901:{category_id:18,name:"Cabletron Management Protocol"},1179902:{category_id:18,name:"mftp"},1179903:{category_id:18,name:"MATIP Type A"},12:{category_id:0,name:"POPO"},1245187:{category_id:19,name:"DTAG or bhoedap4"},1245188:{category_id:19,name:"ndsauth"},1245189:{category_id:19,name:"bh611"},1245190:{category_id:19,name:"datex-asn"},1245191:{category_id:19,name:"Cloanto Net 1"},1245192:{category_id:19,name:"bhevent"},1245193:{category_id:19,name:"shrinkwrap"},1245195:{category_id:19,name:"Tenebris Network Trace Service"},1245196:{category_id:19,name:"scoi2odialog"},1245197:{category_id:19,name:"semantix"},1245198:{category_id:19,name:"SRS Send"},1245200:{category_id:19,name:"aurora-cmgr"},1245201:{category_id:19,name:"DTK"},1245202:{category_id:19,name:"odmr"},1245203:{category_id:19,name:"mortgageware"},1245204:{category_id:19,name:"qbikgdp"},1245205:{category_id:19,name:"rpc2portmap"},1245206:{category_id:19,name:"Coda authentication server (codaauth2)"},1245207:{category_id:19,name:"ClearCase"},1245208:{category_id:19,name:"ListProcessor"},1245209:{category_id:19,name:"Legent Corporation"},1245210:{category_id:19,name:"hassle"},1245211:{category_id:19,name:"Amiga Envoy Network Inquiry Proto"},1245212:{category_id:19,name:"NEC Corporation"},1245213:{category_id:19,name:"TIA EIA IS-99 modem client"},1245214:{category_id:19,name:"TIA EIA IS-99 modem server"},1245215:{category_id:19,name:"HP Performance data collector"},1245216:{category_id:19,name:"HP Performance data managed node"},1245217:{category_id:19,name:"HP Performance data alarm manager"},1245218:{category_id:19,name:"A Remote Network Server System"},1245219:{category_id:19,name:"IBM Application"},1245220:{category_id:19,name:"ASA Message Router Object Def."},1245221:{category_id:19,name:"Appletalk Update-Based Routing Pro."},1245222:{category_id:19,name:"Unidata LDM"},1245223:{category_id:19,name:"Lightweight Directory Access Protocol"},1245224:{category_id:19,name:"uis"},1245225:{category_id:19,name:"SynOptics SNMP Relay Port"},1245226:{category_id:19,name:"SynOptics Port Broker Port"},1245228:{category_id:19,name:"Meta5"},1245229:{category_id:19,name:"EMBL Nucleic Data Transfer"},1245230:{category_id:19,name:"NETscout Control Protocol"},1245231:{category_id:19,name:"Novell Netware over IP"},1245232:{category_id:19,name:"Multi Protocol Trans. Net."},1245233:{category_id:19,name:"kryptolan"},1245234:{category_id:19,name:"ISO Transport Class 2 Non-Control over TCP"},1245235:{category_id:19,name:"Workstation Solutions"},1245236:{category_id:19,name:"Uninterruptible Power Supply"},1245237:{category_id:19,name:"Genie Protocol"},1245238:{category_id:19,name:"decap"},1245239:{category_id:19,name:"nced"},1245240:{category_id:19,name:"ncld"},1245241:{category_id:19,name:"Interactive Mail Support Protocol"},1245242:{category_id:19,name:"timbuktu"},1245243:{category_id:19,name:"Prospero Resource Manager Sys. Man."},1245244:{category_id:19,name:"Prospero Resource Manager Node Man."},1245245:{category_id:19,name:"DECLadebug Remote Debug Protocol"},1245246:{category_id:19,name:"Remote MT Protocol"
},1245247:{category_id:19,name:"Trap Convention Port"},1245248:{category_id:19,name:"smsp"},1245249:{category_id:19,name:"infoseek"},1245250:{category_id:19,name:"bnet"},1245251:{category_id:19,name:"silverplatter"},1245252:{category_id:19,name:"onmux"},1245253:{category_id:19,name:"hyper-g"},1245254:{category_id:19,name:"ariel1"},1245255:{category_id:19,name:"smpte"},1245256:{category_id:19,name:"ariel2"},1245257:{category_id:19,name:"ariel3"},1245258:{category_id:19,name:"IBM Operations Planning and Control Start"},1245259:{category_id:19,name:"IBM Operations Planning and Control Track"},1245260:{category_id:19,name:"icad-el"},1245261:{category_id:19,name:"smartsdp"},1245262:{category_id:19,name:"Server Location"},1245263:{category_id:19,name:"ocs_cmu"},1245264:{category_id:19,name:"ocs_amu"},1245265:{category_id:19,name:"utmpsd"},1245266:{category_id:19,name:"utmpcd"},1245267:{category_id:19,name:"iasd"},1245268:{category_id:19,name:"Usenet Network News Transfer"},1245269:{category_id:19,name:"mobileip-agent"},1245270:{category_id:19,name:"mobilip-mn"},1245271:{category_id:19,name:"dna-cml"},1245272:{category_id:19,name:"comscm"},1245273:{category_id:19,name:"dsfgw"},1245274:{category_id:19,name:"dasp"},1245275:{category_id:19,name:"sgcp"},1245276:{category_id:19,name:"decvms-sysmgt"},1245277:{category_id:19,name:"cvc_hostd"},1245278:{category_id:19,name:"HTTP Protocol over TLS SSL"},1245279:{category_id:19,name:"Simple Network Paging Protocol"},1245280:{category_id:19,name:"Win2k+ Server Message Block"},1245281:{category_id:19,name:"ddm-rdb"},1245282:{category_id:19,name:"ddm-dfm"},1245283:{category_id:19,name:"DDM-SSL"},1245284:{category_id:19,name:"AS Server Mapper"},1245285:{category_id:19,name:"tserver"},1245286:{category_id:19,name:"Cray Network Semaphore server"},1245287:{category_id:19,name:"Cray SFS config server"},1245288:{category_id:19,name:"creativeserver"},1245289:{category_id:19,name:"contentserver"},1245290:{category_id:19,name:"creativepartnr"},1245291:{category_id:19,name:"macon-tcp"},1245292:{category_id:19,name:"scohelp"},1245294:{category_id:19,name:"ampr-rcmd"},1245295:{category_id:19,name:"skronk"},1245296:{category_id:19,name:"datasurfsrv"},1245297:{category_id:19,name:"datasurfsrvsec"},1245298:{category_id:19,name:"Alpes"},1245299:{category_id:19,name:"kpasswd"},1245300:{category_id:19,name:"SMTP Protocol over TLS SSL (was SSMTP)"},1245301:{category_id:19,name:"digital-vrc"},1245302:{category_id:19,name:"mylex-mapd"},1245303:{category_id:19,name:"Photuris Key Management"},1245304:{category_id:19,name:"Radio Control Protocol"},1245305:{category_id:19,name:"scx-proxy"},1245306:{category_id:19,name:"mondex"},1245307:{category_id:19,name:"ljk-login"},1245308:{category_id:19,name:"hybrid-pop"},1245309:{category_id:19,name:"tn-tl-w1"},1245310:{category_id:19,name:"Tcpnethaspsrv Protocol"},1245311:{category_id:19,name:"tn-tl-fd1"},1245312:{category_id:19,name:"ss7ns"},1245313:{category_id:19,name:"spsc"},1245314:{category_id:19,name:"iafserver"},1245316:{category_id:19,name:"loadsrv"},1245318:{category_id:19,name:"dvs"},1245319:{category_id:19,name:"bgs-nsi"},1245320:{category_id:19,name:"ulpnet"},1245321:{category_id:19,name:"Integra Software Management Environment"},1245322:{category_id:19,name:"Air Soft Power Burst"},1245324:{category_id:19,name:"sstats"},1245325:{category_id:19,name:"saft Simple Asynchronous File Transfer"},1245326:{category_id:19,name:"gss-http"},1245327:{category_id:19,name:"nest-protocol"},1245328:{category_id:19,name:"micom-pfs"},1245329:{category_id:19,name:"go-login"},1245330:{category_id:19,name:"Transport Independent Convergence for FNA"},1245331:{category_id:19,name:"pov-ray"},1245332:{category_id:19,name:"intecourier"},1245333:{category_id:19,name:"pim-rp-disc"},1245334:{category_id:19,name:"dantz"},1245335:{category_id:19,name:"siam"},1245336:{category_id:19,name:"ISO ILL Protocol"},1245337:{category_id:19,name:"VPN Key Exchange"},1245338:{category_id:19,name:"Simple Transportation Management Framework (STMF)"},1245339:{category_id:19,name:"asa-appl-proto"},1245340:{category_id:19,name:"intrinsa"},1245341:{category_id:19,name:"Citadel"},1245342:{category_id:19,name:"mailbox-lm"},1245343:{category_id:19,name:"ohimsrv"},1245344:{category_id:19,name:"crs"},1245345:{category_id:19,name:"xvttp"},1245346:{category_id:19,name:"snare"},1245347:{category_id:19,name:"FirstClass Protocol"},1245348:{category_id:19,name:"passgo"},1245349:{category_id:19,name:"BSD rexecd(8)"},1245350:{category_id:19,name:"BSD rlogind(8)"},1245351:{category_id:19,name:"BSD rshd(8)"},1245352:{category_id:19,name:"spooler"},1245353:{category_id:19,name:"videotex"},1245354:{category_id:19,name:"like tenex link but across"},1245355:{category_id:19,name:"ntalk"},1245356:{category_id:19,name:"unixtime"},1245357:{category_id:19,name:"Routing Information Protocol (RIP)"},1245358:{category_id:19,name:"ripng"},1245359:{category_id:19,name:"ulp"},1245360:{category_id:19,name:"ibm-db2"},1245361:{category_id:19,name:"NetWare Core Protocol (NCP)"},1245362:{category_id:19,name:"Timeserver"},1245363:{category_id:19,name:"newdate"},1245364:{category_id:19,name:"Stock IXChange"},1245365:{category_id:19,name:"Customer IXChange"},1245366:{category_id:19,name:"irc-serv"},1245370:{category_id:19,name:"readnews"},1245371:{category_id:19,name:"netwall for emergency broadcasts"},1245372:{category_id:19,name:"MegaMedia Admin"},1245373:{category_id:19,name:"iiop"},1245374:{category_id:19,name:"opalis-rdv"},1245375:{category_id:19,name:"Networked Media Streaming Protocol"},1245376:{category_id:19,name:"gdomap"},1245377:{category_id:19,name:"Apertus Technologies Load Determination"},1245378:{category_id:19,name:"uucpd"},1245379:{category_id:19,name:"uucp-rlogin"},1245380:{category_id:19,name:"Commerce"},1245381:{category_id:19,name:"klogin"},1245382:{category_id:19,name:"krcmd"},1245383:{category_id:19,name:"Kerberos encrypted remote shell"},1245384:{category_id:19,name:"DHCPv6 Client"},1245385:{category_id:19,name:"DHCPv6 Server"},1245386:{category_id:19,name:"AFP over TCP"},1245387:{category_id:19,name:"idfp"},1245388:{category_id:19,name:"new-who"},1245389:{category_id:19,name:"cybercash"},1245390:{category_id:19,name:"deviceshare"},1245391:{category_id:19,name:"pirp"},1245392:{category_id:19,name:"Real Time Stream Control Protocol"},1245393:{category_id:19,name:"dsf"},1245394:{category_id:19,name:"Remote File System (RFS)"},1245395:{category_id:19,name:"openvms-sysipc"},1245396:{category_id:19,name:"sdnskmp"},1245397:{category_id:19,name:"teedtap"},1245398:{category_id:19,name:"rmonitord"},1245399:{category_id:19,name:"monitor"},1245400:{category_id:19,name:"chcmd"},1245402:{category_id:19,name:"snews"},1245403:{category_id:19,name:"plan 9 file service"},1245404:{category_id:19,name:"whoami"},1245405:{category_id:19,name:"streettalk"},1245406:{category_id:19,name:"banyan-rpc"},1245407:{category_id:19,name:"Microsoft shuttle"},1245408:{category_id:19,name:"Microsoft rome"},1245409:{category_id:19,name:"demon"},1245410:{category_id:19,name:"udemon"},1245411:{category_id:19,name:"sonar"},1245412:{category_id:19,name:"banyan-vip"},1245413:{category_id:19,name:"FTP Software Agent System"},1245414:{category_id:19,name:"vemmi"},1245415:{category_id:19,name:"ipcd"},1245416:{category_id:19,name:"vnas"},1245417:{category_id:19,name:"ipdd"},1245418:{category_id:19,name:"decbsrv"},1245419:{category_id:19,name:"sntp-heartbeat"},1245420:{category_id:19,name:"Bundle Discovery Protocol"},1245421:{category_id:19,name:"scc-security"},1245422:{category_id:19,name:"Philips Video-Conferencing"},1245423:{category_id:19,name:"keyserver"},1245424:{category_id:19,name:"IMAP4+SSL"},1245425:{category_id:19,name:"password-chg"},1245426:{category_id:19,name:"submission"},1245427:{category_id:19,name:"cal"},1245428:{category_id:19,name:"eyelink"},1245429:{category_id:19,name:"tns-cml"},1245430:{category_id:19,name:"FileMaker Pro"},1245431:{category_id:19,name:"eudora-set"},1245432:{category_id:19,name:"HTTP RPC Ep Map"},1245433:{category_id:19,name:"tpip"},1245434:{category_id:19,name:"cab-protocol"},1245435:{category_id:19,name:"smsd"},1245436:{category_id:19,name:"PTC Name Service"},1245437:{category_id:19,name:"SCO Web Server Manager 3"},1245438:{category_id:19,name:"Aeolon Core Protocol"},1245439:{category_id:19,name:"Sun IPC server"},13:{category_id:0,name:"Tlen"},1310721:{category_id:20,name:"nqs"},1310722:{category_id:20,name:"Sender-Initiated Unsolicited File Transfer"},1310723:{category_id:20,name:"npmp-trap"},1310724:{category_id:20,name:"npmp-local"},1310725:{category_id:20,name:"npmp-gui"},1310726:{category_id:20,name:"HMMP Indication"},1310727:{category_id:20,name:"HMMP Operation"},1310728:{category_id:20,name:"SSLshell"},1310729:{category_id:20,name:"Internet Configuration Manager"},1310730:{category_id:20,name:"SCO System Administration Server"},1310731:{category_id:20,name:"SCO Desktop Administration Server"},1310732:{category_id:20,name:"DEI-ICDA"},1310733:{category_id:20,name:"Digital EVM"},1310734:{category_id:20,name:"SCO WebServer Manager"},1310735:{category_id:20,name:"ESCP"},1310736:{category_id:20,name:"Collaborator"},1310737:{category_id:20,name:"Aux Bus Shunt"},1310738:{category_id:20,name:"Crypto Admin"},1310739:{category_id:20,name:"DEC DLM"},1310740:{category_id:20,name:"ASIA"},1310741:{category_id:20,name:"PassGo Tivoli"},1310742:{category_id:20,name:"QMQP (qmail)"},1310743:{category_id:20,name:"3Com AMP3"},1310744:{category_id:20,name:"RDA"},1310745:{category_id:20,name:"IPP (Internet Printing Protocol)"},1310746:{category_id:20,name:"bmpp"},1310747:{category_id:20,name:"Service Status update (Sterling Software)"},1310748:{category_id:20,name:"ginad"},1310749:{category_id:20,name:"RLZ DBase"},1310750:{category_id:20,name:"LDAP Protocol over TLS SSL (was SLDAP)"},1310751:{category_id:20,name:"lanserver"},1310752:{category_id:20,name:"mcns-sec"},1310753:{category_id:20,name:"Multicast Source Discovery Protocol (MSDP)"},1310754:{category_id:20,name:"entrust-sps"},1310755:{category_id:20,name:"repcmd"},1310756:{category_id:20,name:"ESRO-EMSDP V1.3"},1310757:{category_id:20,name:"SANity"},1310758:{category_id:20,name:"dwr"},1310759:{category_id:20,name:"PSSC"},1310760:{category_id:20,name:"Label Distribution Protocol (LDP)"},1310761:{category_id:20,name:"DHCP Failover"},1310762:{category_id:20,name:"Registry Registrar Protocol (RRP)"},1310763:{category_id:20,name:"Aminet"},1310764:{category_id:20,name:"OBEX"},1310765:{category_id:20,name:"IEEE MMS"},1310766:{category_id:20,name:"HELLO_PORT"},1310767:{category_id:20,name:"AODV"},1310768:{category_id:20,name:"TINC"},1310769:{category_id:20,name:"SPMP"},1310770:{category_id:20,name:"RMC"},1310771:{category_id:20,name:"TenFold"},1310772:{category_id:20,name:"URL Rendezvous"},1310773:{category_id:20,name:"MacOS Server Admin"},1310774:{category_id:20,name:"HAP"},1310775:{category_id:20,name:"PFTP"},1310776:{category_id:20,name:"PureNoise"},1310777:{category_id:20,name:"Secure Aux Bus"},1310778:{category_id:20,name:"Sun DR"},1310779:{category_id:20,name:"doom Id Software"},1310780:{category_id:20,name:"campaign contribution disclosures - SDR Technologies"},1310781:{category_id:20,name:"MeComm"},1310782:{category_id:20,name:"MeRegister"},1310783:{category_id:20,name:"VACDSM-SWS"},1310784:{category_id:20,name:"VACDSM-APP"},1310785:{category_id:20,name:"VPPS-QUA"},1310786:{category_id:20,name:"CIMPLEX"},1310787:{category_id:20,name:"ACAP"},1310788:{category_id:20,name:"DCTP"},1310789:{category_id:20,name:"VPPS Via"},1310790:{category_id:20,name:"Virtual Presence Protocol"},1310791:{category_id:20,name:"GNU Gereration Foundation NCP"},1310792:{category_id:20,name:"MRM"},1310793:{category_id:20,name:"entrust-aaas"},1310794:{category_id:20,name:"entrust-aams"},1310795:{category_id:20,name:"XFR"},1310796:{category_id:20,name:"CORBA IIOP"},1310797:{category_id:20,name:"CORBA IIOP SSL"},1310798:{category_id:20,name:"MDC Port Mapper"},1310799:{category_id:20,name:"Hardware Control Protocol Wismar"},1310800:{category_id:20,name:"asipregistry"},1310801:{category_id:20,name:"REALM-RUSD"},1310802:{category_id:20,name:"NMAP"},1310803:{category_id:20,name:"VATP"},1310804:{category_id:20,name:"MS Exchange Routing"},1310805:{category_id:20,name:"Hyperwave-ISP"},1310806:{category_id:20,name:"connendp"},1310807:{category_id:20,name:"Linux-HA (High-Availability Linux)"},1310808:{category_id:20,name:"IEEE-MMS-SSL"},1310809:{category_id:20,name:"RUSHD"},1310810:{category_id:20,name:"UUIDGEN"},1310811:{category_id:20,name:"OLSR"},1310812:{category_id:20,name:"Access Network"},1310813:{category_id:20,name:"errlog copy server daemon"},1310814:{category_id:20,name:"AgentX"},1310815:{category_id:20,name:"Secure Internet Live Conferencing (SILC)"},1310816:{category_id:20,name:"Borland DSJ"},1310817:{category_id:20,name:"Entrust Key Management Service Handler"},1310818:{category_id:20,name:"Entrust Administration Service Handler"},1310819:{category_id:20,name:"Cisco TDP"},1310820:{category_id:20,name:"IBM NetView DM 6000 Server Client"},1310821:{category_id:20,name:"IBM NetView DM 6000 send tcp"},1310822:{category_id:20,name:"IBM NetView DM 6000 receive tcp"},1310823:{category_id:20,name:"netGW"},1310824:{category_id:20,name:"Network based Rev. Cont. Sys."},1310825:{category_id:20,name:"Flexible License Manager"},1310826:{category_id:20,name:"Fujitsu Device Control"},1310827:{category_id:20,name:"Russell Info Sci Calendar Manager"},1310828:{category_id:20,name:"Kerberos 5 admin changepw"},1310830:{category_id:20,name:"rfile"},1310832:{category_id:20,name:"pump"},1310833:{category_id:20,name:"qrh"},1310834:{category_id:20,name:"rrh"},1310835:{category_id:20,name:"kerberos v5 server propagation"},1310836:{category_id:20,name:"nlogin"},1310837:{category_id:20,name:"con"},1310839:{category_id:20,name:"ns"},1310840:{category_id:20,name:"kpwd Kerberos (v4) passwd"},1310841:{category_id:20,name:"quotad"},1310842:{category_id:20,name:"cycleserv"},1310843:{category_id:20,name:"omserv"},1310844:{category_id:20,name:"webster"},1310845:{category_id:20,name:"phone"},1310846:{category_id:20,name:"vid"},1310847:{category_id:20,name:"cadlock"},1310848:{category_id:20,name:"rtip"},1310849:{category_id:20,name:"cycleserv2"},1310850:{category_id:20,name:"submit"},1310851:{category_id:20,name:"rpasswd"},1310852:{category_id:20,name:"entomb"},1310853:{category_id:20,name:"wpages"},1310854:{category_id:20,name:"Hummingbird Exceed jconfig"},1310855:{category_id:20,name:"wpgs"},1310856:{category_id:20,name:"concert"},1310857:{category_id:20,name:"QSC"},1310858:{category_id:20,name:"controlit"},1310859:{category_id:20,name:"mdbs_daemon"},1310860:{category_id:20,name:"device"},1310861:{category_id:20,name:"FCP"},1310862:{category_id:20,name:"itm-mcell-s"},1310863:{category_id:20,name:"PKIX-3 CA RA"},1310864:{category_id:20,name:"DHCP Failover 2"},1310865:{category_id:20,name:"SUP server"},1310866:{category_id:20,name:"rsync"},1310867:{category_id:20,name:"ICL coNETion locate server"},1310868:{category_id:20,name:"ICL coNETion server info"},1310869:{category_id:20,name:"AccessBuilder"},1310870:{category_id:20,name:"OMG Initial Refs"},1310871:{category_id:20,name:"Samba SWAT Tool"},1310872:{category_id:20,name:"IDEAFARM-CHAT"},1310873:{category_id:20,name:"IDEAFARM-CATCH"},1310874:{category_id:20,name:"xact-backup"},1310875:{category_id:20,name:"SecureNet Pro sensor"},1310878:{category_id:20,name:"Netnews Administration System"},1310879:{category_id:20,name:"Telnet Protocol over TLS SSL"},1310880:{category_id:20,name:"IMAP4 Protocol over TLS SSL"},1310881:{category_id:20,name:"ICP Protocol over TLS SSL"},1310882:{category_id:20,name:"POP3 Protocol over TLS SSL"},1310883:{category_id:20,name:"bhoetty"},1310884:{category_id:20,name:"Cray Unified Resource Manager"},1310887:{category_id:20,name:"Microsoft Authentication via SSL"},1310888:{category_id:20,name:"Google(SSL)"},1310889:{category_id:20,name:"Yahoo Authentication via SSL"},1310890:{category_id:20,name:"AOL Authentication via SSL"},1310891:{category_id:20,name:"FIX"},1310892:{category_id:20,name:"STUN"},1310893:{category_id:20,name:"Dynamic Host Configuration Protocol (DHCP)"},1310894:{category_id:20,name:"Megaco"},1310895:{category_id:20,name:"Rstatd"},1310896:{category_id:20,name:"RSVP"},1310897:{category_id:20,name:"SOAP"},1310898:{category_id:20,name:"Ess Apple Authentication via SSL"},1310899:{category_id:20,name:"TFTP"},1310900:{category_id:20,name:"Daytime"},1310902:{category_id:20,name:"MicrosoftOnline Authentication via SSL"},1310903:{category_id:20,name:"Microsoft WINS"},1310904:{category_id:20,name:"Remote Procedure Call (RPC)"},1310905:{category_id:20,name:"SSL/TLS"},1310906:{category_id:20,name:"Google APIs(SSL)"},1310907:{category_id:20,name:"Sina Authentication via SSL"},1310908:{category_id:20,name:"Google App Engine(SSL)"},1310909:{category_id:20,name:"Google User Content(SSL)"},1310910:{category_id:20,name:"Blackberry Authentication via SSL"},1376306:{category_id:21,name:"Apple iMessage"},1376323:{category_id:21,name:"ezRead Touch"},1376357:{category_id:21,name:"Android browser"},1376359:{category_id:21,name:"Symbian browser"},14:{category_id:0,name:"Wlt"},15:{category_id:0,name:"RenRen"},1507329:{category_id:23,name:"QQ Private Protocol"},1507330:{category_id:23,name:"Thunder Private Protocol"},1507333:{category_id:23,name:"Jabber Private Protocol"},1572865:{category_id:24,name:"Classmates"},1572866:{category_id:24,name:"Yik Yak"},1572867:{category_id:24,name:"Facebook"},1572868:{category_id:24,name:"Flickr"},1572870:{category_id:24,name:"Friendfeed"},1572871:{category_id:24,name:"Hi5"},1572872:{category_id:24,name:"Linkedin"},1572873:{category_id:24,name:"Livejournal"},1572874:{category_id:24,name:"Twitter"},1572875:{category_id:24,name:"Plurk"},1572876:{category_id:24,name:"MySpace"},1572880:{category_id:24,name:"Khan Academy"},1572881:{category_id:24,name:"Pinterest"},1572882:{category_id:24,name:"Tumblr"},1572883:{category_id:24,name:"MeetMe"},1572884:{category_id:24,name:"VKontakte"},1572885:{category_id:24,name:"Odnoklassniki"},1572886:{category_id:24,name:"Niwota"},1572887:{category_id:24,name:"Tagged"},1572889:{category_id:24,name:"PerfSpot"},1572890:{category_id:24,name:"Me2day"},1572891:{category_id:24,name:"Mekusharim"},1572892:{category_id:24,name:"Draugiem"},1572893:{category_id:24,name:"Badoo"},1572894:{category_id:24,name:"Meetup"},1572895:{category_id:24,name:"Foursquare"},1572896:{category_id:24,name:"Ning"},1572897:{category_id:24,name:"i-Part"},1572898:{category_id:24,name:"Wretch"},1572899:{category_id:24,name:"Dudu"},1572900:{category_id:24,name:"Mig33"},1572901:{category_id:24,name:"Hatena"},1572902:{category_id:24,name:"eHarmony"},1572903:{category_id:24,name:"Fotolog "},1572905:{category_id:24,name:"Tencent QQ"},1572906:{category_id:24,name:"Pixnet"},1572907:{category_id:24,name:"Nk.Pl"},1572908:{category_id:24,name:"K.ai"},1572909:{category_id:24,name:"Twoo"},1572910:{category_id:24,name:"Plaxo"},1572911:{category_id:24,name:"Cyworld"},1572912:{category_id:24,name:"Jivesoftware"},1572913:{category_id:24,name:"WordPress"},1572914:{category_id:24,name:"FMyLife"},1572915:{category_id:24,name:"Dcinside"},1572916:{category_id:24,name:"Class Chinaren"},1572917:{category_id:24,name:"Bai Sohu"},1572918:{category_id:24,name:"Yammer"},1572919:{category_id:24,name:"Douban"},1572920:{category_id:24,name:"Gamer"},1572921:{category_id:24,name:"Xuite"},1572922:{category_id:24,name:"ChatMe"},1572923:{category_id:24,name:"Clien.net"},1572927:{category_id:24,name:"AdultFriendFinder"},1572928:{category_id:24,name:"Fling.com"},1572929:{category_id:24,name:"Delicious"},1572930:{category_id:24,name:"Mei.fm"},1572931:{category_id:24,name:"Streetlife"},1572967:{category_id:24,name:"Daum-blog"},1572968:{category_id:24,name:"Naver-blog"},1572970:{category_id:24,name:"Panoramio"},1572974:{category_id:24,name:"Blogger "},1572975:{category_id:24,name:"FC2"},1572976:{category_id:24,name:"Yahoo Blog"},1572977:{category_id:24,name:"Friendster"},1572978:{category_id:24,name:"Ameba"},1572980:{category_id:24,name:"Bebo social network"},1572981:{category_id:24,name:"Kaixin"},1572983:{category_id:24,name:"Orkut"},1572985:{category_id:24,name:"Aol-Answers"},1572987:{category_id:24,name:"CoolTalk social network"},1572988:{category_id:24,name:"RenRen.com"},1572989:{category_id:24,name:"TweetDeck"},1572990:{category_id:24,name:"Hootsuite"},1572998:{category_id:24,name:"Xing"},1572999:{category_id:24,name:"Lokalisten"},1573000:{category_id:24,name:"meinVZ/studiVZ"},1573004:{category_id:24,name:"Viadeo"},1573005:{category_id:24,name:"Tuenti"},1573006:{category_id:24,name:"Hyves"},1573007:{category_id:24,name:"Mixi.jp"},1573008:{category_id:24,name:"Yahoo-mbga.jp"},1573009:{category_id:24,name:"Gree.jp"},1573010:{category_id:24,name:"Netlog"},1573011:{category_id:24,name:"2ch"},1573014:{category_id:24,name:"LoveTheseCurves"},1573015:{category_id:24,name:"Weibo"},1573016:{category_id:24,name:"Google-plus"},1573017:{category_id:24,name:"Skyrock"},1573018:{category_id:24,name:"51.com"},1573019:{category_id:24,name:"Jackd(M)"},1573020:{category_id:24,name:"Touch(M)"},1573021:{category_id:24,name:"Skout(M)"},1573022:{category_id:24,name:"Instagram"},1573023:{category_id:24,name:"Jiayuan"},1573024:{category_id:24,name:"Zoosk(M)"},1573025:{category_id:24,name:"DatingDNA(M)"},1573026:{category_id:24,name:"500px"},1573027:{category_id:24,name:"Socialcam(M)"},1573028:{category_id:24,name:"iAround(M)"},1573029:{category_id:24,name:"MomoChat(M)"},1573030:{category_id:24,name:"Path(M)"},1573031:{category_id:24,name:"WeHeartIt"},1573032:{category_id:24,name:"Fancy(M)"},1573033:{category_id:24,name:"Vine(M)"},1573035:{category_id:24,name:"Miliao"},16:{category_id:0,name:"Omegle"},16777215:{category_id:255,name:"Unknown"},17:{category_id:0,name:"IPMSG"},18:{category_id:0,name:"Aliww"},1835009:{category_id:28,name:"LiveJasmin"},1835010:{category_id:28,name:"Youporn"},1835011:{category_id:28,name:"XNXX Galleries"},1835012:{category_id:28,name:"Adult Friendfinder"},1835013:{category_id:28,name:"FreeOnes"},1835014:{category_id:28,name:"Streamate"},1835015:{category_id:28,name:"Fling"},1835016:{category_id:28,name:"Literotica.Com"},1835017:{category_id:28,name:"Adam4Adam"},1835018:{category_id:28,name:"Playboy Digital"},1835019:{category_id:28,name:"VICE"},1835020:{category_id:28,name:"Manhunt"},1835021:{category_id:28,name:"GayRomeo"},1835022:{category_id:28,name:"Newgrounds"},1835023:{category_id:28,name:"Payserve"},1835024:{category_id:28,name:"eBaums World"},1835025:{category_id:28,name:"Flirt4Free"},1835026:{category_id:28,name:"Be Naughty"},1835027:{category_id:28,name:"Debonairblog"},1835028:{category_id:28,name:"AEBN"},1835029:{category_id:28,name:"FetLife"},1835030:{category_id:28,name:"ImLive"},1835031:{category_id:28,name:"Video Sex Archive"},1835032:{category_id:28,name:"Mr. Skin"},1835033:{category_id:28,name:"Clips4Sale"},1835034:{category_id:28,name:"Femjoy"},1835035:{category_id:28,name:"HQ Porn Links"},1835036:{category_id:28,name:"The Voyeurweb"},1835037:{category_id:28,name:"Alt.Sex.Stories Text Repository"},1835038:{category_id:28,name:"Xcams"},1835039:{category_id:28,name:"AV Entertainments"},1835040:{category_id:28,name:"Indian Sex Stories"},1835041:{category_id:28,name:"World Sex"},1835042:{category_id:28,name:"Fur Affinity"},1835043:{category_id:28,name:"Celebrity Movie Archive"},1835044:{category_id:28,name:"The Erotic Review"},1835045:{category_id:28,name:"Internet Adult Film Database"},1835046:{category_id:28,name:"Shoosh Time"},1835047:{category_id:28,name:"Thumblogger"},1835048:{category_id:28,name:"First Time Videos"},1835049:{category_id:28,name:"The Huns Yellow Pages"},1835050:{category_id:28,name:"CollarMe"},1835051:{category_id:28,name:"Sex in the UK"},1835052:{category_id:28,name:"Links Hit"},1835053:{category_id:28,name:"Peachy Forum"},1835054:{category_id:28,name:"Swing Life Style"},1835055:{category_id:28,name:"Scoreland Tits"},1835056:{category_id:28,name:"Girlfriend Videos"},1835057:{category_id:28,name:"Digital Playground"},1835058:{category_id:28,name:"Penthouse"},1835059:{category_id:28,name:"Squirt.org"},1835060:{category_id:28,name:"MPL Studios"},1835061:{category_id:28,name:"Wicked Weasel Bikinis"},1835062:{category_id:28,name:"Nifty Erotic Stories Archive"},1835063:{category_id:28,name:"VideoBox"},1835064:{category_id:28,name:"EdenFantasys"},1835065:{category_id:28,name:"Vintage Erotica Forum"},1835066:{category_id:28,name:"PHE"},1835067:{category_id:28,name:"DudesNude"},1835068:{category_id:28,name:"Heaven 666"},1835069:{category_id:28,name:"GameLink"},1835070:{category_id:28,name:"Ask Jolene"},1835071:{category_id:28,name:"Polyner Artist Web Ring"},1835072:{category_id:28,name:"VirtuaGirl 2"},1835073:{category_id:28,name:"Inthecrack"},1835074:{category_id:28,name:"Suicide Girls"},1835075:{category_id:28,name:"Fleshbot"},1835076:{category_id:28,name:"Oglaf"},1835077:{category_id:28,name:"ALS Scan"},1835078:{category_id:28,name:"Odloty"},1835079:{category_id:28,name:"Southern Charms"},1835080:{category_id:28,name:"Fab Swingers"},1835081:{category_id:28,name:"The Stile Project"},1835082:{category_id:28,name:"Hentai Foundry"},1835083:{category_id:28,name:"Adult DVD Empire"},1835084:{category_id:28,name:"Webcams"},1835085:{category_id:28,name:"Cityvibe"},1835086:{category_id:28,name:"Manjam"},1835087:{category_id:28,name:"XBIZ"},1835088:{category_id:28,name:"Rogan"},1835089:{category_id:28,name:"AVN Media Network"},1835090:{category_id:28,name:"Fleshlight"},1835091:{category_id:28,name:"Fucking Machines"},1835092:{category_id:28,name:"Recon"},1835093:{category_id:28,name:"Hogtied"},1835094:{category_id:28,name:"Swingers Date Club"},1835095:{category_id:28,name:"Sex Toys Uk"},1835096:{category_id:28,name:"Lush Sex Stories"},1835097:{category_id:28,name:"NiteFlirt"},1835098:{category_id:28,name:"Wife Lovers"},1835099:{category_id:28,name:"Sucksex"},1835100:{category_id:28,name:"Project Voyeur"},1835101:{category_id:28,name:"Fritchy Forums"},1835102:{category_id:28,name:"AL4A"},1835103:{category_id:28,name:"What The Fuck!?"},1835104:{category_id:28,name:"Kaktuz"},1835105:{category_id:28,name:"Rabbits Reviews"},1835106:{category_id:28,name:"Truth or Dare Pics"},1835107:{category_id:28,name:"Sunny Leone"},1835108:{category_id:28,name:"SPAcash"},19:{category_id:0,name:"Mail.ru IM"},1900545:{category_id:29,name:"The Internet Movie Database"},1900546:{category_id:29,name:"BBC Online"},1900547:{category_id:29,name:"CNN Interactive"},1900548:{category_id:29,name:"ESPN.com"},1900549:{category_id:29,name:"The Weather Channel"},1900550:{category_id:29,name:"FoxNews"},1900551:{category_id:29,name:"deviantART"},1900552:{category_id:29,name:"Yahoo! Movies"},1900553:{category_id:29,name:"NBC News"},1900554:{category_id:29,name:"Yahoo! TV"},1900555:{category_id:29,name:"ABCNews"},1900556:{category_id:29,name:"NDTV"},1900557:{category_id:29,name:"CBS News"},1900558:{category_id:29,name:"CNN/Money"},1900559:{category_id:29,name:"TMZ"},1900560:{category_id:29,name:"CNBC"},1900561:{category_id:29,name:"Wired"},1900562:{category_id:29,name:"Fox Sports Network"},1900563:{category_id:29,name:"CNN/SI Network Page"},1900564:{category_id:29,name:"Rotten Tomatoes"},1900565:{category_id:29,name:"Disney"},1900566:{category_id:29,name:"Urban Dictionary"},1900567:{category_id:29,name:"Food Network"},1900568:{category_id:29,name:"British Sky Broadcasting"},1900569:{category_id:29,name:"NPR Online- National Public Radio"},1900570:{category_id:29,name:"Gawker"},1900571:{category_id:29,name:"Last.fm"},1900572:{category_id:29,name:"Comcast Corporation"},1900573:{category_id:29,name:"ABC"},1900574:{category_id:29,name:"CBS"},1900575:{category_id:29,name:"Salon"},1900576:{category_id:29,name:"CBC Television"},1900577:{category_id:29,name:"E Online"},1900578:{category_id:29,name:"FanFiction.Net"},1900579:{category_id:29,name:"Ultimate Guitar Archive"},1900580:{category_id:29,name:"Deezer.com"},1900581:{category_id:29,name:"Fandango"},1900582:{category_id:29,name:"Copyscape"},1900583:{category_id:29,name:"A-Z Lyrics"},1900584:{category_id:29,name:"Atlantic Online"},1900585:{category_id:29,name:"Discovery Channel"},1900586:{category_id:29,name:"Australian Broadcasting Corporation"},1900587:{category_id:29,name:"Egotastic"},1900588:{category_id:29,name:"NBC"},1900589:{category_id:29,name:"MetroLyrics"},1900590:{category_id:29,name:"TV Guide"},1900591:{category_id:29,name:"MTV"},1900592:{category_id:29,name:"Entertainment Weekly"},1900593:{category_id:29,name:"ksl"},1900594:{category_id:29,name:"World Wrestling Entertainment"},1900595:{category_id:29,name:"Cartoon Network"},1900596:{category_id:29,name:"xkcd"},1900597:{category_id:29,name:"SkyscraperCity"},1900598:{category_id:29,name:"DIRECTV"},1900599:{category_id:29,name:"Discogs"},1900600:{category_id:29,name:"PBS Online"},1900601:{category_id:29,name:"PBS Kids!"},1900602:{category_id:29,name:"The Hollywood Reporter"},1900603:{category_id:29,name:"Nickelodeon"},1900604:{category_id:29,name:"TV"},1900605:{category_id:29,name:"Ravelry"},1900606:{category_id:29,name:"Nick Jr."},1900607:{category_id:29,name:"Rollingstone Magazine"},1900608:{category_id:29,name:"India Forums "},1900609:{category_id:29,name:"Deutsche Welle Radio"},1900610:{category_id:29,name:"Cox Communications"},1900611:{category_id:29,name:"Voice of America"},1900612:{category_id:29,name:"AMC"},1900613:{category_id:29,name:"Metacritic"},1900614:{category_id:29,name:"Islamic Republic of Iran Broadcasting"},1900615:{category_id:29,name:"goComics"},1900616:{category_id:29,name:"The New Yorker"},1900617:{category_id:29,name:"B92"},1900618:{category_id:29,name:"Moviefone"},1900619:{category_id:29,name:"Lyrics Freak"},1900620:{category_id:29,name:"Oprah"},1900621:{category_id:29,name:"Comedy Central"},1900622:{category_id:29,name:"Veoh"},1900623:{category_id:29,name:"Box Office Mojo"},1900624:{category_id:29,name:"All Music Guide"},1900625:{category_id:29,name:"Billboard"},1900626:{category_id:29,name:"RAI"},1900627:{category_id:29,name:"Home and Garden Television (HGTV)"},1900628:{category_id:29,name:"Canon World Wide Gateway"},1900629:{category_id:29,name:"Lorem Ipsum"},1966081:{category_id:30,name:"PayPal"},1966082:{category_id:30,name:"Alibaba"},1966083:{category_id:30,name:"Yahoo! Finance"},1966084:{category_id:30,name:"Bank of America"},1966085:{category_id:30,name:"Chase Bank"},1966086:{category_id:30,name:"Wells Fargo"},1966087:{category_id:30,name:"The Wall Street Journal Interactive Edition"},1966088:{category_id:30,name:"Samsung Electronics"},1966089:{category_id:30,name:"UPS"},196609:{category_id:3,name:"FTP Applications"},1966090:{category_id:30,name:"Target Corporation"},1966091:{category_id:30,name:"Reuters Group PLC"},1966092:{category_id:30,name:"Indeed"},1966093:{category_id:30,name:"Forbes Magazine"},1966094:{category_id:30,name:"Constant Contact"},1966095:{category_id:30,name:"Shutterstock"},1966096:{category_id:30,name:"ClickBank"},1966097:{category_id:30,name:"AT&T"},1966098:{category_id:30,name:"American Express"},1966099:{category_id:30,name:"FedEx"},196610:{category_id:3,name:"GetRight"},1966100:{category_id:30,name:"EzineArticles"},1966101:{category_id:30,name:"Commission Junction"},1966102:{category_id:30,name:"TechCrunch"},1966103:{category_id:30,name:"HDFC Bank Ltd."},1966104:{category_id:30,name:"Verizon Wireless"},1966105:{category_id:30,name:"Freelancer"},1966106:{category_id:30,name:"iStockphoto"},1966107:{category_id:30,name:"Bloomberg"},1966108:{category_id:30,name:"Capital One Financial Corp."},1966109:{category_id:30,name:"Fotolia"},196611:{category_id:3,name:"FlashGet"},1966110:{category_id:30,name:"ICICI Bank"},1966111:{category_id:30,name:"123RF Royalty Free Stock Photos"},1966112:{category_id:30,name:"Zillow"},1966113:{category_id:30,name:"Monster"},1966114:{category_id:30,name:"TradeDoubler"},1966115:{category_id:30,
name:"Industrial and Commercial Bank of China"},1966116:{category_id:30,name:"Nokia"},1966117:{category_id:30,name:"Sears"},1966118:{category_id:30,name:"CNET News"},1966119:{category_id:30,name:"Indian Railways"},196612:{category_id:3,name:"AsianDVDClub"},1966120:{category_id:30,name:"The Sun"},1966121:{category_id:30,name:"Verizon Corporation"},1966122:{category_id:30,name:"Elance"},1966123:{category_id:30,name:"CareerBuilder"},1966124:{category_id:30,name:"Citibank U.S."},1966125:{category_id:30,name:"GetResponse Email Marketing"},1966126:{category_id:30,name:"Business Week"},1966127:{category_id:30,name:"MarketWatch"},1966128:{category_id:30,name:"Shareasale"},1966129:{category_id:30,name:"SiteSell"},196613:{category_id:3,name:"Web File Transfer"},1966130:{category_id:30,name:"Manta"},1966131:{category_id:30,name:"Eventbrite"},1966132:{category_id:30,name:"Citibank Online"},1966133:{category_id:30,name:"Dreamstime Stock Photography"},1966134:{category_id:30,name:"Costco Wholesale Corporation"},1966135:{category_id:30,name:"H&M"},1966136:{category_id:30,name:"Merriam-Webster"},1966137:{category_id:30,name:"The Economic Times"},1966138:{category_id:30,name:"U.S. Bank"},1966139:{category_id:30,name:"TD Bank"},196614:{category_id:3,name:"FileZilla"},1966140:{category_id:30,name:"Intel Corp"},1966141:{category_id:30,name:"Zazzle"},1966142:{category_id:30,name:"Behance Network"},1966143:{category_id:30,name:"Commonwealth Bank of Australia"},1966144:{category_id:30,name:"La Caja de Ahorros y Pensiones de Barcelona"},1966145:{category_id:30,name:"ZDNet"},1966146:{category_id:30,name:"Realtor"},1966147:{category_id:30,name:"New York Post Online Edition"},1966148:{category_id:30,name:"glispa"},1966149:{category_id:30,name:"Financial Times News"},196615:{category_id:3,name:"Kuaipan"},1966150:{category_id:30,name:"SitePoint"},1966151:{category_id:30,name:"T-Mobile"},1966152:{category_id:30,name:"National Hurricane Center"},1966153:{category_id:30,name:"ForexFactory"},1966154:{category_id:30,name:"Sprint"},1966155:{category_id:30,name:"Sony Electronics"},1966156:{category_id:30,name:"VistaPrint"},1966157:{category_id:30,name:"MOJO Works"},1966158:{category_id:30,name:"TD Canada Trust"},1966159:{category_id:30,name:"Zara"},196616:{category_id:3,name:"DBank"},1966160:{category_id:30,name:"Cisco"},1966161:{category_id:30,name:"WebMoney Transfer"},1966162:{category_id:30,name:"Fidelity Investments"},1966163:{category_id:30,name:"USAA"},1966164:{category_id:30,name:"Discover Financial Services"},1966165:{category_id:30,name:"Lego Company"},1966166:{category_id:30,name:"Axis Bank"},1966167:{category_id:30,name:"The Economist"},1966168:{category_id:30,name:"Kmart"},1966169:{category_id:30,name:"Inc"},196617:{category_id:3,name:"115.com"},1966170:{category_id:30,name:"Univision"},1966171:{category_id:30,name:"DHL Worldwide Express"},1966172:{category_id:30,name:"PNC Financial Services Group"},1966173:{category_id:30,name:"WebEx Communications"},196618:{category_id:3,name:"Weiyun"},196619:{category_id:3,name:"Rayfile"},196620:{category_id:3,name:"0zz0"},196621:{category_id:3,name:"Herosh"},196622:{category_id:3,name:"2Shared"},196624:{category_id:3,name:"BIZHARD"},196626:{category_id:3,name:"UPlusBox"},196627:{category_id:3,name:"Filebox.ro"},196628:{category_id:3,name:"Qnext"},196629:{category_id:3,name:"OneDrive"},196630:{category_id:3,name:"YunFile"},196631:{category_id:3,name:"Filehosting"},196632:{category_id:3,name:"Dev-Host"},196633:{category_id:3,name:"Solidfiles"},196634:{category_id:3,name:"IBackup"},196635:{category_id:3,name:"FileSwap"},196637:{category_id:3,name:"Temp-Share"},196638:{category_id:3,name:"WikiUpload"},196640:{category_id:3,name:"MEGA"},196641:{category_id:3,name:"Copy.com"},196642:{category_id:3,name:"4Shared"},196643:{category_id:3,name:"HiCloud"},196644:{category_id:3,name:"Depositfiles"},196645:{category_id:3,name:"Docstoc"},196646:{category_id:3,name:"360 Cloud"},196647:{category_id:3,name:"Symantec Nomdb"},196648:{category_id:3,name:"Baidu Cloud"},196649:{category_id:3,name:"GitHub"},196650:{category_id:3,name:"FileDropper"},196651:{category_id:3,name:"CrashPlan"},196652:{category_id:3,name:"Net2FTP"},196653:{category_id:3,name:"Mediafire"},196655:{category_id:3,name:"Carbonite"},196656:{category_id:3,name:"Mozy"},196657:{category_id:3,name:"SOS Online Backup"},196669:{category_id:3,name:"cute-ftp(HTTP)"},196676:{category_id:3,name:"Box"},196678:{category_id:3,name:"Scribd"},196680:{category_id:3,name:"Rapidshare"},196681:{category_id:3,name:"Sendspace"},196683:{category_id:3,name:"Hightail"},196684:{category_id:3,name:"Diino"},196686:{category_id:3,name:"Fluxiom"},196689:{category_id:3,name:"Nomadesk"},196692:{category_id:3,name:"Dropbox"},196693:{category_id:3,name:"Filesend.to"},196694:{category_id:3,name:"Firestorage"},196695:{category_id:3,name:"Naver Ndrive"},196696:{category_id:3,name:"Filesend.net"},196697:{category_id:3,name:"Crocko"},196700:{category_id:3,name:"Fileserve"},196701:{category_id:3,name:"Netload"},196702:{category_id:3,name:"Megashares"},196703:{category_id:3,name:"TransferBigFiles"},196705:{category_id:3,name:"Filemail"},196706:{category_id:3,name:"Zamzar"},196708:{category_id:3,name:"Divshare"},196709:{category_id:3,name:"DL Free"},196711:{category_id:3,name:"Nakido"},196713:{category_id:3,name:"Gigaup"},196714:{category_id:3,name:"Filestube"},196716:{category_id:3,name:"Filer.cx"},196717:{category_id:3,name:"Cx.com"},196718:{category_id:3,name:"Elephantdrive"},196722:{category_id:3,name:"Zshare"},196723:{category_id:3,name:"Freakshare"},196724:{category_id:3,name:"Uploading"},196725:{category_id:3,name:"Bitshare"},196726:{category_id:3,name:"Letitbit.net"},196727:{category_id:3,name:"Extabit"},196728:{category_id:3,name:"Filefactory"},196729:{category_id:3,name:"Furk"},196731:{category_id:3,name:"GoldFile"},196732:{category_id:3,name:"GigaSize"},196733:{category_id:3,name:"Turbobit"},196735:{category_id:3,name:"Hitfile"},196737:{category_id:3,name:"Zippyshare"},196738:{category_id:3,name:"SoundCloud"},196739:{category_id:3,name:"SpeedyShare"},196742:{category_id:3,name:"FilePost.net"},196743:{category_id:3,name:"GlumboUploads"},196744:{category_id:3,name:"RapidGator.net"},196746:{category_id:3,name:"Clip2net"},196747:{category_id:3,name:"Datei.to"},196748:{category_id:3,name:"Totodisk"},196749:{category_id:3,name:"LeapFile"},196750:{category_id:3,name:"BigUpload"},196751:{category_id:3,name:"OnlineFileFolder"},196752:{category_id:3,name:"ASUSWebStorage"},196753:{category_id:3,name:"File-Upload.net"},196754:{category_id:3,name:"File-Works"},196755:{category_id:3,name:"Zumodrive"},196756:{category_id:3,name:"PutLocker"},196757:{category_id:3,name:"Wetransfer"},196758:{category_id:3,name:"iCloud"},196759:{category_id:3,name:"CloudMe"},196760:{category_id:3,name:"Beanywhere"},196761:{category_id:3,name:"Sugarsync"},196762:{category_id:3,name:"DriveHQ"},196764:{category_id:3,name:"Backblaze"},196765:{category_id:3,name:"AirSet"},196766:{category_id:3,name:"SpiderOak"},196767:{category_id:3,name:"1337X"},196768:{category_id:3,name:"MailBigFile"},196769:{category_id:3,name:"GoldCoupon.co.kr"},196770:{category_id:3,name:"Egnyte"},196771:{category_id:3,name:"SmugMug"},196772:{category_id:3,name:"SlideShare.net"},196773:{category_id:3,name:"4Sync"},196774:{category_id:3,name:"IDrive"},196775:{category_id:3,name:"Mendeley"},196777:{category_id:3,name:"Daum-cloud"},2:{category_id:0,name:"Yahoo Messenger"},20:{category_id:0,name:"Kubao"},2031617:{category_id:31,name:"Yahoo!"},2031618:{category_id:31,name:"Yahoo! Mail"},2031619:{category_id:31,name:"Windows Live Hotmail"},2031620:{category_id:31,name:"Yahoo! Search"},2031621:{category_id:31,name:"Google Docs"},2031622:{category_id:31,name:"Alexa Internet"},2031623:{category_id:31,name:"Bing"},2031624:{category_id:31,name:"Babylon"},2031625:{category_id:31,name:"Google+"},2031626:{category_id:31,name:"Microsoft Corporation"},2031627:{category_id:31,name:"Apple Inc."},2031628:{category_id:31,name:"Go"},2031629:{category_id:31,name:"Ask"},2031630:{category_id:31,name:"Adobe Systems Incorporated"},2031631:{category_id:31,name:"AVG | Antivirus and Security Software"},2031632:{category_id:31,name:"The Pirate Bay"},2031633:{category_id:31,name:"www.ZEDO"},2031634:{category_id:31,name:"Babylon Search"},2031635:{category_id:31,name:"Stack Overflow"},2031636:{category_id:31,name:"About"},2031637:{category_id:31,name:"Google Adwords"},2031638:{category_id:31,name:"Imgur.com"},2031639:{category_id:31,name:"Go Daddy"},2031640:{category_id:31,name:"Google Play"},2031641:{category_id:31,name:"Vimeo.com"},2031642:{category_id:31,name:"The Apple Store"},2031643:{category_id:31,name:"Badoo.Com"},2031644:{category_id:31,name:"AWeber Systems"},2031645:{category_id:31,name:"SourceForge"},2031646:{category_id:31,name:"SlideShare"},2031647:{category_id:31,name:"Mozilla"},2031648:{category_id:31,name:"Wikia"},2031649:{category_id:31,name:"Google AdSense"},2031650:{category_id:31,name:"Fiverr"},2031651:{category_id:31,name:"Photobucket image hosting and photo sharing"},2031652:{category_id:31,name:"Clicksor"},2031653:{category_id:31,name:"HootSuite Social Media Dashboard"},2031654:{category_id:31,name:"1-Click Answers"},2031655:{category_id:31,name:"StatCounter"},2031656:{category_id:31,name:"CNET Download"},2031657:{category_id:31,name:"Rediff"},2031658:{category_id:31,name:"My Yahoo"},2031659:{category_id:31,name:"The Internet Archive"},2031660:{category_id:31,name:"isoHunt"},2031661:{category_id:31,name:"DomainTools"},2031662:{category_id:31,name:"CNET"},2031663:{category_id:31,name:"GitHub.com"},2031664:{category_id:31,name:"Host Gator"},2031665:{category_id:31,name:"PHP"},2031666:{category_id:31,name:"GMX"},2031667:{category_id:31,name:"Microsoft Developer Network"},2031668:{category_id:31,name:"ImageShack"},2031669:{category_id:31,name:"Dell Inc."},2031670:{category_id:31,name:"Microsoft Office Online"},2031671:{category_id:31,name:"Mashable"},2031672:{category_id:31,name:"Digital Point Solutions"},2031673:{category_id:31,name:"Digital Point Forums"},2031674:{category_id:31,name:"Mail Chimp"},2031675:{category_id:31,name:"Joomla!"},2031676:{category_id:31,name:"TypePad"},2031677:{category_id:31,name:"SEOmoz.org"},2031678:{category_id:31,name:"Google Groups"},2031679:{category_id:31,name:"Webs"},2031680:{category_id:31,name:"Speedtest.net"},2097153:{category_id:32,name:"IGN"},2097154:{category_id:32,name:"Publishers Clearing House"},2097155:{category_id:32,name:"MiniClip"},2097156:{category_id:32,name:"888"},2097157:{category_id:32,name:"Xbox"},2097158:{category_id:32,name:"GameSpot"},2097159:{category_id:32,name:"Steam"},2097160:{category_id:32,name:"League of Legends"},2097161:{category_id:32,name:"GameFAQs"},2097162:{category_id:32,name:"Yahoo! Games"},2097163:{category_id:32,name:"William Hill Online"},2097164:{category_id:32,name:"Electronic Arts"},2097165:{category_id:32,name:"Betfair"},2097166:{category_id:32,name:"Wowhead"},2097167:{category_id:32,name:"World of PlayStation"},2097168:{category_id:32,name:"Kongregate"},2097169:{category_id:32,name:"Hattrick"},2097170:{category_id:32,name:"Roblox"},2097171:{category_id:32,name:"King"},2097172:{category_id:32,name:"Chess"},2097173:{category_id:32,name:"Ubi Soft Entertainment"},2097174:{category_id:32,name:"Minepedia"},2097175:{category_id:32,name:"Call of Duty"},2097176:{category_id:32,name:"Addictinggames"},2097177:{category_id:32,name:"MMO-Champion"},2097178:{category_id:32,name:"Bet at Home"},2097179:{category_id:32,name:"FreeLotto"},2097180:{category_id:32,name:"Square Enix"},2097181:{category_id:32,name:"PlayStation"},2097182:{category_id:32,name:"Travian"},2097183:{category_id:32,name:"MSN Gaming Zone"},2097184:{category_id:32,name:"Games"},2097185:{category_id:32,name:"Rockstar Games"},2097186:{category_id:32,name:"N4G"},2097187:{category_id:32,name:"Planet Minecraft"},2097188:{category_id:32,name:"Nvidia"},2097189:{category_id:32,name:"FreeOnlineGames"},2097190:{category_id:32,name:"Nintendo of America"},2097191:{category_id:32,name:"PopCap Games"},2097192:{category_id:32,name:"Game Trailers"},2097193:{category_id:32,name:"Covers"},2097194:{category_id:32,name:"California Lottery"},2097195:{category_id:32,name:"Team Liquid"},2097196:{category_id:32,name:"Eurogamer.net"},2097197:{category_id:32,name:"Party Casino"},2097198:{category_id:32,name:"Game Informer"},2097199:{category_id:32,name:"Penny Arcade"},2097200:{category_id:32,name:"GiantBomb"},2097201:{category_id:32,name:"GameHouse"},2097202:{category_id:32,name:"Curse"},2097203:{category_id:32,name:"Star Wars"},2097204:{category_id:32,name:"PC Gamer Online"},2097205:{category_id:32,name:"BoardGameGeek"},2097206:{category_id:32,name:"Bet365 Affiliates"},2097207:{category_id:32,name:"Bulbagarden / Bulbapedia"},2097208:{category_id:32,name:"OGame.org"},2097209:{category_id:32,name:"Space Federation"},2097210:{category_id:32,name:"Hasbro"},2097211:{category_id:32,name:"Enjin"},2097212:{category_id:32,name:"Perfect World Entertainment"},2097213:{category_id:32,name:"Ladbrokes"},2097214:{category_id:32,name:"Florida Lottery"},2097215:{category_id:32,name:"Paddy Power"},2097216:{category_id:32,name:"Shockwave"},2097217:{category_id:32,name:"Virtua Fighter 4"},2097218:{category_id:32,name:"Cheat Code Central"},2097219:{category_id:32,name:"Bukkit"},2097220:{category_id:32,name:"Oddschecker"},2097221:{category_id:32,name:"Xbox Media Center"},2097222:{category_id:32,name:"BioWare"},2097223:{category_id:32,name:"WoWWiki"},2097224:{category_id:32,name:"Games Radar US"},2097225:{category_id:32,name:"G4 TV"},2097226:{category_id:32,name:"JigZone"},2097227:{category_id:32,name:"Two Plus Two Publishing"},2097228:{category_id:32,name:"Win Every Game"},2097229:{category_id:32,name:"Zylom"},2097230:{category_id:32,name:"Station"},2097231:{category_id:32,name:"Blizzard.com"},2097232:{category_id:32,name:"Super Cheats"},2097233:{category_id:32,name:"TheSims3"},2097234:{category_id:32,name:"Computer and Video Games"},2097235:{category_id:32,name:"Xbox 360 Achievements"},2097236:{category_id:32,name:"Soccer Manager"},2097237:{category_id:32,name:"FreeGamePick"},2097238:{category_id:32,name:"Battlefield Play4Free"},2097239:{category_id:32,name:"The Trivia Portal"},2097240:{category_id:32,name:"VG247"},2097241:{category_id:32,name:"Affiliates United"},2097242:{category_id:32,name:"Stardock"},2097243:{category_id:32,name:"Gearbox Software"},2097244:{category_id:32,name:"sporcle"},2097245:{category_id:32,name:"Gamasutra"},2097246:{category_id:32,name:"Poker News"},2097247:{category_id:32,name:"Nexon America Inc."},21:{category_id:0,name:"Lava-Lava"},2162689:{category_id:33,name:"National Institutes of Health (NIH)"},2162690:{category_id:33,name:"WebMD"},2162691:{category_id:33,name:"PubMed"},2162692:{category_id:33,name:"MayoClinic"},2162693:{category_id:33,name:"Medicine Net"},2162694:{category_id:33,name:"Natural Health Information Articles and Health Newsletter by Dr. Joseph Mercola"},2162695:{category_id:33,name:"Drugs"},2162696:{category_id:33,name:"Mens Health"},2162697:{category_id:33,name:"MedlinePlus"},2162698:{category_id:33,name:"WeightWatchers"},2162699:{category_id:33,name:"Centers for Disease Control and Prevention"},2162700:{category_id:33,name:"Psychology Today"},2162701:{category_id:33,name:"Calorie Count"},2162702:{category_id:33,name:"AIDS Patent Database"},2162703:{category_id:33,name:"Dr. Batras"},2162704:{category_id:33,name:"Medscape"},2162705:{category_id:33,name:"nhs.uk"},2162706:{category_id:33,name:"Kaiser Permanente"},2162707:{category_id:33,name:"who.int"},2162708:{category_id:33,name:"Health Boards"},2162709:{category_id:33,name:"Health Media Ventures"},2162710:{category_id:33,name:"KidsHealth"},2162711:{category_id:33,name:"Food and Drug Administration"},2162712:{category_id:33,name:"Self Magazine"},2162713:{category_id:33,name:"Makeup Alley"},2162714:{category_id:33,name:"HealthCentral"},2162715:{category_id:33,name:"Prevention Magazine"},2162716:{category_id:33,name:"RealAge"},2162717:{category_id:33,name:"NetDoctor"},2162718:{category_id:33,name:"FEMA"},2162719:{category_id:33,name:"Fitness Magazine"},2162720:{category_id:33,name:"Vitals"},2162721:{category_id:33,name:"Total Beauty"},2162722:{category_id:33,name:"RxList"},2162723:{category_id:33,name:"British Medical Journal"},2162724:{category_id:33,name:"Steve Pavlina"},2162725:{category_id:33,name:"American Psychological Association"},2162726:{category_id:33,name:"MedcoHealth"},2162727:{category_id:33,name:"eMedTV Health Information"},2162728:{category_id:33,name:"American Cancer Society"},2162729:{category_id:33,name:"Self Nutrition Data"},2162730:{category_id:33,name:"Nuance Communications"},2162731:{category_id:33,name:"Tehran University of Medical Sciences"},2162732:{category_id:33,name:"Weil Lifestyle"},2162733:{category_id:33,name:"Wellness"},2162734:{category_id:33,name:"PatientUK"},2162735:{category_id:33,name:"National Cancer Institute"},2162736:{category_id:33,name:"24 Hour Fitness"},2162737:{category_id:33,name:"San Diego State University Graduate School of Public Health"},2162738:{category_id:33,name:"Telegraph Health"},2162739:{category_id:33,name:"Earth Clinic"},2162740:{category_id:33,name:"Mens Fitness"},2162741:{category_id:33,name:"Anthony Robbins"},2162742:{category_id:33,name:"Health Guru"},2162743:{category_id:33,name:"Cleveland Clinic"},2162744:{category_id:33,name:"BioMed Central"},2162745:{category_id:33,name:"Become Gorgeous"},2162746:{category_id:33,name:"The Student Doctor Network"},2162747:{category_id:33,name:"The New England Journal of Medicine"},2162748:{category_id:33,name:"American Diabetes Association"},2162749:{category_id:33,name:"Spine Health"},2162750:{category_id:33,name:"Social Anxiety Support"},2162751:{category_id:33,name:"Institute for Integrative Nutrition"},2162752:{category_id:33,name:"The Penis Exercise Forum"},2162753:{category_id:33,name:"3 Fat Chicks on a Diet!"},2162754:{category_id:33,name:"NaturallyCurly"},2162755:{category_id:33,name:"Allnurses"},2162756:{category_id:33,name:"Cure Zone"},2162757:{category_id:33,name:"DocCheck"},2162758:{category_id:33,name:"menshealth.co.uk"},2162759:{category_id:33,name:"Occupational Safety &amp; Health Administration"},2162760:{category_id:33,name:"Planned Parenthood Federation of America"},2162761:{category_id:33,name:"DrRobertRey"},2162762:{category_id:33,name:"Sutter Health"},2162763:{category_id:33,name:"My Home Remedies"},2162764:{category_id:33,name:"Lab Tests Online"},2162765:{category_id:33,name:"American Academy of Family Physicians"},2162766:{category_id:33,name:"American Medical Association"},2162767:{category_id:33,name:"Shiraz University of Medical Sciences"},2162768:{category_id:33,name:"PetMD"},2162769:{category_id:33,name:"Health and Safety Executive"},2162770:{category_id:33,name:"SCORE Counselors to Americas Small Business"},2162771:{category_id:33,name:"Laboratory Corporation of America"},2162772:{category_id:33,name:"Alzheimer s Association"},2162773:{category_id:33,name:"Isfahan University of Medical Sciences"},2162774:{category_id:33,name:"National Institute of Diabetes and Digestive and Kidney Diseases"},2162775:{category_id:33,name:"Celiac Disease and Gluten-Free Diet Support Center"},2162776:{category_id:33,name:"Best Health"},2162777:{category_id:33,name:"Hairfinder Hair Fashion Portal"},2162778:{category_id:33,name:"Medical News Daily"},2162779:{category_id:33,name:"UKhairdressers"},22:{category_id:0,name:"PaltalkScene"},2228225:{category_id:34,name:"eHow"},2228226:{category_id:34,name:"Yelp"},2228227:{category_id:34,name:"Groupon"},2228228:{category_id:34,name:"Engadget"},2228229:{category_id:34,name:"GSM Arena"},2228230:{category_id:34,name:"Allrecipes"},2228231:{category_id:34,name:"RetailMeNot"},2228232:{category_id:34,name:"CNET Reviews"},2228233:{category_id:34,name:"Coupons"},2228234:{category_id:34,name:"Gizmodo"},2228235:{category_id:34,name:"BabyCenter"},2228236:{category_id:34,name:"Yahoo! Shopping"},2228237:{category_id:34,name:"Nextag"},2228238:{category_id:34,name:"Toms Hardware Guide"},2228239:{category_id:34,name:"Yahoo Autos"},2228240:{category_id:34,name:"Digital Photography Review"},2228241:{category_id:34,name:"FixYa"},2228242:{category_id:34,name:"Instructables"},2228243:{category_id:34,name:"The Verge"},2228244:{category_id:34,name:"Shopping"},2228245:{category_id:34,name:"Better Business Bureau"},2228246:{category_id:34,name:"FatWallet"},2228247:{category_id:34,name:"CafeMom"},2228248:{category_id:34,name:"Internal Revenue Service"},2228249:{category_id:34,name:"The Motley Fool"},2228250:{category_id:34,name:"Edmunds"},2228251:{category_id:34,name:"bankrate"},2228252:{category_id:34,name:"Martha Stewart Living Omnimedia"},2228253:{category_id:34,name:"mobile9"},2228254:{category_id:34,name:"Kelley Blue Book"},2228255:{category_id:34,name:"Better Homes &amp; Gardens"},2228256:{category_id:34,name:"Consumer Reports Online"},2228257:{category_id:34,name:"Phone Arena"},2228258:{category_id:34,name:"Real Simple"},2228259:{category_id:34,name:"Apartment Therapy"},2228260:{category_id:34,name:"PriceGrabber"},2228261:{category_id:34,name:"Shopzilla"},2228262:{category_id:34,name:"Bureau of Consular Affairs"},2228263:{category_id:34,name:"Cooks"},2228264:{category_id:34,name:"Epinions"},2228265:{category_id:34,name:"bradsdeals"},2228266:{category_id:34,name:"MouthShut"},2228267:{category_id:34,name:"Blu-ray"},2228268:{category_id:34,name:"Epicurious"},2228269:{category_id:34,name:"Digital Trends"},2228270:{category_id:34,name:"Betty Crocker"},2228271:{category_id:34,name:"OpenDNS"},2228272:{category_id:34,name:"AOL Autos"},2228273:{category_id:34,name:"GardenWeb"},2228274:{category_id:34,name:"Ciao"},2228275:{category_id:34,name:"BGR"},2228276:{category_id:34,name:"Motor Trend Online"},2228277:{category_id:34,name:"Simply Recipes"},2228278:{category_id:34,name:"Rip-off Report"},2228279:{category_id:34,name:"Broadband Reports"},2228280:{category_id:34,name:"Kraft Foods Recipes"},2228281:{category_id:34,name:"Military"},2228282:{category_id:34,name:"Kaboodle"},2228283:{category_id:34,name:"DIY Network"},2228284:{category_id:34,name:"Apartment Therapys The Kitchn"},2228285:{category_id:34,name:"Parents"},2228286:{category_id:34,name:"The Pillsbury Company"},2228287:{category_id:34,name:"Care"},2228288:{category_id:34,name:"Ubergizmo"},2228289:{category_id:34,name:"EatingWell"},2228290:{category_id:34,name:"AVForums"},2228291:{category_id:34,name:"Cooking Light"},2228292:{category_id:34,name:"lifehack.org"},2228293:{category_id:34,name:"Carfax"},2228294:{category_id:34,name:"Social Security Administration"},2228295:{category_id:34,name:"Forums for the Chaotic Home"},2228296:{category_id:34,name:"This Old House Online"},2228297:{category_id:34,name:"ReviewCentre"},2228298:{category_id:34,name:"Kiplinger"},2228299:{category_id:34,name:"Coupon Mom"},2228300:{category_id:34,name:"Food &amp; Wine Online"},2228301:{category_id:34,name:"Jamie Oliver"},2228302:{category_id:34,name:"ConsumerSearch"},2228303:{category_id:34,name:"Geekologie"},2228304:{category_id:34,name:"Photography on the Net"},2228305:{category_id:34,name:"Medicare"},2228306:{category_id:34,name:"GasBuddy Organization Inc."},2228307:{category_id:34,name:"Complaints Board"},2228308:{category_id:34,name:"Good Housekeeping"},2228309:{category_id:34,name:"Pampers"},2228310:{category_id:34,name:"Southern Living Online"},2228311:{category_id:34,name:"Become"},2228312:{category_id:34,name:"Moms Who Think"},2228313:{category_id:34,name:"Mothering Magazine"},2228314:{category_id:34,name:"Think Baby Names"},2293761:{category_id:35,name:"Thesaurus"},2293762:{category_id:35,name:"Weebly"},2293763:{category_id:35,name:"ESPN Cricinfo"},2293764:{category_id:35,name:"Y8"},2293765:{category_id:35,name:"Universal Currency Converter"},2293766:{category_id:35,name:"Time and Date"},2293767:{category_id:35,name:"How Stuff Works"},2293768:{category_id:35,name:"Soccernet"},2293769:{category_id:35,name:"Reverso"},2293770:{category_id:35,name:"Stardoll"},2293771:{category_id:35,name:"000webhost"},2293772:{category_id:35,name:"Uefa"},2293773:{category_id:35,name:"The Toronto Star"},2293774:{category_id:35,name:"FIFA.com"},2293775:{category_id:35,name:"Girls Go Games"},2293776:{category_id:35,name:"Dynamic Drive DHTML Code Library"},2293777:{category_id:35,name:"Bureau of Meteorology"},2293778:{category_id:35,name:"ScienceDaily"},2293779:{category_id:35,name:"Manchester United Football Club"},2293780:{category_id:35,name:"Khan Academy"},2293781:{category_id:35,name:"Earthquake Information"},2293782:{category_id:35,name:"Barbie"},2293783:{category_id:35,name:"National Post"},2293784:{category_id:35,name:"WebDeveloper"},2293785:{category_id:35,name:"Starfall"},2293786:{category_id:35,name:"The Irish Times"},2293787:{category_id:35,name:"AOL Weather"},2293788:{category_id:35,name:"History Channel"},2293789:{category_id:35,name:"Honda Motor Co."},2293790:{category_id:35,name:"Space"},2293791:{category_id:35,name:"The Dilbert Zone"},2293792:{category_id:35,name:"Free Website Builder"},2293793:{category_id:35,name:"Warner Bros. Online"},2293794:{category_id:35,name:"Neopets"},2293795:{category_id:35,name:"USA.gov"},2293796:{category_id:35,name:"US Courts"},2293797:{category_id:35,name:"Popular Science"},2293798:{category_id:35,name:"Webopedia"},2293799:{category_id:35,name:"The Student Room"},2293800:{category_id:35,name:"Gaia Interactive"},2293801:{category_id:35,name:"Encyclopaedia Britannica Online"},2293802:{category_id:35,name:"New Scientist"},2293803:{category_id:35,name:"HTML Goodies"},2293804:{category_id:35,name:"Biography"},2293805:{category_id:35,name:"Maths Is Fun"},2293806:{category_id:35,name:"Archives"},2293807:{category_id:35,name:"Jet Propulsion Laboratory"},2293808:{category_id:35,name:"CBS.Sports"},2293809:{category_id:35,name:"Physics Forums"},2293810:{category_id:35,name:"National Portal of India"},2293811:{category_id:35,name:"ThinkQuest"},2293812:{category_id:35,name:"SpongeBob SquarePants at Nick"},2293813:{category_id:35,name:"Animal Planet Channel Online"},2293814:{category_id:35,name:"Funbrain"},2293815:{category_id:35,name:"StarWars"},2293816:{category_id:35,name:"Enchanted Learning"},2293817:{category_id:35,name:"GameSpy"},2293818:{category_id:35,name:"Spelling City"},2293819:{category_id:35,name:"Pokemon"},2293820:{category_id:35,name:"The Holy See"},2293821:{category_id:35,name:"Fupa Games"},2293822:{category_id:35,name:"Gameloft"},23:{category_id:0,name:"UcTalk"},2359297:{category_id:36,name:"Yahoo News"},2359298:{category_id:36,name:"The Huffington Post"},2359299:{category_id:36,name:"New York Times"},2359300:{category_id:36,name:"Google News"},2359301:{category_id:36,name:"Reddit"},2359302:{category_id:36,name:"The Guardian"},2359303:{category_id:36,name:"The Times of India"},2359304:{category_id:36,name:"Washington Post"},2359305:{category_id:36,name:"Drudge Report"},2359306:{category_id:36,name:"USA Today"},2359307:{category_id:36,name:"Examiner"},2359308:{category_id:36,name:"AccuWeather"},2359309:{category_id:36,name:"Los Angeles Times"},2359310:{category_id:36,name:"Time Magazine"},2359311:{category_id:36,name:"Weather Underground"},2359312:{category_id:36,name:"News.au"},2359313:{category_id:36,name:"The Sydney Morning Herald"},2359314:{category_id:36,name:"Yahoo Weather"},2359315:{category_id:36,name:"Al Arabiya News Channel"},2359316:{category_id:36,name:"Breitbart"},2359317:{category_id:36,name:"San Francisco Chronicle"},2359318:{category_id:36,name:"National Geographic"},2359319:{category_id:36,name:"HindustanTimes"},2359320:{category_id:36,name:"NewsMax"},2359321:{category_id:36,name:"Topix"},2359322:{category_id:36,name:"Chicago Tribune"},2359323:{category_id:36,name:"Houston Chronicle"},2359324:{category_id:36,name:"PRWeb"},2359325:{category_id:36,name:"The Globe and Mail"},2359326:{category_id:36,name:"The Age"},2359327:{category_id:36,name:"Christian Science Monitor"},2359328:{category_id:36,name:"New Jersey Online"},2359329:{category_id:36,name:"WorldNetDaily"},2359330:{category_id:36,name:"Navbharat Times"},2359331:{category_id:36,name:"Washington Times"},2359332:{category_id:36,name:"Eenadu"},2359333:{category_id:36,name:"The Associated Press"},2359334:{category_id:36,name:"Digital Spy"},2359335:{category_id:36,name:"bdnews24"},2359336:{category_id:36,name:"U.S. News &amp; World Report"},2359337:{category_id:36,name:"Yr.no"},2359338:{category_id:36,name:"The Onion"},2359339:{category_id:36,name:"Metafilter"},2359340:{category_id:36,name:"Sky News"},2359341:{category_id:36,name:"The Hill"},2359342:{category_id:36,name:"The Examiner"},2359343:{category_id:36,name:"Philly"},2359344:{category_id:36,name:"The Indian Express"},2359345:{category_id:36,name:"National Review Online"},2359346:{category_id:36,name:"DNA"},2359347:{category_id:36,name:"Malayala Manorama"},2359348:{category_id:36,name:"DailyFinance"},2359349:{category_id:36,name:"France 24"},2359350:{category_id:36,name:"Fark"},2359351:{category_id:36,name:"Intellicast"},2359352:{category_id:36,name:"NewsNow"},2359353:{category_id:36,name:"The Denver Post"},2359354:{category_id:36,name:"PR Newswire"},2359355:{category_id:36,name:"Chicago Sun-Times"},2359356:{category_id:36,name:"The Atlanta Journal-Constitution"},2359357:{category_id:36,name:"Herald Sun"},2359358:{category_id:36,name:"The Australian"},2359359:{category_id:36,name:"The Arizona Republic"},2359360:{category_id:36,name:"Detroit Free Press"},2359361:{category_id:36,name:"Mathrubhumi Daily"},2359362:{category_id:36,name:"San Jose Mercury News"},2359363:{category_id:36,name:"Newsday"},2359364:{category_id:36,name:"Vancouver Province"},2359365:{category_id:36,name:"Star Tribune"},24:{category_id:0,name:"WinpopupX"},2424833:{category_id:37,name:"Booking"},2424834:{category_id:37,name:"TripAdvisor"},2424835:{category_id:37,name:"9Gag"},2424836:{category_id:37,name:"Agoda"},2424837:{category_id:37,name:"Expedia"},2424838:{category_id:37,name:"Southwest"},2424839:{category_id:37,name:"Priceline"},2424840:{category_id:37,name:"CRACKED"},2424841:{category_id:37,name:"Kayak"},2424842:{category_id:37,name:"United Airlines"},2424843:{category_id:37,name:"Delta Air Lines"},2424844:{category_id:37,name:"American Airlines"},2424845:{category_id:37,name:"Lonely Planet"},2424846:{category_id:37,name:"Orbitz"},2424847:{category_id:37,name:"Travelocity"},2424848:{category_id:37,name:"Marriott International"},2424849:{category_id:37,name:"Ryanair"},2424850:{category_id:37,name:"Hilton"},2424851:{category_id:37,name:"EasyJet"},2424852:{category_id:37,name:"Yahoo! Travel"},2424853:{category_id:37,name:"Autoblog"},2424854:{category_id:37,name:"CouchSurfing"},2424855:{category_id:37,name:"British Airways"},2424856:{category_id:37,name:"Hotwire"},2424857:{category_id:37,name:"Emirates"},2424858:{category_id:37,name:"Lufthansa"},2424859:{category_id:37,name:"CollegeHumor"},2424860:{category_id:37,name:"Travelzoo"},2424861:{category_id:37,name:"Japan Airlines"},2424862:{category_id:37,name:"Ford Motor Company"},2424863:{category_id:37,name:"Open Table"},2424864:{category_id:37,name:"Wikitravel"},2424865:{category_id:37,name:"Time Out"},2424866:{category_id:37,name:"Metropolitan Transportation Authority"},2424867:{category_id:37,name:"US Airways"},2424868:{category_id:37,name:"Vacation Rentals by Owner"},2424869:{category_id:37,name:"LanChile"},2424870:{category_id:37,name:"KLM Royal Dutch Airlines"},2424871:{category_id:37,name:"Petfinder"},2424872:{category_id:37,name:"Accorhotels"},2424873:{category_id:37,name:"Library of Congress"},2424874:{category_id:37,name:"Venere"},2424875:{category_id:37,name:"SkyScanner"},2424876:{category_id:37,name:"Hyatt Hotels and Resorts"},2424877:{category_id:37,name:"Geocaching"},2424878:{category_id:37,name:"Aero Berlin"},2424879:{category_id:37,name:"Virgin Atlantic Airlines"},2424880:{category_id:37,name:"Airliners.net"
},2424881:{category_id:37,name:"HomeAway Vacation Rentals Worldwide"},2424882:{category_id:37,name:"Jalopnik"},2424883:{category_id:37,name:"Turkish Airlines"},2424884:{category_id:37,name:"NetCarShow"},2424885:{category_id:37,name:"Qatar Airways"},2424886:{category_id:37,name:"Hostelworld"},2424887:{category_id:37,name:"The Straight Dope by Cecil Adams"},2424888:{category_id:37,name:"Flightradar24"},2424889:{category_id:37,name:"HRS Hotel Reservation Service"},2424890:{category_id:37,name:"Hostelbookers"},2424891:{category_id:37,name:"Qantas Airways"},2424892:{category_id:37,name:"Alaska Airlines"},2424893:{category_id:37,name:"Restaurant"},2424894:{category_id:37,name:"Car and Driver"},2424895:{category_id:37,name:"VirtualTourist"},2424896:{category_id:37,name:"Air Canada"},2424897:{category_id:37,name:"Expedia.ca"},2424898:{category_id:37,name:"Volvo Car Corporation"},2424899:{category_id:37,name:"Late Rooms"},2424900:{category_id:37,name:"Intercontinental Hotels Group"},2424901:{category_id:37,name:"Saudi Arabian Airlines"},2424902:{category_id:37,name:"Top Gear"},2424903:{category_id:37,name:"Porsche"},2424904:{category_id:37,name:"Crave Online"},2424905:{category_id:37,name:"Cathay Pacific Airways"},2424906:{category_id:37,name:"Cebu Pacific Air"},2424907:{category_id:37,name:"Iberia"},2424908:{category_id:37,name:"Cheap Tickets"},2424909:{category_id:37,name:"Florida Department of Transportation"},2424910:{category_id:37,name:"Cheap Flights"},2424911:{category_id:37,name:"AR15"},2424912:{category_id:37,name:"Frommers"},2424913:{category_id:37,name:"Fodors Travel Online"},2424914:{category_id:37,name:"AirTran Airways"},2424915:{category_id:37,name:"Popular Mechanics"},2424916:{category_id:37,name:"AeroMexico"},2424917:{category_id:37,name:"Carnival Cruise Lines"},2424918:{category_id:37,name:"Honda Cars"},2424919:{category_id:37,name:"Aeroflot"},2424920:{category_id:37,name:"Travel and Leisure Magazine"},2490369:{category_id:38,name:"Yahoo! Answers"},2490370:{category_id:38,name:"WikiAnswers"},2490371:{category_id:38,name:"WordReference"},2490372:{category_id:38,name:"The Free Dictionary"},2490373:{category_id:38,name:"Goodreads"},2490374:{category_id:38,name:"LEO English-German Dictionary"},2490375:{category_id:38,name:"World Wide Web Consortium"},2490376:{category_id:38,name:"MapQuest"},2490377:{category_id:38,name:"YELLOWPAGES"},2490378:{category_id:38,name:"Dict.cc"},2490379:{category_id:38,name:"WhitePages"},2490380:{category_id:38,name:"Blackboard"},2490381:{category_id:38,name:"Massachusetts Institute of Technology"},2490382:{category_id:38,name:"Stanford University"},2490383:{category_id:38,name:"JustAnswer"},2490384:{category_id:38,name:"BrainyQuote"},2490385:{category_id:38,name:"Harvard University"},2490386:{category_id:38,name:"Investopedia"},2490387:{category_id:38,name:"Lumosity"},2490388:{category_id:38,name:"eCollege"},2490389:{category_id:38,name:"University of California"},2490390:{category_id:38,name:"SuperPages"},2490391:{category_id:38,name:"Sulekha Yellow Pages India"},2490392:{category_id:38,name:"University of Phoenix"},2490393:{category_id:38,name:"MyLife"},2490394:{category_id:38,name:"wiseGEEK"},2490395:{category_id:38,name:"The University of Michigan"},2490396:{category_id:38,name:"Cornell University"},2490397:{category_id:38,name:"The University of Texas at Austin"},2490398:{category_id:38,name:"The Pennsylvania State University"},2490399:{category_id:38,name:"GMT"},2490400:{category_id:38,name:"U. S. Department of Education"},2490401:{category_id:38,name:"Wikiquote"},2490402:{category_id:38,name:"yourDictionary"},2490403:{category_id:38,name:"University of Washington"},2490404:{category_id:38,name:"Cambridge University Press"},2490405:{category_id:38,name:"192"},2490406:{category_id:38,name:"Columbia University"},2490407:{category_id:38,name:"Purdue University"},2490408:{category_id:38,name:"University of Wisconsin-Madison"},2490409:{category_id:38,name:"Elsevier"},2490410:{category_id:38,name:"YellowPages.ca"},2490411:{category_id:38,name:"University of Pennsylvania"},2490412:{category_id:38,name:"Yahoo! Maps and Driving Directions."},2490413:{category_id:38,name:"Spanish Dictionary"},2490414:{category_id:38,name:"The City University of New York (CUNY)"},2490415:{category_id:38,name:"Coursera"},2490416:{category_id:38,name:"Mappy"},2490417:{category_id:38,name:"New York University"},2490418:{category_id:38,name:"Listal"},2490419:{category_id:38,name:"Experts Exchange"},2490420:{category_id:38,name:"Collegeboard.org"},2490421:{category_id:38,name:"University of Tehran"},2490422:{category_id:38,name:"Yale University"},2490423:{category_id:38,name:"ThinkExist"},2490424:{category_id:38,name:"AllExperts Questions &amp; Answers"},2490425:{category_id:38,name:"WorldCat"},2490426:{category_id:38,name:"University of Florida"},2490427:{category_id:38,name:"Princeton University"},2490428:{category_id:38,name:"Shabdkosh"},2490429:{category_id:38,name:"University of Toronto"},2490430:{category_id:38,name:"University of Cambridge"},2490431:{category_id:38,name:"Maps of World"},2490432:{category_id:38,name:"Michigan State University"},2490433:{category_id:38,name:"RateMyProfessors"},2490434:{category_id:38,name:"K12"},2490435:{category_id:38,name:"Cambridge Dictionary"},2490436:{category_id:38,name:"USP"},2490437:{category_id:38,name:"The Open University"},2490438:{category_id:38,name:"Carnegie Mellon University"},2490439:{category_id:38,name:"Educational Testing Service (ETS)"},2490440:{category_id:38,name:"University of Oxford"},2490441:{category_id:38,name:"University of North Carolina at Chapel Hill"},2490442:{category_id:38,name:"University of Southern California"},2490443:{category_id:38,name:"Moodle"},2490444:{category_id:38,name:"Arizona State University"},2490445:{category_id:38,name:"The University of Arizona"},2490446:{category_id:38,name:"University of Virginia"},2490447:{category_id:38,name:"Chronicle of Higher Education"},25:{category_id:0,name:"BeeTalk"},2555905:{category_id:39,name:"Google India"},2555906:{category_id:39,name:"Google UK"},2555907:{category_id:39,name:"Amazon.co.jp"},2555908:{category_id:39,name:"Amazon.co.uk"},2555909:{category_id:39,name:"Google Australia"},2555910:{category_id:39,name:"eBay UK"},2555911:{category_id:39,name:"The Daily Mail"},2555912:{category_id:39,name:"Indiatimes"},2555913:{category_id:39,name:"Wal-Mart Online"},2555914:{category_id:39,name:"Yahoo! India"},2555915:{category_id:39,name:"Best Buy Co."},2555916:{category_id:39,name:"Bet365"},2555917:{category_id:39,name:"CNN"},2555918:{category_id:39,name:"United States Postal Service (USPS)"},2555919:{category_id:39,name:"eBay India"},2555920:{category_id:39,name:"eBay.au"},2555921:{category_id:39,name:"Indian Railway Catering and Tourism Corporation"},2555922:{category_id:39,name:"Yahoo UK and Ireland"},2555923:{category_id:39,name:"POLITICO"},2555924:{category_id:39,name:"Naukri"},2555925:{category_id:39,name:"The Home Depot"},2555926:{category_id:39,name:"Macys"},2555927:{category_id:39,name:"Zhaopin"},2555928:{category_id:39,name:"Road Runner"},2555929:{category_id:39,name:"Kijiji"},2555930:{category_id:39,name:"Yahoo India News Services"},2555931:{category_id:39,name:"Maktoob"},2555932:{category_id:39,name:"RealClear Politics"},2555933:{category_id:39,name:"IBM Corporation"},2555934:{category_id:39,name:"OneIndia.in"},2555935:{category_id:39,name:"National Oceanic and Atmospheric Administration (NOAA)"},2555936:{category_id:39,name:"Government of Canada"},2555937:{category_id:39,name:"Google News India"},2555938:{category_id:39,name:"IBN Live"},2555939:{category_id:39,name:"Toys R Us"},2555940:{category_id:39,name:"MoneyControl"},2555941:{category_id:39,name:"State of California"},2555942:{category_id:39,name:"New York Daily News"},2555943:{category_id:39,name:"Google NewZealand"},2555944:{category_id:39,name:"NHK"},2555945:{category_id:39,name:"MSN UK"},2555946:{category_id:39,name:"Official Major League Baseball"},2555947:{category_id:39,name:"Slate Magazine"},2555948:{category_id:39,name:"Nordstrom"},2555949:{category_id:39,name:"craigslist"},2555950:{category_id:39,name:"Trulia"},26:{category_id:0,name:"Squiggle"},2621441:{category_id:40,name:"Yahoo! Japan"},2621442:{category_id:40,name:"TED"},2621443:{category_id:40,name:"ScienceDirect"},2621444:{category_id:40,name:"United States Geological Survey (USGS)"},2621445:{category_id:40,name:"Care2"},2621446:{category_id:40,name:"Nature"},2621447:{category_id:40,name:"Japan Meteorological Agency"},2621448:{category_id:40,name:"IEEE"},2621449:{category_id:40,name:"U.S. Department of Agriculture"},262145:{category_id:4,name:"Windows Media Player"},2621450:{category_id:40,name:"JSTOR"},2621451:{category_id:40,name:"RedOrbit"},2621452:{category_id:40,name:"Scientific American"},2621453:{category_id:40,name:"Foreign Policy"},2621454:{category_id:40,name:"LiveScience"},2621455:{category_id:40,name:"National Park Service"},2621456:{category_id:40,name:"Mother Nature Network"},2621457:{category_id:40,name:"US Census Bureau"},2621458:{category_id:40,name:"Bureau of Labor Statistics"},2621459:{category_id:40,name:"Met Office"},262146:{category_id:4,name:"RealPlayer"},2621460:{category_id:40,name:"Environmental Protection Agency"},2621461:{category_id:40,name:"Technology Review"},2621462:{category_id:40,name:"National Geographic News"},2621463:{category_id:40,name:"University of Colorado at Boulder"},2621464:{category_id:40,name:"Wolfram Research"},2621465:{category_id:40,name:"Metric Conversions"},2621466:{category_id:40,name:"Head-Fi"},2621467:{category_id:40,name:"Online Conversion"},2621468:{category_id:40,name:"American Chemical Society"},2621469:{category_id:40,name:"ResearchGATE"},262147:{category_id:4,name:"Winamp"},2621470:{category_id:40,name:"Food and Agriculture Organization (FAO)"},2621471:{category_id:40,name:"Science Magazine"},2621472:{category_id:40,name:"The MathWorks"},2621473:{category_id:40,name:"Azteca Systems Cityworks"},2621474:{category_id:40,name:"arXiv.org e-Print Archive"},2621475:{category_id:40,name:"Gramota.ru"},2621476:{category_id:40,name:"Hydrometeorological Prediction Center"},2621477:{category_id:40,name:"Discover Magazine"},2621478:{category_id:40,name:"italki"},2621479:{category_id:40,name:"arabic keyboard"},262148:{category_id:4,name:"QuickTime"},2621480:{category_id:40,name:"Coolmath"},2621481:{category_id:40,name:"Alldatasheet"},2621482:{category_id:40,name:"Nikon Corporation (Global)"},2621483:{category_id:40,name:"GeoNames"},2621484:{category_id:40,name:"Connexor Parsers"},2621485:{category_id:40,name:"National Institute for Statistics and Economic Studies"},2621486:{category_id:40,name:"Indian Institute of Technology"},2621487:{category_id:40,name:"NIST. National Institute of Standards and Technology"},2621488:{category_id:40,name:"Social Science Research Network"},2621489:{category_id:40,name:"Behind the Name"},262149:{category_id:4,name:"Weather Channel"},2621490:{category_id:40,name:"SpaceWeather"},2621491:{category_id:40,name:"LyngSat"},2621492:{category_id:40,name:"Botanical"},2621493:{category_id:40,name:"Grist Magazine"},2621494:{category_id:40,name:"Blue Letter Bible"},2621495:{category_id:40,name:"European Southern Observatory (ESO)"},2621496:{category_id:40,name:"ScienceBlogs"},2621497:{category_id:40,name:"Iranian Seismological Center"},2621498:{category_id:40,name:"EurekAlert!"},2621499:{category_id:40,name:"IBGE"},262150:{category_id:4,name:"PPTV (PPLive)"},2621500:{category_id:40,name:"Environmental Graffiti"},2621501:{category_id:40,name:"University of Missouri"},2621502:{category_id:40,name:"About Psychology"},2621503:{category_id:40,name:"MathWorld"},262151:{category_id:4,name:"QQLive"},262152:{category_id:4,name:"LOVEFiLM"},262153:{category_id:4,name:"ITV"},262154:{category_id:4,name:"iTunes"},262155:{category_id:4,name:"Adobe Flash"},262156:{category_id:4,name:"Channel 5"},262157:{category_id:4,name:"iQIYI/PPS"},262158:{category_id:4,name:"Headweb"},262159:{category_id:4,name:"Viaplay"},262160:{category_id:4,name:"KKBox"},262161:{category_id:4,name:"WATCHEVER"},262162:{category_id:4,name:"Maxdome"},262163:{category_id:4,name:"Twitch.tv"},262164:{category_id:4,name:"TED"},262165:{category_id:4,name:"RTP"},262166:{category_id:4,name:"SBS"},262167:{category_id:4,name:"UUSee"},262168:{category_id:4,name:"SopCast"},262169:{category_id:4,name:"KeyHoleTV"},262170:{category_id:4,name:"Sina Video"},262171:{category_id:4,name:"Metacafe"},262172:{category_id:4,name:"Wuaki.tv"},262173:{category_id:4,name:"SHOUTcast"},262174:{category_id:4,name:"BBC-iplayer"},262175:{category_id:4,name:"Live365"},262176:{category_id:4,name:"Dailymotion"},262177:{category_id:4,name:"Filmin"},262178:{category_id:4,name:"Flixster"},262179:{category_id:4,name:"Hulu"},262181:{category_id:4,name:"NUBEOX"},262182:{category_id:4,name:"Kugou"},262183:{category_id:4,name:"MoveNetworks"},262184:{category_id:4,name:"Babelgum"},262185:{category_id:4,name:"Livestation"},262186:{category_id:4,name:"iTunes Radio"},262187:{category_id:4,name:"Miro"},262188:{category_id:4,name:"Smithsonian Channel"},262189:{category_id:4,name:"NHL"},262190:{category_id:4,name:"NicoNicoDouga"},262191:{category_id:4,name:"Ooyala"},262192:{category_id:4,name:"Photobucket"},262193:{category_id:4,name:"MLSsoccer"},262194:{category_id:4,name:"Channel 4"},262195:{category_id:4,name:"VideoDetective"},262196:{category_id:4,name:"Ustream.tv"},262197:{category_id:4,name:"Veetle"},262198:{category_id:4,name:"VeohTV"},262199:{category_id:4,name:"iTunes Festival"},262200:{category_id:4,name:"SiriusXM"},262201:{category_id:4,name:"Break.com"},262202:{category_id:4,name:"CinemaNow"},262203:{category_id:4,name:"Letv"},262204:{category_id:4,name:"RTSP"},262205:{category_id:4,name:"Funshion"},262207:{category_id:4,name:"MTV.com"},262208:{category_id:4,name:"Sohu TV"},262209:{category_id:4,name:"MP4"},262210:{category_id:4,name:"MMS/WMSP"},262211:{category_id:4,name:"FLV"},262212:{category_id:4,name:"PIPI"},262213:{category_id:4,name:"Hulkshare"},262214:{category_id:4,name:"Tudou"},262215:{category_id:4,name:"Ifeng Video "},262216:{category_id:4,name:"WSJ Live"},262217:{category_id:4,name:"Cradio"},262218:{category_id:4,name:"Roku"},262219:{category_id:4,name:"Amazon Prime Music"},262220:{category_id:4,name:"Crackle"},262221:{category_id:4,name:"Blip.tv"},262223:{category_id:4,name:"Audible"},262224:{category_id:4,name:"Web Streaming"},262226:{category_id:4,name:"Vyclone"},262227:{category_id:4,name:"China Streaming Video"},262228:{category_id:4,name:"Crunchyroll"},262229:{category_id:4,name:"EmpFlix"},262230:{category_id:4,name:"Porn.com"},262231:{category_id:4,name:"EskimoTube"},262232:{category_id:4,name:"NewBigTube"},262233:{category_id:4,name:"Madbitties"},262234:{category_id:4,name:"RTMP"},262235:{category_id:4,name:"Hustlertube"},262236:{category_id:4,name:"TnaFlix"},262237:{category_id:4,name:"Xtube"},262238:{category_id:4,name:"Yobt.tv"},262239:{category_id:4,name:"Youjizz"},262245:{category_id:4,name:"Pandora"},262246:{category_id:4,name:"Deezer"},262247:{category_id:4,name:"VLC"},262250:{category_id:4,name:"Livesearch.tv/CoolStreaming"},262251:{category_id:4,name:"Qello"},262252:{category_id:4,name:"CNTV"},262254:{category_id:4,name:"Thunderkankan"},262256:{category_id:4,name:"Youtube"},262258:{category_id:4,name:"56.com"},262259:{category_id:4,name:"RMVB"},262260:{category_id:4,name:"Youku.com"},262261:{category_id:4,name:"SWF"},262262:{category_id:4,name:"AVI"},262263:{category_id:4,name:"MP3"},262264:{category_id:4,name:"WMA"},262265:{category_id:4,name:"MOV"},262266:{category_id:4,name:"WMV"},262267:{category_id:4,name:"ASF"},262268:{category_id:4,name:"Vudu"},262270:{category_id:4,name:"PBS Video"},262271:{category_id:4,name:"Freecast"},262272:{category_id:4,name:"Ku6"},262274:{category_id:4,name:"Spotify"},262275:{category_id:4,name:"LastFM"},262276:{category_id:4,name:"Netflix"},262277:{category_id:4,name:"Uitzendinggemist"},262278:{category_id:4,name:"RTL.nl"},262279:{category_id:4,name:"TudouVa"},262280:{category_id:4,name:"GYAO"},262281:{category_id:4,name:"BARKS"},262283:{category_id:4,name:"Baofeng"},262284:{category_id:4,name:"Qvod/Bobohu"},262285:{category_id:4,name:"Grooveshark"},262286:{category_id:4,name:"Microsoft Silverlight"},262287:{category_id:4,name:"6.cn"},262288:{category_id:4,name:"Rhapsody"},262290:{category_id:4,name:"Imgo TV"},262291:{category_id:4,name:"Joy.cn"},262292:{category_id:4,name:"Yinyuetai"},262293:{category_id:4,name:"Hichannel"},262294:{category_id:4,name:"ADNstream"},262295:{category_id:4,name:"Livestream"},262296:{category_id:4,name:"YoukuVa "},262298:{category_id:4,name:"Voddler"},262301:{category_id:4,name:"Flixwagon"},262302:{category_id:4,name:"M4V"},262303:{category_id:4,name:"Podcast"},262305:{category_id:4,name:"Shazam"},262306:{category_id:4,name:"TuneIn"},262308:{category_id:4,name:"BaiduMusic"},262310:{category_id:4,name:"DoubanFM"},262311:{category_id:4,name:"IMDb.com"},262312:{category_id:4,name:"XVideos.com"},262313:{category_id:4,name:"xHamster.com"},262314:{category_id:4,name:"PornHub.com"},262315:{category_id:4,name:"LiveJasmin.com"},262316:{category_id:4,name:"XNXX.com"},262317:{category_id:4,name:"YouPorn.com"},262318:{category_id:4,name:"MajorLeagueGaming"},262319:{category_id:4,name:"Wowtv.co.kr"},262320:{category_id:4,name:"iMBC"},262321:{category_id:4,name:"AfreecaTV"},262322:{category_id:4,name:"Arirang"},262323:{category_id:4,name:"KCTVjeju"},262324:{category_id:4,name:"CJB.co.kr"},262325:{category_id:4,name:"MBN"},262326:{category_id:4,name:"MYSolive"},262327:{category_id:4,name:"KBS"},262328:{category_id:4,name:"Mwave"},262329:{category_id:4,name:"YTN"},262330:{category_id:4,name:"Musicsoda"},262331:{category_id:4,name:"FreeOnes.com"},262332:{category_id:4,name:"Streamate.com"},262333:{category_id:4,name:"Airplay"},262334:{category_id:4,name:"DAAP"},262335:{category_id:4,name:"M1905"},262336:{category_id:4,name:"VEVO"},262337:{category_id:4,name:"Amazon Instant Video"},262338:{category_id:4,name:"MixBit"},262339:{category_id:4,name:"Baomihua"},262340:{category_id:4,name:"FORA.tv"},262341:{category_id:4,name:"Vimeo"},262342:{category_id:4,name:"Vube"},262343:{category_id:4,name:"RedTube.com"},262344:{category_id:4,name:"Tube8"},262345:{category_id:4,name:"Mgoon"},262346:{category_id:4,name:"Trailers"},262347:{category_id:4,name:"HBOGO"},262348:{category_id:4,name:"MLB.com"},262349:{category_id:4,name:"Kaltura.com"},2686977:{category_id:41,name:"eBay"},2686978:{category_id:41,name:"IKEA"},2686979:{category_id:41,name:"NewEgg"},2686980:{category_id:41,name:"Multiply"},2686981:{category_id:41,name:"Gap"},2686982:{category_id:41,name:"LivingSocial"},2686983:{category_id:41,name:"Kohls"},2686984:{category_id:41,name:"Zappos"},2686985:{category_id:41,name:"BodyBuilding"},2686986:{category_id:41,name:"Overstock"},2686987:{category_id:41,name:"Barnes and Noble"},2686988:{category_id:41,name:"Lowes"},2686989:{category_id:41,name:"JCPenney"},2686990:{category_id:41,name:"Shutterfly"},2686991:{category_id:41,name:"QVC"},2686992:{category_id:41,name:"Legacy"},2686993:{category_id:41,name:"Staples"},2686994:{category_id:41,name:"Nike"},2686995:{category_id:41,name:"B&H Photo Video"},2686996:{category_id:41,name:"Ticketmaster USA"},2686997:{category_id:41,name:"Walgreens"},2686998:{category_id:41,name:"TigerDirect"},2686999:{category_id:41,name:"Victorias Secret"},2687000:{category_id:41,name:"Pixmania"},2687001:{category_id:41,name:"GameStop"},2687002:{category_id:41,name:"Buy"},2687003:{category_id:41,name:"Trade Me"},2687004:{category_id:41,name:"AutoTrader"},2687005:{category_id:41,name:"Home Shopping Network"},2687006:{category_id:41,name:"Sams Club"},2687007:{category_id:41,name:"Bed"},2687008:{category_id:41,name:"CafePress"},2687009:{category_id:41,name:"Souq"},2687010:{category_id:41,name:"6pm"},2687011:{category_id:41,name:"CVS/pharmacy Online CVS"},2687012:{category_id:41,name:"cars"},2687013:{category_id:41,name:"Sephora"},2687014:{category_id:41,name:"Cabelas"},2687015:{category_id:41,name:"Forever 21"},2687016:{category_id:41,name:"Lands End"},2687017:{category_id:41,name:"John Wiley and Sons"},2687018:{category_id:41,name:"Play"},2687019:{category_id:41,name:"Drugstore"},2687020:{category_id:41,name:"Blockbuster"},2687021:{category_id:41,name:"M and S Gifts"},2687022:{category_id:41,name:"Neiman Marcus"},2687023:{category_id:41,name:"Office Depot"},2687024:{category_id:41,name:"CD Universe"},2687025:{category_id:41,name:"Shopbop"},2687026:{category_id:41,name:"Recreational Equipment Incorporated"},2687027:{category_id:41,name:"StubHub"},2687028:{category_id:41,name:"JCrew"},2687029:{category_id:41,name:"NET-A-PORTER.COM"},2687030:{category_id:41,name:"iHerb"},2687031:{category_id:41,name:"Frys"},2687032:{category_id:41,name:"Focalprice"},2687033:{category_id:41,name:"L.L.Bean"},2687034:{category_id:41,name:"Saks Fifth Avenue"},2687035:{category_id:41,name:"Bloomingdales"},2687036:{category_id:41,name:"Vitacost"},2687037:{category_id:41,name:"Yoox"},2687038:{category_id:41,name:"Pottery Barn"},2687039:{category_id:41,name:"Urban Outfitters"},2687040:{category_id:41,name:"American Eagle Outfitters"},2687041:{category_id:41,name:"Disney Store"},2687042:{category_id:41,name:"Scholastic Corporation"},2687043:{category_id:41,name:"Sierra Trading Post"},2687044:{category_id:41,name:"Redbubble"},2687045:{category_id:41,name:"ModCloth Indie Clothing"},2687046:{category_id:41,name:"Future Shop"},2687047:{category_id:41,name:"Musicians Friend"},2687048:{category_id:41,name:"Advanced Book Exchange"},2687049:{category_id:41,name:"Joann"},2687050:{category_id:41,name:"GameFly"},2687051:{category_id:41,name:"Dicks Sporting Goods"},2687052:{category_id:41,name:"Harbor Freight"},2687053:{category_id:41,name:"Ralph Lauren"},2687054:{category_id:41,name:"OfficeMax"},2687055:{category_id:41,name:"Snapfish"},2687056:{category_id:41,name:"PetSmart"},2752513:{category_id:42,name:"SiteAdvisor"},2752514:{category_id:42,name:"Yahoo! Shine"},2752515:{category_id:42,name:"Match"},2752516:{category_id:42,name:"Ancestry"},2752517:{category_id:42,name:"Digg"},2752518:{category_id:42,name:"Sulekha"},2752519:{category_id:42,name:"Europa"},2752520:{category_id:42,name:"U.S. Department of State"},2752521:{category_id:42,name:"Bible Gateway"},2752522:{category_id:42,name:"Correios"},2752523:{category_id:42,name:"Wonder Wall"},2752524:{category_id:42,name:"Japan Post Service Co."},2752525:{category_id:42,name:"Change.org"},2752526:{category_id:42,name:"The Weekly Standard"},2752527:{category_id:42,name:"European Commission"},2752528:{category_id:42,name:"Daily Kos"},2752529:{category_id:42,name:"Infowars"},2752530:{category_id:42,name:"SheKnows"},2752531:{category_id:42,name:"President Barack H. Obama"},2752532:{category_id:42,name:"Ask Men"},2752533:{category_id:42,name:"Slashdot"},2752534:{category_id:42,name:"Townhall"},2752535:{category_id:42,name:"Royal Mail"},2752536:{category_id:42,name:"Snopes"},2752537:{category_id:42,name:"AARP"},2752538:{category_id:42,name:"Church of Jesus Christ of Latter-day Saints"},2752539:{category_id:42,name:"Just Jared"},2752540:{category_id:42,name:"Complex"},2752541:{category_id:42,name:"Gallup"},2752542:{category_id:42,name:"The Register"},2752543:{category_id:42,name:"Official Resources Web Site"},2752544:{category_id:42,name:"Creative Commons"},2752545:{category_id:42,name:"NewsBusters.org"},2752546:{category_id:42,name:"The Jerusalem Post"},2752547:{category_id:42,name:"Immigration and Naturalization Service (Employment)"},2752548:{category_id:42,name:"Deutsche Post"},2752549:{category_id:42,name:"Department of Veterans Affairs"},2752550:{category_id:42,name:"DateHookup"},2752551:{category_id:42,name:"Avaaz"},2752552:{category_id:42,name:"The Animal Rescue Site"},2752553:{category_id:42,name:"PeopleSmart"},2752554:{category_id:42,name:"United Nations"},2752555:{category_id:42,name:"Free Republic"},2752556:{category_id:42,name:"Canada Post / Postes Canada"},2752557:{category_id:42,name:"MoveOn.org"},2752558:{category_id:42,name:"Astrodienst"},2752559:{category_id:42,name:"The Christian Post"},2752560:{category_id:42,name:"The Superficial"},2752561:{category_id:42,name:"La Poste"},2752562:{category_id:42,name:"Made Man"},2752563:{category_id:42,name:"Find A Grave"},2752564:{category_id:42,name:"Answerbag"},2752565:{category_id:42,name:"FamilySearch"},2752566:{category_id:42,name:"RootsWeb"},2752567:{category_id:42,name:"American Red Cross"},2752568:{category_id:42,name:"IMDb"},2752569:{category_id:42,name:"Online Parallel Bible"},2752570:{category_id:42,name:"Above Top Secret"},2752571:{category_id:42,name:"Companies House"},2752572:{category_id:42,name:"CaringBridge"},2752573:{category_id:42,name:"The World Bank Group"},2752574:{category_id:42,name:"Christian Book Distributors"},2752575:{category_id:42,name:"The Knot"},2752576:{category_id:42,name:"Australia Post"},2752577:{category_id:42,name:"Expat Blog"},2752578:{category_id:42,name:"Islamic Finder"},2752579:{category_id:42,name:"Central Bank of the Islamic Republic of Iran"},2752580:{category_id:42,name:"Treehugger"},2752581:{category_id:42,name:"David Icke"},2752582:{category_id:42,name:"Cosmopolitan"},2752583:{category_id:42,name:"Securities and Exchange Commission (SEC)"},2752584:{category_id:42,name:"FindLaw"},2752585:{category_id:42,name:"LewRockwell"},2752586:{category_id:42,name:"Esquire"},2752587:{category_id:42,name:"Avvo"},2752588:{category_id:42,name:"Foreign and Commonwealth Office"},2752589:{category_id:42,name:"GoodSearch"},2752590:{category_id:42,name:"Horoscope"},2752591:{category_id:42,name:"GQ"},28:{category_id:0,name:"Pidgin"},2818049:{category_id:43,name:"Yahoo Sports"},2818050:{category_id:43,name:"NFL.COM"},2818051:{category_id:43,name:"NBA"},2818052:{category_id:43,name:"LiveScore"},2818053:{category_id:43,name:"Bleacher Report"},2818054:{category_id:43,name:"Premierleague"},2818055:{category_id:43,name:"SkySports"},2818056:{category_id:43,name:"Fantasy games"},2818057:{category_id:43,name:"British Eurosport"},2818058:{category_id:43,name:"Rivals"},2818059:{category_id:43,name:"Formula1"},2818060:{category_id:43,name:"Scout"},2818061:{category_id:43,name:"ATPworldtour"},2818062:{category_id:43,name:"Rotoworld"},2818063:{category_id:43,name:"Sporting News"},2818064:{category_id:43,name:"NASCAR Online"},2818065:{category_id:43,name:"SB Nation"},2818066:{category_id:43,name:"FlashScore"},2818067:{category_id:43,name:"Yardbarker"},2818068:{category_id:43,name:"Deadspin"},2818069:{category_id:43,name:"The Sports Network"},2818070:{category_id:43,name:"Arsenal"},2818071:{category_id:43,name:"Liverpool Football Club"},2818072:{category_id:43,name:"Pro Football Talk"},2818073:{category_id:43,name:"NHL.com"},2818074:{category_id:43,name:"My Fantasy League"},2818075:{category_id:43,name:"ESPN Star Sports"},2818076:{category_id:43,name:"FootyTube"},2818077:{category_id:43,name:"Cricbuzz"},2818078:{category_id:43,name:"FilGoal"},2818079:{category_id:43,name:"FC Barcelona"},2818080:{category_id:43,name:"Sporting Life"},2818081:{category_id:43,name:"MaxPreps"},2818082:{category_id:43,name:"Chelsea Football Club"},2818083:{category_id:43,name:"autosport"},2818084:{category_id:43,name:"Sherdog"},2818085:{category_id:43,name:"Surfline"},2818086:{category_id:43,name:"Ultimate Fighting Championship"},2818087:{category_id:43,name:"Runners World Online"},2818088:{category_id:43,name:"Racing Post"},2818089:{category_id:43,name:"MSNBC Sports"},2818090:{category_id:43,name:"101 Great Goals"},2818091:{category_id:43,name:"Cyclingnews"},2818092:{category_id:43,name:"The Hong Kong Jockey Club"},2818093:{category_id:43,name:"Real Madrid"},2818094:{category_id:43,name:"XScores"},2818095:{category_id:43,name:"PGA Tour"},2818096:{category_id:43,name:"TEAMtalk "},2818097:{category_id:43,name:"Football365"},2818098:{category_id:43,name:"Real GM"},2818099:{category_id:43,name:"RealTime Fantasy Sports"},2818100:{category_id:43,name:"Eurosport"},2818101:{category_id:43,name:"MLB Trade Rumors"},2818102:{category_id:43,name:"Baseball Reference"},29:{category_id:0,name:"ISPQ"},3:{category_id:0,name:"AIM/ICQ/iIM"},31:{category_id:0,name:"ChatON(M)"},32:{category_id:0,name:"Caihong"},327681:{category_id:5,name:"SMTP"},327682:{category_id:5,name:"POP3"},327683:{category_id:5,name:"IMAP4"},327684:{category_id:5,name:"NNTP"},327685:{category_id:5,name:"Twig"},327686:{category_id:5,name:"GroupWise"},327687:{category_id:5,name:"au one net"},327689:{category_id:5,name:"PChome"},327690:{category_id:5,name:"DTI MyMail"},327691:{category_id:5,name:"Ymail"},327692:{category_id:5,name:"IIJ MailViewer"},327693:{category_id:5,name:"Telenet Mail"},327694:{category_id:5,name:"Open Mail"},327695:{category_id:5,name:"InfoSphere Webmail"},327696:{category_id:5,name:"Goo Mail"},327697:{category_id:5,name:"Nifty"},327698:{category_id:5,name:"QQ Mail"},327699:{category_id:5,name:"Roundcubemail"},327700:{category_id:5,name:"Zenno"},327701:{category_id:5,name:"Itm-asp"},327702:{category_id:5,name:"Biglobe"},327703:{category_id:5,name:"SquirrelMail"},327704:{category_id:5,name:"Zoho Mail"},327705:{category_id:5,name:"Inter7"},327706:{category_id:5,name:"TOK2"},327707:{category_id:5,name:"Smoug"},327708:{category_id:5,name:"1und1"},327709:{category_id:5,name:"Plala"},327710:{category_id:5,name:"WAKWAK"},327711:{category_id:5,name:"Eyejot"},327712:{category_id:5,name:"AsahiNet"},327713:{category_id:5,name:"Aikq"},327714:{category_id:5,name:"Yandex"},327715:{category_id:5,name:"Arcor"},327716:{category_id:5,name:"Bluewin"},327717:{category_id:5,name:"Directbox"},327718:{category_id:5,name:"Freenet"},327720:{category_id:5,name:"Smart Mail"},327722:{category_id:5,name:"WEB.DE"},327723:{category_id:5,name:"MS Exchange Server"},327732:{category_id:5,name:"Webmail.de"},327742:{category_id:5,name:"NETEASE Mail"},327743:{category_id:5,name:"Gmx Mail"},327744:{category_id:5,name:"Excite"},327745:{category_id:5,name:"InfoSeek Mail"},327746:{category_id:5,name:"Livedoor"},327747:{category_id:5,name:"Nate Mail"},327749:{category_id:5,name:"Optimum"},327751:{category_id:5,name:"Secureserver"},327753:{category_id:5,name:"Sina Mail"},327755:{category_id:5,name:"Rambler"},327760:{category_id:5,name:"Daum Mail"},327761:{category_id:5,name:"Mail.com"},327762:{category_id:5,name:"OCN"},327763:{category_id:5,name:"MailChimp"},327764:{category_id:5,name:"Rediff Mail"},327770:{category_id:5,name:"Korea Mail"},327774:{category_id:5,name:"Hotmail"},327775:{category_id:5,name:"Gmail"},327776:{category_id:5,name:"AOL Mail"},327778:{category_id:5,name:"COX"},327779:{category_id:5,name:"Hushmail"},327780:{category_id:5,name:"Mail.ru"},327781:{category_id:5,name:"HiNet Mail"},327782:{category_id:5,name:"Horde"},327783:{category_id:5,name:"Fastmail"},327784:{category_id:5,name:"Comcast"},327785:{category_id:5,name:"Laposte"},327786:{category_id:5,name:"Yahoo Mail"},327787:{category_id:5,name:"Usermin Mail"},327788:{category_id:5,name:"Tistory"},327789:{category_id:5,name:"Orange"},327790:{category_id:5,name:"012mail"},327791:{category_id:5,name:"T-Online"},327792:{category_id:5,name:"Jubii Mail"},327793:{category_id:5,name:"Whalemail"},327794:{category_id:5,name:"Lavabit"},327795:{category_id:5,name:"Tiscali"},33:{category_id:0,name:"KC"},34:{category_id:0,name:"IMVU"},35:{category_id:0,name:"Instan-t"},36:{category_id:0,name:"PiIM"},37:{category_id:0,name:"Xfire"},38:{category_id:0,name:"Raidcall"},393217:{category_id:6,name:"Skype"},393218:{category_id:6,name:"H.323"},393220:{category_id:6,name:"Facetime"},393221:{category_id:6,name:"Juiker"},393222:{category_id:6,name:"Sqwiggle"},393223:{category_id:6,name:"ooVoo"},393225:{category_id:6,name:"TeamSpeak"},393226:{category_id:6,name:"Ventrilo"},393228:{category_id:6,name:"SIP"},393229:{category_id:6,name:"NetMeeting"},393230:{category_id:6,name:"Inter-Asterisk"},393231:{category_id:6,name:"Net2Phone"},393232:{category_id:6,
name:"MSRP"},393234:{category_id:6,name:"LINE(M)"},393235:{category_id:6,name:"Fring(M)"},393236:{category_id:6,name:"Goober"},393238:{category_id:6,name:"Viber(M)"},393239:{category_id:6,name:"Kakao(M)"},393240:{category_id:6,name:"iCall"},393242:{category_id:6,name:"Nimbuzz"},393243:{category_id:6,name:"Bobsled(M)"},393244:{category_id:6,name:"indoona"},393246:{category_id:6,name:"Tango(M)"},393247:{category_id:6,name:"Ooma"},4:{category_id:0,name:"QQ/TM"},41:{category_id:0,name:"WhatsApp(M)"},42:{category_id:0,name:"Userplane"},43:{category_id:0,name:"24im"},44:{category_id:0,name:"Camfrog"},458753:{category_id:7,name:"MSSQL"},458754:{category_id:7,name:"MySQL"},458755:{category_id:7,name:"Oracle"},458756:{category_id:7,name:"PostgreSQL"},458757:{category_id:7,name:"SAP"},458760:{category_id:7,name:"Etelos"},458761:{category_id:7,name:"Centriccrm"},458763:{category_id:7,name:"FileMaker"},458766:{category_id:7,name:"MongoDB"},458767:{category_id:7,name:"Salesforce"},458768:{category_id:7,name:"MariaDB"},46:{category_id:0,name:"Digsby"},49:{category_id:0,name:"Message Send Protocol"},5:{category_id:0,name:"Laiwang(M)"},524289:{category_id:8,name:"QQ Game"},524290:{category_id:8,name:"Our Game"},524291:{category_id:8,name:"Cga.com"},524292:{category_id:8,name:"FIFA"},524293:{category_id:8,name:"PopKart"},524294:{category_id:8,name:"Archlord"},524295:{category_id:8,name:"AddictingGames.com"},524296:{category_id:8,name:"Realgame"},524297:{category_id:8,name:"Audition"},524298:{category_id:8,name:"Koramgame"},524299:{category_id:8,name:"BnB Game"},524300:{category_id:8,name:"Chinagame"},524301:{category_id:8,name:"CS Game"},524302:{category_id:8,name:"Diablo"},524303:{category_id:8,name:"Legend"},524304:{category_id:8,name:"Lineage"},524306:{category_id:8,name:"Quake Game"},524307:{category_id:8,name:"Diablo3"},524308:{category_id:8,name:"Sina Web Game"},524310:{category_id:8,name:"WOW Game"},524311:{category_id:8,name:"Ispeakgame"},524312:{category_id:8,name:"Torchlight2"},524313:{category_id:8,name:"MapleStory"},524314:{category_id:8,name:"TowerOfSaviors(M)"},524315:{category_id:8,name:"Wolfenstein"},524316:{category_id:8,name:"Second Life"},524317:{category_id:8,name:"Kimi"},524318:{category_id:8,name:"Doof Game"},524319:{category_id:8,name:"PartyPoker"},524320:{category_id:8,name:"Pogo"},524321:{category_id:8,name:"PokerStars"},524322:{category_id:8,name:"Zango"},524323:{category_id:8,name:"Little Fighter 2"},524324:{category_id:8,name:"BomberClone"},524326:{category_id:8,name:"FSJOY"},524327:{category_id:8,name:"175pt"},524328:{category_id:8,name:"Zhuxian"},524329:{category_id:8,name:"GameTea/GameABC"},524330:{category_id:8,name:"Talesrunner"},524331:{category_id:8,name:"PK Game"},524332:{category_id:8,name:"Concerto Gate"},524333:{category_id:8,name:"TLBB"},524334:{category_id:8,name:"YBOnline"},524335:{category_id:8,name:"Xunyou"},524336:{category_id:8,name:"Mwo"},524337:{category_id:8,name:"ZF.91"},524338:{category_id:8,name:"WuLin"},524339:{category_id:8,name:"DNF Game"},524340:{category_id:8,name:"Bo Game"},524341:{category_id:8,name:"Gran Turismo"},524343:{category_id:8,name:"Electronic Arts"},524344:{category_id:8,name:"ZhengTu"},524345:{category_id:8,name:"SGOL"},524346:{category_id:8,name:"XY2Online"},524347:{category_id:8,name:"Asherons Call"},524348:{category_id:8,name:"Kali"},524349:{category_id:8,name:"EverQuest"},524350:{category_id:8,name:"XBOX"},524351:{category_id:8,name:"BrettspielWelt"},524352:{category_id:8,name:"Bet-at-Home"},524353:{category_id:8,name:"City of Heroes"},524354:{category_id:8,name:"ClubPenguin"},524355:{category_id:8,name:"StepMania"},524356:{category_id:8,name:"Battle.net"},524358:{category_id:8,name:"Apprentice"},524359:{category_id:8,name:"EA SPORTS"},524360:{category_id:8,name:"FreeLotto Game"},524361:{category_id:8,name:"Halo"},524362:{category_id:8,name:"iSketch"},524363:{category_id:8,name:"RuneScape"},524364:{category_id:8,name:"FUNMILY"},524365:{category_id:8,name:"Yeapgame"},524366:{category_id:8,name:"Grand Theft Auto"},524367:{category_id:8,name:"Lineage2"},524368:{category_id:8,name:"GM99 Game"},524369:{category_id:8,name:"RayCity"},524370:{category_id:8,name:"Rockstar Games"},524371:{category_id:8,name:"Aleph One"},524372:{category_id:8,name:"Wayi"},524373:{category_id:8,name:"CMWEBGAME"},524374:{category_id:8,name:"Call of Duty"},524375:{category_id:8,name:"CAPTAN"},524376:{category_id:8,name:"Supercell(Clash of Clans/Hay Day)"},524377:{category_id:8,name:"Need for Speed"},524379:{category_id:8,name:"Madden NFL"},524380:{category_id:8,name:"Half-Life"},524381:{category_id:8,name:"Team Fortress"},524383:{category_id:8,name:"Final Fantasy"},524384:{category_id:8,name:"Mythic"},524385:{category_id:8,name:"NetPanzer"},524386:{category_id:8,name:"Sdo.com"},524388:{category_id:8,name:"Pokemon Netbattle"},524389:{category_id:8,name:"RunUO-Ultima"},524390:{category_id:8,name:"Soldat Dedicated"},524391:{category_id:8,name:"Blizzard Entertainment"},524392:{category_id:8,name:"RIFT"},524393:{category_id:8,name:"TetriNET"},524394:{category_id:8,name:"Tibia"},524395:{category_id:8,name:"PlanetSide"},524396:{category_id:8,name:"TripleA"},524398:{category_id:8,name:"Unreal"},524399:{category_id:8,name:"Valve Steam"},524400:{category_id:8,name:"WesNOth"},524401:{category_id:8,name:"Xpilot"},524402:{category_id:8,name:"Swtor"},524403:{category_id:8,name:"EVEOnline"},524404:{category_id:8,name:"Hearthstone"},524405:{category_id:8,name:"Guild Wars"},524406:{category_id:8,name:"Zhong Hua Hero"},524407:{category_id:8,name:"Wizard101"},524408:{category_id:8,name:"SD Gundam"},524409:{category_id:8,name:"Prius"},524410:{category_id:8,name:"Age of Conan"},524411:{category_id:8,name:"RF Returns"},524412:{category_id:8,name:"AION"},524413:{category_id:8,name:"POPO Game"},524414:{category_id:8,name:"War-Rock"},524415:{category_id:8,name:"TEN Game"},524416:{category_id:8,name:"LUNA2"},524417:{category_id:8,name:"Karos"},524418:{category_id:8,name:"SPOnline"},524419:{category_id:8,name:"RO Game"},524420:{category_id:8,name:"StarCraft2"},524421:{category_id:8,name:"Itaiwanmj"},524422:{category_id:8,name:"CMWEBGAME Game"},524423:{category_id:8,name:"Beanfun Game"},524424:{category_id:8,name:"JXW"},524425:{category_id:8,name:"Nobol"},524426:{category_id:8,name:"DragonNest"},524427:{category_id:8,name:"BBonline"},524428:{category_id:8,name:"Hangame"},524429:{category_id:8,name:"Homygame"},524430:{category_id:8,name:"Sony PlayStation"},524431:{category_id:8,name:"Garena"},524432:{category_id:8,name:"91555"},524433:{category_id:8,name:"JJ Game"},524434:{category_id:8,name:"YHgame"},524435:{category_id:8,name:"Mdm365"},524436:{category_id:8,name:"7fgame"},524437:{category_id:8,name:"Dokee"},524438:{category_id:8,name:"VSA"},524439:{category_id:8,name:"Funtown"},524440:{category_id:8,name:"SF Game"},524441:{category_id:8,name:"173kh"},524442:{category_id:8,name:"Boyaapoker"},524443:{category_id:8,name:"GameCenter"},524444:{category_id:8,name:"Minecraft"},524445:{category_id:8,name:"Dark Souls"},524446:{category_id:8,name:"The Secret World"},524447:{category_id:8,name:"World2"},524448:{category_id:8,name:"CrossFire"},524449:{category_id:8,name:"XYQ"},524450:{category_id:8,name:"Nexon"},524451:{category_id:8,name:"Vindictus"},524452:{category_id:8,name:"DotA"},524453:{category_id:8,name:"PAYDAY"},524454:{category_id:8,name:"Wayi Game"},524455:{category_id:8,name:"War Thunder"},524456:{category_id:8,name:"Warframe"},524457:{category_id:8,name:"TT-Play Game"},524458:{category_id:8,name:"TT-Play"},524459:{category_id:8,name:"Robocraft"},524460:{category_id:8,name:"World of Tanks"},524461:{category_id:8,name:"Divinity"},524462:{category_id:8,name:"Left 4 Dead 2"},524463:{category_id:8,name:"DayZ"},524466:{category_id:8,name:"TXWY Game"},524479:{category_id:8,name:"Yeapgame Game"},524491:{category_id:8,name:"FUNMILY Game"},524512:{category_id:8,name:"Sony Online Entertainment"},524513:{category_id:8,name:"WSOP(M)"},524514:{category_id:8,name:"TexasHoldemPoker(M)"},524515:{category_id:8,name:"DarkSummoner(M)"},524516:{category_id:8,name:"AjaxPlay"},524517:{category_id:8,name:"AirlineMogul"},524518:{category_id:8,name:"Evony"},524519:{category_id:8,name:"BasketBallZone"},524520:{category_id:8,name:"Y8 Game"},524521:{category_id:8,name:"Y8-Y8"},524522:{category_id:8,name:"KIZI-GAMES"},524523:{category_id:8,name:"Ibibo"},524524:{category_id:8,name:"Hattrick Game"},524525:{category_id:8,name:"Godgame"},524526:{category_id:8,name:"Aswordtw(M)"},524527:{category_id:8,name:"Qme RO(M)"},524529:{category_id:8,name:"THE WORLD(M)"},524530:{category_id:8,name:"Qme JH(M)"},524531:{category_id:8,name:"Qme COS(M)"},524532:{category_id:8,name:"Qme SG(M)"},524533:{category_id:8,name:"Origin"},524534:{category_id:8,name:"LoL"},524535:{category_id:8,name:"THISISGAME"},524536:{category_id:8,name:"Miniclip Game"},524537:{category_id:8,name:"888games"},524538:{category_id:8,name:"WilliamHill"},524539:{category_id:8,name:"Betfair Game"},524540:{category_id:8,name:"Kongregate Game"},524541:{category_id:8,name:"Roblox Game"},524542:{category_id:8,name:"King Game"},524543:{category_id:8,name:"Chess Game"},54:{category_id:0,name:"Fetion"},55:{category_id:0,name:"Heyyo"},56:{category_id:0,name:"Alicall"},57:{category_id:0,name:"Qeshow"},58:{category_id:0,name:"MissLee"},589828:{category_id:9,name:"IGMP"},589829:{category_id:9,name:"SNMP"},589885:{category_id:9,name:"DNS"},589888:{category_id:9,name:"Multicast DNS"},589890:{category_id:9,name:"Finger protocol"},589916:{category_id:9,name:"DCE-RPC"},589933:{category_id:9,name:"SSDP"},589934:{category_id:9,name:"SMB"},589942:{category_id:9,name:"ICMP"},589951:{category_id:9,name:"UPnP"},59:{category_id:0,name:"Jctrans"},6:{category_id:0,name:"IRC"},61:{category_id:0,name:"BaiduHi"},62:{category_id:0,name:"TELTEL"},64:{category_id:0,name:"9158"},65:{category_id:0,name:"Kltx"},655361:{category_id:10,name:"pcAnywhere"},655362:{category_id:10,name:"VNC"},655363:{category_id:10,name:"TeamViewer"},655364:{category_id:10,name:"MS Remote Desktop Protocol (RDP)"},655365:{category_id:10,name:"Chrome Remote Desktop"},655366:{category_id:10,name:"NTRglobal"},655367:{category_id:10,name:"RemoteCall"},655369:{category_id:10,name:"GoToMyPC"},655370:{category_id:10,name:"Pulseway"},655371:{category_id:10,name:"Radmin"},655372:{category_id:10,name:"Beinsync"},655373:{category_id:10,name:"Fastviewer"},655374:{category_id:10,name:"CrossTec Remote Control"},655375:{category_id:10,name:"GoToMeeting"},655376:{category_id:10,name:"ShowMyPC"},655377:{category_id:10,name:"Join.me"},655378:{category_id:10,name:"Telnet"},655379:{category_id:10,name:"Techinline"},65538:{category_id:1,name:"BitTorrent Series"},655380:{category_id:10,name:"ISL Online"},655381:{category_id:10,name:"Secure Shell (SSH)"},655385:{category_id:10,name:"IBM Remote monitoring and Control"},655395:{category_id:10,name:"Netviewer"},655396:{category_id:10,name:"VT100"},655398:{category_id:10,name:"X11"},65540:{category_id:1,name:"DirectConnect"},655402:{category_id:10,name:"Instanthousecall"},655403:{category_id:10,name:"Ammyy"},65542:{category_id:1,name:"eDonkey Series"},65543:{category_id:1,name:"FastTrack"},65544:{category_id:1,name:"Gnutella"},65545:{category_id:1,name:"WinMX"},65546:{category_id:1,name:"Foxy"},65547:{category_id:1,name:"Winny"},65548:{category_id:1,name:"POCO"},65549:{category_id:1,name:"iMesh"},65550:{category_id:1,name:"ClubBox"},65551:{category_id:1,name:"Vagaa"},65552:{category_id:1,name:"Share"},65553:{category_id:1,name:"Thunder Series"},65554:{category_id:1,name:"myMusic"},65555:{category_id:1,name:"QQDownload"},65557:{category_id:1,name:"easyMule"},65559:{category_id:1,name:"Fileguri"},65563:{category_id:1,name:"Soulseek"},65565:{category_id:1,name:"GNUnet"},65566:{category_id:1,name:"XNap"},65568:{category_id:1,name:"Kceasy"},65569:{category_id:1,name:"Aria2"},65570:{category_id:1,name:"Arctic"},65571:{category_id:1,name:"Artemis"},65572:{category_id:1,name:"Bitflu"},65573:{category_id:1,name:"BTG"},65574:{category_id:1,name:"Pando"},65575:{category_id:1,name:"Lphant"},65576:{category_id:1,name:"BitBlinder"},65577:{category_id:1,name:"Deepnet Explorer"},65578:{category_id:1,name:"aMule"},65580:{category_id:1,name:"Ares"},65581:{category_id:1,name:"Azureus"},65582:{category_id:1,name:"BCDC++"},65583:{category_id:1,name:"BitBuddy"},65584:{category_id:1,name:"BitComet"},65585:{category_id:1,name:"BitTornado"},65587:{category_id:1,name:"ApexDC++"},65588:{category_id:1,name:"Bearshare"},65590:{category_id:1,name:"BitLord"},65591:{category_id:1,name:"BitSpirit"},65594:{category_id:1,name:"Shareaza"},65598:{category_id:1,name:"eMule"},65600:{category_id:1,name:"eMule Plus"},65604:{category_id:1,name:"FileScope"},65609:{category_id:1,name:"GoGoBox"},65612:{category_id:1,name:"Hydranode"},65613:{category_id:1,name:"BitTorrent Pro"},65617:{category_id:1,name:"Kazaa Lite Tools K++"},65620:{category_id:1,name:"BitRocket"},65621:{category_id:1,name:"MlDonkey"},65622:{category_id:1,name:"MooPolice"},65630:{category_id:1,name:"Phex"},65633:{category_id:1,name:"RevConnect"},65634:{category_id:1,name:"Rufus"},65635:{category_id:1,name:"SababaDC"},65636:{category_id:1,name:"Shareaza Plus"},65640:{category_id:1,name:"BTSlave"},65642:{category_id:1,name:"TorrentStorm"},65648:{category_id:1,name:"uTorrent"},65652:{category_id:1,name:"ZipTorrent"},65655:{category_id:1,name:"BitPump"},65664:{category_id:1,name:"BBtor"},65665:{category_id:1,name:"Tuotu"},65666:{category_id:1,name:"BitWombat"},65685:{category_id:1,name:"Vuze"},65688:{category_id:1,name:"Bittorrent X"},65689:{category_id:1,name:"DelugeTorrent"},65690:{category_id:1,name:"CTorrent"},65691:{category_id:1,name:"Propagate Data Client"},65692:{category_id:1,name:"EBit"},65693:{category_id:1,name:"Electric Sheep"},65694:{category_id:1,name:"FileCroc"},65695:{category_id:1,name:"FoxTorrent"},65696:{category_id:1,name:"GSTorrent"},65697:{category_id:1,name:"Hekate"},65698:{category_id:1,name:"Halite"},65699:{category_id:1,name:"hMule"},65700:{category_id:1,name:"KGet"},65701:{category_id:1,name:"KTorrent"},65702:{category_id:1,name:"LeechCraft"},65703:{category_id:1,name:"LH-ABC"},65704:{category_id:1,name:"libTorrent"},65705:{category_id:1,name:"LimeWire"},65706:{category_id:1,name:"Meerkat"},65707:{category_id:1,name:"MonoTorrent"},65708:{category_id:1,name:"MoonlightTorrent"},65709:{category_id:1,name:"Net Transport"},65710:{category_id:1,name:"OneSwarm"},65711:{category_id:1,name:"OmegaTorrent"},65712:{category_id:1,name:"Protocol::BitTorrent"},65713:{category_id:1,name:"PHPTracker"},65714:{category_id:1,name:"qBittorrent"},65715:{category_id:1,name:"Qt 4 Torrent example"},65716:{category_id:1,name:"Retriever"},65717:{category_id:1,name:"RezTorrent"},65718:{category_id:1,name:"Swiftbit"},65719:{category_id:1,name:"SoMud"},65720:{category_id:1,name:"SwarmScope"},65721:{category_id:1,name:"SymTorrent"},65722:{category_id:1,name:"Sharktorrent"},65723:{category_id:1,name:"Terasaur Seed Bank"},65724:{category_id:1,name:"TorrentDotNET"},65725:{category_id:1,name:"Transmission"},65726:{category_id:1,name:"uLeecher"},65727:{category_id:1,name:"BitLet"},65728:{category_id:1,name:"FireTorrent"},65729:{category_id:1,name:"XSwifter"},65730:{category_id:1,name:"XanTorrent"},65731:{category_id:1,name:"Xtorrent"},65732:{category_id:1,name:"Pruna"},65733:{category_id:1,name:"Soribada"},65734:{category_id:1,name:"Gample"},65735:{category_id:1,name:"DIYHARD"},65736:{category_id:1,name:"LottoFile"},65737:{category_id:1,name:"ShareBox"},65738:{category_id:1,name:"Bondisk"},65739:{category_id:1,name:"Filei"},65740:{category_id:1,name:"KDISK"},65741:{category_id:1,name:"Ondisk"},65742:{category_id:1,name:"FILEJO"},65743:{category_id:1,name:"FILEDOK"},65744:{category_id:1,name:"Tomatopang/Santa25"},65745:{category_id:1,name:"Webhard"},65746:{category_id:1,name:"TPLE"},65747:{category_id:1,name:"DiskPump"},65748:{category_id:1,name:"NETFOLDER"},65749:{category_id:1,name:"QFILE"},65750:{category_id:1,name:"DISKMAN"},65751:{category_id:1,name:"DBGO"},65752:{category_id:1,name:"Congaltan"},65753:{category_id:1,name:"Diskpot"},65754:{category_id:1,name:"Ipopclub"},65755:{category_id:1,name:"Yesfile"},65756:{category_id:1,name:"Nedisk"},65757:{category_id:1,name:"Me2disk"},65758:{category_id:1,name:"Odisk"},65759:{category_id:1,name:"Tomfile"},65760:{category_id:1,name:"Adrive.co.kr"},65761:{category_id:1,name:"ZIOfile"},65762:{category_id:1,name:"APPLEFILE"},65763:{category_id:1,name:"SUPERDOWN"},65764:{category_id:1,name:"Hidisk"},65765:{category_id:1,name:"Downs"},65766:{category_id:1,name:"DownDay"},65767:{category_id:1,name:"BOMULBOX"},65768:{category_id:1,name:"FILEHAM"},65769:{category_id:1,name:"Tdisk"},65770:{category_id:1,name:"Filehon"},65771:{category_id:1,name:"Jjangfile"},65772:{category_id:1,name:"Onehard.com"},65773:{category_id:1,name:"Pdpop"},65774:{category_id:1,name:"AirFile"},65775:{category_id:1,name:"FILEZZIM"},65776:{category_id:1,name:"Atomfile.co.kr"},65777:{category_id:1,name:"QDOWN.com"},65778:{category_id:1,name:"Alfile.net"},65779:{category_id:1,name:"Bigfile.co.kr"},65780:{category_id:1,name:"Hardmoa.com"},65781:{category_id:1,name:"Redfile.co.kr"},65782:{category_id:1,name:"FILETV.co.kr"},65783:{category_id:1,name:"Now.co.kr"},65784:{category_id:1,name:"JustBeamIt"},65785:{category_id:1,name:"reep.io"},65786:{category_id:1,name:"GnucDNA/Gimme"},65787:{category_id:1,name:"MyNapster"},66:{category_id:0,name:"IM+(M)"},67:{category_id:0,name:"Imi"},68:{category_id:0,name:"Netcall"},69:{category_id:0,name:"ECP"},7:{category_id:0,name:"Yoics"},72:{category_id:0,name:"Etnano"},720898:{category_id:11,name:"VNN"},720899:{category_id:11,name:"Spotflux"},720900:{category_id:11,name:"SoftEther/PacketiX"},720901:{category_id:11,name:"TinyVPN"},720902:{category_id:11,name:"HTTP-Tunnel"},720903:{category_id:11,name:"Tor"},720904:{category_id:11,name:"Ping Tunnel"},720905:{category_id:11,name:"Wujie/UltraSurf"},720906:{category_id:11,name:"Freegate"},720907:{category_id:11,name:"Hidemyass"},720909:{category_id:11,name:"Vedivi"},720910:{category_id:11,name:"ZenMate"},720911:{category_id:11,name:"Hamachi"},720912:{category_id:11,name:"Disconnect.me"},720913:{category_id:11,name:"Psiphon 3"},720914:{category_id:11,name:"Asproxy"},720915:{category_id:11,name:"OpenDoor"},720916:{category_id:11,name:"NSTX DNS Tunnel"},720917:{category_id:11,name:"Coralcdn"},720918:{category_id:11,name:"Glype"},720919:{category_id:11,name:"GPass"},720920:{category_id:11,name:"Kproxy"},720921:{category_id:11,name:"Megaproxy"},720922:{category_id:11,name:"FreeSafeIP"},720925:{category_id:11,name:"Surrogafier"},720926:{category_id:11,name:"Vtunnel"},720928:{category_id:11,name:"BypassThat"},720930:{category_id:11,name:"JAP/JonDo"},720933:{category_id:11,name:"SofaWare"},720946:{category_id:11,name:"Hidedoor"},720948:{category_id:11,name:"CGIProxy"},720950:{category_id:11,name:"Phproxy"},720951:{category_id:11,name:"OpenVPN"},720952:{category_id:11,name:"CCProxy"},720954:{category_id:11,name:"PD-Proxy"},720959:{category_id:11,name:"Rtmpt"},720960:{category_id:11,name:"LogMeIn"},720961:{category_id:11,name:"HotspotShield"},720962:{category_id:11,name:"ExpressVPN"},720963:{category_id:11,name:"GogoNET"},720964:{category_id:11,name:"HTTP Proxy Server"},720966:{category_id:11,name:"Texasproxy"},720967:{category_id:11,name:"Ourproxy"},720969:{category_id:11,name:"Fast Proxy"},720970:{category_id:11,name:"Zalmos"},720971:{category_id:11,name:"Easy Proxy"},720972:{category_id:11,name:"Proxy Era"},720973:{category_id:11,name:"DotVPN"},720974:{category_id:11,name:"BrowSec"},720977:{category_id:11,name:"Air-Proxy"},720979:{category_id:11,name:"Defilter"},720980:{category_id:11,name:"SSLunblock"},720983:{category_id:11,name:"K12History"},720984:{category_id:11,name:"SurfEasy"},720985:{category_id:11,name:"Frozenway"},720986:{category_id:11,name:"CyberGhostVPN"},720987:{category_id:11,name:"SecurityKISS"},720988:{category_id:11,name:"WebWarper"},720989:{category_id:11,name:"Guardster"},720991:{category_id:11,name:"TunnelBear"},720992:{category_id:11,name:"AstrillVPN"},77:{category_id:0,name:"ProvideSupport"},78:{category_id:0,name:"Dudu IM"},786434:{category_id:12,name:"DZH"},786435:{category_id:12,name:"10JQKA"},786437:{category_id:12,name:"Qianlong"},786438:{category_id:12,name:"Compass.cn"},786439:{category_id:12,name:"Huaan"},786440:{category_id:12,name:"StockStar "},786441:{category_id:12,name:"TDX"},786443:{category_id:12,name:"Hexun"},786444:{category_id:12,name:"Hypwise"},786449:{category_id:12,name:"Kiwoom"},786450:{category_id:12,name:"Windin"},786451:{category_id:12,name:"SamsungPoP"},786453:{category_id:12,name:"StockTrace"},786454:{category_id:12,name:"JRJ"},786455:{category_id:12,name:"TradeFields(M)"},786457:{category_id:12,name:"Netdania"},786458:{category_id:12,name:"TradeInterceptor"},8:{category_id:0,name:"Rediff BOL"},80:{category_id:0,name:"Weibo IM"},81:{category_id:0,name:"WO"},82:{category_id:0,name:"Guagua"},83:{category_id:0,name:"Hangouts"},84:{category_id:0,name:"ClubCooee"},85:{category_id:0,name:"Palringo"},851969:{category_id:13,name:"WhiteHat Aviator"},851970:{category_id:13,name:"HTC Widget(M)"},851971:{category_id:13,name:"Doodle"},851972:{category_id:13,name:"Level3"},851973:{category_id:13,name:"FuzeMeeting"},851974:{category_id:13,name:"Mobile01"},851975:{category_id:13,name:"Speedtest.net"},851976:{category_id:13,name:"Google Chrome"},851977:{category_id:13,name:"Babelfish"},851978:{category_id:13,name:"Google-translate"},851980:{category_id:13,name:"Mozilla Firefox"},851981:{category_id:13,name:"Apple Safari"},851982:{category_id:13,name:"Opera browser"},851983:{category_id:13,name:"Google"},851984:{category_id:13,name:"Google-books"},851985:{category_id:13,name:"eBay"},851986:{category_id:13,name:"hao123"},851987:{category_id:13,name:"Soso"},851988:{category_id:13,name:"Tmall"},851989:{category_id:13,name:"PayPal.com"},851990:{category_id:13,name:"Ask.com"},851991:{category_id:13,name:"BBC"},851992:{category_id:13,name:"Alibaba.com"},851993:{category_id:13,name:"CNN.com"},851995:{category_id:13,name:"Sogou.com"},851996:{category_id:13,name:"Evernote"},851997:{category_id:13,name:"About.com"},851998:{category_id:13,name:"Alipay.com"},851999:{category_id:13,name:"Imgur"},852000:{category_id:13,name:"Adcash"},852001:{category_id:13,name:"Huffington Post"},852002:{category_id:13,name:"360buy"},852003:{category_id:13,name:"ESPN"},852004:{category_id:13,name:"Books"},852005:{category_id:13,name:"Craigslist.org"},852006:{category_id:13,name:"Google-analytics"},852007:{category_id:13,name:"Bing Maps"},852008:{category_id:13,name:"ETtoday "},852009:{category_id:13,name:"104 Job Bank"},852010:{category_id:13,name:"NOWnews"},852011:{category_id:13,name:"518 Job Bank"},852012:{category_id:13,name:"Chinatimes.com"},852013:{category_id:13,name:"GOHAPPY"},852014:{category_id:13,name:"591"},852015:{category_id:13,name:"8591"},852016:{category_id:13,name:"Chinatrust"},852017:{category_id:13,name:"Donga.com"},852018:{category_id:13,name:"Gmarket"},852019:{category_id:13,name:"Chosun.com"},852020:{category_id:13,name:"Cafe24.com"},852021:{category_id:13,name:"11st"},852022:{category_id:13,name:"MK.co.kr"},852023:{category_id:13,name:"Auction"},852024:{category_id:13,name:"Hankyung"},852025:{category_id:13,name:"Ppomppu"},852026:{category_id:13,name:"MT.co.kr"},852027:{category_id:13,name:"Zum.com"},852028:{category_id:13,name:"Hankooki"},852029:{category_id:13,name:"JOBKOREA"},852031:{category_id:13,name:"Khan.co.kr"},852032:{category_id:13,name:"Incruit"},852033:{category_id:13,name:"YES24"},852034:{category_id:13,name:"Amazon CloudFront"},852035:{category_id:13,name:"Pcstore"},852036:{category_id:13,name:"Myfreshnet.com"},852037:{category_id:13,name:"Microsoft.com"},852038:{category_id:13,name:"Life.com.tw"},852039:{category_id:13,name:"Libertytimes"},852040:{category_id:13,name:"Lativ"},852041:{category_id:13,name:"Inven"},852042:{category_id:13,name:"cnYES"},852043:{category_id:13,name:"Babyhome"},852044:{category_id:13,name:"8comic.com"},852045:{category_id:13,name:"Ck101.com"},852046:{category_id:13,name:"Taiwanlottery"},852047:{category_id:13,name:"Momoshop"},852048:{category_id:13,name:"Eyny.com"},852049:{category_id:13,name:"Yam.com"},852050:{category_id:13,name:"PChome.com"},852051:{category_id:13,name:"Gamme"},852052:{category_id:13,name:"Apple.com"},852053:{category_id:13,name:"Hinet.net"},852054:{category_id:13,name:"Google-earth"},852055:{category_id:13,name:"Saramin"},852056:{category_id:13,name:"KoreaHerald"},852057:{category_id:13,name:"Plus28.com"},852058:{category_id:13,name:"ChunghwaPost "},852059:{category_id:13,name:"Gomaji "},852060:{category_id:13,name:"NewSen"},852061:{category_id:13,name:"Etnews.com"},852062:{category_id:13,name:"Seoul.co.kr"},852063:{category_id:13,name:"YONHAPNEWS"},852064:{category_id:13,name:"Etoday.co.kr"},852065:{category_id:13,name:"Yesky.com"},852066:{category_id:13,name:"1111 Job Bank"},852067:{category_id:13,name:"Emart"},852068:{category_id:13,name:"KBstar"},852069:{category_id:13,name:"HERALDCORP"},852070:{category_id:13,name:"ActiveX"},852071:{category_id:13,name:"MSN.com"},852072:{category_id:13,name:"Edaily"},852073:{category_id:13,name:"Segye"},852074:{category_id:13,name:"Bobaedream"},852075:{category_id:13,name:"Nocutnews"},852076:{category_id:13,name:"MONETA.co.kr"},852077:{category_id:13,name:"Kukinews"},852078:{category_id:13,name:"Java Applet"},852079:{category_id:13,name:"Todayhumor"},852080:{category_id:13,name:"Inews24"},852081:{category_id:13,name:"KoreaTimes"},852082:{category_id:13,name:"OhmyNews"},852083:{category_id:13,name:"Aladin.co.kr"},852084:{category_id:13,name:"SK Encar"},852085:{category_id:13,name:"eTorrent"},852086:{category_id:13,name:"TVREPORT"},852087:{category_id:13,name:"Mydaily"},852088:{category_id:13,name:"Microsoft Live.com"},852089:{category_id:13,name:"News1.kr"},852090:{category_id:13,name:"Munhwa"},852091:{category_id:13,name:"Dreamwiz"},852092:{category_id:13,name:"Dailian.co.kr"},852093:{category_id:13,name:"Rediff.com"},852094:{category_id:13,name:"Akamai.net"},852097:{category_id:13,name:"Yugma"},852098:{category_id:13,name:"TPB PirateBrowser"},852100:{category_id:13,name:"Wikispaces"},852101:{category_id:13,name:"Wikidot"},852102:{category_id:13,name:"Google-play"},852103:{category_id:13,name:"Wetpaint"},852104:{category_id:13,name:"Windows Store"},852105:{category_id:13,name:"Webshots"},852106:{category_id:13,name:"Kindle Cloud Reader"},852107:{category_id:13,name:"Nice264"},852109:{category_id:13,name:"Vyew"},852110:{category_id:13,name:"TikiWiki"},852111:{category_id:13,name:"Castfire"},852113:{category_id:13,name:"SugarCRM"},852115:{category_id:13,name:"Stumbleupon"},852119:{category_id:13,name:"Spark"},852120:{category_id:13,name:"Socialtext"},852122:{category_id:13,name:"PBworks"},852123:{category_id:13,name:"Fool"},852124:{category_id:13,name:"Showbie"},852125:{category_id:13,name:"MorningStar"},852127:{category_id:13,name:"MoinMoin"},852128:{category_id:13,name:"AppStore"},852129:{category_id:13,name:"Ragingbull"},852130:{category_id:13,name:"Daum"},852131:{category_id:13,name:"Google-docs"},852133:{category_id:13,name:"Naver"},852134:{category_id:13,name:"Editgrid"},852135:{category_id:13,name:"Jaspersoft"},852136:{category_id:13,name:"Clarizen"},852139:{category_id:13,name:"Interpark"},852140:{category_id:13,name:"Hyundaihmall"},852141:{category_id:13,name:"Groupon"},852142:{category_id:13,name:"Gsshop"},852143:{category_id:13,name:"Wemakeprice"},852144:{category_id:13,name:"Lotte.com"},852145:{category_id:13,name:"Coupang"},852147:{category_id:13,name:"Google-alerts"},852149:{category_id:13,name:"Dnshop.com"},852150:{category_id:13,name:"ZoomSpider crawler"},852151:{category_id:13,name:"Win Web Crawler"},852152:{category_id:13,name:"HTTrack crawler"},852153:{category_id:13,name:"Abot crawler"},852154:{category_id:13,name:"Googlebot crawler"},852155:{category_id:13,name:"Microsoft bingbot crawler"},852156:{category_id:13,name:"Yahoo Slurp crawler"},852157:{category_id:13,name:"Beanfun"},852159:{category_id:13,name:"ifeng.com"},852160:{category_id:13,name:"Conduit Mobile"},852162:{category_id:13,name:"Gamebase"},852163:{category_id:13,name:"Kingstone"},852164:{category_id:13,name:"Udn.com"},852166:{category_id:13,name:"Sportsseoul"},852167:{category_id:13,name:"Babylon "},852168:{category_id:13,name:"Yahoo Finance"},852171:{category_id:13,name:"Jira"},852172:{category_id:13,name:"PHPwiki"},852174:{category_id:13,name:"WebCT"},852175:{category_id:13,name:"Youseemore"},852176:{category_id:13,name:"Zwiki-editing"},852177:{category_id:13,name:"Adobe.com"},852178:{category_id:13,name:"Backpackit/Campfire"},852180:{category_id:13,name:"ERoom-net"},852184:{category_id:13,name:"Glide"},852186:{category_id:13,name:"Mediawiki"},852189:{category_id:13,name:"MSN Money"},852190:{category_id:13,name:"HTTP"},852191:{category_id:13,name:"AOL Toolbar"},852193:{category_id:13,name:"Uber"},852194:{category_id:13,name:"Web-crawler"},852195:{category_id:13,name:"RSS"},852196:{category_id:13,name:"WeatherBug"},852197:{category_id:13,name:"Yahoo Toolbar"},852198:{category_id:13,name:"Alexa Toolbar"},852199:{category_id:13,name:"Internet Archive"},852200:{category_id:13,name:"Wikipedia"},852201:{category_id:13,name:"Wiktionary"},852202:{category_id:13,name:"Amazon"},852203:{category_id:13,name:"Google-toolbar"},852204:{category_id:13,name:"Google-maps"},852205:{category_id:13,name:"Zoho"},852206:{category_id:13,name:"Microsoft Internet Explorer"},852207:{category_id:13,name:"Localmind"},852208:{category_id:13,name:"PulseNews"},852209:{category_id:13,name:"BookU(M)"},852210:{category_id:13,name:"Zappos"},852211:{category_id:13,name:"Expedia(M)"},852212:{category_id:13,name:"AdF.ly"},852213:{category_id:13,name:"Baidu"},852214:{category_id:13,name:"Yahoo"},852215:{category_id:13,name:"Taobao"},852216:{category_id:13,name:"163.com"},852217:{category_id:13,name:"Sina.com"},852218:{category_id:13,name:"Bing.com"},852219:{category_id:13,name:"Ruten"},852220:{category_id:13,name:"Shop.com"},852221:{category_id:13,name:"Appledaily"},852222:{category_id:13,name:"CWB"},852223:{category_id:13,name:"CNA"},86:{category_id:0,name:"KikMessenger"},87:{category_id:0,name:"Doshow"},88:{category_id:0,name:"Mibbit"},89:{category_id:0,name:"YY"},9:{category_id:0,name:"Google Talk"},90:{category_id:0,name:"Ispeak"},91:{category_id:0,name:"VzoChat"},917508:{category_id:14,name:"BitDefender"},917509:{category_id:14,name:"360Safe"},917510:{category_id:14,name:"Rising"},917511:{category_id:14,name:"TortoiseSVN"},917513:{category_id:14,name:"Microsoft Windows Update"},917514:{category_id:14,name:"Norton"},917515:{category_id:14,name:"Sophos"},917516:{category_id:14,name:"Yum"},917517:{category_id:14,name:"MIUI"},917518:{category_id:14,name:"Adobe"},917519:{category_id:14,name:"InstallAnyWhere"},917520:{category_id:14,name:"Kaspersky"},917521:{category_id:14,name:"Mcafee"},917522:{category_id:14,name:"TrendMicro"},917523:{category_id:14,name:"F-Secure"},917524:{category_id:14,name:"NOD32"},917525:{category_id:14,name:"Avast"},917526:{category_id:14,name:"Jiangmin"},917527:{category_id:14,name:"Avira"},917528:{category_id:14,name:"Emsisoft"},917529:{category_id:14,name:"Panda"},917530:{category_id:14,name:"AVG"},917531:{category_id:14,name:"PCTools"},917533:{category_id:14,name:"Outpost"},917534:{category_id:14,name:"Spybot"},917535:{category_id:14,name:"Duba"},917536:{category_id:14,name:"Apple"},917538:{category_id:14,name:"Google Update"},917540:{category_id:14,name:"JAVA Update"},917541:{category_id:14,name:"SONY PC Companion"},917542:{category_id:14,name:"SketchUp"},917543:{category_id:14,name:"Webroot"},92:{category_id:0,name:"Trillian"},93:{category_id:0,name:"HipChat"},94:{category_id:0,name:"IntraMessenger"},95:{category_id:0,name:"BitWise"},96:{category_id:0,name:"Barablu"},97:{category_id:0,name:"Whoshere(M)"
},98:{category_id:0,name:"LiiHo(M)"},983043:{category_id:15,name:"eBuddy.com"},983044:{category_id:15,name:"iLoveIM.com"},983047:{category_id:15,name:"imo.im"},983048:{category_id:15,name:"Chikka"},983050:{category_id:15,name:"QQ Web Messenger"},983051:{category_id:15,name:"AOL"},983054:{category_id:15,name:"ICQ Web Messenger"},983057:{category_id:15,name:"AirAim"},983058:{category_id:15,name:"Instan-t Web Messenger"},983065:{category_id:15,name:"TaoBao AliWW"},983069:{category_id:15,name:"Gadu-Gadu Web Messenger"},983070:{category_id:15,name:"Karoo Lark"},983072:{category_id:15,name:"IM+"},99:{category_id:0,name:"Appme(M)"}},categories:{0:{applications:[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,31,32,33,34,35,36,37,38,41,42,43,44,46,49,54,55,56,57,58,59,61,62,64,65,66,67,68,69,72,77,78,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,106,107,108],name:"Instant messaging"},1:{applications:[65538,65540,65542,65543,65544,65545,65546,65547,65548,65549,65550,65551,65552,65553,65554,65555,65557,65559,65563,65565,65566,65568,65569,65570,65571,65572,65573,65574,65575,65576,65577,65578,65580,65581,65582,65583,65584,65585,65587,65588,65590,65591,65594,65598,65600,65604,65609,65612,65613,65617,65620,65621,65622,65630,65633,65634,65635,65636,65640,65642,65648,65652,65655,65664,65665,65666,65685,65688,65689,65690,65691,65692,65693,65694,65695,65696,65697,65698,65699,65700,65701,65702,65703,65704,65705,65706,65707,65708,65709,65710,65711,65712,65713,65714,65715,65716,65717,65718,65719,65720,65721,65722,65723,65724,65725,65726,65727,65728,65729,65730,65731,65732,65733,65734,65735,65736,65737,65738,65739,65740,65741,65742,65743,65744,65745,65746,65747,65748,65749,65750,65751,65752,65753,65754,65755,65756,65757,65758,65759,65760,65761,65762,65763,65764,65765,65766,65767,65768,65769,65770,65771,65772,65773,65774,65775,65776,65777,65778,65779,65780,65781,65782,65783,65784,65785,65786,65787],name:"P2P"},10:{applications:[655361,655362,655363,655364,655365,655366,655367,655369,655370,655371,655372,655373,655374,655375,655376,655377,655378,655379,655380,655381,655385,655395,655396,655398,655402,655403],name:"Remote Access Terminals"},11:{applications:[720898,720899,720900,720901,720902,720903,720904,720905,720906,720907,720909,720910,720911,720912,720913,720914,720915,720916,720917,720918,720919,720920,720921,720922,720925,720926,720928,720930,720933,720946,720948,720950,720951,720952,720954,720959,720960,720961,720962,720963,720964,720966,720967,720969,720970,720971,720972,720973,720974,720977,720979,720980,720983,720984,720985,720986,720987,720988,720989,720991,720992],name:"Bypass Proxies and Tunnels"},12:{applications:[786434,786435,786437,786438,786439,786440,786441,786443,786444,786449,786450,786451,786453,786454,786455,786457,786458],name:"Stock Market"},13:{applications:[851969,851970,851971,851972,851973,851974,851975,851976,851977,851978,851980,851981,851982,851983,851984,851985,851986,851987,851988,851989,851990,851991,851992,851993,851995,851996,851997,851998,851999,852e3,852001,852002,852003,852004,852005,852006,852007,852008,852009,852010,852011,852012,852013,852014,852015,852016,852017,852018,852019,852020,852021,852022,852023,852024,852025,852026,852027,852028,852029,852031,852032,852033,852034,852035,852036,852037,852038,852039,852040,852041,852042,852043,852044,852045,852046,852047,852048,852049,852050,852051,852052,852053,852054,852055,852056,852057,852058,852059,852060,852061,852062,852063,852064,852065,852066,852067,852068,852069,852070,852071,852072,852073,852074,852075,852076,852077,852078,852079,852080,852081,852082,852083,852084,852085,852086,852087,852088,852089,852090,852091,852092,852093,852094,852097,852098,852100,852101,852102,852103,852104,852105,852106,852107,852109,852110,852111,852113,852115,852119,852120,852122,852123,852124,852125,852127,852128,852129,852130,852131,852133,852134,852135,852136,852139,852140,852141,852142,852143,852144,852145,852147,852149,852150,852151,852152,852153,852154,852155,852156,852157,852159,852160,852162,852163,852164,852166,852167,852168,852171,852172,852174,852175,852176,852177,852178,852180,852184,852186,852189,852190,852191,852193,852194,852195,852196,852197,852198,852199,852200,852201,852202,852203,852204,852205,852206,852207,852208,852209,852210,852211,852212,852213,852214,852215,852216,852217,852218,852219,852220,852221,852222,852223],name:"Web / Web 2.0"},14:{applications:[917508,917509,917510,917511,917513,917514,917515,917516,917517,917518,917519,917520,917521,917522,917523,917524,917525,917526,917527,917528,917529,917530,917531,917533,917534,917535,917536,917538,917540,917541,917542,917543],name:"Security Update"},15:{applications:[983043,983044,983047,983048,983050,983051,983054,983057,983058,983065,983069,983070,983072],name:"Web IM"},17:{applications:[1114113,1114114,1114115,1114117,1114118,1114119,1114120,1114121,1114122,1114124,1114125,1114128,1114129,1114130,1114131,1114133,1114134,1114138,1114140,1114141,1114142,1114150,1114151,1114152,1114155,1114158,1114160,1114161,1114167,1114169,1114170,1114176,1114177,1114180,1114182,1114187,1114188,1114191,1114195,1114198,1114201,1114203,1114205,1114206,1114212,1114213,1114222,1114229,1114238,1114239,1114246,1114248,1114250,1114252,1114253,1114255,1114269,1114272,1114273,1114274,1114275,1114277,1114279,1114289,1114290,1114308,1114309,1114310,1114311,1114318,1114320,1114321,1114322,1114330,1114331,1114334,1114335,1114337,1114339,1114340,1114342,1114343,1114347,1114350,1114351,1114352,1114355,1114359,1114361,1114363,1114365],name:"Business"},18:{applications:[1179649,1179650,1179651,1179653,1179654,1179655,1179660,1179665,1179667,1179668,1179669,1179670,1179671,1179672,1179673,1179674,1179675,1179676,1179677,1179678,1179679,1179680,1179681,1179682,1179683,1179684,1179685,1179686,1179687,1179688,1179689,1179690,1179691,1179692,1179693,1179694,1179695,1179696,1179697,1179698,1179699,1179700,1179701,1179702,1179704,1179705,1179706,1179707,1179708,1179709,1179710,1179711,1179712,1179713,1179714,1179715,1179716,1179717,1179718,1179719,1179720,1179721,1179722,1179723,1179724,1179725,1179726,1179727,1179728,1179729,1179731,1179732,1179733,1179734,1179735,1179737,1179739,1179740,1179742,1179743,1179744,1179745,1179746,1179747,1179748,1179749,1179752,1179753,1179754,1179755,1179756,1179757,1179758,1179759,1179760,1179761,1179762,1179763,1179764,1179765,1179766,1179767,1179768,1179769,1179770,1179771,1179772,1179773,1179774,1179775,1179776,1179777,1179778,1179779,1179780,1179781,1179782,1179783,1179784,1179785,1179786,1179787,1179788,1179789,1179790,1179791,1179793,1179794,1179795,1179796,1179797,1179798,1179799,1179800,1179801,1179802,1179803,1179804,1179805,1179806,1179807,1179808,1179809,1179810,1179811,1179812,1179813,1179814,1179815,1179816,1179817,1179818,1179819,1179820,1179821,1179822,1179823,1179824,1179825,1179826,1179827,1179828,1179829,1179830,1179831,1179832,1179833,1179834,1179835,1179836,1179838,1179839,1179840,1179841,1179842,1179843,1179844,1179845,1179846,1179847,1179848,1179849,1179850,1179851,1179852,1179853,1179854,1179855,1179856,1179857,1179858,1179860,1179862,1179863,1179864,1179865,1179866,1179867,1179868,1179869,1179870,1179871,1179872,1179873,1179874,1179875,1179876,1179877,1179878,1179879,1179880,1179881,1179882,1179883,1179884,1179885,1179886,1179887,1179888,1179889,1179890,1179891,1179892,1179893,1179894,1179895,1179896,1179897,1179898,1179899,1179900,1179901,1179902,1179903],name:"Network Protocols"},19:{applications:[1245187,1245188,1245189,1245190,1245191,1245192,1245193,1245195,1245196,1245197,1245198,1245200,1245201,1245202,1245203,1245204,1245205,1245206,1245207,1245208,1245209,1245210,1245211,1245212,1245213,1245214,1245215,1245216,1245217,1245218,1245219,1245220,1245221,1245222,1245223,1245224,1245225,1245226,1245228,1245229,1245230,1245231,1245232,1245233,1245234,1245235,1245236,1245237,1245238,1245239,1245240,1245241,1245242,1245243,1245244,1245245,1245246,1245247,1245248,1245249,1245250,1245251,1245252,1245253,1245254,1245255,1245256,1245257,1245258,1245259,1245260,1245261,1245262,1245263,1245264,1245265,1245266,1245267,1245268,1245269,1245270,1245271,1245272,1245273,1245274,1245275,1245276,1245277,1245278,1245279,1245280,1245281,1245282,1245283,1245284,1245285,1245286,1245287,1245288,1245289,1245290,1245291,1245292,1245294,1245295,1245296,1245297,1245298,1245299,1245300,1245301,1245302,1245303,1245304,1245305,1245306,1245307,1245308,1245309,1245310,1245311,1245312,1245313,1245314,1245316,1245318,1245319,1245320,1245321,1245322,1245324,1245325,1245326,1245327,1245328,1245329,1245330,1245331,1245332,1245333,1245334,1245335,1245336,1245337,1245338,1245339,1245340,1245341,1245342,1245343,1245344,1245345,1245346,1245347,1245348,1245349,1245350,1245351,1245352,1245353,1245354,1245355,1245356,1245357,1245358,1245359,1245360,1245361,1245362,1245363,1245364,1245365,1245366,1245370,1245371,1245372,1245373,1245374,1245375,1245376,1245377,1245378,1245379,1245380,1245381,1245382,1245383,1245384,1245385,1245386,1245387,1245388,1245389,1245390,1245391,1245392,1245393,1245394,1245395,1245396,1245397,1245398,1245399,1245400,1245402,1245403,1245404,1245405,1245406,1245407,1245408,1245409,1245410,1245411,1245412,1245413,1245414,1245415,1245416,1245417,1245418,1245419,1245420,1245421,1245422,1245423,1245424,1245425,1245426,1245427,1245428,1245429,1245430,1245431,1245432,1245433,1245434,1245435,1245436,1245437,1245438,1245439],name:"Network Protocols"},20:{applications:[1310721,1310722,1310723,1310724,1310725,1310726,1310727,1310728,1310729,1310730,1310731,1310732,1310733,1310734,1310735,1310736,1310737,1310738,1310739,1310740,1310741,1310742,1310743,1310744,1310745,1310746,1310747,1310748,1310749,1310750,1310751,1310752,1310753,1310754,1310755,1310756,1310757,1310758,1310759,1310760,1310761,1310762,1310763,1310764,1310765,1310766,1310767,1310768,1310769,1310770,1310771,1310772,1310773,1310774,1310775,1310776,1310777,1310778,1310779,1310780,1310781,1310782,1310783,1310784,1310785,1310786,1310787,1310788,1310789,1310790,1310791,1310792,1310793,1310794,1310795,1310796,1310797,1310798,1310799,1310800,1310801,1310802,1310803,1310804,1310805,1310806,1310807,1310808,1310809,1310810,1310811,1310812,1310813,1310814,1310815,1310816,1310817,1310818,1310819,1310820,1310821,1310822,1310823,1310824,1310825,1310826,1310827,1310828,1310830,1310832,1310833,1310834,1310835,1310836,1310837,1310839,1310840,1310841,1310842,1310843,1310844,1310845,1310846,1310847,1310848,1310849,1310850,1310851,1310852,1310853,1310854,1310855,1310856,1310857,1310858,1310859,1310860,1310861,1310862,1310863,1310864,1310865,1310866,1310867,1310868,1310869,1310870,1310871,1310872,1310873,1310874,1310875,1310878,1310879,1310880,1310881,1310882,1310883,1310884,1310887,1310888,1310889,1310890,1310891,1310892,1310893,1310894,1310895,1310896,1310897,1310898,1310899,1310900,1310902,1310903,1310904,1310905,1310906,1310907,1310908,1310909,1310910],name:"Network Protocols"},21:{applications:[1376306,1376323,1376357,1376359],name:"Mobile"},23:{applications:[1507329,1507330,1507333],name:"Private Protocol"},24:{applications:[1572865,1572866,1572867,1572868,1572870,1572871,1572872,1572873,1572874,1572875,1572876,1572880,1572881,1572882,1572883,1572884,1572885,1572886,1572887,1572889,1572890,1572891,1572892,1572893,1572894,1572895,1572896,1572897,1572898,1572899,1572900,1572901,1572902,1572903,1572905,1572906,1572907,1572908,1572909,1572910,1572911,1572912,1572913,1572914,1572915,1572916,1572917,1572918,1572919,1572920,1572921,1572922,1572923,1572927,1572928,1572929,1572930,1572931,1572967,1572968,1572970,1572974,1572975,1572976,1572977,1572978,1572980,1572981,1572983,1572985,1572987,1572988,1572989,1572990,1572998,1572999,1573e3,1573004,1573005,1573006,1573007,1573008,1573009,1573010,1573011,1573014,1573015,1573016,1573017,1573018,1573019,1573020,1573021,1573022,1573023,1573024,1573025,1573026,1573027,1573028,1573029,1573030,1573031,1573032,1573033,1573035],name:"Social Network"},255:{applications:[65535],name:"Unknown"},28:{applications:[1835009,1835010,1835011,1835012,1835013,1835014,1835015,1835016,1835017,1835018,1835019,1835020,1835021,1835022,1835023,1835024,1835025,1835026,1835027,1835028,1835029,1835030,1835031,1835032,1835033,1835034,1835035,1835036,1835037,1835038,1835039,1835040,1835041,1835042,1835043,1835044,1835045,1835046,1835047,1835048,1835049,1835050,1835051,1835052,1835053,1835054,1835055,1835056,1835057,1835058,1835059,1835060,1835061,1835062,1835063,1835064,1835065,1835066,1835067,1835068,1835069,1835070,1835071,1835072,1835073,1835074,1835075,1835076,1835077,1835078,1835079,1835080,1835081,1835082,1835083,1835084,1835085,1835086,1835087,1835088,1835089,1835090,1835091,1835092,1835093,1835094,1835095,1835096,1835097,1835098,1835099,1835100,1835101,1835102,1835103,1835104,1835105,1835106,1835107,1835108],name:"TopSites-Adult"},29:{applications:[1900545,1900546,1900547,1900548,1900549,1900550,1900551,1900552,1900553,1900554,1900555,1900556,1900557,1900558,1900559,1900560,1900561,1900562,1900563,1900564,1900565,1900566,1900567,1900568,1900569,1900570,1900571,1900572,1900573,1900574,1900575,1900576,1900577,1900578,1900579,1900580,1900581,1900582,1900583,1900584,1900585,1900586,1900587,1900588,1900589,1900590,1900591,1900592,1900593,1900594,1900595,1900596,1900597,1900598,1900599,1900600,1900601,1900602,1900603,1900604,1900605,1900606,1900607,1900608,1900609,1900610,1900611,1900612,1900613,1900614,1900615,1900616,1900617,1900618,1900619,1900620,1900621,1900622,1900623,1900624,1900625,1900626,1900627,1900628,1900629],name:"TopSites-Arts"},3:{applications:[196609,196610,196611,196612,196613,196614,196615,196616,196617,196618,196619,196620,196621,196622,196624,196626,196627,196628,196629,196630,196631,196632,196633,196634,196635,196637,196638,196640,196641,196642,196643,196644,196645,196646,196647,196648,196649,196650,196651,196652,196653,196655,196656,196657,196669,196676,196678,196680,196681,196683,196684,196686,196689,196692,196693,196694,196695,196696,196697,196700,196701,196702,196703,196705,196706,196708,196709,196711,196713,196714,196716,196717,196718,196722,196723,196724,196725,196726,196727,196728,196729,196731,196732,196733,196735,196737,196738,196739,196742,196743,196744,196746,196747,196748,196749,196750,196751,196752,196753,196754,196755,196756,196757,196758,196759,196760,196761,196762,196764,196765,196766,196767,196768,196769,196770,196771,196772,196773,196774,196775,196777],name:"File Transfer"},30:{applications:[1966081,1966082,1966083,1966084,1966085,1966086,1966087,1966088,1966089,1966090,1966091,1966092,1966093,1966094,1966095,1966096,1966097,1966098,1966099,1966100,1966101,1966102,1966103,1966104,1966105,1966106,1966107,1966108,1966109,1966110,1966111,1966112,1966113,1966114,1966115,1966116,1966117,1966118,1966119,1966120,1966121,1966122,1966123,1966124,1966125,1966126,1966127,1966128,1966129,1966130,1966131,1966132,1966133,1966134,1966135,1966136,1966137,1966138,1966139,1966140,1966141,1966142,1966143,1966144,1966145,1966146,1966147,1966148,1966149,1966150,1966151,1966152,1966153,1966154,1966155,1966156,1966157,1966158,1966159,1966160,1966161,1966162,1966163,1966164,1966165,1966166,1966167,1966168,1966169,1966170,1966171,1966172,1966173],name:"TopSites-Business"},31:{applications:[2031617,2031618,2031619,2031620,2031621,2031622,2031623,2031624,2031625,2031626,2031627,2031628,2031629,2031630,2031631,2031632,2031633,2031634,2031635,2031636,2031637,2031638,2031639,2031640,2031641,2031642,2031643,2031644,2031645,2031646,2031647,2031648,2031649,2031650,2031651,2031652,2031653,2031654,2031655,2031656,2031657,2031658,2031659,2031660,2031661,2031662,2031663,2031664,2031665,2031666,2031667,2031668,2031669,2031670,2031671,2031672,2031673,2031674,2031675,2031676,2031677,2031678,2031679,2031680],name:"TopSites-Computers"},32:{applications:[2097153,2097154,2097155,2097156,2097157,2097158,2097159,2097160,2097161,2097162,2097163,2097164,2097165,2097166,2097167,2097168,2097169,2097170,2097171,2097172,2097173,2097174,2097175,2097176,2097177,2097178,2097179,2097180,2097181,2097182,2097183,2097184,2097185,2097186,2097187,2097188,2097189,2097190,2097191,2097192,2097193,2097194,2097195,2097196,2097197,2097198,2097199,2097200,2097201,2097202,2097203,2097204,2097205,2097206,2097207,2097208,2097209,2097210,2097211,2097212,2097213,2097214,2097215,2097216,2097217,2097218,2097219,2097220,2097221,2097222,2097223,2097224,2097225,2097226,2097227,2097228,2097229,2097230,2097231,2097232,2097233,2097234,2097235,2097236,2097237,2097238,2097239,2097240,2097241,2097242,2097243,2097244,2097245,2097246,2097247],name:"TopSites-Games"},33:{applications:[2162689,2162690,2162691,2162692,2162693,2162694,2162695,2162696,2162697,2162698,2162699,2162700,2162701,2162702,2162703,2162704,2162705,2162706,2162707,2162708,2162709,2162710,2162711,2162712,2162713,2162714,2162715,2162716,2162717,2162718,2162719,2162720,2162721,2162722,2162723,2162724,2162725,2162726,2162727,2162728,2162729,2162730,2162731,2162732,2162733,2162734,2162735,2162736,2162737,2162738,2162739,2162740,2162741,2162742,2162743,2162744,2162745,2162746,2162747,2162748,2162749,2162750,2162751,2162752,2162753,2162754,2162755,2162756,2162757,2162758,2162759,2162760,2162761,2162762,2162763,2162764,2162765,2162766,2162767,2162768,2162769,2162770,2162771,2162772,2162773,2162774,2162775,2162776,2162777,2162778,2162779],name:"TopSites-Health"},34:{applications:[2228225,2228226,2228227,2228228,2228229,2228230,2228231,2228232,2228233,2228234,2228235,2228236,2228237,2228238,2228239,2228240,2228241,2228242,2228243,2228244,2228245,2228246,2228247,2228248,2228249,2228250,2228251,2228252,2228253,2228254,2228255,2228256,2228257,2228258,2228259,2228260,2228261,2228262,2228263,2228264,2228265,2228266,2228267,2228268,2228269,2228270,2228271,2228272,2228273,2228274,2228275,2228276,2228277,2228278,2228279,2228280,2228281,2228282,2228283,2228284,2228285,2228286,2228287,2228288,2228289,2228290,2228291,2228292,2228293,2228294,2228295,2228296,2228297,2228298,2228299,2228300,2228301,2228302,2228303,2228304,2228305,2228306,2228307,2228308,2228309,2228310,2228311,2228312,2228313,2228314],name:"TopSites-Home"},35:{applications:[2293761,2293762,2293763,2293764,2293765,2293766,2293767,2293768,2293769,2293770,2293771,2293772,2293773,2293774,2293775,2293776,2293777,2293778,2293779,2293780,2293781,2293782,2293783,2293784,2293785,2293786,2293787,2293788,2293789,2293790,2293791,2293792,2293793,2293794,2293795,2293796,2293797,2293798,2293799,2293800,2293801,2293802,2293803,2293804,2293805,2293806,2293807,2293808,2293809,2293810,2293811,2293812,2293813,2293814,2293815,2293816,2293817,2293818,2293819,2293820,2293821,2293822],name:"TopSites-KidsnTeens"},36:{applications:[2359297,2359298,2359299,2359300,2359301,2359302,2359303,2359304,2359305,2359306,2359307,2359308,2359309,2359310,2359311,2359312,2359313,2359314,2359315,2359316,2359317,2359318,2359319,2359320,2359321,2359322,2359323,2359324,2359325,2359326,2359327,2359328,2359329,2359330,2359331,2359332,2359333,2359334,2359335,2359336,2359337,2359338,2359339,2359340,2359341,2359342,2359343,2359344,2359345,2359346,2359347,2359348,2359349,2359350,2359351,2359352,2359353,2359354,2359355,2359356,2359357,2359358,2359359,2359360,2359361,2359362,2359363,2359364,2359365],name:"TopSites-News"},37:{applications:[2424833,2424834,2424835,2424836,2424837,2424838,2424839,2424840,2424841,2424842,2424843,2424844,2424845,2424846,2424847,2424848,2424849,2424850,2424851,2424852,2424853,2424854,2424855,2424856,2424857,2424858,2424859,2424860,2424861,2424862,2424863,2424864,2424865,2424866,2424867,2424868,2424869,2424870,2424871,2424872,2424873,2424874,2424875,2424876,2424877,2424878,2424879,2424880,2424881,2424882,2424883,2424884,2424885,2424886,2424887,2424888,2424889,2424890,2424891,2424892,2424893,2424894,2424895,2424896,2424897,2424898,2424899,2424900,2424901,2424902,2424903,2424904,2424905,2424906,2424907,2424908,2424909,2424910,2424911,2424912,2424913,2424914,2424915,2424916,2424917,2424918,2424919,2424920],name:"TopSites-Recreation"},38:{applications:[2490369,2490370,2490371,2490372,2490373,2490374,2490375,2490376,2490377,2490378,2490379,2490380,2490381,2490382,2490383,2490384,2490385,2490386,2490387,2490388,2490389,2490390,2490391,2490392,2490393,2490394,2490395,2490396,2490397,2490398,2490399,2490400,2490401,2490402,2490403,2490404,2490405,2490406,2490407,2490408,2490409,2490410,2490411,2490412,2490413,2490414,2490415,2490416,2490417,2490418,2490419,2490420,2490421,2490422,2490423,2490424,2490425,2490426,2490427,2490428,2490429,2490430,2490431,2490432,2490433,2490434,2490435,2490436,2490437,2490438,2490439,2490440,2490441,2490442,2490443,2490444,2490445,2490446,2490447],name:"TopSites-Reference"},39:{applications:[2555905,2555906,2555907,2555908,2555909,2555910,2555911,2555912,2555913,2555914,2555915,2555916,2555917,2555918,2555919,2555920,2555921,2555922,2555923,2555924,2555925,2555926,2555927,2555928,2555929,2555930,2555931,2555932,2555933,2555934,2555935,2555936,2555937,2555938,2555939,2555940,2555941,2555942,2555943,2555944,2555945,2555946,2555947,2555948,2555949,2555950],name:"TopSites-Regional"},4:{applications:[262145,262146,262147,262148,262149,262150,262151,262152,262153,262154,262155,262156,262157,262158,262159,262160,262161,262162,262163,262164,262165,262166,262167,262168,262169,262170,262171,262172,262173,262174,262175,262176,262177,262178,262179,262181,262182,262183,262184,262185,262186,262187,262188,262189,262190,262191,262192,262193,262194,262195,262196,262197,262198,262199,262200,262201,262202,262203,262204,262205,262207,262208,262209,262210,262211,262212,262213,262214,262215,262216,262217,262218,262219,262220,262221,262223,262224,262226,262227,262228,262229,262230,262231,262232,262233,262234,262235,262236,262237,262238,262239,262245,262246,262247,262250,262251,262252,262254,262256,262258,262259,262260,262261,262262,262263,262264,262265,262266,262267,262268,262270,262271,262272,262274,262275,262276,262277,262278,262279,262280,262281,262283,262284,262285,262286,262287,262288,262290,262291,262292,262293,262294,262295,262296,262298,262301,262302,262303,262305,262306,262308,262310,262311,262312,262313,262314,262315,262316,262317,262318,262319,262320,262321,262322,262323,262324,262325,262326,262327,262328,262329,262330,262331,262332,262333,262334,262335,262336,262337,262338,262339,262340,262341,262342,262343,262344,262345,262346,262347,262348,262349],name:"Streaming Media"},40:{applications:[2621441,2621442,2621443,2621444,2621445,2621446,2621447,2621448,2621449,2621450,2621451,2621452,2621453,2621454,2621455,2621456,2621457,2621458,2621459,2621460,2621461,2621462,2621463,2621464,2621465,2621466,2621467,2621468,2621469,2621470,2621471,2621472,2621473,2621474,2621475,2621476,2621477,2621478,2621479,2621480,2621481,2621482,2621483,2621484,2621485,2621486,2621487,2621488,2621489,2621490,2621491,2621492,2621493,2621494,2621495,2621496,2621497,2621498,2621499,2621500,2621501,2621502,2621503],name:"TopSites-Science"},41:{applications:[2686977,2686978,2686979,2686980,2686981,2686982,2686983,2686984,2686985,2686986,2686987,2686988,2686989,2686990,2686991,2686992,2686993,2686994,2686995,2686996,2686997,2686998,2686999,2687e3,2687001,2687002,2687003,2687004,2687005,2687006,2687007,2687008,2687009,2687010,2687011,2687012,2687013,2687014,2687015,2687016,2687017,2687018,2687019,2687020,2687021,2687022,2687023,2687024,2687025,2687026,2687027,2687028,2687029,2687030,2687031,2687032,2687033,2687034,2687035,2687036,2687037,2687038,2687039,2687040,2687041,2687042,2687043,2687044,2687045,2687046,2687047,2687048,2687049,2687050,2687051,2687052,2687053,2687054,2687055,2687056],name:"TopSites-Shopping"},42:{applications:[2752513,2752514,2752515,2752516,2752517,2752518,2752519,2752520,2752521,2752522,2752523,2752524,2752525,2752526,2752527,2752528,2752529,2752530,2752531,2752532,2752533,2752534,2752535,2752536,2752537,2752538,2752539,2752540,2752541,2752542,2752543,2752544,2752545,2752546,2752547,2752548,2752549,2752550,2752551,2752552,2752553,2752554,2752555,2752556,2752557,2752558,2752559,2752560,2752561,2752562,2752563,2752564,2752565,2752566,2752567,2752568,2752569,2752570,2752571,2752572,2752573,2752574,2752575,2752576,2752577,2752578,2752579,2752580,2752581,2752582,2752583,2752584,2752585,2752586,2752587,2752588,2752589,2752590,2752591],name:"TopSites-Society"},43:{applications:[2818049,2818050,2818051,2818052,2818053,2818054,2818055,2818056,2818057,2818058,2818059,2818060,2818061,2818062,2818063,2818064,2818065,2818066,2818067,2818068,2818069,2818070,2818071,2818072,2818073,2818074,2818075,2818076,2818077,2818078,2818079,2818080,2818081,2818082,2818083,2818084,2818085,2818086,2818087,2818088,2818089,2818090,2818091,2818092,2818093,2818094,2818095,2818096,2818097,2818098,2818099,2818100,2818101,2818102],name:"TopSites-Sports"},5:{applications:[327681,327682,327683,327684,327685,327686,327687,327689,327690,327691,327692,327693,327694,327695,327696,327697,327698,327699,327700,327701,327702,327703,327704,327705,327706,327707,327708,327709,327710,327711,327712,327713,327714,327715,327716,327717,327718,327720,327722,327723,327732,327742,327743,327744,327745,327746,327747,327749,327751,327753,327755,327760,327761,327762,327763,327764,327770,327774,327775,327776,327778,327779,327780,327781,327782,327783,327784,327785,327786,327787,327788,327789,327790,327791,327792,327793,327794,327795],name:"Mail and Collaboration"},6:{applications:[393217,393218,393220,393221,393222,393223,393225,393226,393228,393229,393230,393231,393232,393234,393235,393236,393238,393239,393240,393242,393243,393244,393246,393247],name:"Voice over IP"},7:{applications:[458753,458754,458755,458756,458757,458760,458761,458763,458766,458767,458768],name:"Database"},8:{applications:[524289,524290,524291,524292,524293,524294,524295,524296,524297,524298,524299,524300,524301,524302,524303,524304,524306,524307,524308,524310,524311,524312,524313,524314,524315,524316,524317,524318,524319,524320,524321,524322,524323,524324,524326,524327,524328,524329,524330,524331,524332,524333,524334,524335,524336,524337,524338,524339,524340,524341,524343,524344,524345,524346,524347,524348,524349,524350,524351,524352,524353,524354,524355,524356,524358,524359,524360,524361,524362,524363,524364,524365,524366,524367,524368,524369,524370,524371,524372,524373,524374,524375,524376,524377,524379,524380,524381,524383,524384,524385,524386,524388,524389,524390,524391,524392,524393,524394,524395,524396,524398,524399,524400,524401,524402,524403,524404,524405,524406,524407,524408,524409,524410,524411,524412,524413,524414,524415,524416,524417,524418,524419,524420,524421,524422,524423,524424,524425,524426,524427,524428,524429,524430,524431,524432,524433,524434,524435,524436,524437,524438,524439,524440,524441,524442,524443,524444,524445,524446,524447,524448,524449,524450,524451,524452,524453,524454,524455,524456,524457,524458,524459,524460,524461,524462,524463,524466,524479,524491,524512,524513,524514,524515,524516,524517,524518,524519,524520,524521,524522,524523,524524,524525,524526,524527,524529,524530,524531,524532,524533,524534,524535,524536,524537,524538,524539,524540,524541,524542,524543],name:"Games"},9:{applications:[589828,589829,589885,589888,589890,589916,589933,589934,589942,589951],name:"Network Management"}},version:{major:1,minor:52}}}),define("unifi/util/DpiIconMap",[],function(){"use strict";return{applications:{1:{category_id:0,name:"MSN",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/msn.com/favicon.ico"},10:{category_id:0,name:"Gadu-Gadu"},100:{category_id:0,name:"Verychat(M)"},101:{category_id:0,name:"Voxer(M)"},102:{category_id:0,name:"TextMe(M)"},103:{category_id:0,name:"Bump(M)"},104:{category_id:0,name:"CoolMessenger"},105:{category_id:0,name:"NateOn"},106:{category_id:0,name:"WeChat(M)"},107:{category_id:0,name:"Snapchat(M)"},108:{category_id:0,name:"Wangxin"},11:{category_id:0,name:"Yixin"},1114113:{category_id:17,name:"WatchGuard WSM Management"},1114114:{category_id:17,name:"WatchGuard Web Management UI"},1114115:{category_id:17,name:"WatchGuard Authentication Access"},1114117:{category_id:17,name:"WatchGuard external Webblocker database fetch"},1114118:{category_id:17,name:"Livelink"},1114119:{category_id:17,name:"Altiris"},1114120:{category_id:17,name:"AMS"},1114121:{category_id:17,name:"Apache Synapse"},1114122:{category_id:17,name:"WatchGuard CLI "},1114124:{category_id:17,name:"Webex"},1114125:{category_id:17,name:"Webex-WebOffice"},1114128:{category_id:17,name:"Avamar"},1114129:{category_id:17,name:"Avaya"},1114130:{category_id:17,name:"BackupExec"},1114131:{category_id:17,name:"Bitcoin Core"},1114133:{category_id:17,name:"Microsoft OS license",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/microsoft.com/favicon.ico"},1114134:{category_id:17,name:"Microsoft Office 2013 license",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/microsoft.com/favicon.ico"},1114138:{category_id:17,name:"BZFlag"},1114140:{category_id:17,name:"CAJO"},1114141:{category_id:17,name:"Cisco HSRP"},1114142:{category_id:17,name:"SkyDesk"},1114150:{category_id:17,name:"openQRM"},1114151:{category_id:17,name:"Citrix"},1114152:{category_id:17,name:"CodeMeter"},1114155:{category_id:17,name:"Corba"},1114158:{category_id:17,name:"Cups"},1114160:{category_id:17,name:"Cvsup"},1114161:{category_id:17,name:"DameWare"},1114167:{category_id:17,name:"Db2"},1114169:{category_id:17,name:"Dclink"},1114170:{category_id:17,name:"Urchin Web Analytics"},1114176:{category_id:17,name:"EForward-document transport system"},1114177:{category_id:17,name:"EMWIN"},1114180:{category_id:17,name:"ESRI"},1114182:{category_id:17,name:"Big Brother"},1114187:{category_id:17,name:"Freeciv"},1114188:{category_id:17,name:"Microsoft Lync",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/microsoft.com/favicon.ico"},1114191:{category_id:17,name:"Websense"},1114195:{category_id:17,name:"Whisker"},1114198:{category_id:17,name:"Hewlett-Packard"},1114201:{category_id:17,name:"HP-JetDirect"},1114203:{category_id:17,name:"VMWare"},1114205:{category_id:17,name:"IBM HTTP"},1114206:{category_id:17,name:"IBM SmartCloud"},1114212:{category_id:17,name:"IMS"},1114213:{category_id:17,name:"Infomix"},1114222:{category_id:17,name:"Limelight"},1114229:{category_id:17,name:"Lawson-m3"},1114238:{category_id:17,name:"Meeting-maker"},1114239:{category_id:17,name:"Zendesk"},1114246:{category_id:17,name:"Microsoft DTC",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/microsoft.com/favicon.ico"},1114248:{category_id:17,name:"Microsoft Netlogon",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/microsoft.com/favicon.ico"},1114250:{category_id:17,name:"Microsoft Remote Web Workplace",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/microsoft.com/favicon.ico"},1114252:{category_id:17,name:"Sharepoint-wiki"},1114253:{category_id:17,name:"Microsoft SSDP",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/microsoft.com/favicon.ico"},1114255:{category_id:17,name:"GatherPlace"},1114269:{category_id:17,name:"Xgrid"},1114272:{category_id:17,name:"Backweb"},1114273:{category_id:17,name:"Bugzilla"},1114274:{category_id:17,name:"NCube"},1114275:{category_id:17,name:"WinboxRouterOS"},1114277:{category_id:17,name:"WSO2"},1114279:{category_id:17,name:"NetFlow"},1114289:{category_id:17,name:"concur"},1114290:{category_id:17,name:"NetSupport"},1114308:{category_id:17,name:"DirectAdmin"},1114309:{category_id:17,name:"EasyBits"},1114310:{category_id:17,name:"Eiq-sec-analyzer"},1114311:{category_id:17,name:"Netbotz"},1114318:{category_id:17,name:"Perforce"},1114320:{category_id:17,name:"TiVoConnect"},1114321:{category_id:17,name:"Polycom"},1114322:{category_id:17,name:"WebSphere"},1114330:{category_id:17,name:"Radacct RADIUS"},1114331:{category_id:17,name:"Psiphon"},1114334:{category_id:17,name:"Securemeeting"},1114335:{category_id:17,name:"SW Soft Plesk"},1114337:{category_id:17,name:"SANE"},1114339:{category_id:17,name:"WebHost"},1114340:{category_id:17,name:"CPanel"},1114342:{category_id:17,name:"Sibelius"},1114343:{category_id:17,name:"Siebel-crm"},1114347:{category_id:17,name:"SMS"},1114350:{category_id:17,name:"Spirent"
},1114351:{category_id:17,name:"SPSS"},1114352:{category_id:17,name:"Subversion"},1114355:{category_id:17,name:"Tripwire"},1114359:{category_id:17,name:"WatchGuard Webblocker database transfer"},1114361:{category_id:17,name:"WatchGuard Security Event Processor logging"},1114363:{category_id:17,name:"Genesys Meeting Center"},1114365:{category_id:17,name:"Nagios"},1179649:{category_id:18,name:"TCP Port Service Multiplexer"},1179650:{category_id:18,name:"Management Utility"},1179651:{category_id:18,name:"Compression Process"},1179653:{category_id:18,name:"Echo"},1179654:{category_id:18,name:"Discard"},1179655:{category_id:18,name:"Active"},1179660:{category_id:18,name:"Character Generator"},1179665:{category_id:18,name:"any private mail system"},1179667:{category_id:18,name:"AltaVista Firewall97"},1179668:{category_id:18,name:"NSW User System FE"},1179669:{category_id:18,name:"MSG ICP"},1179670:{category_id:18,name:"MSG Authentication"},1179671:{category_id:18,name:"Display Support Protocol"},1179672:{category_id:18,name:"any private printer server"},1179673:{category_id:18,name:"Time"},1179674:{category_id:18,name:"Route Access Protocol"},1179675:{category_id:18,name:"Resource Location Protocol"},1179676:{category_id:18,name:"graphics"},1179677:{category_id:18,name:"Host Name Server"},1179678:{category_id:18,name:"NIC Name"},1179679:{category_id:18,name:"MPM FLAGS Protocol"},1179680:{category_id:18,name:"Message Processing Module [recv]"},1179681:{category_id:18,name:"MPM [default send]"},1179682:{category_id:18,name:"NI FTP"},1179683:{category_id:18,name:"Digital Audit Daemon"},1179684:{category_id:18,name:"Login Host Protocol (TACACS)"},1179685:{category_id:18,name:"Remote Mail Checking Protocol"},1179686:{category_id:18,name:"IMP Logical Address Maintenance"},1179687:{category_id:18,name:"XNS Time Protocol"},1179688:{category_id:18,name:"Domain Name Server"},1179689:{category_id:18,name:"XNS Clearinghouse"},1179690:{category_id:18,name:"ISI Graphics Language"},1179691:{category_id:18,name:"XNS Authentication"},1179692:{category_id:18,name:"Mail Transfer Protocol (MTP)"},1179693:{category_id:18,name:"XNS Mail"},1179694:{category_id:18,name:"any private file service"},1179695:{category_id:18,name:"NI MAIL"},1179696:{category_id:18,name:"ACA Services"},1179697:{category_id:18,name:"VIA Systems - FTP whois++"},1179698:{category_id:18,name:"Communications Integrator (CI)"},1179699:{category_id:18,name:"TACACS-Database Service"},1179700:{category_id:18,name:"Oracle SQL-NET"},1179701:{category_id:18,name:"Bootstrap Protocol Server"},1179702:{category_id:18,name:"Bootstrap Protocol Client"},1179704:{category_id:18,name:"Gopher"},1179705:{category_id:18,name:"Remote Job Service"},1179706:{category_id:18,name:"any private dial out service"},1179707:{category_id:18,name:"Distributed External Object Store"},1179708:{category_id:18,name:"any private RJE service netrjs"},1179709:{category_id:18,name:"Vet TCP"},1179710:{category_id:18,name:"Finger"},1179711:{category_id:18,name:"World Wide Web HTTP"},1179712:{category_id:18,name:"Torpark"},1179713:{category_id:18,name:"XFER Utility"},1179714:{category_id:18,name:"MIT ML Device"},1179715:{category_id:18,name:"Common Trace Facility"},1179716:{category_id:18,name:"Micro Focus Cobol"},1179717:{category_id:18,name:"any private terminal link ttylink"},1179718:{category_id:18,name:"Kerberos"},1179719:{category_id:18,name:"SU MIT Telnet Gateway"},1179720:{category_id:18,name:"DNSIX Securit Attribute Token Map"},1179721:{category_id:18,name:"MIT Dover Spooler"},1179722:{category_id:18,name:"Network Printing Protocol"},1179723:{category_id:18,name:"Device Control Protocol"},1179724:{category_id:18,name:"Tivoli Object Dispatcher"},1179725:{category_id:18,name:"BSD supdupd(8)"},1179726:{category_id:18,name:"DIXIE Protocol Specification"},1179727:{category_id:18,name:"Swift Remote Virtural File Protocol"},1179728:{category_id:18,name:"linuxconf"},1179729:{category_id:18,name:"Metagram Relay"},1179731:{category_id:18,name:"NIC Host Name Server"},1179732:{category_id:18,name:"ISO-TSAP Class 0"},1179733:{category_id:18,name:"Genesis Point-to-Point Trans Net"},1179734:{category_id:18,name:"ACR-NEMA Digital Imag. &amp; Comm. 300"},1179735:{category_id:18,name:"Mailbox Name Nameserver"},1179737:{category_id:18,name:"Eudora compatible PW changer"},1179739:{category_id:18,name:"SNA Gateway Access Server"},1179740:{category_id:18,name:"PostOffice V.2"},1179742:{category_id:18,name:"Portmapper RPC Bind"},1179743:{category_id:18,name:"McIDAS Data Transmission Protocol"},1179744:{category_id:18,name:"Ident Tap Authentication Service"},1179745:{category_id:18,name:"Audio News Multicast"},1179746:{category_id:18,name:"Simple File Transfer Protocol"},1179747:{category_id:18,name:"ANSA REX Notify"},1179748:{category_id:18,name:"UUCP Path Service"},1179749:{category_id:18,name:"SQL Services"},1179752:{category_id:18,name:"Encore Expedited Remote Pro.Call"},1179753:{category_id:18,name:"Smakynet"},1179754:{category_id:18,name:"NTP"},1179755:{category_id:18,name:"ANSA REX Trader"},1179756:{category_id:18,name:"Locus PC-Interface Net Map Ser"},1179757:{category_id:18,name:"Unisys Unitary Login"},1179758:{category_id:18,name:"Locus PC-Interface Conn Server"},1179759:{category_id:18,name:"GSS X License Verification"},1179760:{category_id:18,name:"Password Generator Protocol"},1179761:{category_id:18,name:"Cisco FNATIVE"},1179762:{category_id:18,name:"Cisco TNATIVE"},1179763:{category_id:18,name:"Cisco SYSMAINT"},1179764:{category_id:18,name:"Statistics Service"},1179765:{category_id:18,name:"INGRES-NET Service"},1179766:{category_id:18,name:"NCS local location broker"},1179767:{category_id:18,name:"PROFILE Naming System"},1179768:{category_id:18,name:"NetBIOS Name Service"},1179769:{category_id:18,name:"NetBIOS Datagram Service"},1179770:{category_id:18,name:"NetBIOS Session Service"},1179771:{category_id:18,name:"EMFIS Data Service"},1179772:{category_id:18,name:"EMFIS Control Service"},1179773:{category_id:18,name:"Britton-Lee IDM"},1179774:{category_id:18,name:"Internet Message Access Protocol"},1179775:{category_id:18,name:"Universal Management Architecture"},1179776:{category_id:18,name:"UAAC Protocol"},1179777:{category_id:18,name:"iso-ip0"},1179778:{category_id:18,name:"iso-ip"},1179779:{category_id:18,name:"Jargon"},1179780:{category_id:18,name:"AED 512 Emulation Service"},1179781:{category_id:18,name:"SQL-net"},1179782:{category_id:18,name:"HEMS"},1179783:{category_id:18,name:"Background File Transfer Program (BFTP)"},1179784:{category_id:18,name:"SGMP"},1179785:{category_id:18,name:"NetSC-prod"},1179786:{category_id:18,name:"NetSC-dev"},1179787:{category_id:18,name:"SQL Service"},1179788:{category_id:18,name:"KNET VM Command Message Protocol"},1179789:{category_id:18,name:"PCMail Server"},1179790:{category_id:18,name:"NSS-Routing"},1179791:{category_id:18,name:"SGMP-traps"},1179793:{category_id:18,name:"SNMPTRAP"},1179794:{category_id:18,name:"CMIP TCP Manager"},1179795:{category_id:18,name:"CMIP TCP Agent"},1179796:{category_id:18,name:"Xerox"},1179797:{category_id:18,name:"Sirius Systems"},1179798:{category_id:18,name:"namp"},1179799:{category_id:18,name:"rsvd"},1179800:{category_id:18,name:"send"},1179801:{category_id:18,name:"Network PostScript"},1179802:{category_id:18,name:"Network Innovations Multiplex"},1179803:{category_id:18,name:"Network Innovations CL 1"},1179804:{category_id:18,name:"xyplex-mux"},1179805:{category_id:18,name:"mailq"},1179806:{category_id:18,name:"vmnet"},1179807:{category_id:18,name:"genrad-mux"},1179808:{category_id:18,name:"X Display Manager Control Protocol"},1179809:{category_id:18,name:"NextStep Window Server"},1179810:{category_id:18,name:"Border Gateway Protocol"},1179811:{category_id:18,name:"Intergraph"},1179812:{category_id:18,name:"unify"},1179813:{category_id:18,name:"Unisys Audit SITP"},1179814:{category_id:18,name:"ocbinder"},1179815:{category_id:18,name:"ocserver"},1179816:{category_id:18,name:"remote-kis"},1179817:{category_id:18,name:"KIS Protocol"},1179818:{category_id:18,name:"Application Communication Interface"},1179819:{category_id:18,name:"Plus Fives MUMPS"},1179820:{category_id:18,name:"Queued File Transport"},1179821:{category_id:18,name:"Gateway Access Control Protocol"},1179822:{category_id:18,name:"Prospero Directory Service"},1179823:{category_id:18,name:"OSU Network Monitoring System"},1179824:{category_id:18,name:"Spider Remote Monitoring Protocol"},1179825:{category_id:18,name:"Internet Relay Chat"},1179826:{category_id:18,name:"DNSIX Network Level Module Audit"},1179827:{category_id:18,name:"DNSIX Session Mgt Module Audit Redir"},1179828:{category_id:18,name:"Directory Location Service"},1179829:{category_id:18,name:"Directory Location Service Monitor"},1179830:{category_id:18,name:"SMUX"},1179831:{category_id:18,name:"IBM System Resource Controller"},1179832:{category_id:18,name:"AppleTalk Routing Maintenance",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/apple.com/favicon.ico"},1179833:{category_id:18,name:"AppleTalk Name Binding",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/apple.com/favicon.ico"},1179834:{category_id:18,name:"AppleTalk Unused",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/apple.com/favicon.ico"},1179835:{category_id:18,name:"AppleTalk Echo",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/apple.com/favicon.ico"},1179836:{category_id:18,name:"AppleTalk Zone Information",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/apple.com/favicon.ico"},1179838:{category_id:18,name:"Trivial Authenticated Mail Protocol"},1179839:{category_id:18,name:"ANSI Z39.50"},1179840:{category_id:18,name:"Texas Instruments"},1179841:{category_id:18,name:"ATEXSSTR"},1179842:{category_id:18,name:"IPX"},1179843:{category_id:18,name:"vmpwscs"},1179844:{category_id:18,name:"Insignia Solutions"},1179845:{category_id:18,name:"Computer Associates Intl License Server"},1179846:{category_id:18,name:"dBASE Unix"},1179847:{category_id:18,name:"Netix Message Posting Protocol"},1179848:{category_id:18,name:"Unisys ARPs"},1179849:{category_id:18,name:"Interactive Mail Access Protocol v3"},1179850:{category_id:18,name:"Berkeley rlogind with SPX auth"},1179851:{category_id:18,name:"Berkeley rshd with SPX auth"},1179852:{category_id:18,name:"Certificate Distribution Center"},1179853:{category_id:18,name:"masqdialer"},1179854:{category_id:18,name:"direct"},1179855:{category_id:18,name:"Survey Measurement"},1179856:{category_id:18,name:"inbusiness"},1179857:{category_id:18,name:"link"},1179858:{category_id:18,name:"Display Systems Protocol"},1179860:{category_id:18,name:"bhfhs"},1179862:{category_id:18,name:"RAP (Route Access Protocol)"},1179863:{category_id:18,name:"Checkpoint Firewall-1"},1179864:{category_id:18,name:"Efficient Short Remote Operations"},1179865:{category_id:18,name:"openport"},1179866:{category_id:18,name:"Checkpoint Firewall-1 Management"},1179867:{category_id:18,name:"arcisdms"},1179868:{category_id:18,name:"hdap"},1179869:{category_id:18,name:"Border Gateway Multicast Protocol (BGMP)"},1179870:{category_id:18,name:"X-Bone CTL"},1179871:{category_id:18,name:"SCSI on ST"},1179872:{category_id:18,name:"Tobit David Service Layer"},1179873:{category_id:18,name:"Tobit David Replica"},1179874:{category_id:18,name:"http-mgmt"},1179875:{category_id:18,name:"personal-link"},1179876:{category_id:18,name:"Cable Port A X"},1179877:{category_id:18,name:"rescap"},1179878:{category_id:18,name:"corerjd"},1179879:{category_id:18,name:"FXP-1"},1179880:{category_id:18,name:"K-BLOCK"},1179881:{category_id:18,name:"Novastor Backup"},1179882:{category_id:18,name:"entrusttime"},1179883:{category_id:18,name:"bhmds"},1179884:{category_id:18,name:"AppleShare IP WebAdmin",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/apple.com/favicon.ico"},1179885:{category_id:18,name:"VSLMP"},1179886:{category_id:18,name:"magenta-logic"},1179887:{category_id:18,name:"opalis-robot"},1179888:{category_id:18,name:"DPSI"},1179889:{category_id:18,name:"decAuth"},1179890:{category_id:18,name:"zannet"},1179891:{category_id:18,name:"PKIX TimeStamp"},1179892:{category_id:18,name:"PTP Event"},1179893:{category_id:18,name:"PTP General"},1179894:{category_id:18,name:"Programmable Interconnect Point (PIP)"},1179895:{category_id:18,name:"RTSPS"},1179896:{category_id:18,name:"Texar Security Port"},1179897:{category_id:18,name:"Prospero Data Access Protocol"},1179898:{category_id:18,name:"Perf Analysis Workbench"},1179899:{category_id:18,name:"Zebra server"},1179900:{category_id:18,name:"Fatmen Server"},1179901:{category_id:18,name:"Cabletron Management Protocol"},1179902:{category_id:18,name:"mftp"},1179903:{category_id:18,name:"MATIP Type A"},12:{category_id:0,name:"POPO"},1245187:{category_id:19,name:"DTAG or bhoedap4"},1245188:{category_id:19,name:"ndsauth"},1245189:{category_id:19,name:"bh611"},1245190:{category_id:19,name:"datex-asn"},1245191:{category_id:19,name:"Cloanto Net 1"},1245192:{category_id:19,name:"bhevent"},1245193:{category_id:19,name:"shrinkwrap"},1245195:{category_id:19,name:"Tenebris Network Trace Service"},1245196:{category_id:19,name:"scoi2odialog"},1245197:{category_id:19,name:"semantix"},1245198:{category_id:19,name:"SRS Send"},1245200:{category_id:19,name:"aurora-cmgr"},1245201:{category_id:19,name:"DTK"},1245202:{category_id:19,name:"odmr"},1245203:{category_id:19,name:"mortgageware"},1245204:{category_id:19,name:"qbikgdp"},1245205:{category_id:19,name:"rpc2portmap"},1245206:{category_id:19,name:"Coda authentication server (codaauth2)"},1245207:{category_id:19,name:"ClearCase"},1245208:{category_id:19,name:"ListProcessor"},1245209:{category_id:19,name:"Legent Corporation"},1245210:{category_id:19,name:"hassle"},1245211:{category_id:19,name:"Amiga Envoy Network Inquiry Proto"},1245212:{category_id:19,name:"NEC Corporation"},1245213:{category_id:19,name:"TIA EIA IS-99 modem client"},1245214:{category_id:19,name:"TIA EIA IS-99 modem server"},1245215:{category_id:19,name:"HP Performance data collector"},1245216:{category_id:19,name:"HP Performance data managed node"},1245217:{category_id:19,name:"HP Performance data alarm manager"},1245218:{category_id:19,name:"A Remote Network Server System"},1245219:{category_id:19,name:"IBM Application"},1245220:{category_id:19,name:"ASA Message Router Object Def."},1245221:{category_id:19,name:"Appletalk Update-Based Routing Pro.",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/apple.com/favicon.ico"},1245222:{category_id:19,name:"Unidata LDM"},1245223:{category_id:19,name:"Lightweight Directory Access Protocol"},1245224:{category_id:19,name:"uis"},1245225:{category_id:19,name:"SynOptics SNMP Relay Port"},1245226:{category_id:19,name:"SynOptics Port Broker Port"},1245228:{category_id:19,name:"Meta5"},1245229:{category_id:19,name:"EMBL Nucleic Data Transfer"},1245230:{category_id:19,name:"NETscout Control Protocol"},1245231:{category_id:19,name:"Novell Netware over IP"},1245232:{category_id:19,name:"Multi Protocol Trans. Net."},1245233:{category_id:19,name:"kryptolan"},1245234:{category_id:19,name:"ISO Transport Class 2 Non-Control over TCP"},1245235:{category_id:19,name:"Workstation Solutions"},1245236:{category_id:19,name:"Uninterruptible Power Supply"},1245237:{category_id:19,name:"Genie Protocol"},1245238:{category_id:19,name:"decap"},1245239:{category_id:19,name:"nced"},1245240:{category_id:19,name:"ncld"},1245241:{category_id:19,name:"Interactive Mail Support Protocol"},1245242:{category_id:19,name:"timbuktu"},1245243:{category_id:19,name:"Prospero Resource Manager Sys. Man."},1245244:{category_id:19,name:"Prospero Resource Manager Node Man."},1245245:{category_id:19,name:"DECLadebug Remote Debug Protocol"},1245246:{category_id:19,name:"Remote MT Protocol"},1245247:{category_id:19,name:"Trap Convention Port"},1245248:{category_id:19,name:"smsp"},1245249:{category_id:19,name:"infoseek"},1245250:{category_id:19,name:"bnet"},1245251:{category_id:19,name:"silverplatter"},1245252:{category_id:19,name:"onmux"},1245253:{category_id:19,name:"hyper-g"},1245254:{category_id:19,name:"ariel1"},1245255:{category_id:19,name:"smpte"},1245256:{category_id:19,name:"ariel2"},1245257:{category_id:19,name:"ariel3"},1245258:{category_id:19,name:"IBM Operations Planning and Control Start"},1245259:{category_id:19,name:"IBM Operations Planning and Control Track"},1245260:{category_id:19,name:"icad-el"},1245261:{category_id:19,name:"smartsdp"},1245262:{category_id:19,name:"Server Location"},1245263:{category_id:19,name:"ocs_cmu"},1245264:{category_id:19,name:"ocs_amu"},1245265:{category_id:19,name:"utmpsd"},1245266:{category_id:19,name:"utmpcd"},1245267:{category_id:19,name:"iasd"},1245268:{category_id:19,name:"Usenet Network News Transfer"},1245269:{category_id:19,name:"mobileip-agent"},1245270:{category_id:19,name:"mobilip-mn"},1245271:{category_id:19,name:"dna-cml"},1245272:{category_id:19,name:"comscm"},1245273:{category_id:19,name:"dsfgw"},1245274:{category_id:19,name:"dasp"},1245275:{category_id:19,name:"sgcp"},1245276:{category_id:19,name:"decvms-sysmgt"},1245277:{category_id:19,name:"cvc_hostd"},1245278:{category_id:19,name:"HTTP Protocol over TLS SSL"},1245279:{category_id:19,name:"Simple Network Paging Protocol"},1245280:{category_id:19,name:"Win2k+ Server Message Block"},1245281:{category_id:19,name:"ddm-rdb"},1245282:{category_id:19,name:"ddm-dfm"},1245283:{category_id:19,name:"DDM-SSL"},1245284:{category_id:19,name:"AS Server Mapper"},1245285:{category_id:19,name:"tserver"},1245286:{category_id:19,name:"Cray Network Semaphore server"},1245287:{category_id:19,name:"Cray SFS config server"},1245288:{category_id:19,name:"creativeserver"},1245289:{category_id:19,name:"contentserver"},1245290:{category_id:19,name:"creativepartnr"},1245291:{category_id:19,name:"macon-tcp"},1245292:{category_id:19,name:"scohelp"},1245294:{category_id:19,name:"ampr-rcmd"},1245295:{category_id:19,name:"skronk"},1245296:{category_id:19,name:"datasurfsrv"},1245297:{category_id:19,name:"datasurfsrvsec"},1245298:{category_id:19,name:"Alpes"},1245299:{category_id:19,name:"kpasswd"},1245300:{category_id:19,name:"SMTP Protocol over TLS SSL (was SSMTP)"},1245301:{category_id:19,name:"digital-vrc"},1245302:{category_id:19,name:"mylex-mapd"},1245303:{category_id:19,name:"Photuris Key Management"},1245304:{category_id:19,name:"Radio Control Protocol"},1245305:{category_id:19,name:"scx-proxy"},1245306:{category_id:19,name:"mondex"},1245307:{category_id:19,name:"ljk-login"},1245308:{category_id:19,name:"hybrid-pop"},1245309:{category_id:19,name:"tn-tl-w1"},1245310:{category_id:19,name:"Tcpnethaspsrv Protocol"},1245311:{category_id:19,name:"tn-tl-fd1"},1245312:{category_id:19,name:"ss7ns"},1245313:{category_id:19,name:"spsc"},1245314:{category_id:19,name:"iafserver"},1245316:{category_id:19,name:"loadsrv"},1245318:{category_id:19,name:"dvs"},1245319:{category_id:19,name:"bgs-nsi"},1245320:{category_id:19,name:"ulpnet"},1245321:{category_id:19,name:"Integra Software Management Environment"},1245322:{category_id:19,name:"Air Soft Power Burst"},1245324:{category_id:19,name:"sstats"},1245325:{category_id:19,name:"saft Simple Asynchronous File Transfer"},1245326:{category_id:19,name:"gss-http"},1245327:{category_id:19,name:"nest-protocol"},1245328:{category_id:19,name:"micom-pfs"},1245329:{category_id:19,name:"go-login"},1245330:{category_id:19,name:"Transport Independent Convergence for FNA"},1245331:{category_id:19,name:"pov-ray"},1245332:{category_id:19,name:"intecourier"},1245333:{category_id:19,name:"pim-rp-disc"},1245334:{category_id:19,name:"dantz"},1245335:{category_id:19,name:"siam"},1245336:{category_id:19,name:"ISO ILL Protocol"},1245337:{category_id:19,name:"VPN Key Exchange"},1245338:{category_id:19,name:"Simple Transportation Management Framework (STMF)"},1245339:{category_id:19,name:"asa-appl-proto"},1245340:{category_id:19,name:"intrinsa"},1245341:{category_id:19,name:"Citadel"},1245342:{category_id:19,name:"mailbox-lm"},1245343:{category_id:19,name:"ohimsrv"},1245344:{category_id:19,name:"crs"},1245345:{category_id:19,name:"xvttp"},1245346:{category_id:19,name:"snare"},1245347:{category_id:19,name:"FirstClass Protocol"},1245348:{category_id:19,name:"passgo"},1245349:{category_id:19,name:"BSD rexecd(8)"},1245350:{category_id:19,name:"BSD rlogind(8)"},1245351:{category_id:19,name:"BSD rshd(8)"},1245352:{category_id:19,name:"spooler"},1245353:{category_id:19,name:"videotex"},1245354:{category_id:19,name:"like tenex link but across"},1245355:{category_id:19,name:"ntalk"},1245356:{category_id:19,name:"unixtime"},1245357:{category_id:19,name:"Routing Information Protocol (RIP)"},1245358:{category_id:19,name:"ripng"},1245359:{category_id:19,name:"ulp"},1245360:{category_id:19,name:"ibm-db2"},1245361:{category_id:19,name:"NetWare Core Protocol (NCP)"},1245362:{category_id:19,name:"Timeserver"},1245363:{category_id:19,name:"newdate"},1245364:{category_id:19,name:"Stock IXChange"},1245365:{category_id:19,name:"Customer IXChange"},1245366:{category_id:19,name:"irc-serv"},1245370:{category_id:19,name:"readnews"},1245371:{category_id:19,name:"netwall for emergency broadcasts"},1245372:{category_id:19,name:"MegaMedia Admin"},1245373:{category_id:19,name:"iiop"},1245374:{category_id:19,name:"opalis-rdv"},1245375:{category_id:19,name:"Networked Media Streaming Protocol"},1245376:{category_id:19,name:"gdomap"},1245377:{category_id:19,name:"Apertus Technologies Load Determination"},1245378:{category_id:19,name:"uucpd"},1245379:{category_id:19,name:"uucp-rlogin"},1245380:{category_id:19,name:"Commerce"},1245381:{category_id:19,name:"klogin"},1245382:{category_id:19,name:"krcmd"},1245383:{category_id:19,name:"Kerberos encrypted remote shell"},1245384:{category_id:19,name:"DHCPv6 Client"},1245385:{category_id:19,name:"DHCPv6 Server"},1245386:{category_id:19,name:"AFP over TCP"},1245387:{category_id:19,name:"idfp"},1245388:{category_id:19,name:"new-who"},1245389:{category_id:19,name:"cybercash"},1245390:{category_id:19,name:"deviceshare"},1245391:{category_id:19,name:"pirp"},1245392:{category_id:19,name:"Real Time Stream Control Protocol"},1245393:{category_id:19,name:"dsf"},1245394:{category_id:19,name:"Remote File System (RFS)"},1245395:{category_id:19,name:"openvms-sysipc"},1245396:{category_id:19,name:"sdnskmp"},1245397:{category_id:19,name:"teedtap"},1245398:{category_id:19,name:"rmonitord"},1245399:{category_id:19,name:"monitor"},1245400:{category_id:19,name:"chcmd"},1245402:{category_id:19,name:"snews"},1245403:{category_id:19,name:"plan 9 file service"},1245404:{category_id:19,name:"whoami"},1245405:{category_id:19,name:"streettalk"},1245406:{category_id:19,name:"banyan-rpc"},1245407:{category_id:19,name:"Microsoft shuttle",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/microsoft.com/favicon.ico"},1245408:{category_id:19,name:"Microsoft rome",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/microsoft.com/favicon.ico"},1245409:{category_id:19,name:"demon"},1245410:{category_id:19,name:"udemon"},1245411:{category_id:19,name:"sonar"},1245412:{category_id:19,name:"banyan-vip"},1245413:{category_id:19,name:"FTP Software Agent System"},1245414:{category_id:19,name:"vemmi"},1245415:{category_id:19,name:"ipcd"},1245416:{category_id:19,name:"vnas"},1245417:{category_id:19,name:"ipdd"},1245418:{category_id:19,name:"decbsrv"},1245419:{category_id:19,name:"sntp-heartbeat"},1245420:{category_id:19,name:"Bundle Discovery Protocol"},1245421:{category_id:19,name:"scc-security"},1245422:{category_id:19,name:"Philips Video-Conferencing"},1245423:{category_id:19,name:"keyserver"},1245424:{category_id:19,name:"IMAP4+SSL"},1245425:{category_id:19,name:"password-chg"},1245426:{category_id:19,name:"submission"},1245427:{category_id:19,name:"cal"},1245428:{category_id:19,name:"eyelink"},1245429:{category_id:19,name:"tns-cml"},1245430:{category_id:19,name:"FileMaker Pro"},1245431:{category_id:19,name:"eudora-set"},1245432:{category_id:19,name:"HTTP RPC Ep Map"},1245433:{category_id:19,name:"tpip"},1245434:{category_id:19,name:"cab-protocol"},1245435:{category_id:19,name:"smsd"},1245436:{category_id:19,name:"PTC Name Service"},1245437:{category_id:19,name:"SCO Web Server Manager 3"},1245438:{category_id:19,name:"Aeolon Core Protocol"},1245439:{category_id:19,name:"Sun IPC server"},13:{category_id:0,name:"Tlen"},1310721:{category_id:20,name:"nqs"},1310722:{category_id:20,name:"Sender-Initiated Unsolicited File Transfer"},1310723:{category_id:20,name:"npmp-trap"},1310724:{category_id:20,name:"npmp-local"},1310725:{category_id:20,name:"npmp-gui"},1310726:{category_id:20,name:"HMMP Indication"},1310727:{category_id:20,name:"HMMP Operation"},1310728:{category_id:20,name:"SSLshell"},1310729:{category_id:20,name:"Internet Configuration Manager"},1310730:{category_id:20,name:"SCO System Administration Server"},1310731:{category_id:20,name:"SCO Desktop Administration Server"},1310732:{category_id:20,name:"DEI-ICDA"},1310733:{category_id:20,name:"Digital EVM"},1310734:{category_id:20,name:"SCO WebServer Manager"},1310735:{category_id:20,name:"ESCP"},1310736:{category_id:20,name:"Collaborator"},1310737:{category_id:20,name:"Aux Bus Shunt"},1310738:{category_id:20,name:"Crypto Admin"},1310739:{category_id:20,name:"DEC DLM"},1310740:{category_id:20,name:"ASIA"},1310741:{category_id:20,name:"PassGo Tivoli"},1310742:{category_id:20,name:"QMQP (qmail)"},1310743:{category_id:20,name:"3Com AMP3"},1310744:{category_id:20,name:"RDA"},1310745:{category_id:20,name:"IPP (Internet Printing Protocol)"},1310746:{category_id:20,name:"bmpp"},1310747:{category_id:20,name:"Service Status update (Sterling Software)"},1310748:{category_id:20,name:"ginad"},1310749:{category_id:20,name:"RLZ DBase"},1310750:{category_id:20,name:"LDAP Protocol over TLS SSL (was SLDAP)"},1310751:{category_id:20,name:"lanserver"},1310752:{category_id:20,name:"mcns-sec"},1310753:{category_id:20,name:"Multicast Source Discovery Protocol (MSDP)"},1310754:{category_id:20,name:"entrust-sps"},1310755:{category_id:20,name:"repcmd"},1310756:{category_id:20,name:"ESRO-EMSDP V1.3"},1310757:{category_id:20,name:"SANity"},1310758:{category_id:20,name:"dwr"},1310759:{category_id:20,name:"PSSC"},1310760:{category_id:20,name:"Label Distribution Protocol (LDP)"},1310761:{category_id:20,name:"DHCP Failover"},1310762:{category_id:20,name:"Registry Registrar Protocol (RRP)"},1310763:{category_id:20,name:"Aminet"},1310764:{category_id:20,name:"OBEX"},1310765:{category_id:20,name:"IEEE MMS"},1310766:{category_id:20,name:"HELLO_PORT"},1310767:{category_id:20,name:"AODV"},1310768:{category_id:20,name:"TINC"},1310769:{category_id:20,name:"SPMP"},1310770:{category_id:20,name:"RMC"},1310771:{category_id:20,name:"TenFold"},1310772:{category_id:20,name:"URL Rendezvous"},1310773:{category_id:20,name:"MacOS Server Admin"},1310774:{category_id:20,name:"HAP"},1310775:{category_id:20,name:"PFTP"},1310776:{category_id:20,name:"PureNoise"},1310777:{category_id:20,name:"Secure Aux Bus"},1310778:{category_id:20,name:"Sun DR"},1310779:{category_id:20,name:"doom Id Software"},1310780:{category_id:20,name:"campaign contribution disclosures - SDR Technologies"},1310781:{category_id:20,name:"MeComm"},1310782:{category_id:20,name:"MeRegister"},1310783:{category_id:20,name:"VACDSM-SWS"},1310784:{category_id:20,name:"VACDSM-APP"},1310785:{category_id:20,name:"VPPS-QUA"},1310786:{category_id:20,name:"CIMPLEX"},1310787:{category_id:20,name:"ACAP"},1310788:{category_id:20,name:"DCTP"},1310789:{category_id:20,name:"VPPS Via"},1310790:{category_id:20,name:"Virtual Presence Protocol"},1310791:{category_id:20,name:"GNU Gereration Foundation NCP"},1310792:{category_id:20,name:"MRM"},1310793:{category_id:20,name:"entrust-aaas"},1310794:{category_id:20,name:"entrust-aams"},1310795:{category_id:20,name:"XFR"},1310796:{category_id:20,name:"CORBA IIOP"},1310797:{category_id:20,name:"CORBA IIOP SSL"},1310798:{category_id:20,name:"MDC Port Mapper"},1310799:{category_id:20,name:"Hardware Control Protocol Wismar"},1310800:{category_id:20,name:"asipregistry"},1310801:{category_id:20,name:"REALM-RUSD"},1310802:{category_id:20,name:"NMAP"},1310803:{category_id:20,name:"VATP"},1310804:{category_id:20,name:"MS Exchange Routing"},1310805:{category_id:20,name:"Hyperwave-ISP"},1310806:{category_id:20,name:"connendp"},1310807:{category_id:20,name:"Linux-HA (High-Availability Linux)"},1310808:{category_id:20,name:"IEEE-MMS-SSL"},1310809:{category_id:20,name:"RUSHD"},1310810:{category_id:20,name:"UUIDGEN"},1310811:{category_id:20,name:"OLSR"},1310812:{category_id:20,name:"Access Network"},1310813:{category_id:20,name:"errlog copy server daemon"},1310814:{category_id:20,name:"AgentX"},1310815:{category_id:20,name:"Secure Internet Live Conferencing (SILC)"},1310816:{category_id:20,name:"Borland DSJ"},1310817:{category_id:20,name:"Entrust Key Management Service Handler"},1310818:{category_id:20,name:"Entrust Administration Service Handler"},1310819:{category_id:20,name:"Cisco TDP"},1310820:{category_id:20,name:"IBM NetView DM 6000 Server Client"},1310821:{category_id:20,name:"IBM NetView DM 6000 send tcp"},1310822:{category_id:20,name:"IBM NetView DM 6000 receive tcp"},1310823:{category_id:20,name:"netGW"},1310824:{category_id:20,name:"Network based Rev. Cont. Sys."},1310825:{category_id:20,name:"Flexible License Manager"},1310826:{category_id:20,name:"Fujitsu Device Control"},1310827:{category_id:20,name:"Russell Info Sci Calendar Manager"},1310828:{category_id:20,name:"Kerberos 5 admin changepw"},1310830:{category_id:20,name:"rfile"},1310832:{category_id:20,name:"pump"},1310833:{category_id:20,name:"qrh"},1310834:{category_id:20,name:"rrh"},1310835:{category_id:20,name:"kerberos v5 server propagation"},1310836:{category_id:20,name:"nlogin"},1310837:{category_id:20,name:"con"},1310839:{category_id:20,name:"ns"},1310840:{category_id:20,name:"kpwd Kerberos (v4) passwd"},1310841:{category_id:20,name:"quotad"},1310842:{category_id:20,name:"cycleserv"},1310843:{category_id:20,name:"omserv"},1310844:{category_id:20,name:"webster"},1310845:{category_id:20,name:"phone"},1310846:{category_id:20,name:"vid"},1310847:{category_id:20,name:"cadlock"},1310848:{category_id:20,name:"rtip"},1310849:{category_id:20,name:"cycleserv2"},1310850:{category_id:20,name:"submit"},1310851:{category_id:20,name:"rpasswd"},1310852:{category_id:20,name:"entomb"},1310853:{category_id:20,name:"wpages"},1310854:{category_id:20,name:"Hummingbird Exceed jconfig"},1310855:{category_id:20,name:"wpgs"},1310856:{category_id:20,name:"concert"},1310857:{category_id:20,name:"QSC"},1310858:{category_id:20,name:"controlit"},1310859:{category_id:20,name:"mdbs_daemon"},1310860:{category_id:20,name:"device"},1310861:{category_id:20,name:"FCP"},1310862:{category_id:20,name:"itm-mcell-s"},1310863:{category_id:20,name:"PKIX-3 CA RA"},1310864:{category_id:20,name:"DHCP Failover 2"},1310865:{category_id:20,name:"SUP server"},1310866:{category_id:20,name:"rsync"},1310867:{category_id:20,name:"ICL coNETion locate server"},1310868:{category_id:20,name:"ICL coNETion server info"},1310869:{category_id:20,name:"AccessBuilder"},1310870:{category_id:20,name:"OMG Initial Refs"},1310871:{category_id:20,name:"Samba SWAT Tool"},1310872:{category_id:20,name:"IDEAFARM-CHAT"},1310873:{category_id:20,name:"IDEAFARM-CATCH"},1310874:{category_id:20,name:"xact-backup"},1310875:{category_id:20,name:"SecureNet Pro sensor"},1310878:{category_id:20,name:"Netnews Administration System"},1310879:{category_id:20,name:"Telnet Protocol over TLS SSL"},1310880:{category_id:20,name:"IMAP4 Protocol over TLS SSL"},1310881:{category_id:20,name:"ICP Protocol over TLS SSL"},1310882:{category_id:20,name:"POP3 Protocol over TLS SSL"},1310883:{category_id:20,name:"bhoetty"},1310884:{category_id:20,name:"Cray Unified Resource Manager"},1310887:{category_id:20,name:"Microsoft Authentication via SSL",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/microsoft.com/favicon.ico"},1310888:{category_id:20,name:"Google(SSL)",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/google.com/favicon.ico"},1310889:{category_id:20,name:"Yahoo Authentication via SSL",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/yahoo.com/favicon.ico"},1310890:{category_id:20,name:"AOL Authentication via SSL",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/aol.com/favicon.ico"
},1310891:{category_id:20,name:"FIX"},1310892:{category_id:20,name:"STUN"},1310893:{category_id:20,name:"Dynamic Host Configuration Protocol (DHCP)"},1310894:{category_id:20,name:"Megaco"},1310895:{category_id:20,name:"Rstatd"},1310896:{category_id:20,name:"RSVP"},1310897:{category_id:20,name:"SOAP"},1310898:{category_id:20,name:"Ess Apple Authentication via SSL",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/apple.com/favicon.ico"},1310899:{category_id:20,name:"TFTP"},1310900:{category_id:20,name:"Daytime"},1310902:{category_id:20,name:"MicrosoftOnline Authentication via SSL",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/microsoft.com/favicon.ico"},1310903:{category_id:20,name:"Microsoft WINS",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/microsoft.com/favicon.ico"},1310904:{category_id:20,name:"Remote Procedure Call (RPC)"},1310905:{category_id:20,name:"SSL/TLS"},1310906:{category_id:20,name:"Google APIs(SSL)",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/google.com/favicon.ico"},1310907:{category_id:20,name:"Sina Authentication via SSL"},1310908:{category_id:20,name:"Google App Engine(SSL)",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/google.com/favicon.ico"},1310909:{category_id:20,name:"Google User Content(SSL)",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/google.com/favicon.ico"},1310910:{category_id:20,name:"Blackberry Authentication via SSL"},1376306:{category_id:21,name:"Apple iMessage",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/apple.com/favicon.ico"},1376323:{category_id:21,name:"ezRead Touch"},1376357:{category_id:21,name:"Android browser"},1376359:{category_id:21,name:"Symbian browser"},14:{category_id:0,name:"Wlt"},15:{category_id:0,name:"RenRen"},1507329:{category_id:23,name:"QQ Private Protocol"},1507330:{category_id:23,name:"Thunder Private Protocol"},1507333:{category_id:23,name:"Jabber Private Protocol"},1572865:{category_id:24,name:"Classmates"},1572866:{category_id:24,name:"Yik Yak"},1572867:{category_id:24,name:"Facebook",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/facebook.com/favicon.ico"},1572868:{category_id:24,name:"Flickr"},1572870:{category_id:24,name:"Friendfeed"},1572871:{category_id:24,name:"Hi5"},1572872:{category_id:24,name:"Linkedin",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/linkedin.com/favicon.ico"},1572873:{category_id:24,name:"Livejournal"},1572874:{category_id:24,name:"Twitter",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/twitter.com/favicon.ico"},1572875:{category_id:24,name:"Plurk"},1572876:{category_id:24,name:"MySpace"},1572880:{category_id:24,name:"Khan Academy"},1572881:{category_id:24,name:"Pinterest",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/pinterest.com/favicon.ico"},1572882:{category_id:24,name:"Tumblr",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/tumblr.com/favicon.ico"},1572883:{category_id:24,name:"MeetMe"},1572884:{category_id:24,name:"VKontakte"},1572885:{category_id:24,name:"Odnoklassniki"},1572886:{category_id:24,name:"Niwota"},1572887:{category_id:24,name:"Tagged"},1572889:{category_id:24,name:"PerfSpot"},1572890:{category_id:24,name:"Me2day"},1572891:{category_id:24,name:"Mekusharim"},1572892:{category_id:24,name:"Draugiem"},1572893:{category_id:24,name:"Badoo"},1572894:{category_id:24,name:"Meetup"},1572895:{category_id:24,name:"Foursquare"},1572896:{category_id:24,name:"Ning"},1572897:{category_id:24,name:"i-Part"},1572898:{category_id:24,name:"Wretch"},1572899:{category_id:24,name:"Dudu"},1572900:{category_id:24,name:"Mig33"},1572901:{category_id:24,name:"Hatena"},1572902:{category_id:24,name:"eHarmony"},1572903:{category_id:24,name:"Fotolog "},1572905:{category_id:24,name:"Tencent QQ"},1572906:{category_id:24,name:"Pixnet"},1572907:{category_id:24,name:"Nk.Pl"},1572908:{category_id:24,name:"K.ai"},1572909:{category_id:24,name:"Twoo"},1572910:{category_id:24,name:"Plaxo"},1572911:{category_id:24,name:"Cyworld"},1572912:{category_id:24,name:"Jivesoftware"},1572913:{category_id:24,name:"WordPress",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/wordpress.com/favicon.ico"},1572914:{category_id:24,name:"FMyLife"},1572915:{category_id:24,name:"Dcinside"},1572916:{category_id:24,name:"Class Chinaren"},1572917:{category_id:24,name:"Bai Sohu"},1572918:{category_id:24,name:"Yammer"},1572919:{category_id:24,name:"Douban"},1572920:{category_id:24,name:"Gamer"},1572921:{category_id:24,name:"Xuite"},1572922:{category_id:24,name:"ChatMe"},1572923:{category_id:24,name:"Clien.net"},1572927:{category_id:24,name:"AdultFriendFinder"},1572928:{category_id:24,name:"Fling.com"},1572929:{category_id:24,name:"Delicious"},1572930:{category_id:24,name:"Mei.fm"},1572931:{category_id:24,name:"Streetlife"},1572967:{category_id:24,name:"Daum-blog"},1572968:{category_id:24,name:"Naver-blog"},1572970:{category_id:24,name:"Panoramio"},1572974:{category_id:24,name:"Blogger "},1572975:{category_id:24,name:"FC2"},1572976:{category_id:24,name:"Yahoo Blog",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/yahoo.com/favicon.ico"},1572977:{category_id:24,name:"Friendster"},1572978:{category_id:24,name:"Ameba"},1572980:{category_id:24,name:"Bebo social network"},1572981:{category_id:24,name:"Kaixin"},1572983:{category_id:24,name:"Orkut"},1572985:{category_id:24,name:"Aol-Answers",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/aol.com/favicon.ico"},1572987:{category_id:24,name:"CoolTalk social network"},1572988:{category_id:24,name:"RenRen.com"},1572989:{category_id:24,name:"TweetDeck"},1572990:{category_id:24,name:"Hootsuite"},1572998:{category_id:24,name:"Xing"},1572999:{category_id:24,name:"Lokalisten"},1573000:{category_id:24,name:"meinVZ/studiVZ"},1573004:{category_id:24,name:"Viadeo"},1573005:{category_id:24,name:"Tuenti"},1573006:{category_id:24,name:"Hyves"},1573007:{category_id:24,name:"Mixi.jp"},1573008:{category_id:24,name:"Yahoo-mbga.jp",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/yahoo.com/favicon.ico"},1573009:{category_id:24,name:"Gree.jp"},1573010:{category_id:24,name:"Netlog"},1573011:{category_id:24,name:"2ch"},1573014:{category_id:24,name:"LoveTheseCurves"},1573015:{category_id:24,name:"Weibo"},1573016:{category_id:24,name:"Google-plus",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/google.com/favicon.ico"},1573017:{category_id:24,name:"Skyrock"},1573018:{category_id:24,name:"51.com"},1573019:{category_id:24,name:"Jackd(M)"},1573020:{category_id:24,name:"Touch(M)"},1573021:{category_id:24,name:"Skout(M)"},1573022:{category_id:24,name:"Instagram",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/instagram.com/favicon.ico"},1573023:{category_id:24,name:"Jiayuan"},1573024:{category_id:24,name:"Zoosk(M)"},1573025:{category_id:24,name:"DatingDNA(M)"},1573026:{category_id:24,name:"500px"},1573027:{category_id:24,name:"Socialcam(M)"},1573028:{category_id:24,name:"iAround(M)"},1573029:{category_id:24,name:"MomoChat(M)"},1573030:{category_id:24,name:"Path(M)"},1573031:{category_id:24,name:"WeHeartIt"},1573032:{category_id:24,name:"Fancy(M)"},1573033:{category_id:24,name:"Vine(M)"},1573035:{category_id:24,name:"Miliao"},16:{category_id:0,name:"Omegle"},16777215:{category_id:255,name:"Unknown"},17:{category_id:0,name:"IPMSG"},18:{category_id:0,name:"Aliww"},1835009:{category_id:28,name:"LiveJasmin"},1835010:{category_id:28,name:"Youporn"},1835011:{category_id:28,name:"XNXX Galleries"},1835012:{category_id:28,name:"Adult Friendfinder"},1835013:{category_id:28,name:"FreeOnes"},1835014:{category_id:28,name:"Streamate"},1835015:{category_id:28,name:"Fling"},1835016:{category_id:28,name:"Literotica.Com"},1835017:{category_id:28,name:"Adam4Adam"},1835018:{category_id:28,name:"Playboy Digital"},1835019:{category_id:28,name:"VICE"},1835020:{category_id:28,name:"Manhunt"},1835021:{category_id:28,name:"GayRomeo"},1835022:{category_id:28,name:"Newgrounds"},1835023:{category_id:28,name:"Payserve"},1835024:{category_id:28,name:"eBaums World"},1835025:{category_id:28,name:"Flirt4Free"},1835026:{category_id:28,name:"Be Naughty"},1835027:{category_id:28,name:"Debonairblog"},1835028:{category_id:28,name:"AEBN"},1835029:{category_id:28,name:"FetLife"},1835030:{category_id:28,name:"ImLive"},1835031:{category_id:28,name:"Video Sex Archive"},1835032:{category_id:28,name:"Mr. Skin"},1835033:{category_id:28,name:"Clips4Sale"},1835034:{category_id:28,name:"Femjoy"},1835035:{category_id:28,name:"HQ Porn Links"},1835036:{category_id:28,name:"The Voyeurweb"},1835037:{category_id:28,name:"Alt.Sex.Stories Text Repository"},1835038:{category_id:28,name:"Xcams"},1835039:{category_id:28,name:"AV Entertainments"},1835040:{category_id:28,name:"Indian Sex Stories"},1835041:{category_id:28,name:"World Sex"},1835042:{category_id:28,name:"Fur Affinity"},1835043:{category_id:28,name:"Celebrity Movie Archive"},1835044:{category_id:28,name:"The Erotic Review"},1835045:{category_id:28,name:"Internet Adult Film Database"},1835046:{category_id:28,name:"Shoosh Time"},1835047:{category_id:28,name:"Thumblogger"},1835048:{category_id:28,name:"First Time Videos"},1835049:{category_id:28,name:"The Huns Yellow Pages"},1835050:{category_id:28,name:"CollarMe"},1835051:{category_id:28,name:"Sex in the UK"},1835052:{category_id:28,name:"Links Hit"},1835053:{category_id:28,name:"Peachy Forum"},1835054:{category_id:28,name:"Swing Life Style"},1835055:{category_id:28,name:"Scoreland Tits"},1835056:{category_id:28,name:"Girlfriend Videos"},1835057:{category_id:28,name:"Digital Playground"},1835058:{category_id:28,name:"Penthouse"},1835059:{category_id:28,name:"Squirt.org"},1835060:{category_id:28,name:"MPL Studios"},1835061:{category_id:28,name:"Wicked Weasel Bikinis"},1835062:{category_id:28,name:"Nifty Erotic Stories Archive"},1835063:{category_id:28,name:"VideoBox"},1835064:{category_id:28,name:"EdenFantasys"},1835065:{category_id:28,name:"Vintage Erotica Forum"},1835066:{category_id:28,name:"PHE"},1835067:{category_id:28,name:"DudesNude"},1835068:{category_id:28,name:"Heaven 666"},1835069:{category_id:28,name:"GameLink"},1835070:{category_id:28,name:"Ask Jolene"},1835071:{category_id:28,name:"Polyner Artist Web Ring"},1835072:{category_id:28,name:"VirtuaGirl 2"},1835073:{category_id:28,name:"Inthecrack"},1835074:{category_id:28,name:"Suicide Girls"},1835075:{category_id:28,name:"Fleshbot"},1835076:{category_id:28,name:"Oglaf"},1835077:{category_id:28,name:"ALS Scan"},1835078:{category_id:28,name:"Odloty"},1835079:{category_id:28,name:"Southern Charms"},1835080:{category_id:28,name:"Fab Swingers"},1835081:{category_id:28,name:"The Stile Project"},1835082:{category_id:28,name:"Hentai Foundry"},1835083:{category_id:28,name:"Adult DVD Empire"},1835084:{category_id:28,name:"Webcams"},1835085:{category_id:28,name:"Cityvibe"},1835086:{category_id:28,name:"Manjam"},1835087:{category_id:28,name:"XBIZ"},1835088:{category_id:28,name:"Rogan"},1835089:{category_id:28,name:"AVN Media Network"},1835090:{category_id:28,name:"Fleshlight"},1835091:{category_id:28,name:"Fucking Machines"},1835092:{category_id:28,name:"Recon"},1835093:{category_id:28,name:"Hogtied"},1835094:{category_id:28,name:"Swingers Date Club"},1835095:{category_id:28,name:"Sex Toys Uk"},1835096:{category_id:28,name:"Lush Sex Stories"},1835097:{category_id:28,name:"NiteFlirt"},1835098:{category_id:28,name:"Wife Lovers"},1835099:{category_id:28,name:"Sucksex"},1835100:{category_id:28,name:"Project Voyeur"},1835101:{category_id:28,name:"Fritchy Forums"},1835102:{category_id:28,name:"AL4A"},1835103:{category_id:28,name:"What The Fuck!?"},1835104:{category_id:28,name:"Kaktuz"},1835105:{category_id:28,name:"Rabbits Reviews"},1835106:{category_id:28,name:"Truth or Dare Pics"},1835107:{category_id:28,name:"Sunny Leone"},1835108:{category_id:28,name:"SPAcash"},19:{category_id:0,name:"Mail.ru IM"},1900545:{category_id:29,name:"The Internet Movie Database"},1900546:{category_id:29,name:"BBC Online"},1900547:{category_id:29,name:"CNN Interactive",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/cnn.com/favicon.ico"},1900548:{category_id:29,name:"ESPN.com",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/espn.go.com/favicon.ico"},1900549:{category_id:29,name:"The Weather Channel"},1900550:{category_id:29,name:"FoxNews"},1900551:{category_id:29,name:"deviantART"},1900552:{category_id:29,name:"Yahoo! Movies",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/yahoo.com/favicon.ico"},1900553:{category_id:29,name:"NBC News"},1900554:{category_id:29,name:"Yahoo! TV",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/yahoo.com/favicon.ico"},1900555:{category_id:29,name:"ABCNews"},1900556:{category_id:29,name:"NDTV"},1900557:{category_id:29,name:"CBS News"},1900558:{category_id:29,name:"CNN/Money",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/cnn.com/favicon.ico"},1900559:{category_id:29,name:"TMZ"},1900560:{category_id:29,name:"CNBC"},1900561:{category_id:29,name:"Wired"},1900562:{category_id:29,name:"Fox Sports Network"},1900563:{category_id:29,name:"CNN/SI Network Page",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/cnn.com/favicon.ico"},1900564:{category_id:29,name:"Rotten Tomatoes"},1900565:{category_id:29,name:"Disney"},1900566:{category_id:29,name:"Urban Dictionary"},1900567:{category_id:29,name:"Food Network"},1900568:{category_id:29,name:"British Sky Broadcasting"},1900569:{category_id:29,name:"NPR Online- National Public Radio"},1900570:{category_id:29,name:"Gawker"},1900571:{category_id:29,name:"Last.fm"},1900572:{category_id:29,name:"Comcast Corporation"},1900573:{category_id:29,name:"ABC"},1900574:{category_id:29,name:"CBS"},1900575:{category_id:29,name:"Salon"},1900576:{category_id:29,name:"CBC Television"},1900577:{category_id:29,name:"E Online"},1900578:{category_id:29,name:"FanFiction.Net"},1900579:{category_id:29,name:"Ultimate Guitar Archive"},1900580:{category_id:29,name:"Deezer.com"},1900581:{category_id:29,name:"Fandango"},1900582:{category_id:29,name:"Copyscape"},1900583:{category_id:29,name:"A-Z Lyrics"},1900584:{category_id:29,name:"Atlantic Online"},1900585:{category_id:29,name:"Discovery Channel"},1900586:{category_id:29,name:"Australian Broadcasting Corporation"},1900587:{category_id:29,name:"Egotastic"},1900588:{category_id:29,name:"NBC"},1900589:{category_id:29,name:"MetroLyrics"},1900590:{category_id:29,name:"TV Guide"},1900591:{category_id:29,name:"MTV"},1900592:{category_id:29,name:"Entertainment Weekly"},1900593:{category_id:29,name:"ksl"},1900594:{category_id:29,name:"World Wrestling Entertainment"},1900595:{category_id:29,name:"Cartoon Network"},1900596:{category_id:29,name:"xkcd"},1900597:{category_id:29,name:"SkyscraperCity"},1900598:{category_id:29,name:"DIRECTV"},1900599:{category_id:29,name:"Discogs"},1900600:{category_id:29,name:"PBS Online"},1900601:{category_id:29,name:"PBS Kids!"},1900602:{category_id:29,name:"The Hollywood Reporter"},1900603:{category_id:29,name:"Nickelodeon"},1900604:{category_id:29,name:"TV"},1900605:{category_id:29,name:"Ravelry"},1900606:{category_id:29,name:"Nick Jr."},1900607:{category_id:29,name:"Rollingstone Magazine"},1900608:{category_id:29,name:"India Forums "},1900609:{category_id:29,name:"Deutsche Welle Radio"},1900610:{category_id:29,name:"Cox Communications"},1900611:{category_id:29,name:"Voice of America"},1900612:{category_id:29,name:"AMC"},1900613:{category_id:29,name:"Metacritic"},1900614:{category_id:29,name:"Islamic Republic of Iran Broadcasting"},1900615:{category_id:29,name:"goComics"},1900616:{category_id:29,name:"The New Yorker"},1900617:{category_id:29,name:"B92"},1900618:{category_id:29,name:"Moviefone"},1900619:{category_id:29,name:"Lyrics Freak"},1900620:{category_id:29,name:"Oprah"},1900621:{category_id:29,name:"Comedy Central"},1900622:{category_id:29,name:"Veoh"},1900623:{category_id:29,name:"Box Office Mojo"},1900624:{category_id:29,name:"All Music Guide"},1900625:{category_id:29,name:"Billboard"},1900626:{category_id:29,name:"RAI"},1900627:{category_id:29,name:"Home and Garden Television (HGTV)"},1900628:{category_id:29,name:"Canon World Wide Gateway"},1900629:{category_id:29,name:"Lorem Ipsum"},1966081:{category_id:30,name:"PayPal",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/paypal.com/favicon.ico"},1966082:{category_id:30,name:"Alibaba"},1966083:{category_id:30,name:"Yahoo! Finance",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/yahoo.com/favicon.ico"},1966084:{category_id:30,name:"Bank of America",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/bankofamerica.com/favicon.ico"},1966085:{category_id:30,name:"Chase Bank",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/chase.com/favicon.ico"},1966086:{category_id:30,name:"Wells Fargo",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/wellsfargo.com/favicon.ico"},1966087:{category_id:30,name:"The Wall Street Journal Interactive Edition"},1966088:{category_id:30,name:"Samsung Electronics"},1966089:{category_id:30,name:"UPS"},196609:{category_id:3,name:"FTP Applications"},1966090:{category_id:30,name:"Target Corporation",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/target.com/favicon.ico"},1966091:{category_id:30,name:"Reuters Group PLC"},1966092:{category_id:30,name:"Indeed"},1966093:{category_id:30,name:"Forbes Magazine"},1966094:{category_id:30,name:"Constant Contact"},1966095:{category_id:30,name:"Shutterstock"},1966096:{category_id:30,name:"ClickBank"},1966097:{category_id:30,name:"AT&T"},1966098:{category_id:30,name:"American Express"},1966099:{category_id:30,name:"FedEx"},196610:{category_id:3,name:"GetRight"},1966100:{category_id:30,name:"EzineArticles"},1966101:{category_id:30,name:"Commission Junction"},1966102:{category_id:30,name:"TechCrunch"},1966103:{category_id:30,name:"HDFC Bank Ltd."},1966104:{category_id:30,name:"Verizon Wireless"},1966105:{category_id:30,name:"Freelancer"},1966106:{category_id:30,name:"iStockphoto"},1966107:{category_id:30,name:"Bloomberg"},1966108:{category_id:30,name:"Capital One Financial Corp."},1966109:{category_id:30,name:"Fotolia"},196611:{category_id:3,name:"FlashGet"},1966110:{category_id:30,name:"ICICI Bank"},1966111:{category_id:30,name:"123RF Royalty Free Stock Photos"},1966112:{category_id:30,name:"Zillow",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/zillow.com/favicon.ico"},1966113:{category_id:30,name:"Monster"},1966114:{category_id:30,name:"TradeDoubler"},1966115:{category_id:30,name:"Industrial and Commercial Bank of China"},1966116:{category_id:30,name:"Nokia"},1966117:{category_id:30,name:"Sears"},1966118:{category_id:30,name:"CNET News"},1966119:{category_id:30,name:"Indian Railways"},196612:{category_id:3,name:"AsianDVDClub"},1966120:{category_id:30,name:"The Sun"},1966121:{category_id:30,name:"Verizon Corporation"},1966122:{category_id:30,name:"Elance"},1966123:{category_id:30,name:"CareerBuilder"},1966124:{category_id:30,name:"Citibank U.S."},1966125:{category_id:30,name:"GetResponse Email Marketing"},1966126:{category_id:30,name:"Business Week"},1966127:{category_id:30,name:"MarketWatch"},1966128:{category_id:30,name:"Shareasale"},1966129:{category_id:30,name:"SiteSell"},196613:{category_id:3,name:"Web File Transfer"},1966130:{category_id:30,name:"Manta"},1966131:{category_id:30,name:"Eventbrite"},1966132:{category_id:30,name:"Citibank Online"},1966133:{category_id:30,name:"Dreamstime Stock Photography"},1966134:{category_id:30,name:"Costco Wholesale Corporation"},1966135:{category_id:30,name:"H&M"},1966136:{category_id:30,name:"Merriam-Webster"},1966137:{category_id:30,name:"The Economic Times"},1966138:{category_id:30,name:"U.S. Bank"},1966139:{category_id:30,name:"TD Bank"},196614:{category_id:3,name:"FileZilla"},1966140:{category_id:30,name:"Intel Corp"},1966141:{category_id:30,name:"Zazzle"},1966142:{category_id:30,name:"Behance Network"},1966143:{category_id:30,name:"Commonwealth Bank of Australia"},1966144:{category_id:30,name:"La Caja de Ahorros y Pensiones de Barcelona"},1966145:{category_id:30,name:"ZDNet"},1966146:{category_id:30,name:"Realtor"},1966147:{category_id:30,name:"New York Post Online Edition"},1966148:{category_id:30,name:"glispa"},1966149:{category_id:30,name:"Financial Times News"},196615:{category_id:3,name:"Kuaipan"},1966150:{category_id:30,name:"SitePoint"},1966151:{category_id:30,name:"T-Mobile"},1966152:{category_id:30,name:"National Hurricane Center"},1966153:{category_id:30,name:"ForexFactory"},1966154:{category_id:30,name:"Sprint"},1966155:{category_id:30,name:"Sony Electronics"},1966156:{category_id:30,name:"VistaPrint"},1966157:{category_id:30,name:"MOJO Works"},1966158:{category_id:30,name:"TD Canada Trust"},1966159:{category_id:30,name:"Zara"},196616:{category_id:3,name:"DBank"},1966160:{category_id:30,name:"Cisco"},1966161:{category_id:30,name:"WebMoney Transfer"},1966162:{category_id:30,name:"Fidelity Investments"},1966163:{category_id:30,name:"USAA"},1966164:{category_id:30,name:"Discover Financial Services"},1966165:{category_id:30,name:"Lego Company"},1966166:{category_id:30,name:"Axis Bank"},1966167:{category_id:30,name:"The Economist"},1966168:{category_id:30,name:"Kmart"},1966169:{category_id:30,name:"Inc"},196617:{category_id:3,name:"115.com"},1966170:{category_id:30,name:"Univision"},1966171:{category_id:30,name:"DHL Worldwide Express"},1966172:{category_id:30,name:"PNC Financial Services Group"},1966173:{category_id:30,name:"WebEx Communications"},196618:{category_id:3,name:"Weiyun"},196619:{category_id:3,name:"Rayfile"},196620:{category_id:3,name:"0zz0"},196621:{category_id:3,name:"Herosh"},196622:{category_id:3,name:"2Shared"},196624:{category_id:3,name:"BIZHARD"},196626:{category_id:3,name:"UPlusBox"},196627:{category_id:3,name:"Filebox.ro"},196628:{category_id:3,name:"Qnext"},196629:{category_id:3,name:"OneDrive"},196630:{category_id:3,name:"YunFile"},196631:{category_id:3,name:"Filehosting"},196632:{category_id:3,name:"Dev-Host"},196633:{category_id:3,name:"Solidfiles"},196634:{category_id:3,name:"IBackup"},196635:{category_id:3,name:"FileSwap"},196637:{category_id:3,name:"Temp-Share"},196638:{category_id:3,name:"WikiUpload"},196640:{category_id:3,name:"MEGA"},196641:{category_id:3,name:"Copy.com"},196642:{category_id:3,name:"4Shared"},196643:{category_id:3,name:"HiCloud"},196644:{category_id:3,name:"Depositfiles"},196645:{category_id:3,name:"Docstoc"},196646:{category_id:3,name:"360 Cloud"},196647:{category_id:3,name:"Symantec Nomdb"},196648:{category_id:3,name:"Baidu Cloud"},196649:{category_id:3,name:"GitHub"},196650:{category_id:3,name:"FileDropper"},196651:{category_id:3,name:"CrashPlan"},196652:{category_id:3,name:"Net2FTP"},196653:{category_id:3,name:"Mediafire"},196655:{category_id:3,name:"Carbonite"},196656:{category_id:3,name:"Mozy"},196657:{category_id:3,name:"SOS Online Backup"},196669:{category_id:3,name:"cute-ftp(HTTP)"},196676:{category_id:3,name:"Box"},196678:{category_id:3,name:"Scribd"},196680:{category_id:3,name:"Rapidshare"},196681:{category_id:3,name:"Sendspace"},196683:{category_id:3,name:"Hightail"},196684:{category_id:3,name:"Diino"},196686:{category_id:3,name:"Fluxiom"},196689:{category_id:3,name:"Nomadesk"},196692:{category_id:3,name:"Dropbox"},196693:{category_id:3,name:"Filesend.to"},196694:{category_id:3,name:"Firestorage"},196695:{category_id:3,name:"Naver Ndrive"},196696:{category_id:3,name:"Filesend.net"},196697:{category_id:3,name:"Crocko"},196700:{category_id:3,name:"Fileserve"},196701:{category_id:3,name:"Netload"},196702:{category_id:3,name:"Megashares"},196703:{category_id:3,name:"TransferBigFiles"},196705:{category_id:3,name:"Filemail"},196706:{category_id:3,name:"Zamzar"},196708:{category_id:3,name:"Divshare"},196709:{category_id:3,name:"DL Free"},196711:{category_id:3,name:"Nakido"},196713:{category_id:3,name:"Gigaup"},196714:{category_id:3,name:"Filestube"},196716:{category_id:3,name:"Filer.cx"},196717:{category_id:3,name:"Cx.com"},196718:{category_id:3,name:"Elephantdrive"},196722:{category_id:3,name:"Zshare"},196723:{category_id:3,name:"Freakshare"},196724:{category_id:3,name:"Uploading"},196725:{category_id:3,name:"Bitshare"},196726:{category_id:3,name:"Letitbit.net"},196727:{category_id:3,name:"Extabit"},196728:{category_id:3,name:"Filefactory"},196729:{category_id:3,name:"Furk"},196731:{category_id:3,name:"GoldFile"},196732:{category_id:3,name:"GigaSize"},196733:{category_id:3,name:"Turbobit"},196735:{category_id:3,name:"Hitfile"},196737:{category_id:3,name:"Zippyshare"},196738:{category_id:3,name:"SoundCloud"},196739:{category_id:3,name:"SpeedyShare"},196742:{category_id:3,name:"FilePost.net"},196743:{category_id:3,name:"GlumboUploads"},196744:{category_id:3,name:"RapidGator.net"},196746:{category_id:3,name:"Clip2net"},196747:{category_id:3,name:"Datei.to"},196748:{category_id:3,name:"Totodisk"},196749:{category_id:3,name:"LeapFile"},196750:{category_id:3,name:"BigUpload"},196751:{category_id:3,name:"OnlineFileFolder"},196752:{category_id:3,name:"ASUSWebStorage"},196753:{category_id:3,name:"File-Upload.net"},196754:{category_id:3,name:"File-Works"},196755:{category_id:3,name:"Zumodrive"},196756:{category_id:3,name:"PutLocker"},196757:{category_id:3,name:"Wetransfer"},196758:{category_id:3,name:"iCloud",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/apple.com/favicon.ico"},196759:{category_id:3,name:"CloudMe"},196760:{category_id:3,name:"Beanywhere"},196761:{category_id:3,name:"Sugarsync"},196762:{category_id:3,name:"DriveHQ"},196764:{category_id:3,name:"Backblaze"},196765:{category_id:3,name:"AirSet"},196766:{category_id:3,name:"SpiderOak"},196767:{category_id:3,name:"1337X"},196768:{category_id:3,name:"MailBigFile"},196769:{category_id:3,name:"GoldCoupon.co.kr"},196770:{category_id:3,name:"Egnyte"},196771:{category_id:3,name:"SmugMug"},196772:{category_id:3,name:"SlideShare.net"},196773:{category_id:3,name:"4Sync"},196774:{category_id:3,name:"IDrive"},196775:{category_id:3,name:"Mendeley"},196777:{category_id:3,name:"Daum-cloud"},2:{category_id:0,name:"Yahoo Messenger",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/yahoo.com/favicon.ico"},20:{category_id:0,name:"Kubao"},2031617:{category_id:31,name:"Yahoo!",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/yahoo.com/favicon.ico"},2031618:{category_id:31,name:"Yahoo! Mail",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/yahoo.com/favicon.ico"},2031619:{category_id:31,name:"Windows Live Hotmail"},2031620:{category_id:31,name:"Yahoo! Search",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/yahoo.com/favicon.ico"},2031621:{category_id:31,name:"Google Docs",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/google.com/favicon.ico"},2031622:{category_id:31,name:"Alexa Internet"},2031623:{category_id:31,name:"Bing",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/bing.com/favicon.ico"},2031624:{category_id:31,name:"Babylon"},2031625:{category_id:31,name:"Google+",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/google.com/favicon.ico"},2031626:{category_id:31,name:"Microsoft Corporation",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/microsoft.com/favicon.ico"},2031627:{category_id:31,name:"Apple Inc.",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/apple.com/favicon.ico"},2031628:{category_id:31,name:"Go"},2031629:{category_id:31,name:"Ask"},2031630:{category_id:31,name:"Adobe Systems Incorporated"},2031631:{category_id:31,name:"AVG | Antivirus and Security Software"},2031632:{category_id:31,name:"The Pirate Bay"},2031633:{category_id:31,name:"www.ZEDO"},2031634:{category_id:31,name:"Babylon Search"},2031635:{category_id:31,name:"Stack Overflow"},2031636:{category_id:31,name:"About"},2031637:{category_id:31,name:"Google Adwords",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/google.com/favicon.ico"},2031638:{category_id:31,name:"Imgur.com",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/imgur.com/favicon.ico"},2031639:{category_id:31,name:"Go Daddy"},2031640:{category_id:31,name:"Google Play",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/google.com/favicon.ico"},2031641:{category_id:31,name:"Vimeo.com"},2031642:{category_id:31,name:"The Apple Store",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/apple.com/favicon.ico"},2031643:{category_id:31,name:"Badoo.Com"},2031644:{category_id:31,name:"AWeber Systems"},2031645:{category_id:31,name:"SourceForge"},2031646:{category_id:31,name:"SlideShare"},2031647:{category_id:31,name:"Mozilla"},2031648:{category_id:31,name:"Wikia",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/wikia.com/favicon.ico"},2031649:{category_id:31,name:"Google AdSense",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/google.com/favicon.ico"},2031650:{category_id:31,name:"Fiverr"},2031651:{category_id:31,name:"Photobucket image hosting and photo sharing"},2031652:{category_id:31,name:"Clicksor"},2031653:{category_id:31,name:"HootSuite Social Media Dashboard"},2031654:{category_id:31,name:"1-Click Answers"},2031655:{category_id:31,name:"StatCounter"},2031656:{category_id:31,name:"CNET Download"},2031657:{category_id:31,name:"Rediff"},2031658:{category_id:31,name:"My Yahoo",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/yahoo.com/favicon.ico"},2031659:{category_id:31,name:"The Internet Archive"},2031660:{category_id:31,name:"isoHunt"},2031661:{category_id:31,name:"DomainTools"},2031662:{category_id:31,name:"CNET"},2031663:{category_id:31,name:"GitHub.com"},2031664:{category_id:31,name:"Host Gator"},2031665:{category_id:31,name:"PHP"},2031666:{category_id:31,name:"GMX"},2031667:{category_id:31,name:"Microsoft Developer Network",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/msdn.com/favicon.ico"},2031668:{category_id:31,name:"ImageShack"},2031669:{category_id:31,name:"Dell Inc."},2031670:{category_id:31,name:"Microsoft Office Online",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/microsoft.com/favicon.ico"},2031671:{category_id:31,name:"Mashable"},2031672:{category_id:31,name:"Digital Point Solutions"},2031673:{category_id:31,name:"Digital Point Forums"},2031674:{category_id:31,name:"Mail Chimp"},2031675:{category_id:31,name:"Joomla!"},2031676:{category_id:31,name:"TypePad"},2031677:{category_id:31,name:"SEOmoz.org"},2031678:{category_id:31,name:"Google Groups",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/google.com/favicon.ico"},2031679:{category_id:31,name:"Webs"},2031680:{category_id:31,name:"Speedtest.net"},2097153:{category_id:32,name:"IGN"},2097154:{category_id:32,name:"Publishers Clearing House"},2097155:{category_id:32,name:"MiniClip"},2097156:{category_id:32,name:"888"},2097157:{category_id:32,name:"Xbox"},2097158:{category_id:32,name:"GameSpot"},2097159:{category_id:32,name:"Steam"},2097160:{category_id:32,name:"League of Legends"},2097161:{category_id:32,name:"GameFAQs"},2097162:{category_id:32,name:"Yahoo! Games",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/yahoo.com/favicon.ico"},2097163:{category_id:32,name:"William Hill Online"},2097164:{category_id:32,name:"Electronic Arts"},2097165:{category_id:32,name:"Betfair"},2097166:{category_id:32,name:"Wowhead"},2097167:{category_id:32,name:"World of PlayStation"},2097168:{category_id:32,name:"Kongregate"},2097169:{category_id:32,name:"Hattrick"},2097170:{category_id:32,name:"Roblox"},2097171:{category_id:32,name:"King"},2097172:{category_id:32,name:"Chess"},2097173:{category_id:32,name:"Ubi Soft Entertainment"},2097174:{category_id:32,name:"Minepedia"},2097175:{category_id:32,name:"Call of Duty"},2097176:{category_id:32,name:"Addictinggames"},2097177:{category_id:32,name:"MMO-Champion"},2097178:{category_id:32,name:"Bet at Home"},2097179:{category_id:32,name:"FreeLotto"},2097180:{category_id:32,name:"Square Enix"},2097181:{category_id:32,name:"PlayStation"},2097182:{category_id:32,name:"Travian"},2097183:{category_id:32,name:"MSN Gaming Zone",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/msn.com/favicon.ico"},2097184:{category_id:32,name:"Games"},2097185:{category_id:32,name:"Rockstar Games"},2097186:{category_id:32,name:"N4G"},2097187:{category_id:32,name:"Planet Minecraft"},2097188:{category_id:32,name:"Nvidia"},2097189:{category_id:32,name:"FreeOnlineGames"},2097190:{category_id:32,name:"Nintendo of America"},2097191:{category_id:32,name:"PopCap Games"},2097192:{category_id:32,name:"Game Trailers"},2097193:{category_id:32,name:"Covers"},2097194:{category_id:32,name:"California Lottery"},2097195:{category_id:32,name:"Team Liquid"},2097196:{category_id:32,name:"Eurogamer.net"},2097197:{category_id:32,name:"Party Casino"},2097198:{category_id:32,name:"Game Informer"},2097199:{category_id:32,name:"Penny Arcade"},2097200:{category_id:32,name:"GiantBomb"},2097201:{category_id:32,name:"GameHouse"},2097202:{category_id:32,name:"Curse"},2097203:{category_id:32,name:"Star Wars"},2097204:{category_id:32,name:"PC Gamer Online"},2097205:{category_id:32,name:"BoardGameGeek"},2097206:{category_id:32,name:"Bet365 Affiliates"},2097207:{category_id:32,name:"Bulbagarden / Bulbapedia"},2097208:{category_id:32,name:"OGame.org"},2097209:{category_id:32,name:"Space Federation"},2097210:{category_id:32,name:"Hasbro"},2097211:{category_id:32,name:"Enjin"},2097212:{category_id:32,name:"Perfect World Entertainment"},2097213:{category_id:32,name:"Ladbrokes"},2097214:{category_id:32,name:"Florida Lottery"},2097215:{category_id:32,
name:"Paddy Power"},2097216:{category_id:32,name:"Shockwave"},2097217:{category_id:32,name:"Virtua Fighter 4"},2097218:{category_id:32,name:"Cheat Code Central"},2097219:{category_id:32,name:"Bukkit"},2097220:{category_id:32,name:"Oddschecker"},2097221:{category_id:32,name:"Xbox Media Center"},2097222:{category_id:32,name:"BioWare"},2097223:{category_id:32,name:"WoWWiki"},2097224:{category_id:32,name:"Games Radar US"},2097225:{category_id:32,name:"G4 TV"},2097226:{category_id:32,name:"JigZone"},2097227:{category_id:32,name:"Two Plus Two Publishing"},2097228:{category_id:32,name:"Win Every Game"},2097229:{category_id:32,name:"Zylom"},2097230:{category_id:32,name:"Station"},2097231:{category_id:32,name:"Blizzard.com"},2097232:{category_id:32,name:"Super Cheats"},2097233:{category_id:32,name:"TheSims3"},2097234:{category_id:32,name:"Computer and Video Games"},2097235:{category_id:32,name:"Xbox 360 Achievements"},2097236:{category_id:32,name:"Soccer Manager"},2097237:{category_id:32,name:"FreeGamePick"},2097238:{category_id:32,name:"Battlefield Play4Free"},2097239:{category_id:32,name:"The Trivia Portal"},2097240:{category_id:32,name:"VG247"},2097241:{category_id:32,name:"Affiliates United"},2097242:{category_id:32,name:"Stardock"},2097243:{category_id:32,name:"Gearbox Software"},2097244:{category_id:32,name:"sporcle"},2097245:{category_id:32,name:"Gamasutra"},2097246:{category_id:32,name:"Poker News"},2097247:{category_id:32,name:"Nexon America Inc."},21:{category_id:0,name:"Lava-Lava"},2162689:{category_id:33,name:"National Institutes of Health (NIH)"},2162690:{category_id:33,name:"WebMD"},2162691:{category_id:33,name:"PubMed"},2162692:{category_id:33,name:"MayoClinic"},2162693:{category_id:33,name:"Medicine Net"},2162694:{category_id:33,name:"Natural Health Information Articles and Health Newsletter by Dr. Joseph Mercola"},2162695:{category_id:33,name:"Drugs"},2162696:{category_id:33,name:"Mens Health"},2162697:{category_id:33,name:"MedlinePlus"},2162698:{category_id:33,name:"WeightWatchers"},2162699:{category_id:33,name:"Centers for Disease Control and Prevention"},2162700:{category_id:33,name:"Psychology Today"},2162701:{category_id:33,name:"Calorie Count"},2162702:{category_id:33,name:"AIDS Patent Database"},2162703:{category_id:33,name:"Dr. Batras"},2162704:{category_id:33,name:"Medscape"},2162705:{category_id:33,name:"nhs.uk"},2162706:{category_id:33,name:"Kaiser Permanente"},2162707:{category_id:33,name:"who.int"},2162708:{category_id:33,name:"Health Boards"},2162709:{category_id:33,name:"Health Media Ventures"},2162710:{category_id:33,name:"KidsHealth"},2162711:{category_id:33,name:"Food and Drug Administration"},2162712:{category_id:33,name:"Self Magazine"},2162713:{category_id:33,name:"Makeup Alley"},2162714:{category_id:33,name:"HealthCentral"},2162715:{category_id:33,name:"Prevention Magazine"},2162716:{category_id:33,name:"RealAge"},2162717:{category_id:33,name:"NetDoctor"},2162718:{category_id:33,name:"FEMA"},2162719:{category_id:33,name:"Fitness Magazine"},2162720:{category_id:33,name:"Vitals"},2162721:{category_id:33,name:"Total Beauty"},2162722:{category_id:33,name:"RxList"},2162723:{category_id:33,name:"British Medical Journal"},2162724:{category_id:33,name:"Steve Pavlina"},2162725:{category_id:33,name:"American Psychological Association"},2162726:{category_id:33,name:"MedcoHealth"},2162727:{category_id:33,name:"eMedTV Health Information"},2162728:{category_id:33,name:"American Cancer Society"},2162729:{category_id:33,name:"Self Nutrition Data"},2162730:{category_id:33,name:"Nuance Communications"},2162731:{category_id:33,name:"Tehran University of Medical Sciences"},2162732:{category_id:33,name:"Weil Lifestyle"},2162733:{category_id:33,name:"Wellness"},2162734:{category_id:33,name:"PatientUK"},2162735:{category_id:33,name:"National Cancer Institute"},2162736:{category_id:33,name:"24 Hour Fitness"},2162737:{category_id:33,name:"San Diego State University Graduate School of Public Health"},2162738:{category_id:33,name:"Telegraph Health"},2162739:{category_id:33,name:"Earth Clinic"},2162740:{category_id:33,name:"Mens Fitness"},2162741:{category_id:33,name:"Anthony Robbins"},2162742:{category_id:33,name:"Health Guru"},2162743:{category_id:33,name:"Cleveland Clinic"},2162744:{category_id:33,name:"BioMed Central"},2162745:{category_id:33,name:"Become Gorgeous"},2162746:{category_id:33,name:"The Student Doctor Network"},2162747:{category_id:33,name:"The New England Journal of Medicine"},2162748:{category_id:33,name:"American Diabetes Association"},2162749:{category_id:33,name:"Spine Health"},2162750:{category_id:33,name:"Social Anxiety Support"},2162751:{category_id:33,name:"Institute for Integrative Nutrition"},2162752:{category_id:33,name:"The Penis Exercise Forum"},2162753:{category_id:33,name:"3 Fat Chicks on a Diet!"},2162754:{category_id:33,name:"NaturallyCurly"},2162755:{category_id:33,name:"Allnurses"},2162756:{category_id:33,name:"Cure Zone"},2162757:{category_id:33,name:"DocCheck"},2162758:{category_id:33,name:"menshealth.co.uk"},2162759:{category_id:33,name:"Occupational Safety &amp; Health Administration"},2162760:{category_id:33,name:"Planned Parenthood Federation of America"},2162761:{category_id:33,name:"DrRobertRey"},2162762:{category_id:33,name:"Sutter Health"},2162763:{category_id:33,name:"My Home Remedies"},2162764:{category_id:33,name:"Lab Tests Online"},2162765:{category_id:33,name:"American Academy of Family Physicians"},2162766:{category_id:33,name:"American Medical Association"},2162767:{category_id:33,name:"Shiraz University of Medical Sciences"},2162768:{category_id:33,name:"PetMD"},2162769:{category_id:33,name:"Health and Safety Executive"},2162770:{category_id:33,name:"SCORE Counselors to Americas Small Business"},2162771:{category_id:33,name:"Laboratory Corporation of America"},2162772:{category_id:33,name:"Alzheimer s Association"},2162773:{category_id:33,name:"Isfahan University of Medical Sciences"},2162774:{category_id:33,name:"National Institute of Diabetes and Digestive and Kidney Diseases"},2162775:{category_id:33,name:"Celiac Disease and Gluten-Free Diet Support Center"},2162776:{category_id:33,name:"Best Health"},2162777:{category_id:33,name:"Hairfinder Hair Fashion Portal"},2162778:{category_id:33,name:"Medical News Daily"},2162779:{category_id:33,name:"UKhairdressers"},22:{category_id:0,name:"PaltalkScene"},2228225:{category_id:34,name:"eHow"},2228226:{category_id:34,name:"Yelp",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/yelp.com/favicon.ico"},2228227:{category_id:34,name:"Groupon"},2228228:{category_id:34,name:"Engadget"},2228229:{category_id:34,name:"GSM Arena"},2228230:{category_id:34,name:"Allrecipes"},2228231:{category_id:34,name:"RetailMeNot"},2228232:{category_id:34,name:"CNET Reviews"},2228233:{category_id:34,name:"Coupons"},2228234:{category_id:34,name:"Gizmodo"},2228235:{category_id:34,name:"BabyCenter"},2228236:{category_id:34,name:"Yahoo! Shopping",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/yahoo.com/favicon.ico"},2228237:{category_id:34,name:"Nextag"},2228238:{category_id:34,name:"Toms Hardware Guide"},2228239:{category_id:34,name:"Yahoo Autos",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/yahoo.com/favicon.ico"},2228240:{category_id:34,name:"Digital Photography Review"},2228241:{category_id:34,name:"FixYa"},2228242:{category_id:34,name:"Instructables"},2228243:{category_id:34,name:"The Verge"},2228244:{category_id:34,name:"Shopping"},2228245:{category_id:34,name:"Better Business Bureau"},2228246:{category_id:34,name:"FatWallet"},2228247:{category_id:34,name:"CafeMom"},2228248:{category_id:34,name:"Internal Revenue Service"},2228249:{category_id:34,name:"The Motley Fool"},2228250:{category_id:34,name:"Edmunds"},2228251:{category_id:34,name:"bankrate"},2228252:{category_id:34,name:"Martha Stewart Living Omnimedia"},2228253:{category_id:34,name:"mobile9"},2228254:{category_id:34,name:"Kelley Blue Book"},2228255:{category_id:34,name:"Better Homes &amp; Gardens"},2228256:{category_id:34,name:"Consumer Reports Online"},2228257:{category_id:34,name:"Phone Arena"},2228258:{category_id:34,name:"Real Simple"},2228259:{category_id:34,name:"Apartment Therapy"},2228260:{category_id:34,name:"PriceGrabber"},2228261:{category_id:34,name:"Shopzilla"},2228262:{category_id:34,name:"Bureau of Consular Affairs"},2228263:{category_id:34,name:"Cooks"},2228264:{category_id:34,name:"Epinions"},2228265:{category_id:34,name:"bradsdeals"},2228266:{category_id:34,name:"MouthShut"},2228267:{category_id:34,name:"Blu-ray"},2228268:{category_id:34,name:"Epicurious"},2228269:{category_id:34,name:"Digital Trends"},2228270:{category_id:34,name:"Betty Crocker"},2228271:{category_id:34,name:"OpenDNS"},2228272:{category_id:34,name:"AOL Autos",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/aol.com/favicon.ico"},2228273:{category_id:34,name:"GardenWeb"},2228274:{category_id:34,name:"Ciao"},2228275:{category_id:34,name:"BGR"},2228276:{category_id:34,name:"Motor Trend Online"},2228277:{category_id:34,name:"Simply Recipes"},2228278:{category_id:34,name:"Rip-off Report"},2228279:{category_id:34,name:"Broadband Reports"},2228280:{category_id:34,name:"Kraft Foods Recipes"},2228281:{category_id:34,name:"Military"},2228282:{category_id:34,name:"Kaboodle"},2228283:{category_id:34,name:"DIY Network"},2228284:{category_id:34,name:"Apartment Therapys The Kitchn"},2228285:{category_id:34,name:"Parents"},2228286:{category_id:34,name:"The Pillsbury Company"},2228287:{category_id:34,name:"Care"},2228288:{category_id:34,name:"Ubergizmo"},2228289:{category_id:34,name:"EatingWell"},2228290:{category_id:34,name:"AVForums"},2228291:{category_id:34,name:"Cooking Light"},2228292:{category_id:34,name:"lifehack.org"},2228293:{category_id:34,name:"Carfax"},2228294:{category_id:34,name:"Social Security Administration"},2228295:{category_id:34,name:"Forums for the Chaotic Home"},2228296:{category_id:34,name:"This Old House Online"},2228297:{category_id:34,name:"ReviewCentre"},2228298:{category_id:34,name:"Kiplinger"},2228299:{category_id:34,name:"Coupon Mom"},2228300:{category_id:34,name:"Food &amp; Wine Online"},2228301:{category_id:34,name:"Jamie Oliver"},2228302:{category_id:34,name:"ConsumerSearch"},2228303:{category_id:34,name:"Geekologie"},2228304:{category_id:34,name:"Photography on the Net"},2228305:{category_id:34,name:"Medicare"},2228306:{category_id:34,name:"GasBuddy Organization Inc."},2228307:{category_id:34,name:"Complaints Board"},2228308:{category_id:34,name:"Good Housekeeping"},2228309:{category_id:34,name:"Pampers"},2228310:{category_id:34,name:"Southern Living Online"},2228311:{category_id:34,name:"Become"},2228312:{category_id:34,name:"Moms Who Think"},2228313:{category_id:34,name:"Mothering Magazine"},2228314:{category_id:34,name:"Think Baby Names"},2293761:{category_id:35,name:"Thesaurus"},2293762:{category_id:35,name:"Weebly"},2293763:{category_id:35,name:"ESPN Cricinfo"},2293764:{category_id:35,name:"Y8"},2293765:{category_id:35,name:"Universal Currency Converter"},2293766:{category_id:35,name:"Time and Date"},2293767:{category_id:35,name:"How Stuff Works"},2293768:{category_id:35,name:"Soccernet"},2293769:{category_id:35,name:"Reverso"},2293770:{category_id:35,name:"Stardoll"},2293771:{category_id:35,name:"000webhost"},2293772:{category_id:35,name:"Uefa"},2293773:{category_id:35,name:"The Toronto Star"},2293774:{category_id:35,name:"FIFA.com"},2293775:{category_id:35,name:"Girls Go Games"},2293776:{category_id:35,name:"Dynamic Drive DHTML Code Library"},2293777:{category_id:35,name:"Bureau of Meteorology"},2293778:{category_id:35,name:"ScienceDaily"},2293779:{category_id:35,name:"Manchester United Football Club"},2293780:{category_id:35,name:"Khan Academy"},2293781:{category_id:35,name:"Earthquake Information"},2293782:{category_id:35,name:"Barbie"},2293783:{category_id:35,name:"National Post"},2293784:{category_id:35,name:"WebDeveloper"},2293785:{category_id:35,name:"Starfall"},2293786:{category_id:35,name:"The Irish Times"},2293787:{category_id:35,name:"AOL Weather",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/aol.com/favicon.ico"},2293788:{category_id:35,name:"History Channel"},2293789:{category_id:35,name:"Honda Motor Co."},2293790:{category_id:35,name:"Space"},2293791:{category_id:35,name:"The Dilbert Zone"},2293792:{category_id:35,name:"Free Website Builder"},2293793:{category_id:35,name:"Warner Bros. Online"},2293794:{category_id:35,name:"Neopets"},2293795:{category_id:35,name:"USA.gov"},2293796:{category_id:35,name:"US Courts"},2293797:{category_id:35,name:"Popular Science"},2293798:{category_id:35,name:"Webopedia"},2293799:{category_id:35,name:"The Student Room"},2293800:{category_id:35,name:"Gaia Interactive"},2293801:{category_id:35,name:"Encyclopaedia Britannica Online"},2293802:{category_id:35,name:"New Scientist"},2293803:{category_id:35,name:"HTML Goodies"},2293804:{category_id:35,name:"Biography"},2293805:{category_id:35,name:"Maths Is Fun"},2293806:{category_id:35,name:"Archives"},2293807:{category_id:35,name:"Jet Propulsion Laboratory"},2293808:{category_id:35,name:"CBS.Sports"},2293809:{category_id:35,name:"Physics Forums"},2293810:{category_id:35,name:"National Portal of India"},2293811:{category_id:35,name:"ThinkQuest"},2293812:{category_id:35,name:"SpongeBob SquarePants at Nick"},2293813:{category_id:35,name:"Animal Planet Channel Online"},2293814:{category_id:35,name:"Funbrain"},2293815:{category_id:35,name:"StarWars"},2293816:{category_id:35,name:"Enchanted Learning"},2293817:{category_id:35,name:"GameSpy"},2293818:{category_id:35,name:"Spelling City"},2293819:{category_id:35,name:"Pokemon"},2293820:{category_id:35,name:"The Holy See"},2293821:{category_id:35,name:"Fupa Games"},2293822:{category_id:35,name:"Gameloft"},23:{category_id:0,name:"UcTalk"},2359297:{category_id:36,name:"Yahoo News",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/yahoo.com/favicon.ico"},2359298:{category_id:36,name:"The Huffington Post",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/huffingtonpost.com/favicon.ico"},2359299:{category_id:36,name:"New York Times"},2359300:{category_id:36,name:"Google News",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/google.com/favicon.ico"},2359301:{category_id:36,name:"Reddit",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/reddit.com/favicon.ico"},2359302:{category_id:36,name:"The Guardian"},2359303:{category_id:36,name:"The Times of India"},2359304:{category_id:36,name:"Washington Post"},2359305:{category_id:36,name:"Drudge Report"},2359306:{category_id:36,name:"USA Today"},2359307:{category_id:36,name:"Examiner"},2359308:{category_id:36,name:"AccuWeather"},2359309:{category_id:36,name:"Los Angeles Times"},2359310:{category_id:36,name:"Time Magazine"},2359311:{category_id:36,name:"Weather Underground"},2359312:{category_id:36,name:"News.au"},2359313:{category_id:36,name:"The Sydney Morning Herald"},2359314:{category_id:36,name:"Yahoo Weather",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/yahoo.com/favicon.ico"},2359315:{category_id:36,name:"Al Arabiya News Channel"},2359316:{category_id:36,name:"Breitbart"},2359317:{category_id:36,name:"San Francisco Chronicle"},2359318:{category_id:36,name:"National Geographic"},2359319:{category_id:36,name:"HindustanTimes"},2359320:{category_id:36,name:"NewsMax"},2359321:{category_id:36,name:"Topix"},2359322:{category_id:36,name:"Chicago Tribune"},2359323:{category_id:36,name:"Houston Chronicle"},2359324:{category_id:36,name:"PRWeb"},2359325:{category_id:36,name:"The Globe and Mail"},2359326:{category_id:36,name:"The Age"},2359327:{category_id:36,name:"Christian Science Monitor"},2359328:{category_id:36,name:"New Jersey Online"},2359329:{category_id:36,name:"WorldNetDaily"},2359330:{category_id:36,name:"Navbharat Times"},2359331:{category_id:36,name:"Washington Times"},2359332:{category_id:36,name:"Eenadu"},2359333:{category_id:36,name:"The Associated Press"},2359334:{category_id:36,name:"Digital Spy"},2359335:{category_id:36,name:"bdnews24"},2359336:{category_id:36,name:"U.S. News &amp; World Report"},2359337:{category_id:36,name:"Yr.no"},2359338:{category_id:36,name:"The Onion"},2359339:{category_id:36,name:"Metafilter"},2359340:{category_id:36,name:"Sky News"},2359341:{category_id:36,name:"The Hill"},2359342:{category_id:36,name:"The Examiner"},2359343:{category_id:36,name:"Philly"},2359344:{category_id:36,name:"The Indian Express"},2359345:{category_id:36,name:"National Review Online"},2359346:{category_id:36,name:"DNA"},2359347:{category_id:36,name:"Malayala Manorama"},2359348:{category_id:36,name:"DailyFinance"},2359349:{category_id:36,name:"France 24"},2359350:{category_id:36,name:"Fark"},2359351:{category_id:36,name:"Intellicast"},2359352:{category_id:36,name:"NewsNow"},2359353:{category_id:36,name:"The Denver Post"},2359354:{category_id:36,name:"PR Newswire"},2359355:{category_id:36,name:"Chicago Sun-Times"},2359356:{category_id:36,name:"The Atlanta Journal-Constitution"},2359357:{category_id:36,name:"Herald Sun"},2359358:{category_id:36,name:"The Australian"},2359359:{category_id:36,name:"The Arizona Republic"},2359360:{category_id:36,name:"Detroit Free Press"},2359361:{category_id:36,name:"Mathrubhumi Daily"},2359362:{category_id:36,name:"San Jose Mercury News"},2359363:{category_id:36,name:"Newsday"},2359364:{category_id:36,name:"Vancouver Province"},2359365:{category_id:36,name:"Star Tribune"},24:{category_id:0,name:"WinpopupX"},2424833:{category_id:37,name:"Booking"},2424834:{category_id:37,name:"TripAdvisor"},2424835:{category_id:37,name:"9Gag"},2424836:{category_id:37,name:"Agoda"},2424837:{category_id:37,name:"Expedia"},2424838:{category_id:37,name:"Southwest"},2424839:{category_id:37,name:"Priceline"},2424840:{category_id:37,name:"CRACKED"},2424841:{category_id:37,name:"Kayak"},2424842:{category_id:37,name:"United Airlines"},2424843:{category_id:37,name:"Delta Air Lines"},2424844:{category_id:37,name:"American Airlines"},2424845:{category_id:37,name:"Lonely Planet"},2424846:{category_id:37,name:"Orbitz"},2424847:{category_id:37,name:"Travelocity"},2424848:{category_id:37,name:"Marriott International"},2424849:{category_id:37,name:"Ryanair"},2424850:{category_id:37,name:"Hilton"},2424851:{category_id:37,name:"EasyJet"},2424852:{category_id:37,name:"Yahoo! Travel",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/yahoo.com/favicon.ico"},2424853:{category_id:37,name:"Autoblog"},2424854:{category_id:37,name:"CouchSurfing"},2424855:{category_id:37,name:"British Airways"},2424856:{category_id:37,name:"Hotwire"},2424857:{category_id:37,name:"Emirates"},2424858:{category_id:37,name:"Lufthansa"},2424859:{category_id:37,name:"CollegeHumor"},2424860:{category_id:37,name:"Travelzoo"},2424861:{category_id:37,name:"Japan Airlines"},2424862:{category_id:37,name:"Ford Motor Company"},2424863:{category_id:37,name:"Open Table"},2424864:{category_id:37,name:"Wikitravel"},2424865:{category_id:37,name:"Time Out"},2424866:{category_id:37,name:"Metropolitan Transportation Authority"},2424867:{category_id:37,name:"US Airways"},2424868:{category_id:37,name:"Vacation Rentals by Owner"},2424869:{category_id:37,name:"LanChile"},2424870:{category_id:37,name:"KLM Royal Dutch Airlines"},2424871:{category_id:37,name:"Petfinder"},2424872:{category_id:37,name:"Accorhotels"},2424873:{category_id:37,name:"Library of Congress"},2424874:{category_id:37,name:"Venere"},2424875:{category_id:37,name:"SkyScanner"},2424876:{category_id:37,name:"Hyatt Hotels and Resorts"},2424877:{category_id:37,name:"Geocaching"},2424878:{category_id:37,name:"Aero Berlin"},2424879:{category_id:37,name:"Virgin Atlantic Airlines"},2424880:{category_id:37,name:"Airliners.net"},2424881:{category_id:37,name:"HomeAway Vacation Rentals Worldwide"},2424882:{category_id:37,name:"Jalopnik"},2424883:{category_id:37,name:"Turkish Airlines"},2424884:{category_id:37,name:"NetCarShow"},2424885:{category_id:37,name:"Qatar Airways"},2424886:{category_id:37,name:"Hostelworld"},2424887:{category_id:37,name:"The Straight Dope by Cecil Adams"},2424888:{category_id:37,name:"Flightradar24"},2424889:{category_id:37,name:"HRS Hotel Reservation Service"},2424890:{category_id:37,name:"Hostelbookers"},2424891:{category_id:37,name:"Qantas Airways"},2424892:{category_id:37,name:"Alaska Airlines"},2424893:{category_id:37,name:"Restaurant"},2424894:{category_id:37,name:"Car and Driver"},2424895:{category_id:37,name:"VirtualTourist"},2424896:{category_id:37,name:"Air Canada"},2424897:{category_id:37,name:"Expedia.ca"},2424898:{category_id:37,name:"Volvo Car Corporation"},2424899:{category_id:37,name:"Late Rooms"},2424900:{category_id:37,name:"Intercontinental Hotels Group"},2424901:{category_id:37,name:"Saudi Arabian Airlines"},2424902:{category_id:37,name:"Top Gear"},2424903:{category_id:37,name:"Porsche"},2424904:{category_id:37,name:"Crave Online"},2424905:{category_id:37,name:"Cathay Pacific Airways"},2424906:{category_id:37,name:"Cebu Pacific Air"},2424907:{category_id:37,name:"Iberia"},2424908:{category_id:37,name:"Cheap Tickets"},2424909:{category_id:37,name:"Florida Department of Transportation"},2424910:{category_id:37,name:"Cheap Flights"},2424911:{category_id:37,name:"AR15"},2424912:{category_id:37,name:"Frommers"},2424913:{category_id:37,name:"Fodors Travel Online"},2424914:{category_id:37,name:"AirTran Airways"},2424915:{category_id:37,name:"Popular Mechanics"},2424916:{category_id:37,name:"AeroMexico"},2424917:{category_id:37,name:"Carnival Cruise Lines"},2424918:{category_id:37,name:"Honda Cars"},2424919:{category_id:37,name:"Aeroflot"},2424920:{category_id:37,name:"Travel and Leisure Magazine"},2490369:{category_id:38,name:"Yahoo! Answers",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/yahoo.com/favicon.ico"},2490370:{category_id:38,name:"WikiAnswers"},2490371:{category_id:38,name:"WordReference"},2490372:{category_id:38,name:"The Free Dictionary"},2490373:{category_id:38,name:"Goodreads"},2490374:{category_id:38,name:"LEO English-German Dictionary"},2490375:{category_id:38,name:"World Wide Web Consortium"},2490376:{category_id:38,name:"MapQuest"},2490377:{category_id:38,name:"YELLOWPAGES"},2490378:{category_id:38,name:"Dict.cc"},2490379:{category_id:38,name:"WhitePages"},2490380:{category_id:38,name:"Blackboard"},2490381:{category_id:38,name:"Massachusetts Institute of Technology"},2490382:{category_id:38,name:"Stanford University"},2490383:{category_id:38,name:"JustAnswer"},2490384:{category_id:38,name:"BrainyQuote"},2490385:{category_id:38,name:"Harvard University"},2490386:{category_id:38,name:"Investopedia"},2490387:{category_id:38,name:"Lumosity"},2490388:{category_id:38,name:"eCollege"},2490389:{category_id:38,name:"University of California"},2490390:{category_id:38,name:"SuperPages"},2490391:{category_id:38,name:"Sulekha Yellow Pages India"},2490392:{category_id:38,name:"University of Phoenix"},2490393:{category_id:38,name:"MyLife"},2490394:{category_id:38,name:"wiseGEEK"},2490395:{category_id:38,name:"The University of Michigan"},2490396:{category_id:38,name:"Cornell University"},2490397:{category_id:38,name:"The University of Texas at Austin"},2490398:{category_id:38,name:"The Pennsylvania State University"},2490399:{category_id:38,name:"GMT"},2490400:{category_id:38,name:"U. S. Department of Education"},2490401:{category_id:38,name:"Wikiquote"},2490402:{category_id:38,name:"yourDictionary"},2490403:{category_id:38,name:"University of Washington"},2490404:{category_id:38,name:"Cambridge University Press"},2490405:{category_id:38,name:"192"},2490406:{category_id:38,name:"Columbia University"},2490407:{category_id:38,name:"Purdue University"},2490408:{category_id:38,name:"University of Wisconsin-Madison"},2490409:{category_id:38,name:"Elsevier"},2490410:{category_id:38,name:"YellowPages.ca"},2490411:{category_id:38,name:"University of Pennsylvania"},2490412:{category_id:38,name:"Yahoo! Maps and Driving Directions.",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/yahoo.com/favicon.ico"},2490413:{category_id:38,name:"Spanish Dictionary"},2490414:{category_id:38,name:"The City University of New York (CUNY)"},2490415:{category_id:38,name:"Coursera"},2490416:{category_id:38,name:"Mappy"},2490417:{category_id:38,name:"New York University"},2490418:{category_id:38,name:"Listal"},2490419:{category_id:38,name:"Experts Exchange"},2490420:{category_id:38,name:"Collegeboard.org"},2490421:{category_id:38,name:"University of Tehran"},2490422:{category_id:38,name:"Yale University"},2490423:{category_id:38,name:"ThinkExist"},2490424:{category_id:38,name:"AllExperts Questions &amp; Answers"},2490425:{category_id:38,name:"WorldCat"},2490426:{category_id:38,name:"University of Florida"},2490427:{category_id:38,name:"Princeton University"},2490428:{category_id:38,name:"Shabdkosh"},2490429:{category_id:38,name:"University of Toronto"},2490430:{category_id:38,name:"University of Cambridge"},2490431:{category_id:38,name:"Maps of World"},2490432:{category_id:38,name:"Michigan State University"},2490433:{category_id:38,name:"RateMyProfessors"},2490434:{category_id:38,name:"K12"},2490435:{category_id:38,name:"Cambridge Dictionary"},2490436:{category_id:38,name:"USP"},2490437:{category_id:38,name:"The Open University"},2490438:{category_id:38,name:"Carnegie Mellon University"},2490439:{category_id:38,name:"Educational Testing Service (ETS)"},2490440:{category_id:38,name:"University of Oxford"},2490441:{category_id:38,name:"University of North Carolina at Chapel Hill"},2490442:{category_id:38,name:"University of Southern California"},2490443:{category_id:38,name:"Moodle"},2490444:{category_id:38,name:"Arizona State University"},2490445:{category_id:38,name:"The University of Arizona"},2490446:{category_id:38,name:"University of Virginia"},2490447:{category_id:38,name:"Chronicle of Higher Education"},25:{category_id:0,name:"BeeTalk"},2555905:{category_id:39,name:"Google India",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/google.com/favicon.ico"},2555906:{category_id:39,name:"Google UK",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/google.com/favicon.ico"},2555907:{category_id:39,name:"Amazon.co.jp",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/amazon.com/favicon.ico"},2555908:{category_id:39,name:"Amazon.co.uk",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/amazon.com/favicon.ico"},2555909:{category_id:39,name:"Google Australia",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/google.com/favicon.ico"},2555910:{category_id:39,name:"eBay UK",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/ebay.com/favicon.ico"},2555911:{category_id:39,name:"The Daily Mail"},2555912:{category_id:39,name:"Indiatimes"},2555913:{category_id:39,name:"Wal-Mart Online"},2555914:{category_id:39,name:"Yahoo! India",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/yahoo.com/favicon.ico"},2555915:{category_id:39,name:"Best Buy Co."},2555916:{category_id:39,name:"Bet365"},2555917:{category_id:39,name:"CNN",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/cnn.com/favicon.ico"},2555918:{category_id:39,name:"United States Postal Service (USPS)"},2555919:{category_id:39,name:"eBay India",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/ebay.com/favicon.ico"},2555920:{category_id:39,name:"eBay.au",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/ebay.com/favicon.ico"},2555921:{category_id:39,name:"Indian Railway Catering and Tourism Corporation"},2555922:{category_id:39,name:"Yahoo UK and Ireland",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/yahoo.com/favicon.ico"},2555923:{category_id:39,name:"POLITICO"},2555924:{category_id:39,name:"Naukri"},2555925:{category_id:39,name:"The Home Depot"},2555926:{category_id:39,name:"Macys"},2555927:{category_id:39,name:"Zhaopin"},2555928:{category_id:39,name:"Road Runner"},2555929:{category_id:39,name:"Kijiji"},2555930:{category_id:39,name:"Yahoo India News Services",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/yahoo.com/favicon.ico"},2555931:{category_id:39,name:"Maktoob"},2555932:{category_id:39,name:"RealClear Politics"},2555933:{category_id:39,name:"IBM Corporation"},2555934:{category_id:39,name:"OneIndia.in"},2555935:{category_id:39,name:"National Oceanic and Atmospheric Administration (NOAA)"},2555936:{category_id:39,name:"Government of Canada"},2555937:{category_id:39,name:"Google News India",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/google.com/favicon.ico"},2555938:{category_id:39,name:"IBN Live"},2555939:{category_id:39,name:"Toys R Us"},2555940:{category_id:39,name:"MoneyControl"},2555941:{category_id:39,name:"State of California"},2555942:{category_id:39,name:"New York Daily News"},2555943:{category_id:39,name:"Google NewZealand",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/google.com/favicon.ico"},2555944:{category_id:39,name:"NHK"},2555945:{category_id:39,name:"MSN UK",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/msn.com/favicon.ico"},2555946:{category_id:39,name:"Official Major League Baseball"},2555947:{category_id:39,name:"Slate Magazine"},2555948:{category_id:39,name:"Nordstrom"},2555949:{category_id:39,name:"craigslist",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/craigslist.com/favicon.ico"},2555950:{category_id:39,name:"Trulia"},26:{category_id:0,name:"Squiggle"},2621441:{category_id:40,name:"Yahoo! Japan",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/yahoo.com/favicon.ico"},2621442:{category_id:40,name:"TED"},2621443:{category_id:40,name:"ScienceDirect"},2621444:{category_id:40,name:"United States Geological Survey (USGS)"},2621445:{category_id:40,name:"Care2"},2621446:{category_id:40,name:"Nature"},2621447:{category_id:40,name:"Japan Meteorological Agency"},2621448:{category_id:40,name:"IEEE"},2621449:{category_id:40,name:"U.S. Department of Agriculture"},262145:{category_id:4,name:"Windows Media Player"},2621450:{category_id:40,name:"JSTOR"},2621451:{category_id:40,name:"RedOrbit"},2621452:{category_id:40,name:"Scientific American"},2621453:{category_id:40,name:"Foreign Policy"},2621454:{category_id:40,name:"LiveScience"},2621455:{category_id:40,name:"National Park Service"},2621456:{category_id:40,name:"Mother Nature Network"},2621457:{category_id:40,name:"US Census Bureau"},2621458:{category_id:40,name:"Bureau of Labor Statistics"},2621459:{category_id:40,name:"Met Office"},262146:{category_id:4,name:"RealPlayer"},2621460:{category_id:40,name:"Environmental Protection Agency"},2621461:{category_id:40,name:"Technology Review"},2621462:{category_id:40,name:"National Geographic News"},2621463:{category_id:40,name:"University of Colorado at Boulder"},2621464:{category_id:40,name:"Wolfram Research"},2621465:{category_id:40,name:"Metric Conversions"},2621466:{category_id:40,name:"Head-Fi"},2621467:{category_id:40,name:"Online Conversion"},2621468:{category_id:40,name:"American Chemical Society"},2621469:{category_id:40,name:"ResearchGATE"},262147:{category_id:4,name:"Winamp"},2621470:{category_id:40,name:"Food and Agriculture Organization (FAO)"},2621471:{category_id:40,name:"Science Magazine"},2621472:{category_id:40,name:"The MathWorks"},2621473:{category_id:40,name:"Azteca Systems Cityworks"},2621474:{category_id:40,name:"arXiv.org e-Print Archive"},2621475:{category_id:40,name:"Gramota.ru"},2621476:{category_id:40,name:"Hydrometeorological Prediction Center"},2621477:{category_id:40,name:"Discover Magazine"},2621478:{category_id:40,name:"italki"},2621479:{category_id:40,name:"arabic keyboard"},262148:{category_id:4,name:"QuickTime"},2621480:{category_id:40,name:"Coolmath"},2621481:{category_id:40,name:"Alldatasheet"},2621482:{category_id:40,name:"Nikon Corporation (Global)"},2621483:{category_id:40,name:"GeoNames"},2621484:{category_id:40,name:"Connexor Parsers"},2621485:{category_id:40,name:"National Institute for Statistics and Economic Studies"},2621486:{category_id:40,name:"Indian Institute of Technology"},2621487:{category_id:40,name:"NIST. National Institute of Standards and Technology"},2621488:{category_id:40,name:"Social Science Research Network"},2621489:{category_id:40,name:"Behind the Name"},262149:{category_id:4,name:"Weather Channel"},2621490:{category_id:40,name:"SpaceWeather"},2621491:{category_id:40,name:"LyngSat"},2621492:{category_id:40,name:"Botanical"},2621493:{category_id:40,name:"Grist Magazine"},2621494:{category_id:40,name:"Blue Letter Bible"},2621495:{category_id:40,name:"European Southern Observatory (ESO)"},2621496:{category_id:40,name:"ScienceBlogs"},2621497:{category_id:40,name:"Iranian Seismological Center"},2621498:{category_id:40,name:"EurekAlert!"},2621499:{category_id:40,name:"IBGE"},262150:{category_id:4,name:"PPTV (PPLive)"},2621500:{category_id:40,name:"Environmental Graffiti"
},2621501:{category_id:40,name:"University of Missouri"},2621502:{category_id:40,name:"About Psychology"},2621503:{category_id:40,name:"MathWorld"},262151:{category_id:4,name:"QQLive"},262152:{category_id:4,name:"LOVEFiLM"},262153:{category_id:4,name:"ITV"},262154:{category_id:4,name:"iTunes",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/apple.com/favicon.ico"},262155:{category_id:4,name:"Adobe Flash"},262156:{category_id:4,name:"Channel 5"},262157:{category_id:4,name:"iQIYI/PPS"},262158:{category_id:4,name:"Headweb"},262159:{category_id:4,name:"Viaplay"},262160:{category_id:4,name:"KKBox"},262161:{category_id:4,name:"WATCHEVER"},262162:{category_id:4,name:"Maxdome"},262163:{category_id:4,name:"Twitch.tv"},262164:{category_id:4,name:"TED"},262165:{category_id:4,name:"RTP"},262166:{category_id:4,name:"SBS"},262167:{category_id:4,name:"UUSee"},262168:{category_id:4,name:"SopCast"},262169:{category_id:4,name:"KeyHoleTV"},262170:{category_id:4,name:"Sina Video"},262171:{category_id:4,name:"Metacafe"},262172:{category_id:4,name:"Wuaki.tv"},262173:{category_id:4,name:"SHOUTcast"},262174:{category_id:4,name:"BBC-iplayer"},262175:{category_id:4,name:"Live365"},262176:{category_id:4,name:"Dailymotion"},262177:{category_id:4,name:"Filmin"},262178:{category_id:4,name:"Flixster"},262179:{category_id:4,name:"Hulu"},262181:{category_id:4,name:"NUBEOX"},262182:{category_id:4,name:"Kugou"},262183:{category_id:4,name:"MoveNetworks"},262184:{category_id:4,name:"Babelgum"},262185:{category_id:4,name:"Livestation"},262186:{category_id:4,name:"iTunes Radio"},262187:{category_id:4,name:"Miro"},262188:{category_id:4,name:"Smithsonian Channel"},262189:{category_id:4,name:"NHL"},262190:{category_id:4,name:"NicoNicoDouga"},262191:{category_id:4,name:"Ooyala"},262192:{category_id:4,name:"Photobucket"},262193:{category_id:4,name:"MLSsoccer"},262194:{category_id:4,name:"Channel 4"},262195:{category_id:4,name:"VideoDetective"},262196:{category_id:4,name:"Ustream.tv"},262197:{category_id:4,name:"Veetle"},262198:{category_id:4,name:"VeohTV"},262199:{category_id:4,name:"iTunes Festival"},262200:{category_id:4,name:"SiriusXM"},262201:{category_id:4,name:"Break.com"},262202:{category_id:4,name:"CinemaNow"},262203:{category_id:4,name:"Letv"},262204:{category_id:4,name:"RTSP"},262205:{category_id:4,name:"Funshion"},262207:{category_id:4,name:"MTV.com"},262208:{category_id:4,name:"Sohu TV"},262209:{category_id:4,name:"MP4"},262210:{category_id:4,name:"MMS/WMSP"},262211:{category_id:4,name:"FLV"},262212:{category_id:4,name:"PIPI"},262213:{category_id:4,name:"Hulkshare"},262214:{category_id:4,name:"Tudou"},262215:{category_id:4,name:"Ifeng Video "},262216:{category_id:4,name:"WSJ Live"},262217:{category_id:4,name:"Cradio"},262218:{category_id:4,name:"Roku"},262219:{category_id:4,name:"Amazon Prime Music",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/amazon.com/favicon.ico"},262220:{category_id:4,name:"Crackle"},262221:{category_id:4,name:"Blip.tv"},262223:{category_id:4,name:"Audible"},262224:{category_id:4,name:"Web Streaming"},262226:{category_id:4,name:"Vyclone"},262227:{category_id:4,name:"China Streaming Video"},262228:{category_id:4,name:"Crunchyroll"},262229:{category_id:4,name:"EmpFlix"},262230:{category_id:4,name:"Porn.com"},262231:{category_id:4,name:"EskimoTube"},262232:{category_id:4,name:"NewBigTube"},262233:{category_id:4,name:"Madbitties"},262234:{category_id:4,name:"RTMP"},262235:{category_id:4,name:"Hustlertube"},262236:{category_id:4,name:"TnaFlix"},262237:{category_id:4,name:"Xtube"},262238:{category_id:4,name:"Yobt.tv"},262239:{category_id:4,name:"Youjizz"},262245:{category_id:4,name:"Pandora"},262246:{category_id:4,name:"Deezer"},262247:{category_id:4,name:"VLC"},262250:{category_id:4,name:"Livesearch.tv/CoolStreaming"},262251:{category_id:4,name:"Qello"},262252:{category_id:4,name:"CNTV"},262254:{category_id:4,name:"Thunderkankan"},262256:{category_id:4,name:"Youtube",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/youtube.com/favicon.ico"},262258:{category_id:4,name:"56.com"},262259:{category_id:4,name:"RMVB"},262260:{category_id:4,name:"Youku.com"},262261:{category_id:4,name:"SWF"},262262:{category_id:4,name:"AVI"},262263:{category_id:4,name:"MP3"},262264:{category_id:4,name:"WMA"},262265:{category_id:4,name:"MOV"},262266:{category_id:4,name:"WMV"},262267:{category_id:4,name:"ASF"},262268:{category_id:4,name:"Vudu"},262270:{category_id:4,name:"PBS Video"},262271:{category_id:4,name:"Freecast"},262272:{category_id:4,name:"Ku6"},262274:{category_id:4,name:"Spotify"},262275:{category_id:4,name:"LastFM"},262276:{category_id:4,name:"Netflix",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/netflix.com/favicon.ico"},262277:{category_id:4,name:"Uitzendinggemist"},262278:{category_id:4,name:"RTL.nl"},262279:{category_id:4,name:"TudouVa"},262280:{category_id:4,name:"GYAO"},262281:{category_id:4,name:"BARKS"},262283:{category_id:4,name:"Baofeng"},262284:{category_id:4,name:"Qvod/Bobohu"},262285:{category_id:4,name:"Grooveshark"},262286:{category_id:4,name:"Microsoft Silverlight",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/microsoft.com/favicon.ico"},262287:{category_id:4,name:"6.cn"},262288:{category_id:4,name:"Rhapsody"},262290:{category_id:4,name:"Imgo TV"},262291:{category_id:4,name:"Joy.cn"},262292:{category_id:4,name:"Yinyuetai"},262293:{category_id:4,name:"Hichannel"},262294:{category_id:4,name:"ADNstream"},262295:{category_id:4,name:"Livestream"},262296:{category_id:4,name:"YoukuVa "},262298:{category_id:4,name:"Voddler"},262301:{category_id:4,name:"Flixwagon"},262302:{category_id:4,name:"M4V"},262303:{category_id:4,name:"Podcast"},262305:{category_id:4,name:"Shazam"},262306:{category_id:4,name:"TuneIn"},262308:{category_id:4,name:"BaiduMusic"},262310:{category_id:4,name:"DoubanFM"},262311:{category_id:4,name:"IMDb.com",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/imdb.com/favicon.ico"},262312:{category_id:4,name:"XVideos.com"},262313:{category_id:4,name:"xHamster.com"},262314:{category_id:4,name:"PornHub.com"},262315:{category_id:4,name:"LiveJasmin.com"},262316:{category_id:4,name:"XNXX.com"},262317:{category_id:4,name:"YouPorn.com"},262318:{category_id:4,name:"MajorLeagueGaming"},262319:{category_id:4,name:"Wowtv.co.kr"},262320:{category_id:4,name:"iMBC"},262321:{category_id:4,name:"AfreecaTV"},262322:{category_id:4,name:"Arirang"},262323:{category_id:4,name:"KCTVjeju"},262324:{category_id:4,name:"CJB.co.kr"},262325:{category_id:4,name:"MBN"},262326:{category_id:4,name:"MYSolive"},262327:{category_id:4,name:"KBS"},262328:{category_id:4,name:"Mwave"},262329:{category_id:4,name:"YTN"},262330:{category_id:4,name:"Musicsoda"},262331:{category_id:4,name:"FreeOnes.com"},262332:{category_id:4,name:"Streamate.com"},262333:{category_id:4,name:"Airplay"},262334:{category_id:4,name:"DAAP"},262335:{category_id:4,name:"M1905"},262336:{category_id:4,name:"VEVO"},262337:{category_id:4,name:"Amazon Instant Video",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/amazon.com/favicon.ico"},262338:{category_id:4,name:"MixBit"},262339:{category_id:4,name:"Baomihua"},262340:{category_id:4,name:"FORA.tv"},262341:{category_id:4,name:"Vimeo"},262342:{category_id:4,name:"Vube"},262343:{category_id:4,name:"RedTube.com"},262344:{category_id:4,name:"Tube8"},262345:{category_id:4,name:"Mgoon"},262346:{category_id:4,name:"Trailers"},262347:{category_id:4,name:"HBOGO"},262348:{category_id:4,name:"MLB.com"},262349:{category_id:4,name:"Kaltura.com"},2686977:{category_id:41,name:"eBay",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/ebay.com/favicon.ico"},2686978:{category_id:41,name:"IKEA"},2686979:{category_id:41,name:"NewEgg"},2686980:{category_id:41,name:"Multiply"},2686981:{category_id:41,name:"Gap"},2686982:{category_id:41,name:"LivingSocial"},2686983:{category_id:41,name:"Kohls"},2686984:{category_id:41,name:"Zappos"},2686985:{category_id:41,name:"BodyBuilding"},2686986:{category_id:41,name:"Overstock"},2686987:{category_id:41,name:"Barnes and Noble"},2686988:{category_id:41,name:"Lowes"},2686989:{category_id:41,name:"JCPenney"},2686990:{category_id:41,name:"Shutterfly"},2686991:{category_id:41,name:"QVC"},2686992:{category_id:41,name:"Legacy"},2686993:{category_id:41,name:"Staples"},2686994:{category_id:41,name:"Nike"},2686995:{category_id:41,name:"B&H Photo Video"},2686996:{category_id:41,name:"Ticketmaster USA"},2686997:{category_id:41,name:"Walgreens"},2686998:{category_id:41,name:"TigerDirect"},2686999:{category_id:41,name:"Victorias Secret"},2687000:{category_id:41,name:"Pixmania"},2687001:{category_id:41,name:"GameStop"},2687002:{category_id:41,name:"Buy"},2687003:{category_id:41,name:"Trade Me"},2687004:{category_id:41,name:"AutoTrader"},2687005:{category_id:41,name:"Home Shopping Network"},2687006:{category_id:41,name:"Sams Club"},2687007:{category_id:41,name:"Bed"},2687008:{category_id:41,name:"CafePress"},2687009:{category_id:41,name:"Souq"},2687010:{category_id:41,name:"6pm"},2687011:{category_id:41,name:"CVS/pharmacy Online CVS"},2687012:{category_id:41,name:"cars"},2687013:{category_id:41,name:"Sephora"},2687014:{category_id:41,name:"Cabelas"},2687015:{category_id:41,name:"Forever 21"},2687016:{category_id:41,name:"Lands End"},2687017:{category_id:41,name:"John Wiley and Sons"},2687018:{category_id:41,name:"Play"},2687019:{category_id:41,name:"Drugstore"},2687020:{category_id:41,name:"Blockbuster"},2687021:{category_id:41,name:"M and S Gifts"},2687022:{category_id:41,name:"Neiman Marcus"},2687023:{category_id:41,name:"Office Depot"},2687024:{category_id:41,name:"CD Universe"},2687025:{category_id:41,name:"Shopbop"},2687026:{category_id:41,name:"Recreational Equipment Incorporated"},2687027:{category_id:41,name:"StubHub"},2687028:{category_id:41,name:"JCrew"},2687029:{category_id:41,name:"NET-A-PORTER.COM"},2687030:{category_id:41,name:"iHerb"},2687031:{category_id:41,name:"Frys"},2687032:{category_id:41,name:"Focalprice"},2687033:{category_id:41,name:"L.L.Bean"},2687034:{category_id:41,name:"Saks Fifth Avenue"},2687035:{category_id:41,name:"Bloomingdales"},2687036:{category_id:41,name:"Vitacost"},2687037:{category_id:41,name:"Yoox"},2687038:{category_id:41,name:"Pottery Barn"},2687039:{category_id:41,name:"Urban Outfitters"},2687040:{category_id:41,name:"American Eagle Outfitters"},2687041:{category_id:41,name:"Disney Store"},2687042:{category_id:41,name:"Scholastic Corporation"},2687043:{category_id:41,name:"Sierra Trading Post"},2687044:{category_id:41,name:"Redbubble"},2687045:{category_id:41,name:"ModCloth Indie Clothing"},2687046:{category_id:41,name:"Future Shop"},2687047:{category_id:41,name:"Musicians Friend"},2687048:{category_id:41,name:"Advanced Book Exchange"},2687049:{category_id:41,name:"Joann"},2687050:{category_id:41,name:"GameFly"},2687051:{category_id:41,name:"Dicks Sporting Goods"},2687052:{category_id:41,name:"Harbor Freight"},2687053:{category_id:41,name:"Ralph Lauren"},2687054:{category_id:41,name:"OfficeMax"},2687055:{category_id:41,name:"Snapfish"},2687056:{category_id:41,name:"PetSmart"},2752513:{category_id:42,name:"SiteAdvisor"},2752514:{category_id:42,name:"Yahoo! Shine",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/yahoo.com/favicon.ico"},2752515:{category_id:42,name:"Match"},2752516:{category_id:42,name:"Ancestry"},2752517:{category_id:42,name:"Digg"},2752518:{category_id:42,name:"Sulekha"},2752519:{category_id:42,name:"Europa"},2752520:{category_id:42,name:"U.S. Department of State"},2752521:{category_id:42,name:"Bible Gateway"},2752522:{category_id:42,name:"Correios"},2752523:{category_id:42,name:"Wonder Wall"},2752524:{category_id:42,name:"Japan Post Service Co."},2752525:{category_id:42,name:"Change.org"},2752526:{category_id:42,name:"The Weekly Standard"},2752527:{category_id:42,name:"European Commission"},2752528:{category_id:42,name:"Daily Kos"},2752529:{category_id:42,name:"Infowars"},2752530:{category_id:42,name:"SheKnows"},2752531:{category_id:42,name:"President Barack H. Obama"},2752532:{category_id:42,name:"Ask Men"},2752533:{category_id:42,name:"Slashdot"},2752534:{category_id:42,name:"Townhall"},2752535:{category_id:42,name:"Royal Mail"},2752536:{category_id:42,name:"Snopes"},2752537:{category_id:42,name:"AARP"},2752538:{category_id:42,name:"Church of Jesus Christ of Latter-day Saints"},2752539:{category_id:42,name:"Just Jared"},2752540:{category_id:42,name:"Complex"},2752541:{category_id:42,name:"Gallup"},2752542:{category_id:42,name:"The Register"},2752543:{category_id:42,name:"Official Resources Web Site"},2752544:{category_id:42,name:"Creative Commons"},2752545:{category_id:42,name:"NewsBusters.org"},2752546:{category_id:42,name:"The Jerusalem Post"},2752547:{category_id:42,name:"Immigration and Naturalization Service (Employment)"},2752548:{category_id:42,name:"Deutsche Post"},2752549:{category_id:42,name:"Department of Veterans Affairs"},2752550:{category_id:42,name:"DateHookup"},2752551:{category_id:42,name:"Avaaz"},2752552:{category_id:42,name:"The Animal Rescue Site"},2752553:{category_id:42,name:"PeopleSmart"},2752554:{category_id:42,name:"United Nations"},2752555:{category_id:42,name:"Free Republic"},2752556:{category_id:42,name:"Canada Post / Postes Canada"},2752557:{category_id:42,name:"MoveOn.org"},2752558:{category_id:42,name:"Astrodienst"},2752559:{category_id:42,name:"The Christian Post"},2752560:{category_id:42,name:"The Superficial"},2752561:{category_id:42,name:"La Poste"},2752562:{category_id:42,name:"Made Man"},2752563:{category_id:42,name:"Find A Grave"},2752564:{category_id:42,name:"Answerbag"},2752565:{category_id:42,name:"FamilySearch"},2752566:{category_id:42,name:"RootsWeb"},2752567:{category_id:42,name:"American Red Cross"},2752568:{category_id:42,name:"IMDb",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/imdb.com/favicon.ico"},2752569:{category_id:42,name:"Online Parallel Bible"},2752570:{category_id:42,name:"Above Top Secret"},2752571:{category_id:42,name:"Companies House"},2752572:{category_id:42,name:"CaringBridge"},2752573:{category_id:42,name:"The World Bank Group"},2752574:{category_id:42,name:"Christian Book Distributors"},2752575:{category_id:42,name:"The Knot"},2752576:{category_id:42,name:"Australia Post"},2752577:{category_id:42,name:"Expat Blog"},2752578:{category_id:42,name:"Islamic Finder"},2752579:{category_id:42,name:"Central Bank of the Islamic Republic of Iran"},2752580:{category_id:42,name:"Treehugger"},2752581:{category_id:42,name:"David Icke"},2752582:{category_id:42,name:"Cosmopolitan"},2752583:{category_id:42,name:"Securities and Exchange Commission (SEC)"},2752584:{category_id:42,name:"FindLaw"},2752585:{category_id:42,name:"LewRockwell"},2752586:{category_id:42,name:"Esquire"},2752587:{category_id:42,name:"Avvo"},2752588:{category_id:42,name:"Foreign and Commonwealth Office"},2752589:{category_id:42,name:"GoodSearch"},2752590:{category_id:42,name:"Horoscope"},2752591:{category_id:42,name:"GQ"},28:{category_id:0,name:"Pidgin"},2818049:{category_id:43,name:"Yahoo Sports",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/yahoo.com/favicon.ico"},2818050:{category_id:43,name:"NFL.COM"},2818051:{category_id:43,name:"NBA"},2818052:{category_id:43,name:"LiveScore"},2818053:{category_id:43,name:"Bleacher Report"},2818054:{category_id:43,name:"Premierleague"},2818055:{category_id:43,name:"SkySports"},2818056:{category_id:43,name:"Fantasy games"},2818057:{category_id:43,name:"British Eurosport"},2818058:{category_id:43,name:"Rivals"},2818059:{category_id:43,name:"Formula1"},2818060:{category_id:43,name:"Scout"},2818061:{category_id:43,name:"ATPworldtour"},2818062:{category_id:43,name:"Rotoworld"},2818063:{category_id:43,name:"Sporting News"},2818064:{category_id:43,name:"NASCAR Online"},2818065:{category_id:43,name:"SB Nation"},2818066:{category_id:43,name:"FlashScore"},2818067:{category_id:43,name:"Yardbarker"},2818068:{category_id:43,name:"Deadspin"},2818069:{category_id:43,name:"The Sports Network"},2818070:{category_id:43,name:"Arsenal"},2818071:{category_id:43,name:"Liverpool Football Club"},2818072:{category_id:43,name:"Pro Football Talk"},2818073:{category_id:43,name:"NHL.com"},2818074:{category_id:43,name:"My Fantasy League"},2818075:{category_id:43,name:"ESPN Star Sports"},2818076:{category_id:43,name:"FootyTube"},2818077:{category_id:43,name:"Cricbuzz"},2818078:{category_id:43,name:"FilGoal"},2818079:{category_id:43,name:"FC Barcelona"},2818080:{category_id:43,name:"Sporting Life"},2818081:{category_id:43,name:"MaxPreps"},2818082:{category_id:43,name:"Chelsea Football Club"},2818083:{category_id:43,name:"autosport"},2818084:{category_id:43,name:"Sherdog"},2818085:{category_id:43,name:"Surfline"},2818086:{category_id:43,name:"Ultimate Fighting Championship"},2818087:{category_id:43,name:"Runners World Online"},2818088:{category_id:43,name:"Racing Post"},2818089:{category_id:43,name:"MSNBC Sports"},2818090:{category_id:43,name:"101 Great Goals"},2818091:{category_id:43,name:"Cyclingnews"},2818092:{category_id:43,name:"The Hong Kong Jockey Club"},2818093:{category_id:43,name:"Real Madrid"},2818094:{category_id:43,name:"XScores"},2818095:{category_id:43,name:"PGA Tour"},2818096:{category_id:43,name:"TEAMtalk "},2818097:{category_id:43,name:"Football365"},2818098:{category_id:43,name:"Real GM"},2818099:{category_id:43,name:"RealTime Fantasy Sports"},2818100:{category_id:43,name:"Eurosport"},2818101:{category_id:43,name:"MLB Trade Rumors"},2818102:{category_id:43,name:"Baseball Reference"},29:{category_id:0,name:"ISPQ"},3:{category_id:0,name:"AIM/ICQ/iIM"},31:{category_id:0,name:"ChatON(M)"},32:{category_id:0,name:"Caihong"},327681:{category_id:5,name:"SMTP"},327682:{category_id:5,name:"POP3"},327683:{category_id:5,name:"IMAP4"},327684:{category_id:5,name:"NNTP"},327685:{category_id:5,name:"Twig"},327686:{category_id:5,name:"GroupWise"},327687:{category_id:5,name:"au one net"},327689:{category_id:5,name:"PChome"},327690:{category_id:5,name:"DTI MyMail"},327691:{category_id:5,name:"Ymail"},327692:{category_id:5,name:"IIJ MailViewer"},327693:{category_id:5,name:"Telenet Mail"},327694:{category_id:5,name:"Open Mail"},327695:{category_id:5,name:"InfoSphere Webmail"},327696:{category_id:5,name:"Goo Mail"},327697:{category_id:5,name:"Nifty"},327698:{category_id:5,name:"QQ Mail"},327699:{category_id:5,name:"Roundcubemail"},327700:{category_id:5,name:"Zenno"},327701:{category_id:5,name:"Itm-asp"},327702:{category_id:5,name:"Biglobe"},327703:{category_id:5,name:"SquirrelMail"},327704:{category_id:5,name:"Zoho Mail"},327705:{category_id:5,name:"Inter7"},327706:{category_id:5,name:"TOK2"},327707:{category_id:5,name:"Smoug"},327708:{category_id:5,name:"1und1"},327709:{category_id:5,name:"Plala"},327710:{category_id:5,name:"WAKWAK"},327711:{category_id:5,name:"Eyejot"},327712:{category_id:5,name:"AsahiNet"},327713:{category_id:5,name:"Aikq"},327714:{category_id:5,name:"Yandex"},327715:{category_id:5,name:"Arcor"},327716:{category_id:5,name:"Bluewin"},327717:{category_id:5,name:"Directbox"},327718:{category_id:5,name:"Freenet"},327720:{category_id:5,name:"Smart Mail"},327722:{category_id:5,name:"WEB.DE"},327723:{category_id:5,name:"MS Exchange Server"},327732:{category_id:5,name:"Webmail.de"},327742:{category_id:5,name:"NETEASE Mail"},327743:{category_id:5,name:"Gmx Mail"},327744:{category_id:5,name:"Excite"},327745:{category_id:5,name:"InfoSeek Mail"},327746:{category_id:5,name:"Livedoor"},327747:{category_id:5,name:"Nate Mail"},327749:{category_id:5,name:"Optimum"},327751:{category_id:5,name:"Secureserver"},327753:{category_id:5,name:"Sina Mail"},327755:{category_id:5,name:"Rambler"},327760:{category_id:5,name:"Daum Mail"},327761:{category_id:5,name:"Mail.com"},327762:{category_id:5,name:"OCN"},327763:{category_id:5,name:"MailChimp"},327764:{category_id:5,name:"Rediff Mail"},327770:{category_id:5,name:"Korea Mail"},327774:{category_id:5,name:"Hotmail"},327775:{category_id:5,name:"Gmail"},327776:{category_id:5,name:"AOL Mail",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/aol.com/favicon.ico"},327778:{category_id:5,name:"COX"},327779:{category_id:5,name:"Hushmail"},327780:{category_id:5,name:"Mail.ru"},327781:{category_id:5,name:"HiNet Mail"},327782:{category_id:5,name:"Horde"},327783:{category_id:5,name:"Fastmail"},327784:{category_id:5,name:"Comcast",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/comcast.com/favicon.ico"},327785:{category_id:5,name:"Laposte"},327786:{category_id:5,name:"Yahoo Mail",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/yahoo.com/favicon.ico"},327787:{category_id:5,name:"Usermin Mail"},327788:{category_id:5,name:"Tistory"},327789:{category_id:5,name:"Orange"},327790:{category_id:5,name:"012mail"},327791:{category_id:5,name:"T-Online"},327792:{category_id:5,name:"Jubii Mail"},327793:{category_id:5,name:"Whalemail"},327794:{category_id:5,name:"Lavabit"},327795:{category_id:5,name:"Tiscali"},33:{category_id:0,name:"KC"},34:{category_id:0,name:"IMVU"},35:{category_id:0,name:"Instan-t"},36:{category_id:0,name:"PiIM"},37:{category_id:0,name:"Xfire"},38:{category_id:0,name:"Raidcall"},393217:{category_id:6,name:"Skype"},393218:{category_id:6,name:"H.323"},393220:{category_id:6,name:"Facetime"},393221:{category_id:6,name:"Juiker"},393222:{category_id:6,name:"Sqwiggle"},393223:{category_id:6,name:"ooVoo"},393225:{category_id:6,name:"TeamSpeak"},393226:{category_id:6,name:"Ventrilo"},393228:{category_id:6,name:"SIP"},393229:{category_id:6,name:"NetMeeting"},393230:{category_id:6,name:"Inter-Asterisk"},393231:{category_id:6,name:"Net2Phone"},393232:{category_id:6,name:"MSRP"},393234:{category_id:6,name:"LINE(M)"},393235:{category_id:6,name:"Fring(M)"},393236:{category_id:6,name:"Goober"},393238:{category_id:6,name:"Viber(M)"},393239:{category_id:6,name:"Kakao(M)"},393240:{category_id:6,name:"iCall"},393242:{category_id:6,name:"Nimbuzz"},393243:{category_id:6,name:"Bobsled(M)"},393244:{category_id:6,name:"indoona"},393246:{category_id:6,name:"Tango(M)"},393247:{category_id:6,name:"Ooma"},4:{category_id:0,name:"QQ/TM"},41:{category_id:0,name:"WhatsApp(M)"},42:{category_id:0,name:"Userplane"},43:{category_id:0,name:"24im"},44:{category_id:0,name:"Camfrog"},458753:{category_id:7,name:"MSSQL"},458754:{category_id:7,name:"MySQL"},458755:{category_id:7,name:"Oracle"},458756:{category_id:7,name:"PostgreSQL"},458757:{category_id:7,name:"SAP"},458760:{category_id:7,name:"Etelos"},458761:{category_id:7,name:"Centriccrm"},458763:{category_id:7,name:"FileMaker"},458766:{category_id:7,name:"MongoDB"},458767:{category_id:7,name:"Salesforce"},458768:{category_id:7,name:"MariaDB"},46:{category_id:0,name:"Digsby"},49:{category_id:0,name:"Message Send Protocol"},5:{category_id:0,name:"Laiwang(M)"},524289:{category_id:8,name:"QQ Game"},524290:{category_id:8,name:"Our Game"},524291:{category_id:8,name:"Cga.com"},524292:{category_id:8,name:"FIFA"},524293:{category_id:8,name:"PopKart"},524294:{category_id:8,name:"Archlord"},524295:{category_id:8,name:"AddictingGames.com"},524296:{category_id:8,name:"Realgame"},524297:{category_id:8,name:"Audition"},524298:{category_id:8,name:"Koramgame"},524299:{category_id:8,name:"BnB Game"},524300:{category_id:8,name:"Chinagame"},524301:{category_id:8,name:"CS Game"},524302:{category_id:8,name:"Diablo"},524303:{category_id:8,name:"Legend"},524304:{category_id:8,name:"Lineage"},524306:{category_id:8,name:"Quake Game"},524307:{category_id:8,name:"Diablo3"},524308:{category_id:8,name:"Sina Web Game"},524310:{category_id:8,name:"WOW Game"},524311:{category_id:8,name:"Ispeakgame"},524312:{category_id:8,name:"Torchlight2"},524313:{category_id:8,name:"MapleStory"},524314:{category_id:8,name:"TowerOfSaviors(M)"},524315:{category_id:8,name:"Wolfenstein"},524316:{category_id:8,name:"Second Life"},524317:{category_id:8,name:"Kimi"},524318:{category_id:8,name:"Doof Game"},524319:{category_id:8,name:"PartyPoker"},524320:{category_id:8,name:"Pogo"},524321:{category_id:8,name:"PokerStars"},524322:{category_id:8,name:"Zango"},524323:{category_id:8,name:"Little Fighter 2"},524324:{category_id:8,name:"BomberClone"},524326:{category_id:8,name:"FSJOY"},524327:{category_id:8,name:"175pt"},524328:{category_id:8,name:"Zhuxian"},524329:{category_id:8,name:"GameTea/GameABC"},524330:{category_id:8,name:"Talesrunner"},524331:{category_id:8,name:"PK Game"},524332:{category_id:8,name:"Concerto Gate"},524333:{category_id:8,name:"TLBB"},524334:{category_id:8,name:"YBOnline"},524335:{category_id:8,name:"Xunyou"},524336:{category_id:8,name:"Mwo"},524337:{category_id:8,name:"ZF.91"},524338:{category_id:8,name:"WuLin"},524339:{category_id:8,name:"DNF Game"},524340:{category_id:8,name:"Bo Game"},524341:{category_id:8,name:"Gran Turismo"},524343:{category_id:8,name:"Electronic Arts"},524344:{category_id:8,name:"ZhengTu"},524345:{category_id:8,name:"SGOL"},524346:{category_id:8,name:"XY2Online"},524347:{category_id:8,name:"Asherons Call"},524348:{category_id:8,name:"Kali"},524349:{category_id:8,name:"EverQuest"},524350:{category_id:8,name:"XBOX"},524351:{category_id:8,name:"BrettspielWelt"},524352:{category_id:8,name:"Bet-at-Home"},524353:{category_id:8,name:"City of Heroes"},524354:{category_id:8,name:"ClubPenguin"},524355:{category_id:8,name:"StepMania"},524356:{category_id:8,name:"Battle.net"},524358:{category_id:8,name:"Apprentice"},524359:{category_id:8,name:"EA SPORTS"},524360:{category_id:8,name:"FreeLotto Game"},524361:{category_id:8,name:"Halo"},524362:{category_id:8,name:"iSketch"},524363:{category_id:8,name:"RuneScape"},524364:{category_id:8,name:"FUNMILY"},524365:{category_id:8,name:"Yeapgame"},524366:{category_id:8,name:"Grand Theft Auto"},524367:{category_id:8,name:"Lineage2"},524368:{category_id:8,name:"GM99 Game"},524369:{category_id:8,name:"RayCity"},524370:{category_id:8,name:"Rockstar Games"},524371:{category_id:8,name:"Aleph One"},524372:{category_id:8,name:"Wayi"},524373:{category_id:8,name:"CMWEBGAME"},524374:{category_id:8,name:"Call of Duty"},524375:{category_id:8,name:"CAPTAN"},524376:{category_id:8,name:"Supercell(Clash of Clans/Hay Day)"},524377:{category_id:8,name:"Need for Speed"},524379:{category_id:8,name:"Madden NFL"},524380:{category_id:8,name:"Half-Life"},524381:{category_id:8,name:"Team Fortress"},524383:{category_id:8,name:"Final Fantasy"},524384:{category_id:8,name:"Mythic"},524385:{category_id:8,name:"NetPanzer"},524386:{category_id:8,name:"Sdo.com"},524388:{category_id:8,name:"Pokemon Netbattle"},524389:{category_id:8,name:"RunUO-Ultima"},524390:{category_id:8,name:"Soldat Dedicated"},524391:{category_id:8,name:"Blizzard Entertainment"},524392:{category_id:8,name:"RIFT"},524393:{category_id:8,name:"TetriNET"},524394:{category_id:8,name:"Tibia"},524395:{category_id:8,name:"PlanetSide"},524396:{category_id:8,name:"TripleA"},524398:{category_id:8,name:"Unreal"},524399:{category_id:8,name:"Valve Steam"},524400:{category_id:8,name:"WesNOth"},524401:{category_id:8,name:"Xpilot"},524402:{category_id:8,name:"Swtor"},524403:{category_id:8,name:"EVEOnline"},524404:{category_id:8,name:"Hearthstone"},524405:{category_id:8,name:"Guild Wars"},524406:{category_id:8,name:"Zhong Hua Hero"},524407:{category_id:8,name:"Wizard101"},524408:{category_id:8,name:"SD Gundam"},524409:{category_id:8,name:"Prius"},524410:{category_id:8,name:"Age of Conan"},524411:{category_id:8,name:"RF Returns"},524412:{category_id:8,name:"AION"},524413:{category_id:8,name:"POPO Game"},524414:{category_id:8,name:"War-Rock"},524415:{category_id:8,name:"TEN Game"},524416:{category_id:8,name:"LUNA2"},524417:{category_id:8,name:"Karos"},524418:{category_id:8,name:"SPOnline"},524419:{category_id:8,name:"RO Game"},524420:{category_id:8,name:"StarCraft2"},524421:{category_id:8,name:"Itaiwanmj"},524422:{category_id:8,name:"CMWEBGAME Game"},524423:{category_id:8,name:"Beanfun Game"},524424:{category_id:8,name:"JXW"},524425:{category_id:8,name:"Nobol"},524426:{category_id:8,name:"DragonNest"},524427:{category_id:8,name:"BBonline"},524428:{category_id:8,name:"Hangame"},524429:{category_id:8,name:"Homygame"},524430:{category_id:8,name:"Sony PlayStation"},524431:{category_id:8,name:"Garena"},524432:{category_id:8,name:"91555"},524433:{category_id:8,name:"JJ Game"},524434:{category_id:8,name:"YHgame"},524435:{category_id:8,name:"Mdm365"},524436:{category_id:8,name:"7fgame"},524437:{category_id:8,name:"Dokee"},524438:{category_id:8,name:"VSA"},524439:{category_id:8,name:"Funtown"},524440:{category_id:8,name:"SF Game"},524441:{category_id:8,name:"173kh"},524442:{category_id:8,name:"Boyaapoker"},524443:{category_id:8,name:"GameCenter"},524444:{category_id:8,name:"Minecraft"},524445:{category_id:8,name:"Dark Souls"},524446:{category_id:8,name:"The Secret World"},524447:{category_id:8,name:"World2"},524448:{category_id:8,name:"CrossFire"},524449:{category_id:8,name:"XYQ"},524450:{category_id:8,name:"Nexon"},524451:{category_id:8,name:"Vindictus"},524452:{category_id:8,name:"DotA"},524453:{category_id:8,name:"PAYDAY"},524454:{category_id:8,name:"Wayi Game"},524455:{category_id:8,name:"War Thunder"},524456:{category_id:8,name:"Warframe"},524457:{category_id:8,name:"TT-Play Game"},524458:{category_id:8,name:"TT-Play"},524459:{category_id:8,name:"Robocraft"},524460:{category_id:8,name:"World of Tanks"},524461:{category_id:8,name:"Divinity"},524462:{category_id:8,name:"Left 4 Dead 2"},524463:{category_id:8,name:"DayZ"},524466:{category_id:8,name:"TXWY Game"},524479:{category_id:8,name:"Yeapgame Game"},524491:{category_id:8,name:"FUNMILY Game"},524512:{category_id:8,name:"Sony Online Entertainment"},524513:{category_id:8,name:"WSOP(M)"},524514:{category_id:8,name:"TexasHoldemPoker(M)"},524515:{category_id:8,name:"DarkSummoner(M)"},524516:{category_id:8,name:"AjaxPlay"},524517:{category_id:8,name:"AirlineMogul"},524518:{category_id:8,name:"Evony"},524519:{category_id:8,name:"BasketBallZone"},524520:{category_id:8,name:"Y8 Game"},524521:{category_id:8,name:"Y8-Y8"},524522:{category_id:8,name:"KIZI-GAMES"},524523:{category_id:8,name:"Ibibo"},524524:{category_id:8,name:"Hattrick Game"},524525:{category_id:8,name:"Godgame"},524526:{category_id:8,name:"Aswordtw(M)"},524527:{category_id:8,name:"Qme RO(M)"},524529:{category_id:8,name:"THE WORLD(M)"},524530:{category_id:8,name:"Qme JH(M)"},524531:{category_id:8,name:"Qme COS(M)"},524532:{category_id:8,name:"Qme SG(M)"},524533:{category_id:8,name:"Origin"},524534:{category_id:8,name:"LoL"},524535:{category_id:8,name:"THISISGAME"},524536:{category_id:8,name:"Miniclip Game"},524537:{category_id:8,name:"888games"},524538:{category_id:8,name:"WilliamHill"},524539:{category_id:8,name:"Betfair Game"},524540:{category_id:8,name:"Kongregate Game"},524541:{category_id:8,name:"Roblox Game"},524542:{category_id:8,name:"King Game"},524543:{category_id:8,name:"Chess Game"},54:{category_id:0,name:"Fetion"},55:{category_id:0,name:"Heyyo"},56:{category_id:0,name:"Alicall"},57:{category_id:0,name:"Qeshow"},58:{category_id:0,name:"MissLee"},589828:{category_id:9,name:"IGMP"},589829:{category_id:9,name:"SNMP"},589885:{category_id:9,name:"DNS"},589888:{category_id:9,name:"Multicast DNS"},589890:{category_id:9,name:"Finger protocol"},589916:{category_id:9,name:"DCE-RPC"},589933:{category_id:9,name:"SSDP"},589934:{category_id:9,name:"SMB"},589942:{category_id:9,name:"ICMP"},589951:{category_id:9,name:"UPnP"},59:{category_id:0,name:"Jctrans"},6:{category_id:0,name:"IRC"},61:{category_id:0,name:"BaiduHi"},62:{category_id:0,name:"TELTEL"},64:{category_id:0,name:"9158"},65:{category_id:0,name:"Kltx"},655361:{category_id:10,name:"pcAnywhere"},655362:{category_id:10,name:"VNC"},655363:{category_id:10,name:"TeamViewer"},655364:{category_id:10,name:"MS Remote Desktop Protocol (RDP)"},655365:{category_id:10,name:"Chrome Remote Desktop"},655366:{category_id:10,name:"NTRglobal"},655367:{category_id:10,name:"RemoteCall"},655369:{category_id:10,name:"GoToMyPC"},655370:{category_id:10,name:"Pulseway"},655371:{category_id:10,name:"Radmin"},655372:{category_id:10,name:"Beinsync"},655373:{category_id:10,name:"Fastviewer"},655374:{category_id:10,name:"CrossTec Remote Control"},655375:{category_id:10,name:"GoToMeeting"},655376:{category_id:10,name:"ShowMyPC"},655377:{category_id:10,name:"Join.me"},655378:{category_id:10,name:"Telnet"},655379:{category_id:10,name:"Techinline"},65538:{category_id:1,name:"BitTorrent Series"},655380:{category_id:10,name:"ISL Online"},655381:{category_id:10,name:"Secure Shell (SSH)"
},655385:{category_id:10,name:"IBM Remote monitoring and Control"},655395:{category_id:10,name:"Netviewer"},655396:{category_id:10,name:"VT100"},655398:{category_id:10,name:"X11"},65540:{category_id:1,name:"DirectConnect"},655402:{category_id:10,name:"Instanthousecall"},655403:{category_id:10,name:"Ammyy"},65542:{category_id:1,name:"eDonkey Series"},65543:{category_id:1,name:"FastTrack"},65544:{category_id:1,name:"Gnutella"},65545:{category_id:1,name:"WinMX"},65546:{category_id:1,name:"Foxy"},65547:{category_id:1,name:"Winny"},65548:{category_id:1,name:"POCO"},65549:{category_id:1,name:"iMesh"},65550:{category_id:1,name:"ClubBox"},65551:{category_id:1,name:"Vagaa"},65552:{category_id:1,name:"Share"},65553:{category_id:1,name:"Thunder Series"},65554:{category_id:1,name:"myMusic"},65555:{category_id:1,name:"QQDownload"},65557:{category_id:1,name:"easyMule"},65559:{category_id:1,name:"Fileguri"},65563:{category_id:1,name:"Soulseek"},65565:{category_id:1,name:"GNUnet"},65566:{category_id:1,name:"XNap"},65568:{category_id:1,name:"Kceasy"},65569:{category_id:1,name:"Aria2"},65570:{category_id:1,name:"Arctic"},65571:{category_id:1,name:"Artemis"},65572:{category_id:1,name:"Bitflu"},65573:{category_id:1,name:"BTG"},65574:{category_id:1,name:"Pando"},65575:{category_id:1,name:"Lphant"},65576:{category_id:1,name:"BitBlinder"},65577:{category_id:1,name:"Deepnet Explorer"},65578:{category_id:1,name:"aMule"},65580:{category_id:1,name:"Ares"},65581:{category_id:1,name:"Azureus"},65582:{category_id:1,name:"BCDC++"},65583:{category_id:1,name:"BitBuddy"},65584:{category_id:1,name:"BitComet"},65585:{category_id:1,name:"BitTornado"},65587:{category_id:1,name:"ApexDC++"},65588:{category_id:1,name:"Bearshare"},65590:{category_id:1,name:"BitLord"},65591:{category_id:1,name:"BitSpirit"},65594:{category_id:1,name:"Shareaza"},65598:{category_id:1,name:"eMule"},65600:{category_id:1,name:"eMule Plus"},65604:{category_id:1,name:"FileScope"},65609:{category_id:1,name:"GoGoBox"},65612:{category_id:1,name:"Hydranode"},65613:{category_id:1,name:"BitTorrent Pro"},65617:{category_id:1,name:"Kazaa Lite Tools K++"},65620:{category_id:1,name:"BitRocket"},65621:{category_id:1,name:"MlDonkey"},65622:{category_id:1,name:"MooPolice"},65630:{category_id:1,name:"Phex"},65633:{category_id:1,name:"RevConnect"},65634:{category_id:1,name:"Rufus"},65635:{category_id:1,name:"SababaDC"},65636:{category_id:1,name:"Shareaza Plus"},65640:{category_id:1,name:"BTSlave"},65642:{category_id:1,name:"TorrentStorm"},65648:{category_id:1,name:"uTorrent"},65652:{category_id:1,name:"ZipTorrent"},65655:{category_id:1,name:"BitPump"},65664:{category_id:1,name:"BBtor"},65665:{category_id:1,name:"Tuotu"},65666:{category_id:1,name:"BitWombat"},65685:{category_id:1,name:"Vuze"},65688:{category_id:1,name:"Bittorrent X"},65689:{category_id:1,name:"DelugeTorrent"},65690:{category_id:1,name:"CTorrent"},65691:{category_id:1,name:"Propagate Data Client"},65692:{category_id:1,name:"EBit"},65693:{category_id:1,name:"Electric Sheep"},65694:{category_id:1,name:"FileCroc"},65695:{category_id:1,name:"FoxTorrent"},65696:{category_id:1,name:"GSTorrent"},65697:{category_id:1,name:"Hekate"},65698:{category_id:1,name:"Halite"},65699:{category_id:1,name:"hMule"},65700:{category_id:1,name:"KGet"},65701:{category_id:1,name:"KTorrent"},65702:{category_id:1,name:"LeechCraft"},65703:{category_id:1,name:"LH-ABC"},65704:{category_id:1,name:"libTorrent"},65705:{category_id:1,name:"LimeWire"},65706:{category_id:1,name:"Meerkat"},65707:{category_id:1,name:"MonoTorrent"},65708:{category_id:1,name:"MoonlightTorrent"},65709:{category_id:1,name:"Net Transport"},65710:{category_id:1,name:"OneSwarm"},65711:{category_id:1,name:"OmegaTorrent"},65712:{category_id:1,name:"Protocol::BitTorrent"},65713:{category_id:1,name:"PHPTracker"},65714:{category_id:1,name:"qBittorrent"},65715:{category_id:1,name:"Qt 4 Torrent example"},65716:{category_id:1,name:"Retriever"},65717:{category_id:1,name:"RezTorrent"},65718:{category_id:1,name:"Swiftbit"},65719:{category_id:1,name:"SoMud"},65720:{category_id:1,name:"SwarmScope"},65721:{category_id:1,name:"SymTorrent"},65722:{category_id:1,name:"Sharktorrent"},65723:{category_id:1,name:"Terasaur Seed Bank"},65724:{category_id:1,name:"TorrentDotNET"},65725:{category_id:1,name:"Transmission"},65726:{category_id:1,name:"uLeecher"},65727:{category_id:1,name:"BitLet"},65728:{category_id:1,name:"FireTorrent"},65729:{category_id:1,name:"XSwifter"},65730:{category_id:1,name:"XanTorrent"},65731:{category_id:1,name:"Xtorrent"},65732:{category_id:1,name:"Pruna"},65733:{category_id:1,name:"Soribada"},65734:{category_id:1,name:"Gample"},65735:{category_id:1,name:"DIYHARD"},65736:{category_id:1,name:"LottoFile"},65737:{category_id:1,name:"ShareBox"},65738:{category_id:1,name:"Bondisk"},65739:{category_id:1,name:"Filei"},65740:{category_id:1,name:"KDISK"},65741:{category_id:1,name:"Ondisk"},65742:{category_id:1,name:"FILEJO"},65743:{category_id:1,name:"FILEDOK"},65744:{category_id:1,name:"Tomatopang/Santa25"},65745:{category_id:1,name:"Webhard"},65746:{category_id:1,name:"TPLE"},65747:{category_id:1,name:"DiskPump"},65748:{category_id:1,name:"NETFOLDER"},65749:{category_id:1,name:"QFILE"},65750:{category_id:1,name:"DISKMAN"},65751:{category_id:1,name:"DBGO"},65752:{category_id:1,name:"Congaltan"},65753:{category_id:1,name:"Diskpot"},65754:{category_id:1,name:"Ipopclub"},65755:{category_id:1,name:"Yesfile"},65756:{category_id:1,name:"Nedisk"},65757:{category_id:1,name:"Me2disk"},65758:{category_id:1,name:"Odisk"},65759:{category_id:1,name:"Tomfile"},65760:{category_id:1,name:"Adrive.co.kr"},65761:{category_id:1,name:"ZIOfile"},65762:{category_id:1,name:"APPLEFILE"},65763:{category_id:1,name:"SUPERDOWN"},65764:{category_id:1,name:"Hidisk"},65765:{category_id:1,name:"Downs"},65766:{category_id:1,name:"DownDay"},65767:{category_id:1,name:"BOMULBOX"},65768:{category_id:1,name:"FILEHAM"},65769:{category_id:1,name:"Tdisk"},65770:{category_id:1,name:"Filehon"},65771:{category_id:1,name:"Jjangfile"},65772:{category_id:1,name:"Onehard.com"},65773:{category_id:1,name:"Pdpop"},65774:{category_id:1,name:"AirFile"},65775:{category_id:1,name:"FILEZZIM"},65776:{category_id:1,name:"Atomfile.co.kr"},65777:{category_id:1,name:"QDOWN.com"},65778:{category_id:1,name:"Alfile.net"},65779:{category_id:1,name:"Bigfile.co.kr"},65780:{category_id:1,name:"Hardmoa.com"},65781:{category_id:1,name:"Redfile.co.kr"},65782:{category_id:1,name:"FILETV.co.kr"},65783:{category_id:1,name:"Now.co.kr"},65784:{category_id:1,name:"JustBeamIt"},65785:{category_id:1,name:"reep.io"},65786:{category_id:1,name:"GnucDNA/Gimme"},65787:{category_id:1,name:"MyNapster"},66:{category_id:0,name:"IM+(M)"},67:{category_id:0,name:"Imi"},68:{category_id:0,name:"Netcall"},69:{category_id:0,name:"ECP"},7:{category_id:0,name:"Yoics"},72:{category_id:0,name:"Etnano"},720898:{category_id:11,name:"VNN"},720899:{category_id:11,name:"Spotflux"},720900:{category_id:11,name:"SoftEther/PacketiX"},720901:{category_id:11,name:"TinyVPN"},720902:{category_id:11,name:"HTTP-Tunnel"},720903:{category_id:11,name:"Tor"},720904:{category_id:11,name:"Ping Tunnel"},720905:{category_id:11,name:"Wujie/UltraSurf"},720906:{category_id:11,name:"Freegate"},720907:{category_id:11,name:"Hidemyass"},720909:{category_id:11,name:"Vedivi"},720910:{category_id:11,name:"ZenMate"},720911:{category_id:11,name:"Hamachi"},720912:{category_id:11,name:"Disconnect.me"},720913:{category_id:11,name:"Psiphon 3"},720914:{category_id:11,name:"Asproxy"},720915:{category_id:11,name:"OpenDoor"},720916:{category_id:11,name:"NSTX DNS Tunnel"},720917:{category_id:11,name:"Coralcdn"},720918:{category_id:11,name:"Glype"},720919:{category_id:11,name:"GPass"},720920:{category_id:11,name:"Kproxy"},720921:{category_id:11,name:"Megaproxy"},720922:{category_id:11,name:"FreeSafeIP"},720925:{category_id:11,name:"Surrogafier"},720926:{category_id:11,name:"Vtunnel"},720928:{category_id:11,name:"BypassThat"},720930:{category_id:11,name:"JAP/JonDo"},720933:{category_id:11,name:"SofaWare"},720946:{category_id:11,name:"Hidedoor"},720948:{category_id:11,name:"CGIProxy"},720950:{category_id:11,name:"Phproxy"},720951:{category_id:11,name:"OpenVPN"},720952:{category_id:11,name:"CCProxy"},720954:{category_id:11,name:"PD-Proxy"},720959:{category_id:11,name:"Rtmpt"},720960:{category_id:11,name:"LogMeIn"},720961:{category_id:11,name:"HotspotShield"},720962:{category_id:11,name:"ExpressVPN"},720963:{category_id:11,name:"GogoNET"},720964:{category_id:11,name:"HTTP Proxy Server"},720966:{category_id:11,name:"Texasproxy"},720967:{category_id:11,name:"Ourproxy"},720969:{category_id:11,name:"Fast Proxy"},720970:{category_id:11,name:"Zalmos"},720971:{category_id:11,name:"Easy Proxy"},720972:{category_id:11,name:"Proxy Era"},720973:{category_id:11,name:"DotVPN"},720974:{category_id:11,name:"BrowSec"},720977:{category_id:11,name:"Air-Proxy"},720979:{category_id:11,name:"Defilter"},720980:{category_id:11,name:"SSLunblock"},720983:{category_id:11,name:"K12History"},720984:{category_id:11,name:"SurfEasy"},720985:{category_id:11,name:"Frozenway"},720986:{category_id:11,name:"CyberGhostVPN"},720987:{category_id:11,name:"SecurityKISS"},720988:{category_id:11,name:"WebWarper"},720989:{category_id:11,name:"Guardster"},720991:{category_id:11,name:"TunnelBear"},720992:{category_id:11,name:"AstrillVPN"},77:{category_id:0,name:"ProvideSupport"},78:{category_id:0,name:"Dudu IM"},786434:{category_id:12,name:"DZH"},786435:{category_id:12,name:"10JQKA"},786437:{category_id:12,name:"Qianlong"},786438:{category_id:12,name:"Compass.cn"},786439:{category_id:12,name:"Huaan"},786440:{category_id:12,name:"StockStar "},786441:{category_id:12,name:"TDX"},786443:{category_id:12,name:"Hexun"},786444:{category_id:12,name:"Hypwise"},786449:{category_id:12,name:"Kiwoom"},786450:{category_id:12,name:"Windin"},786451:{category_id:12,name:"SamsungPoP"},786453:{category_id:12,name:"StockTrace"},786454:{category_id:12,name:"JRJ"},786455:{category_id:12,name:"TradeFields(M)"},786457:{category_id:12,name:"Netdania"},786458:{category_id:12,name:"TradeInterceptor"},8:{category_id:0,name:"Rediff BOL"},80:{category_id:0,name:"Weibo IM"},81:{category_id:0,name:"WO"},82:{category_id:0,name:"Guagua"},83:{category_id:0,name:"Hangouts"},84:{category_id:0,name:"ClubCooee"},85:{category_id:0,name:"Palringo"},851969:{category_id:13,name:"WhiteHat Aviator"},851970:{category_id:13,name:"HTC Widget(M)"},851971:{category_id:13,name:"Doodle"},851972:{category_id:13,name:"Level3"},851973:{category_id:13,name:"FuzeMeeting"},851974:{category_id:13,name:"Mobile01"},851975:{category_id:13,name:"Speedtest.net"},851976:{category_id:13,name:"Google Chrome",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/google.com/favicon.ico"},851977:{category_id:13,name:"Babelfish"},851978:{category_id:13,name:"Google-translate",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/google.com/favicon.ico"},851980:{category_id:13,name:"Mozilla Firefox"},851981:{category_id:13,name:"Apple Safari",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/apple.com/favicon.ico"},851982:{category_id:13,name:"Opera browser"},851983:{category_id:13,name:"Google",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/google.com/favicon.ico"},851984:{category_id:13,name:"Google-books",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/google.com/favicon.ico"},851985:{category_id:13,name:"eBay",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/ebay.com/favicon.ico"},851986:{category_id:13,name:"hao123"},851987:{category_id:13,name:"Soso"},851988:{category_id:13,name:"Tmall"},851989:{category_id:13,name:"PayPal.com",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/paypal.com/favicon.ico"},851990:{category_id:13,name:"Ask.com"},851991:{category_id:13,name:"BBC"},851992:{category_id:13,name:"Alibaba.com"},851993:{category_id:13,name:"CNN.com",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/cnn.com/favicon.ico"},851995:{category_id:13,name:"Sogou.com"},851996:{category_id:13,name:"Evernote"},851997:{category_id:13,name:"About.com"},851998:{category_id:13,name:"Alipay.com"},851999:{category_id:13,name:"Imgur",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/imgur.com/favicon.ico"},852000:{category_id:13,name:"Adcash"},852001:{category_id:13,name:"Huffington Post",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/huffingtonpost.com/favicon.ico"},852002:{category_id:13,name:"360buy"},852003:{category_id:13,name:"ESPN"},852004:{category_id:13,name:"Books"},852005:{category_id:13,name:"Craigslist.org",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/craigslist.com/favicon.ico"},852006:{category_id:13,name:"Google-analytics",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/google.com/favicon.ico"},852007:{category_id:13,name:"Bing Maps",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/bing.com/favicon.ico"},852008:{category_id:13,name:"ETtoday "},852009:{category_id:13,name:"104 Job Bank"},852010:{category_id:13,name:"NOWnews"},852011:{category_id:13,name:"518 Job Bank"},852012:{category_id:13,name:"Chinatimes.com"},852013:{category_id:13,name:"GOHAPPY"},852014:{category_id:13,name:"591"},852015:{category_id:13,name:"8591"},852016:{category_id:13,name:"Chinatrust"},852017:{category_id:13,name:"Donga.com"},852018:{category_id:13,name:"Gmarket"},852019:{category_id:13,name:"Chosun.com"},852020:{category_id:13,name:"Cafe24.com"},852021:{category_id:13,name:"11st"},852022:{category_id:13,name:"MK.co.kr"},852023:{category_id:13,name:"Auction"},852024:{category_id:13,name:"Hankyung"},852025:{category_id:13,name:"Ppomppu"},852026:{category_id:13,name:"MT.co.kr"},852027:{category_id:13,name:"Zum.com"},852028:{category_id:13,name:"Hankooki"},852029:{category_id:13,name:"JOBKOREA"},852031:{category_id:13,name:"Khan.co.kr"},852032:{category_id:13,name:"Incruit"},852033:{category_id:13,name:"YES24"},852034:{category_id:13,name:"Amazon CloudFront",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/amazon.com/favicon.ico"},852035:{category_id:13,name:"Pcstore"},852036:{category_id:13,name:"Myfreshnet.com"},852037:{category_id:13,name:"Microsoft.com",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/microsoft.com/favicon.ico"},852038:{category_id:13,name:"Life.com.tw"},852039:{category_id:13,name:"Libertytimes"},852040:{category_id:13,name:"Lativ"},852041:{category_id:13,name:"Inven"},852042:{category_id:13,name:"cnYES"},852043:{category_id:13,name:"Babyhome"},852044:{category_id:13,name:"8comic.com"},852045:{category_id:13,name:"Ck101.com"},852046:{category_id:13,name:"Taiwanlottery"},852047:{category_id:13,name:"Momoshop"},852048:{category_id:13,name:"Eyny.com"},852049:{category_id:13,name:"Yam.com"},852050:{category_id:13,name:"PChome.com"},852051:{category_id:13,name:"Gamme"},852052:{category_id:13,name:"Apple.com",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/apple.com/favicon.ico"},852053:{category_id:13,name:"Hinet.net"},852054:{category_id:13,name:"Google-earth",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/google.com/favicon.ico"},852055:{category_id:13,name:"Saramin"},852056:{category_id:13,name:"KoreaHerald"},852057:{category_id:13,name:"Plus28.com"},852058:{category_id:13,name:"ChunghwaPost "},852059:{category_id:13,name:"Gomaji "},852060:{category_id:13,name:"NewSen"},852061:{category_id:13,name:"Etnews.com"},852062:{category_id:13,name:"Seoul.co.kr"},852063:{category_id:13,name:"YONHAPNEWS"},852064:{category_id:13,name:"Etoday.co.kr"},852065:{category_id:13,name:"Yesky.com"},852066:{category_id:13,name:"1111 Job Bank"},852067:{category_id:13,name:"Emart"},852068:{category_id:13,name:"KBstar"},852069:{category_id:13,name:"HERALDCORP"},852070:{category_id:13,name:"ActiveX"},852071:{category_id:13,name:"MSN.com",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/msn.com/favicon.ico"},852072:{category_id:13,name:"Edaily"},852073:{category_id:13,name:"Segye"},852074:{category_id:13,name:"Bobaedream"},852075:{category_id:13,name:"Nocutnews"},852076:{category_id:13,name:"MONETA.co.kr"},852077:{category_id:13,name:"Kukinews"},852078:{category_id:13,name:"Java Applet"},852079:{category_id:13,name:"Todayhumor"},852080:{category_id:13,name:"Inews24"},852081:{category_id:13,name:"KoreaTimes"},852082:{category_id:13,name:"OhmyNews"},852083:{category_id:13,name:"Aladin.co.kr"},852084:{category_id:13,name:"SK Encar"},852085:{category_id:13,name:"eTorrent"},852086:{category_id:13,name:"TVREPORT"},852087:{category_id:13,name:"Mydaily"},852088:{category_id:13,name:"Microsoft Live.com",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/microsoft.com/favicon.ico"},852089:{category_id:13,name:"News1.kr"},852090:{category_id:13,name:"Munhwa"},852091:{category_id:13,name:"Dreamwiz"},852092:{category_id:13,name:"Dailian.co.kr"},852093:{category_id:13,name:"Rediff.com"},852094:{category_id:13,name:"Akamai.net"},852097:{category_id:13,name:"Yugma"},852098:{category_id:13,name:"TPB PirateBrowser"},852100:{category_id:13,name:"Wikispaces"},852101:{category_id:13,name:"Wikidot"},852102:{category_id:13,name:"Google-play",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/google.com/favicon.ico"},852103:{category_id:13,name:"Wetpaint"},852104:{category_id:13,name:"Windows Store"},852105:{category_id:13,name:"Webshots"},852106:{category_id:13,name:"Kindle Cloud Reader"},852107:{category_id:13,name:"Nice264"},852109:{category_id:13,name:"Vyew"},852110:{category_id:13,name:"TikiWiki"},852111:{category_id:13,name:"Castfire"},852113:{category_id:13,name:"SugarCRM"},852115:{category_id:13,name:"Stumbleupon"},852119:{category_id:13,name:"Spark"},852120:{category_id:13,name:"Socialtext"},852122:{category_id:13,name:"PBworks"},852123:{category_id:13,name:"Fool"},852124:{category_id:13,name:"Showbie"},852125:{category_id:13,name:"MorningStar"},852127:{category_id:13,name:"MoinMoin"},852128:{category_id:13,name:"AppStore"},852129:{category_id:13,name:"Ragingbull"},852130:{category_id:13,name:"Daum"},852131:{category_id:13,name:"Google-docs",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/google.com/favicon.ico"},852133:{category_id:13,name:"Naver"},852134:{category_id:13,name:"Editgrid"},852135:{category_id:13,name:"Jaspersoft"},852136:{category_id:13,name:"Clarizen"},852139:{category_id:13,name:"Interpark"},852140:{category_id:13,name:"Hyundaihmall"},852141:{category_id:13,name:"Groupon"},852142:{category_id:13,name:"Gsshop"},852143:{category_id:13,name:"Wemakeprice"},852144:{category_id:13,name:"Lotte.com"},852145:{category_id:13,name:"Coupang"},852147:{category_id:13,name:"Google-alerts",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/google.com/favicon.ico"},852149:{category_id:13,name:"Dnshop.com"},852150:{category_id:13,name:"ZoomSpider crawler"},852151:{category_id:13,name:"Win Web Crawler"},852152:{category_id:13,name:"HTTrack crawler"},852153:{category_id:13,name:"Abot crawler"},852154:{category_id:13,name:"Googlebot crawler",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/google.com/favicon.ico"},852155:{category_id:13,name:"Microsoft bingbot crawler",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/microsoft.com/favicon.ico"},852156:{category_id:13,name:"Yahoo Slurp crawler",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/yahoo.com/favicon.ico"},852157:{category_id:13,name:"Beanfun"},852159:{category_id:13,name:"ifeng.com"},852160:{category_id:13,name:"Conduit Mobile"},852162:{category_id:13,name:"Gamebase"},852163:{category_id:13,name:"Kingstone"},852164:{category_id:13,name:"Udn.com"},852166:{category_id:13,name:"Sportsseoul"},852167:{category_id:13,name:"Babylon "},852168:{category_id:13,name:"Yahoo Finance",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/yahoo.com/favicon.ico"},852171:{category_id:13,name:"Jira"},852172:{category_id:13,name:"PHPwiki"},852174:{category_id:13,name:"WebCT"},852175:{category_id:13,name:"Youseemore"},852176:{category_id:13,name:"Zwiki-editing"},852177:{category_id:13,name:"Adobe.com"},852178:{category_id:13,name:"Backpackit/Campfire"},852180:{category_id:13,name:"ERoom-net"},852184:{category_id:13,name:"Glide"},852186:{category_id:13,name:"Mediawiki"},852189:{category_id:13,name:"MSN Money",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/msn.com/favicon.ico"},852190:{category_id:13,name:"HTTP"},852191:{category_id:13,name:"AOL Toolbar",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/aol.com/favicon.ico"},852193:{category_id:13,name:"Uber"},852194:{category_id:13,name:"Web-crawler"},852195:{category_id:13,name:"RSS"},852196:{category_id:13,name:"WeatherBug"},852197:{category_id:13,name:"Yahoo Toolbar",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/yahoo.com/favicon.ico"},852198:{category_id:13,name:"Alexa Toolbar"},852199:{category_id:13,name:"Internet Archive"},852200:{category_id:13,name:"Wikipedia",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/wikipedia.com/favicon.ico"},852201:{category_id:13,name:"Wiktionary"},852202:{category_id:13,name:"Amazon",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/amazon.com/favicon.ico"},852203:{category_id:13,name:"Google-toolbar",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/google.com/favicon.ico"},852204:{category_id:13,name:"Google-maps",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/google.com/favicon.ico"},852205:{category_id:13,name:"Zoho"},852206:{category_id:13,name:"Microsoft Internet Explorer",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/microsoft.com/favicon.ico"},852207:{category_id:13,name:"Localmind"},852208:{category_id:13,name:"PulseNews"},852209:{category_id:13,name:"BookU(M)"},852210:{category_id:13,name:"Zappos"},852211:{category_id:13,name:"Expedia(M)"},852212:{category_id:13,name:"AdF.ly"},852213:{category_id:13,name:"Baidu"},852214:{category_id:13,name:"Yahoo",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/yahoo.com/favicon.ico"},852215:{category_id:13,name:"Taobao"},852216:{category_id:13,name:"163.com"},852217:{category_id:13,name:"Sina.com"},852218:{category_id:13,name:"Bing.com",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/bing.com/favicon.ico"},852219:{category_id:13,name:"Ruten"},852220:{category_id:13,name:"Shop.com"},852221:{category_id:13,name:"Appledaily"},852222:{category_id:13,name:"CWB"},852223:{category_id:13,name:"CNA"},86:{category_id:0,name:"KikMessenger"},87:{category_id:0,name:"Doshow"},88:{category_id:0,name:"Mibbit"},89:{category_id:0,name:"YY"},9:{category_id:0,name:"Google Talk",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/google.com/favicon.ico"},90:{category_id:0,name:"Ispeak"},91:{category_id:0,name:"VzoChat"},917508:{category_id:14,name:"BitDefender"},917509:{category_id:14,name:"360Safe"},917510:{category_id:14,name:"Rising"},917511:{category_id:14,name:"TortoiseSVN"},917513:{category_id:14,name:"Microsoft Windows Update",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/microsoft.com/favicon.ico"},917514:{category_id:14,name:"Norton"},917515:{category_id:14,name:"Sophos"},917516:{category_id:14,name:"Yum"},917517:{category_id:14,name:"MIUI"},917518:{category_id:14,name:"Adobe"},917519:{category_id:14,name:"InstallAnyWhere"},917520:{category_id:14,name:"Kaspersky"},917521:{category_id:14,name:"Mcafee"},917522:{category_id:14,name:"TrendMicro"},917523:{category_id:14,name:"F-Secure"},917524:{category_id:14,name:"NOD32"},917525:{category_id:14,name:"Avast"},917526:{category_id:14,name:"Jiangmin"},917527:{category_id:14,name:"Avira"},917528:{category_id:14,name:"Emsisoft"},917529:{category_id:14,name:"Panda"},917530:{category_id:14,name:"AVG"},917531:{category_id:14,name:"PCTools"},917533:{category_id:14,name:"Outpost"},917534:{category_id:14,name:"Spybot"},917535:{category_id:14,name:"Duba"},917536:{category_id:14,name:"Apple",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/apple.com/favicon.ico"},917538:{category_id:14,name:"Google Update",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/google.com/favicon.ico"},917540:{category_id:14,name:"JAVA Update"},917541:{category_id:14,name:"SONY PC Companion"},917542:{category_id:14,name:"SketchUp"},917543:{category_id:14,name:"Webroot"},92:{category_id:0,name:"Trillian"},93:{category_id:0,name:"HipChat"},94:{category_id:0,name:"IntraMessenger"},95:{category_id:0,name:"BitWise"},96:{category_id:0,name:"Barablu"},97:{category_id:0,name:"Whoshere(M)"},98:{category_id:0,name:"LiiHo(M)"},983043:{category_id:15,name:"eBuddy.com"},983044:{category_id:15,name:"iLoveIM.com"},983047:{category_id:15,name:"imo.im"},983048:{category_id:15,name:"Chikka"},983050:{category_id:15,name:"QQ Web Messenger"},983051:{category_id:15,name:"AOL",iconUrl:"/lib/1.0.2.1095/images/dpi_icons/aol.com/favicon.ico"},983054:{category_id:15,name:"ICQ Web Messenger"},983057:{category_id:15,name:"AirAim"},983058:{category_id:15,name:"Instan-t Web Messenger"},983065:{category_id:15,name:"TaoBao AliWW"},983069:{category_id:15,name:"Gadu-Gadu Web Messenger"},983070:{category_id:15,name:"Karoo Lark"},983072:{category_id:15,name:"IM+"},99:{category_id:0,name:"Appme(M)"}},categories:{0:{applications:[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,31,32,33,34,35,36,37,38,41,42,43,44,46,49,54,55,56,57,58,59,61,62,64,65,66,67,68,69,72,77,78,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,106,107,108],name:"Instant messaging"},1:{applications:[65538,65540,65542,65543,65544,65545,65546,65547,65548,65549,65550,65551,65552,65553,65554,65555,65557,65559,65563,65565,65566,65568,65569,65570,65571,65572,65573,65574,65575,65576,65577,65578,65580,65581,65582,65583,65584,65585,65587,65588,65590,65591,65594,65598,65600,65604,65609,65612,65613,65617,65620,65621,65622,65630,65633,65634,65635,65636,65640,65642,65648,65652,65655,65664,65665,65666,65685,65688,65689,65690,65691,65692,65693,65694,65695,65696,65697,65698,65699,65700,65701,65702,65703,65704,65705,65706,65707,65708,65709,65710,65711,65712,65713,65714,65715,65716,65717,65718,65719,65720,65721,65722,65723,65724,65725,65726,65727,65728,65729,65730,65731,65732,65733,65734,65735,65736,65737,65738,65739,65740,65741,65742,65743,65744,65745,65746,65747,65748,65749,65750,65751,65752,65753,65754,65755,65756,65757,65758,65759,65760,65761,65762,65763,65764,65765,65766,65767,65768,65769,65770,65771,65772,65773,65774,65775,65776,65777,65778,65779,65780,65781,65782,65783,65784,65785,65786,65787],name:"P2P"},10:{applications:[655361,655362,655363,655364,655365,655366,655367,655369,655370,655371,655372,655373,655374,655375,655376,655377,655378,655379,655380,655381,655385,655395,655396,655398,655402,655403],name:"Remote Access Terminals"},11:{applications:[720898,720899,720900,720901,720902,720903,720904,720905,720906,720907,720909,720910,720911,720912,720913,720914,720915,720916,720917,720918,720919,720920,720921,720922,720925,720926,720928,720930,720933,720946,720948,720950,720951,720952,720954,720959,720960,720961,720962,720963,720964,720966,720967,720969,720970,720971,720972,720973,720974,720977,720979,720980,720983,720984,720985,720986,720987,720988,720989,720991,720992],name:"Bypass Proxies and Tunnels"},12:{applications:[786434,786435,786437,786438,786439,786440,786441,786443,786444,786449,786450,786451,786453,786454,786455,786457,786458],name:"Stock Market"},13:{applications:[851969,851970,851971,851972,851973,851974,851975,851976,851977,851978,851980,851981,851982,851983,851984,851985,851986,851987,851988,851989,851990,851991,851992,851993,851995,851996,851997,851998,851999,852e3,852001,852002,852003,852004,852005,852006,852007,852008,852009,852010,852011,852012,852013,852014,852015,852016,852017,852018,852019,852020,852021,852022,852023,852024,852025,852026,852027,852028,852029,852031,852032,852033,852034,852035,852036,852037,852038,852039,852040,852041,852042,852043,852044,852045,852046,852047,852048,852049,852050,852051,852052,852053,852054,852055,852056,852057,852058,852059,852060,852061,852062,852063,852064,852065,852066,852067,852068,852069,852070,852071,852072,852073,852074,852075,852076,852077,852078,852079,852080,852081,852082,852083,852084,852085,852086,852087,852088,852089,852090,852091,852092,852093,852094,852097,852098,852100,852101,852102,852103,852104,852105,852106,852107,852109,852110,852111,852113,852115,852119,852120,852122,852123,852124,852125,852127,852128,852129,852130,852131,852133,852134,852135,852136,852139,852140,852141,852142,852143,852144,852145,852147,852149,852150,852151,852152,852153,852154,852155,852156,852157,852159,852160,852162,852163,852164,852166,852167,852168,852171,852172,852174,852175,852176,852177,852178,852180,852184,852186,852189,852190,852191,852193,852194,852195,852196,852197,852198,852199,852200,852201,852202,852203,852204,852205,852206,852207,852208,852209,852210,852211,852212,852213,852214,852215,852216,852217,852218,852219,852220,852221,852222,852223],name:"Web / Web 2.0"},14:{applications:[917508,917509,917510,917511,917513,917514,917515,917516,917517,917518,917519,917520,917521,917522,917523,917524,917525,917526,917527,917528,917529,917530,917531,917533,917534,917535,917536,917538,917540,917541,917542,917543],name:"Security Update"},15:{applications:[983043,983044,983047,983048,983050,983051,983054,983057,983058,983065,983069,983070,983072],name:"Web IM"},17:{applications:[1114113,1114114,1114115,1114117,1114118,1114119,1114120,1114121,1114122,1114124,1114125,1114128,1114129,1114130,1114131,1114133,1114134,1114138,1114140,1114141,1114142,1114150,1114151,1114152,1114155,1114158,1114160,1114161,1114167,1114169,1114170,1114176,1114177,1114180,1114182,1114187,1114188,1114191,1114195,1114198,1114201,1114203,1114205,1114206,1114212,1114213,1114222,1114229,1114238,1114239,1114246,1114248,1114250,1114252,1114253,1114255,1114269,1114272,1114273,1114274,1114275,1114277,1114279,1114289,1114290,1114308,1114309,1114310,1114311,1114318,1114320,1114321,1114322,1114330,1114331,1114334,1114335,1114337,1114339,1114340,1114342,1114343,1114347,1114350,1114351,1114352,1114355,1114359,1114361,1114363,1114365],name:"Business"},18:{applications:[1179649,1179650,1179651,1179653,1179654,1179655,1179660,1179665,1179667,1179668,1179669,1179670,1179671,1179672,1179673,1179674,1179675,1179676,1179677,1179678,1179679,1179680,1179681,1179682,1179683,1179684,1179685,1179686,1179687,1179688,1179689,1179690,1179691,1179692,1179693,1179694,1179695,1179696,1179697,1179698,1179699,1179700,1179701,1179702,1179704,1179705,1179706,1179707,1179708,1179709,1179710,1179711,1179712,1179713,1179714,1179715,1179716,1179717,1179718,1179719,1179720,1179721,1179722,1179723,1179724,1179725,1179726,1179727,1179728,1179729,1179731,1179732,1179733,1179734,1179735,1179737,1179739,1179740,1179742,1179743,1179744,1179745,1179746,1179747,1179748,1179749,1179752,1179753,1179754,1179755,1179756,1179757,1179758,1179759,1179760,1179761,1179762,1179763,1179764,1179765,1179766,1179767,1179768,1179769,1179770,1179771,1179772,1179773,1179774,1179775,1179776,1179777,1179778,1179779,1179780,1179781,1179782,1179783,1179784,1179785,1179786,1179787,1179788,1179789,1179790,1179791,1179793,1179794,1179795,1179796,1179797,1179798,1179799,1179800,1179801,1179802,1179803,1179804,1179805,1179806,1179807,1179808,1179809,1179810,1179811,1179812,1179813,1179814,1179815,1179816,1179817,1179818,1179819,1179820,1179821,1179822,1179823,1179824,1179825,1179826,1179827,1179828,1179829,1179830,1179831,1179832,1179833,1179834,1179835,1179836,1179838,1179839,1179840,1179841,1179842,1179843,1179844,1179845,1179846,1179847,1179848,1179849,1179850,1179851,1179852,1179853,1179854,1179855,1179856,1179857,1179858,1179860,1179862,1179863,1179864,1179865,1179866,1179867,1179868,1179869,1179870,1179871,1179872,1179873,1179874,1179875,1179876,1179877,1179878,1179879,1179880,1179881,1179882,1179883,1179884,1179885,1179886,1179887,1179888,1179889,1179890,1179891,1179892,1179893,1179894,1179895,1179896,1179897,1179898,1179899,1179900,1179901,1179902,1179903],name:"Network Protocols"},19:{applications:[1245187,1245188,1245189,1245190,1245191,1245192,1245193,1245195,1245196,1245197,1245198,1245200,1245201,1245202,1245203,1245204,1245205,1245206,1245207,1245208,1245209,1245210,1245211,1245212,1245213,1245214,1245215,1245216,1245217,1245218,1245219,1245220,1245221,1245222,1245223,1245224,1245225,1245226,1245228,1245229,1245230,1245231,1245232,1245233,1245234,1245235,1245236,1245237,1245238,1245239,1245240,1245241,1245242,1245243,1245244,1245245,1245246,1245247,1245248,1245249,1245250,1245251,1245252,1245253,1245254,1245255,1245256,1245257,1245258,1245259,1245260,1245261,1245262,1245263,1245264,1245265,1245266,1245267,1245268,1245269,1245270,1245271,1245272,1245273,1245274,1245275,1245276,1245277,1245278,1245279,1245280,1245281,1245282,1245283,1245284,1245285,1245286,1245287,1245288,1245289,1245290,1245291,1245292,1245294,1245295,1245296,1245297,1245298,1245299,1245300,1245301,1245302,1245303,1245304,1245305,1245306,1245307,1245308,1245309,1245310,1245311,1245312,1245313,1245314,1245316,1245318,1245319,1245320,1245321,1245322,1245324,1245325,1245326,1245327,1245328,1245329,1245330,1245331,1245332,1245333,1245334,1245335,1245336,1245337,1245338,1245339,1245340,1245341,1245342,1245343,1245344,1245345,1245346,1245347,1245348,1245349,1245350,1245351,1245352,1245353,1245354,1245355,1245356,1245357,1245358,1245359,1245360,1245361,1245362,1245363,1245364,1245365,1245366,1245370,1245371,1245372,1245373,1245374,1245375,1245376,1245377,1245378,1245379,1245380,1245381,1245382,1245383,1245384,1245385,1245386,1245387,1245388,1245389,1245390,1245391,1245392,1245393,1245394,1245395,1245396,1245397,1245398,1245399,1245400,1245402,1245403,1245404,1245405,1245406,1245407,1245408,1245409,1245410,1245411,1245412,1245413,1245414,1245415,1245416,1245417,1245418,1245419,1245420,1245421,1245422,1245423,1245424,1245425,1245426,1245427,1245428,1245429,1245430,1245431,1245432,1245433,1245434,1245435,1245436,1245437,1245438,1245439],
name:"Network Protocols"},20:{applications:[1310721,1310722,1310723,1310724,1310725,1310726,1310727,1310728,1310729,1310730,1310731,1310732,1310733,1310734,1310735,1310736,1310737,1310738,1310739,1310740,1310741,1310742,1310743,1310744,1310745,1310746,1310747,1310748,1310749,1310750,1310751,1310752,1310753,1310754,1310755,1310756,1310757,1310758,1310759,1310760,1310761,1310762,1310763,1310764,1310765,1310766,1310767,1310768,1310769,1310770,1310771,1310772,1310773,1310774,1310775,1310776,1310777,1310778,1310779,1310780,1310781,1310782,1310783,1310784,1310785,1310786,1310787,1310788,1310789,1310790,1310791,1310792,1310793,1310794,1310795,1310796,1310797,1310798,1310799,1310800,1310801,1310802,1310803,1310804,1310805,1310806,1310807,1310808,1310809,1310810,1310811,1310812,1310813,1310814,1310815,1310816,1310817,1310818,1310819,1310820,1310821,1310822,1310823,1310824,1310825,1310826,1310827,1310828,1310830,1310832,1310833,1310834,1310835,1310836,1310837,1310839,1310840,1310841,1310842,1310843,1310844,1310845,1310846,1310847,1310848,1310849,1310850,1310851,1310852,1310853,1310854,1310855,1310856,1310857,1310858,1310859,1310860,1310861,1310862,1310863,1310864,1310865,1310866,1310867,1310868,1310869,1310870,1310871,1310872,1310873,1310874,1310875,1310878,1310879,1310880,1310881,1310882,1310883,1310884,1310887,1310888,1310889,1310890,1310891,1310892,1310893,1310894,1310895,1310896,1310897,1310898,1310899,1310900,1310902,1310903,1310904,1310905,1310906,1310907,1310908,1310909,1310910],name:"Network Protocols"},21:{applications:[1376306,1376323,1376357,1376359],name:"Mobile"},23:{applications:[1507329,1507330,1507333],name:"Private Protocol"},24:{applications:[1572865,1572866,1572867,1572868,1572870,1572871,1572872,1572873,1572874,1572875,1572876,1572880,1572881,1572882,1572883,1572884,1572885,1572886,1572887,1572889,1572890,1572891,1572892,1572893,1572894,1572895,1572896,1572897,1572898,1572899,1572900,1572901,1572902,1572903,1572905,1572906,1572907,1572908,1572909,1572910,1572911,1572912,1572913,1572914,1572915,1572916,1572917,1572918,1572919,1572920,1572921,1572922,1572923,1572927,1572928,1572929,1572930,1572931,1572967,1572968,1572970,1572974,1572975,1572976,1572977,1572978,1572980,1572981,1572983,1572985,1572987,1572988,1572989,1572990,1572998,1572999,1573e3,1573004,1573005,1573006,1573007,1573008,1573009,1573010,1573011,1573014,1573015,1573016,1573017,1573018,1573019,1573020,1573021,1573022,1573023,1573024,1573025,1573026,1573027,1573028,1573029,1573030,1573031,1573032,1573033,1573035],name:"Social Network"},255:{applications:[65535],name:"Unknown"},28:{applications:[1835009,1835010,1835011,1835012,1835013,1835014,1835015,1835016,1835017,1835018,1835019,1835020,1835021,1835022,1835023,1835024,1835025,1835026,1835027,1835028,1835029,1835030,1835031,1835032,1835033,1835034,1835035,1835036,1835037,1835038,1835039,1835040,1835041,1835042,1835043,1835044,1835045,1835046,1835047,1835048,1835049,1835050,1835051,1835052,1835053,1835054,1835055,1835056,1835057,1835058,1835059,1835060,1835061,1835062,1835063,1835064,1835065,1835066,1835067,1835068,1835069,1835070,1835071,1835072,1835073,1835074,1835075,1835076,1835077,1835078,1835079,1835080,1835081,1835082,1835083,1835084,1835085,1835086,1835087,1835088,1835089,1835090,1835091,1835092,1835093,1835094,1835095,1835096,1835097,1835098,1835099,1835100,1835101,1835102,1835103,1835104,1835105,1835106,1835107,1835108],name:"TopSites-Adult"},29:{applications:[1900545,1900546,1900547,1900548,1900549,1900550,1900551,1900552,1900553,1900554,1900555,1900556,1900557,1900558,1900559,1900560,1900561,1900562,1900563,1900564,1900565,1900566,1900567,1900568,1900569,1900570,1900571,1900572,1900573,1900574,1900575,1900576,1900577,1900578,1900579,1900580,1900581,1900582,1900583,1900584,1900585,1900586,1900587,1900588,1900589,1900590,1900591,1900592,1900593,1900594,1900595,1900596,1900597,1900598,1900599,1900600,1900601,1900602,1900603,1900604,1900605,1900606,1900607,1900608,1900609,1900610,1900611,1900612,1900613,1900614,1900615,1900616,1900617,1900618,1900619,1900620,1900621,1900622,1900623,1900624,1900625,1900626,1900627,1900628,1900629],name:"TopSites-Arts"},3:{applications:[196609,196610,196611,196612,196613,196614,196615,196616,196617,196618,196619,196620,196621,196622,196624,196626,196627,196628,196629,196630,196631,196632,196633,196634,196635,196637,196638,196640,196641,196642,196643,196644,196645,196646,196647,196648,196649,196650,196651,196652,196653,196655,196656,196657,196669,196676,196678,196680,196681,196683,196684,196686,196689,196692,196693,196694,196695,196696,196697,196700,196701,196702,196703,196705,196706,196708,196709,196711,196713,196714,196716,196717,196718,196722,196723,196724,196725,196726,196727,196728,196729,196731,196732,196733,196735,196737,196738,196739,196742,196743,196744,196746,196747,196748,196749,196750,196751,196752,196753,196754,196755,196756,196757,196758,196759,196760,196761,196762,196764,196765,196766,196767,196768,196769,196770,196771,196772,196773,196774,196775,196777],name:"File Transfer"},30:{applications:[1966081,1966082,1966083,1966084,1966085,1966086,1966087,1966088,1966089,1966090,1966091,1966092,1966093,1966094,1966095,1966096,1966097,1966098,1966099,1966100,1966101,1966102,1966103,1966104,1966105,1966106,1966107,1966108,1966109,1966110,1966111,1966112,1966113,1966114,1966115,1966116,1966117,1966118,1966119,1966120,1966121,1966122,1966123,1966124,1966125,1966126,1966127,1966128,1966129,1966130,1966131,1966132,1966133,1966134,1966135,1966136,1966137,1966138,1966139,1966140,1966141,1966142,1966143,1966144,1966145,1966146,1966147,1966148,1966149,1966150,1966151,1966152,1966153,1966154,1966155,1966156,1966157,1966158,1966159,1966160,1966161,1966162,1966163,1966164,1966165,1966166,1966167,1966168,1966169,1966170,1966171,1966172,1966173],name:"TopSites-Business"},31:{applications:[2031617,2031618,2031619,2031620,2031621,2031622,2031623,2031624,2031625,2031626,2031627,2031628,2031629,2031630,2031631,2031632,2031633,2031634,2031635,2031636,2031637,2031638,2031639,2031640,2031641,2031642,2031643,2031644,2031645,2031646,2031647,2031648,2031649,2031650,2031651,2031652,2031653,2031654,2031655,2031656,2031657,2031658,2031659,2031660,2031661,2031662,2031663,2031664,2031665,2031666,2031667,2031668,2031669,2031670,2031671,2031672,2031673,2031674,2031675,2031676,2031677,2031678,2031679,2031680],name:"TopSites-Computers"},32:{applications:[2097153,2097154,2097155,2097156,2097157,2097158,2097159,2097160,2097161,2097162,2097163,2097164,2097165,2097166,2097167,2097168,2097169,2097170,2097171,2097172,2097173,2097174,2097175,2097176,2097177,2097178,2097179,2097180,2097181,2097182,2097183,2097184,2097185,2097186,2097187,2097188,2097189,2097190,2097191,2097192,2097193,2097194,2097195,2097196,2097197,2097198,2097199,2097200,2097201,2097202,2097203,2097204,2097205,2097206,2097207,2097208,2097209,2097210,2097211,2097212,2097213,2097214,2097215,2097216,2097217,2097218,2097219,2097220,2097221,2097222,2097223,2097224,2097225,2097226,2097227,2097228,2097229,2097230,2097231,2097232,2097233,2097234,2097235,2097236,2097237,2097238,2097239,2097240,2097241,2097242,2097243,2097244,2097245,2097246,2097247],name:"TopSites-Games"},33:{applications:[2162689,2162690,2162691,2162692,2162693,2162694,2162695,2162696,2162697,2162698,2162699,2162700,2162701,2162702,2162703,2162704,2162705,2162706,2162707,2162708,2162709,2162710,2162711,2162712,2162713,2162714,2162715,2162716,2162717,2162718,2162719,2162720,2162721,2162722,2162723,2162724,2162725,2162726,2162727,2162728,2162729,2162730,2162731,2162732,2162733,2162734,2162735,2162736,2162737,2162738,2162739,2162740,2162741,2162742,2162743,2162744,2162745,2162746,2162747,2162748,2162749,2162750,2162751,2162752,2162753,2162754,2162755,2162756,2162757,2162758,2162759,2162760,2162761,2162762,2162763,2162764,2162765,2162766,2162767,2162768,2162769,2162770,2162771,2162772,2162773,2162774,2162775,2162776,2162777,2162778,2162779],name:"TopSites-Health"},34:{applications:[2228225,2228226,2228227,2228228,2228229,2228230,2228231,2228232,2228233,2228234,2228235,2228236,2228237,2228238,2228239,2228240,2228241,2228242,2228243,2228244,2228245,2228246,2228247,2228248,2228249,2228250,2228251,2228252,2228253,2228254,2228255,2228256,2228257,2228258,2228259,2228260,2228261,2228262,2228263,2228264,2228265,2228266,2228267,2228268,2228269,2228270,2228271,2228272,2228273,2228274,2228275,2228276,2228277,2228278,2228279,2228280,2228281,2228282,2228283,2228284,2228285,2228286,2228287,2228288,2228289,2228290,2228291,2228292,2228293,2228294,2228295,2228296,2228297,2228298,2228299,2228300,2228301,2228302,2228303,2228304,2228305,2228306,2228307,2228308,2228309,2228310,2228311,2228312,2228313,2228314],name:"TopSites-Home"},35:{applications:[2293761,2293762,2293763,2293764,2293765,2293766,2293767,2293768,2293769,2293770,2293771,2293772,2293773,2293774,2293775,2293776,2293777,2293778,2293779,2293780,2293781,2293782,2293783,2293784,2293785,2293786,2293787,2293788,2293789,2293790,2293791,2293792,2293793,2293794,2293795,2293796,2293797,2293798,2293799,2293800,2293801,2293802,2293803,2293804,2293805,2293806,2293807,2293808,2293809,2293810,2293811,2293812,2293813,2293814,2293815,2293816,2293817,2293818,2293819,2293820,2293821,2293822],name:"TopSites-KidsnTeens"},36:{applications:[2359297,2359298,2359299,2359300,2359301,2359302,2359303,2359304,2359305,2359306,2359307,2359308,2359309,2359310,2359311,2359312,2359313,2359314,2359315,2359316,2359317,2359318,2359319,2359320,2359321,2359322,2359323,2359324,2359325,2359326,2359327,2359328,2359329,2359330,2359331,2359332,2359333,2359334,2359335,2359336,2359337,2359338,2359339,2359340,2359341,2359342,2359343,2359344,2359345,2359346,2359347,2359348,2359349,2359350,2359351,2359352,2359353,2359354,2359355,2359356,2359357,2359358,2359359,2359360,2359361,2359362,2359363,2359364,2359365],name:"TopSites-News"},37:{applications:[2424833,2424834,2424835,2424836,2424837,2424838,2424839,2424840,2424841,2424842,2424843,2424844,2424845,2424846,2424847,2424848,2424849,2424850,2424851,2424852,2424853,2424854,2424855,2424856,2424857,2424858,2424859,2424860,2424861,2424862,2424863,2424864,2424865,2424866,2424867,2424868,2424869,2424870,2424871,2424872,2424873,2424874,2424875,2424876,2424877,2424878,2424879,2424880,2424881,2424882,2424883,2424884,2424885,2424886,2424887,2424888,2424889,2424890,2424891,2424892,2424893,2424894,2424895,2424896,2424897,2424898,2424899,2424900,2424901,2424902,2424903,2424904,2424905,2424906,2424907,2424908,2424909,2424910,2424911,2424912,2424913,2424914,2424915,2424916,2424917,2424918,2424919,2424920],name:"TopSites-Recreation"},38:{applications:[2490369,2490370,2490371,2490372,2490373,2490374,2490375,2490376,2490377,2490378,2490379,2490380,2490381,2490382,2490383,2490384,2490385,2490386,2490387,2490388,2490389,2490390,2490391,2490392,2490393,2490394,2490395,2490396,2490397,2490398,2490399,2490400,2490401,2490402,2490403,2490404,2490405,2490406,2490407,2490408,2490409,2490410,2490411,2490412,2490413,2490414,2490415,2490416,2490417,2490418,2490419,2490420,2490421,2490422,2490423,2490424,2490425,2490426,2490427,2490428,2490429,2490430,2490431,2490432,2490433,2490434,2490435,2490436,2490437,2490438,2490439,2490440,2490441,2490442,2490443,2490444,2490445,2490446,2490447],name:"TopSites-Reference"},39:{applications:[2555905,2555906,2555907,2555908,2555909,2555910,2555911,2555912,2555913,2555914,2555915,2555916,2555917,2555918,2555919,2555920,2555921,2555922,2555923,2555924,2555925,2555926,2555927,2555928,2555929,2555930,2555931,2555932,2555933,2555934,2555935,2555936,2555937,2555938,2555939,2555940,2555941,2555942,2555943,2555944,2555945,2555946,2555947,2555948,2555949,2555950],name:"TopSites-Regional"},4:{applications:[262145,262146,262147,262148,262149,262150,262151,262152,262153,262154,262155,262156,262157,262158,262159,262160,262161,262162,262163,262164,262165,262166,262167,262168,262169,262170,262171,262172,262173,262174,262175,262176,262177,262178,262179,262181,262182,262183,262184,262185,262186,262187,262188,262189,262190,262191,262192,262193,262194,262195,262196,262197,262198,262199,262200,262201,262202,262203,262204,262205,262207,262208,262209,262210,262211,262212,262213,262214,262215,262216,262217,262218,262219,262220,262221,262223,262224,262226,262227,262228,262229,262230,262231,262232,262233,262234,262235,262236,262237,262238,262239,262245,262246,262247,262250,262251,262252,262254,262256,262258,262259,262260,262261,262262,262263,262264,262265,262266,262267,262268,262270,262271,262272,262274,262275,262276,262277,262278,262279,262280,262281,262283,262284,262285,262286,262287,262288,262290,262291,262292,262293,262294,262295,262296,262298,262301,262302,262303,262305,262306,262308,262310,262311,262312,262313,262314,262315,262316,262317,262318,262319,262320,262321,262322,262323,262324,262325,262326,262327,262328,262329,262330,262331,262332,262333,262334,262335,262336,262337,262338,262339,262340,262341,262342,262343,262344,262345,262346,262347,262348,262349],name:"Streaming Media"},40:{applications:[2621441,2621442,2621443,2621444,2621445,2621446,2621447,2621448,2621449,2621450,2621451,2621452,2621453,2621454,2621455,2621456,2621457,2621458,2621459,2621460,2621461,2621462,2621463,2621464,2621465,2621466,2621467,2621468,2621469,2621470,2621471,2621472,2621473,2621474,2621475,2621476,2621477,2621478,2621479,2621480,2621481,2621482,2621483,2621484,2621485,2621486,2621487,2621488,2621489,2621490,2621491,2621492,2621493,2621494,2621495,2621496,2621497,2621498,2621499,2621500,2621501,2621502,2621503],name:"TopSites-Science"},41:{applications:[2686977,2686978,2686979,2686980,2686981,2686982,2686983,2686984,2686985,2686986,2686987,2686988,2686989,2686990,2686991,2686992,2686993,2686994,2686995,2686996,2686997,2686998,2686999,2687e3,2687001,2687002,2687003,2687004,2687005,2687006,2687007,2687008,2687009,2687010,2687011,2687012,2687013,2687014,2687015,2687016,2687017,2687018,2687019,2687020,2687021,2687022,2687023,2687024,2687025,2687026,2687027,2687028,2687029,2687030,2687031,2687032,2687033,2687034,2687035,2687036,2687037,2687038,2687039,2687040,2687041,2687042,2687043,2687044,2687045,2687046,2687047,2687048,2687049,2687050,2687051,2687052,2687053,2687054,2687055,2687056],name:"TopSites-Shopping"},42:{applications:[2752513,2752514,2752515,2752516,2752517,2752518,2752519,2752520,2752521,2752522,2752523,2752524,2752525,2752526,2752527,2752528,2752529,2752530,2752531,2752532,2752533,2752534,2752535,2752536,2752537,2752538,2752539,2752540,2752541,2752542,2752543,2752544,2752545,2752546,2752547,2752548,2752549,2752550,2752551,2752552,2752553,2752554,2752555,2752556,2752557,2752558,2752559,2752560,2752561,2752562,2752563,2752564,2752565,2752566,2752567,2752568,2752569,2752570,2752571,2752572,2752573,2752574,2752575,2752576,2752577,2752578,2752579,2752580,2752581,2752582,2752583,2752584,2752585,2752586,2752587,2752588,2752589,2752590,2752591],name:"TopSites-Society"},43:{applications:[2818049,2818050,2818051,2818052,2818053,2818054,2818055,2818056,2818057,2818058,2818059,2818060,2818061,2818062,2818063,2818064,2818065,2818066,2818067,2818068,2818069,2818070,2818071,2818072,2818073,2818074,2818075,2818076,2818077,2818078,2818079,2818080,2818081,2818082,2818083,2818084,2818085,2818086,2818087,2818088,2818089,2818090,2818091,2818092,2818093,2818094,2818095,2818096,2818097,2818098,2818099,2818100,2818101,2818102],name:"TopSites-Sports"},5:{applications:[327681,327682,327683,327684,327685,327686,327687,327689,327690,327691,327692,327693,327694,327695,327696,327697,327698,327699,327700,327701,327702,327703,327704,327705,327706,327707,327708,327709,327710,327711,327712,327713,327714,327715,327716,327717,327718,327720,327722,327723,327732,327742,327743,327744,327745,327746,327747,327749,327751,327753,327755,327760,327761,327762,327763,327764,327770,327774,327775,327776,327778,327779,327780,327781,327782,327783,327784,327785,327786,327787,327788,327789,327790,327791,327792,327793,327794,327795],name:"Mail and Collaboration"},6:{applications:[393217,393218,393220,393221,393222,393223,393225,393226,393228,393229,393230,393231,393232,393234,393235,393236,393238,393239,393240,393242,393243,393244,393246,393247],name:"Voice over IP"},7:{applications:[458753,458754,458755,458756,458757,458760,458761,458763,458766,458767,458768],name:"Database"},8:{applications:[524289,524290,524291,524292,524293,524294,524295,524296,524297,524298,524299,524300,524301,524302,524303,524304,524306,524307,524308,524310,524311,524312,524313,524314,524315,524316,524317,524318,524319,524320,524321,524322,524323,524324,524326,524327,524328,524329,524330,524331,524332,524333,524334,524335,524336,524337,524338,524339,524340,524341,524343,524344,524345,524346,524347,524348,524349,524350,524351,524352,524353,524354,524355,524356,524358,524359,524360,524361,524362,524363,524364,524365,524366,524367,524368,524369,524370,524371,524372,524373,524374,524375,524376,524377,524379,524380,524381,524383,524384,524385,524386,524388,524389,524390,524391,524392,524393,524394,524395,524396,524398,524399,524400,524401,524402,524403,524404,524405,524406,524407,524408,524409,524410,524411,524412,524413,524414,524415,524416,524417,524418,524419,524420,524421,524422,524423,524424,524425,524426,524427,524428,524429,524430,524431,524432,524433,524434,524435,524436,524437,524438,524439,524440,524441,524442,524443,524444,524445,524446,524447,524448,524449,524450,524451,524452,524453,524454,524455,524456,524457,524458,524459,524460,524461,524462,524463,524466,524479,524491,524512,524513,524514,524515,524516,524517,524518,524519,524520,524521,524522,524523,524524,524525,524526,524527,524529,524530,524531,524532,524533,524534,524535,524536,524537,524538,524539,524540,524541,524542,524543],name:"Games"},9:{applications:[589828,589829,589885,589888,589890,589916,589933,589934,589942,589951],name:"Network Management"}},version:{major:1,minor:52}}}),define("unifi/model/GatewayDpi",["unifi/model/Model","jquery","underscore","unifi/util/DpiRuleMap","unifi/util/DpiIconMap","msg/Msg"],function(e,t,a,n,i,o){"use strict";return e.extend({otherBytesMaximumPercent:.05,parseData:function(){this.set({by_cat:this.sortData(this.get("by_cat")),by_app:this.sortData(this.get("by_app")),by_cat_total:this.totalCategoryData(this.get("by_cat")),by_app_total:this.totalApplicationData(this.get("by_app"))},{silent:!0}),this.set({by_cat_other:this.totalCategoryData(this.get("by_cat"),this.otherBytesMaximumPercent),by_app_other:this.totalApplicationData(this.get("by_app"),this.otherBytesMaximumPercent)},{silent:!0})},getName:function(e,t){var a=t.cat&&t.app?65536*t.cat+t.app:t.cat,i="by_cat"==e?"categories":"applications",r=n[i][a],s=r?r.name:"("+o.G_Unknown.toLowerCase()+")",c=t.name||s;return c},getIconUrl:function(e,t){var a=t.cat&&t.app?65536*t.cat+t.app:t.cat,n="by_cat"==e?"categories":"applications",o=i[n][a];return o?o.iconUrl:null},sortData:function(e){return a.sortBy(e,function(e){return-((e.tx_bytes||0)+(e.rx_bytes||0))})},totalCategoryData:function(e,t){return a.reduce(e,function(e,a){var n,i;return void 0!==t&&(n=this.get("by_cat_total"),i=(n.rx_bytes+n.tx_bytes)*t,e.name=o.G_Other),(void 0===i||a.tx_bytes+a.rx_bytes<i)&&(e.tx_bytes+=a.tx_bytes||0,e.rx_bytes+=a.rx_bytes||0,e.tx_packets+=a.tx_packets||0,e.rx_packets+=a.rx_packets||0,void 0!==t&&(e.isGrouped=!0)),e},{tx_bytes:0,rx_bytes:0,tx_packets:0,rx_packets:0},this)},totalApplicationData:function(e,t){return a.reduce(e,function(e,a){var n,i,r=a.cat;return void 0!==t&&(n=this.get("by_app_total")[r],i=(n.rx_bytes+n.tx_bytes)*t),(void 0===i||a.tx_bytes+a.rx_bytes<i)&&(e[r]?(e[r].apps.push(a.app),e[r].tx_bytes+=a.tx_bytes||0,e[r].rx_bytes+=a.rx_bytes||0,e[r].tx_packets+=a.tx_packets||0,e[r].rx_packets+=a.rx_packets||0):(e[r]={},e[r].cat=Number.MAX_VALUE,e[r].apps=[a.app],e[r].tx_bytes=a.tx_bytes||0,e[r].rx_bytes=a.rx_bytes||0,e[r].tx_packets=a.tx_packets||0,e[r].rx_packets=a.rx_packets||0,e[r].name=o.G_Other),void 0!==t&&(e[r].isGrouped=!0)),e},{},this)}})}),define("unifi/model/ClientDpi",["unifi/model/Model","unifi/util/DpiRuleMap","unifi/util/DpiIconMap","msg/Msg"],function(e,t,a,n){"use strict";return e.extend({idAttribute:"app",name:function(){var e=t.applications[65536*this.get("cat")+this.get("app")];return e?e.name:"("+n.G_Unknown.toLowerCase()+")"},iconUrl:function(){var e=a.applications[65536*this.get("cat")+this.get("app")];return e?e.iconUrl:null},bytesTotal:function(){var e=this.get("rx_bytes")||0,t=this.get("tx_bytes")||0;return e+t},packetsTotal:function(){var e=this.get("rx_packets")||0,t=this.get("tx_packets")||0;return e+t}})}),define("unifi/util/DpiDevidMap",[],function(){"use strict";return{devids:{dev_type_ids:{1:{name:"Desktop/Laptop"},10:{name:"VoIP Gateway"},11:{name:"Printer"},12:{name:"Wireless Access Point"},13:{name:"Switch"},14:{name:"Wireless Controller"},15:{name:"Media Link Controller"},16:{name:"Network Diagnostics"},17:{name:"Game Console"},18:{name:"NAS"},19:{name:"PDA"},2:{name:"Router"},20:{name:"Multimedia Device"},21:{name:"eBook Reader"},22:{name:"Scanner"},23:{name:"Video Conferencing"},24:{name:"DVR"},25:{name:"Thin Client"},255:{name:"Unknown"},26:{name:"Phone"},27:{name:"Video Phone"},28:{name:"Workstation"},29:{name:"Apple iOS Device"},3:{name:"VoIP Phone"},30:{name:"Tablet"},31:{name:"SmartTV"},32:{name:"Android Device"},33:{name:"Automation Switch"},34:{name:"Projector"},35:{name:"Wireless Lighting"},4:{name:"Miscellaneous"},5:{name:"IPTV"},6:{name:"Smartphone"},7:{name:"UPS"},8:{name:"Wireless Router"},9:{name:"IP Network Camera"}},device_ids:{1:{name:"2Wire Residential Gateway"},10:{name:"Android 1.0"},100:{name:"Gentoo 2006.1"},101:{name:"Gentoo 2007.0"},102:{name:"Gentoo 2008.0 R1"},103:{name:"Haiku"},104:{name:"Hakin9 Live 2.8"},105:{name:"Hewlett-Packard iLO Agent"},106:{name:"Hewlett-Packard iLO Agent (Not Configured)"},107:{name:"Hewlett-Packard JetDirect (J311xA/J32xxx)"},108:{name:"Hewlett-Packard JetDirect (J4169A/J6035D/J6038A/J6..."},109:{name:"Hewlett-Packard JetDirect (J6035A)"},11:{name:"Android 1.5-2.1"},110:{name:"Hewlett-Packard JetDirect (J7973E)"},111:{name:"Hewlett-Packard LaserJet P2015 Printer Series"},112:{name:"Hewlett-Packard Printer"},113:{name:"Hewlett-Packard Printer MFP"},114:{name:"Hewlett-Packard Procurve"},115:{name:"Hewlett-Packard ProCurve AP"},116:{name:"Hotway LanDrive"},117:{name:"Internet Connection Sharing - Microsoft"},118:{name:"iPhone/iPad/iPod"},119:{name:"Amazon Kindle"},12:{name:"Android 2.2-2.3"},120:{name:"Knoppix"},121:{name:"Kyocera FS-1028MFP"},122:{name:"Kyocera KM-XXXX"},123:{name:"Kyocera Printer"},124:{name:"Lexmark MFP Printer"},125:{name:"Lexmark Printer"},126:{name:"LifeSize Room"},127:{name:"Linksys BEFW11S4"},128:{name:"Linksys PAP2/SPA 941"},129:{name:"Linksys Router"},13:{name:"Android 3.0-4.1"},130:{name:"Linux 2.0.x"},131:{name:"Linux 2.2.x"},132:{name:"Linux 2.4.x"},133:{name:"Linux 2.6.x"},134:{name:"Linux Mint Debian"},135:{name:"Mac OS 9.1"},136:{name:"Mac OS 9.2"},137:{name:"Mac OS 9.x"},138:{name:"Mac OS X"},139:{name:"Mandriva 2011"},14:{name:"Android 4.2-4.4"},140:{name:"Mediatrix VoIP Adapter"},141:{name:"Meraki Indoor"},142:{name:"Mitel IP Phone"},143:{name:"Moneris HiSpeed 3100IP"},144:{name:"Motorola NIM100"},145:{name:"Motorola Router"},146:{name:"Neoware Capio Thin Client (Windows CE)"},147:{name:"Neoware e100 Thin Client (NeoLinux)"},148:{name:"NetBotz WallBotz 400C"},149:{name:"NetBotz WallBotz 420E"},15:{name:"Android 4.4"},150:{name:"NetBotz WallBotz 500"},151:{name:"NETGEAR FVS114"},152:{name:"NETGEAR Router"},153:{name:"NETGEAR WGR614v6"},154:{name:"NETGEAR WGT624v4"},155:{name:"NETGEAR WNDR3000"},156:{name:"NETGEAR WNR3500L"},157:{name:"NETGEAR WNR854T"},158:{name:"Nokia 6086 UMA"},159:{name:"Nokia E-Series"},16:{name:"Anonym.OS"},160:{name:"Nokia Internet Tablet"},161:{name:"Nortel IP Phone"},162:{name:"Novell NetWare Client"},163:{name:"OpenBSD"},164:{name:"OpenSolaris 2008.11 - 2010.02"},165:{name:"openSUSE 12.1"},166:{name:"OS/2 Warp"},167:{name:"PC-BSD 1.4"},168:{name:"PC-BSD 1.5"},169:{name:"pdaNet"},17:{name:"APC UPS"},170:{name:"PlayStation 2"},171:{name:"PlayStation 3"},172:{name:"Polycom Video Phone (VSX 3000A)"},173:{name:"Polycom ViewStation"},174:{name:"Porteus 1.0"},175:{name:"Puppy Linux 4.x"},176:{name:"PXE Client"},177:{name:"PXE Client (ZEN)"},178:{name:"Red Hat Linux"},179:{name:"ReplayTV"},18:{name:"Apple Airport"},180:{name:"ShoreTel IP Phone"},181:{name:"Siemens OpenStage 20/40/60/80"},182:{name:"Siemens optiPoint 150 S"},183:{name:"Siemens optiPoint 410/420"},184:{name:"Siemens optiPoint WL2 professional"},185:{name:"Sipura VoIP Adaptor"},186:{name:"Slax 5.x-6.x based distros"},187:{name:"SLED 10"},188:{name:"SLED 10.1"},189:{name:"Slingbox"},19:{name:"Apple Airport Extreme"},190:{name:"SPA 942"},191:{name:"Sun Blade 100 Workstation"},192:{name:"SunOS 5.6"},193:{name:"SunRocket Gizmo"},194:{name:"SUSE Linux Enterprise"},195:{name:"SUSE Linux Enterprise 9.3"},196:{name:"Sweex LW050 WAP"},197:{name:"Symbol Wireless Access Point"},198:{name:"Symbol Wireless Switch"},199:{name:"TallyGenicom Printer"},2:{name:"3Com IP Phone"},20:{name:"Apple Netboot"},200:{name:"TANDBERG"},201:{name:"TANDBERG 1000"},202:{name:"TiVo"},203:{name:"TP-LINK Wireless LAN Router"},204:{name:"Trapeze 2330 Wireless Access Point"},205:{name:"Trapeze MP-422 Wireless Access Point"},206:{name:"Trendnet IP Camera"},207:{name:"Trendnet Print Server"},208:{name:"Trendnet Wireless Access Point"},209:{name:"Ubuntu"},21:{name:"Avaya IP Phone"},210:{name:"Ubuntu 11 based distro"},211:{name:"Ubuntu 6.0.6"},212:{name:"Ubuntu 6.10"},213:{name:"Ubuntu 7.x based distro"},214:{name:"Ubuntu 8.04"},215:{name:"Ubuntu 8.10 based distro"},216:{name:"Ubuntu 9-10 based distro"},217:{name:"UniData IP Phone"},218:{name:"Uniden DTA VoIP Adapater"},219:{name:"UTStarcom F3000"},22:{name:"Axis Network Camera"},220:{name:"WD My Book World Edition"},221:{name:"WD ShareSpace"},222:{name:"Wii"},223:{name:"Windows 2000"},224:{name:"Windows 7"},225:{name:"Windows 8"},226:{name:"Windows 95"},227:{name:"Windows 95 B"},228:{name:"Windows 98"},229:{name:"Windows 98 SE"},23:{name:"Backtrack 1.0"},230:{name:"Windows CE"},231:{name:"Windows ME"},232:{name:"Windows NT 4"},233:{name:"Windows Phone 7.5"},234:{name:"Windows Phone 8.0"},235:{name:"Windows Server 2003"},236:{name:"Windows Server 2008"},237:{name:"Windows Vista"},238:{name:"Windows XP"},239:{name:"Windows"},24:{name:"BATM VoIP Adapter"},240:{name:"Xbox"},241:{name:"Xbox 360"},242:{name:"Xerox Printer"},243:{name:"Xerox WorkCentre"},244:{name:"Zenwalk based distro"},245:{name:"ZyXEL WiFi Phone"},246:{name:"Apple iPod"},247:{name:"Apple iPhone"},248:{name:"Apple iPad"},249:{name:"Apple TV"},25:{name:"Belkin F5D8235-4 v2"},250:{name:"BarnesNoble NOOK"},251:{name:"SonyEricsson Symbian Phone"},252:{name:"SonyEricsson Android Phone"},253:{name:"Sony Android Device"},254:{name:"Sony PSP"},255:{name:"Unknown"},256:{name:"Nintendo Wii"},257:{name:"Nokia Symbian"},258:{name:"Nokia Lumia"},259:{name:"Nokia Windows Phone"},26:{name:"Belkin Skype Phone"},260:{name:"Google Nexus Series"},261:{name:"HTC Android Phone"},262:{name:"HTC Windows Phone"},263:{name:"ASUS Transformer"},264:{name:"ASUS PadFone"},265:{name:"Motorola XOOM"},266:{name:"Motorola Droid"},267:{name:"Motorola Android Phone"},268:{name:"Huawei Android Phone"},269:{name:"Samsung Smartphone"},27:{name:"BeOS 4.x"},270:{name:"Samsung Symbian"},271:{name:"Samsung Android Tab"},272:{name:"Samsung Android Phone"},273:{name:"Samsung Windows Phone"},274:{name:"LG Android Tab"},275:{name:"LG Android Phone"},276:{name:"Android Device"},277:{name:"Windows Mobile Device"},278:{name:"Windows Phone Device"},279:{name:"Macintosh"},28:{name:"BeOS 5.0"},280:{name:"FreeBSD"},281:{name:"SunOS"},282:{name:"Solaris"},283:{name:"Linux"},284:{name:"Sony PlayStation 2"},285:{name:"Sony PlayStation 3"},286:{name:"Firefox Device"},287:{name:"D-Link Boxee"},288:{name:"Belkin wemo"},289:{name:"Canon Photo Printer"},29:{name:"BlackBerry"},290:{name:"NEC M300X"},291:{name:"Roku"},292:{name:"Roku Device"},293:{name:"FirefoxOS Mobile"},294:{name:"NETGEAR NTV300"},295:{name:"TrendMicro JewelryBox"},296:{name:"Chromecast"},297:{name:"Samsung SmartTV"},298:{name:"Xbox One"},299:{name:"Amazon Kindle Fire"},3:{name:"Adobe Flash Player"},30:{name:"Bluesocket BSC"},300:{name:"Sony Android Tab"},301:{name:"Asus Pad"},302:{name:"Alcatel Device"},303:{name:"Apple iPhone 5s"},304:{name:"Apple iPhone 5"},305:{name:"Apple iPhone 5c"},306:{name:"Sharp SmartTV"},307:{name:"Xiaomi Router"},308:{name:"Apple iPhone 6 Plus"},309:{name:"Apple iPhone 6"},31:{name:"Brother Printer"},310:{name:"Apple iPhone 4s"},311:{name:"Apple iPhone 4"},312:{name:"Apple iPad Mini"},313:{name:"Apple iPad Air"},314:{name:"Apple iPad 4"},315:{name:"Apple iPad 3"},316:{name:"Apple iPad 2"},317:{name:"Samsung Galaxy S5"},318:{name:"Samsung Galaxy S4"},319:{name:"Samsung Galaxy S3"},32:{name:"Brother Printer 2"},320:{name:"Samsung Galaxy Note 4"},321:{name:"Samsung Galaxy Note 3"},322:{name:"Samsung Galaxy Note 3 Neo"},323:{name:"Samsung Galaxy Note 2"},324:{name:"Samsung Galaxy Note"},325:{name:"Samsung Galaxy NotePRO"},326:{name:"Samsung Galaxy Tab"},327:{name:"Samsung Galaxy Tab S"},328:{name:"Samsung Galaxy TabPRO"},329:{name:"Sony Xperia Z3"},33:{name:"Buffalo Wireless Access Point"},330:{name:"Sony Xperia Z3 Compact"},331:{name:"Sony Xperia Z3 Tablet"},332:{name:"Sony Xperia Z2a"},333:{name:"Sony Xperia Z2"},334:{name:"Sony Xperia Z2 Tablet"},335:{name:"Sony Xperia Z1"},336:{name:"Sony Xperia Z1 Compact"},337:{name:"Sony Xperia Tablet Z"},338:{name:"Sony Xperia Z Ultra"},339:{name:"Sony Xperia Z"},34:{name:"Canon Printer"},340:{name:"Sony Xperia L"},341:{name:"Sony Xperia ZR"},342:{name:"Sony Xperia SP"},343:{name:"Sony Xperia ZL"},344:{name:"Sony Xperia C"},345:{name:"Sony Xperia C3"},346:{name:"Sony Xperia T3"},347:{name:"Sony Xperia E1"},348:{name:"Sony Xperia E3"},349:{name:"Sony Xperia M"},35:{name:"Cisco 7905 IP Phone"},350:{name:"Sony Xperia M2"},351:{name:"Sony Xperia M2 Agua"},352:{name:"HTC Butterfly 2"},353:{name:"HTC Butterfly Series"},354:{name:"HTC Desire 610"},355:{name:"HTC Desire 816"},356:{name:"HTC Desire Series"},357:{name:"HTC One E8"},358:{name:"HTC One M8"},359:{name:"HTC One Max"},36:{name:"Cisco 7910 IP Phone"},360:{name:"HTC One Mini 2"},361:{name:"HTC One Mini"},362:{name:"HTC One X+"},363:{name:"HTC One Series"},364:{name:"HTC EVO Series"},365:{name:"HTC J"},366:{name:"HTC Flyer"},367:{name:"HTC Sensation Series"},368:{name:"HTC Wildfire Series"},369:{name:"Sony PlayStation 4"},37:{name:"Cisco 7911x IP Phone"},370:{name:"Synology NAS"},371:{name:"Apple iPad Mini 3"},372:{name:"Apple iPad Air 2"},373:{name:"Amazon Fire TV"},374:{name:"Nintendo 3DS"},375:{name:"Google Nexus 4"},376:{name:"Google Nexus 5"},377:{name:"Google Nexus 7"},378:{name:"Google Nexus 9"},379:{name:"Google Nexus 10"},38:{name:"Cisco 7912 IP Phone"},380:{name:"Huawei MediaPad"},381:{name:"Xiaomi Redmi"},382:{name:"Xiaomi Mi 3"},383:{name:"Xiaomi Mi 2 Series"},384:{name:"Lenovo YOGA Tablet"},385:{name:"Philips hue"},386:{name:"Vonage VoIP Phone"},387:{name:"Sony BRAVIA SmartTV"},388:{name:"Sony Xperia Z1 f"},389:{name:"Sony Xperia AX"},39:{name:"Cisco 7935 IP Phone"},390:{name:"Sony Xperia GX"},391:{name:"Sony Xperia SX"},392:{name:"Sony Reader PRS-T3"},393:{name:"HTC INFOBAR"},394:{name:"HTC J One"},395:{name:"Samsung Galaxy Tab Plus"},396:{name:"LG SmartTV"},397:{name:"Fujitsu ANTEPRIMA F-09D"},398:{name:"Sharp AQUOS PAD"},399:{name:"Sharp AQUOS PHONE Xx"},4:{name:"Alcatel 4037 Advanced Reflex IP Phone"},40:{name:"Cisco 7940/7960x IP Phone"},400:{name:"Sharp AQUOS PHONE Xx mini"},401:{name:"Sharp AQUOS PHONE SL"},402:{name:"Sharp AQUOS PHONE CL"},403:{name:"Sharp AQUOS PHONE EX"},404:{name:"Sharp AQUOS PHONE SERIE"},405:{name:"Sharp AQUOS PHONE SERIE mini"},406:{name:"Sharp AQUOS PHONE si"},407:{name:"Sharp AQUOS PHONE ss"},408:{name:"Sharp AQUOS PHONE st"},409:{name:"Sharp AQUOS PHONE sv"},41:{name:"Cisco 7961G IP Phone"},410:{name:"Sharp AQUOS PHONE ZETA"
},411:{name:"Sharp AQUOS ZETA"},412:{name:"Sharp AQUOS SmartTV"},413:{name:"Sharp AQUOS PHONE Vivienne Westwood"},414:{name:"Fujitsu ARROWS A"},415:{name:"Fujitsu ARROWS ef"},416:{name:"Fujitsu ARROWS Kiss"},417:{name:"Fujitsu ARROWS V"},418:{name:"Fujitsu ARROWS X"},419:{name:"Fujitsu ARROWS NX"},42:{name:"Cisco 7965G IP Phone"},420:{name:"Fujitsu ARROWS Z"},421:{name:"Fujitsu ARROWS REGZA Phone"},422:{name:"Fujitsu ARROWS Tab"},423:{name:"Hitachi SmartTV"},424:{name:"Mitsubishi SmartTV"},425:{name:"Panasonic Viera SmartTV"},426:{name:"Toshiba REGZA SmartTV"},427:{name:"NEC MEDIAS W"},428:{name:"Kyocera URBANO L01"},429:{name:"Kyocera URBANO L02"},43:{name:"Cisco Aironet 1100"},430:{name:"Kyocera URBANO L03"},431:{name:"Kyocera TORQUE G01"},432:{name:"Chromebook"},433:{name:"Hitachi Wooo TV"},434:{name:"Mitsubishi LCD SmartTV"},435:{name:"Panasoic DMR"},436:{name:"Panasoic SmartTV"},437:{name:"Pioneer BDP"},438:{name:"Sony BDZ"},439:{name:"Sony BDP"},44:{name:"Cisco Aironet 1130"},440:{name:"Sony PlayStation Portable"},441:{name:"Sony PlayStation Vita"},442:{name:"Toshiba DBR"},443:{name:"Toshiba SmartTV"},444:{name:"Nintendo Wii U"},445:{name:"Ooma VoIP Adapter"},446:{name:"Fujitsu ARROWS"},447:{name:"Fujitsu Disney"},448:{name:"Fujitsu Raku-Raku"},449:{name:"Sharp AQUOS PHONE"},45:{name:"Cisco Aironet 1140"},450:{name:"Sharp AQUOS PHONE THE PREMIUM"},451:{name:"Sharp AQUOS PHONE THE HYBRID"},452:{name:"Sharp PANTON 4"},453:{name:"Sharp PANTON 5"},454:{name:"Sharp PANTON 6"},455:{name:"Sharp PANTON WATERPROOF"},456:{name:"Sharp Galapagos"},457:{name:"NEC MEDIAS CH"},458:{name:"NEC MEDIAS BR"},459:{name:"NEC MEDIAS PP"},46:{name:"Cisco Aironet 1200"},460:{name:"NEC MEDIAS U"},461:{name:"NEC Disney"},462:{name:"NEC MEDIAS"},463:{name:"NEC MEDIAS X"},464:{name:"NEC MEDIAS ES"},465:{name:"NEC MEDIAS WP"},466:{name:"NEC MEDIAS Tab"},467:{name:"NEC MEDIAS Tab UL"},468:{name:"Kyocera DIGNO S"},469:{name:"Kyocera DIGNO M"},47:{name:"Cisco Aironet 1240"},470:{name:"Alcatel One Touch Evolve"},471:{name:"ASUS PadFone 2"},472:{name:"Asus Fonepad"},473:{name:"Asus Fonepad 7"},474:{name:"CASIO GzOne TYPE-L"},475:{name:"Fujitsu ARROWS Me"},476:{name:"HTC J Butterfly"},477:{name:"Huawei Stream"},478:{name:"Huawei Stream S"},479:{name:"Huawei Stream X"},48:{name:"Cisco Aironet 1300"},480:{name:"Huawei MediaPad 7 Lite"},481:{name:"Kobo Arc 7 HD"},482:{name:"Kyocera Honey Bee"},483:{name:"Kyocera DIGNO R"},484:{name:"Kyocera Disney"},485:{name:"Kyocera URBANO PROGRESSO"},486:{name:"Kyocera Digno Dual 2"},487:{name:"Lenovo IdeaTab"},488:{name:"LG Optimus L1 II Dual"},489:{name:"LG Optimus L5II"},49:{name:"Cisco Aironet 1310"},490:{name:"LG Optimus L5II Duet"},491:{name:"LG Optimus Vu JOJO"},492:{name:"LG Optimus G"},493:{name:"LG Optimus G Flex"},494:{name:"LG Optimus L7"},495:{name:"LG Optimus F5"},496:{name:"Motorola Droid RAZR M"},497:{name:"Motorola Droid RAZR HD"},498:{name:"Motorola Droid XYBOARD"},499:{name:"Motorola DEFY Mini"},5:{name:"Alcatel IP Touch 8 Series Phones"},50:{name:"Cisco Aironet 1500"},500:{name:"Motorola DEFY XT"},501:{name:"Motorola Admiral"},502:{name:"Motorola Master"},503:{name:"Motorola MOTO"},504:{name:"Motorola Electrify 2"},505:{name:"Motorola Droid RAZR V"},506:{name:"Motorola RAZR i"},507:{name:"Motorola Photon Q"},508:{name:"Motorola Electrify M"},509:{name:"Motorola RAZR M"},51:{name:"Cisco Aironet 4800"},510:{name:"Motorola Droid RAZR M"},511:{name:"Motorola RAZR XT910"},512:{name:"Motorola RAZR D1"},513:{name:"Motorola RAZR D3"},514:{name:"NEC LifeTouch L"},515:{name:"NEC LaVie Tab S"},516:{name:"Panasonic Eluga"},517:{name:"Panasonic Disney"},518:{name:"Panasonic Eluga V"},519:{name:"Panasonic Eluga Power"},52:{name:"Cisco ATA 186"},520:{name:"Panasonic Eluga Live"},521:{name:"Samsung Galaxy Core"},522:{name:"Samsung Galaxy Win"},523:{name:"Samsung Galaxy Mega"},524:{name:"Samsung Galaxy Pocket Neo"},525:{name:"Samsung Galaxy Fame"},526:{name:"Samsung Galaxy Ace 3"},527:{name:"Samsung Galaxy S II"},528:{name:"Samsung Galaxy Young"},529:{name:"Samsung Galaxy Fame Lite"},53:{name:"Cisco Catalyst 29xx"},530:{name:"Samsung Galaxy Fame Lite Duos"},531:{name:"Samsung Galaxy Trend Lite"},532:{name:"Samsung Galaxy S Duos"},533:{name:"Samsung Galaxy S Duos 2"},534:{name:"Samsung Galaxy S"},535:{name:"Samsung Galaxy J"},536:{name:"Samsung Galaxy S III alpha"},537:{name:"Sharp Disney"},538:{name:"Sharp AQUOS PHONE CRYSTAL"},539:{name:"Sharp AQUOS PHONE Slider"},54:{name:"Cisco Catalyst 35xx"},540:{name:"Sharp Q-pot PHONE"},541:{name:"Sharp Junior"},542:{name:"Sharp AQUOS PHONE NERV"},543:{name:"Sharp Lynx"},544:{name:"Sharp Shot PHONE"},545:{name:"Sony Xperia T2 Ultra"},546:{name:"Sony Xperia Arc"},547:{name:"Sony Xperia Tablet S"},548:{name:"Sony Xperia A"},549:{name:"Sony Xperia VL"},55:{name:"Cisco IP Phone"},550:{name:"Sony Xperia UL"},551:{name:"Sony Xperia ZL2"},552:{name:"Sony Xperia tipo"},553:{name:"Toshiba Tablet"},554:{name:"Toshiba REGZA Tablet"},555:{name:"Alcatel One Touch Idol"},556:{name:"Alcatel One Touch Idol X"},557:{name:"Mitsubishi DVR"},558:{name:"Nintendo DSi"},559:{name:"Coolpad 5216D"},56:{name:"Cisco Wireless Access Point"},560:{name:"Coolpad 5879T"},561:{name:"Coolpad 5890"},562:{name:"Coolpad 5951"},563:{name:"Coolpad 5950T"},564:{name:"Coolpad 7270"},565:{name:"Coolpad 7295T"},566:{name:"Coolpad 7620L"},567:{name:"Coolpad 8012"},568:{name:"Coolpad 8297"},569:{name:"Coolpad 8720L"},57:{name:"Clipcomm IP Phone"},570:{name:"Coolpad 9080W"},571:{name:"Coolpad D530TW"},572:{name:"Coolpad device"},573:{name:"Fujitsu Girls"},574:{name:"Android 5.0"},575:{name:"D-Link IPCam"},576:{name:"FreeBSD 10.1"},58:{name:"Compex Wireless Access Point"},59:{name:"DD-WRT Router"},6:{name:"Amino AmiNET110"},60:{name:"Debian 3.1"},61:{name:"Debian 4 based distro"},62:{name:"Debian 6"},63:{name:"Debian-based Linux"},64:{name:"Dell Printer"},65:{name:"D-Link Wireless Router"},66:{name:"DNSChanger Trojan"},67:{name:"DSL 4.4.x"},68:{name:"Enterasys HiPath Wireless Access Point 2610/2620/2..."},69:{name:"Enterasys HiPath Wireless Access Point 2630/2640"},7:{name:"Amino AmiNET110 (Not configured)"},70:{name:"Enterasys HiPath Wireless Access Point 3610/3620"},71:{name:"Enterasys HiPath Wireless C20N Controller"},72:{name:"Enterasys Matrix N-Series DFE-G/P/D"},73:{name:"Enterasys RBT-1002-EU Wireless Access Point"},74:{name:"Enterasys RBT-1602 Wireless Access Point"},75:{name:"Enterasys RBT-1602C Wireless Access Point"},76:{name:"Enterasys RBT-4102C-EU Wireless Access Point"},77:{name:"Enterasys RBT-4102-EU Wireless Access Point"},78:{name:"Enterasys RBT-8200 Wireless Controller"},79:{name:"Enterasys SecureStack A2"},8:{name:"Anaconda"},80:{name:"Enterasys SecureStack B2/B3/C2/C3"},81:{name:"Epson Printer"},82:{name:"Etherboot/gPXE"},83:{name:"Extron MLC 226 IP"},84:{name:"Eye-Fi Wireless Memory Card"},85:{name:"Fedora 13 based distro"},86:{name:"Fedora 14 based distro"},87:{name:"Fedora 15-16 based distro"},88:{name:"Fedora 3-8 based distro"},89:{name:"Fedora 9-12 based distro"},9:{name:"Android 0.9"},90:{name:"Fluke OneTouch Series II/III"},91:{name:"FreeBSD 6.0-6.2"},92:{name:"FreeBSD 6.3-7.2"},93:{name:"FreeNAS 0.7"},94:{name:"GameCube"},95:{name:"Gemtek Wireless Router"},96:{name:"Generic Printer"},97:{name:"Gentoo 2004.3"},98:{name:"Gentoo 2005.0"},99:{name:"Gentoo 2006.0"}},family_ids:{1:{name:"Smart TV &amp;  Set-top box"},2:{name:"Game Console"},255:{name:"Unknown"},3:{name:"Handheld"},4:{name:"Computer"},5:{name:"Intelligent Home Appliances"},6:{name:"Wearable devices"},7:{name:"Network &amp; Peripheral"}},os_class_ids:{1:{name:"Others"},10:{name:"Cisco Native Unix"},11:{name:"Cisco IOS"},12:{name:"Threat"},13:{name:"FreeBSD"},14:{name:"Haiku"},15:{name:"Windows"},16:{name:"Apple iOS"},17:{name:"Solaris"},18:{name:"OS/2 Warp"},19:{name:"XMB"},2:{name:"VxWorks"},20:{name:"Network Bootloader"},21:{name:"Unix"},22:{name:"Wii system"},23:{name:"Xbox"},24:{name:"Symbian"},25:{name:"Bada"},255:{name:"Unknown"},26:{name:"Firefox OS"},27:{name:"FirefoxOS"},28:{name:"ChromeOS"},3:{name:"Linux"},4:{name:"Network Boot Loader"},5:{name:"Android"},6:{name:"OpenBSD"},7:{name:"Mac OS"},8:{name:"BeOS"},9:{name:"BlackBerry"}},os_name_ids:{1:{name:"Others"},10:{name:"Android 4.4"},11:{name:"OpenBSD"},12:{name:"Mac OS X"},13:{name:"Linux 2.6"},14:{name:"BeOS 4"},15:{name:"BeOS 5"},16:{name:"BlackBerry"},17:{name:"Cisco Native Unix"},18:{name:"Cisco IOS"},19:{name:"Windows"},2:{name:"VxWorks"},20:{name:"Linux 2.4"},21:{name:"FreeBSD 6.0"},22:{name:"FreeBSD 6.3"},23:{name:"FreeNAS"},24:{name:"Haiku"},25:{name:"Apple iOS"},255:{name:"Unknown"},26:{name:"Linux 2.0"},27:{name:"Linux 2.2"},28:{name:"Mac OS 9.1"},29:{name:"Mac OS 9.2"},3:{name:"Linux"},30:{name:"Mac OS 9.x"},31:{name:"FreeBSD"},32:{name:"Maemo"},33:{name:"OpenSolaris"},34:{name:"OS/2 Warp"},35:{name:"FreeBSD 6.2"},36:{name:"XMB"},37:{name:"VxWorks 5.4"},38:{name:"SunOS"},39:{name:"VxWorks 5.5"},4:{name:"Android 0.9"},40:{name:"Wii system"},41:{name:"Windows 2000"},42:{name:"Windows 7"},43:{name:"Windows 8"},44:{name:"Windows 95"},45:{name:"Windows 95 B"},46:{name:"Windows 98"},47:{name:"Windows 98 SE"},48:{name:"Windows CE"},49:{name:"Windows ME"},5:{name:"Android 1.0"},50:{name:"Windows NT 4"},51:{name:"Windows Phone"},52:{name:"Windows Server 2003"},53:{name:"Windows Server 2008"},54:{name:"Windows Vista"},55:{name:"Windows XP"},56:{name:"Xbox"},57:{name:"Android"},58:{name:"Symbian"},59:{name:"Bada"},6:{name:"Android 1.5-2.1"},60:{name:"Windows Mobile"},61:{name:"Ubuntu"},62:{name:"Firefox OS"},63:{name:"FirefoxOS 1.3"},64:{name:"ChromeOS"},65:{name:"Android 5.0"},66:{name:"FreeBSD 10.1"},7:{name:"Android 2.2-2.3"},8:{name:"Android 3.0-4.1"},9:{name:"Android 4.2-4.3"}},vendor_ids:{1:{name:"Others"},10:{name:"American Power Conversion Corp."},100:{name:"BlackBerry Limited"},101:{name:"Nokia Oyj"},102:{name:"HTC Corporation"},103:{name:"ASUSTeK Computer Inc."},104:{name:"Huawei Technologies Co. Ltd."},105:{name:"Samsung Group"},106:{name:"LG Corporation"},107:{name:"Xerox Corp."},108:{name:"Zenwalk.org"},109:{name:"ZyXEL Corp."},11:{name:"Apple, Inc."},110:{name:"Mozilla Corporation"},111:{name:"D-Link Corporation"},112:{name:"NEC Corporation"},113:{name:"Roku, Inc."},114:{name:"Mozilla"},115:{name:"Trend Micro Inc."},116:{name:"Sharp Corporation"},117:{name:"Xiaomi Inc."},118:{name:"Synology Inc."},119:{name:"Lenovo Group Ltd."},12:{name:"Apple"},120:{name:"Philips"},121:{name:"Vonage Holdings Corp."},122:{name:"Fujitsu Ltd."},123:{name:"Hitachi, Ltd."},124:{name:"Mitsubishi Electric Corporation"},125:{name:"Panasonic Corporation"},126:{name:"Toshiba Corporation"},127:{name:"Pioneer Corporation"},128:{name:"Ooma, Inc."},13:{name:"Avaya, Inc."},14:{name:"Axis Communications"},15:{name:"remote-exploit.org"},16:{name:"BATM"},17:{name:"Belkin"},18:{name:"Be, Inc."},19:{name:"BlackBerry"},2:{name:"2Wire, Inc."},20:{name:"Bluesocket"},21:{name:"Brother Industries, Ltd."},22:{name:"Buffalo Technology, Inc."},23:{name:"Canon, Inc."},24:{name:"Cisco Systems, Inc."},25:{name:"Clipcomm, Inc."},255:{name:"Unknown"},26:{name:"Compex Systems Pte, Ltd."},27:{name:"DD-WRT"},28:{name:"Debian"},29:{name:"Dell, Inc."},3:{name:"3Com"},30:{name:"D-Link Systems, Inc."},31:{name:"Damn Small Linux"},32:{name:"Enterasys Networks, Inc."},33:{name:"Seiko Epson Corp."},34:{name:"Etherboot"},35:{name:"Extron"},36:{name:"EyeFi, Inc."},37:{name:"Fluke Electronics"},38:{name:"FreeBSD"},39:{name:"FreeNAS"},4:{name:"Adobe"},40:{name:"Nintendo Co., Ltd."},41:{name:"Gemtek Technology Co., Ltd."},42:{name:"Gentoo"},43:{name:"Haiku, Inc."},44:{name:"Hakin9"},45:{name:"Hewlett-Packard"},46:{name:"Hotway"},47:{name:"Microsoft Corp."},48:{name:"Microsoft"},49:{name:"Amazon"},5:{name:"Alcatel-Lucent"},50:{name:"Knoppix"},51:{name:"Kyocera Mita Corp."},52:{name:"Lexmark International, Inc."},53:{name:"LifeSize Communications, Inc."},54:{name:"Linksys"},55:{name:"Linux Mint"},56:{name:"Mediatrix Telecom"},57:{name:"Meraki"},58:{name:"Mitel Corp."},59:{name:"Moneris Solutions"},6:{name:"Amino Technologies"},60:{name:"Motorola, Inc."},61:{name:"Netbotz"},62:{name:"NETGEAR"},63:{name:"Nokia"},64:{name:"Maemo"},65:{name:"Nortel Networks"},66:{name:"Novell, Inc."},67:{name:"Sun Microsystems, Inc."},68:{name:"IBM Corp."},69:{name:"PC-BSD"},7:{name:"Fedora"},70:{name:"Linux"},71:{name:"Sony"},72:{name:"Polycom, Inc."},73:{name:"Porteus"},74:{name:"Puppy Linux"},75:{name:"Red Hat"},76:{name:"DIRECTV, Inc."},77:{name:"ShoreTel, Inc."},78:{name:"Infineon Technologies AG"},79:{name:"Wind River"},8:{name:"Google Inc."},80:{name:"Sipura Technology"},81:{name:"Slax"},82:{name:"SUSE"},83:{name:"Sling Media"},84:{name:"InnoMedia, Inc."},85:{name:"Symbol"},86:{name:"TallyGenicom LP"},87:{name:"TANDBERG"},88:{name:"TiVo"},89:{name:"TP-LINK Technologies Co., Ltd."},9:{name:"OpenBSD"},90:{name:"Trapeze Networks"},91:{name:"TRENDnet"},92:{name:"Ubuntu"},93:{name:"UniData Communications Systems Inc."},94:{name:"Uniden"},95:{name:"UTStarcom, Inc."},96:{name:"Western Digital Corp."},97:{name:"Amazon.com, Inc."},98:{name:"Barnes &amp; Noble, Inc."},99:{name:"Sony Corporation"}}},version:{major:0,minor:0}}}),define("unifi/model/Client",["unifi/model/Model","jquery","backbone","underscore","ubnt/backgrid","libs/moment","unifi/util/DpiDevidMap","msg/Msg","ubnt/ubnt.ip"],function(e,t,a,n,i,o,r,s){"use strict";return e.extend({parse:function(t,a){return t=e.prototype.parse.call(this,t,a),t&&(t.tx_bytes?t.tx_bytes=parseInt(t.tx_bytes,10):t.tx_bytes=0,t.rx_bytes?t.rx_bytes=parseInt(t.rx_bytes,10):t.rx_bytes=0,t.last_seen?t.last_seen=parseInt(t.last_seen,10):t.last_seen=0),t},toSearch:function(){return{mac:this.attributes.mac,name:this.name(),ip:this.attributes.ip,connection:this.attributes.essid,is_guest:this.isGuest(),last_seen:this.absoluteLastSeen(),ap:this.attributes.ap_mac,sw:this.attributes.sw_mac}},validate:function(e,t){var a={};t?t.partial:null;return e.name&&!this.validator.name(e.name)&&(a.name=s.localize(s.E_InvalidName,s.G_PropertiesAlias)),n.size(a)?a:void 0},name:function(){return this.get("name")||this.get("hostname")||this.get("mac")},ip2long:function(){return t.ip2long(this.get("ip"))},sortStatus:function(){return this.get("authorized")?1:0},authorizable:function(){return this.isGuest()&&(!this.get("is_wired")||this.get("is_wired")&&this.get("gw_mac"))},switch_port_suffix:function(e){var t=this.get("sw_mac"),a=this.get("sw_port");return t&&a?" #"+(e&&1===a.toString().length?" ":"")+a:""},wired_connection:function(){var e=this.get("sw_mac"),t=this.get("gw_mac");this.get("sw_port");return e?e+this.switch_port_suffix(!0):t?t:""},connection:function(){return this.get("is_wired")?this.get("network"):this.get("essid")},isConnected:function(){return this.get("mac")&&!this.get("blocked")&&this.get("uptime")?!0:!1},userOrGuest:function(){return this.get("is_guest")?s.G_Guest:s.G_User},isGuest:function(){return this.get("is_guest")},uptime:function(e){return e=e||this.get("uptime"),e>0?i.Formatters.Duration.fromRaw(e||0):""},rssi:function(){var e=parseFloat(this.get("rssi"));return e||0===e?(e>45?e=45:5>e&&(e=5),e=(e-5)/40*99,(0===e?"0":e.toPrecision(2))+"%"):""},lastSeen:function(){var e,t=this.get("last_seen");return t?(e=(new Date).getTime()/1e3-parseInt(t,10),isNaN(e)?"":86400>e?i.Formatters.Duration.fromRaw(e)+" ago":o(t+"","X").format("YYYY/MM/DD HH:mm:ss")):""},absoluteLastSeen:function(){var e=this.get("last_seen");return e?o(e+"","X").format("YYYY/MM/DD HH:mm:ss"):""},dpiDeviceType:function(){var e=this.get("dev_cat");if(e){var t=r.devids.dev_type_ids[e];return t?t.name:"("+s.G_Unknown.toLowerCase()+")"}return""},dpiDeviceId:function(){var e=this.get("dev_id");if(e){var t=r.devids.device_ids[e];return t?t.name:"("+s.G_Unknown.toLowerCase()+")"}return""},dpiDeviceVendor:function(){var e=this.get("dev_vendor");if(e){var t=r.devids.vendor_ids[e];return t?t.name:"("+s.G_Unknown.toLowerCase()+")"}return""},dpiDeviceFamily:function(){var e=this.get("dev_family");if(e){var t=r.devids.family_ids[e];return t?t.name:"("+s.G_Unknown.toLowerCase()+")"}return""},dpiDeviceOSClass:function(){var e=this.get("os_class");if(e){var t=r.devids.os_class_ids[e];return t?t.name:"("+s.G_Unknown.toLowerCase()+")"}return""},dpiDeviceOSName:function(){var e=this.get("os_name");if(e){var t=r.devids.os_name_ids[e];return t?t.name:"("+s.G_Unknown.toLowerCase()+")"}return""},radioType:function(){return this.get("radio_proto")},is5g:function(){return"na"==this.get("radio")},signalWithDbm:function(){return(this.get("rssi")||0)-95+" dBm"},txRateInM:function(){return this.get("tx_rate")?this.get("tx_rate")/1e3+"M":""},rxRateInM:function(){return this.get("rx_rate")?this.get("rx_rate")/1e3+"M":""},activity:function(){var e=this.get("bytes-r")||0;return e?i.Formatters.Bytes.fromRaw(e)+"B/sec":""},activitySort:function(){return this.get("bytes-r")||0},powersave:function(){return this.get("powersave_enabled")?"Enabled":"Not Enabled"},receivedPacketsOverBytes:function(){var e=this.get("rx_packets"),t=this.get("rx_bytes");return e&&t?i.Formatters.Bytes.fromRaw(e)+" / "+i.Formatters.Bytes.fromRaw(t):""},sentPacketsOverBytes:function(){var e=this.get("tx_packets"),t=this.get("tx_bytes");return e&&t?i.Formatters.Bytes.fromRaw(e)+" / "+i.Formatters.Bytes.fromRaw(t):""},reconnect:function(e){this.sync("reconnect",this,e)},block:function(e){this.sync("block",this,e)},unblock:function(e){this.sync("unblock",this,e)},unauthorize:function(e){this.sync("unauthorize",this,e)},authorize:function(e){this.sync("authorize",this,e)},queryDpiStats:function(e){this.sync("query-dpi-stats",this,e)},sync:function(e,t,n){switch(n=n||{},e){case"update":n.contentType="application/json; charset=utf-8",n.url="/api/s/"+SITE.name+"/upd/user/"+t.get("_id"),n.type="POST",n.data=JSON.stringify(t.changed);break;case"reconnect":n.contentType="application/json; charset=utf-8",n.url="/api/s/"+SITE.name+"/cmd/stamgr",n.type="POST",n.data=JSON.stringify({mac:t.get("mac"),cmd:"kick-sta"});break;case"block":n.contentType="application/json; charset=utf-8",n.url="/api/s/"+SITE.name+"/cmd/stamgr",n.type="POST",n.data=JSON.stringify({mac:t.get("mac"),cmd:"block-sta"});break;case"unblock":n.contentType="application/json; charset=utf-8",n.url="/api/s/"+SITE.name+"/cmd/stamgr",n.type="POST",n.data=JSON.stringify({mac:t.get("mac"),cmd:"unblock-sta"});break;case"unauthorize":n.contentType="application/json; charset=utf-8",n.url="/api/s/"+SITE.name+"/cmd/stamgr",n.type="POST",n.data=JSON.stringify({mac:t.get("mac"),cmd:"unauthorize-guest"});break;case"authorize":n.contentType="application/json; charset=utf-8",n.url="/api/s/"+SITE.name+"/cmd/stamgr",n.type="POST",n.data=JSON.stringify({mac:t.get("mac"),cmd:"authorize-guest"});break;case"query-dpi-stats":n.contentType="application/json; charset=utf-8",n.url="/api/s/"+SITE.name+"/cmd/devmgr",n.type="POST",n.data=JSON.stringify({mac:t.get("mac"),cmd:"query-dpi-stats"})}return a.sync.call(this,e,t,n)}})}),define("unifi/collection/Clients",["unifi/collection/Collection","unifi/model/Client","underscore"],function(e,t,a){"use strict";return e.extend({model:t,bySite:!0,url:function(){return"/api/s/"+SITE.name+"/stat/sta"},getClientFromMac:function(e){return this.find(function(t){return t.get("mac")==e})},getUserFromIp:function(e){return this.find(function(t){return t.get("ip")==e})},sortByBytes:function(){var e=this.sortBy(function(e){return-1*(e.get("tx_bytes")+e.get("rx_bytes"))});return e},sortByUptime:function(){var e=this.sortBy(function(e){return-1*e.get("uptime")});return e},clientsPerEssid:function(){var e=this.filter(function(e){return e.get("essid")}),t=a.groupBy(e,function(e){return e.get("essid")});return t},clientsPerEssidStats:function(){var t,n=this.clientsPerEssid(),i=[];return a.each(n,function(e,t){i.push({name:t,count:e.length})}),t=new e(i),t.sortBy(function(e){return-1*e.get("count")})}})}),define("unifi/model/insights/KnownClient",["unifi/model/Client","backbone","ubnt/backgrid","libs/moment"],function(e,t,a,n){"use strict";return e.extend({toSearch:function(){return{name:this.name(),mac:this.attributes.mac,is_guest:this.isGuest(),last_seen:this.absoluteLastSeen()}}})}),define("unifi/collection/insights/KnownClients",["backbone","underscore","unifi/collection/Clients","unifi/model/insights/KnownClient","app"],function(e,t,a,n,i){"use strict";return a.extend({model:n,bySite:!0,url:function(){return"/api/s/"+SITE.name+"/stat/alluser"},parse:function(e){if(!i.data.Clients)return e.data;var a=[],n=e.data;return t.each(i.collection("Clients").models,function(e){a.push(e.attributes)}),this.mergeByProperty(n,a,"mac"),n},mergeByProperty:function(e,a,n){t.each(a,function(a){var i=t.find(e,function(e){return e[n]===a[n]});i?t.extend(i,a):e.push(a)})},sync:function(a,n,i){switch(i=i||{},a){case"read":i.contentType="application/json; charset=utf-8",i.type="POST",i.data=JSON.stringify(t.extend(i.data||{}))}return e.sync.call(this,a,n,i)}})}),define("unifi/view/gateway/DpiPropertyView",["backbone","underscore","msg/Msg","jquery","text!includes/gateway/DpiPropertyTemplate.html","libs/d3","libs/backgrid","ubnt/backgrid","unifi/model/GatewayDpi","unifi/collection/Collection","unifi/model/ClientDpi","unifi/collection/insights/KnownClients"],function(e,t,a,n,i,o,r,s,c,d,l,m){"use strict";return e.View.extend({template:t.template(i),initialize:function(e){t.bindAll(this),this.app=e.app,this.grids={},this.render()},showCategories:function(){this.$categorySections.show(),this.$applicationSections.hide(),this.$clientSections.hide()},showApplications:function(e){this.$categorySections.hide(),this.$applicationSections.show(),this.$clientSections.hide(),this.renderAppClientChart(e)},showClients:function(e){this.$categorySections.hide(),this.$applicationSections.hide(),this.$clientSections.show()},render:function(){var e=this;this.model&&!t.isEmpty(this.model.get("by_cat"))&&(!this.rendered&&(this.rendered=!0)&&(this.$el.html(this.template({msg:a})),this.$categorySections=this.$el.find("> .category"),this.$applicationSections=this.$el.find("> .application"),this.$clientSections=this.$el.find("> .client"),this.$totalBytes=this.$el.find("> .category.header > .totalBytes"),this.$rxBytes=this.$el.find("> .category.header > .rxBytes"),this.$txBytes=this.$el.find("> .category.header > .txBytes"),this.$chart=this.$el.find("> .category.graph > .chart"),this.$chartDetail=this.$el.find("> .category.graph > .chartDetail"),this.$detail=this.$el.find("> .category.detail"),this.$chart.on("mouseover","> .chartSection",function(t){var a=n(this);e.$detail.scrollTop(0),e.$currentCategoryRow=a,e.renderRowDetail(e.$currentCategoryRow)}),this.$detail.on("click","> div.appTile > div",function(t){var a=n(this);e.$currentApplicationRow=a,e.showApplications(e.$currentApplicationRow)}),this.$applicationHeader=this.$el.find("> .application.header"),this.$applicationBack=this.$applicationHeader.find("> .back"),this.$applicationName=this.$applicationHeader.find("> .title > .name"),this.$applicationChart=this.$el.find("> .application.chart"),this.$applicationBack.on("click",function(t){e.$currentApplicationRow=null,e.showCategories()}),this.showCategories()),this.populate())},display:function(e,t){var a=this.$chart.find('.chartSection[data-cat="'+e+'"]');this.$chart.find("> div").removeClass("selected"),a.addClass("selected"),this.$detail.scrollTop(0),this.$currentCategoryRow=a,a.css({cursor:"default"}),this.renderRowDetail(this.$currentCategoryRow),void 0!==t&&(this.$currentApplicationRow=this.$detail.find('.appTile[data-cat="'+e+'"][data-app="'+t+'"] > div'),this.showApplications(this.$currentApplicationRow))},populate:function(){this.renderTotalData(),this.renderGraph(),this.$currentCategoryRow&&this.renderRowDetail(this.$currentCategoryRow),this.$currentApplicationRow&&this.showApplications(this.$currentApplicationRow)},renderTotalData:function(){var e=this.model.get("by_cat_total"),t=s.Formatters.Bytes.fromRaw((e.rx_bytes||0)+(e.tx_bytes||0)),a=s.Formatters.Bytes.fromRaw(e.rx_bytes||0),n=s.Formatters.Bytes.fromRaw(e.tx_bytes||0);this.$totalBytes.text(t),this.$rxBytes.text(a),this.$txBytes.text(n)},renderGraph:function(){var e,a,i,o,r,c,d,l,m,g,u,h,p,y=this.model.get("by_cat"),_=this.model.get("by_cat_total"),f=(_.rx_bytes||0)+(_.tx_bytes||0),v=(this.$chart.width(),this.$currentCategoryRow&&this.$currentCategoryRow.attr("data-cat")),b=this.$currentCategoryRow&&this.$currentCategoryRow.attr("data-app");this.$chart.empty(),t.each(y,function(t,y){e=(t.rx_bytes||0)+(t.tx_bytes||0),a=s.Formatters.Bytes.fromRaw((t.rx_bytes||0)+(t.tx_bytes||0)),i=s.Formatters.Bytes.fromRaw(t.rx_bytes||0),o=s.Formatters.Bytes.fromRaw(t.tx_bytes||0),r=this.model.getName("by_cat",t),c=t.cat,d=t.app,l=e/f,m=100*l,g=m.toFixed(1),u=90+15*y,1>g&&(g="< 1"),u>200&&(u=200),h=n('<div class="chartSection"></div>').attr("data-cat",c).attr("data-app",d).attr("data-bytes_rx",i).attr("data-bytes_tx",o).attr("data-bytes_total",a).attr("data-name",g+"% "+r).css({width:m+"%"}),(v==c&&b==d||!this.graphRendered)&&(this.graphRendered=!0,this.$currentCategoryRow=h),p=n('<div class="bar"></div>').css({"background-color":"rgb("+u+","+u+","+u+")"}),h.append(p),h.append(n('<div class="calloutTop"></div><div class="calloutBottom"></div>')),this.$chart.append(h)},this)},renderRowDetail:function(e){this.$chart.find("> div").removeClass("selected"),e.css({cursor:"default"}),e.addClass("selected");var t={tx_bytes:e.attr("data-bytes_tx"),rx_bytes:e.attr("data-bytes_rx"),total_bytes:e.attr("data-bytes_total"),name:e.attr("data-name")},a=n('<div>    <span class="name"></span> -     <span class="totalBytes"></span>     (        <span class="ubnt-icon-arrow-down"></span>         <span class="rxBytes"></span>          <span class="ubnt-icon-arrow-up"></span>         <span class="txBytes"></span>    )</div>');a.find(".totalBytes").text(t.total_bytes),a.find(".rxBytes").text(t.rx_bytes),a.find(".txBytes").text(t.tx_bytes),a.find(".name").text(t.name),this.$chartDetail.empty().append(a),this.renderAppData(e)},renderAppData:function(e){var a,i,o,r,s,c,d,l,m=e.attr("data-cat"),g=t.where(this.model.get("by_app"),{cat:+m}),u=this.model.totalCategoryData(g),h=this.$currentApplicationRow&&this.$currentApplicationRow.attr("app")||null,p=this.$currentApplicationRow&&this.$currentApplicationRow.attr("cat")||null;this.$detail.empty(),t.each(g,function(e){s=((e.tx_bytes||0)+(e.rx_bytes||0))/(u.tx_bytes+u.rx_bytes),c=(100*s).toFixed(1),d=this.model.getName("by_app",e),l=this.model.getIconUrl("by_app",e),1>c&&(c="< 1"),a=n('<div class="appTile"></div>').attr("data-app",e.app).attr("data-cat",e.cat).attr("title",d),h==e.cat&&p==e.app&&(this.$currentApplicationRow=a),i=n('<div class="appIcon"></div>'),o=n('<div class="inner"></div>'),l?o.prepend(n('<div class="appLogo"></div>').css({background:'url("'+l+'")'})):o.text(d),i.append(o),r=n('<div class="appPercent"></div>').text(c+"%"),a.append(i).append(r),this.$detail.append(a)},this)},setData:function(e){e&&(this.model||(this.model=new c),this.model.set({by_cat:e.by_cat||[],by_app:e.by_app||[]},{silent:!0}),this.model.parseData(),this.render())},renderAppClientChart:function(a){var n=this,i=a.parent().attr("data-cat"),o=a.parent().attr("data-app"),r=t.where(this.model.get("by_app"),{cat:+i,app:+o})[0],s=this.model.getName("by_app",r),c=t.reduce(r.clients,function(e,t){var a=n.app.collection("Clients").findWhere({mac:t.mac});return a&&(t.staData=a,e.push(t)),e},[]),d=e.Collection.extend({model:l}),m=new d;m.reset(c),this.$applicationName.text(s),this.clientDpiTableGrid(this.$applicationChart,m)},clientDpiTableGrid:function(e,t){if(!this.grids.appClientDpi){var i=this,o=[{name:"mac",label:a.G_ClientsNameMACAddress,editable:!1,headerCell:s.Headers.customSortHeader,cell:s.Cells.ComplexHtmlCell.extend({formatter:{fromRaw:function(e){var t=e.get("staData"),a=n('<span "macCell"></span>');return a.text(t.name()).on("click",function(){i.clientProperty(t)}).css({color:"#1292c5",cursor:"pointer"}),a},toRaw:function(e){return e}},className:"mac-cell"}),sortValue:function(e){var t=i.app.collection("Clients").findWhere({mac:e.get("mac")});return t?t.name():e.get("mac")},remove:function(){this.$el.find(".macCell").off("click"),s.Cells.ComplexHtmlCell.remove.apply(this,arguments)}},{name:"packets",label:a.G_PortForwardUpPkts,editable:!1,headerCell:s.Headers.customSortHeader,cell:s.Cells.ComplexCell.extend({formatter:{fromRaw:function(e){var t=new r.NumberFormatter({decimals:0});return t.fromRaw(e.packetsTotal())},toRaw:function(e){return e}},className:"packets-cell"}),sortValue:function(e){return e.packetsTotal()}},{name:"bytes",label:a.G_PortForwardUpBytes,editable:!1,headerCell:s.Headers.customSortHeader,cell:s.Cells.ComplexCell.extend({formatter:{fromRaw:function(e){return s.Formatters.Bytes.fromRaw(e.bytesTotal())},toRaw:function(e){return e}},className:"bytes-cell"}),sortValue:function(e){return e.bytesTotal()}}];this.grids.dpi=this.grid(o,t,e)}},grid:function(e,a,n,i,o){if(a){var r=new s.Grid(o=t.extend({columns:e,collection:a,pageable:!0,footer:s.Paginators.Mini,noRows:i},o||{}));return n.html(r.render().$el),o.pageable&&r.paginate(1,4),r}i&&n.html(i)},clientProperty:function(e){this.app.routers.clients.views.index.property(e,{section:"dpi"})},remove:function(){t.each(this.grids,function(e){e.remove()}),this.grids={},this.$currentCategoryRow=null,this.$chart&&this.$chart.off("click","> div"),this.rendered=!1,e.View.prototype.remove.apply(this,arguments)}})}),define("unifi/model/PortForward",["unifi/model/Model","underscore","backbone","msg/Msg"],function(e,t,a,n){"use strict";return e.extend({validate:function(e,a){var i={},o=a?a.partial:null;return o&&"name"!=o||(e.name?this.validator.name(e.name)||(i.name=n.localize(n.E_InvalidName,n.G_Name)):i.name=n.localize(n.E_CannotBeEmpty,n.G_Name)),o&&"src"!=o||(e.src?"any"==e.src||this.validator.ip(e.src)||this.validator.iprange(e.src)||this.validator.subnet(e.src)||"!"===e.src.charAt(0)&&(this.validator.ip(e.src.substring(1))||this.validator.iprange(e.src.substring(1))||this.validator.subnet(e.src.substring(1)))||(i.src=n.localize(n.E_IncorrectIPRangeSubnet,n.G_PortForwardSource)):i.src=n.localize(n.E_CannotBeEmpty,n.G_PortForwardSource)),o&&"dst_port"!=o||(e.dst_port?this.validator.rangeList(e.dst_port,",-",15,1,65535)||(i.dst_port=n.localize(n.E_IncorrectNumberRangeList,n.G_Port,15,1,65535)):i.dst_port=n.localize(n.E_CannotBeEmpty,n.G_Port)),o&&"fwd"!=o||(e.fwd?this.validator.ip(e.fwd)||(i.fwd=n.localize(n.E_IncorrectIPAddress,n.G_PortForwardDestIp)):i.fwd=n.localize(n.E_CannotBeEmpty,n.G_PortForwardDestIp)),o&&"fwd_port"!=o||(e.fwd_port?this.validator.rangeList(e.fwd_port,",-",15,1,65535)||(i.fwd_port=n.localize(n.E_IncorrectNumberRangeList,n.G_PortForwardDestPort,15,1,65535)):i.fwd_port=n.localize(n.E_CannotBeEmpty,n.G_PortForwardDestPort)),t.size(i)?i:void 0},sync:function(e,t,n){switch(n=n||{},e){case"create":n.contentType="application/json; charset=utf-8",n.url="/api/s/"+SITE.name+"/add/portforward",n.type="POST";break;case"update":n.contentType="application/json; charset=utf-8",n.url="/api/s/"+SITE.name+"/upd/portforward/"+t.id,n.type="POST",n.data=JSON.stringify(t.toJSON({exclude:["_id","site_id"]}));break;case"delete":n.contentType="application/json; charset=utf-8",n.url="/api/s/"+SITE.name+"/del/portforward/"+t.id,n.type="POST"}return a.sync.call(this,e,t,n)}})}),define("unifi/collection/PortForward",["unifi/collection/Collection","underscore","unifi/model/PortForward"],function(e,t,a){"use strict";return e.extend({model:a,bySite:!0,url:function(){return"/api/s/"+SITE.name+"/list/portforward"}})}),define("unifi/model/DynamicDNS",["unifi/model/Model","underscore","backbone","msg/Msg"],function(e,t,a,n){"use strict";return e.extend({validate:function(e,a){var i={},o=a?a.partial:null;return o&&"login"!=o||e.login||(i.login=n.localize(n.E_CannotBeEmpty,n.G_PropertiesDDNSUsername)),o&&"x_password"!=o||e.x_password||(i.x_password=n.localize(n.E_CannotBeEmpty,n.G_PropertiesDDNSPassword)),o&&"host_name"!=o||e.host_name||(i.host_name=n.localize(n.E_CannotBeEmpty,n.G_PropertiesDDNSHostname)),
t.size(i)?i:void 0},service:function(){return this.get("service")},hostname:function(){return this.get("host_name")},server:function(){return this.get("server")},username:function(){return this.get("login")},sync:function(e,t,n){switch(n=n||{},e){case"create":n.contentType="application/json; charset=utf-8",n.url="/api/s/"+SITE.name+"/add/dynamicdns",n.type="POST";break;case"update":n.contentType="application/json; charset=utf-8",n.url="/api/s/"+SITE.name+"/upd/dynamicdns/"+t.id,n.type="POST",n.data=JSON.stringify(t.toJSON({exclude:["_id","site_id"]}));break;case"delete":n.contentType="application/json; charset=utf-8",n.url="/api/s/"+SITE.name+"/del/dynamicdns/"+t.id,n.type="POST"}return a.sync.call(this,e,t,n)}})}),define("unifi/collection/DynamicDNS",["unifi/collection/Collection","underscore","unifi/model/DynamicDNS"],function(e,t,a){"use strict";return e.extend({model:a,bySite:!0,url:function(){return"/api/s/"+SITE.name+"/list/dynamicdns"}})}),define("text!includes/gateway/gatewayPropertiesTemplate.html",[],function(){return'<div class="accordion-header">\n    <div class="accordion-title">\n        <span class="device-icons access-point half"></span>\n        <span class="title-text"><%- name() %></span>\n        <div class="ubnt-icon-arrow-down sidebar-icons minmax minimize"></div>\n    </div>\n    <div class="right">\n        <div class="ubnt-icon-new-window sidebar-icons detach" title="Detach"></div>\n        <div class="ubnt-icon-close sidebar-icons remove" title="Close"></div>\n    </div>\n</div>\n<div class="property-content">\n    <div class="loading"><span><%- msg.N_Loading %></span></div>\n\n    <%= diagram %>\n\n    <div class="status-alert status-success"><span class="ubnt-icon-check checkmark"></span><%- msg.G_Saved %></div>\n    <div class="status-alert status-error"><span class="ubnt-icon-warning alert"></span><%- msg.E_Error %></div>\n\n    <div class="tabs">\n        <ul>\n            <li class="tab-nav-list-item">\n                <a class="tab-button" href="#gatewayDetails<%- _id %>"><%- msg.G_PropertiesDetails %></a>\n            </li>\n            <li class="tab-nav-list-item">\n                <a class="tab-button" href="#gatewayStatistics<%- _id %>"><%- msg.G_Stats %></a>\n            </li>\n            <li class="tab-nav-list-item">\n                <a class="tab-button" href="#gatewayNetworks<%- _id %>"><%- msg.G_PropertiesNetworks %></a>\n            </li>\n            <li class="tab-nav-list-item ap-configs">\n                <a class="tab-button" href="#gatewayConfig<%- _id %>"><%- msg.G_PropertiesConfiguration %></a>\n            </li>\n        </ul>\n        <div class="properties-container overflow">\n            <div id="gatewayDetails<%- _id %>" class="gateway-details tab-content">\n                <div class="accordion">\n                    <div class="accordion-header">\n                        <div class="accordion-title"><%- msg.G_DevicesOverview %></div>\n                    </div>\n                    <div class="basic-overview">\n                        <table>\n                            <tr class="table-row">\n                                <td class="column-name"><%- msg.G_PropertiesMACAddress %></td>\n                                <td class="column-value"><%- get(\'mac\') %></td>\n                            </tr>\n                            <tr class="table-row">\n                                <td class="column-name"><%- msg.G_DevicesModel %></td>\n                                <td class="column-value"><%- apModel() %></td>\n                            </tr>\n                            <tr class="table-row">\n                                <td class="column-name"><%- msg.G_Version %></td>\n                                <td class="column-value bind-version"></td>\n                            </tr>\n                        </table>\n                        <hr />\n                        <table>\n                            <tr class="table-row ip-address">\n                                <td class="column-name"><%- msg.G_PropertiesLANIPAddress %></td>\n                                <td class="column-value bind-lan-ip"></td>\n                            </tr>\n                            <tr class="table-row uptime">\n                                <td class="column-name"><%- msg.G_Uptime %></td>\n                                <td class="column-value bind-uptime"></td>\n                            </tr>\n                        </table>\n                    </div>\n                    <div class="accordion-header gw-wan-details">\n                        <div class="accordion-title"><%- msg.G_DevicesWan %></div>\n                    </div>\n                    <div class="devices-wan gw-wan-details">\n                        <table class="side-by-side">\n                            <tr class="table-row">\n                                <td class="column-name"><%- msg.G_IPAddress %></td>\n                                <td class="column-value bind-wan-ip"></td>\n                            </tr>\n                            <tr class="table-row">\n                                <td class="column-name"><%- msg.G_Speed %></td>\n                                <td class="column-value bind-uplink-speed"></td>\n                            </tr>\n                            <tr class="table-row">\n                                <td class="column-name"><%- msg.G_PropertiesDuplex %></td>\n                                <td class="column-value bind-uplink-duplex"></td>\n                            </tr>\n                        </table>\n\n                        <table class="side-by-side">\n                            <tr class="table-row">\n                                <td class="column-name"><%- msg.G_PropertiesDownPktsBytes %></td>\n                                <td class="column-value bind-uplink-down-packets"></td>\n                            </tr>\n                            <tr class="table-row">\n                                <td class="column-name"><%- msg.G_PropertiesUpPktsBytes %></td>\n                                <td class="column-value bind-uplink-up-packets"></td>\n                            </tr>\n                            <tr class="table-row">\n                                <td class="column-name"><%- msg.G_PropertiesDownActivity %></td>\n                                <td class="column-value bind-uplink-down-rate"></td>\n                            </tr>\n                            <tr class="table-row">\n                                <td class="column-name"><%- msg.G_PropertiesUpActivity %></td>\n                                <td class="column-value bind-uplink-up-rate"></td>\n                            </tr>\n                        </table>\n                    </div>\n                    <div class="accordion-header gw-adv-adopt">\n                        <div class="accordion-title"><%- msg.G_PropertiesAdvancedOpts %></div>\n                    </div>\n                    <div class="gw-adv-adopt">\n                        <form action="" class="advAdoptForm gw-adv-adopt">\n                            <div class="row">\n                                <label class="label inline"><%- msg.G_IP %></label>\n                                <input class="input inline medium bind-adopt-ip" type="text" value="" name="ip" />\n                                <span class="colon">:</span>\n                                <input class="input inline small" type="text" value="22" name="port" />\n                            </div>\n                            <div class="row">\n                                <label class="label inline"><%- msg.G_UN %></label>\n                                <input class="input inline" type="text" value="" name="username" />\n                            </div>\n                            <div class="row">\n                                <label class="label inline"><%- msg.G_PW %></label>\n                                <input class="input inline" type="password" value="" name="password" />\n                            </div>\n                            <div class="row">\n                                <label class="label inline"><%- msg.G_PropertiesInformURL %></label>\n                                <input class="input inline bind-adopt-url" type="text" value="" name="url" />\n                            </div>\n                            <button class="button is-admin" type="submit"><%- msg.G_Adopt %></button>\n                        </form>\n                    </div>\n                </div>\n            </div>\n            <div id="gatewayStatistics<%- _id %>" class="tab-content statistics">\n                <div class="statistics-tab-content"><%- msg.G_PropertiesNoGatewayDpi %></div>\n            </div>\n            <div id="gatewayNetworks<%- _id %>" class="tab-content minigrid">\n                <div class="data-table data-table-networks bind-networks"><%- msg.G_PropertiesNoNetworksConfigured %></div>\n            </div>\n            <div id="gatewayConfig<%- _id %>" class="tab-content ap-configs">\n                <div class="accordion">\n                    <div class="accordion-header ap-configs">\n                        <div class="accordion-title"><%- msg.G_Config %></div>\n                    </div>\n                    <div class="ap-configs">\n                        <form action="" class="aliasForm">\n                            <div class="row">\n                                <label for="aliasName<%- _id %>" class="label"><%- msg.G_PropertiesAlias %></label>\n                                <input name="name" id="aliasName<%- _id %>" type="text" class="input" value="<%- get(\'name\') %>" pattern=".{1,128}" title="<%- msg.E_AliasName %>" />\n                            </div>\n                            <button class="button is-admin" type="submit"><%- msg.G_Apply %></button>\n                        </form>\n                    </div>\n                    <div class="accordion-header wan-config">\n                        <div class="accordion-title"><%- msg.G_DevicesWan %></div>\n                    </div>\n                    <div class="wan-config">\n                        <form class="wanForm bind-wan">\n                            <div class="clearfix">\n                                <div class="row">\n                                   <label for="connectionnType<%- _id %>" class="label inline"><%- msg.G_PropertiesConnectionType %></label>\n                                   <select name="connectionType" class="connection-type" id="connectionnType<%- _id %>">\n                                       <option value="dhcp"><%- msg.G_PropertiesUsingDHCP %></option>\n                                       <option value="static"><%- msg.G_PropertiesStaticIP %></option>\n                                       <option value="pppoe"><%- msg.G_PropertiesPPPoE %></option>\n                                   </select>\n                                </div>\n\n                                <div class="side-by-side">\n                                    <div class="row connection-toggled connection-static">\n                                        <label class="label inline"><%- msg.G_IPAddress %></label>\n                                        <input type="text" class="input inline" name="ip" value="" />\n                                    </div>\n                                    <div class="row connection-toggled connection-static">\n                                        <label class="label inline"><%- msg.G_PropertiesSubnetMask %></label>\n                                        <input type="text" class="input inline" name="netmask" value="" />\n                                    </div>\n                                    <div class="row connection-toggled connection-static">\n                                        <label for="gateway<%- _id %>" class="label inline"><%- msg.G_PropertiesRouter %></label>\n                                        <input type="text" class="input inline" name="gateway" id="gateway<%- _id %>" value="" />\n                                    </div>\n\n                                    <div class="row connection-toggled connection-pppoe">\n                                        <label class="label inline"><%- msg.G_UN %></label>\n                                        <input type="text" class="input inline" name="username" value="" />\n                                    </div>\n                                    <div class="row connection-toggled connection-pppoe">\n                                        <label class="label inline"><%- msg.G_PW %></label>\n                                        <input type="text" class="input inline" name="x_password" value="" />\n                                    </div>\n                                </div>\n\n                                <div class="side-by-side">\n                                    <div class="row">\n                                        <label class="label inline"><%- msg.G_PropertiesPreferredDNS %></label>\n                                        <input type="text" class="input inline" name="dns1" value="" />\n                                    </div>\n                                    <div class="row">\n                                        <label class="label inline"><%- msg.G_PropertiesAlternateDNS %></label>\n                                        <input type="text" class="input inline" name="dns2" value="" />\n                                    </div>\n                                </div>\n                            </div>\n\n                            <button class="button is-admin" type="submit"><%- msg.G_Apply %></button>\n                        </form>\n                    </div>\n                    <div class="accordion-header portfwd-config">\n                        <div class="accordion-title"><%- msg.G_PropertiesPortForward %></div>\n                    </div>\n                    <div class="portfwd-config">\n                        <button class="button portfwd-create is-admin" name="create">\n                            <span class="ui-button-icon-primary ubnt-icon-plus"></span>\n                            <span class="nav-text"><%- msg.G_Create %></span>\n                        </button>\n\n                        <div class="portfwd-list">\n                            <div class="data-table data-table-portfwd data-table-fit"><%- msg.G_PropertiesNoPortForwardingConfigured %></div>\n                        </div>\n\n                        <div class="portfwd-form"></div>\n                    </div>\n                    <div class="accordion-header dynamicdns-config">\n                        <div class="accordion-title"><%- msg.G_PropertiesDynamicDNS %></div>\n                    </div>\n                    <div class="dynamicdns-config">\n                        <button class="button dynamicdns-create is-admin" name="create">\n                            <span class="ui-button-icon-primary ubnt-icon-plus"></span>\n                            <span class="nav-text"><%- msg.G_Create %></span>\n                        </button>\n                        <div class="dynamicdns-list">\n                            <div class="data-table data-table-dynamicdns data-table-fit"><%- msg.G_PropertiesNoDynamicDNSConfigured %></div>\n                        </div>\n                        <div class="dynamicdns-form"></div>\n                    </div>\n\n                    <div class="accordion-header is-admin">\n                        <div class="accordion-title"><%- msg.G_PropertiesCustomUpgrade %></div>\n                    </div>\n                    <div class="is-admin">\n                        <div class="row">\n                            <%- msg.G_PropertiesCustomFirmwareTxt %>\n                        </div>\n                        <button class="button custom-upgrade left">\n                            <span class="ui-button-icon-primary ubnt-icon-download"></span>\n                            <span class="nav-text"><%- msg.G_PropertiesCustomUpgrade %></span>\n                        </button>\n                    </div>\n\n                    <div class="accordion-header is-admin">\n                        <div class="accordion-title"><%- msg.G_PropertiesForgetGateway %></div>\n                    </div>\n                    <div class="is-admin">\n                        <div class="row">\n                            <%- msg.G_PropertiesForgetGatewayTxt %>\n                        </div>\n                        <button class="button forget left">\n                            <span class="ui-button-icon-primary ubnt-icon-forget-this-network"></span>\n                            <span class="nav-text"><%- msg.G_PropertiesForget %></span>\n                        </button>\n                        <div class="left">\n                            <select name="move" class="move-dropdown" data-myposition="left bottom" data-atposition="left top"></select>\n                        </div>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class="dialog-controls is-admin clearfix">\n            <button class="button button-locate left">\n                <span class="ui-button-icon-primary ubnt-icon-location sidebar-icons locate"></span>\n                <span class="nav-text"><%- msg.G_Locate %></span>\n            </button>\n            <button class="button button-restart left">\n                <span class="ui-button-icon-primary ubnt-icon-rotate sidebar-icons restart"></span>\n                <span class="nav-text"><%- msg.G_Restart %></span>\n            </button>\n            <button class="button button-update left">\n                <span class="ui-button-icon-primary ubnt-icon-download sidebar-icons update"></span>\n                <span class="nav-text"><%- msg.G_Upgrade %></span>\n            </button>\n            <button class="button button-adopt left">\n                <span class="ui-button-icon-primary ubnt-icon-plus sidebar-icons adopt"></span>\n                <span class="nav-text"><%- msg.G_Adopt %></span>\n            </button>\n        </div>\n    </div>\n</div>\n'}),define("text!includes/gateway/gatewayDiagramUGW3Template.html",[],function(){return'<div class="diagram gateway port3 bind-state">\n    <div class="port wan"><div class="status"></div><div class="name"><%- msg.G_DevicesWan %></div></div>\n    <div class="port lan"><div class="status"></div><div class="name"><%- msg.G_DevicesLan %></div></div>\n    <div class="port voip"><div class="status"></div><div class="name"><%- msg.G_DevicesVoip %></div></div>\n</div>'}),define("text!includes/gateway/gatewayDiagramUGW4Template.html",[],function(){return'<div class="diagram gateway port4 bind-state">\n    <div class="port lan"><div class="status"></div><div class="name"><%- msg.G_DevicesLan %></div></div>\n    <div class="port voip"><div class="status"></div><div class="name"><%- msg.G_DevicesVoip %></div></div>\n    <div class="port wan wan1"><div class="status"></div><div class="name"><%- msg.G_DevicesWan %>1</div></div>\n    <div class="port wan wan2"><div class="status"></div><div class="name"><%- msg.G_DevicesWan %>2</div></div>\n</div>'}),define("text!includes/gateway/gatewayDiagramUGW8Template.html",[],function(){return'<div class="diagram gateway port8 bind-state">\n    <div class="port lan lan1"><div class="status"></div><div class="name"><%- msg.G_DevicesLan %>1</div></div>\n    <div class="port lan lan2"><div class="status"></div><div class="name"><%- msg.G_DevicesLan %>2</div></div>\n    <div class="port lan lan3"><div class="status"></div><div class="name"><%- msg.G_DevicesLan %>3</div></div>\n    <div class="port lan lan4"><div class="status"></div><div class="name"><%- msg.G_DevicesLan %>4</div></div>\n    <div class="port lan lan5"><div class="status"></div><div class="name"><%- msg.G_DevicesLan %>5</div></div>\n    <div class="port voip"><div class="status"></div><div class="name"><%- msg.G_DevicesVoip %></div></div>\n    <div class="port wan wan1"><div class="status"></div><div class="name"><%- msg.G_DevicesWan %>1</div></div>\n    <div class="port wan wan2"><div class="status"></div><div class="name"><%- msg.G_DevicesWan %>2</div></div>\n</div>'}),define("unifi/view/gateway/PropertyView",["unifi/view/devices/PropertyView","unifi/view/gateway/PortForwardFormView","unifi/view/gateway/DynamicDNSFormView","unifi/view/gateway/DpiPropertyView","ubnt/backgrid","libs/backgrid","underscore","backbone","jquery","msg/Msg","unifi/collection/PortForward","unifi/collection/DynamicDNS","text!includes/gateway/gatewayPropertiesTemplate.html","text!includes/gateway/gatewayDiagramUGW3Template.html","text!includes/gateway/gatewayDiagramUGW4Template.html","text!includes/gateway/gatewayDiagramUGW8Template.html","ubnt/view/dialogs/AlertDialogView","ubnt/view/dialogs/ConfirmDialogView","stickit"],function(e,t,a,n,i,o,r,s,c,d,l,m,g,u,h,p,y,_){"use strict";return e.extend({templateId:g,diagramTemplate:null,bindings:function(){return r.extend({},e.prototype.bindings.call(this),{".bind-wan-ip":{observe:"uplink",onGet:function(e){this.$bindWanIp.text(e.ip),this.$bindUplinkSpeed.text(this.model.uplinkSpeed()),this.$bindUplinkDuplex.text(this.model.uplinkDuplex()),this.$bindUplinkDownPackets.text(this.model.uplinkDownPackets()),this.$bindUplinkUpPackets.text(this.model.uplinkUpPackets()),this.$bindUplinkDownRate.text(this.model.uplinkActivityDown()),this.$bindUplinkUpRate.text(this.model.uplinkActivityUp())}},".bind-wan":{observe:"config_network_wan",onGet:function(e){this.populateNetworkForm(this.$wanForm,e)}},".bind-networks":{observe:"network_table",onGet:function(e){this.networkTable()}},".bind-state":{observe:["uplink","port_table"],onGet:function(){this.populateStates()}},".bind-lan-ip":{observe:"port_table",onGet:function(e){var t=r.findWhere(e,{name:"lan"});t&&this.$bindLanIp.text(t.ip||"")}},".statistics-tab-content":{observe:"dpistats_table",onGet:function(){this.renderDpi()}}})},initialize:function(t){switch(this.model.get("model")){case"UGW3":this.diagramTemplate=r.template(u,{msg:d});break;case"UGW4":this.diagramTemplate=r.template(h,{msg:d});break;case"UGW8":this.diagramTemplate=r.template(p,{msg:d})}e.prototype.initialize.call(this,t)},dependencies:function(){var e={PortForward:l,DynamicDNS:m},t=[],a={},n=this;r.each(e,function(e,n){t.push(a[n]=c.Deferred())},this),c.when.apply(c,t).then(function(){n._dependencies.resolve()},function(){n._dependencies.reject()}),r.each(e,function(e,t){this.app.collection(t,{fetch:{reload:!1,deferred:a[t]}},e)},this)},render:function(t){var a=this.rendered;return e.prototype.render.call(this,t),a||(this.forms={},this.listenTo(this.app.collection("PortForward"),"add remove",this.portForwardTable),this.listenTo(this.app.collection("DynamicDNS"),"add remove",this.dynamicDNSTable),this.noPortFwdRows=this.$(".data-table-portfwd").html(),this.noDynamicDNSRows=this.$(".data-table-dynamicdns").html(),this.noNetworkRows=this.$(".data-table-networks").html(),this.$advAdoptForm=this.$(".advAdoptForm"),this.$gatewayDetails=this.$(".gateway-details"),this.$gatewayConfig=this.$(".ap-configs"),this.$wanForm=this.$(".wanForm"),this.$connectionType=this.$wanForm.find("select[name=connectionType]"),this.$bindWanIp=this.$(".bind-wan-ip"),this.$bindUplinkSpeed=this.$(".bind-uplink-speed"),this.$bindUplinkDuplex=this.$(".bind-uplink-duplex"),this.$bindUplinkDownPackets=this.$(".bind-uplink-down-packets"),this.$bindUplinkUpPackets=this.$(".bind-uplink-up-packets"),this.$bindUplinkDownRate=this.$(".bind-uplink-down-rate"),this.$bindUplinkUpRate=this.$(".bind-uplink-up-rate"),this.$bindLanIp=this.$(".bind-lan-ip"),this.$portFwdCreate=this.$('.portfwd-config button[name="create"]'),this.$portFwdList=this.$(".portfwd-list"),this.$portFwdForm=this.$(".portfwd-form"),this.$portFwdCreate.on("click",c.proxy(function(){this.portForwardForm()},this)),this.$portFwdForm.hide(),this.$dynamicDNSCreate=this.$('.dynamicdns-config button[name="create"]'),this.$dynamicDNSList=this.$(".dynamicdns-list"),this.$dynamicDNSForm=this.$(".dynamicdns-form"),this.$dynamicDNSCreate.on("click",c.proxy(function(){this.dynamicDNSForm()},this)),this.$dynamicDNSForm.hide(),this.$connectionType.on("change",c.proxy(function(e){var t=c(e.target).val();this.$wanForm.find(".connection-toggled").hide().filter(".connection-"+t).show()},this)).trigger("change"),this.$wanForm.on("submit",c.proxy(function(e){e.preventDefault(),this.updateNetwork(this.$wanForm,"config_network_wan")},this)),this.renderDiagram(),"resolved"===this._rendered.state()&&"resolved"==this._dependencies.state()?this.populate():"pending"===this._rendered.state()&&this._rendered.resolve(),this.stickit(this.model,this.bindings())),this.populateStates(),this.networkTable(),this.portForwardTable(),this.dynamicDNSTable(),this.toggleAdvancedAdoption(),a||this.detach(),this.options.options&&"lan"==this.options.options.port&&this.$diagramLan.click(),this.renderDpi(),this.options.options&&this.options.options.section&&this.setSection(this.options.options.section,this.options.options.cat,this.options.options.app),this},setSection:function(e,t,a){if(t||a){var n;switch(e){case"dpi":n=1}this.$tabs.tabs("option","active",n),this.options.options.section=null,this.options.options.cat=null,this.options.options.app=null,this.dpiPropertyView&&this.dpiPropertyView.display(t,a)}},toggleAdvancedAdoption:function(){var e=this.app.collection("Devices"),t=e.where({type:"ugw",site_id:SITE.id});t.length?(this.isAdoptable?(this.$el.find("div.gw-adv-adopt").hide(),this.$advAdoptForm.off("submit",this.onAdvAdoptFormSubmit)):void 0===this.isAdoptable&&this.$el.find("div.gw-adv-adopt").hide(),this.isAdoptable=!1):this.isAdoptable||(this.isAdoptable=!0,this.$el.find("div.gw-adv-adopt").hide(),this.$el.find("div.gw-adv-adopt.accordion-header").show(),this.$advAdoptForm.on("submit",this.onAdvAdoptFormSubmit))},renderDiagram:function(){this.$diagram=this.$(".diagram"),this.$diagramWan=this.$(".diagram .port.wan"),this.$diagramLan=this.$(".diagram .port.lan"),this.$diagramVoice=this.$(".diagram .port.voice"),this.$diagramWan.on("click",c.proxy(function(){var e=r.findWhere(this.model.get("port_table"),{name:"wan"}),t=e&&e.up?e.up:!1;this.$tabs.tabs("option","active",0),t&&this.$gatewayDetails.find(".accordion").accordion("option","active",1)},this)),this.$diagramLan.on("click",c.proxy(function(){this.$tabs.tabs("option","active",1)},this)),this.$diagramVoice.on("click",c.proxy(function(){this.$el.hasClass("gw-has-voice")&&(this.$tabs.tabs("option","active",0),this.$gatewayDetails.find(".accordion").accordion("option","active",2))},this))},args:function(){return{_id:this.id,diagram:this.diagramTemplate,msg:d}},onAdvAdoptFormSubmit:function(e){e.preventDefault();var t=this,a=this.model,n=c(e.target).find("button");this.$advAdoptForm.find(".error").removeClass("error"),n.attr("disabled","disabled");var i=a.advanceAdopt({data:{ip:this.$advAdoptForm.find('input[name="ip"]').val(),port:this.$advAdoptForm.find('input[name="port"]').val(),username:this.$advAdoptForm.find('input[name="username"]').val(),password:this.$advAdoptForm.find('input[name="password"]').val(),url:this.$advAdoptForm.find('input[name="url"]').val()},success:function(e){"ok"===e.meta.rc?a.fetch({success:function(e,a,n){"ok"===a.meta.rc&&t.parent.property(e)},complete:function(){n.removeAttr("disabled")}}):(t.showErrorState(),n.removeAttr("disabled"))},error:function(){t.showErrorState(),n.removeAttr("disabled")}});!i&&this.model.validationError&&r.each(this.model.validationError,function(e,t){switch(t){case"username":case"password":this.$advAdoptForm.find('input[name="'+t+'"]').addClass("error"),n.removeAttr("disabled")}},this)},populate:function(){this.$el.addClass("gateway-properties"),e.prototype.populate.call(this),this._dependencies&&"resolved"==this._dependencies.state()&&this.position()},renderDpi:function(){var e=this.model.get("dpistats_table");e&&e.by_cat&&e.by_cat.length&&e.by_app&&e.by_app.length?(this.dpiPropertyView||(this.dpiPropertyView=new n({app:this.app,el:this.$el.find(".statistics-tab-content").get(0)})),this.dpiPropertyView&&this.dpiPropertyView.setData(e)):(this.dpiPropertyView&&this.dpiPropertyView.remove(),this.dpiPropertyView=null,this.$el.find(".tab-content.statistics").html('<div class="statistics-tab-content">'+d.G_PropertiesNoGatewayDpi+"</div>"))},populateStates:function(){this.$el.removeClass("gw-has-wan gw-has-lan gw-has-voice"),r.each(this.model.get("port_table")||[],c.proxy(function(e){var t=this.$diagram.find(".port."+e.name);t.removeClass("shutdown up green orange"),e.enable||t.addClass("shutdown"),e.up&&(this.$el.addClass("gw-has-"+e.name.replace(/[^a-z]/,"")),t.addClass("up"),1e3==e.speed?t.addClass("green"):(100==e.speed||10==e.speed)&&t.addClass("orange"))},this))},networkTable:function(){if(!this.rendered)return!1;if(this.grids.networks)this.grids.networks.collection.set(this.model.networks());else{var e=[{name:"name",label:d.G_Network,editable:!1,cell:"string"},{name:"ip",label:d.G_IP,editable:!1,cell:"string"},{name:"tx_bytes",label:d.G_DevicesTX,editable:!1,cell:o.StringCell.extend({formatter:i.Formatters.Bytes})},{name:"rx_bytes",label:d.G_DevicesRX,editable:!1,cell:o.StringCell.extend({formatter:i.Formatters.Bytes})},{name:"num_sta",label:d.G_PropertiesNumHosts,editable:!1,cell:"integer"}];this.grids.networks=this.grid(e,new s.Collection(this.model.networks()),this.$(".data-table-networks"),this.noNetworkRows)}},portForwardTable:function(){if(!this.rendered)return!1;if(!this.grids.portfwd){var e=[{name:"name",label:d.G_Name,editable:!1,cell:"string"},{name:"src",label:d.G_PortForwardSource,editable:!1,cell:o.StringCell.extend({formatter:{fromRaw:function(e){return e&&"any"!=e?e:"*"},toRaw:function(e){return e}}})},{name:"dst_port",label:d.G_Port,customClass:"detached-only",editable:!1,cell:"string"},{name:"fwd",label:d.G_PortForwardDest,customClass:"detached-only",editable:!1,cell:i.Cells.ComplexCell.extend({formatter:{fromRaw:function(e){return r.filter([e.get("fwd"),e.get("fwd_port")],function(e){return e}).join(":")},toRaw:function(e){return e}}})},{name:"_id",label:d.G_Actions,customClass:"column-actions",editable:!1,sortable:!1,headerCell:i.Headers.noSortHeader,cell:i.Cells.ActionsCell.extend({actions:{edit:{icon:"ubnt-icon-edit",iconOnly:!0,requiresAdminPrivilege:!0,callback:this.portForwardForm},remove:{icon:"ubnt-icon-trash",iconOnly:!0,requiresAdminPrivilege:!0,callback:c.proxy(function(e){(new _).show(d.G_PropertiesPortForwardDeleteConfirm,c.proxy(function(){e.destroy({success:c.proxy(function(e,t){"ok"===t.meta.rc?this.showSavedState():this.showErrorState()},this),error:c.proxy(function(){this.showErrorState()},this)})},this))},this)}}})}];this.grids.portfwd=this.grid(e,this.app.collection("PortForward"),this.$(".data-table-portfwd"),this.noPortFwdRows,{paginateToAddedModel:!0}),this.grids.portfwd&&this.grids.portfwd.setFilter("name")}},portForwardForm:function(e){var a=this.app.collection("PortForward");this.forms.PortForward=new t({app:this.app,container:this.$portFwdForm,collection:a,model:e||new a.model}),this.listenTo(this.forms.PortForward,"remove",c.proxy(function(){this.forms.PortForward=null},this)),this.forms.PortForward.render(),this.position()},dynamicDNSTable:function(){if(!this.rendered)return!1;if(!this.grids.dynamicdns){var e=[{name:"service",label:d.G_PropertiesDDNSService,editable:!1,cell:"string"},{name:"host_name",label:d.G_PropertiesDDNSHostname,editable:!1,cell:"string"},{name:"login",label:d.G_PropertiesDDNSUsername,customClass:"detached-only",editable:!1,cell:"string"},{name:"x_password",label:d.G_PropertiesDDNSPassword,customClass:"detached-only",editable:!1,cell:"string"},{name:"server",label:d.G_PropertiesDDNSServer,customClass:"detached-only",editable:!1,cell:"string"},{name:"_id",label:d.G_Actions,customClass:"column-actions",
editable:!1,sortable:!1,headerCell:i.Headers.noSortHeader,cell:i.Cells.ActionsCell.extend({actions:{edit:{icon:"ubnt-icon-edit",iconOnly:!0,requiresAdminPrivilege:!0,callback:this.dynamicDNSForm},remove:{icon:"ubnt-icon-trash",iconOnly:!0,requiresAdminPrivilege:!0,callback:c.proxy(function(e){(new _).show(d.G_PropertiesDDNSDynamicDNSDeleteConfirm,c.proxy(function(){e.destroy({success:c.proxy(function(e,t){"ok"===t.meta.rc?this.showSavedState():this.showErrorState()},this),error:c.proxy(function(){this.showErrorState()},this)})},this))},this)}}})}];this.grids.dynamicdns=this.grid(e,this.app.collection("DynamicDNS"),this.$(".data-table-dynamicdns"),this.noDynamicDNSRows,{paginateToAddedModel:!0}),this.grids.dynamicdns&&this.grids.dynamicdns.setFilter("service")}},dynamicDNSForm:function(e){var t=this.app.collection("DynamicDNS");this.forms.DynamicDNS=new a({app:this.app,container:this.$dynamicDNSForm,collection:t,model:e||new t.model}),this.listenTo(this.forms.DynamicDNS,"remove",c.proxy(function(){this.forms.DynamicDNS=null},this)),this.forms.DynamicDNS.render(),this.position()},statsDynamicDNSForm:function(e,t){this.$tabs.tabs("option","active",2),this.$gatewayConfig.find(".accordion").accordion("option","active",3),t&&this.dynamicDNSForm(e)},statsPortForwardForm:function(e,t){this.$tabs.tabs("option","active",2),this.$gatewayConfig.find(".accordion").accordion("option","active",2),t&&this.portForwardForm(e)},remove:function(){this.dpiPropertyView&&this.dpiPropertyView.remove(),this.listenTo(this.app.collection("PortForward"),"add remove",this.portForwardTable),this.$portFwdCreate.off("click"),this.$connectionType.off("change"),this.$wanForm.off("submit"),this.$diagramWan.off("click"),this.$diagramLan.off("click"),this.$diagramVoice.off("click"),this.stopListening(this.forms.PortForward,"remove"),this.forms.PortForward&&this.forms.PortForward.remove(),this.unstickit(this.model),this.$advAdoptForm.off("submit",this.onAdvAdoptFormSubmit),this.rendered=!1,e.prototype.remove.apply(this,arguments)}})}),define("text!includes/switches/switchNetworksVlanFormTemplate.html",[],function(){return'<form>\n    <fieldset class="fieldset">\n        <div class="row">\n            <label class="label inline"><%- msg.G_Name %></label>\n            <input type="text" class="input inline" name="name" value="" />\n        </div>\n        <div class="row forward-native forward-customize">\n            <label class="label inline"><%- msg.G_NativeNetwork %></label>\n            <select id="network" name="network" class="input inline"></select>\n        </div>\n        <div class="row forward-customize">\n            <label class="label inline"><%- msg.G_PropertiesTaggedNetworks %></label>\n\n            <div class="networks checkbox-group left"></div>\n        </div>\n    </fieldset>\n\n    <button class="button is-admin" type="submit"><%- msg.G_Apply %></button>\n    <button class="button" name="cancel" value="Cancel" type="button"><%- msg.G_Cancel %></button>\n</form>\n'}),define("unifi/view/switches/NetworksVlanFormView",["unifi/view/app/FormView","jquery","underscore","msg/Msg","text!includes/switches/switchNetworksVlanFormTemplate.html","ubnt/ubnt.radiotoggle"],function(e,t,a,n,i){"use strict";return e.extend({_templateId:a.template(i,{msg:n}),_prevalidate:{name:{input:"text"}},events:{"change #network":"onNetworkChange","click button[name=cancel]":"remove",'click input[name="networks"]':"onTaggedNetworkChange"},onNetworkChange:function(e){var t=this.$el.find("input[type=checkbox][name=networks]");t.prop("disabled",!1),t.filter(":checkbox[value="+e.target.value+"]").prop("checked",!1).prop("disabled",!0)},onTaggedNetworkChange:function(e){var a=t(e.target),n=this.$el.find("select[name=network]"),i=n.find('option[value="'+a.val()+'"]');a.is(":checked")&&(i.prop("selected",!1),n.val()==a.val()&&(i=n.find("option:first"),i.prop("selected",!0))),n.selectmenu("refresh")},render:function(){var t=this.rendered;e.prototype.render.call(this);var a=this.$container.parents(".networks-vlan-config");a.addClass("show-form"),t||(this.listenTo(this.app.collection("Networks"),"add remove",this.renderNetworks),this.on("remove",function(){a.removeClass("show-form")}),this.renderNetworks(),this.app.isReadOnly||this.prevalidator())},renderNetworks:function(){var e=this.app.collection("Networks").filterByPurpose(["corporate","guest","voip","vlan-only"]),i=this.$("select[name=network]"),o=this.$(".networks");o.empty(),i.empty(),i.append(t('<option value=""></option>').text(n.G_None)),a.each(e,function(e){o.append(t('<label><input type="checkbox" name="networks" value="'+e.id+'" /> '+e.get("name")+"</label>")),i.append(t('<option value="'+e.id+'"></option>').text(e.get("name")))}),i.selectmenu("refresh"),this.populate()},populate:function(){if(this.model){this.$el.find("input[name=name]").val(this.model.get("name")),this.$el.find("select[name=network]").val(this.model.get("native_networkconf_id")).trigger("change");var e=this.$el.find("input[type=checkbox][name=networks]");e.prop("checked",!1),a.each(this.model.get("tagged_networkconf_ids")||[],function(t){e.filter(":checkbox[value="+t+"]").prop("checked",!0)})}},gather:function(){var e={name:this.$el.find("input[name=name]").val()};return e.native_networkconf_id=this.$el.find("select[name=network] option:selected").val(),e.tagged_networkconf_ids=this.$el.find("input[name=networks]:checked").map(function(){return t(this).val()}).get(),e.native_networkconf_id&&a.isEmpty(e.tagged_networkconf_ids)?e.forward="native":e.forward="customize",e},success:function(){this.remove()},error:function(e,t){this.options.app.views.app.flash("error","Error",n.apiError(t))},remove:function(){this.stopListening(this.app.collection("Networks"),"add remove"),this.rendered=!1,e.prototype.remove.apply(this,arguments)}})}),define("text!includes/switches/switchPortFormTemplate.html",[],function(){return'<form class="tab-form">\n    <fieldset>\n        <div class="row">\n            <span class="label inline"><%- msg.G_Port %></span>\n            <span class="label inline label-fit label-light portidx"></span>\n        </div>\n        <div class="name">\n            <div class="row">\n                <label class="label inline"><%- msg.G_Name %></label>\n                <input type="text" class="input inline" name="name" value="" />\n            </div>\n        </div>\n        <div class="poe">\n            <div class="row op_mode-toggled op_mode-switch">\n                <label class="label inline"><%- msg.G_PropertiesPoE %></label>\n\n                <div class="port-group left">\n                    <label><input type="radio" name="poe_mode" value="off" /> <%- msg.G_SettingsOff %></label>\n                    <label><input type="radio" name="poe_mode" value="pasv24" /> <%- msg.G_PropertiesPoEModePassive %></label>\n                    <label><input type="radio" name="poe_mode" value="auto" /> <%- msg.G_PropertiesPoEModePoEPlus %></label>\n                </div>\n            </div>\n        </div>\n        <div class="row op_mode-toggled op_mode-switch op_mode-aggregate">\n            <label class="label inline"><%- msg.G_PropertiesNetworksVLANs %></label>\n            <select name="portconf_id" class="input inline"></select>\n        </div>\n    </fieldset>\n\n    <fieldset class="advanced">\n        <legend class="toggle"><%- msg.G_SettingsAdvancedOpts %> <span class="ubnt-icon-arrow-down secondary-color"></span></legend>\n\n        <div class="advanced">\n            <div class="row">\n                <label class="label inline"><%- msg.G_PropertiesOperation %></label>\n                <div class="port-group left">\n                    <label><input type="radio" name="op_mode" value="switch" /><%- msg.G_PropertiesSwitching %></label>\n                    <label><input type="radio" name="op_mode" value="mirror" /><%- msg.G_PropertiesMirroring %></label>\n                    <label><input type="radio" name="op_mode" value="aggregate" /><%- msg.G_PropertiesAggregate %></label>\n                </div>\n            </div>\n            <div class="row op_mode-toggled op_mode-mirror">\n                <label class="label inline"><%- msg.G_PropertiesMirroringPort %></label>\n                <input type="text" class="input inline" name="mirror_port_idx" value="" />\n            </div>\n            <div class="row op_mode-toggled op_mode-aggregate">\n                <label class="label inline"><%- msg.G_PropertiesAggregatePorts %></label>\n                <input type="text" class="input inline small" name="aggregate_start" value="" disabled="disabled" />\n                <span class="label inline label-fit label-light"><%- msg.G_To %></span>\n                <input type="text" class="input inline small" name="aggregate_num_ports" value="" />\n                <span class="aggregate-limits tip inline"></span>\n            </div>\n            <div class="row autoneg">\n                <label class="label inline"><%- msg.G_PropertiesAutoneg %></label>\n                <div class="port-group left">\n                    <label><input type="radio" name="autoneg" value="auto" /><%- msg.G_PropertiesAuto %></label>\n                    <label><input type="radio" name="autoneg" value="manual" /><%- msg.G_PropertiesManual %></label>\n                </div>\n            </div>\n            <div class="row autoneg-disable duplex autoneg">\n                <label class="label inline"><%- msg.G_PropertiesFullDuplex %></label>\n                <div class="port-group left">\n                    <label><input type="checkbox" name="fullduplex"><%- msg.G_PropertiesEnable %></label>\n                </div>\n            </div>\n            <div class="row autoneg-disable autoneg">\n                <label class="label inline"><%- msg.G_PropertiesSpeed %></label>\n                <div class="port-group left">\n                    <select id="speed" class="input inline" name="speed">\n                        <option value="10000"><%- msg.G_Properties10Gbps %></option>\n                        <option value="1000"><%- msg.G_Properties1000Mbps %></option>\n                        <option value="100"><%- msg.G_Properties100Mbps %></option>\n                        <option value="10"><%- msg.G_Properties10Mbps %></option>\n                    </select>\n                </div>\n            </div>\n            <div class="row isolation">\n                <label class="label inline"><%- msg.G_PropertiesIsolation %></label>\n                <div class="port-group">\n                    <label><input type="checkbox" name="isolation"><%- msg.G_PropertiesEnableIsolation %></label>\n                </div>\n            </div>\n            <div class="row stormctrl">\n                <label class="label inline"><%- msg.G_PropertiesStormCtrl %></label>\n                <div class="port-group">\n                    <label class="fix-width"><input type="checkbox" name="stormctrl_ucast_enabled"><%- msg.G_PropertiesUcast %></label>\n                    <input type="number" min=0 max=14880000 name="stormctrl_ucast_rate" value="">\n                    <span><%- msg.G_PropertiesStormCtrlRate %></span>\n                </div>\n            </div>\n            <div class="row stormctrl">\n                <label class="label inline">&nbsp</label>\n                <div class="port-group">\n                    <label class="fix-width"><input type="checkbox" name="stormctrl_mcast_enabled"><%- msg.G_PropertiesMcast %></label>\n                    <input type="number" min=0 max=14880000 name="stormctrl_mcast_rate" value="">\n                    <span><%- msg.G_PropertiesStormCtrlRate %></span>\n                </div>\n            </div>\n            <div class="row stormctrl">\n                <label class="label inline">&nbsp</label>\n                <div class="port-group">\n                    <label class="fix-width"><input type="checkbox" name="stormctrl_bcast_enabled"><%- msg.G_PropertiesBcast %></label>\n                    <input type="number" min=0 max=14880000 name="stormctrl_bcast_rate" value="">\n                    <span><%- msg.G_PropertiesStormCtrlRate %></span>\n                </div>\n            </div>\n        </div>\n    </fieldset>\n    <div class="form-controls">\n        <button class="button is-admin" type="submit"><%- msg.G_Apply %></button>\n        <button class="button" name="cancel" value="Cancel" type="button"><%- msg.G_Cancel %></button>\n    </div>\n</form>\n'}),define("unifi/view/switches/PortFormView",["unifi/view/app/FormView","ubnt/view/dialogs/ConfirmDialogView","jquery","underscore","msg/Msg","text!includes/switches/switchPortFormTemplate.html"],function(e,t,a,n,i,o){"use strict";return e.extend({_templateId:n.template(o,{msg:i}),_prevalidate:{aggregate_num_ports:{input:"text",complex:!0,extra:{portidx:"tbd"}},mirror_port_idx:{input:"text",complex:!0,extra:{portidx:"tbd"}}},events:{"click button[name=cancel]":"remove"},render:function(){var t=this.rendered;this.formResult="",this.selection={},this.selection.count=this.options.overrides.length,this.selection.firstIdx=this.options.overrides[0].get("port_idx"),this.selection.lastIdx=this.options.overrides[this.selection.count-1].get("port_idx");var i=[],o=null,r=!1;n.each(this.options.overrides,function(e){var t=e.get("port_idx");r||(r=e.get("port_poe")),"aggregate"==e.get("op_mode")?(i.push(t+"-"+(t+e.get("aggregate_num_ports")-1)),o=null):t===this.selection.firstIdx?i.push(t):t!==o+1?(i[i.length-1]!==o&&(i[i.length-1]+="-"+o),i.push(t)):t===this.selection.lastIdx&&(t===o+1?i[i.length-1]+="-"+t:i.push(t)),o=t},this),this.selection.indexesLabel=i.join(", "),this.selection.supportsPoe=r,e.prototype.render.call(this);var s=this.$container.parents(".port-list-config");s.addClass("show-form");this.$el;if(!t){this.on("remove",function(){s.removeClass("show-form")}),this.$el.find("input[name=op_mode]").radiotoggle({container:this.$el});var c=1===this.selection.count?this.options.overrides[0]:null;c?c.get("media")?(a(".autoneg").show(),this.$el.find("input[name=autoneg]").change(function(){"auto"===a(this).val()?a(".autoneg-disable").hide():(a(".autoneg-disable").show(),("SFP"===c.get("media")||"SFP+"===c.get("media"))&&a(".duplex").hide())})):a(".autoneg").hide():(a(".autoneg").hide(),a(".isolation").hide()),this.$el.find("input[name=op_mode]").change(function(){"switch"===a(this).val()?(a(".stormctrl").show(),a(".isolation").show()):(a(".stormctrl").hide(),a(".isolation").hide())}),this.$el.find(".stormctrl").find(":checkbox").each(function(){a(this).change(function(){var e=a(this);e.is(":checked")?e.parent().parent().find("input").not(e).prop("disabled",!1):e.parent().parent().find("input").not(e).prop("disabled",!0)})}),this.renderPortConf(),this.app.isReadOnly||this.prevalidator()}},renderPortConf:function(){var e=this.$el.find("select[name=portconf_id]");e.empty(),this.selection.count>1&&e.append(a('<option value=""></option>').text("(Keep existing)")),this.app.collection("PortConf").each(function(t){e.append(a('<option value="'+t.id+'"></option>').text(t.get("name")))}),this.portidx=parseInt(this.selection.firstIdx,10),this.$el.find(".portidx").text(this.selection.indexesLabel),this.$el.find("div.poe").toggle(this.selection.supportsPoe),e.selectmenu("refresh"),this.populate()},populate:function(){var e=1===this.selection.count?this.options.overrides[0]:null,t=e?e.get("poe_mode")||"auto":"auto",o=e?e.get("op_mode")||"switch":"switch",r={};if(n.each(this.model.get("port_overrides"),function(e){r[e.port_idx]=!0},this),e){this.$el.find("input[name=name]").val(e.get("name")),this.$el.find("input[name=poe_mode][value="+t+"]").prop("checked",!0).trigger("change"),this.$el.find("select[name=portconf_id]").val(e.get("portconf_id")||"").trigger("change"),this.$el.find("input[name=op_mode][value="+o+"]").prop("checked",!0).trigger("change"),this.$el.find("input[name=mirror_port_idx]").val(e.get("mirror_port_idx")),this.$el.find("input[name=isolation]").prop("checked",e.get("isolation")).trigger("change"),this.$el.find("input[name=aggregate_num_ports]").val(e.get("aggregate_num_ports")?parseInt(e.get("port_idx"),10)+parseInt(e.get("aggregate_num_ports"),10)-1:""),this.$el.find("input[name=stormctrl_ucast_enabled]").prop("checked",e.get("stormctrl_ucast_enabled")).trigger("change"),this.$el.find("input[name=stormctrl_ucast_rate]").val(e.get("stormctrl_ucast_rate")?parseInt(e.get("stormctrl_ucast_rate"),10):0),this.$el.find("input[name=stormctrl_mcast_enabled]").prop("checked",e.get("stormctrl_mcast_enabled")).trigger("change"),this.$el.find("input[name=stormctrl_mcast_rate]").val(e.get("stormctrl_mcast_rate")?parseInt(e.get("stormctrl_mcast_rate"),10):0),this.$el.find("input[name=stormctrl_bcast_enabled]").prop("checked",e.get("stormctrl_bcast_enabled")).trigger("change"),this.$el.find("input[name=stormctrl_bcast_rate]").val(e.get("stormctrl_bcast_rate")?parseInt(e.get("stormctrl_bcast_rate"),10):0);var s,c,d;r[e.get("port_idx")]?(s=e.get("autoneg")?"auto":"manual",c=e.get("full_duplex"),d=e.get("speed")):(s="auto",c=!0,d="1000");e.get("media");"SFP"!==e.get("media")&&"SFP+"!==e.get("media")?this.$el.find('select[name="speed"] option[value=10000]').remove():"SFP+"===e.get("media")?(this.$el.find('select[name="speed"] option[value=100]').remove(),this.$el.find('select[name="speed"] option[value=10]').remove()):"SFP"===e.get("media")&&(this.$el.find('select[name="speed"] option[value=10000]').remove(),this.$el.find('select[name="speed"] option[value=100]').remove(),this.$el.find('select[name="speed"] option[value=10]').remove()),this.$el.find("input[name=autoneg][value="+s+"]").prop("checked",!0).trigger("change"),this.$el.find("input[name=fullduplex]").prop("checked",c).trigger("change"),this.$el.find("select[name=speed]").val(d).trigger("change"),"switch"!=o&&this.$el.find("legend.toggle").trigger("click",!1)}else this.$el.find("input[name=name]").val("(Keep existing)"),this.$el.find("input[name=poe_mode][value=auto]").prop("checked",!0).trigger("change"),this.$el.find("input[name=op_mode][value=switch]").prop("checked",!0).trigger("change");if(1===this.selection.count){this.$el.find("fieldset.advanced input").prop("disabled",!1),this.$el.find(".stormctrl").find(":checkbox").each(function(){a(this).trigger("change")}),this.$el.find("input[name=aggregate_start]").val(e.get("port_idx")).disable();for(var l=this.selection.firstIdx+1,m=this.selection.firstIdx+3,g=this.model.numPorts(),u=this.$el.find("input[name=aggregate_num_ports]"),h=this.model.get("port_table"),p=(h.length,this.selection.firstIdx);m>p;p++)if(m>p){var y=h[p];if(y&&"switch"!==y.op_mode){m=p;break}}m>g&&(m=g),this.$el.find('input[name=op_mode][value="aggregate"]').parents("label:first").css("display",l>g||l>m?"none":"inline-block"),m-l>0?(this.$el.find(".aggregate-limits").text("("+i.localize(i.G_BetweenXandY,l,m)+")"),u.enable()):(u.val(l),u.disable()),this._prevalidate.aggregate_num_ports.extra.portidx=this.selection.firstIdx,this._prevalidate.mirror_port_idx.extra.portidx=this.selection.firstIdx}else this.$el.find("fieldset.advanced").prop("disabled",!0)},gather:function(){var e=n.clone(this.model.get("port_overrides")),t=[],i=this.$el.find("input[name=name]").val(),o=this.$el.find("input[name=poe_mode]:checked").val(),r=this.$el.find("select[name=portconf_id]").val(),s=this.$el.find("input[name=op_mode]:checked").val();n.each(this.options.overrides,function(e){var n={port_idx:e.get("port_idx"),name:"(Keep existing)"===i?e.get("name"):i,portconf_id:r||e.get("portconf_id"),op_mode:s};if(this.selection.supportsPoe&&"SFP"!==e.get("media")&&"SFP+"!==e.get("media")&&(n.poe_mode=o),!n.name)switch(n.name="Port "+e.get("port_idx"),this.model.get("model")){case"US24":case"US24P250":case"US24P500":n.port_idx>24&&(n.name="SFP "+(n.port_idx-24));break;case"US48":case"US48P500":case"US48P750":n.port_idx>50?n.name="SFP "+(n.port_idx-50):n.port_idx>48&&(n.name="SFP+ "+(n.port_idx-48))}"mirror"==n.op_mode?n.mirror_port_idx=this.$el.find("input[name=mirror_port_idx]").val():"aggregate"==n.op_mode&&(n.aggregate_num_ports=this.$el.find("input[name=aggregate_num_ports]").val()-this.selection.firstIdx+1),a(".autoneg").is(":visible")&&(n.autoneg="auto"===this.$el.find("input[name=autoneg]:checked").val()?!0:!1,n.autoneg||(n.full_duplex=this.$el.find("input[name=fullduplex]:checked").is(":checked"),n.speed=this.$el.find("select[name=speed]").val())),n.isolation=this.$el.find("input[name=isolation]:checked").is(":checked"),n.stormctrl_ucast_enabled=this.$el.find("input[name=stormctrl_ucast_enabled]:checked").is(":checked"),n.stormctrl_ucast_rate=this.$el.find("input[name=stormctrl_ucast_rate]").val(),n.stormctrl_mcast_enabled=this.$el.find("input[name=stormctrl_mcast_enabled]:checked").is(":checked"),n.stormctrl_mcast_rate=this.$el.find("input[name=stormctrl_mcast_rate]").val(),n.stormctrl_bcast_enabled=this.$el.find("input[name=stormctrl_bcast_enabled]:checked").is(":checked"),n.stormctrl_bcast_rate=this.$el.find("input[name=stormctrl_bcast_rate]").val(),t.push(n)},this);var c=t.map(function(e){return e.port_idx});return e=e?n.reject(e,function(e){return c.indexOf(e.port_idx)>-1}):[],e=e.concat(t),{port_overrides:e}},save:function(e){e&&e.preventDefault();var n=a.proxy(function(){this.clear(),this.$submit.trigger("saving");var e=this._save(this.model,null,{wait:!0,data:this.gather(),extra:{portidx:this.selection.firstIdx}});e?this.formResult="success":this.$submit.trigger("error",!0)},this),o=this.model.get("inform_ip"),r=this.app.collection("Clients").getUserFromIp(o);"undefined"!=typeof r&&this.model.get("mac")===r.get("sw_mac")&&this.portidx==r.get("sw_port")?(new t).show(i.localize(i.N_ConfirmPortConfigApply,this.portidx,o),n):n()},success:function(){this.model.fetch(),this.remove()},error:function(e,t){this.options.app.views.app.flash("error","Error",i.apiError(t,!0))},remove:function(){this.rendered=!1,this.$el.find("input[name=autoneg]").off(),e.prototype.remove.apply(this,arguments)}})}),define("unifi/model/PortConf",["unifi/model/Model","underscore","backbone","msg/Msg"],function(e,t,a,n){"use strict";return e.extend({validate:function(e,a){var i={},o=a?a.partial:null;return o&&"name"!=o||(e.name?this.validator.name(e.name)||(i.name=n.localize(n.E_InvalidName,n.G_Name)):o||(i.name=n.localize(n.E_CannotBeEmpty,n.G_Name))),t.size(i)?i:void 0},sync:function(e,t,n){switch(n=n||{},e){case"create":n.contentType="application/json; charset=utf-8",n.url="/api/s/"+SITE.name+"/add/portconf",n.type="POST";break;case"update":n.contentType="application/json; charset=utf-8",n.url="/api/s/"+SITE.name+"/upd/portconf/"+t.id,n.type="POST",n.data=JSON.stringify(t.toJSON({exclude:["_id","site_id"]}));break;case"delete":n.contentType="application/json; charset=utf-8",n.url="/api/s/"+SITE.name+"/del/portconf/"+t.id,n.type="POST"}return a.sync.call(this,e,t,n)}})}),define("unifi/collection/PortConf",["unifi/collection/Collection","underscore","unifi/model/PortConf"],function(e,t,a){"use strict";return e.extend({model:a,bySite:!0,url:function(){return"/api/s/"+SITE.name+"/list/portconf"}})}),define("text!includes/switches/switchPropertiesTemplate.html",[],function(){return'<div class="accordion-header">\n    <div class="accordion-title">\n        <span class="device-icons access-point half"></span>\n        <span class="title-text"><%- name() %></span>\n        <div class="ubnt-icon-arrow-down sidebar-icons minmax minimize"></div>\n    </div>\n    <div class="right">\n        <div class="ubnt-icon-new-window sidebar-icons detach" title="Detach"></div>\n        <div class="ubnt-icon-close sidebar-icons remove" title="Close"></div>\n    </div>\n</div>\n<div class="property-content">\n    <div class="loading"><span><%- msg.N_Loading %></span></div>\n\n    <div class="device-status-wrapper">\n        <div class="device-status bind-status"></div>\n    </div>\n\n    <%= diagram %>\n\n    <div class="status-alert status-success"><span class="ubnt-icon-check checkmark"></span><%- msg.G_Saved %></div>\n    <div class="status-alert status-error"><span class="ubnt-icon-warning alert"></span><%- msg.E_Error %></div>\n    <div class="tabs">\n        <ul>\n            <li class="tab-nav-list-item">\n                <a class="tab-button" href="#switchDetails<%- _id %>"><%- msg.G_PropertiesDetails %></a>\n            </li>\n            <li class="tab-nav-list-item ap-configs">\n                <a class="tab-button switchPorts-anchor" href="#switchPorts<%- _id %>"><%- msg.G_Ports %></a>\n            </li>\n            <li class="tab-nav-list-item ap-configs">\n                <a class="tab-button" href="#switchConfig<%- _id %>"><%- msg.G_PropertiesConfiguration %></a>\n            </li>\n        </ul>\n        <div class="properties-container overflow">\n            <div id="switchDetails<%- _id %>" class="tab-content">\n                <div class="accordion">\n                    <div class="accordion-header">\n                        <div class="accordion-title"><%- msg.G_DevicesOverview %></div>\n                    </div>\n                    <div class="basic-overview">\n                        <table>\n                            <tr class="table-row">\n                                <td class="column-name"><%- msg.G_PropertiesMACAddress %></td>\n                                <td class="column-value"><%- get(\'mac\') %></td>\n                            </tr>\n                            <tr class="table-row">\n                                <td class="column-name"><%- msg.G_DevicesModel %></td>\n                                <td class="column-value"><%- apModel() %></td>\n                            </tr>\n                            <tr class="table-row">\n                                <td class="column-name"><%- msg.G_Version %></td>\n                                <td class="column-value bind-version"></td>\n                            </tr>\n                        </table>\n                        <hr />\n                        <table>\n                            <tr class="table-row ip-address">\n                                <td class="column-name"><%- msg.G_IPAddress %></td>\n                                <td class="column-value bind-ip"></td>\n                            </tr>\n                            <tr class="table-row power-consumption">\n                                <td class="column-name"><%- msg.G_PowerConsumption %></td>\n                                <td class="column-value bind-power-consumption"></td>\n                            </tr>\n                            <tr class="table-row temperature">\n                                <td class="column-name"><%- msg.G_Temperature %></td>\n                                <td class="column-value bind-temperature"></td>\n                            </tr>\n                            <tr class="table-row fan-level sw-fan-details">\n                                <td class="column-name"><%- msg.G_FanLevel %></td>\n                                <td class="column-value bind-fan-level"></td>\n                            </tr>\n                            <tr class="table-row uptime">\n                                <td class="column-name"><%- msg.G_Uptime %></td>\n                                <td class="column-value bind-uptime"></td>\n                            </tr>\n                            <tr class="table-row last-uplink">\n                                <td class="column-name"><%- msg.G_LastUplink %></td>\n                                <td class="column-value">\n                                    <a class="bind-lastuplink button-uplink-device" href="#"></a>\n                                </td>\n                            </tr>\n                            <tr class="table-row last-seen">\n                                <td class="column-name"><%- msg.G_LastSeen %></td>\n                                <td class="column-value bind-lastseen"></td>\n                            </tr>\n                        </table>\n                    </div>\n\n                    <div class="accordion-header sw-uplink-details">\n                        <div class="accordion-title"><%- msg.G_PropertiesUplink %></div>\n                    </div>\n                    <div class="uplinks bind-uplink sw-uplink-details">\n                        <table class="side-by-side">\n                            <tr class="table-row">\n                                <td class="column-name"><%- msg.G_Port %></td>\n                                <td class="column-value bind-uplink-port"></td>\n                            </tr>\n                            <tr class="table-row">\n                                <td class="column-name"><%- msg.G_PropertiesUplink %></td>\n                                <td class="column-value column-callback bind-uplink-device button-uplink-device"></td>\n                            </tr>\n                            <tr class="table-row">\n                                <td class="column-name"><%- msg.G_Speed %></td>\n                                <td class="column-value bind-uplink-speed"></td>\n                            </tr>\n                            <tr class="table-row">\n                                <td class="column-name"><%- msg.G_PropertiesDuplex %></td>\n                                <td class="column-value bind-uplink-duplex"></td>\n                            </tr>\n                        </table>\n\n                        <table class="side-by-side">\n                            <tr class="table-row">\n                                <td class="column-name"><%- msg.G_PropertiesDownPktsBytes %></td>\n                                <td class="column-value bind-uplink-down-packets"></td>\n                            </tr>\n                            <tr class="table-row">\n                                <td class="column-name"><%- msg.G_PropertiesUpPktsBytes %></td>\n                                <td class="column-value bind-uplink-up-packets"></td>\n                            </tr>\n                            <tr class="table-row">\n                                <td class="column-name"><%- msg.G_Activity %></td>\n                                <td class="column-value bind-uplink-activity"></td>\n                            </tr>\n                        </table>\n                    </div>\n\n                    <div class="accordion-header sw-adv-adopt">\n                        <div class="accordion-title"><%- msg.G_PropertiesAdvancedOpts %></div>\n                    </div>\n                    <div class="sw-adv-adopt">\n                        <form action="" class="advAdoptForm sw-adv-adopt">\n                            <div class="row">\n                                <label class="label inline"><%- msg.G_IP %></label>\n                                <input class="input inline medium bind-adopt-ip" type="text" value="" name="ip" />\n                                <span class="colon">:</span>\n                                <input class="input inline small" type="text" value="22" name="port" />\n                            </div>\n                            <div class="row">\n                                <label class="label inline"><%- msg.G_UN %></label>\n                                <input class="input inline" type="text" value="" name="username" />\n                            </div>\n                            <div class="row">\n                                <label class="label inline"><%- msg.G_PW %></label>\n                                <input class="input inline" type="password" value="" name="password" />\n                            </div>\n                            <div class="row">\n                                <label class="label inline"><%- msg.G_PropertiesInformURL %></label>\n                                <input class="input inline bind-adopt-url" type="text" value="" name="url" />\n                            </div>\n                            <button class="button is-admin" type="submit"><%- msg.G_Adopt %></button>\n                        </form>\n                    </div>\n\n                    <div class="accordion-header sw-downlink-details">\n                        <div class="accordion-title"><%- msg.G_PropertiesDownlinks %></div>\n                    </div>\n                    <div class="downlinks sw-downlink-details minigrid">\n                        <div class="data-table data-table-downlinks data-table-fit bind-downlinks"><%- msg.G_PropertiesNoDownlinksConnected %></div>\n                    </div>\n                </div>\n            </div>\n            <div id="switchPorts<%- _id %>" class="tab-content minigrid port-list-config ap-configs">\n                <div class="data-table data-table-ports data-table-fit bind-ports port-list"><%- msg.G_PropertiesNoPorts %></div>\n                <div class="port-form"></div>\n            </div>\n            <div id="switchConfig<%- _id %>" class="tab-content ap-configs">\n                <div class="accordion">\n                    <div class="accordion-header ap-configs">\n                        <div class="accordion-title"><%- msg.G_Config %></div>\n                    </div>\n                    <div class="ap-configs">\n                        <form action="" class="aliasForm">\n                            <div class="row">\n                                <label for="aliasName<%- _id %>" class="label"><%- msg.G_PropertiesAlias %></label>\n                                <input name="name" id="aliasName<%- _id %>" type="text" class="input" value="<%- get(\'name\') %>" pattern=".{1,128}" title="<%- msg.E_AliasName %>" />\n                            </div>\n                            <button class="button is-admin" type="submit"><%- msg.G_Apply %></button>\n                        </form>\n                    </div>\n\n                    <div class="accordion-header" class="networks-vlan-config">\n                        <div class="accordion-title"><%- msg.G_PropertiesNetworksVLANs %></div>\n                    </div>\n                    <div class="networks-vlan-config">\n                        <button class="button networks-vlan-create is-admin" name="create">\n                            <span class="ui-button-icon-primary ubnt-icon-plus"></span>\n                            <span class="nav-text"><%- msg.G_Create %></span>\n                        </button>\n\n                        <div class="networks-vlan-list">\n                            <div class="data-table data-table-networks-vlan data-table-fit"><%- msg.G_PropertiesNoNetworksVLANsConfigured %></div>\n                        </div>\n\n                        <div class="networks-vlan-form"></div>\n                    </div>\n\n                    <div class="accordion-header">\n                        <div class="accordion-title"><%- msg.G_Services %></div>\n                    </div>\n                    <div>\n                        <form action="" class="servicesForm">\n                            <div class="clearfix">\n                                <div class="side-by-side">\n                                    <div class="row">\n                                        <label class="label inline"><%- msg.G_PropertiesManagementVLAN %></label>\n                                        <select name="mgmt_network" id="mgmt_network<%- _id %>">\n                                        </select>\n                                    </div>\n                                </div>\n                            </div>\n\n                            <div class="row">\n                                <label class="wrapper"><input type="checkbox" name="jumboframe_enabled" value="1" /><%- msg.G_PropertiesEnableJumboFrame %></label>\n                            </div>\n                            <div class="row">\n                                <label class="wrapper"><input type="checkbox" name="flowctrl_enabled" value="1" /><%- msg.G_PropertiesEnableFlowControl %></label>\n                            </div>\n\n                            <button class="button is-admin" type="submit"><%- msg.G_Apply %></button>\n                        </form>\n                    </div>\n\n                    <div class="accordion-header">\n                        <div class="accordion-title"><%- msg.G_Network %></div>\n                    </div>\n                    <div>\n                        <form action="" class="networkForm bind-network">\n                            <div class="clearfix">\n                                <div class="side-by-side">\n                                    <div class="row">\n                                        <label for="configure-ip<%- _id %>" class="label inline"><%- msg.G_PropertiesConfigIP %></label>\n                                        <select name="type" class="configure-ip" id="configure-ip<%- _id %>">\n                                            <option value="dhcp"><%- msg.G_PropertiesUsingDHCP %></option>\n                                            <option value="static"><%- msg.G_PropertiesStaticIP %></option>\n                                        </select>\n                                    </div>\n                                </div>\n                            </div>\n\n                            <div class="clearfix">\n                                <div class="side-by-side">\n                                    <div class="row connection-toggled connection-static">\n                                        <label class="label inline"><%- msg.G_IPAddress %></label>\n                                        <input type="text" class="input inline" name="ip" size="17" value="" />\n                                    </div>\n                                    <div class="row connection-toggled connection-static">\n                                        <label class="label inline"><%- msg.G_PropertiesSubnetMask %></label>\n                                        <input type="text" class="input inline" name="netmask" size="17" value="" />\n                                    </div>\n                                    <div class="row connection-toggled connection-static">\n                                        <label class="label inline"><%- msg.G_PropertiesGateway %></label>\n                                        <input type="text" class="input inline" name="gateway" size="17" value="" />\n                                    </div>\n                                </div>\n\n                                <div class="side-by-side">\n                                    <div class="row connection-toggled connection-static">\n                                        <label class="label inline"><%- msg.G_PropertiesPreferredDNS %></label>\n                                        <input type="text" class="input inline" name="dns1" size="17" value="" />\n                                    </div>\n                                    <div class="row connection-toggled connection-static">\n                                        <label class="label inline"><%- msg.G_PropertiesAlternateDNS %></label>\n                                        <input type="text" class="input inline" name="dns2" size="17" value="" />\n                                    </div>\n                                    <div class="row connection-toggled connection-static">\n                                        <label class="label inline"><%- msg.G_PropertiesDNSSuffix %></label>\n                                        <input type="text" class="input inline" name="dnssuffix" size="17" value="" />\n                                    </div>\n                                </div>\n                            </div>\n                            <button class="button is-admin"><%- msg.G_Apply %></button>\n                        </form>\n                    </div>\n\n                    <div class="accordion-header is-admin">\n                        <div class="accordion-title"><%- msg.G_PropertiesCopySwitchConfig %></div>\n                    </div>\n                    <div class="is-admin">\n                        <div class="row">\n                            <%- msg.G_PropertiesCopySwitchConfigTxt %>\n                        </div>\n                        <div class="left">\n                            <select name="copyConfig" class="copyConfig-dropdown" data-myposition="left bottom" data-atposition="left top"></select>\n                        </div>\n                    </div>\n\n                    <div class="accordion-header is-admin">\n                        <div class="accordion-title"><%- msg.G_PropertiesCustomUpgrade %></div>\n                    </div>\n                    <div class="is-admin">\n                        <div class="row">\n                            <%- msg.G_PropertiesCustomFirmwareTxt %>\n                        </div>\n                        <button class="button custom-upgrade left">\n                            <span class="ui-button-icon-primary ubnt-icon-download"></span>\n                            <span class="nav-text"><%- msg.G_PropertiesCustomUpgrade %></span>\n                        </button>\n                    </div>\n\n                    <div class="accordion-header is-admin">\n                        <div class="accordion-title"><%- msg.G_PropertiesForgetSwitch %></div>\n                    </div>\n                    <div class="is-admin">\n                        <div class="row">\n                            <%- msg.G_PropertiesForgetSwitchTxt %>\n                        </div>\n                        <button class="button forget left">\n                            <span class="ui-button-icon-primary ubnt-icon-forget-this-network"></span>\n                            <span class="nav-text"><%- msg.G_PropertiesForget %></span>\n                        </button>\n                        <div class="left">\n                            <select name="move" class="move-dropdown" data-myposition="left bottom" data-atposition="left top"></select>\n                        </div>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class="dialog-controls is-admin clearfix">\n            <button class="button button-locate left">\n                <span class="ui-button-icon-primary ubnt-icon-location sidebar-icons locate"></span>\n                <span class="nav-text"><%- msg.G_Locate %></span>\n            </button>\n            <button class="button button-restart left">\n                <span class="ui-button-icon-primary ubnt-icon-rotate sidebar-icons restart"></span>\n                <span class="nav-text"><%- msg.G_Restart %></span>\n            </button>\n            <button class="button button-update left">\n                <span class="ui-button-icon-primary ubnt-icon-download sidebar-icons update"></span>\n                <span class="nav-text"><%- msg.G_Upgrade %></span>\n            </button>\n            <button class="button button-adopt left">\n                <span class="ui-button-icon-primary ubnt-icon-plus sidebar-icons adopt"></span>\n                <span class="nav-text"><%- msg.G_Adopt %></span>\n            </button>\n            <button class="button button-edit right disabled">\n                <span class="ui-button-icon-primary ubnt-icon-edit sidebar-icons edit"></span>\n                <span class="nav-text"><%- msg.G_EditSelected %></span>\n            </button>\n        </div>\n    </div>\n</div>\n';
}),define("text!includes/switches/switchDiagramUS8PTemplate.html",[],function(){return'<div class="diagram switch port8 bind-state">\n    <div class="detached">\n        <div class="top">\n            <% for (var i = 1; i <= 8; i++) { %>\n            <div class="port port-<%= i %>" data-port="<%= i %>">\n                <div class="num"><%= i %></div>\n                <div class="status">\n                    <div class="poe"></div>\n                    <div class="mirror"></div>\n                    <div class="block"></div>\n                </div>\n            </div>\n            <% } %>\n\n            <div class="port sfp port-9" data-port="9">\n                <div class="num">SFP1</div>\n                <div class="status">\n                    <div class="poe"></div>\n                    <div class="mirror"></div>\n                    <div class="block"></div>\n                </div>\n            </div>\n            <div class="port sfp port-10" data-port="10">\n                <div class="num">SFP2</div>\n                <div class="status">\n                    <div class="poe"></div>\n                    <div class="mirror"></div>\n                    <div class="block"></div>\n                </div>\n            </div>\n        </div>\n    </div>\n    <div class="attached">\n        <div class="top">\n            <% for (var i = 1; i <= 8; i++) { %>\n            <div class="port port-<%= i %>" data-port="<%= i %>">\n                <div class="status">\n                    <div class="poe"></div>\n                    <div class="mirror"></div>\n                    <div class="block"></div>\n                </div>\n            </div>\n            <% } %>\n\n            <div class="port sfp port-9" data-port="9">\n                <div class="status">\n                    <div class="poe"></div>\n                    <div class="mirror"></div>\n                    <div class="block"></div>\n                </div>\n            </div>\n            <div class="port sfp port-10" data-port="10">\n                <div class="status">\n                    <div class="poe"></div>\n                    <div class="mirror"></div>\n                    <div class="block"></div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n'}),define("text!includes/switches/switchDiagramUS24PTemplate.html",[],function(){return'<div class="diagram switch port24 bind-state">\n    <div class="detached">\n        <div class="top">\n            <% for (var i = 1; i <= 24; i+=2) { %>\n            <div class="port port-<%= i %>" data-port="<%= i %>">\n                <div class="num"><%= i %></div>\n                <div class="status">\n                    <div class="poe"></div>\n                    <div class="mirror"></div>\n                    <div class="block"></div>\n                </div>\n            </div>\n            <% } %>\n\n            <div class="port sfp port-25" data-port="25">\n                <div class="num">SFP1</div>\n                <div class="status">\n                    <div class="poe"></div>\n                    <div class="mirror"></div>\n                    <div class="block"></div>\n                </div>\n            </div>\n        </div>\n\n        <div class="bottom">\n            <% for (var i = 2; i <= 24; i+=2) { %>\n            <div class="port port-<%= i %>" data-port="<%= i %>">\n                <div class="status">\n                    <div class="poe"></div>\n                    <div class="mirror"></div>\n                    <div class="block"></div>\n                </div>\n                <div class="num"><%= i %></div>\n            </div>\n            <% } %>\n\n            <div class="port sfp port-26" data-port="26">\n                <div class="status">\n                    <div class="poe"></div>\n                    <div class="mirror"></div>\n                    <div class="block"></div>\n                </div>\n                <div class="num">SFP2</div>\n            </div>\n        </div>\n    </div>\n    <div class="attached">\n        <div class="top">\n            <% for (var i = 1; i <= 24; i+=2) { %>\n            <div class="port port-<%= i %>" data-port="<%= i %>">\n                <div class="status">\n                    <div class="poe"></div>\n                    <div class="mirror"></div>\n                    <div class="block"></div>\n                </div>\n            </div>\n            <% } %>\n\n            <div class="port sfp port-25" data-port="25">\n                <div class="status">\n                    <div class="poe"></div>\n                    <div class="mirror"></div>\n                    <div class="block"></div>\n                </div>\n            </div>\n        </div>\n\n        <div class="bottom">\n            <% for (var i = 2; i <= 24; i+=2) { %>\n            <div class="port port-<%= i %>" data-port="<%= i %>">\n                <div class="status">\n                    <div class="poe"></div>\n                    <div class="mirror"></div>\n                    <div class="block"></div>\n                </div>\n            </div>\n            <% } %>\n\n            <div class="port sfp port-26" data-port="26">\n                <div class="status">\n                    <div class="poe"></div>\n                    <div class="mirror"></div>\n                    <div class="block"></div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n'}),define("text!includes/switches/switchDiagramUS48PTemplate.html",[],function(){return'<div class="diagram switch port48 bind-state">\n    <div class="detached">\n        <div class="top">\n            <% for (var i = 1; i <= 48; i+=2) { %>\n                <div class="port port-<%= i %>" data-port="<%= i %>">\n                    <div class="num"><%= i %></div>\n                    <div class="status">\n                        <div class="poe"></div>\n                        <div class="mirror"></div>\n                        <div class="block"></div>\n                    </div>\n                </div>\n            <% } %>\n\n            <div class="port sfp port-49" data-port="49">\n                <div class="num">SFP+1</div>\n                <div class="status">\n                    <div class="poe"></div>\n                    <div class="mirror"></div>\n                    <div class="block"></div>\n                </div>\n            </div>\n\n            <div class="port sfp port-51" data-port="51">\n                <div class="num">SFP1</div>\n                <div class="status">\n                    <div class="poe"></div>\n                    <div class="mirror"></div>\n                    <div class="block"></div>\n                </div>\n            </div>\n        </div>\n\n        <div class="bottom">\n            <% for (var i = 2; i <= 48; i+=2) { %>\n                <div class="port port-<%= i %>" data-port="<%= i %>">\n                    <div class="status">\n                        <div class="poe"></div>\n                        <div class="mirror"></div>\n                        <div class="block"></div>\n                    </div>\n                    <div class="num"><%= i %></div>\n                </div>\n            <% } %>\n\n            <div class="port sfp port-50" data-port="50">\n                <div class="status">\n                    <div class="poe"></div>\n                    <div class="mirror"></div>\n                    <div class="block"></div>\n                </div>\n                <div class="num">SFP+2</div>\n            </div>\n            <div class="port sfp port-52" data-port="52">\n                <div class="status">\n                    <div class="poe"></div>\n                    <div class="mirror"></div>\n                    <div class="block"></div>\n                </div>\n                <div class="num">SFP2</div>\n            </div>\n        </div>\n    </div>\n    <div class="attached">\n        <div class="top">\n            <% for (var i = 1; i <= 48; i+=2) { %>\n                <div class="port port-<%= i %>" data-port="<%= i %>">\n                    <div class="status">\n                        <div class="poe"></div>\n                        <div class="mirror"></div>\n                        <div class="block"></div>\n                    </div>\n                </div>\n            <% } %>\n\n            <div class="port sfp port-49" data-port="49">\n                <div class="status">\n                    <div class="poe"></div>\n                    <div class="mirror"></div>\n                    <div class="block"></div>\n                </div>\n            </div>\n\n            <div class="port sfp port-51" data-port="51">\n                <div class="status">\n                    <div class="poe"></div>\n                    <div class="mirror"></div>\n                    <div class="block"></div>\n                </div>\n            </div>\n        </div>\n\n        <div class="bottom">\n            <% for (var i = 2; i <= 48; i+=2) { %>\n                <div class="port port-<%= i %>" data-port="<%= i %>">\n                    <div class="status">\n                        <div class="poe"></div>\n                        <div class="mirror"></div>\n                        <div class="block"></div>\n                    </div>\n                </div>\n            <% } %>\n\n            <div class="port sfp port-50" data-port="50">\n                <div class="status">\n                    <div class="poe"></div>\n                    <div class="mirror"></div>\n                    <div class="block"></div>\n                </div>\n            </div>\n            <div class="port sfp port-52" data-port="52">\n                <div class="status">\n                    <div class="poe"></div>\n                    <div class="mirror"></div>\n                    <div class="block"></div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n'}),define("unifi/view/switches/PropertyView",["unifi/view/devices/PropertyView","unifi/view/switches/NetworksVlanFormView","unifi/view/switches/PortFormView","ubnt/backgrid","libs/backgrid","underscore","backbone","jquery","msg/Msg","unifi/collection/PortConf","unifi/collection/Networks","text!includes/switches/switchPropertiesTemplate.html","text!includes/switches/switchDiagramUS8PTemplate.html","text!includes/switches/switchDiagramUS24PTemplate.html","text!includes/switches/switchDiagramUS48PTemplate.html","ubnt/view/dialogs/AlertDialogView","ubnt/view/dialogs/ConfirmDialogView","stickit"],function(e,t,a,n,i,o,r,s,c,d,l,m,g,u,h,p,y){"use strict";return e.extend({templateId:m,diagramTemplate:null,bindings:function(){return o.extend({},e.prototype.bindings.call(this),{".bind-uplink":{observe:"uplink",onGet:function(e){if(e){var t=this.parent.options.app.collection("Devices").getDeviceFromMac(e.uplink_mac);t&&this.$bindUplinkDevice.text(t.name()).data("mac",t.get("mac")||""),this.$bindUplinkPort.text(e.port_idx),this.$bindUplinkSpeed.text(this.model.uplinkSpeed()),this.$bindUplinkDuplex.text(this.model.uplinkDuplex()),this.$bindUplinkDownPackets.text(this.model.uplinkDownPackets()),this.$bindUplinkUpPackets.text(this.model.uplinkUpPackets()),this.$bindUplinkActivity.text(this.model.uplinkActivity())}}},".bind-lastseen":{observe:"last_seen",onGet:function(){this.$bindLastseen.text(this.model.lastSeen())}},".bind-lastuplink":{observe:["last_uplink","uplink"],onGet:function(){this.$bindLastUplink.text(this.model.uplinkDeviceText())}},".bind-state":{observe:"uplink",onGet:function(){this.populateStates()}},".bind-downlinks":{observe:"downlink_table",onGet:function(e){this.downlinksTable()}},".bind-ports":{observe:"port_table",onGet:function(e){this.portsTable(!0)}},".bind-power-consumption":{observe:"port_table",onGet:function(e){this.$bindPowerConsumption.text(this.model.power()+" "+c.G_Watt)}},".bind-temperature":{observe:"general_temperature",onGet:function(e){var t=parseInt(this.model.get("general_temperature"),10)||-1;this.$bindTemperature.empty(),t>0&&this.$bindTemperature.text(this.model.get("general_temperature")).append(c.G_DegreeCelsius)}},".bind-fan-level":{observe:"fan_level",onGet:function(e){this.$bindFanLevel.text(this.model.fan_level())}},".bind-network":{observe:"config_network",onGet:function(e){this.populateNetworkForm(this.$networkForm,e)}},".button-edit":{observe:["state","map_id","default","upgradable","locating"],onGet:function(){var e=this.model.get("state");1==e?this.$btnEdit.show():this.$btnEdit.hide(),e!==this.lastPortState&&(this.position(),this.lastPortState=e)}}})},initialize:function(t){switch(this.portConfCollection=t.parent.options.app.collection("PortConf"),this.model.get("model")){case"US8P150":this.diagramTemplate=o.template(g,{msg:c});break;case"US24":case"US24P250":case"US24P500":this.diagramTemplate=o.template(u,{msg:c});break;case"US48":case"US48P500":case"US48P750":this.diagramTemplate=o.template(h,{msg:c})}this.listenTo(this.portConfCollection,"add remove change",s.proxy(function(){this.networksVlanTable(),this.portsTable()},this)),e.prototype.initialize.call(this,t)},dependencies:function(){var e={PortConf:d,Networks:l},t=[],a={},n=this;o.each(e,function(e,n){t.push(a[n]=s.Deferred())},this),s.when.apply(s,t).then(function(){n._dependencies.resolve()},function(){n._dependencies.reject()}),o.each(e,function(e,t){this.options.parent.app.collection(t,{fetch:{reload:!1,deferred:a[t]}},e)},this)},render:function(t){var a=this.rendered;return e.prototype.render.call(this,t),a||(this.forms={},this.noDownlinksRows=this.$(".data-table-downlinks").html(),this.noPortsRows=this.$(".data-table-ports").html(),this.noNetworksVlanRows=this.$(".data-table-networks-vlan").html(),this.$advAdoptForm=this.$(".advAdoptForm"),this.$btnEdit=this.$(".button-edit"),this.$diagram=this.$(".diagram"),this.$portList=this.$(".port-list"),this.$portForm=this.$(".port-form"),this.$bindLastseen=this.$(".bind-lastseen"),this.$bindLastUplink=this.$(".bind-lastuplink"),this.$bindPowerConsumption=this.$(".bind-power-consumption"),this.$bindTemperature=this.$(".bind-temperature"),this.$bindFanLevel=this.$(".bind-fan-level"),this.$bindUplinkPort=this.$(".bind-uplink-port"),this.$bindUplinkDevice=this.$(".bind-uplink-device"),this.$bindUplinkSpeed=this.$(".bind-uplink-speed"),this.$bindUplinkDuplex=this.$(".bind-uplink-duplex"),this.$bindUplinkDownPackets=this.$(".bind-uplink-down-packets"),this.$bindUplinkUpPackets=this.$(".bind-uplink-up-packets"),this.$bindUplinkActivity=this.$(".bind-uplink-activity"),this.$uplinkDevice=this.$(".button-uplink-device"),this.$servicesForm=this.$(".servicesForm"),this.$networkForm=this.$(".networkForm"),this.$connectionType=this.$(".configure-ip"),this.$networksVlanCreate=this.$('.networks-vlan-config button[name="create"]'),this.$networksVlanList=this.$(".networks-vlan-list"),this.$networksVlanForm=this.$(".networks-vlan-form"),this.$advAdoptForm.on("submit",this.onAdvAdoptFormSubmit),this.$btnEdit.on("click",this.edit),this.$uplinkDevice.on("click",this.displayUplinkDevice),this.$servicesForm.on("submit",s.proxy(function(e){e.preventDefault(),this.updateServices()},this)),this.$networkForm.on("submit",s.proxy(function(e){e.preventDefault(),this.updateNetwork(this.$networkForm,"config_network")},this)),this.$connectionType.on("change",s.proxy(function(e){var t=s(e.target).val();this.$networkForm.find(".connection-toggled").hide().filter(".connection-"+t).show()},this)).trigger("change"),this.$networksVlanCreate.on("click",s.proxy(function(){this.networksVlanForm()},this)),this.$networksVlanForm.hide(),this.$portList.on("click","tr",s.proxy(function(e){var t,a=s(e.target).closest("tr");if(e.metaKey||e.ctrlKey){var n=a.closest("tr").find(".column-checkboxes input:not([disabled])");n.is(":checked");window.getSelection?window.getSelection().removeAllRanges():document.selection&&document.selection.empty(),n.trigger("click"),this.highlightPort(t,!1)}else"tbody"==a.parent().prop("tagName").toLowerCase()&&(t=a.attr("class").replace("port-","")),this.highlightPort(t)},this)),this.$diagram.on("click",".port",s.proxy(function(e){if(e.preventDefault(),!this.forms.Port){var t=s(e.target).closest(".port"),a=t.data("port");if(e.metaKey||e.ctrlKey){var n=this.$portList.find("tr.port-"+a).find(".column-checkboxes input:not([disabled])");n.trigger("click"),this.highlightPort(a,!1)}else this.highlightPort(a)}},this)),"resolved"===this._rendered.state()&&"resolved"===this._dependencies.state()?this.populate():"pending"===this._rendered.state()&&this._rendered.resolve(),this.adjustData&&this.adjustData(),this.stickit(this.model,this.bindings()),this.$tabs.on("change",s.proxy(function(e){this.toggleEditButton()},this)),this.toggleEditButton(),this.listenTo(this.app.collection("Networks"),"add remove",this.renderMgmtNetworks)),this.networksVlanTable(),this.portsTable(),this.renderMgmtNetworks(),a||this.detach(),this.options.options&&this.options.options.port&&this.highlightPort(this.options.options.port),this},renderMgmtNetworks:function(){var e=this.app.collection("Networks").filterByPurpose(["corporate","guest","voip","vlan-only"]),t=this.$("select[name=mgmt_network]"),a=this.model.get("networkgroup")||"LAN",n=o.find(e,function(e){return e.get("attr_no_delete")===!0&&e.get("networkgroup")===a})||e[0],i=this.model.get("mgmt_network_id")||n.id;t.empty(),o.each(e,function(e){t.append(s('<option value="'+e.id+'"></option>').text(e.get("name")))}),t.find('option[value="'+i+'"]').prop("selected",!0)},toggleEditButton:function(){1!==this.$tabs.tabs("option","active")||this.forms.Port?this.$tabs.find(".dialog-controls .button-edit").hide():this.$tabs.find(".dialog-controls .button-edit").show();var e=this.model.get("state");e!==this.lastPortState&&(this.position(),this.lastPortState=e)},edit:function(e){var t=s(e.target),a=t.hasClass("disabled"),n=this.$portList.find('.checkbox-cell input[type="checkbox"]:checked'),i=o.map(n,function(e){return e.id}),r=o.filter(this.model.collections.portTable.models,function(e){return-1!==i.indexOf(""+e.id)});!a&&n.length&&(this.portForm(r,null,!0),this.toggleEditButton())},args:function(){return{_id:this.id,diagram:this.diagramTemplate,msg:c}},adjustData:function(){},onAdvAdoptFormSubmit:function(e){e.preventDefault();var t=this,a=this.model,n=s(e.target).find("button");this.$advAdoptForm.find(".error").removeClass("error"),n.attr("disabled","disabled");var i=a.advanceAdopt({data:{ip:this.$advAdoptForm.find('input[name="ip"]').val(),port:this.$advAdoptForm.find('input[name="port"]').val(),username:this.$advAdoptForm.find('input[name="username"]').val(),password:this.$advAdoptForm.find('input[name="password"]').val(),url:this.$advAdoptForm.find('input[name="url"]').val()},success:function(e){"ok"===e.meta.rc?a.fetch({success:function(e,a,n){"ok"===a.