/*
  backgrid-select-all
  http://github.com/wyuenho/backgrid

  Copyright (c) 2013 Jimmy Yuen Ho Wong and contributors
  Licensed under the MIT @license.
*/

/*! http://mths.be/placeholder v2.0.7 by @mathias 
	Modified to work with Zepto.js by ZURB
*/

define("text!includes/wizard/WelcomeTemplate.html",[],function(){return'<h2><%- msg.Wizard.G_WelcomeMessage %></h2>\n<div class="row input">\n    <div class="large-12 columns">\n        <label for="country"><%- msg.Wizard.G_WelcomeSelectCountry %></label>\n        <span class="custom-dropdown custom-dropdown--white">\n            <select id="country" name="country" class="custom-dropdown__select custom-dropdown__select--white">\n                <% _(ccodes).each(function (ccode) {%><option value="<%= ccode.code %>"><%= ccode.name %></option><% }); %>\n            </select>\n        </span>\n    </div>\n    <div class="large-12 columns">\n        <label for="timezone"><%- msg.Wizard.G_WelcomeSelectTimezone %></label>\n        <span class="custom-dropdown custom-dropdown--white">\n            <select id="timezone" name="timezone" class="custom-dropdown__select custom-dropdown__select--white">\n                <%= timezoneOptionsTemplate() %>\n            </select>\n        </span>\n    </div>\n</div>\n<div class="row"><div class="large-12 columns">\n        <%- msg.Wizard.G_WelcomeRestoreLinkPrefix %> <a id="Backup" href="#Backup"><%- msg.Wizard.G_WelcomeRestoreLinkText %></a>.\n</div></div>\n<div class="row">\n    <div class="large-12 columns">\n        <input type="file" name="file" id="restoreFile"/>\n        <progress />\n    </div>\n</div>\n'}),define("unifi/view/wizard/WelcomeView",["underscore","backbone","msg/Msg","ubnt/view/dialogs/ConfirmDialogView","ubnt/view/dialogs/ErrorDialogView","ubnt/view/dialogs/WorkingDialogView","text!includes/wizard/WelcomeTemplate.html","text!includes/global/timezoneOptions.html","libs/fileupload"],function(e,t,i,s,n,a,o,r,l){"use strict";return t.View.extend({template:e.template(o),el:"#Step",events:{"click #Backup":"onBackup",'change [type="file"]':"onFileChange","change #country":"onCountryChange","change #language":"onLanguageChange","change #timezone":"onTimezoneChange"},initialize:function(t){this.options=t,e.bindAll(this,"onProgress","restore"),this.listenTo(this.model,"change:up",this.backupRestored)},render:function(){this.$el.html(this.template({ccodes:this.model.get("ccodes"),languages:[{name:"English (US)",code:"en_us"}],timezoneOptionsTemplate:e.template(r),msg:i}));var t=this.$("#timezone");if(!this.model.get("timezone")){var s=this.model.getTimezoneOffset();if(s){var n=t.find('option[title="'+s+'"]');n&&this.model.set("timezone",n.val())}}return this.$("#country").val(this.model.get("country")),this.$("#language").val(this.model.get("language")),t.val(this.model.get("timezone")).change(),this.$progress=this.$("progress"),this.$file=this.$("#restoreFile"),this},onCountryChange:function(e){this.model.set("country",this.$(e.target).val())},onLanguageChange:function(e){this.model.set("language",this.$(e.target).val())},onTimezoneChange:function(e){this.model.set("timezone",this.$(e.target).val())},onBackup:function(e){e.preventDefault(),this.$file.show()},onFileChange:function(e){this.$progress.show(),this.$file.hide();var i=new l,s=i.upload(t.$("form"),{url:"/upload/backup"});s.progress(this.onProgress),s.done(this.restore),s.fail(this.restore)},onProgress:function(e){var t=this.$progress.get(0);this.$progress.val(e.loaded),e.total!==t.max&&(t.max=e.total)},restore:function(e,t,n){this.$progress.hide(),this.$file=this.$("#restoreFile").show();var a=this;return e=e.responseJSON,e&&e.meta&&"ok"==e.meta.rc?(e=e.meta,void(new s).show(i.localize(i.I_ConfirmRestore,e.filename,new Date(parseInt(e.timestamp,10))),function(){a.model.cmdRestore().done(function(e){"ok"===e.meta.rc?a.model.pollServer():alert("something went wrong:"+e.msg)})})):this.failedUpload(n,t,e)},backupRestored:function(e,t,s){return t?window.location.reload():(new a).open(i.Wizard.N_Restoring),this},failedUpload:function(e,t,s){var a,o=new n;a="api.err.InvalidBackupVersion"===s.meta.msg?i.localize(i.E_InvalidBackupVersion,s.meta.filename,s.meta.version):i.localize(i.E_InvalidBackup,s.meta.filename),o.open(a)}})}),define("text!includes/wizard/DiscoverTemplate.html",[],function(){return'<h2>\n    <%- msg.Wizard.G_DiscoverMessage %>\n</h2>\n<div class="row">\n    <div class="large-24 columns">\n        <div id="Devices" class="data-table untitled"></div>\n    </div>\n</div>\n<button id="Refresh" type="button" class="button secondary"><span class=ubnt-icon-refresh>   </span><%- msg.Wizard.G_Refresh %></button>\n'}),function(e){"object"==typeof exports?module.exports=e(require("backbone"),require("backgrid")):"undefined"!=typeof Backbone&&"undefined"!=typeof Backgrid&&e(Backbone,Backgrid)}(function(e,t){"use strict";var i=e.$,s=t.Extension.SelectRowCell=e.View.extend({className:"select-row-cell",tagName:"td",events:{"keydown :checkbox":"onKeydown","change :checkbox":"onChange","click :checkbox":"enterEditMode"},initialize:function(e){this.column=e.column,this.column instanceof t.Column||(this.column=new t.Column(this.column)),this.listenTo(this.model,"backgrid:select",function(e,t){this.$el.find(":checkbox").prop("checked",t).change()});var i=this.column,s=this.$el;this.listenTo(i,"change:renderable",function(e,t){s.toggleClass("renderable",t)}),i.get("renderable")&&s.addClass("renderable")},enterEditMode:function(){this.$el.find(":checkbox").focus()},exitEditMode:function(){this.$el.find(":checkbox").blur()},onKeydown:function(e){var i=new t.Command(e);return i.passThru()?!0:void(i.cancel()?(e.stopPropagation(),this.$el.find(":checkbox").blur()):(i.save()||i.moveLeft()||i.moveRight()||i.moveUp()||i.moveDown())&&(e.preventDefault(),e.stopPropagation(),this.model.trigger("backgrid:edited",this.model,this.column,i)))},onChange:function(e){var t=i(e.target).prop("checked");this.$el.parent().toggleClass("selected",t),this.model.trigger("backgrid:selected",this.model,t)},render:function(){return this.$el.empty().append('<input tabindex="-1" type="checkbox" />'),this.delegateEvents(),this}}),n=t.Extension.SelectAllHeaderCell=s.extend({className:"select-all-header-cell",tagName:"th",initialize:function(e){this.column=e.column,this.column instanceof t.Column||(this.column=new t.Column(this.column));var i=this.collection,s=this.selectedModels={};this.listenTo(i,"backgrid:selected",function(e,t){t?s[e.id||e.cid]=e:(delete s[e.id||e.cid],this.$el.find(":checkbox").prop("checked",!1))}),this.listenTo(i,"remove",function(e){delete s[e.id||e.cid]}),this.listenTo(i,"backgrid:refresh",function(){this.$el.find(":checkbox").prop("checked",!1);for(var e=0;e<i.length;e++){var t=i.at(e);s[t.id||t.cid]&&t.trigger("backgrid:select",t,!0)}});var n=this.column,a=this.$el;this.listenTo(n,"change:renderable",function(e,t){a.toggleClass("renderable",t)}),n.get("renderable")&&a.addClass("renderable")},onChange:function(e){var t=i(e.target).prop("checked"),s=this.collection;s.each(function(e){e.trigger("backgrid:select",e,t)}),s.trigger("backgrid:select-all",s,t)}});t.Grid.prototype.getSelectedModels=function(){for(var e,t=this.header.row.cells,i=0,s=t.length;s>i;i++){var a=t[i];if(a instanceof n){e=a;break}}var o=[],r=this.collection;if("fullCollection"in r&&(r=r.fullCollection),e)for(var l in e.selectedModels)o.push(r.get(l));return o}}),define("libs/backgrid-select-all",["libs/backgrid"],function(){}),define("unifi/view/wizard/SelectDevicesView",["jquery","underscore","backbone","libs/backgrid","ubnt/backgrid","msg/Msg","text!includes/wizard/WelcomeTemplate.html","libs/backgrid-select-all"],function(e,t,i,s,n,a,o){"use strict";var r=function(e){};return r.prototype=new s.NumberFormatter,t.extend(r.prototype,n.Formatters.Seconds),i.View.extend({el:"#Devices",template:t.template('<div class="error"><p class="message"><%= message %></p><p><%= instructions %></p>'),events:{"click .prev":"_onChangePage","click .next":"_onChangePage"},initialize:function(e,t){this.listenTo(this.collection,"add",this.sizeCheck),this.listenTo(this.collection,"remove",this.sizeCheck),this.listenTo(this.collection,"reset",this.sizeCheck)},sizeCheck:function(e,t,i){0===this.collection.length||0===this.grid._collection().length?(this.$("table.backgrid").hide(),this.$error.show()):(this.$("table.backgrid").show(),this.$error.hide())},render:function(){return this.$error=i.$(this.template({message:a.Wizard.E_NoDevicesMsg,instructions:a.Wizard.E_NoDevicesInstructions})),this.grid=new n.Grid({columns:this.columns,collection:this.collection,pageable:!0,footer:n.Paginators.Mini}),this.grid.setFilter("default",!0,1),this.grid.paginate(1,10),this.$el.html(this.grid.render().el),this._selectFix(),this.$el.append(this.$error),this.sizeCheck(),this},_onChangePage:function(){var i,s,n,a=this.grid.getSelectedModels(),o=this;t.delay(function(){o.$("tbody").find("tr").each(function(){i=e(this),n=i.find("td:eq(1)").text(),s=i.find("td:first").find("input"),t.find(a,function(e){return e.attributes.mac===n})?s.attr("checked","checked"):s.removeAttr("checked")})},200)},_selectFix:function(){var t=this.grid.header.row.cells[0];t.collection=this.collection,t.initialize({column:t.column});var i=this;return this.grid.body.$el.on("refresh",function(){i.collection.length&&i.collection.trigger("backgrid:refresh")}),t.$el.on("change",":checkbox",function(){var t=e(this).is(":checked");i.collection.each(function(e){e.trigger("backgrid:selected",e,t)})}),this.collection.selectedDevices=t.selectedModels,this},columns:[{name:"",headerCell:"select-all",cell:"select-row"},{name:"name",label:a.G_PropertiesMACAddress,sortable:!1,editable:!1,headerCell:n.Headers.noLinkHeader,cell:n.Cells.ModelCell.extend({callback:"name"})},{name:"version",label:a.G_Version,sortable:!1,editable:!1,headerCell:n.Headers.noLinkHeader,cell:"string"},{name:"ip",label:a.G_IPAddress,sortable:!1,editable:!1,headerCell:n.Headers.noLinkHeader,cell:"string"},{name:"uptime",label:a.G_Uptime,editable:!1,cell:s.IntegerCell.extend({formatter:r})}]})}),define("unifi/view/wizard/DiscoverView",["backbone","underscore","msg/Msg","text!includes/wizard/DiscoverTemplate.html","unifi/view/wizard/SelectDevicesView"],function(e,t,i,s,n){"use strict";return e.View.extend({template:t.template(s),events:{"click #Refresh":"onRefresh"},el:"#Step",render:function(){return this.$el.html(this.template({msg:i})),this.devicesView=new n({collection:this.model.get("devices")}),this.devicesView.render(),this},onRefresh:function(e){this.model.fetchDeviceStatus({type:"POST"})}})}),define("text!includes/wizard/WirelessTemplate.html",[],function(){return'<h2><%- msg.Wizard.G_WirelessMessage %></h2>\n<p><%- msg.Wizard.G_WirelessMessageSkip %></p>\n<div class="row">\n    <div class="large-9 columns">\n        <label for="SSID"><%- msg.Wizard.G_WirelessSecureSsid %></label>\n        <input id="SSID" name="SSID" type="text" value="<%- ssid %>" required pattern="(^([\\x20-\\x7E]){1,32}$)" title="<%- msg.Wizard.G_WirelessSecureSsidTitle %>"/>\n    </div>\n    <div class="large-9 columns large-offset-2">\n        <label for="SecurityKey"><%- msg.Wizard.G_WirelessSecurityKey %></label>\n        <input id="SecurityKey" name="SecurityKey" type="password" value="<%- securityKey %>" title="<%- msg.Wizard.G_WirelessSecurityKeyTitle %>" pattern="^([\\x20-\\x7E]){8,63}$" required/>\n    </div>\n    <div class="large-4 columns"></div>\n</div>\n<p><%- msg.Wizard.G_WirelessOptionMessage %></p>\n<div>\n    <input type="checkbox" name="Guest" id="Guest" value="true" <% if (guest) {%>checked<% } %> /> <label for="Guest"><%- msg.Wizard.G_WirelessEnableGuestAccess %></label>\n    <div class="row">\n        <div class="large-9 columns guest">\n            <label for="GuestSSID"><%- msg.Wizard.G_WirelessGuestSsid %></label>\n            <input id="GuestSSID" name="GuestSSID" type="text" value="<%- guest_ssid %>" required pattern="(^([\\x20-\\x7E]){1,32}$)" title="<%- msg.Wizard.G_WirelessSecureSsidTitle %>" <% if (guest) {%>disabled<% } %>/>\n        </div>\n    </div>\n</div>\n'}),define("unifi/view/wizard/WirelessView",["underscore","backbone","msg/Msg","text!includes/wizard/WirelessTemplate.html"],function(e,t,i,s){"use strict";return t.View.extend({events:{"change #Guest":"onGuestChange","change #SecurityKey":"onSecurityKeyChange","change #SSID":"onSSIDChange","change #GuestSSID":"onGuestSSIDChange"},template:e.template(s),el:"#Step",initialize:function(e){this.options=e,this.listenTo(this.model,"change:guest",this.showGuestSSID)},render:function(){return this.$el.html(this.template({securityKey:this.model.get("securityKey"),ssid:this.model.get("ssid"),guest:this.model.get("guest"),guest_ssid:this.model.get("guest_ssid"),msg:i})),this.showGuestSSID(this.model,this.model.get("guest")),this},onSSIDChange:function(e){this.model.set({ssid:e.target.value})},onSecurityKeyChange:function(e){this.model.set({securityKey:e.target.value})},onGuestChange:function(e){this.model.set({guest:e.target.checked})},onGuestSSIDChange:function(e){this.model.set({guest_ssid:e.target.value})},showGuestSSID:function(e,t,i){return t?(this.$(".guest").show(),this.$("#GuestSSID").get(0).disabled=!1):(this.$("#GuestSSID").get(0).disabled=!0,this.$(".guest").hide()),this}})}),define("text!includes/wizard/PasswordTemplate.html",[],function(){return'<h2><%- msg.Wizard.G_PasswordMessage %></h2>\n<div class="row">\n    <div class="large-9 columns">\n        <label for="admin"><%- msg.Wizard.G_PasswordAdminName %></label>\n        <input id="admin" name="admin" type="text" value="<%- admin %>" pattern="^[_A-Za-z0-9][-_.A-Za-z0-9]*$" title="<%- msg.Wizard.G_PasswordAdminNameTitle %>" required/>\n    </div>\n</div>\n<div class="row">\n    <div class="large-9 columns">\n        <label for="password"><%- msg.Wizard.G_Password %></label>\n        <input id="password" name="password" type="password" value="<%- password %>" required title=""/>\n    </div>\n    <div class="large-9 columns large-offset-2">\n        <label for="password"><%- msg.Wizard.G_ConfirmPassword %></label>\n        <input id="password-confirm" name="password-confirm" type="password" value="<%- passwordConfirm %>" required/>\n    </div>\n    <div class="large-4 columns"></div>\n</div>\n'}),define("unifi/view/wizard/PasswordView",["underscore","backbone","msg/Msg","text!includes/wizard/PasswordTemplate.html"],function(e,t,i,s){"use strict";return t.View.extend({events:{"change #password":"onPasswordChange","change #password-confirm":"onPasswordChangeConfirm","change #admin":"onAdminChange","keyup #password-confirm":"onPasswordChangeConfirm"},template:e.template(s),el:"#Step",initialize:function(e){this.options=e,this.listenTo(this.model,"invalid",this.setInvalid)},render:function(){return this.$el.html(this.template({password:this.model.get("password"),passwordConfirm:this.model.get("password-confirm"),admin:this.model.get("admin"),msg:i})),this.passwordConfirm=this.el.querySelector("#password-confirm"),this.$passwordConfirm=t.$(this.passwordConfirm),this},setInvalid:function(e,t){return"passwords do not match"===t&&(this.passwordConfirm.setCustomValidity("Passwords do not match"),this.$passwordConfirm.addClass("error")),this},setValid:function(e){this.passwordConfirm.setCustomValidity(""),this.$passwordConfirm.removeClass("error")},onPasswordChange:function(e){this.model.set("password",this.$el.find("#password").val()),this.model.isValid()&&this.setValid()},onPasswordChangeConfirm:function(e){this.onPasswordChange(),this.onAdminChange(),this.passwordConfirm.setCustomValidity(""),this.$passwordConfirm.removeClass("error"),this.model.set("password-confirm",this.$el.find("#password-confirm").val()),this.model.isValid()},onAdminChange:function(e){this.model.set("admin",this.$el.find("#admin").val())}})}),define("text!includes/wizard/FinishTemplate.html",[],function(){return'<h2><%- msg.Wizard.G_FinishMessage %></h2>\n<div class="row">\n    <div class="large-12 columns">\n        <label><%- msg.Wizard.G_PasswordAdminName %></label>\n    </div>\n</div>\n<div class="row">\n    <div class="large-12 columns">\n        <span><%- admin %></span>\n    </div>\n</div>\n'}),define("unifi/view/wizard/FinishView",["underscore","backbone","msg/Msg","text!includes/wizard/FinishTemplate.html"],function(e,t,i,s){"use strict";return t.View.extend({template:e.template(s),el:"#Step",render:function(){return this.$el.html(this.template({admin:this.model.get("admin"),ssid:this.model.get("ssid")||i.Wizard.N_NoSSID,msg:i})),this}})}),define("text!includes/wizard/ProgressTemplate.html",[],function(){return'<ol>\n    <li class="welcome in-progress">\n        <button type=button name=step value=welcome>1</button>\n        <a href="#welcome"><%- msg.Wizard.G_Welcome %></a>\n    </li>\n    <li class="discover">\n        <button type=button name=step value=discover>2</button>\n        <div class="connection"></div>\n        <a href="#discover"><%- msg.Wizard.G_Discover %></a>\n    </li>\n    <li class="password">\n        <button type=button name=step value=password>3</button>\n        <div class="connection"></div>\n        <a href="#password"><%- msg.Wizard.G_Password %></a>\n    </li>\n    <li class="finish">\n        <button type=button name=step value=finish>4</button>\n        <div class="connection"></div>\n        <a href="#finish"><%- msg.Wizard.G_Finish %></a>\n    </li>\n</ol>\n'}),define("unifi/view/wizard/ProgressView",["backbone","underscore","msg/Msg","text!includes/wizard/ProgressTemplate.html"],function(e,t,i,s){"use strict";return e.View.extend({template:t.template(s),el:"#Progress",initialize:function(e){this.listenTo(this.model,"change:step",this.showStep)},render:function(){return this.$el.html(this.template({msg:i})),this},showStep:function(e,t){return this.$("."+t).prevAll().removeClass("in-progress").addClass("complete"),this.$("."+t).removeClass("complete").addClass("in-progress"),this.$("."+t+" ~ li").removeClass("complete in-progress"),this},setStep:function(t){t.preventDefault();var i=e.$(t.target),s=i.val();s||(s=i.attr("href").slice(1)),this.model.set("step",s)}})}),function(e,t,i){function s(e){var t={},s=/^jQuery\d+$/;return i.each(e.attributes,function(e,i){i.specified&&!s.test(i.name)&&(t[i.name]=i.value)}),t}function n(e,s){var n=this,a=i(n);if(n.value==a.attr("placeholder")&&a.hasClass("placeholder"))if(a.data("placeholder-password")){if(a=a.hide().next().show().attr("id",a.removeAttr("id").data("placeholder-id")),e===!0)return a[0].value=s;a.focus()}else n.value="",a.removeClass("placeholder"),n==t.activeElement&&n.select()}function a(){var e,t=this,a=i(t),o=this.id;if(""==t.value){if("password"==t.type){if(!a.data("placeholder-textinput")){try{e=a.clone().attr({type:"text"})}catch(r){e=i("<input>").attr(i.extend(s(this),{type:"text"}))}e.removeAttr("name").data({"placeholder-password":!0,"placeholder-id":o}).bind("focus.placeholder",n),a.data({"placeholder-textinput":e,"placeholder-id":o}).before(e)}a=a.removeAttr("id").hide().prev().attr("id",o).show()}a.addClass("placeholder"),a[0].value=a.attr("placeholder")}else a.removeClass("placeholder")}var o,r,l="placeholder"in t.createElement("input"),d="placeholder"in t.createElement("textarea"),c=i.fn,u=i.valHooks;l&&d?(r=c.placeholder=function(){return this},r.input=r.textarea=!0):(r=c.placeholder=function(){var e=this;return e.filter((l?"textarea":":input")+"[placeholder]").not(".placeholder").bind({"focus.placeholder":n,"blur.placeholder":a}).data("placeholder-enabled",!0).trigger("blur.placeholder"),e},r.input=l,r.textarea=d,o={get:function(e){var t=i(e);return t.data("placeholder-enabled")&&t.hasClass("placeholder")?"":e.value},set:function(e,s){var o=i(e);return o.data("placeholder-enabled")?(""==s?(e.value=s,e!=t.activeElement&&a.call(e)):o.hasClass("placeholder")?n.call(e,!0,s)||(e.value=s):e.value=s,o):e.value=s}},l||(u.input=o),d||(u.textarea=o),i(function(){i(t).delegate("form","submit.placeholder",function(){var e=i(".placeholder",this).each(n);setTimeout(function(){e.each(a)},10)})}),i(e).bind("beforeunload.placeholder",function(){i(".placeholder").each(function(){this.value=""})}))}(this,document,Foundation.zj),define("foundation.placeholder",["foundation"],function(){}),define("unifi/view/wizard/ChromeView",["jquery","backbone","msg/Msg","unifi/service/location/locationService","unifi/view/wizard/WelcomeView","unifi/view/wizard/DiscoverView","unifi/view/wizard/WirelessView","unifi/view/wizard/PasswordView","unifi/view/wizard/FinishView","unifi/view/wizard/ProgressView","foundation.placeholder"],function(e,t,i,s,n,a,o,r,l,d){"use strict";return t.View.extend({events:{"submit form":"onNext","click #Skip":"onSkip","click #Back":"onBack","click #Finish":"onFinish"},el:"#Wizard",initialize:function(){this.localize(),this.listenTo(this.model,"change:step",this.renderStep),this.listenTo(this.model,"invalid",this.invalid)},localize:function(){var t=e(this.el).find("form");t.find("> h1").first().text(i.Wizard.G_UniFiSetupWizardTitle),t.find(".buttons > div > #Back").text(i.Wizard.G_Back),t.find(".buttons > div > #Skip").text(i.Wizard.G_Skip),t.find(".buttons > div > #Next").text(i.Wizard.G_Next),t.find(".buttons > div > #Finish").text(i.Wizard.G_Finish);var s=e("body > #Wrapper > #Modal > .modal-background");s.find("> h1").text(i.E_WontWork),s.find("> p").text(i.E_WontWorkDetail)},onNext:function(e){e.preventDefault();var t=this.model.get("step"),i={v:{}};switch(t){case"wireless":i.v={ssid:!0,securityKey:!0,guest_ssid:!0};break;case"password":i.v={password:!0,admin:!0}}this.el.querySelector("form").checkValidity()&&this.model.isValid(i)&&this.model.step()},onSkip:function(e){this.model.resetStep(this.model.get("step")),this.model.step()},onBack:function(e){this.model.stepBack()},onFinish:function(e){e.preventDefault(),this.model.save({},{success:function(){s.replaceWithLoginPage()}})},render:function(){e("#Main").removeClass("loading");var t=new d({model:this.model});return t.render(),this.renderStep(this.model,this.model.get("step"))},renderStep:function(e,t,i){i=i||{};var s,d,c=!0;switch(t){case"discover":s=a;break;case"wireless":s=o,c=!1;break;case"password":s=r;break;case"finish":s=l;break;default:s=n}return i.model=e,d=new s(i),d.render(),c?this.$el.addClass("required"):this.$el.removeClass("required"),this.model.steps[t].p?this.$el.removeClass("first"):this.$el.addClass("first"),this.model.steps[t].n?this.$el.removeClass("last"):this.$el.addClass("last"),this},invalid:function(e,t,i){"finish"===e.get("step")&&alert(t)}})}),define("unifi/model/WizardModel",["underscore","backbone","unifi/service/location/locationService","unifi/collection/Devices","msg/Msg"],function(e,t,i,s,n){"use strict";return t.Model.extend({idAttribute:"_id",urlRoot:"/api/",defaults:{step:"welcome",country:840,language:"en_us",timezone:"",guest:!1,ssid:"",guest_ssid:"",securityKey:"",admin:"",up:!0},steps:{welcome:{p:!1,n:"discover"},discover:{p:"welcome",n:"password"},password:{p:"discover",n:"finish"},finish:{p:"password",n:!1}},validate:function(e,t){t=t||{};var i=t.v||{password:!0,ssid:!0,guest_ssid:!0,securityKey:!0,admin:!0};if(i.password&&!e.password)return n.Wizard.E_PasswordRequired;if(i.password&&e.password!==e["password-confirm"])return n.Wizard.E_PasswordsDontMatch;if(e.ssid){if(i.ssid&&!/^([\x20-\x7E]){1,32}$/.test(e.ssid))return n.Wizard.E_SsidAlphanumeric;if(i.guest_ssid&&e.guest&&!/^([\x20-\x7E]){1,32}$/.test(e.ssid))return n.Wizard.E_SsidAlphanumeric;if(i.securityKey&&!/(^([\x20-\x7E]){8,63}$)/.test(e.securityKey))return n.Wizard.E_SsidPasswordLength}return i.admin&&!/^[_.A-Za-z0-9][-\@_.A-Za-z0-9]*\$?$/.test(e.admin)?n.Wizard.E_AdminNameAlphanumeric:void 0},step:function(){return this.set({step:this.steps[this.get("step")].n})},stepBack:function(){return this.set({step:this.steps[this.get("step")].p})},resetStep:function(e){switch(e){case"wireless":this.unset("ssid"),this.unset("securityKey"),this.unset("guest"),this.unset("guest_ssid")}},set:function(i,s,n){var a=s,o=n;return"object"==typeof i?a=e.defaults({},s,{validate:!1}):o=e.defaults({},n,{validate:!1}),t.Model.prototype.set.call(this,i,s,n)},getTimezoneOffset:function(){var e,t=new Date,i=new Date(t.getFullYear(),0,1),s=new Date(t.getFullYear(),6,1),n=Math.max(i.getTimezoneOffset(),s.getTimezoneOffset()),a=t.getTimezoneOffset()<n,o=t.toString().match(/GMT([-|+]\d{2})/);return o&&o.length>1&&(e=parseInt(o[1],10),a&&(e-=1)),e},fetchSysInfo:function(i){var s=this;return i.url="/api/stat/sysinfo",i.data={json:JSON.stringify({})},i.success=function(t){s.set({ccodes:e.map(t.data[0].ccodes,function(t){return e.pick(t,"code","name")})})},t.ajax(i)},fetchDeviceStatus:function(e){return this.get("devices")||this.set({devices:new s}),this.get("devices").discover()},fetch:function(i){i=i?e.clone(i):{},void 0===i.parse&&(i.parse=!0);var s=this,n=i.success;return i=e.defaults(i,{type:"POST"}),t.$.when(this.fetchSysInfo(i),this.fetchDeviceStatus(i)).then(function(e,t,a){n&&n(s,null,i),s.trigger("sync",s,null,i)})},_saveSetting:function(e){return e.data={json:JSON.stringify(e.data)},e.success=!1,e.type="POST",t.ajax(e)},cmdSiteMgr:function(){var e={};return e.url="/api/cmd/sitemgr",e.data={name:this.get("admin"),lang:this.get("language"),timezone:this.get("timezone"),x_password:this.get("password"),cmd:"add-default-admin"},this._saveSetting(e)},addWlanConf:function(){if(!this.get("ssid"))return!0;var e={};e.url="/api/add/wlanconf",e.data={wlangroup_id:this.get("id"),enabled:!0,name:this.get("ssid"),security:"wpapsk",wpa_mode:"wpa2",wpa_enc:"ccmp",x_passphrase:this.get("securityKey")};var t={url:"/api/add/wlanconf",data:{wlangroup_id:this.get("id"),is_guest:!0,enabled:!0,name:this.get("guest_ssid"),security:"open"}},i=this._saveSetting(e),s=this;return this.get("guest")?i.then(function(){return s._saveSetting(t)}):i},cmdAdopt:function(){var i={};i.url="/api/cmd/devmgr";var s=new t.Collection(e.values(this.get("devices").selectedDevices));return i.data={cmd:"adopt",macs:s.pluck("mac")},this._saveSetting(i)},setCountry:function(){var e={};return e.url="/api/set/setting/country",e.data={code:parseInt(this.get("country"),10)},this._saveSetting(e)},setTimezone:function(){var e={};return e.url="/api/set/setting/locale",e.data={timezone:this.get("timezone")},this._saveSetting(e)},cmdInstalled:function(){var e={};return e.url="/api/cmd/system",e.data={cmd:"set-installed"},this._saveSetting(e)},cmdRestore:function(){this.set("up",!1);var e={};return e.url="/api/s/default/cmd/system",e.data={cmd:"restore"},this._saveSetting(e)},pollServer:function(){var e=this;t.$.getJSON("/status").done(function(t){"ok"===t.meta.rc&&t.meta.up?e.set("up",t.meta.up):window.setTimeout(function(){e.pollServer()},1500)}).fail(function(t,i,s){window.setTimeout(function(){e.pollServer()},1500)})},initialize:function(t){e.bindAll(this,"cmdInstalled","cmdAdopt","cmdSiteMgr","setCountry","setTimezone","addWlanConf")},sync:function(e){var t=e.success,s=this;return this.cmdSiteMgr(e).then(this.addWlanConf).then(this.cmdAdopt).then(this.setCountry).then(this.setTimezone).then(this.cmdInstalled).done(function(){t?t(s,null,e):i.gotoLoginPage()})}})}),define("wizard",["jquery","backbone","unifi/view/wizard/ChromeView","unifi/model/WizardModel","foundation"],function(e,t,i,s){"use strict";e(function(){e(document).foundation();var t=new s,n=new i({model:t});t.fetch({wait:!0}).done(function(){n.render()})})});